<?php

namespace OpenEMR\FHIR\R4;

/*!
 * This class was generated with the PHPFHIR library (https://github.com/dcarbone/php-fhir) using
 * class definitions from HL7 FHIR (https://www.hl7.org/fhir/)
 *
 * Class creation date: June 14th, 2019
 *
 * PHPFHIR Copyright:
 *
 * Copyright 2016-2017 Daniel Carbone (daniel.p.carbone@gmail.com)
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *        http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 */

class PHPFHIRAutoloader
{
    const ROOT_DIR = __DIR__;

    /** @var array */
    private static $_classMap = array (
    'OpenEMR\\FHIR\\R4\\PHPFHIRParserMap' => 'OpenEMR/FHIR/R4/PHPFHIRParserMap.php',
    'OpenEMR\\FHIR\\R4\\PHPFHIRHelper' => 'OpenEMR/FHIR/R4/PHPFHIRHelper.php',
    'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRDate' => 'OpenEMR/FHIR/R4/FHIRElement/FHIRDate.php',
    'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRDateTime' => 'OpenEMR/FHIR/R4/FHIRElement/FHIRDateTime.php',
    'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRCode' => 'OpenEMR/FHIR/R4/FHIRElement/FHIRCode.php',
    'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRString' => 'OpenEMR/FHIR/R4/FHIRElement/FHIRString.php',
    'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRInteger' => 'OpenEMR/FHIR/R4/FHIRElement/FHIRInteger.php',
    'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIROid' => 'OpenEMR/FHIR/R4/FHIRElement/FHIROid.php',
    'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRCanonical' => 'OpenEMR/FHIR/R4/FHIRElement/FHIRCanonical.php',
    'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRUri' => 'OpenEMR/FHIR/R4/FHIRElement/FHIRUri.php',
    'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRUuid' => 'OpenEMR/FHIR/R4/FHIRElement/FHIRUuid.php',
    'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRUrl' => 'OpenEMR/FHIR/R4/FHIRElement/FHIRUrl.php',
    'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRInstant' => 'OpenEMR/FHIR/R4/FHIRElement/FHIRInstant.php',
    'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRBoolean' => 'OpenEMR/FHIR/R4/FHIRElement/FHIRBoolean.php',
    'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRBase64Binary' => 'OpenEMR/FHIR/R4/FHIRElement/FHIRBase64Binary.php',
    'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRUnsignedInt' => 'OpenEMR/FHIR/R4/FHIRElement/FHIRUnsignedInt.php',
    'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRMarkdown' => 'OpenEMR/FHIR/R4/FHIRElement/FHIRMarkdown.php',
    'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRTime' => 'OpenEMR/FHIR/R4/FHIRElement/FHIRTime.php',
    'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRId' => 'OpenEMR/FHIR/R4/FHIRElement/FHIRId.php',
    'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRPositiveInt' => 'OpenEMR/FHIR/R4/FHIRElement/FHIRPositiveInt.php',
    'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRDecimal' => 'OpenEMR/FHIR/R4/FHIRElement/FHIRDecimal.php',
    'OpenEMR\\FHIR\\R4\\FHIRResourceContainer' => 'OpenEMR/FHIR/R4/FHIRResourceContainer.php',
    'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRExtension' => 'OpenEMR/FHIR/R4/FHIRElement/FHIRExtension.php',
    'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRBackboneElement' => 'OpenEMR/FHIR/R4/FHIRElement/FHIRBackboneElement.php',
    'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRNarrative' => 'OpenEMR/FHIR/R4/FHIRElement/FHIRNarrative.php',
    'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRNarrativeStatus' => 'OpenEMR/FHIR/R4/FHIRElement/FHIRNarrativeStatus.php',
    'OpenEMR\\FHIR\\R4\\FHIRElement' => 'OpenEMR/FHIR/R4/FHIRElement.php',
    'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRMeta' => 'OpenEMR/FHIR/R4/FHIRElement/FHIRMeta.php',
    'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRAddress' => 'OpenEMR/FHIR/R4/FHIRElement/FHIRAddress.php',
    'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRAddressUse' => 'OpenEMR/FHIR/R4/FHIRElement/FHIRAddressUse.php',
    'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRAddressType' => 'OpenEMR/FHIR/R4/FHIRElement/FHIRAddressType.php',
    'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRContributor' => 'OpenEMR/FHIR/R4/FHIRElement/FHIRContributor.php',
    'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRContributorType' => 'OpenEMR/FHIR/R4/FHIRElement/FHIRContributorType.php',
    'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRAttachment' => 'OpenEMR/FHIR/R4/FHIRElement/FHIRAttachment.php',
    'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRQuantity\\FHIRCount' => 'OpenEMR/FHIR/R4/FHIRElement/FHIRQuantity/FHIRCount.php',
    'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRDataRequirement' => 'OpenEMR/FHIR/R4/FHIRElement/FHIRDataRequirement.php',
    'OpenEMR\\FHIR\\R4\\FHIRResource\\FHIRDataRequirement\\FHIRDataRequirementCodeFilter' => 'OpenEMR/FHIR/R4/FHIRResource/FHIRDataRequirement/FHIRDataRequirementCodeFilter.php',
    'OpenEMR\\FHIR\\R4\\FHIRResource\\FHIRDataRequirement\\FHIRDataRequirementDateFilter' => 'OpenEMR/FHIR/R4/FHIRResource/FHIRDataRequirement/FHIRDataRequirementDateFilter.php',
    'OpenEMR\\FHIR\\R4\\FHIRResource\\FHIRDataRequirement\\FHIRDataRequirementSort' => 'OpenEMR/FHIR/R4/FHIRResource/FHIRDataRequirement/FHIRDataRequirementSort.php',
    'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRSortDirection' => 'OpenEMR/FHIR/R4/FHIRElement/FHIRSortDirection.php',
    'OpenEMR\\FHIR\\R4\\FHIRResource\\FHIRDosage' => 'OpenEMR/FHIR/R4/FHIRResource/FHIRDosage.php',
    'OpenEMR\\FHIR\\R4\\FHIRResource\\FHIRDosage\\FHIRDosageDoseAndRate' => 'OpenEMR/FHIR/R4/FHIRResource/FHIRDosage/FHIRDosageDoseAndRate.php',
    'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRMoney' => 'OpenEMR/FHIR/R4/FHIRElement/FHIRMoney.php',
    'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRHumanName' => 'OpenEMR/FHIR/R4/FHIRElement/FHIRHumanName.php',
    'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRNameUse' => 'OpenEMR/FHIR/R4/FHIRElement/FHIRNameUse.php',
    'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRContactPoint' => 'OpenEMR/FHIR/R4/FHIRElement/FHIRContactPoint.php',
    'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRContactPointSystem' => 'OpenEMR/FHIR/R4/FHIRElement/FHIRContactPointSystem.php',
    'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRContactPointUse' => 'OpenEMR/FHIR/R4/FHIRElement/FHIRContactPointUse.php',
    'OpenEMR\\FHIR\\R4\\FHIRResource\\FHIRMarketingStatus' => 'OpenEMR/FHIR/R4/FHIRResource/FHIRMarketingStatus.php',
    'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRIdentifier' => 'OpenEMR/FHIR/R4/FHIRElement/FHIRIdentifier.php',
    'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRIdentifierUse' => 'OpenEMR/FHIR/R4/FHIRElement/FHIRIdentifierUse.php',
    'OpenEMR\\FHIR\\R4\\FHIRResource\\FHIRSubstanceAmount' => 'OpenEMR/FHIR/R4/FHIRResource/FHIRSubstanceAmount.php',
    'OpenEMR\\FHIR\\R4\\FHIRResource\\FHIRSubstanceAmount\\FHIRSubstanceAmountReferenceRange' => 'OpenEMR/FHIR/R4/FHIRResource/FHIRSubstanceAmount/FHIRSubstanceAmountReferenceRange.php',
    'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRCoding' => 'OpenEMR/FHIR/R4/FHIRElement/FHIRCoding.php',
    'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRSampledData' => 'OpenEMR/FHIR/R4/FHIRElement/FHIRSampledData.php',
    'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRSampledDataDataType' => 'OpenEMR/FHIR/R4/FHIRElement/FHIRSampledDataDataType.php',
    'OpenEMR\\FHIR\\R4\\FHIRResource\\FHIRPopulation' => 'OpenEMR/FHIR/R4/FHIRResource/FHIRPopulation.php',
    'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRRatio' => 'OpenEMR/FHIR/R4/FHIRElement/FHIRRatio.php',
    'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRQuantity\\FHIRDistance' => 'OpenEMR/FHIR/R4/FHIRElement/FHIRQuantity/FHIRDistance.php',
    'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRQuantity\\FHIRAge' => 'OpenEMR/FHIR/R4/FHIRElement/FHIRQuantity/FHIRAge.php',
    'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRReference' => 'OpenEMR/FHIR/R4/FHIRElement/FHIRReference.php',
    'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRTriggerDefinition' => 'OpenEMR/FHIR/R4/FHIRElement/FHIRTriggerDefinition.php',
    'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRTriggerType' => 'OpenEMR/FHIR/R4/FHIRElement/FHIRTriggerType.php',
    'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRQuantity' => 'OpenEMR/FHIR/R4/FHIRElement/FHIRQuantity.php',
    'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRQuantityComparator' => 'OpenEMR/FHIR/R4/FHIRElement/FHIRQuantityComparator.php',
    'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRPeriod' => 'OpenEMR/FHIR/R4/FHIRElement/FHIRPeriod.php',
    'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRQuantity\\FHIRDuration' => 'OpenEMR/FHIR/R4/FHIRElement/FHIRQuantity/FHIRDuration.php',
    'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRRange' => 'OpenEMR/FHIR/R4/FHIRElement/FHIRRange.php',
    'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRRelatedArtifact' => 'OpenEMR/FHIR/R4/FHIRElement/FHIRRelatedArtifact.php',
    'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRRelatedArtifactType' => 'OpenEMR/FHIR/R4/FHIRElement/FHIRRelatedArtifactType.php',
    'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRAnnotation' => 'OpenEMR/FHIR/R4/FHIRElement/FHIRAnnotation.php',
    'OpenEMR\\FHIR\\R4\\FHIRResource\\FHIRProductShelfLife' => 'OpenEMR/FHIR/R4/FHIRResource/FHIRProductShelfLife.php',
    'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRContactDetail' => 'OpenEMR/FHIR/R4/FHIRElement/FHIRContactDetail.php',
    'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRUsageContext' => 'OpenEMR/FHIR/R4/FHIRElement/FHIRUsageContext.php',
    'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRExpression' => 'OpenEMR/FHIR/R4/FHIRElement/FHIRExpression.php',
    'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRExpressionLanguage' => 'OpenEMR/FHIR/R4/FHIRElement/FHIRExpressionLanguage.php',
    'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRSignature' => 'OpenEMR/FHIR/R4/FHIRElement/FHIRSignature.php',
    'OpenEMR\\FHIR\\R4\\FHIRResource\\FHIRTiming' => 'OpenEMR/FHIR/R4/FHIRResource/FHIRTiming.php',
    'OpenEMR\\FHIR\\R4\\FHIRResource\\FHIRTiming\\FHIRTimingRepeat' => 'OpenEMR/FHIR/R4/FHIRResource/FHIRTiming/FHIRTimingRepeat.php',
    'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRUnitsOfTime' => 'OpenEMR/FHIR/R4/FHIRElement/FHIRUnitsOfTime.php',
    'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIREventTiming' => 'OpenEMR/FHIR/R4/FHIRElement/FHIREventTiming.php',
    'OpenEMR\\FHIR\\R4\\FHIRResource\\FHIRProdCharacteristic' => 'OpenEMR/FHIR/R4/FHIRResource/FHIRProdCharacteristic.php',
    'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRCodeableConcept' => 'OpenEMR/FHIR/R4/FHIRElement/FHIRCodeableConcept.php',
    'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRParameterDefinition' => 'OpenEMR/FHIR/R4/FHIRElement/FHIRParameterDefinition.php',
    'OpenEMR\\FHIR\\R4\\FHIRResource\\FHIRElementDefinition' => 'OpenEMR/FHIR/R4/FHIRResource/FHIRElementDefinition.php',
    'OpenEMR\\FHIR\\R4\\FHIRResource\\FHIRElementDefinition\\FHIRElementDefinitionConstraint' => 'OpenEMR/FHIR/R4/FHIRResource/FHIRElementDefinition/FHIRElementDefinitionConstraint.php',
    'OpenEMR\\FHIR\\R4\\FHIRResource\\FHIRElementDefinition\\FHIRElementDefinitionMapping' => 'OpenEMR/FHIR/R4/FHIRResource/FHIRElementDefinition/FHIRElementDefinitionMapping.php',
    'OpenEMR\\FHIR\\R4\\FHIRResource\\FHIRElementDefinition\\FHIRElementDefinitionBase' => 'OpenEMR/FHIR/R4/FHIRResource/FHIRElementDefinition/FHIRElementDefinitionBase.php',
    'OpenEMR\\FHIR\\R4\\FHIRResource\\FHIRElementDefinition\\FHIRElementDefinitionType' => 'OpenEMR/FHIR/R4/FHIRResource/FHIRElementDefinition/FHIRElementDefinitionType.php',
    'OpenEMR\\FHIR\\R4\\FHIRResource\\FHIRElementDefinition\\FHIRElementDefinitionExample' => 'OpenEMR/FHIR/R4/FHIRResource/FHIRElementDefinition/FHIRElementDefinitionExample.php',
    'OpenEMR\\FHIR\\R4\\FHIRResource\\FHIRElementDefinition\\FHIRElementDefinitionSlicing' => 'OpenEMR/FHIR/R4/FHIRResource/FHIRElementDefinition/FHIRElementDefinitionSlicing.php',
    'OpenEMR\\FHIR\\R4\\FHIRResource\\FHIRElementDefinition\\FHIRElementDefinitionBinding' => 'OpenEMR/FHIR/R4/FHIRResource/FHIRElementDefinition/FHIRElementDefinitionBinding.php',
    'OpenEMR\\FHIR\\R4\\FHIRResource\\FHIRElementDefinition\\FHIRElementDefinitionDiscriminator' => 'OpenEMR/FHIR/R4/FHIRResource/FHIRElementDefinition/FHIRElementDefinitionDiscriminator.php',
    'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRPropertyRepresentation' => 'OpenEMR/FHIR/R4/FHIRElement/FHIRPropertyRepresentation.php',
    'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRConstraintSeverity' => 'OpenEMR/FHIR/R4/FHIRElement/FHIRConstraintSeverity.php',
    'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRAggregationMode' => 'OpenEMR/FHIR/R4/FHIRElement/FHIRAggregationMode.php',
    'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRReferenceVersionRules' => 'OpenEMR/FHIR/R4/FHIRElement/FHIRReferenceVersionRules.php',
    'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRSlicingRules' => 'OpenEMR/FHIR/R4/FHIRElement/FHIRSlicingRules.php',
    'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRBindingStrength' => 'OpenEMR/FHIR/R4/FHIRElement/FHIRBindingStrength.php',
    'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRDiscriminatorType' => 'OpenEMR/FHIR/R4/FHIRElement/FHIRDiscriminatorType.php',
    'OpenEMR\\FHIR\\R4\\FHIRResource\\FHIRDomainResource' => 'OpenEMR/FHIR/R4/FHIRResource/FHIRDomainResource.php',
    'OpenEMR\\FHIR\\R4\\FHIRResource' => 'OpenEMR/FHIR/R4/FHIRResource.php',
    'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRPublicationStatus' => 'OpenEMR/FHIR/R4/FHIRElement/FHIRPublicationStatus.php',
    'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRSearchParamType' => 'OpenEMR/FHIR/R4/FHIRElement/FHIRSearchParamType.php',
    'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRAdministrativeGender' => 'OpenEMR/FHIR/R4/FHIRElement/FHIRAdministrativeGender.php',
    'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRFHIRVersion' => 'OpenEMR/FHIR/R4/FHIRElement/FHIRFHIRVersion.php',
    'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRNoteType' => 'OpenEMR/FHIR/R4/FHIRElement/FHIRNoteType.php',
    'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRRemittanceOutcome' => 'OpenEMR/FHIR/R4/FHIRElement/FHIRRemittanceOutcome.php',
    'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRConceptMapEquivalence' => 'OpenEMR/FHIR/R4/FHIRElement/FHIRConceptMapEquivalence.php',
    'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRDocumentReferenceStatus' => 'OpenEMR/FHIR/R4/FHIRElement/FHIRDocumentReferenceStatus.php',
    'OpenEMR\\FHIR\\R4\\FHIRDomainResource\\FHIRAccount' => 'OpenEMR/FHIR/R4/FHIRDomainResource/FHIRAccount.php',
    'OpenEMR\\FHIR\\R4\\FHIRResource\\FHIRAccount\\FHIRAccountCoverage' => 'OpenEMR/FHIR/R4/FHIRResource/FHIRAccount/FHIRAccountCoverage.php',
    'OpenEMR\\FHIR\\R4\\FHIRResource\\FHIRAccount\\FHIRAccountGuarantor' => 'OpenEMR/FHIR/R4/FHIRResource/FHIRAccount/FHIRAccountGuarantor.php',
    'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRAccountStatus' => 'OpenEMR/FHIR/R4/FHIRElement/FHIRAccountStatus.php',
    'OpenEMR\\FHIR\\R4\\FHIRDomainResource\\FHIRActivityDefinition' => 'OpenEMR/FHIR/R4/FHIRDomainResource/FHIRActivityDefinition.php',
    'OpenEMR\\FHIR\\R4\\FHIRResource\\FHIRActivityDefinition\\FHIRActivityDefinitionParticipant' => 'OpenEMR/FHIR/R4/FHIRResource/FHIRActivityDefinition/FHIRActivityDefinitionParticipant.php',
    'OpenEMR\\FHIR\\R4\\FHIRResource\\FHIRActivityDefinition\\FHIRActivityDefinitionDynamicValue' => 'OpenEMR/FHIR/R4/FHIRResource/FHIRActivityDefinition/FHIRActivityDefinitionDynamicValue.php',
    'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRActionParticipantType' => 'OpenEMR/FHIR/R4/FHIRElement/FHIRActionParticipantType.php',
    'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRRequestIntent' => 'OpenEMR/FHIR/R4/FHIRElement/FHIRRequestIntent.php',
    'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRRequestResourceType' => 'OpenEMR/FHIR/R4/FHIRElement/FHIRRequestResourceType.php',
    'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRRequestPriority' => 'OpenEMR/FHIR/R4/FHIRElement/FHIRRequestPriority.php',
    'OpenEMR\\FHIR\\R4\\FHIRDomainResource\\FHIRAdverseEvent' => 'OpenEMR/FHIR/R4/FHIRDomainResource/FHIRAdverseEvent.php',
    'OpenEMR\\FHIR\\R4\\FHIRResource\\FHIRAdverseEvent\\FHIRAdverseEventSuspectEntity' => 'OpenEMR/FHIR/R4/FHIRResource/FHIRAdverseEvent/FHIRAdverseEventSuspectEntity.php',
    'OpenEMR\\FHIR\\R4\\FHIRResource\\FHIRAdverseEvent\\FHIRAdverseEventCausality' => 'OpenEMR/FHIR/R4/FHIRResource/FHIRAdverseEvent/FHIRAdverseEventCausality.php',
    'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRAdverseEventActuality' => 'OpenEMR/FHIR/R4/FHIRElement/FHIRAdverseEventActuality.php',
    'OpenEMR\\FHIR\\R4\\FHIRDomainResource\\FHIRAllergyIntolerance' => 'OpenEMR/FHIR/R4/FHIRDomainResource/FHIRAllergyIntolerance.php',
    'OpenEMR\\FHIR\\R4\\FHIRResource\\FHIRAllergyIntolerance\\FHIRAllergyIntoleranceReaction' => 'OpenEMR/FHIR/R4/FHIRResource/FHIRAllergyIntolerance/FHIRAllergyIntoleranceReaction.php',
    'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRAllergyIntoleranceCriticality' => 'OpenEMR/FHIR/R4/FHIRElement/FHIRAllergyIntoleranceCriticality.php',
    'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRAllergyIntoleranceType' => 'OpenEMR/FHIR/R4/FHIRElement/FHIRAllergyIntoleranceType.php',
    'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRAllergyIntoleranceCategory' => 'OpenEMR/FHIR/R4/FHIRElement/FHIRAllergyIntoleranceCategory.php',
    'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRAllergyIntoleranceSeverity' => 'OpenEMR/FHIR/R4/FHIRElement/FHIRAllergyIntoleranceSeverity.php',
    'OpenEMR\\FHIR\\R4\\FHIRDomainResource\\FHIRAppointment' => 'OpenEMR/FHIR/R4/FHIRDomainResource/FHIRAppointment.php',
    'OpenEMR\\FHIR\\R4\\FHIRResource\\FHIRAppointment\\FHIRAppointmentParticipant' => 'OpenEMR/FHIR/R4/FHIRResource/FHIRAppointment/FHIRAppointmentParticipant.php',
    'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRParticipantRequired' => 'OpenEMR/FHIR/R4/FHIRElement/FHIRParticipantRequired.php',
    'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRAppointmentStatus' => 'OpenEMR/FHIR/R4/FHIRElement/FHIRAppointmentStatus.php',
    'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRParticipationStatus' => 'OpenEMR/FHIR/R4/FHIRElement/FHIRParticipationStatus.php',
    'OpenEMR\\FHIR\\R4\\FHIRDomainResource\\FHIRAppointmentResponse' => 'OpenEMR/FHIR/R4/FHIRDomainResource/FHIRAppointmentResponse.php',
    'OpenEMR\\FHIR\\R4\\FHIRDomainResource\\FHIRAuditEvent' => 'OpenEMR/FHIR/R4/FHIRDomainResource/FHIRAuditEvent.php',
    'OpenEMR\\FHIR\\R4\\FHIRResource\\FHIRAuditEvent\\FHIRAuditEventAgent' => 'OpenEMR/FHIR/R4/FHIRResource/FHIRAuditEvent/FHIRAuditEventAgent.php',
    'OpenEMR\\FHIR\\R4\\FHIRResource\\FHIRAuditEvent\\FHIRAuditEventNetwork' => 'OpenEMR/FHIR/R4/FHIRResource/FHIRAuditEvent/FHIRAuditEventNetwork.php',
    'OpenEMR\\FHIR\\R4\\FHIRResource\\FHIRAuditEvent\\FHIRAuditEventSource' => 'OpenEMR/FHIR/R4/FHIRResource/FHIRAuditEvent/FHIRAuditEventSource.php',
    'OpenEMR\\FHIR\\R4\\FHIRResource\\FHIRAuditEvent\\FHIRAuditEventEntity' => 'OpenEMR/FHIR/R4/FHIRResource/FHIRAuditEvent/FHIRAuditEventEntity.php',
    'OpenEMR\\FHIR\\R4\\FHIRResource\\FHIRAuditEvent\\FHIRAuditEventDetail' => 'OpenEMR/FHIR/R4/FHIRResource/FHIRAuditEvent/FHIRAuditEventDetail.php',
    'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRAuditEventOutcome' => 'OpenEMR/FHIR/R4/FHIRElement/FHIRAuditEventOutcome.php',
    'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRAuditEventAction' => 'OpenEMR/FHIR/R4/FHIRElement/FHIRAuditEventAction.php',
    'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRAuditEventAgentNetworkType' => 'OpenEMR/FHIR/R4/FHIRElement/FHIRAuditEventAgentNetworkType.php',
    'OpenEMR\\FHIR\\R4\\FHIRDomainResource\\FHIRBasic' => 'OpenEMR/FHIR/R4/FHIRDomainResource/FHIRBasic.php',
    'OpenEMR\\FHIR\\R4\\FHIRResource\\FHIRBinary' => 'OpenEMR/FHIR/R4/FHIRResource/FHIRBinary.php',
    'OpenEMR\\FHIR\\R4\\FHIRDomainResource\\FHIRBiologicallyDerivedProduct' => 'OpenEMR/FHIR/R4/FHIRDomainResource/FHIRBiologicallyDerivedProduct.php',
    'OpenEMR\\FHIR\\R4\\FHIRResource\\FHIRBiologicallyDerivedProduct\\FHIRBiologicallyDerivedProductCollection' => 'OpenEMR/FHIR/R4/FHIRResource/FHIRBiologicallyDerivedProduct/FHIRBiologicallyDerivedProductCollection.php',
    'OpenEMR\\FHIR\\R4\\FHIRResource\\FHIRBiologicallyDerivedProduct\\FHIRBiologicallyDerivedProductProcessing' => 'OpenEMR/FHIR/R4/FHIRResource/FHIRBiologicallyDerivedProduct/FHIRBiologicallyDerivedProductProcessing.php',
    'OpenEMR\\FHIR\\R4\\FHIRResource\\FHIRBiologicallyDerivedProduct\\FHIRBiologicallyDerivedProductManipulation' => 'OpenEMR/FHIR/R4/FHIRResource/FHIRBiologicallyDerivedProduct/FHIRBiologicallyDerivedProductManipulation.php',
    'OpenEMR\\FHIR\\R4\\FHIRResource\\FHIRBiologicallyDerivedProduct\\FHIRBiologicallyDerivedProductStorage' => 'OpenEMR/FHIR/R4/FHIRResource/FHIRBiologicallyDerivedProduct/FHIRBiologicallyDerivedProductStorage.php',
    'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRBiologicallyDerivedProductCategory' => 'OpenEMR/FHIR/R4/FHIRElement/FHIRBiologicallyDerivedProductCategory.php',
    'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRBiologicallyDerivedProductStatus' => 'OpenEMR/FHIR/R4/FHIRElement/FHIRBiologicallyDerivedProductStatus.php',
    'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRBiologicallyDerivedProductStorageScale' => 'OpenEMR/FHIR/R4/FHIRElement/FHIRBiologicallyDerivedProductStorageScale.php',
    'OpenEMR\\FHIR\\R4\\FHIRDomainResource\\FHIRBodyStructure' => 'OpenEMR/FHIR/R4/FHIRDomainResource/FHIRBodyStructure.php',
    'OpenEMR\\FHIR\\R4\\FHIRResource\\FHIRBundle' => 'OpenEMR/FHIR/R4/FHIRResource/FHIRBundle.php',
    'OpenEMR\\FHIR\\R4\\FHIRResource\\FHIRBundle\\FHIRBundleLink' => 'OpenEMR/FHIR/R4/FHIRResource/FHIRBundle/FHIRBundleLink.php',
    'OpenEMR\\FHIR\\R4\\FHIRResource\\FHIRBundle\\FHIRBundleEntry' => 'OpenEMR/FHIR/R4/FHIRResource/FHIRBundle/FHIRBundleEntry.php',
    'OpenEMR\\FHIR\\R4\\FHIRResource\\FHIRBundle\\FHIRBundleSearch' => 'OpenEMR/FHIR/R4/FHIRResource/FHIRBundle/FHIRBundleSearch.php',
    'OpenEMR\\FHIR\\R4\\FHIRResource\\FHIRBundle\\FHIRBundleRequest' => 'OpenEMR/FHIR/R4/FHIRResource/FHIRBundle/FHIRBundleRequest.php',
    'OpenEMR\\FHIR\\R4\\FHIRResource\\FHIRBundle\\FHIRBundleResponse' => 'OpenEMR/FHIR/R4/FHIRResource/FHIRBundle/FHIRBundleResponse.php',
    'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRHTTPVerb' => 'OpenEMR/FHIR/R4/FHIRElement/FHIRHTTPVerb.php',
    'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRBundleType' => 'OpenEMR/FHIR/R4/FHIRElement/FHIRBundleType.php',
    'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRSearchEntryMode' => 'OpenEMR/FHIR/R4/FHIRElement/FHIRSearchEntryMode.php',
    'OpenEMR\\FHIR\\R4\\FHIRDomainResource\\FHIRCapabilityStatement' => 'OpenEMR/FHIR/R4/FHIRDomainResource/FHIRCapabilityStatement.php',
    'OpenEMR\\FHIR\\R4\\FHIRResource\\FHIRCapabilityStatement\\FHIRCapabilityStatementSoftware' => 'OpenEMR/FHIR/R4/FHIRResource/FHIRCapabilityStatement/FHIRCapabilityStatementSoftware.php',
    'OpenEMR\\FHIR\\R4\\FHIRResource\\FHIRCapabilityStatement\\FHIRCapabilityStatementImplementation' => 'OpenEMR/FHIR/R4/FHIRResource/FHIRCapabilityStatement/FHIRCapabilityStatementImplementation.php',
    'OpenEMR\\FHIR\\R4\\FHIRResource\\FHIRCapabilityStatement\\FHIRCapabilityStatementRest' => 'OpenEMR/FHIR/R4/FHIRResource/FHIRCapabilityStatement/FHIRCapabilityStatementRest.php',
    'OpenEMR\\FHIR\\R4\\FHIRResource\\FHIRCapabilityStatement\\FHIRCapabilityStatementSecurity' => 'OpenEMR/FHIR/R4/FHIRResource/FHIRCapabilityStatement/FHIRCapabilityStatementSecurity.php',
    'OpenEMR\\FHIR\\R4\\FHIRResource\\FHIRCapabilityStatement\\FHIRCapabilityStatementResource' => 'OpenEMR/FHIR/R4/FHIRResource/FHIRCapabilityStatement/FHIRCapabilityStatementResource.php',
    'OpenEMR\\FHIR\\R4\\FHIRResource\\FHIRCapabilityStatement\\FHIRCapabilityStatementInteraction' => 'OpenEMR/FHIR/R4/FHIRResource/FHIRCapabilityStatement/FHIRCapabilityStatementInteraction.php',
    'OpenEMR\\FHIR\\R4\\FHIRResource\\FHIRCapabilityStatement\\FHIRCapabilityStatementSearchParam' => 'OpenEMR/FHIR/R4/FHIRResource/FHIRCapabilityStatement/FHIRCapabilityStatementSearchParam.php',
    'OpenEMR\\FHIR\\R4\\FHIRResource\\FHIRCapabilityStatement\\FHIRCapabilityStatementOperation' => 'OpenEMR/FHIR/R4/FHIRResource/FHIRCapabilityStatement/FHIRCapabilityStatementOperation.php',
    'OpenEMR\\FHIR\\R4\\FHIRResource\\FHIRCapabilityStatement\\FHIRCapabilityStatementInteraction1' => 'OpenEMR/FHIR/R4/FHIRResource/FHIRCapabilityStatement/FHIRCapabilityStatementInteraction1.php',
    'OpenEMR\\FHIR\\R4\\FHIRResource\\FHIRCapabilityStatement\\FHIRCapabilityStatementMessaging' => 'OpenEMR/FHIR/R4/FHIRResource/FHIRCapabilityStatement/FHIRCapabilityStatementMessaging.php',
    'OpenEMR\\FHIR\\R4\\FHIRResource\\FHIRCapabilityStatement\\FHIRCapabilityStatementEndpoint' => 'OpenEMR/FHIR/R4/FHIRResource/FHIRCapabilityStatement/FHIRCapabilityStatementEndpoint.php',
    'OpenEMR\\FHIR\\R4\\FHIRResource\\FHIRCapabilityStatement\\FHIRCapabilityStatementSupportedMessage' => 'OpenEMR/FHIR/R4/FHIRResource/FHIRCapabilityStatement/FHIRCapabilityStatementSupportedMessage.php',
    'OpenEMR\\FHIR\\R4\\FHIRResource\\FHIRCapabilityStatement\\FHIRCapabilityStatementDocument' => 'OpenEMR/FHIR/R4/FHIRResource/FHIRCapabilityStatement/FHIRCapabilityStatementDocument.php',
    'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRCapabilityStatementKind' => 'OpenEMR/FHIR/R4/FHIRElement/FHIRCapabilityStatementKind.php',
    'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIREventCapabilityMode' => 'OpenEMR/FHIR/R4/FHIRElement/FHIREventCapabilityMode.php',
    'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRResourceVersionPolicy' => 'OpenEMR/FHIR/R4/FHIRElement/FHIRResourceVersionPolicy.php',
    'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRDocumentMode' => 'OpenEMR/FHIR/R4/FHIRElement/FHIRDocumentMode.php',
    'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRRestfulCapabilityMode' => 'OpenEMR/FHIR/R4/FHIRElement/FHIRRestfulCapabilityMode.php',
    'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRTypeRestfulInteraction' => 'OpenEMR/FHIR/R4/FHIRElement/FHIRTypeRestfulInteraction.php',
    'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRSystemRestfulInteraction' => 'OpenEMR/FHIR/R4/FHIRElement/FHIRSystemRestfulInteraction.php',
    'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRConditionalReadStatus' => 'OpenEMR/FHIR/R4/FHIRElement/FHIRConditionalReadStatus.php',
    'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRReferenceHandlingPolicy' => 'OpenEMR/FHIR/R4/FHIRElement/FHIRReferenceHandlingPolicy.php',
    'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRConditionalDeleteStatus' => 'OpenEMR/FHIR/R4/FHIRElement/FHIRConditionalDeleteStatus.php',
    'OpenEMR\\FHIR\\R4\\FHIRDomainResource\\FHIRCarePlan' => 'OpenEMR/FHIR/R4/FHIRDomainResource/FHIRCarePlan.php',
    'OpenEMR\\FHIR\\R4\\FHIRResource\\FHIRCarePlan\\FHIRCarePlanActivity' => 'OpenEMR/FHIR/R4/FHIRResource/FHIRCarePlan/FHIRCarePlanActivity.php',
    'OpenEMR\\FHIR\\R4\\FHIRResource\\FHIRCarePlan\\FHIRCarePlanDetail' => 'OpenEMR/FHIR/R4/FHIRResource/FHIRCarePlan/FHIRCarePlanDetail.php',
    'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRCarePlanActivityKind' => 'OpenEMR/FHIR/R4/FHIRElement/FHIRCarePlanActivityKind.php',
    'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRCarePlanActivityStatus' => 'OpenEMR/FHIR/R4/FHIRElement/FHIRCarePlanActivityStatus.php',
    'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRCarePlanIntent' => 'OpenEMR/FHIR/R4/FHIRElement/FHIRCarePlanIntent.php',
    'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRRequestStatus' => 'OpenEMR/FHIR/R4/FHIRElement/FHIRRequestStatus.php',
    'OpenEMR\\FHIR\\R4\\FHIRDomainResource\\FHIRCareTeam' => 'OpenEMR/FHIR/R4/FHIRDomainResource/FHIRCareTeam.php',
    'OpenEMR\\FHIR\\R4\\FHIRResource\\FHIRCareTeam\\FHIRCareTeamParticipant' => 'OpenEMR/FHIR/R4/FHIRResource/FHIRCareTeam/FHIRCareTeamParticipant.php',
    'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRCareTeamStatus' => 'OpenEMR/FHIR/R4/FHIRElement/FHIRCareTeamStatus.php',
    'OpenEMR\\FHIR\\R4\\FHIRDomainResource\\FHIRCatalogEntry' => 'OpenEMR/FHIR/R4/FHIRDomainResource/FHIRCatalogEntry.php',
    'OpenEMR\\FHIR\\R4\\FHIRResource\\FHIRCatalogEntry\\FHIRCatalogEntryRelatedEntry' => 'OpenEMR/FHIR/R4/FHIRResource/FHIRCatalogEntry/FHIRCatalogEntryRelatedEntry.php',
    'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRCatalogEntryRelationType' => 'OpenEMR/FHIR/R4/FHIRElement/FHIRCatalogEntryRelationType.php',
    'OpenEMR\\FHIR\\R4\\FHIRDomainResource\\FHIRChargeItem' => 'OpenEMR/FHIR/R4/FHIRDomainResource/FHIRChargeItem.php',
    'OpenEMR\\FHIR\\R4\\FHIRResource\\FHIRChargeItem\\FHIRChargeItemPerformer' => 'OpenEMR/FHIR/R4/FHIRResource/FHIRChargeItem/FHIRChargeItemPerformer.php',
    'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRChargeItemStatus' => 'OpenEMR/FHIR/R4/FHIRElement/FHIRChargeItemStatus.php',
    'OpenEMR\\FHIR\\R4\\FHIRDomainResource\\FHIRChargeItemDefinition' => 'OpenEMR/FHIR/R4/FHIRDomainResource/FHIRChargeItemDefinition.php',
    'OpenEMR\\FHIR\\R4\\FHIRResource\\FHIRChargeItemDefinition\\FHIRChargeItemDefinitionApplicability' => 'OpenEMR/FHIR/R4/FHIRResource/FHIRChargeItemDefinition/FHIRChargeItemDefinitionApplicability.php',
    'OpenEMR\\FHIR\\R4\\FHIRResource\\FHIRChargeItemDefinition\\FHIRChargeItemDefinitionPropertyGroup' => 'OpenEMR/FHIR/R4/FHIRResource/FHIRChargeItemDefinition/FHIRChargeItemDefinitionPropertyGroup.php',
    'OpenEMR\\FHIR\\R4\\FHIRResource\\FHIRChargeItemDefinition\\FHIRChargeItemDefinitionPriceComponent' => 'OpenEMR/FHIR/R4/FHIRResource/FHIRChargeItemDefinition/FHIRChargeItemDefinitionPriceComponent.php',
    'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRInvoicePriceComponentType' => 'OpenEMR/FHIR/R4/FHIRElement/FHIRInvoicePriceComponentType.php',
    'OpenEMR\\FHIR\\R4\\FHIRDomainResource\\FHIRClaim' => 'OpenEMR/FHIR/R4/FHIRDomainResource/FHIRClaim.php',
    'OpenEMR\\FHIR\\R4\\FHIRResource\\FHIRClaim\\FHIRClaimRelated' => 'OpenEMR/FHIR/R4/FHIRResource/FHIRClaim/FHIRClaimRelated.php',
    'OpenEMR\\FHIR\\R4\\FHIRResource\\FHIRClaim\\FHIRClaimPayee' => 'OpenEMR/FHIR/R4/FHIRResource/FHIRClaim/FHIRClaimPayee.php',
    'OpenEMR\\FHIR\\R4\\FHIRResource\\FHIRClaim\\FHIRClaimCareTeam' => 'OpenEMR/FHIR/R4/FHIRResource/FHIRClaim/FHIRClaimCareTeam.php',
    'OpenEMR\\FHIR\\R4\\FHIRResource\\FHIRClaim\\FHIRClaimSupportingInfo' => 'OpenEMR/FHIR/R4/FHIRResource/FHIRClaim/FHIRClaimSupportingInfo.php',
    'OpenEMR\\FHIR\\R4\\FHIRResource\\FHIRClaim\\FHIRClaimDiagnosis' => 'OpenEMR/FHIR/R4/FHIRResource/FHIRClaim/FHIRClaimDiagnosis.php',
    'OpenEMR\\FHIR\\R4\\FHIRResource\\FHIRClaim\\FHIRClaimProcedure' => 'OpenEMR/FHIR/R4/FHIRResource/FHIRClaim/FHIRClaimProcedure.php',
    'OpenEMR\\FHIR\\R4\\FHIRResource\\FHIRClaim\\FHIRClaimInsurance' => 'OpenEMR/FHIR/R4/FHIRResource/FHIRClaim/FHIRClaimInsurance.php',
    'OpenEMR\\FHIR\\R4\\FHIRResource\\FHIRClaim\\FHIRClaimAccident' => 'OpenEMR/FHIR/R4/FHIRResource/FHIRClaim/FHIRClaimAccident.php',
    'OpenEMR\\FHIR\\R4\\FHIRResource\\FHIRClaim\\FHIRClaimItem' => 'OpenEMR/FHIR/R4/FHIRResource/FHIRClaim/FHIRClaimItem.php',
    'OpenEMR\\FHIR\\R4\\FHIRResource\\FHIRClaim\\FHIRClaimDetail' => 'OpenEMR/FHIR/R4/FHIRResource/FHIRClaim/FHIRClaimDetail.php',
    'OpenEMR\\FHIR\\R4\\FHIRResource\\FHIRClaim\\FHIRClaimSubDetail' => 'OpenEMR/FHIR/R4/FHIRResource/FHIRClaim/FHIRClaimSubDetail.php',
    'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRUse' => 'OpenEMR/FHIR/R4/FHIRElement/FHIRUse.php',
    'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRFinancialResourceStatusCodes' => 'OpenEMR/FHIR/R4/FHIRElement/FHIRFinancialResourceStatusCodes.php',
    'OpenEMR\\FHIR\\R4\\FHIRDomainResource\\FHIRClaimResponse' => 'OpenEMR/FHIR/R4/FHIRDomainResource/FHIRClaimResponse.php',
    'OpenEMR\\FHIR\\R4\\FHIRResource\\FHIRClaimResponse\\FHIRClaimResponseItem' => 'OpenEMR/FHIR/R4/FHIRResource/FHIRClaimResponse/FHIRClaimResponseItem.php',
    'OpenEMR\\FHIR\\R4\\FHIRResource\\FHIRClaimResponse\\FHIRClaimResponseAdjudication' => 'OpenEMR/FHIR/R4/FHIRResource/FHIRClaimResponse/FHIRClaimResponseAdjudication.php',
    'OpenEMR\\FHIR\\R4\\FHIRResource\\FHIRClaimResponse\\FHIRClaimResponseDetail' => 'OpenEMR/FHIR/R4/FHIRResource/FHIRClaimResponse/FHIRClaimResponseDetail.php',
    'OpenEMR\\FHIR\\R4\\FHIRResource\\FHIRClaimResponse\\FHIRClaimResponseSubDetail' => 'OpenEMR/FHIR/R4/FHIRResource/FHIRClaimResponse/FHIRClaimResponseSubDetail.php',
    'OpenEMR\\FHIR\\R4\\FHIRResource\\FHIRClaimResponse\\FHIRClaimResponseAddItem' => 'OpenEMR/FHIR/R4/FHIRResource/FHIRClaimResponse/FHIRClaimResponseAddItem.php',
    'OpenEMR\\FHIR\\R4\\FHIRResource\\FHIRClaimResponse\\FHIRClaimResponseDetail1' => 'OpenEMR/FHIR/R4/FHIRResource/FHIRClaimResponse/FHIRClaimResponseDetail1.php',
    'OpenEMR\\FHIR\\R4\\FHIRResource\\FHIRClaimResponse\\FHIRClaimResponseSubDetail1' => 'OpenEMR/FHIR/R4/FHIRResource/FHIRClaimResponse/FHIRClaimResponseSubDetail1.php',
    'OpenEMR\\FHIR\\R4\\FHIRResource\\FHIRClaimResponse\\FHIRClaimResponseTotal' => 'OpenEMR/FHIR/R4/FHIRResource/FHIRClaimResponse/FHIRClaimResponseTotal.php',
    'OpenEMR\\FHIR\\R4\\FHIRResource\\FHIRClaimResponse\\FHIRClaimResponsePayment' => 'OpenEMR/FHIR/R4/FHIRResource/FHIRClaimResponse/FHIRClaimResponsePayment.php',
    'OpenEMR\\FHIR\\R4\\FHIRResource\\FHIRClaimResponse\\FHIRClaimResponseProcessNote' => 'OpenEMR/FHIR/R4/FHIRResource/FHIRClaimResponse/FHIRClaimResponseProcessNote.php',
    'OpenEMR\\FHIR\\R4\\FHIRResource\\FHIRClaimResponse\\FHIRClaimResponseInsurance' => 'OpenEMR/FHIR/R4/FHIRResource/FHIRClaimResponse/FHIRClaimResponseInsurance.php',
    'OpenEMR\\FHIR\\R4\\FHIRResource\\FHIRClaimResponse\\FHIRClaimResponseError' => 'OpenEMR/FHIR/R4/FHIRResource/FHIRClaimResponse/FHIRClaimResponseError.php',
    'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRClaimProcessingCodes' => 'OpenEMR/FHIR/R4/FHIRElement/FHIRClaimProcessingCodes.php',
    'OpenEMR\\FHIR\\R4\\FHIRDomainResource\\FHIRClinicalImpression' => 'OpenEMR/FHIR/R4/FHIRDomainResource/FHIRClinicalImpression.php',
    'OpenEMR\\FHIR\\R4\\FHIRResource\\FHIRClinicalImpression\\FHIRClinicalImpressionInvestigation' => 'OpenEMR/FHIR/R4/FHIRResource/FHIRClinicalImpression/FHIRClinicalImpressionInvestigation.php',
    'OpenEMR\\FHIR\\R4\\FHIRResource\\FHIRClinicalImpression\\FHIRClinicalImpressionFinding' => 'OpenEMR/FHIR/R4/FHIRResource/FHIRClinicalImpression/FHIRClinicalImpressionFinding.php',
    'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRClinicalImpressionStatus' => 'OpenEMR/FHIR/R4/FHIRElement/FHIRClinicalImpressionStatus.php',
    'OpenEMR\\FHIR\\R4\\FHIRDomainResource\\FHIRCodeSystem' => 'OpenEMR/FHIR/R4/FHIRDomainResource/FHIRCodeSystem.php',
    'OpenEMR\\FHIR\\R4\\FHIRResource\\FHIRCodeSystem\\FHIRCodeSystemFilter' => 'OpenEMR/FHIR/R4/FHIRResource/FHIRCodeSystem/FHIRCodeSystemFilter.php',
    'OpenEMR\\FHIR\\R4\\FHIRResource\\FHIRCodeSystem\\FHIRCodeSystemProperty' => 'OpenEMR/FHIR/R4/FHIRResource/FHIRCodeSystem/FHIRCodeSystemProperty.php',
    'OpenEMR\\FHIR\\R4\\FHIRResource\\FHIRCodeSystem\\FHIRCodeSystemConcept' => 'OpenEMR/FHIR/R4/FHIRResource/FHIRCodeSystem/FHIRCodeSystemConcept.php',
    'OpenEMR\\FHIR\\R4\\FHIRResource\\FHIRCodeSystem\\FHIRCodeSystemDesignation' => 'OpenEMR/FHIR/R4/FHIRResource/FHIRCodeSystem/FHIRCodeSystemDesignation.php',
    'OpenEMR\\FHIR\\R4\\FHIRResource\\FHIRCodeSystem\\FHIRCodeSystemProperty1' => 'OpenEMR/FHIR/R4/FHIRResource/FHIRCodeSystem/FHIRCodeSystemProperty1.php',
    'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRFilterOperator' => 'OpenEMR/FHIR/R4/FHIRElement/FHIRFilterOperator.php',
    'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRPropertyType' => 'OpenEMR/FHIR/R4/FHIRElement/FHIRPropertyType.php',
    'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRCodeSystemHierarchyMeaning' => 'OpenEMR/FHIR/R4/FHIRElement/FHIRCodeSystemHierarchyMeaning.php',
    'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRCodeSystemContentMode' => 'OpenEMR/FHIR/R4/FHIRElement/FHIRCodeSystemContentMode.php',
    'OpenEMR\\FHIR\\R4\\FHIRDomainResource\\FHIRCommunication' => 'OpenEMR/FHIR/R4/FHIRDomainResource/FHIRCommunication.php',
    'OpenEMR\\FHIR\\R4\\FHIRResource\\FHIRCommunication\\FHIRCommunicationPayload' => 'OpenEMR/FHIR/R4/FHIRResource/FHIRCommunication/FHIRCommunicationPayload.php',
    'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIREventStatus' => 'OpenEMR/FHIR/R4/FHIRElement/FHIREventStatus.php',
    'OpenEMR\\FHIR\\R4\\FHIRDomainResource\\FHIRCommunicationRequest' => 'OpenEMR/FHIR/R4/FHIRDomainResource/FHIRCommunicationRequest.php',
    'OpenEMR\\FHIR\\R4\\FHIRResource\\FHIRCommunicationRequest\\FHIRCommunicationRequestPayload' => 'OpenEMR/FHIR/R4/FHIRResource/FHIRCommunicationRequest/FHIRCommunicationRequestPayload.php',
    'OpenEMR\\FHIR\\R4\\FHIRDomainResource\\FHIRCompartmentDefinition' => 'OpenEMR/FHIR/R4/FHIRDomainResource/FHIRCompartmentDefinition.php',
    'OpenEMR\\FHIR\\R4\\FHIRResource\\FHIRCompartmentDefinition\\FHIRCompartmentDefinitionResource' => 'OpenEMR/FHIR/R4/FHIRResource/FHIRCompartmentDefinition/FHIRCompartmentDefinitionResource.php',
    'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRCompartmentType' => 'OpenEMR/FHIR/R4/FHIRElement/FHIRCompartmentType.php',
    'OpenEMR\\FHIR\\R4\\FHIRDomainResource\\FHIRComposition' => 'OpenEMR/FHIR/R4/FHIRDomainResource/FHIRComposition.php',
    'OpenEMR\\FHIR\\R4\\FHIRResource\\FHIRComposition\\FHIRCompositionAttester' => 'OpenEMR/FHIR/R4/FHIRResource/FHIRComposition/FHIRCompositionAttester.php',
    'OpenEMR\\FHIR\\R4\\FHIRResource\\FHIRComposition\\FHIRCompositionRelatesTo' => 'OpenEMR/FHIR/R4/FHIRResource/FHIRComposition/FHIRCompositionRelatesTo.php',
    'OpenEMR\\FHIR\\R4\\FHIRResource\\FHIRComposition\\FHIRCompositionEvent' => 'OpenEMR/FHIR/R4/FHIRResource/FHIRComposition/FHIRCompositionEvent.php',
    'OpenEMR\\FHIR\\R4\\FHIRResource\\FHIRComposition\\FHIRCompositionSection' => 'OpenEMR/FHIR/R4/FHIRResource/FHIRComposition/FHIRCompositionSection.php',
    'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRVConfidentialityClassification' => 'OpenEMR/FHIR/R4/FHIRElement/FHIRVConfidentialityClassification.php',
    'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRCompositionStatus' => 'OpenEMR/FHIR/R4/FHIRElement/FHIRCompositionStatus.php',
    'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRDocumentRelationshipType' => 'OpenEMR/FHIR/R4/FHIRElement/FHIRDocumentRelationshipType.php',
    'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRCompositionAttestationMode' => 'OpenEMR/FHIR/R4/FHIRElement/FHIRCompositionAttestationMode.php',
    'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRListMode' => 'OpenEMR/FHIR/R4/FHIRElement/FHIRListMode.php',
    'OpenEMR\\FHIR\\R4\\FHIRDomainResource\\FHIRConceptMap' => 'OpenEMR/FHIR/R4/FHIRDomainResource/FHIRConceptMap.php',
    'OpenEMR\\FHIR\\R4\\FHIRResource\\FHIRConceptMap\\FHIRConceptMapGroup' => 'OpenEMR/FHIR/R4/FHIRResource/FHIRConceptMap/FHIRConceptMapGroup.php',
    'OpenEMR\\FHIR\\R4\\FHIRResource\\FHIRConceptMap\\FHIRConceptMapElement' => 'OpenEMR/FHIR/R4/FHIRResource/FHIRConceptMap/FHIRConceptMapElement.php',
    'OpenEMR\\FHIR\\R4\\FHIRResource\\FHIRConceptMap\\FHIRConceptMapTarget' => 'OpenEMR/FHIR/R4/FHIRResource/FHIRConceptMap/FHIRConceptMapTarget.php',
    'OpenEMR\\FHIR\\R4\\FHIRResource\\FHIRConceptMap\\FHIRConceptMapDependsOn' => 'OpenEMR/FHIR/R4/FHIRResource/FHIRConceptMap/FHIRConceptMapDependsOn.php',
    'OpenEMR\\FHIR\\R4\\FHIRResource\\FHIRConceptMap\\FHIRConceptMapUnmapped' => 'OpenEMR/FHIR/R4/FHIRResource/FHIRConceptMap/FHIRConceptMapUnmapped.php',
    'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRConceptMapGroupUnmappedMode' => 'OpenEMR/FHIR/R4/FHIRElement/FHIRConceptMapGroupUnmappedMode.php',
    'OpenEMR\\FHIR\\R4\\FHIRDomainResource\\FHIRCondition' => 'OpenEMR/FHIR/R4/FHIRDomainResource/FHIRCondition.php',
    'OpenEMR\\FHIR\\R4\\FHIRResource\\FHIRCondition\\FHIRConditionStage' => 'OpenEMR/FHIR/R4/FHIRResource/FHIRCondition/FHIRConditionStage.php',
    'OpenEMR\\FHIR\\R4\\FHIRResource\\FHIRCondition\\FHIRConditionEvidence' => 'OpenEMR/FHIR/R4/FHIRResource/FHIRCondition/FHIRConditionEvidence.php',
    'OpenEMR\\FHIR\\R4\\FHIRDomainResource\\FHIRConsent' => 'OpenEMR/FHIR/R4/FHIRDomainResource/FHIRConsent.php',
    'OpenEMR\\FHIR\\R4\\FHIRResource\\FHIRConsent\\FHIRConsentPolicy' => 'OpenEMR/FHIR/R4/FHIRResource/FHIRConsent/FHIRConsentPolicy.php',
    'OpenEMR\\FHIR\\R4\\FHIRResource\\FHIRConsent\\FHIRConsentVerification' => 'OpenEMR/FHIR/R4/FHIRResource/FHIRConsent/FHIRConsentVerification.php',
    'OpenEMR\\FHIR\\R4\\FHIRResource\\FHIRConsent\\FHIRConsentProvision' => 'OpenEMR/FHIR/R4/FHIRResource/FHIRConsent/FHIRConsentProvision.php',
    'OpenEMR\\FHIR\\R4\\FHIRResource\\FHIRConsent\\FHIRConsentActor' => 'OpenEMR/FHIR/R4/FHIRResource/FHIRConsent/FHIRConsentActor.php',
    'OpenEMR\\FHIR\\R4\\FHIRResource\\FHIRConsent\\FHIRConsentData' => 'OpenEMR/FHIR/R4/FHIRResource/FHIRConsent/FHIRConsentData.php',
    'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRConsentProvisionType' => 'OpenEMR/FHIR/R4/FHIRElement/FHIRConsentProvisionType.php',
    'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRConsentDataMeaning' => 'OpenEMR/FHIR/R4/FHIRElement/FHIRConsentDataMeaning.php',
    'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRConsentState' => 'OpenEMR/FHIR/R4/FHIRElement/FHIRConsentState.php',
    'OpenEMR\\FHIR\\R4\\FHIRDomainResource\\FHIRContract' => 'OpenEMR/FHIR/R4/FHIRDomainResource/FHIRContract.php',
    'OpenEMR\\FHIR\\R4\\FHIRResource\\FHIRContract\\FHIRContractContentDefinition' => 'OpenEMR/FHIR/R4/FHIRResource/FHIRContract/FHIRContractContentDefinition.php',
    'OpenEMR\\FHIR\\R4\\FHIRResource\\FHIRContract\\FHIRContractTerm' => 'OpenEMR/FHIR/R4/FHIRResource/FHIRContract/FHIRContractTerm.php',
    'OpenEMR\\FHIR\\R4\\FHIRResource\\FHIRContract\\FHIRContractSecurityLabel' => 'OpenEMR/FHIR/R4/FHIRResource/FHIRContract/FHIRContractSecurityLabel.php',
    'OpenEMR\\FHIR\\R4\\FHIRResource\\FHIRContract\\FHIRContractOffer' => 'OpenEMR/FHIR/R4/FHIRResource/FHIRContract/FHIRContractOffer.php',
    'OpenEMR\\FHIR\\R4\\FHIRResource\\FHIRContract\\FHIRContractParty' => 'OpenEMR/FHIR/R4/FHIRResource/FHIRContract/FHIRContractParty.php',
    'OpenEMR\\FHIR\\R4\\FHIRResource\\FHIRContract\\FHIRContractAnswer' => 'OpenEMR/FHIR/R4/FHIRResource/FHIRContract/FHIRContractAnswer.php',
    'OpenEMR\\FHIR\\R4\\FHIRResource\\FHIRContract\\FHIRContractAsset' => 'OpenEMR/FHIR/R4/FHIRResource/FHIRContract/FHIRContractAsset.php',
    'OpenEMR\\FHIR\\R4\\FHIRResource\\FHIRContract\\FHIRContractContext' => 'OpenEMR/FHIR/R4/FHIRResource/FHIRContract/FHIRContractContext.php',
    'OpenEMR\\FHIR\\R4\\FHIRResource\\FHIRContract\\FHIRContractValuedItem' => 'OpenEMR/FHIR/R4/FHIRResource/FHIRContract/FHIRContractValuedItem.php',
    'OpenEMR\\FHIR\\R4\\FHIRResource\\FHIRContract\\FHIRContractAction' => 'OpenEMR/FHIR/R4/FHIRResource/FHIRContract/FHIRContractAction.php',
    'OpenEMR\\FHIR\\R4\\FHIRResource\\FHIRContract\\FHIRContractSubject' => 'OpenEMR/FHIR/R4/FHIRResource/FHIRContract/FHIRContractSubject.php',
    'OpenEMR\\FHIR\\R4\\FHIRResource\\FHIRContract\\FHIRContractSigner' => 'OpenEMR/FHIR/R4/FHIRResource/FHIRContract/FHIRContractSigner.php',
    'OpenEMR\\FHIR\\R4\\FHIRResource\\FHIRContract\\FHIRContractFriendly' => 'OpenEMR/FHIR/R4/FHIRResource/FHIRContract/FHIRContractFriendly.php',
    'OpenEMR\\FHIR\\R4\\FHIRResource\\FHIRContract\\FHIRContractLegal' => 'OpenEMR/FHIR/R4/FHIRResource/FHIRContract/FHIRContractLegal.php',
    'OpenEMR\\FHIR\\R4\\FHIRResource\\FHIRContract\\FHIRContractRule' => 'OpenEMR/FHIR/R4/FHIRResource/FHIRContract/FHIRContractRule.php',
    'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRContractResourceStatusCodes' => 'OpenEMR/FHIR/R4/FHIRElement/FHIRContractResourceStatusCodes.php',
    'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRContractResourcePublicationStatusCodes' => 'OpenEMR/FHIR/R4/FHIRElement/FHIRContractResourcePublicationStatusCodes.php',
    'OpenEMR\\FHIR\\R4\\FHIRDomainResource\\FHIRCoverage' => 'OpenEMR/FHIR/R4/FHIRDomainResource/FHIRCoverage.php',
    'OpenEMR\\FHIR\\R4\\FHIRResource\\FHIRCoverage\\FHIRCoverageClass' => 'OpenEMR/FHIR/R4/FHIRResource/FHIRCoverage/FHIRCoverageClass.php',
    'OpenEMR\\FHIR\\R4\\FHIRResource\\FHIRCoverage\\FHIRCoverageCostToBeneficiary' => 'OpenEMR/FHIR/R4/FHIRResource/FHIRCoverage/FHIRCoverageCostToBeneficiary.php',
    'OpenEMR\\FHIR\\R4\\FHIRResource\\FHIRCoverage\\FHIRCoverageException' => 'OpenEMR/FHIR/R4/FHIRResource/FHIRCoverage/FHIRCoverageException.php',
    'OpenEMR\\FHIR\\R4\\FHIRDomainResource\\FHIRCoverageEligibilityRequest' => 'OpenEMR/FHIR/R4/FHIRDomainResource/FHIRCoverageEligibilityRequest.php',
    'OpenEMR\\FHIR\\R4\\FHIRResource\\FHIRCoverageEligibilityRequest\\FHIRCoverageEligibilityRequestSupportingInfo' => 'OpenEMR/FHIR/R4/FHIRResource/FHIRCoverageEligibilityRequest/FHIRCoverageEligibilityRequestSupportingInfo.php',
    'OpenEMR\\FHIR\\R4\\FHIRResource\\FHIRCoverageEligibilityRequest\\FHIRCoverageEligibilityRequestInsurance' => 'OpenEMR/FHIR/R4/FHIRResource/FHIRCoverageEligibilityRequest/FHIRCoverageEligibilityRequestInsurance.php',
    'OpenEMR\\FHIR\\R4\\FHIRResource\\FHIRCoverageEligibilityRequest\\FHIRCoverageEligibilityRequestItem' => 'OpenEMR/FHIR/R4/FHIRResource/FHIRCoverageEligibilityRequest/FHIRCoverageEligibilityRequestItem.php',
    'OpenEMR\\FHIR\\R4\\FHIRResource\\FHIRCoverageEligibilityRequest\\FHIRCoverageEligibilityRequestDiagnosis' => 'OpenEMR/FHIR/R4/FHIRResource/FHIRCoverageEligibilityRequest/FHIRCoverageEligibilityRequestDiagnosis.php',
    'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIREligibilityRequestPurpose' => 'OpenEMR/FHIR/R4/FHIRElement/FHIREligibilityRequestPurpose.php',
    'OpenEMR\\FHIR\\R4\\FHIRDomainResource\\FHIRCoverageEligibilityResponse' => 'OpenEMR/FHIR/R4/FHIRDomainResource/FHIRCoverageEligibilityResponse.php',
    'OpenEMR\\FHIR\\R4\\FHIRResource\\FHIRCoverageEligibilityResponse\\FHIRCoverageEligibilityResponseInsurance' => 'OpenEMR/FHIR/R4/FHIRResource/FHIRCoverageEligibilityResponse/FHIRCoverageEligibilityResponseInsurance.php',
    'OpenEMR\\FHIR\\R4\\FHIRResource\\FHIRCoverageEligibilityResponse\\FHIRCoverageEligibilityResponseItem' => 'OpenEMR/FHIR/R4/FHIRResource/FHIRCoverageEligibilityResponse/FHIRCoverageEligibilityResponseItem.php',
    'OpenEMR\\FHIR\\R4\\FHIRResource\\FHIRCoverageEligibilityResponse\\FHIRCoverageEligibilityResponseBenefit' => 'OpenEMR/FHIR/R4/FHIRResource/FHIRCoverageEligibilityResponse/FHIRCoverageEligibilityResponseBenefit.php',
    'OpenEMR\\FHIR\\R4\\FHIRResource\\FHIRCoverageEligibilityResponse\\FHIRCoverageEligibilityResponseError' => 'OpenEMR/FHIR/R4/FHIRResource/FHIRCoverageEligibilityResponse/FHIRCoverageEligibilityResponseError.php',
    'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIREligibilityResponsePurpose' => 'OpenEMR/FHIR/R4/FHIRElement/FHIREligibilityResponsePurpose.php',
    'OpenEMR\\FHIR\\R4\\FHIRDomainResource\\FHIRDetectedIssue' => 'OpenEMR/FHIR/R4/FHIRDomainResource/FHIRDetectedIssue.php',
    'OpenEMR\\FHIR\\R4\\FHIRResource\\FHIRDetectedIssue\\FHIRDetectedIssueEvidence' => 'OpenEMR/FHIR/R4/FHIRResource/FHIRDetectedIssue/FHIRDetectedIssueEvidence.php',
    'OpenEMR\\FHIR\\R4\\FHIRResource\\FHIRDetectedIssue\\FHIRDetectedIssueMitigation' => 'OpenEMR/FHIR/R4/FHIRResource/FHIRDetectedIssue/FHIRDetectedIssueMitigation.php',
    'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRObservationStatus' => 'OpenEMR/FHIR/R4/FHIRElement/FHIRObservationStatus.php',
    'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRDetectedIssueSeverity' => 'OpenEMR/FHIR/R4/FHIRElement/FHIRDetectedIssueSeverity.php',
    'OpenEMR\\FHIR\\R4\\FHIRDomainResource\\FHIRDevice' => 'OpenEMR/FHIR/R4/FHIRDomainResource/FHIRDevice.php',
    'OpenEMR\\FHIR\\R4\\FHIRResource\\FHIRDevice\\FHIRDeviceUdiCarrier' => 'OpenEMR/FHIR/R4/FHIRResource/FHIRDevice/FHIRDeviceUdiCarrier.php',
    'OpenEMR\\FHIR\\R4\\FHIRResource\\FHIRDevice\\FHIRDeviceDeviceName' => 'OpenEMR/FHIR/R4/FHIRResource/FHIRDevice/FHIRDeviceDeviceName.php',
    'OpenEMR\\FHIR\\R4\\FHIRResource\\FHIRDevice\\FHIRDeviceSpecialization' => 'OpenEMR/FHIR/R4/FHIRResource/FHIRDevice/FHIRDeviceSpecialization.php',
    'OpenEMR\\FHIR\\R4\\FHIRResource\\FHIRDevice\\FHIRDeviceVersion' => 'OpenEMR/FHIR/R4/FHIRResource/FHIRDevice/FHIRDeviceVersion.php',
    'OpenEMR\\FHIR\\R4\\FHIRResource\\FHIRDevice\\FHIRDeviceProperty' => 'OpenEMR/FHIR/R4/FHIRResource/FHIRDevice/FHIRDeviceProperty.php',
    'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRFHIRDeviceStatus' => 'OpenEMR/FHIR/R4/FHIRElement/FHIRFHIRDeviceStatus.php',
    'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRDeviceNameType' => 'OpenEMR/FHIR/R4/FHIRElement/FHIRDeviceNameType.php',
    'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRUDIEntryType' => 'OpenEMR/FHIR/R4/FHIRElement/FHIRUDIEntryType.php',
    'OpenEMR\\FHIR\\R4\\FHIRDomainResource\\FHIRDeviceDefinition' => 'OpenEMR/FHIR/R4/FHIRDomainResource/FHIRDeviceDefinition.php',
    'OpenEMR\\FHIR\\R4\\FHIRResource\\FHIRDeviceDefinition\\FHIRDeviceDefinitionUdiDeviceIdentifier' => 'OpenEMR/FHIR/R4/FHIRResource/FHIRDeviceDefinition/FHIRDeviceDefinitionUdiDeviceIdentifier.php',
    'OpenEMR\\FHIR\\R4\\FHIRResource\\FHIRDeviceDefinition\\FHIRDeviceDefinitionDeviceName' => 'OpenEMR/FHIR/R4/FHIRResource/FHIRDeviceDefinition/FHIRDeviceDefinitionDeviceName.php',
    'OpenEMR\\FHIR\\R4\\FHIRResource\\FHIRDeviceDefinition\\FHIRDeviceDefinitionSpecialization' => 'OpenEMR/FHIR/R4/FHIRResource/FHIRDeviceDefinition/FHIRDeviceDefinitionSpecialization.php',
    'OpenEMR\\FHIR\\R4\\FHIRResource\\FHIRDeviceDefinition\\FHIRDeviceDefinitionCapability' => 'OpenEMR/FHIR/R4/FHIRResource/FHIRDeviceDefinition/FHIRDeviceDefinitionCapability.php',
    'OpenEMR\\FHIR\\R4\\FHIRResource\\FHIRDeviceDefinition\\FHIRDeviceDefinitionProperty' => 'OpenEMR/FHIR/R4/FHIRResource/FHIRDeviceDefinition/FHIRDeviceDefinitionProperty.php',
    'OpenEMR\\FHIR\\R4\\FHIRResource\\FHIRDeviceDefinition\\FHIRDeviceDefinitionMaterial' => 'OpenEMR/FHIR/R4/FHIRResource/FHIRDeviceDefinition/FHIRDeviceDefinitionMaterial.php',
    'OpenEMR\\FHIR\\R4\\FHIRDomainResource\\FHIRDeviceMetric' => 'OpenEMR/FHIR/R4/FHIRDomainResource/FHIRDeviceMetric.php',
    'OpenEMR\\FHIR\\R4\\FHIRResource\\FHIRDeviceMetric\\FHIRDeviceMetricCalibration' => 'OpenEMR/FHIR/R4/FHIRResource/FHIRDeviceMetric/FHIRDeviceMetricCalibration.php',
    'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRDeviceMetricCalibrationType' => 'OpenEMR/FHIR/R4/FHIRElement/FHIRDeviceMetricCalibrationType.php',
    'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRDeviceMetricColor' => 'OpenEMR/FHIR/R4/FHIRElement/FHIRDeviceMetricColor.php',
    'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRDeviceMetricCalibrationState' => 'OpenEMR/FHIR/R4/FHIRElement/FHIRDeviceMetricCalibrationState.php',
    'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRDeviceMetricOperationalStatus' => 'OpenEMR/FHIR/R4/FHIRElement/FHIRDeviceMetricOperationalStatus.php',
    'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRDeviceMetricCategory' => 'OpenEMR/FHIR/R4/FHIRElement/FHIRDeviceMetricCategory.php',
    'OpenEMR\\FHIR\\R4\\FHIRDomainResource\\FHIRDeviceRequest' => 'OpenEMR/FHIR/R4/FHIRDomainResource/FHIRDeviceRequest.php',
    'OpenEMR\\FHIR\\R4\\FHIRResource\\FHIRDeviceRequest\\FHIRDeviceRequestParameter' => 'OpenEMR/FHIR/R4/FHIRResource/FHIRDeviceRequest/FHIRDeviceRequestParameter.php',
    'OpenEMR\\FHIR\\R4\\FHIRDomainResource\\FHIRDeviceUseStatement' => 'OpenEMR/FHIR/R4/FHIRDomainResource/FHIRDeviceUseStatement.php',
    'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRDeviceUseStatementStatus' => 'OpenEMR/FHIR/R4/FHIRElement/FHIRDeviceUseStatementStatus.php',
    'OpenEMR\\FHIR\\R4\\FHIRDomainResource\\FHIRDiagnosticReport' => 'OpenEMR/FHIR/R4/FHIRDomainResource/FHIRDiagnosticReport.php',
    'OpenEMR\\FHIR\\R4\\FHIRResource\\FHIRDiagnosticReport\\FHIRDiagnosticReportMedia' => 'OpenEMR/FHIR/R4/FHIRResource/FHIRDiagnosticReport/FHIRDiagnosticReportMedia.php',
    'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRDiagnosticReportStatus' => 'OpenEMR/FHIR/R4/FHIRElement/FHIRDiagnosticReportStatus.php',
    'OpenEMR\\FHIR\\R4\\FHIRDomainResource\\FHIRDocumentManifest' => 'OpenEMR/FHIR/R4/FHIRDomainResource/FHIRDocumentManifest.php',
    'OpenEMR\\FHIR\\R4\\FHIRResource\\FHIRDocumentManifest\\FHIRDocumentManifestRelated' => 'OpenEMR/FHIR/R4/FHIRResource/FHIRDocumentManifest/FHIRDocumentManifestRelated.php',
    'OpenEMR\\FHIR\\R4\\FHIRDomainResource\\FHIRDocumentReference' => 'OpenEMR/FHIR/R4/FHIRDomainResource/FHIRDocumentReference.php',
    'OpenEMR\\FHIR\\R4\\FHIRResource\\FHIRDocumentReference\\FHIRDocumentReferenceRelatesTo' => 'OpenEMR/FHIR/R4/FHIRResource/FHIRDocumentReference/FHIRDocumentReferenceRelatesTo.php',
    'OpenEMR\\FHIR\\R4\\FHIRResource\\FHIRDocumentReference\\FHIRDocumentReferenceContent' => 'OpenEMR/FHIR/R4/FHIRResource/FHIRDocumentReference/FHIRDocumentReferenceContent.php',
    'OpenEMR\\FHIR\\R4\\FHIRResource\\FHIRDocumentReference\\FHIRDocumentReferenceContext' => 'OpenEMR/FHIR/R4/FHIRResource/FHIRDocumentReference/FHIRDocumentReferenceContext.php',
    'OpenEMR\\FHIR\\R4\\FHIRDomainResource\\FHIREffectEvidenceSynthesis' => 'OpenEMR/FHIR/R4/FHIRDomainResource/FHIREffectEvidenceSynthesis.php',
    'OpenEMR\\FHIR\\R4\\FHIRResource\\FHIREffectEvidenceSynthesis\\FHIREffectEvidenceSynthesisSampleSize' => 'OpenEMR/FHIR/R4/FHIRResource/FHIREffectEvidenceSynthesis/FHIREffectEvidenceSynthesisSampleSize.php',
    'OpenEMR\\FHIR\\R4\\FHIRResource\\FHIREffectEvidenceSynthesis\\FHIREffectEvidenceSynthesisResultsByExposure' => 'OpenEMR/FHIR/R4/FHIRResource/FHIREffectEvidenceSynthesis/FHIREffectEvidenceSynthesisResultsByExposure.php',
    'OpenEMR\\FHIR\\R4\\FHIRResource\\FHIREffectEvidenceSynthesis\\FHIREffectEvidenceSynthesisEffectEstimate' => 'OpenEMR/FHIR/R4/FHIRResource/FHIREffectEvidenceSynthesis/FHIREffectEvidenceSynthesisEffectEstimate.php',
    'OpenEMR\\FHIR\\R4\\FHIRResource\\FHIREffectEvidenceSynthesis\\FHIREffectEvidenceSynthesisPrecisionEstimate' => 'OpenEMR/FHIR/R4/FHIRResource/FHIREffectEvidenceSynthesis/FHIREffectEvidenceSynthesisPrecisionEstimate.php',
    'OpenEMR\\FHIR\\R4\\FHIRResource\\FHIREffectEvidenceSynthesis\\FHIREffectEvidenceSynthesisCertainty' => 'OpenEMR/FHIR/R4/FHIRResource/FHIREffectEvidenceSynthesis/FHIREffectEvidenceSynthesisCertainty.php',
    'OpenEMR\\FHIR\\R4\\FHIRResource\\FHIREffectEvidenceSynthesis\\FHIREffectEvidenceSynthesisCertaintySubcomponent' => 'OpenEMR/FHIR/R4/FHIRResource/FHIREffectEvidenceSynthesis/FHIREffectEvidenceSynthesisCertaintySubcomponent.php',
    'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRExposureState' => 'OpenEMR/FHIR/R4/FHIRElement/FHIRExposureState.php',
    'OpenEMR\\FHIR\\R4\\FHIRDomainResource\\FHIREncounter' => 'OpenEMR/FHIR/R4/FHIRDomainResource/FHIREncounter.php',
    'OpenEMR\\FHIR\\R4\\FHIRResource\\FHIREncounter\\FHIREncounterStatusHistory' => 'OpenEMR/FHIR/R4/FHIRResource/FHIREncounter/FHIREncounterStatusHistory.php',
    'OpenEMR\\FHIR\\R4\\FHIRResource\\FHIREncounter\\FHIREncounterClassHistory' => 'OpenEMR/FHIR/R4/FHIRResource/FHIREncounter/FHIREncounterClassHistory.php',
    'OpenEMR\\FHIR\\R4\\FHIRResource\\FHIREncounter\\FHIREncounterParticipant' => 'OpenEMR/FHIR/R4/FHIRResource/FHIREncounter/FHIREncounterParticipant.php',
    'OpenEMR\\FHIR\\R4\\FHIRResource\\FHIREncounter\\FHIREncounterDiagnosis' => 'OpenEMR/FHIR/R4/FHIRResource/FHIREncounter/FHIREncounterDiagnosis.php',
    'OpenEMR\\FHIR\\R4\\FHIRResource\\FHIREncounter\\FHIREncounterHospitalization' => 'OpenEMR/FHIR/R4/FHIRResource/FHIREncounter/FHIREncounterHospitalization.php',
    'OpenEMR\\FHIR\\R4\\FHIRResource\\FHIREncounter\\FHIREncounterLocation' => 'OpenEMR/FHIR/R4/FHIRResource/FHIREncounter/FHIREncounterLocation.php',
    'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIREncounterLocationStatus' => 'OpenEMR/FHIR/R4/FHIRElement/FHIREncounterLocationStatus.php',
    'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIREncounterStatus' => 'OpenEMR/FHIR/R4/FHIRElement/FHIREncounterStatus.php',
    'OpenEMR\\FHIR\\R4\\FHIRDomainResource\\FHIREndpoint' => 'OpenEMR/FHIR/R4/FHIRDomainResource/FHIREndpoint.php',
    'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIREndpointStatus' => 'OpenEMR/FHIR/R4/FHIRElement/FHIREndpointStatus.php',
    'OpenEMR\\FHIR\\R4\\FHIRDomainResource\\FHIREnrollmentRequest' => 'OpenEMR/FHIR/R4/FHIRDomainResource/FHIREnrollmentRequest.php',
    'OpenEMR\\FHIR\\R4\\FHIRDomainResource\\FHIREnrollmentResponse' => 'OpenEMR/FHIR/R4/FHIRDomainResource/FHIREnrollmentResponse.php',
    'OpenEMR\\FHIR\\R4\\FHIRDomainResource\\FHIREpisodeOfCare' => 'OpenEMR/FHIR/R4/FHIRDomainResource/FHIREpisodeOfCare.php',
    'OpenEMR\\FHIR\\R4\\FHIRResource\\FHIREpisodeOfCare\\FHIREpisodeOfCareStatusHistory' => 'OpenEMR/FHIR/R4/FHIRResource/FHIREpisodeOfCare/FHIREpisodeOfCareStatusHistory.php',
    'OpenEMR\\FHIR\\R4\\FHIRResource\\FHIREpisodeOfCare\\FHIREpisodeOfCareDiagnosis' => 'OpenEMR/FHIR/R4/FHIRResource/FHIREpisodeOfCare/FHIREpisodeOfCareDiagnosis.php',
    'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIREpisodeOfCareStatus' => 'OpenEMR/FHIR/R4/FHIRElement/FHIREpisodeOfCareStatus.php',
    'OpenEMR\\FHIR\\R4\\FHIRDomainResource\\FHIREventDefinition' => 'OpenEMR/FHIR/R4/FHIRDomainResource/FHIREventDefinition.php',
    'OpenEMR\\FHIR\\R4\\FHIRDomainResource\\FHIREvidence' => 'OpenEMR/FHIR/R4/FHIRDomainResource/FHIREvidence.php',
    'OpenEMR\\FHIR\\R4\\FHIRDomainResource\\FHIREvidenceVariable' => 'OpenEMR/FHIR/R4/FHIRDomainResource/FHIREvidenceVariable.php',
    'OpenEMR\\FHIR\\R4\\FHIRResource\\FHIREvidenceVariable\\FHIREvidenceVariableCharacteristic' => 'OpenEMR/FHIR/R4/FHIRResource/FHIREvidenceVariable/FHIREvidenceVariableCharacteristic.php',
    'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIREvidenceVariableType' => 'OpenEMR/FHIR/R4/FHIRElement/FHIREvidenceVariableType.php',
    'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRGroupMeasure' => 'OpenEMR/FHIR/R4/FHIRElement/FHIRGroupMeasure.php',
    'OpenEMR\\FHIR\\R4\\FHIRDomainResource\\FHIRExampleScenario' => 'OpenEMR/FHIR/R4/FHIRDomainResource/FHIRExampleScenario.php',
    'OpenEMR\\FHIR\\R4\\FHIRResource\\FHIRExampleScenario\\FHIRExampleScenarioActor' => 'OpenEMR/FHIR/R4/FHIRResource/FHIRExampleScenario/FHIRExampleScenarioActor.php',
    'OpenEMR\\FHIR\\R4\\FHIRResource\\FHIRExampleScenario\\FHIRExampleScenarioInstance' => 'OpenEMR/FHIR/R4/FHIRResource/FHIRExampleScenario/FHIRExampleScenarioInstance.php',
    'OpenEMR\\FHIR\\R4\\FHIRResource\\FHIRExampleScenario\\FHIRExampleScenarioVersion' => 'OpenEMR/FHIR/R4/FHIRResource/FHIRExampleScenario/FHIRExampleScenarioVersion.php',
    'OpenEMR\\FHIR\\R4\\FHIRResource\\FHIRExampleScenario\\FHIRExampleScenarioContainedInstance' => 'OpenEMR/FHIR/R4/FHIRResource/FHIRExampleScenario/FHIRExampleScenarioContainedInstance.php',
    'OpenEMR\\FHIR\\R4\\FHIRResource\\FHIRExampleScenario\\FHIRExampleScenarioProcess' => 'OpenEMR/FHIR/R4/FHIRResource/FHIRExampleScenario/FHIRExampleScenarioProcess.php',
    'OpenEMR\\FHIR\\R4\\FHIRResource\\FHIRExampleScenario\\FHIRExampleScenarioStep' => 'OpenEMR/FHIR/R4/FHIRResource/FHIRExampleScenario/FHIRExampleScenarioStep.php',
    'OpenEMR\\FHIR\\R4\\FHIRResource\\FHIRExampleScenario\\FHIRExampleScenarioOperation' => 'OpenEMR/FHIR/R4/FHIRResource/FHIRExampleScenario/FHIRExampleScenarioOperation.php',
    'OpenEMR\\FHIR\\R4\\FHIRResource\\FHIRExampleScenario\\FHIRExampleScenarioAlternative' => 'OpenEMR/FHIR/R4/FHIRResource/FHIRExampleScenario/FHIRExampleScenarioAlternative.php',
    'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRExampleScenarioActorType' => 'OpenEMR/FHIR/R4/FHIRElement/FHIRExampleScenarioActorType.php',
    'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRResourceType' => 'OpenEMR/FHIR/R4/FHIRElement/FHIRResourceType.php',
    'OpenEMR\\FHIR\\R4\\FHIRDomainResource\\FHIRExplanationOfBenefit' => 'OpenEMR/FHIR/R4/FHIRDomainResource/FHIRExplanationOfBenefit.php',
    'OpenEMR\\FHIR\\R4\\FHIRResource\\FHIRExplanationOfBenefit\\FHIRExplanationOfBenefitRelated' => 'OpenEMR/FHIR/R4/FHIRResource/FHIRExplanationOfBenefit/FHIRExplanationOfBenefitRelated.php',
    'OpenEMR\\FHIR\\R4\\FHIRResource\\FHIRExplanationOfBenefit\\FHIRExplanationOfBenefitPayee' => 'OpenEMR/FHIR/R4/FHIRResource/FHIRExplanationOfBenefit/FHIRExplanationOfBenefitPayee.php',
    'OpenEMR\\FHIR\\R4\\FHIRResource\\FHIRExplanationOfBenefit\\FHIRExplanationOfBenefitCareTeam' => 'OpenEMR/FHIR/R4/FHIRResource/FHIRExplanationOfBenefit/FHIRExplanationOfBenefitCareTeam.php',
    'OpenEMR\\FHIR\\R4\\FHIRResource\\FHIRExplanationOfBenefit\\FHIRExplanationOfBenefitSupportingInfo' => 'OpenEMR/FHIR/R4/FHIRResource/FHIRExplanationOfBenefit/FHIRExplanationOfBenefitSupportingInfo.php',
    'OpenEMR\\FHIR\\R4\\FHIRResource\\FHIRExplanationOfBenefit\\FHIRExplanationOfBenefitDiagnosis' => 'OpenEMR/FHIR/R4/FHIRResource/FHIRExplanationOfBenefit/FHIRExplanationOfBenefitDiagnosis.php',
    'OpenEMR\\FHIR\\R4\\FHIRResource\\FHIRExplanationOfBenefit\\FHIRExplanationOfBenefitProcedure' => 'OpenEMR/FHIR/R4/FHIRResource/FHIRExplanationOfBenefit/FHIRExplanationOfBenefitProcedure.php',
    'OpenEMR\\FHIR\\R4\\FHIRResource\\FHIRExplanationOfBenefit\\FHIRExplanationOfBenefitInsurance' => 'OpenEMR/FHIR/R4/FHIRResource/FHIRExplanationOfBenefit/FHIRExplanationOfBenefitInsurance.php',
    'OpenEMR\\FHIR\\R4\\FHIRResource\\FHIRExplanationOfBenefit\\FHIRExplanationOfBenefitAccident' => 'OpenEMR/FHIR/R4/FHIRResource/FHIRExplanationOfBenefit/FHIRExplanationOfBenefitAccident.php',
    'OpenEMR\\FHIR\\R4\\FHIRResource\\FHIRExplanationOfBenefit\\FHIRExplanationOfBenefitItem' => 'OpenEMR/FHIR/R4/FHIRResource/FHIRExplanationOfBenefit/FHIRExplanationOfBenefitItem.php',
    'OpenEMR\\FHIR\\R4\\FHIRResource\\FHIRExplanationOfBenefit\\FHIRExplanationOfBenefitAdjudication' => 'OpenEMR/FHIR/R4/FHIRResource/FHIRExplanationOfBenefit/FHIRExplanationOfBenefitAdjudication.php',
    'OpenEMR\\FHIR\\R4\\FHIRResource\\FHIRExplanationOfBenefit\\FHIRExplanationOfBenefitDetail' => 'OpenEMR/FHIR/R4/FHIRResource/FHIRExplanationOfBenefit/FHIRExplanationOfBenefitDetail.php',
    'OpenEMR\\FHIR\\R4\\FHIRResource\\FHIRExplanationOfBenefit\\FHIRExplanationOfBenefitSubDetail' => 'OpenEMR/FHIR/R4/FHIRResource/FHIRExplanationOfBenefit/FHIRExplanationOfBenefitSubDetail.php',
    'OpenEMR\\FHIR\\R4\\FHIRResource\\FHIRExplanationOfBenefit\\FHIRExplanationOfBenefitAddItem' => 'OpenEMR/FHIR/R4/FHIRResource/FHIRExplanationOfBenefit/FHIRExplanationOfBenefitAddItem.php',
    'OpenEMR\\FHIR\\R4\\FHIRResource\\FHIRExplanationOfBenefit\\FHIRExplanationOfBenefitDetail1' => 'OpenEMR/FHIR/R4/FHIRResource/FHIRExplanationOfBenefit/FHIRExplanationOfBenefitDetail1.php',
    'OpenEMR\\FHIR\\R4\\FHIRResource\\FHIRExplanationOfBenefit\\FHIRExplanationOfBenefitSubDetail1' => 'OpenEMR/FHIR/R4/FHIRResource/FHIRExplanationOfBenefit/FHIRExplanationOfBenefitSubDetail1.php',
    'OpenEMR\\FHIR\\R4\\FHIRResource\\FHIRExplanationOfBenefit\\FHIRExplanationOfBenefitTotal' => 'OpenEMR/FHIR/R4/FHIRResource/FHIRExplanationOfBenefit/FHIRExplanationOfBenefitTotal.php',
    'OpenEMR\\FHIR\\R4\\FHIRResource\\FHIRExplanationOfBenefit\\FHIRExplanationOfBenefitPayment' => 'OpenEMR/FHIR/R4/FHIRResource/FHIRExplanationOfBenefit/FHIRExplanationOfBenefitPayment.php',
    'OpenEMR\\FHIR\\R4\\FHIRResource\\FHIRExplanationOfBenefit\\FHIRExplanationOfBenefitProcessNote' => 'OpenEMR/FHIR/R4/FHIRResource/FHIRExplanationOfBenefit/FHIRExplanationOfBenefitProcessNote.php',
    'OpenEMR\\FHIR\\R4\\FHIRResource\\FHIRExplanationOfBenefit\\FHIRExplanationOfBenefitBenefitBalance' => 'OpenEMR/FHIR/R4/FHIRResource/FHIRExplanationOfBenefit/FHIRExplanationOfBenefitBenefitBalance.php',
    'OpenEMR\\FHIR\\R4\\FHIRResource\\FHIRExplanationOfBenefit\\FHIRExplanationOfBenefitFinancial' => 'OpenEMR/FHIR/R4/FHIRResource/FHIRExplanationOfBenefit/FHIRExplanationOfBenefitFinancial.php',
    'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRExplanationOfBenefitStatus' => 'OpenEMR/FHIR/R4/FHIRElement/FHIRExplanationOfBenefitStatus.php',
    'OpenEMR\\FHIR\\R4\\FHIRDomainResource\\FHIRFamilyMemberHistory' => 'OpenEMR/FHIR/R4/FHIRDomainResource/FHIRFamilyMemberHistory.php',
    'OpenEMR\\FHIR\\R4\\FHIRResource\\FHIRFamilyMemberHistory\\FHIRFamilyMemberHistoryCondition' => 'OpenEMR/FHIR/R4/FHIRResource/FHIRFamilyMemberHistory/FHIRFamilyMemberHistoryCondition.php',
    'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRFamilyHistoryStatus' => 'OpenEMR/FHIR/R4/FHIRElement/FHIRFamilyHistoryStatus.php',
    'OpenEMR\\FHIR\\R4\\FHIRDomainResource\\FHIRFlag' => 'OpenEMR/FHIR/R4/FHIRDomainResource/FHIRFlag.php',
    'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRFlagStatus' => 'OpenEMR/FHIR/R4/FHIRElement/FHIRFlagStatus.php',
    'OpenEMR\\FHIR\\R4\\FHIRDomainResource\\FHIRGoal' => 'OpenEMR/FHIR/R4/FHIRDomainResource/FHIRGoal.php',
    'OpenEMR\\FHIR\\R4\\FHIRResource\\FHIRGoal\\FHIRGoalTarget' => 'OpenEMR/FHIR/R4/FHIRResource/FHIRGoal/FHIRGoalTarget.php',
    'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRGoalLifecycleStatus' => 'OpenEMR/FHIR/R4/FHIRElement/FHIRGoalLifecycleStatus.php',
    'OpenEMR\\FHIR\\R4\\FHIRDomainResource\\FHIRGraphDefinition' => 'OpenEMR/FHIR/R4/FHIRDomainResource/FHIRGraphDefinition.php',
    'OpenEMR\\FHIR\\R4\\FHIRResource\\FHIRGraphDefinition\\FHIRGraphDefinitionLink' => 'OpenEMR/FHIR/R4/FHIRResource/FHIRGraphDefinition/FHIRGraphDefinitionLink.php',
    'OpenEMR\\FHIR\\R4\\FHIRResource\\FHIRGraphDefinition\\FHIRGraphDefinitionTarget' => 'OpenEMR/FHIR/R4/FHIRResource/FHIRGraphDefinition/FHIRGraphDefinitionTarget.php',
    'OpenEMR\\FHIR\\R4\\FHIRResource\\FHIRGraphDefinition\\FHIRGraphDefinitionCompartment' => 'OpenEMR/FHIR/R4/FHIRResource/FHIRGraphDefinition/FHIRGraphDefinitionCompartment.php',
    'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRGraphCompartmentUse' => 'OpenEMR/FHIR/R4/FHIRElement/FHIRGraphCompartmentUse.php',
    'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRGraphCompartmentRule' => 'OpenEMR/FHIR/R4/FHIRElement/FHIRGraphCompartmentRule.php',
    'OpenEMR\\FHIR\\R4\\FHIRDomainResource\\FHIRGroup' => 'OpenEMR/FHIR/R4/FHIRDomainResource/FHIRGroup.php',
    'OpenEMR\\FHIR\\R4\\FHIRResource\\FHIRGroup\\FHIRGroupCharacteristic' => 'OpenEMR/FHIR/R4/FHIRResource/FHIRGroup/FHIRGroupCharacteristic.php',
    'OpenEMR\\FHIR\\R4\\FHIRResource\\FHIRGroup\\FHIRGroupMember' => 'OpenEMR/FHIR/R4/FHIRResource/FHIRGroup/FHIRGroupMember.php',
    'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRGroupType' => 'OpenEMR/FHIR/R4/FHIRElement/FHIRGroupType.php',
    'OpenEMR\\FHIR\\R4\\FHIRDomainResource\\FHIRGuidanceResponse' => 'OpenEMR/FHIR/R4/FHIRDomainResource/FHIRGuidanceResponse.php',
    'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRGuidanceResponseStatus' => 'OpenEMR/FHIR/R4/FHIRElement/FHIRGuidanceResponseStatus.php',
    'OpenEMR\\FHIR\\R4\\FHIRDomainResource\\FHIRHealthcareService' => 'OpenEMR/FHIR/R4/FHIRDomainResource/FHIRHealthcareService.php',
    'OpenEMR\\FHIR\\R4\\FHIRResource\\FHIRHealthcareService\\FHIRHealthcareServiceEligibility' => 'OpenEMR/FHIR/R4/FHIRResource/FHIRHealthcareService/FHIRHealthcareServiceEligibility.php',
    'OpenEMR\\FHIR\\R4\\FHIRResource\\FHIRHealthcareService\\FHIRHealthcareServiceAvailableTime' => 'OpenEMR/FHIR/R4/FHIRResource/FHIRHealthcareService/FHIRHealthcareServiceAvailableTime.php',
    'OpenEMR\\FHIR\\R4\\FHIRResource\\FHIRHealthcareService\\FHIRHealthcareServiceNotAvailable' => 'OpenEMR/FHIR/R4/FHIRResource/FHIRHealthcareService/FHIRHealthcareServiceNotAvailable.php',
    'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRDaysOfWeek' => 'OpenEMR/FHIR/R4/FHIRElement/FHIRDaysOfWeek.php',
    'OpenEMR\\FHIR\\R4\\FHIRDomainResource\\FHIRImagingStudy' => 'OpenEMR/FHIR/R4/FHIRDomainResource/FHIRImagingStudy.php',
    'OpenEMR\\FHIR\\R4\\FHIRResource\\FHIRImagingStudy\\FHIRImagingStudySeries' => 'OpenEMR/FHIR/R4/FHIRResource/FHIRImagingStudy/FHIRImagingStudySeries.php',
    'OpenEMR\\FHIR\\R4\\FHIRResource\\FHIRImagingStudy\\FHIRImagingStudyPerformer' => 'OpenEMR/FHIR/R4/FHIRResource/FHIRImagingStudy/FHIRImagingStudyPerformer.php',
    'OpenEMR\\FHIR\\R4\\FHIRResource\\FHIRImagingStudy\\FHIRImagingStudyInstance' => 'OpenEMR/FHIR/R4/FHIRResource/FHIRImagingStudy/FHIRImagingStudyInstance.php',
    'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRImagingStudyStatus' => 'OpenEMR/FHIR/R4/FHIRElement/FHIRImagingStudyStatus.php',
    'OpenEMR\\FHIR\\R4\\FHIRDomainResource\\FHIRImmunization' => 'OpenEMR/FHIR/R4/FHIRDomainResource/FHIRImmunization.php',
    'OpenEMR\\FHIR\\R4\\FHIRResource\\FHIRImmunization\\FHIRImmunizationPerformer' => 'OpenEMR/FHIR/R4/FHIRResource/FHIRImmunization/FHIRImmunizationPerformer.php',
    'OpenEMR\\FHIR\\R4\\FHIRResource\\FHIRImmunization\\FHIRImmunizationEducation' => 'OpenEMR/FHIR/R4/FHIRResource/FHIRImmunization/FHIRImmunizationEducation.php',
    'OpenEMR\\FHIR\\R4\\FHIRResource\\FHIRImmunization\\FHIRImmunizationReaction' => 'OpenEMR/FHIR/R4/FHIRResource/FHIRImmunization/FHIRImmunizationReaction.php',
    'OpenEMR\\FHIR\\R4\\FHIRResource\\FHIRImmunization\\FHIRImmunizationProtocolApplied' => 'OpenEMR/FHIR/R4/FHIRResource/FHIRImmunization/FHIRImmunizationProtocolApplied.php',
    'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRImmunizationStatusCodes' => 'OpenEMR/FHIR/R4/FHIRElement/FHIRImmunizationStatusCodes.php',
    'OpenEMR\\FHIR\\R4\\FHIRDomainResource\\FHIRImmunizationEvaluation' => 'OpenEMR/FHIR/R4/FHIRDomainResource/FHIRImmunizationEvaluation.php',
    'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRImmunizationEvaluationStatusCodes' => 'OpenEMR/FHIR/R4/FHIRElement/FHIRImmunizationEvaluationStatusCodes.php',
    'OpenEMR\\FHIR\\R4\\FHIRDomainResource\\FHIRImmunizationRecommendation' => 'OpenEMR/FHIR/R4/FHIRDomainResource/FHIRImmunizationRecommendation.php',
    'OpenEMR\\FHIR\\R4\\FHIRResource\\FHIRImmunizationRecommendation\\FHIRImmunizationRecommendationRecommendation' => 'OpenEMR/FHIR/R4/FHIRResource/FHIRImmunizationRecommendation/FHIRImmunizationRecommendationRecommendation.php',
    'OpenEMR\\FHIR\\R4\\FHIRResource\\FHIRImmunizationRecommendation\\FHIRImmunizationRecommendationDateCriterion' => 'OpenEMR/FHIR/R4/FHIRResource/FHIRImmunizationRecommendation/FHIRImmunizationRecommendationDateCriterion.php',
    'OpenEMR\\FHIR\\R4\\FHIRDomainResource\\FHIRImplementationGuide' => 'OpenEMR/FHIR/R4/FHIRDomainResource/FHIRImplementationGuide.php',
    'OpenEMR\\FHIR\\R4\\FHIRResource\\FHIRImplementationGuide\\FHIRImplementationGuideDependsOn' => 'OpenEMR/FHIR/R4/FHIRResource/FHIRImplementationGuide/FHIRImplementationGuideDependsOn.php',
    'OpenEMR\\FHIR\\R4\\FHIRResource\\FHIRImplementationGuide\\FHIRImplementationGuideGlobal' => 'OpenEMR/FHIR/R4/FHIRResource/FHIRImplementationGuide/FHIRImplementationGuideGlobal.php',
    'OpenEMR\\FHIR\\R4\\FHIRResource\\FHIRImplementationGuide\\FHIRImplementationGuideDefinition' => 'OpenEMR/FHIR/R4/FHIRResource/FHIRImplementationGuide/FHIRImplementationGuideDefinition.php',
    'OpenEMR\\FHIR\\R4\\FHIRResource\\FHIRImplementationGuide\\FHIRImplementationGuideGrouping' => 'OpenEMR/FHIR/R4/FHIRResource/FHIRImplementationGuide/FHIRImplementationGuideGrouping.php',
    'OpenEMR\\FHIR\\R4\\FHIRResource\\FHIRImplementationGuide\\FHIRImplementationGuideResource' => 'OpenEMR/FHIR/R4/FHIRResource/FHIRImplementationGuide/FHIRImplementationGuideResource.php',
    'OpenEMR\\FHIR\\R4\\FHIRResource\\FHIRImplementationGuide\\FHIRImplementationGuidePage' => 'OpenEMR/FHIR/R4/FHIRResource/FHIRImplementationGuide/FHIRImplementationGuidePage.php',
    'OpenEMR\\FHIR\\R4\\FHIRResource\\FHIRImplementationGuide\\FHIRImplementationGuideParameter' => 'OpenEMR/FHIR/R4/FHIRResource/FHIRImplementationGuide/FHIRImplementationGuideParameter.php',
    'OpenEMR\\FHIR\\R4\\FHIRResource\\FHIRImplementationGuide\\FHIRImplementationGuideTemplate' => 'OpenEMR/FHIR/R4/FHIRResource/FHIRImplementationGuide/FHIRImplementationGuideTemplate.php',
    'OpenEMR\\FHIR\\R4\\FHIRResource\\FHIRImplementationGuide\\FHIRImplementationGuideManifest' => 'OpenEMR/FHIR/R4/FHIRResource/FHIRImplementationGuide/FHIRImplementationGuideManifest.php',
    'OpenEMR\\FHIR\\R4\\FHIRResource\\FHIRImplementationGuide\\FHIRImplementationGuideResource1' => 'OpenEMR/FHIR/R4/FHIRResource/FHIRImplementationGuide/FHIRImplementationGuideResource1.php',
    'OpenEMR\\FHIR\\R4\\FHIRResource\\FHIRImplementationGuide\\FHIRImplementationGuidePage1' => 'OpenEMR/FHIR/R4/FHIRResource/FHIRImplementationGuide/FHIRImplementationGuidePage1.php',
    'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRGuideParameterCode' => 'OpenEMR/FHIR/R4/FHIRElement/FHIRGuideParameterCode.php',
    'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRSPDXLicense' => 'OpenEMR/FHIR/R4/FHIRElement/FHIRSPDXLicense.php',
    'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRGuidePageGeneration' => 'OpenEMR/FHIR/R4/FHIRElement/FHIRGuidePageGeneration.php',
    'OpenEMR\\FHIR\\R4\\FHIRDomainResource\\FHIRInsurancePlan' => 'OpenEMR/FHIR/R4/FHIRDomainResource/FHIRInsurancePlan.php',
    'OpenEMR\\FHIR\\R4\\FHIRResource\\FHIRInsurancePlan\\FHIRInsurancePlanContact' => 'OpenEMR/FHIR/R4/FHIRResource/FHIRInsurancePlan/FHIRInsurancePlanContact.php',
    'OpenEMR\\FHIR\\R4\\FHIRResource\\FHIRInsurancePlan\\FHIRInsurancePlanCoverage' => 'OpenEMR/FHIR/R4/FHIRResource/FHIRInsurancePlan/FHIRInsurancePlanCoverage.php',
    'OpenEMR\\FHIR\\R4\\FHIRResource\\FHIRInsurancePlan\\FHIRInsurancePlanBenefit' => 'OpenEMR/FHIR/R4/FHIRResource/FHIRInsurancePlan/FHIRInsurancePlanBenefit.php',
    'OpenEMR\\FHIR\\R4\\FHIRResource\\FHIRInsurancePlan\\FHIRInsurancePlanLimit' => 'OpenEMR/FHIR/R4/FHIRResource/FHIRInsurancePlan/FHIRInsurancePlanLimit.php',
    'OpenEMR\\FHIR\\R4\\FHIRResource\\FHIRInsurancePlan\\FHIRInsurancePlanPlan' => 'OpenEMR/FHIR/R4/FHIRResource/FHIRInsurancePlan/FHIRInsurancePlanPlan.php',
    'OpenEMR\\FHIR\\R4\\FHIRResource\\FHIRInsurancePlan\\FHIRInsurancePlanGeneralCost' => 'OpenEMR/FHIR/R4/FHIRResource/FHIRInsurancePlan/FHIRInsurancePlanGeneralCost.php',
    'OpenEMR\\FHIR\\R4\\FHIRResource\\FHIRInsurancePlan\\FHIRInsurancePlanSpecificCost' => 'OpenEMR/FHIR/R4/FHIRResource/FHIRInsurancePlan/FHIRInsurancePlanSpecificCost.php',
    'OpenEMR\\FHIR\\R4\\FHIRResource\\FHIRInsurancePlan\\FHIRInsurancePlanBenefit1' => 'OpenEMR/FHIR/R4/FHIRResource/FHIRInsurancePlan/FHIRInsurancePlanBenefit1.php',
    'OpenEMR\\FHIR\\R4\\FHIRResource\\FHIRInsurancePlan\\FHIRInsurancePlanCost' => 'OpenEMR/FHIR/R4/FHIRResource/FHIRInsurancePlan/FHIRInsurancePlanCost.php',
    'OpenEMR\\FHIR\\R4\\FHIRDomainResource\\FHIRInvoice' => 'OpenEMR/FHIR/R4/FHIRDomainResource/FHIRInvoice.php',
    'OpenEMR\\FHIR\\R4\\FHIRResource\\FHIRInvoice\\FHIRInvoiceParticipant' => 'OpenEMR/FHIR/R4/FHIRResource/FHIRInvoice/FHIRInvoiceParticipant.php',
    'OpenEMR\\FHIR\\R4\\FHIRResource\\FHIRInvoice\\FHIRInvoiceLineItem' => 'OpenEMR/FHIR/R4/FHIRResource/FHIRInvoice/FHIRInvoiceLineItem.php',
    'OpenEMR\\FHIR\\R4\\FHIRResource\\FHIRInvoice\\FHIRInvoicePriceComponent' => 'OpenEMR/FHIR/R4/FHIRResource/FHIRInvoice/FHIRInvoicePriceComponent.php',
    'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRInvoiceStatus' => 'OpenEMR/FHIR/R4/FHIRElement/FHIRInvoiceStatus.php',
    'OpenEMR\\FHIR\\R4\\FHIRDomainResource\\FHIRLibrary' => 'OpenEMR/FHIR/R4/FHIRDomainResource/FHIRLibrary.php',
    'OpenEMR\\FHIR\\R4\\FHIRDomainResource\\FHIRLinkage' => 'OpenEMR/FHIR/R4/FHIRDomainResource/FHIRLinkage.php',
    'OpenEMR\\FHIR\\R4\\FHIRResource\\FHIRLinkage\\FHIRLinkageItem' => 'OpenEMR/FHIR/R4/FHIRResource/FHIRLinkage/FHIRLinkageItem.php',
    'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRLinkageType' => 'OpenEMR/FHIR/R4/FHIRElement/FHIRLinkageType.php',
    'OpenEMR\\FHIR\\R4\\FHIRDomainResource\\FHIRList' => 'OpenEMR/FHIR/R4/FHIRDomainResource/FHIRList.php',
    'OpenEMR\\FHIR\\R4\\FHIRResource\\FHIRList\\FHIRListEntry' => 'OpenEMR/FHIR/R4/FHIRResource/FHIRList/FHIRListEntry.php',
    'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRListStatus' => 'OpenEMR/FHIR/R4/FHIRElement/FHIRListStatus.php',
    'OpenEMR\\FHIR\\R4\\FHIRDomainResource\\FHIRLocation' => 'OpenEMR/FHIR/R4/FHIRDomainResource/FHIRLocation.php',
    'OpenEMR\\FHIR\\R4\\FHIRResource\\FHIRLocation\\FHIRLocationPosition' => 'OpenEMR/FHIR/R4/FHIRResource/FHIRLocation/FHIRLocationPosition.php',
    'OpenEMR\\FHIR\\R4\\FHIRResource\\FHIRLocation\\FHIRLocationHoursOfOperation' => 'OpenEMR/FHIR/R4/FHIRResource/FHIRLocation/FHIRLocationHoursOfOperation.php',
    'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRLocationMode' => 'OpenEMR/FHIR/R4/FHIRElement/FHIRLocationMode.php',
    'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRLocationStatus' => 'OpenEMR/FHIR/R4/FHIRElement/FHIRLocationStatus.php',
    'OpenEMR\\FHIR\\R4\\FHIRDomainResource\\FHIRMeasure' => 'OpenEMR/FHIR/R4/FHIRDomainResource/FHIRMeasure.php',
    'OpenEMR\\FHIR\\R4\\FHIRResource\\FHIRMeasure\\FHIRMeasureGroup' => 'OpenEMR/FHIR/R4/FHIRResource/FHIRMeasure/FHIRMeasureGroup.php',
    'OpenEMR\\FHIR\\R4\\FHIRResource\\FHIRMeasure\\FHIRMeasurePopulation' => 'OpenEMR/FHIR/R4/FHIRResource/FHIRMeasure/FHIRMeasurePopulation.php',
    'OpenEMR\\FHIR\\R4\\FHIRResource\\FHIRMeasure\\FHIRMeasureStratifier' => 'OpenEMR/FHIR/R4/FHIRResource/FHIRMeasure/FHIRMeasureStratifier.php',
    'OpenEMR\\FHIR\\R4\\FHIRResource\\FHIRMeasure\\FHIRMeasureComponent' => 'OpenEMR/FHIR/R4/FHIRResource/FHIRMeasure/FHIRMeasureComponent.php',
    'OpenEMR\\FHIR\\R4\\FHIRResource\\FHIRMeasure\\FHIRMeasureSupplementalData' => 'OpenEMR/FHIR/R4/FHIRResource/FHIRMeasure/FHIRMeasureSupplementalData.php',
    'OpenEMR\\FHIR\\R4\\FHIRDomainResource\\FHIRMeasureReport' => 'OpenEMR/FHIR/R4/FHIRDomainResource/FHIRMeasureReport.php',
    'OpenEMR\\FHIR\\R4\\FHIRResource\\FHIRMeasureReport\\FHIRMeasureReportGroup' => 'OpenEMR/FHIR/R4/FHIRResource/FHIRMeasureReport/FHIRMeasureReportGroup.php',
    'OpenEMR\\FHIR\\R4\\FHIRResource\\FHIRMeasureReport\\FHIRMeasureReportPopulation' => 'OpenEMR/FHIR/R4/FHIRResource/FHIRMeasureReport/FHIRMeasureReportPopulation.php',
    'OpenEMR\\FHIR\\R4\\FHIRResource\\FHIRMeasureReport\\FHIRMeasureReportStratifier' => 'OpenEMR/FHIR/R4/FHIRResource/FHIRMeasureReport/FHIRMeasureReportStratifier.php',
    'OpenEMR\\FHIR\\R4\\FHIRResource\\FHIRMeasureReport\\FHIRMeasureReportStratum' => 'OpenEMR/FHIR/R4/FHIRResource/FHIRMeasureReport/FHIRMeasureReportStratum.php',
    'OpenEMR\\FHIR\\R4\\FHIRResource\\FHIRMeasureReport\\FHIRMeasureReportComponent' => 'OpenEMR/FHIR/R4/FHIRResource/FHIRMeasureReport/FHIRMeasureReportComponent.php',
    'OpenEMR\\FHIR\\R4\\FHIRResource\\FHIRMeasureReport\\FHIRMeasureReportPopulation1' => 'OpenEMR/FHIR/R4/FHIRResource/FHIRMeasureReport/FHIRMeasureReportPopulation1.php',
    'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRMeasureReportStatus' => 'OpenEMR/FHIR/R4/FHIRElement/FHIRMeasureReportStatus.php',
    'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRMeasureReportType' => 'OpenEMR/FHIR/R4/FHIRElement/FHIRMeasureReportType.php',
    'OpenEMR\\FHIR\\R4\\FHIRDomainResource\\FHIRMedia' => 'OpenEMR/FHIR/R4/FHIRDomainResource/FHIRMedia.php',
    'OpenEMR\\FHIR\\R4\\FHIRDomainResource\\FHIRMedication' => 'OpenEMR/FHIR/R4/FHIRDomainResource/FHIRMedication.php',
    'OpenEMR\\FHIR\\R4\\FHIRResource\\FHIRMedication\\FHIRMedicationIngredient' => 'OpenEMR/FHIR/R4/FHIRResource/FHIRMedication/FHIRMedicationIngredient.php',
    'OpenEMR\\FHIR\\R4\\FHIRResource\\FHIRMedication\\FHIRMedicationBatch' => 'OpenEMR/FHIR/R4/FHIRResource/FHIRMedication/FHIRMedicationBatch.php',
    'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRMedicationStatusCodes' => 'OpenEMR/FHIR/R4/FHIRElement/FHIRMedicationStatusCodes.php',
    'OpenEMR\\FHIR\\R4\\FHIRDomainResource\\FHIRMedicationAdministration' => 'OpenEMR/FHIR/R4/FHIRDomainResource/FHIRMedicationAdministration.php',
    'OpenEMR\\FHIR\\R4\\FHIRResource\\FHIRMedicationAdministration\\FHIRMedicationAdministrationPerformer' => 'OpenEMR/FHIR/R4/FHIRResource/FHIRMedicationAdministration/FHIRMedicationAdministrationPerformer.php',
    'OpenEMR\\FHIR\\R4\\FHIRResource\\FHIRMedicationAdministration\\FHIRMedicationAdministrationDosage' => 'OpenEMR/FHIR/R4/FHIRResource/FHIRMedicationAdministration/FHIRMedicationAdministrationDosage.php',
    'OpenEMR\\FHIR\\R4\\FHIRDomainResource\\FHIRMedicationDispense' => 'OpenEMR/FHIR/R4/FHIRDomainResource/FHIRMedicationDispense.php',
    'OpenEMR\\FHIR\\R4\\FHIRResource\\FHIRMedicationDispense\\FHIRMedicationDispensePerformer' => 'OpenEMR/FHIR/R4/FHIRResource/FHIRMedicationDispense/FHIRMedicationDispensePerformer.php',
    'OpenEMR\\FHIR\\R4\\FHIRResource\\FHIRMedicationDispense\\FHIRMedicationDispenseSubstitution' => 'OpenEMR/FHIR/R4/FHIRResource/FHIRMedicationDispense/FHIRMedicationDispenseSubstitution.php',
    'OpenEMR\\FHIR\\R4\\FHIRDomainResource\\FHIRMedicationKnowledge' => 'OpenEMR/FHIR/R4/FHIRDomainResource/FHIRMedicationKnowledge.php',
    'OpenEMR\\FHIR\\R4\\FHIRResource\\FHIRMedicationKnowledge\\FHIRMedicationKnowledgeRelatedMedicationKnowledge' => 'OpenEMR/FHIR/R4/FHIRResource/FHIRMedicationKnowledge/FHIRMedicationKnowledgeRelatedMedicationKnowledge.php',
    'OpenEMR\\FHIR\\R4\\FHIRResource\\FHIRMedicationKnowledge\\FHIRMedicationKnowledgeMonograph' => 'OpenEMR/FHIR/R4/FHIRResource/FHIRMedicationKnowledge/FHIRMedicationKnowledgeMonograph.php',
    'OpenEMR\\FHIR\\R4\\FHIRResource\\FHIRMedicationKnowledge\\FHIRMedicationKnowledgeIngredient' => 'OpenEMR/FHIR/R4/FHIRResource/FHIRMedicationKnowledge/FHIRMedicationKnowledgeIngredient.php',
    'OpenEMR\\FHIR\\R4\\FHIRResource\\FHIRMedicationKnowledge\\FHIRMedicationKnowledgeCost' => 'OpenEMR/FHIR/R4/FHIRResource/FHIRMedicationKnowledge/FHIRMedicationKnowledgeCost.php',
    'OpenEMR\\FHIR\\R4\\FHIRResource\\FHIRMedicationKnowledge\\FHIRMedicationKnowledgeMonitoringProgram' => 'OpenEMR/FHIR/R4/FHIRResource/FHIRMedicationKnowledge/FHIRMedicationKnowledgeMonitoringProgram.php',
    'OpenEMR\\FHIR\\R4\\FHIRResource\\FHIRMedicationKnowledge\\FHIRMedicationKnowledgeAdministrationGuidelines' => 'OpenEMR/FHIR/R4/FHIRResource/FHIRMedicationKnowledge/FHIRMedicationKnowledgeAdministrationGuidelines.php',
    'OpenEMR\\FHIR\\R4\\FHIRResource\\FHIRMedicationKnowledge\\FHIRMedicationKnowledgeDosage' => 'OpenEMR/FHIR/R4/FHIRResource/FHIRMedicationKnowledge/FHIRMedicationKnowledgeDosage.php',
    'OpenEMR\\FHIR\\R4\\FHIRResource\\FHIRMedicationKnowledge\\FHIRMedicationKnowledgePatientCharacteristics' => 'OpenEMR/FHIR/R4/FHIRResource/FHIRMedicationKnowledge/FHIRMedicationKnowledgePatientCharacteristics.php',
    'OpenEMR\\FHIR\\R4\\FHIRResource\\FHIRMedicationKnowledge\\FHIRMedicationKnowledgeMedicineClassification' => 'OpenEMR/FHIR/R4/FHIRResource/FHIRMedicationKnowledge/FHIRMedicationKnowledgeMedicineClassification.php',
    'OpenEMR\\FHIR\\R4\\FHIRResource\\FHIRMedicationKnowledge\\FHIRMedicationKnowledgePackaging' => 'OpenEMR/FHIR/R4/FHIRResource/FHIRMedicationKnowledge/FHIRMedicationKnowledgePackaging.php',
    'OpenEMR\\FHIR\\R4\\FHIRResource\\FHIRMedicationKnowledge\\FHIRMedicationKnowledgeDrugCharacteristic' => 'OpenEMR/FHIR/R4/FHIRResource/FHIRMedicationKnowledge/FHIRMedicationKnowledgeDrugCharacteristic.php',
    'OpenEMR\\FHIR\\R4\\FHIRResource\\FHIRMedicationKnowledge\\FHIRMedicationKnowledgeRegulatory' => 'OpenEMR/FHIR/R4/FHIRResource/FHIRMedicationKnowledge/FHIRMedicationKnowledgeRegulatory.php',
    'OpenEMR\\FHIR\\R4\\FHIRResource\\FHIRMedicationKnowledge\\FHIRMedicationKnowledgeSubstitution' => 'OpenEMR/FHIR/R4/FHIRResource/FHIRMedicationKnowledge/FHIRMedicationKnowledgeSubstitution.php',
    'OpenEMR\\FHIR\\R4\\FHIRResource\\FHIRMedicationKnowledge\\FHIRMedicationKnowledgeSchedule' => 'OpenEMR/FHIR/R4/FHIRResource/FHIRMedicationKnowledge/FHIRMedicationKnowledgeSchedule.php',
    'OpenEMR\\FHIR\\R4\\FHIRResource\\FHIRMedicationKnowledge\\FHIRMedicationKnowledgeMaxDispense' => 'OpenEMR/FHIR/R4/FHIRResource/FHIRMedicationKnowledge/FHIRMedicationKnowledgeMaxDispense.php',
    'OpenEMR\\FHIR\\R4\\FHIRResource\\FHIRMedicationKnowledge\\FHIRMedicationKnowledgeKinetics' => 'OpenEMR/FHIR/R4/FHIRResource/FHIRMedicationKnowledge/FHIRMedicationKnowledgeKinetics.php',
    'OpenEMR\\FHIR\\R4\\FHIRDomainResource\\FHIRMedicationRequest' => 'OpenEMR/FHIR/R4/FHIRDomainResource/FHIRMedicationRequest.php',
    'OpenEMR\\FHIR\\R4\\FHIRResource\\FHIRMedicationRequest\\FHIRMedicationRequestDispenseRequest' => 'OpenEMR/FHIR/R4/FHIRResource/FHIRMedicationRequest/FHIRMedicationRequestDispenseRequest.php',
    'OpenEMR\\FHIR\\R4\\FHIRResource\\FHIRMedicationRequest\\FHIRMedicationRequestInitialFill' => 'OpenEMR/FHIR/R4/FHIRResource/FHIRMedicationRequest/FHIRMedicationRequestInitialFill.php',
    'OpenEMR\\FHIR\\R4\\FHIRResource\\FHIRMedicationRequest\\FHIRMedicationRequestSubstitution' => 'OpenEMR/FHIR/R4/FHIRResource/FHIRMedicationRequest/FHIRMedicationRequestSubstitution.php',
    'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRMedicationrequestStatus' => 'OpenEMR/FHIR/R4/FHIRElement/FHIRMedicationrequestStatus.php',
    'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRMedicationRequestIntent' => 'OpenEMR/FHIR/R4/FHIRElement/FHIRMedicationRequestIntent.php',
    'OpenEMR\\FHIR\\R4\\FHIRDomainResource\\FHIRMedicationStatement' => 'OpenEMR/FHIR/R4/FHIRDomainResource/FHIRMedicationStatement.php',
    'OpenEMR\\FHIR\\R4\\FHIRDomainResource\\FHIRMedicinalProduct' => 'OpenEMR/FHIR/R4/FHIRDomainResource/FHIRMedicinalProduct.php',
    'OpenEMR\\FHIR\\R4\\FHIRResource\\FHIRMedicinalProduct\\FHIRMedicinalProductName' => 'OpenEMR/FHIR/R4/FHIRResource/FHIRMedicinalProduct/FHIRMedicinalProductName.php',
    'OpenEMR\\FHIR\\R4\\FHIRResource\\FHIRMedicinalProduct\\FHIRMedicinalProductNamePart' => 'OpenEMR/FHIR/R4/FHIRResource/FHIRMedicinalProduct/FHIRMedicinalProductNamePart.php',
    'OpenEMR\\FHIR\\R4\\FHIRResource\\FHIRMedicinalProduct\\FHIRMedicinalProductCountryLanguage' => 'OpenEMR/FHIR/R4/FHIRResource/FHIRMedicinalProduct/FHIRMedicinalProductCountryLanguage.php',
    'OpenEMR\\FHIR\\R4\\FHIRResource\\FHIRMedicinalProduct\\FHIRMedicinalProductManufacturingBusinessOperation' => 'OpenEMR/FHIR/R4/FHIRResource/FHIRMedicinalProduct/FHIRMedicinalProductManufacturingBusinessOperation.php',
    'OpenEMR\\FHIR\\R4\\FHIRResource\\FHIRMedicinalProduct\\FHIRMedicinalProductSpecialDesignation' => 'OpenEMR/FHIR/R4/FHIRResource/FHIRMedicinalProduct/FHIRMedicinalProductSpecialDesignation.php',
    'OpenEMR\\FHIR\\R4\\FHIRDomainResource\\FHIRMedicinalProductAuthorization' => 'OpenEMR/FHIR/R4/FHIRDomainResource/FHIRMedicinalProductAuthorization.php',
    'OpenEMR\\FHIR\\R4\\FHIRResource\\FHIRMedicinalProductAuthorization\\FHIRMedicinalProductAuthorizationJurisdictionalAuthorization' => 'OpenEMR/FHIR/R4/FHIRResource/FHIRMedicinalProductAuthorization/FHIRMedicinalProductAuthorizationJurisdictionalAuthorization.php',
    'OpenEMR\\FHIR\\R4\\FHIRResource\\FHIRMedicinalProductAuthorization\\FHIRMedicinalProductAuthorizationProcedure' => 'OpenEMR/FHIR/R4/FHIRResource/FHIRMedicinalProductAuthorization/FHIRMedicinalProductAuthorizationProcedure.php',
    'OpenEMR\\FHIR\\R4\\FHIRDomainResource\\FHIRMedicinalProductContraindication' => 'OpenEMR/FHIR/R4/FHIRDomainResource/FHIRMedicinalProductContraindication.php',
    'OpenEMR\\FHIR\\R4\\FHIRResource\\FHIRMedicinalProductContraindication\\FHIRMedicinalProductContraindicationOtherTherapy' => 'OpenEMR/FHIR/R4/FHIRResource/FHIRMedicinalProductContraindication/FHIRMedicinalProductContraindicationOtherTherapy.php',
    'OpenEMR\\FHIR\\R4\\FHIRDomainResource\\FHIRMedicinalProductIndication' => 'OpenEMR/FHIR/R4/FHIRDomainResource/FHIRMedicinalProductIndication.php',
    'OpenEMR\\FHIR\\R4\\FHIRResource\\FHIRMedicinalProductIndication\\FHIRMedicinalProductIndicationOtherTherapy' => 'OpenEMR/FHIR/R4/FHIRResource/FHIRMedicinalProductIndication/FHIRMedicinalProductIndicationOtherTherapy.php',
    'OpenEMR\\FHIR\\R4\\FHIRDomainResource\\FHIRMedicinalProductIngredient' => 'OpenEMR/FHIR/R4/FHIRDomainResource/FHIRMedicinalProductIngredient.php',
    'OpenEMR\\FHIR\\R4\\FHIRResource\\FHIRMedicinalProductIngredient\\FHIRMedicinalProductIngredientSpecifiedSubstance' => 'OpenEMR/FHIR/R4/FHIRResource/FHIRMedicinalProductIngredient/FHIRMedicinalProductIngredientSpecifiedSubstance.php',
    'OpenEMR\\FHIR\\R4\\FHIRResource\\FHIRMedicinalProductIngredient\\FHIRMedicinalProductIngredientStrength' => 'OpenEMR/FHIR/R4/FHIRResource/FHIRMedicinalProductIngredient/FHIRMedicinalProductIngredientStrength.php',
    'OpenEMR\\FHIR\\R4\\FHIRResource\\FHIRMedicinalProductIngredient\\FHIRMedicinalProductIngredientReferenceStrength' => 'OpenEMR/FHIR/R4/FHIRResource/FHIRMedicinalProductIngredient/FHIRMedicinalProductIngredientReferenceStrength.php',
    'OpenEMR\\FHIR\\R4\\FHIRResource\\FHIRMedicinalProductIngredient\\FHIRMedicinalProductIngredientSubstance' => 'OpenEMR/FHIR/R4/FHIRResource/FHIRMedicinalProductIngredient/FHIRMedicinalProductIngredientSubstance.php',
    'OpenEMR\\FHIR\\R4\\FHIRDomainResource\\FHIRMedicinalProductInteraction' => 'OpenEMR/FHIR/R4/FHIRDomainResource/FHIRMedicinalProductInteraction.php',
    'OpenEMR\\FHIR\\R4\\FHIRResource\\FHIRMedicinalProductInteraction\\FHIRMedicinalProductInteractionInteractant' => 'OpenEMR/FHIR/R4/FHIRResource/FHIRMedicinalProductInteraction/FHIRMedicinalProductInteractionInteractant.php',
    'OpenEMR\\FHIR\\R4\\FHIRDomainResource\\FHIRMedicinalProductManufactured' => 'OpenEMR/FHIR/R4/FHIRDomainResource/FHIRMedicinalProductManufactured.php',
    'OpenEMR\\FHIR\\R4\\FHIRDomainResource\\FHIRMedicinalProductPackaged' => 'OpenEMR/FHIR/R4/FHIRDomainResource/FHIRMedicinalProductPackaged.php',
    'OpenEMR\\FHIR\\R4\\FHIRResource\\FHIRMedicinalProductPackaged\\FHIRMedicinalProductPackagedBatchIdentifier' => 'OpenEMR/FHIR/R4/FHIRResource/FHIRMedicinalProductPackaged/FHIRMedicinalProductPackagedBatchIdentifier.php',
    'OpenEMR\\FHIR\\R4\\FHIRResource\\FHIRMedicinalProductPackaged\\FHIRMedicinalProductPackagedPackageItem' => 'OpenEMR/FHIR/R4/FHIRResource/FHIRMedicinalProductPackaged/FHIRMedicinalProductPackagedPackageItem.php',
    'OpenEMR\\FHIR\\R4\\FHIRDomainResource\\FHIRMedicinalProductPharmaceutical' => 'OpenEMR/FHIR/R4/FHIRDomainResource/FHIRMedicinalProductPharmaceutical.php',
    'OpenEMR\\FHIR\\R4\\FHIRResource\\FHIRMedicinalProductPharmaceutical\\FHIRMedicinalProductPharmaceuticalCharacteristics' => 'OpenEMR/FHIR/R4/FHIRResource/FHIRMedicinalProductPharmaceutical/FHIRMedicinalProductPharmaceuticalCharacteristics.php',
    'OpenEMR\\FHIR\\R4\\FHIRResource\\FHIRMedicinalProductPharmaceutical\\FHIRMedicinalProductPharmaceuticalRouteOfAdministration' => 'OpenEMR/FHIR/R4/FHIRResource/FHIRMedicinalProductPharmaceutical/FHIRMedicinalProductPharmaceuticalRouteOfAdministration.php',
    'OpenEMR\\FHIR\\R4\\FHIRResource\\FHIRMedicinalProductPharmaceutical\\FHIRMedicinalProductPharmaceuticalTargetSpecies' => 'OpenEMR/FHIR/R4/FHIRResource/FHIRMedicinalProductPharmaceutical/FHIRMedicinalProductPharmaceuticalTargetSpecies.php',
    'OpenEMR\\FHIR\\R4\\FHIRResource\\FHIRMedicinalProductPharmaceutical\\FHIRMedicinalProductPharmaceuticalWithdrawalPeriod' => 'OpenEMR/FHIR/R4/FHIRResource/FHIRMedicinalProductPharmaceutical/FHIRMedicinalProductPharmaceuticalWithdrawalPeriod.php',
    'OpenEMR\\FHIR\\R4\\FHIRDomainResource\\FHIRMedicinalProductUndesirableEffect' => 'OpenEMR/FHIR/R4/FHIRDomainResource/FHIRMedicinalProductUndesirableEffect.php',
    'OpenEMR\\FHIR\\R4\\FHIRDomainResource\\FHIRMessageDefinition' => 'OpenEMR/FHIR/R4/FHIRDomainResource/FHIRMessageDefinition.php',
    'OpenEMR\\FHIR\\R4\\FHIRResource\\FHIRMessageDefinition\\FHIRMessageDefinitionFocus' => 'OpenEMR/FHIR/R4/FHIRResource/FHIRMessageDefinition/FHIRMessageDefinitionFocus.php',
    'OpenEMR\\FHIR\\R4\\FHIRResource\\FHIRMessageDefinition\\FHIRMessageDefinitionAllowedResponse' => 'OpenEMR/FHIR/R4/FHIRResource/FHIRMessageDefinition/FHIRMessageDefinitionAllowedResponse.php',
    'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRMessageSignificanceCategory' => 'OpenEMR/FHIR/R4/FHIRElement/FHIRMessageSignificanceCategory.php',
    'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRMessageheaderResponseRequest' => 'OpenEMR/FHIR/R4/FHIRElement/FHIRMessageheaderResponseRequest.php',
    'OpenEMR\\FHIR\\R4\\FHIRDomainResource\\FHIRMessageHeader' => 'OpenEMR/FHIR/R4/FHIRDomainResource/FHIRMessageHeader.php',
    'OpenEMR\\FHIR\\R4\\FHIRResource\\FHIRMessageHeader\\FHIRMessageHeaderDestination' => 'OpenEMR/FHIR/R4/FHIRResource/FHIRMessageHeader/FHIRMessageHeaderDestination.php',
    'OpenEMR\\FHIR\\R4\\FHIRResource\\FHIRMessageHeader\\FHIRMessageHeaderSource' => 'OpenEMR/FHIR/R4/FHIRResource/FHIRMessageHeader/FHIRMessageHeaderSource.php',
    'OpenEMR\\FHIR\\R4\\FHIRResource\\FHIRMessageHeader\\FHIRMessageHeaderResponse' => 'OpenEMR/FHIR/R4/FHIRResource/FHIRMessageHeader/FHIRMessageHeaderResponse.php',
    'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRResponseType' => 'OpenEMR/FHIR/R4/FHIRElement/FHIRResponseType.php',
    'OpenEMR\\FHIR\\R4\\FHIRDomainResource\\FHIRMolecularSequence' => 'OpenEMR/FHIR/R4/FHIRDomainResource/FHIRMolecularSequence.php',
    'OpenEMR\\FHIR\\R4\\FHIRResource\\FHIRMolecularSequence\\FHIRMolecularSequenceReferenceSeq' => 'OpenEMR/FHIR/R4/FHIRResource/FHIRMolecularSequence/FHIRMolecularSequenceReferenceSeq.php',
    'OpenEMR\\FHIR\\R4\\FHIRResource\\FHIRMolecularSequence\\FHIRMolecularSequenceVariant' => 'OpenEMR/FHIR/R4/FHIRResource/FHIRMolecularSequence/FHIRMolecularSequenceVariant.php',
    'OpenEMR\\FHIR\\R4\\FHIRResource\\FHIRMolecularSequence\\FHIRMolecularSequenceQuality' => 'OpenEMR/FHIR/R4/FHIRResource/FHIRMolecularSequence/FHIRMolecularSequenceQuality.php',
    'OpenEMR\\FHIR\\R4\\FHIRResource\\FHIRMolecularSequence\\FHIRMolecularSequenceRoc' => 'OpenEMR/FHIR/R4/FHIRResource/FHIRMolecularSequence/FHIRMolecularSequenceRoc.php',
    'OpenEMR\\FHIR\\R4\\FHIRResource\\FHIRMolecularSequence\\FHIRMolecularSequenceRepository' => 'OpenEMR/FHIR/R4/FHIRResource/FHIRMolecularSequence/FHIRMolecularSequenceRepository.php',
    'OpenEMR\\FHIR\\R4\\FHIRResource\\FHIRMolecularSequence\\FHIRMolecularSequenceStructureVariant' => 'OpenEMR/FHIR/R4/FHIRResource/FHIRMolecularSequence/FHIRMolecularSequenceStructureVariant.php',
    'OpenEMR\\FHIR\\R4\\FHIRResource\\FHIRMolecularSequence\\FHIRMolecularSequenceOuter' => 'OpenEMR/FHIR/R4/FHIRResource/FHIRMolecularSequence/FHIRMolecularSequenceOuter.php',
    'OpenEMR\\FHIR\\R4\\FHIRResource\\FHIRMolecularSequence\\FHIRMolecularSequenceInner' => 'OpenEMR/FHIR/R4/FHIRResource/FHIRMolecularSequence/FHIRMolecularSequenceInner.php',
    'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRStrandType' => 'OpenEMR/FHIR/R4/FHIRElement/FHIRStrandType.php',
    'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIROrientationType' => 'OpenEMR/FHIR/R4/FHIRElement/FHIROrientationType.php',
    'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRRepositoryType' => 'OpenEMR/FHIR/R4/FHIRElement/FHIRRepositoryType.php',
    'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRQualityType' => 'OpenEMR/FHIR/R4/FHIRElement/FHIRQualityType.php',
    'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRSequenceType' => 'OpenEMR/FHIR/R4/FHIRElement/FHIRSequenceType.php',
    'OpenEMR\\FHIR\\R4\\FHIRDomainResource\\FHIRNamingSystem' => 'OpenEMR/FHIR/R4/FHIRDomainResource/FHIRNamingSystem.php',
    'OpenEMR\\FHIR\\R4\\FHIRResource\\FHIRNamingSystem\\FHIRNamingSystemUniqueId' => 'OpenEMR/FHIR/R4/FHIRResource/FHIRNamingSystem/FHIRNamingSystemUniqueId.php',
    'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRNamingSystemIdentifierType' => 'OpenEMR/FHIR/R4/FHIRElement/FHIRNamingSystemIdentifierType.php',
    'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRNamingSystemType' => 'OpenEMR/FHIR/R4/FHIRElement/FHIRNamingSystemType.php',
    'OpenEMR\\FHIR\\R4\\FHIRDomainResource\\FHIRNutritionOrder' => 'OpenEMR/FHIR/R4/FHIRDomainResource/FHIRNutritionOrder.php',
    'OpenEMR\\FHIR\\R4\\FHIRResource\\FHIRNutritionOrder\\FHIRNutritionOrderOralDiet' => 'OpenEMR/FHIR/R4/FHIRResource/FHIRNutritionOrder/FHIRNutritionOrderOralDiet.php',
    'OpenEMR\\FHIR\\R4\\FHIRResource\\FHIRNutritionOrder\\FHIRNutritionOrderNutrient' => 'OpenEMR/FHIR/R4/FHIRResource/FHIRNutritionOrder/FHIRNutritionOrderNutrient.php',
    'OpenEMR\\FHIR\\R4\\FHIRResource\\FHIRNutritionOrder\\FHIRNutritionOrderTexture' => 'OpenEMR/FHIR/R4/FHIRResource/FHIRNutritionOrder/FHIRNutritionOrderTexture.php',
    'OpenEMR\\FHIR\\R4\\FHIRResource\\FHIRNutritionOrder\\FHIRNutritionOrderSupplement' => 'OpenEMR/FHIR/R4/FHIRResource/FHIRNutritionOrder/FHIRNutritionOrderSupplement.php',
    'OpenEMR\\FHIR\\R4\\FHIRResource\\FHIRNutritionOrder\\FHIRNutritionOrderEnteralFormula' => 'OpenEMR/FHIR/R4/FHIRResource/FHIRNutritionOrder/FHIRNutritionOrderEnteralFormula.php',
    'OpenEMR\\FHIR\\R4\\FHIRResource\\FHIRNutritionOrder\\FHIRNutritionOrderAdministration' => 'OpenEMR/FHIR/R4/FHIRResource/FHIRNutritionOrder/FHIRNutritionOrderAdministration.php',
    'OpenEMR\\FHIR\\R4\\FHIRDomainResource\\FHIRObservation' => 'OpenEMR/FHIR/R4/FHIRDomainResource/FHIRObservation.php',
    'OpenEMR\\FHIR\\R4\\FHIRResource\\FHIRObservation\\FHIRObservationReferenceRange' => 'OpenEMR/FHIR/R4/FHIRResource/FHIRObservation/FHIRObservationReferenceRange.php',
    'OpenEMR\\FHIR\\R4\\FHIRResource\\FHIRObservation\\FHIRObservationComponent' => 'OpenEMR/FHIR/R4/FHIRResource/FHIRObservation/FHIRObservationComponent.php',
    'OpenEMR\\FHIR\\R4\\FHIRDomainResource\\FHIRObservationDefinition' => 'OpenEMR/FHIR/R4/FHIRDomainResource/FHIRObservationDefinition.php',
    'OpenEMR\\FHIR\\R4\\FHIRResource\\FHIRObservationDefinition\\FHIRObservationDefinitionQuantitativeDetails' => 'OpenEMR/FHIR/R4/FHIRResource/FHIRObservationDefinition/FHIRObservationDefinitionQuantitativeDetails.php',
    'OpenEMR\\FHIR\\R4\\FHIRResource\\FHIRObservationDefinition\\FHIRObservationDefinitionQualifiedInterval' => 'OpenEMR/FHIR/R4/FHIRResource/FHIRObservationDefinition/FHIRObservationDefinitionQualifiedInterval.php',
    'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRObservationDataType' => 'OpenEMR/FHIR/R4/FHIRElement/FHIRObservationDataType.php',
    'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRObservationRangeCategory' => 'OpenEMR/FHIR/R4/FHIRElement/FHIRObservationRangeCategory.php',
    'OpenEMR\\FHIR\\R4\\FHIRDomainResource\\FHIROperationDefinition' => 'OpenEMR/FHIR/R4/FHIRDomainResource/FHIROperationDefinition.php',
    'OpenEMR\\FHIR\\R4\\FHIRResource\\FHIROperationDefinition\\FHIROperationDefinitionParameter' => 'OpenEMR/FHIR/R4/FHIRResource/FHIROperationDefinition/FHIROperationDefinitionParameter.php',
    'OpenEMR\\FHIR\\R4\\FHIRResource\\FHIROperationDefinition\\FHIROperationDefinitionBinding' => 'OpenEMR/FHIR/R4/FHIRResource/FHIROperationDefinition/FHIROperationDefinitionBinding.php',
    'OpenEMR\\FHIR\\R4\\FHIRResource\\FHIROperationDefinition\\FHIROperationDefinitionReferencedFrom' => 'OpenEMR/FHIR/R4/FHIRResource/FHIROperationDefinition/FHIROperationDefinitionReferencedFrom.php',
    'OpenEMR\\FHIR\\R4\\FHIRResource\\FHIROperationDefinition\\FHIROperationDefinitionOverload' => 'OpenEMR/FHIR/R4/FHIRResource/FHIROperationDefinition/FHIROperationDefinitionOverload.php',
    'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIROperationParameterUse' => 'OpenEMR/FHIR/R4/FHIRElement/FHIROperationParameterUse.php',
    'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIROperationKind' => 'OpenEMR/FHIR/R4/FHIRElement/FHIROperationKind.php',
    'OpenEMR\\FHIR\\R4\\FHIRDomainResource\\FHIROperationOutcome' => 'OpenEMR/FHIR/R4/FHIRDomainResource/FHIROperationOutcome.php',
    'OpenEMR\\FHIR\\R4\\FHIRResource\\FHIROperationOutcome\\FHIROperationOutcomeIssue' => 'OpenEMR/FHIR/R4/FHIRResource/FHIROperationOutcome/FHIROperationOutcomeIssue.php',
    'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRIssueType' => 'OpenEMR/FHIR/R4/FHIRElement/FHIRIssueType.php',
    'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRIssueSeverity' => 'OpenEMR/FHIR/R4/FHIRElement/FHIRIssueSeverity.php',
    'OpenEMR\\FHIR\\R4\\FHIRDomainResource\\FHIROrganization' => 'OpenEMR/FHIR/R4/FHIRDomainResource/FHIROrganization.php',
    'OpenEMR\\FHIR\\R4\\FHIRResource\\FHIROrganization\\FHIROrganizationContact' => 'OpenEMR/FHIR/R4/FHIRResource/FHIROrganization/FHIROrganizationContact.php',
    'OpenEMR\\FHIR\\R4\\FHIRDomainResource\\FHIROrganizationAffiliation' => 'OpenEMR/FHIR/R4/FHIRDomainResource/FHIROrganizationAffiliation.php',
    'OpenEMR\\FHIR\\R4\\FHIRResource\\FHIRParameters' => 'OpenEMR/FHIR/R4/FHIRResource/FHIRParameters.php',
    'OpenEMR\\FHIR\\R4\\FHIRResource\\FHIRParameters\\FHIRParametersParameter' => 'OpenEMR/FHIR/R4/FHIRResource/FHIRParameters/FHIRParametersParameter.php',
    'OpenEMR\\FHIR\\R4\\FHIRDomainResource\\FHIRPatient' => 'OpenEMR/FHIR/R4/FHIRDomainResource/FHIRPatient.php',
    'OpenEMR\\FHIR\\R4\\FHIRResource\\FHIRPatient\\FHIRPatientContact' => 'OpenEMR/FHIR/R4/FHIRResource/FHIRPatient/FHIRPatientContact.php',
    'OpenEMR\\FHIR\\R4\\FHIRResource\\FHIRPatient\\FHIRPatientCommunication' => 'OpenEMR/FHIR/R4/FHIRResource/FHIRPatient/FHIRPatientCommunication.php',
    'OpenEMR\\FHIR\\R4\\FHIRResource\\FHIRPatient\\FHIRPatientLink' => 'OpenEMR/FHIR/R4/FHIRResource/FHIRPatient/FHIRPatientLink.php',
    'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRLinkType' => 'OpenEMR/FHIR/R4/FHIRElement/FHIRLinkType.php',
    'OpenEMR\\FHIR\\R4\\FHIRDomainResource\\FHIRPaymentNotice' => 'OpenEMR/FHIR/R4/FHIRDomainResource/FHIRPaymentNotice.php',
    'OpenEMR\\FHIR\\R4\\FHIRDomainResource\\FHIRPaymentReconciliation' => 'OpenEMR/FHIR/R4/FHIRDomainResource/FHIRPaymentReconciliation.php',
    'OpenEMR\\FHIR\\R4\\FHIRResource\\FHIRPaymentReconciliation\\FHIRPaymentReconciliationDetail' => 'OpenEMR/FHIR/R4/FHIRResource/FHIRPaymentReconciliation/FHIRPaymentReconciliationDetail.php',
    'OpenEMR\\FHIR\\R4\\FHIRResource\\FHIRPaymentReconciliation\\FHIRPaymentReconciliationProcessNote' => 'OpenEMR/FHIR/R4/FHIRResource/FHIRPaymentReconciliation/FHIRPaymentReconciliationProcessNote.php',
    'OpenEMR\\FHIR\\R4\\FHIRDomainResource\\FHIRPerson' => 'OpenEMR/FHIR/R4/FHIRDomainResource/FHIRPerson.php',
    'OpenEMR\\FHIR\\R4\\FHIRResource\\FHIRPerson\\FHIRPersonLink' => 'OpenEMR/FHIR/R4/FHIRResource/FHIRPerson/FHIRPersonLink.php',
    'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRIdentityAssuranceLevel' => 'OpenEMR/FHIR/R4/FHIRElement/FHIRIdentityAssuranceLevel.php',
    'OpenEMR\\FHIR\\R4\\FHIRDomainResource\\FHIRPlanDefinition' => 'OpenEMR/FHIR/R4/FHIRDomainResource/FHIRPlanDefinition.php',
    'OpenEMR\\FHIR\\R4\\FHIRResource\\FHIRPlanDefinition\\FHIRPlanDefinitionGoal' => 'OpenEMR/FHIR/R4/FHIRResource/FHIRPlanDefinition/FHIRPlanDefinitionGoal.php',
    'OpenEMR\\FHIR\\R4\\FHIRResource\\FHIRPlanDefinition\\FHIRPlanDefinitionTarget' => 'OpenEMR/FHIR/R4/FHIRResource/FHIRPlanDefinition/FHIRPlanDefinitionTarget.php',
    'OpenEMR\\FHIR\\R4\\FHIRResource\\FHIRPlanDefinition\\FHIRPlanDefinitionAction' => 'OpenEMR/FHIR/R4/FHIRResource/FHIRPlanDefinition/FHIRPlanDefinitionAction.php',
    'OpenEMR\\FHIR\\R4\\FHIRResource\\FHIRPlanDefinition\\FHIRPlanDefinitionCondition' => 'OpenEMR/FHIR/R4/FHIRResource/FHIRPlanDefinition/FHIRPlanDefinitionCondition.php',
    'OpenEMR\\FHIR\\R4\\FHIRResource\\FHIRPlanDefinition\\FHIRPlanDefinitionRelatedAction' => 'OpenEMR/FHIR/R4/FHIRResource/FHIRPlanDefinition/FHIRPlanDefinitionRelatedAction.php',
    'OpenEMR\\FHIR\\R4\\FHIRResource\\FHIRPlanDefinition\\FHIRPlanDefinitionParticipant' => 'OpenEMR/FHIR/R4/FHIRResource/FHIRPlanDefinition/FHIRPlanDefinitionParticipant.php',
    'OpenEMR\\FHIR\\R4\\FHIRResource\\FHIRPlanDefinition\\FHIRPlanDefinitionDynamicValue' => 'OpenEMR/FHIR/R4/FHIRResource/FHIRPlanDefinition/FHIRPlanDefinitionDynamicValue.php',
    'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRActionRequiredBehavior' => 'OpenEMR/FHIR/R4/FHIRElement/FHIRActionRequiredBehavior.php',
    'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRActionRelationshipType' => 'OpenEMR/FHIR/R4/FHIRElement/FHIRActionRelationshipType.php',
    'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRActionGroupingBehavior' => 'OpenEMR/FHIR/R4/FHIRElement/FHIRActionGroupingBehavior.php',
    'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRActionSelectionBehavior' => 'OpenEMR/FHIR/R4/FHIRElement/FHIRActionSelectionBehavior.php',
    'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRActionCardinalityBehavior' => 'OpenEMR/FHIR/R4/FHIRElement/FHIRActionCardinalityBehavior.php',
    'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRActionPrecheckBehavior' => 'OpenEMR/FHIR/R4/FHIRElement/FHIRActionPrecheckBehavior.php',
    'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRActionConditionKind' => 'OpenEMR/FHIR/R4/FHIRElement/FHIRActionConditionKind.php',
    'OpenEMR\\FHIR\\R4\\FHIRDomainResource\\FHIRPractitioner' => 'OpenEMR/FHIR/R4/FHIRDomainResource/FHIRPractitioner.php',
    'OpenEMR\\FHIR\\R4\\FHIRResource\\FHIRPractitioner\\FHIRPractitionerQualification' => 'OpenEMR/FHIR/R4/FHIRResource/FHIRPractitioner/FHIRPractitionerQualification.php',
    'OpenEMR\\FHIR\\R4\\FHIRDomainResource\\FHIRPractitionerRole' => 'OpenEMR/FHIR/R4/FHIRDomainResource/FHIRPractitionerRole.php',
    'OpenEMR\\FHIR\\R4\\FHIRResource\\FHIRPractitionerRole\\FHIRPractitionerRoleAvailableTime' => 'OpenEMR/FHIR/R4/FHIRResource/FHIRPractitionerRole/FHIRPractitionerRoleAvailableTime.php',
    'OpenEMR\\FHIR\\R4\\FHIRResource\\FHIRPractitionerRole\\FHIRPractitionerRoleNotAvailable' => 'OpenEMR/FHIR/R4/FHIRResource/FHIRPractitionerRole/FHIRPractitionerRoleNotAvailable.php',
    'OpenEMR\\FHIR\\R4\\FHIRDomainResource\\FHIRProcedure' => 'OpenEMR/FHIR/R4/FHIRDomainResource/FHIRProcedure.php',
    'OpenEMR\\FHIR\\R4\\FHIRResource\\FHIRProcedure\\FHIRProcedurePerformer' => 'OpenEMR/FHIR/R4/FHIRResource/FHIRProcedure/FHIRProcedurePerformer.php',
    'OpenEMR\\FHIR\\R4\\FHIRResource\\FHIRProcedure\\FHIRProcedureFocalDevice' => 'OpenEMR/FHIR/R4/FHIRResource/FHIRProcedure/FHIRProcedureFocalDevice.php',
    'OpenEMR\\FHIR\\R4\\FHIRDomainResource\\FHIRProvenance' => 'OpenEMR/FHIR/R4/FHIRDomainResource/FHIRProvenance.php',
    'OpenEMR\\FHIR\\R4\\FHIRResource\\FHIRProvenance\\FHIRProvenanceAgent' => 'OpenEMR/FHIR/R4/FHIRResource/FHIRProvenance/FHIRProvenanceAgent.php',
    'OpenEMR\\FHIR\\R4\\FHIRResource\\FHIRProvenance\\FHIRProvenanceEntity' => 'OpenEMR/FHIR/R4/FHIRResource/FHIRProvenance/FHIRProvenanceEntity.php',
    'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRProvenanceEntityRole' => 'OpenEMR/FHIR/R4/FHIRElement/FHIRProvenanceEntityRole.php',
    'OpenEMR\\FHIR\\R4\\FHIRDomainResource\\FHIRQuestionnaire' => 'OpenEMR/FHIR/R4/FHIRDomainResource/FHIRQuestionnaire.php',
    'OpenEMR\\FHIR\\R4\\FHIRResource\\FHIRQuestionnaire\\FHIRQuestionnaireItem' => 'OpenEMR/FHIR/R4/FHIRResource/FHIRQuestionnaire/FHIRQuestionnaireItem.php',
    'OpenEMR\\FHIR\\R4\\FHIRResource\\FHIRQuestionnaire\\FHIRQuestionnaireEnableWhen' => 'OpenEMR/FHIR/R4/FHIRResource/FHIRQuestionnaire/FHIRQuestionnaireEnableWhen.php',
    'OpenEMR\\FHIR\\R4\\FHIRResource\\FHIRQuestionnaire\\FHIRQuestionnaireAnswerOption' => 'OpenEMR/FHIR/R4/FHIRResource/FHIRQuestionnaire/FHIRQuestionnaireAnswerOption.php',
    'OpenEMR\\FHIR\\R4\\FHIRResource\\FHIRQuestionnaire\\FHIRQuestionnaireInitial' => 'OpenEMR/FHIR/R4/FHIRResource/FHIRQuestionnaire/FHIRQuestionnaireInitial.php',
    'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRQuestionnaireItemType' => 'OpenEMR/FHIR/R4/FHIRElement/FHIRQuestionnaireItemType.php',
    'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIREnableWhenBehavior' => 'OpenEMR/FHIR/R4/FHIRElement/FHIREnableWhenBehavior.php',
    'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRQuestionnaireItemOperator' => 'OpenEMR/FHIR/R4/FHIRElement/FHIRQuestionnaireItemOperator.php',
    'OpenEMR\\FHIR\\R4\\FHIRDomainResource\\FHIRQuestionnaireResponse' => 'OpenEMR/FHIR/R4/FHIRDomainResource/FHIRQuestionnaireResponse.php',
    'OpenEMR\\FHIR\\R4\\FHIRResource\\FHIRQuestionnaireResponse\\FHIRQuestionnaireResponseItem' => 'OpenEMR/FHIR/R4/FHIRResource/FHIRQuestionnaireResponse/FHIRQuestionnaireResponseItem.php',
    'OpenEMR\\FHIR\\R4\\FHIRResource\\FHIRQuestionnaireResponse\\FHIRQuestionnaireResponseAnswer' => 'OpenEMR/FHIR/R4/FHIRResource/FHIRQuestionnaireResponse/FHIRQuestionnaireResponseAnswer.php',
    'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRQuestionnaireResponseStatus' => 'OpenEMR/FHIR/R4/FHIRElement/FHIRQuestionnaireResponseStatus.php',
    'OpenEMR\\FHIR\\R4\\FHIRDomainResource\\FHIRRelatedPerson' => 'OpenEMR/FHIR/R4/FHIRDomainResource/FHIRRelatedPerson.php',
    'OpenEMR\\FHIR\\R4\\FHIRResource\\FHIRRelatedPerson\\FHIRRelatedPersonCommunication' => 'OpenEMR/FHIR/R4/FHIRResource/FHIRRelatedPerson/FHIRRelatedPersonCommunication.php',
    'OpenEMR\\FHIR\\R4\\FHIRDomainResource\\FHIRRequestGroup' => 'OpenEMR/FHIR/R4/FHIRDomainResource/FHIRRequestGroup.php',
    'OpenEMR\\FHIR\\R4\\FHIRResource\\FHIRRequestGroup\\FHIRRequestGroupAction' => 'OpenEMR/FHIR/R4/FHIRResource/FHIRRequestGroup/FHIRRequestGroupAction.php',
    'OpenEMR\\FHIR\\R4\\FHIRResource\\FHIRRequestGroup\\FHIRRequestGroupCondition' => 'OpenEMR/FHIR/R4/FHIRResource/FHIRRequestGroup/FHIRRequestGroupCondition.php',
    'OpenEMR\\FHIR\\R4\\FHIRResource\\FHIRRequestGroup\\FHIRRequestGroupRelatedAction' => 'OpenEMR/FHIR/R4/FHIRResource/FHIRRequestGroup/FHIRRequestGroupRelatedAction.php',
    'OpenEMR\\FHIR\\R4\\FHIRDomainResource\\FHIRResearchDefinition' => 'OpenEMR/FHIR/R4/FHIRDomainResource/FHIRResearchDefinition.php',
    'OpenEMR\\FHIR\\R4\\FHIRDomainResource\\FHIRResearchElementDefinition' => 'OpenEMR/FHIR/R4/FHIRDomainResource/FHIRResearchElementDefinition.php',
    'OpenEMR\\FHIR\\R4\\FHIRResource\\FHIRResearchElementDefinition\\FHIRResearchElementDefinitionCharacteristic' => 'OpenEMR/FHIR/R4/FHIRResource/FHIRResearchElementDefinition/FHIRResearchElementDefinitionCharacteristic.php',
    'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRResearchElementType' => 'OpenEMR/FHIR/R4/FHIRElement/FHIRResearchElementType.php',
    'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRVariableType' => 'OpenEMR/FHIR/R4/FHIRElement/FHIRVariableType.php',
    'OpenEMR\\FHIR\\R4\\FHIRDomainResource\\FHIRResearchStudy' => 'OpenEMR/FHIR/R4/FHIRDomainResource/FHIRResearchStudy.php',
    'OpenEMR\\FHIR\\R4\\FHIRResource\\FHIRResearchStudy\\FHIRResearchStudyArm' => 'OpenEMR/FHIR/R4/FHIRResource/FHIRResearchStudy/FHIRResearchStudyArm.php',
    'OpenEMR\\FHIR\\R4\\FHIRResource\\FHIRResearchStudy\\FHIRResearchStudyObjective' => 'OpenEMR/FHIR/R4/FHIRResource/FHIRResearchStudy/FHIRResearchStudyObjective.php',
    'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRResearchStudyStatus' => 'OpenEMR/FHIR/R4/FHIRElement/FHIRResearchStudyStatus.php',
    'OpenEMR\\FHIR\\R4\\FHIRDomainResource\\FHIRResearchSubject' => 'OpenEMR/FHIR/R4/FHIRDomainResource/FHIRResearchSubject.php',
    'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRResearchSubjectStatus' => 'OpenEMR/FHIR/R4/FHIRElement/FHIRResearchSubjectStatus.php',
    'OpenEMR\\FHIR\\R4\\FHIRDomainResource\\FHIRRiskAssessment' => 'OpenEMR/FHIR/R4/FHIRDomainResource/FHIRRiskAssessment.php',
    'OpenEMR\\FHIR\\R4\\FHIRResource\\FHIRRiskAssessment\\FHIRRiskAssessmentPrediction' => 'OpenEMR/FHIR/R4/FHIRResource/FHIRRiskAssessment/FHIRRiskAssessmentPrediction.php',
    'OpenEMR\\FHIR\\R4\\FHIRDomainResource\\FHIRRiskEvidenceSynthesis' => 'OpenEMR/FHIR/R4/FHIRDomainResource/FHIRRiskEvidenceSynthesis.php',
    'OpenEMR\\FHIR\\R4\\FHIRResource\\FHIRRiskEvidenceSynthesis\\FHIRRiskEvidenceSynthesisSampleSize' => 'OpenEMR/FHIR/R4/FHIRResource/FHIRRiskEvidenceSynthesis/FHIRRiskEvidenceSynthesisSampleSize.php',
    'OpenEMR\\FHIR\\R4\\FHIRResource\\FHIRRiskEvidenceSynthesis\\FHIRRiskEvidenceSynthesisRiskEstimate' => 'OpenEMR/FHIR/R4/FHIRResource/FHIRRiskEvidenceSynthesis/FHIRRiskEvidenceSynthesisRiskEstimate.php',
    'OpenEMR\\FHIR\\R4\\FHIRResource\\FHIRRiskEvidenceSynthesis\\FHIRRiskEvidenceSynthesisPrecisionEstimate' => 'OpenEMR/FHIR/R4/FHIRResource/FHIRRiskEvidenceSynthesis/FHIRRiskEvidenceSynthesisPrecisionEstimate.php',
    'OpenEMR\\FHIR\\R4\\FHIRResource\\FHIRRiskEvidenceSynthesis\\FHIRRiskEvidenceSynthesisCertainty' => 'OpenEMR/FHIR/R4/FHIRResource/FHIRRiskEvidenceSynthesis/FHIRRiskEvidenceSynthesisCertainty.php',
    'OpenEMR\\FHIR\\R4\\FHIRResource\\FHIRRiskEvidenceSynthesis\\FHIRRiskEvidenceSynthesisCertaintySubcomponent' => 'OpenEMR/FHIR/R4/FHIRResource/FHIRRiskEvidenceSynthesis/FHIRRiskEvidenceSynthesisCertaintySubcomponent.php',
    'OpenEMR\\FHIR\\R4\\FHIRDomainResource\\FHIRSchedule' => 'OpenEMR/FHIR/R4/FHIRDomainResource/FHIRSchedule.php',
    'OpenEMR\\FHIR\\R4\\FHIRDomainResource\\FHIRSearchParameter' => 'OpenEMR/FHIR/R4/FHIRDomainResource/FHIRSearchParameter.php',
    'OpenEMR\\FHIR\\R4\\FHIRResource\\FHIRSearchParameter\\FHIRSearchParameterComponent' => 'OpenEMR/FHIR/R4/FHIRResource/FHIRSearchParameter/FHIRSearchParameterComponent.php',
    'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRXPathUsageType' => 'OpenEMR/FHIR/R4/FHIRElement/FHIRXPathUsageType.php',
    'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRSearchModifierCode' => 'OpenEMR/FHIR/R4/FHIRElement/FHIRSearchModifierCode.php',
    'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRSearchComparator' => 'OpenEMR/FHIR/R4/FHIRElement/FHIRSearchComparator.php',
    'OpenEMR\\FHIR\\R4\\FHIRDomainResource\\FHIRServiceRequest' => 'OpenEMR/FHIR/R4/FHIRDomainResource/FHIRServiceRequest.php',
    'OpenEMR\\FHIR\\R4\\FHIRDomainResource\\FHIRSlot' => 'OpenEMR/FHIR/R4/FHIRDomainResource/FHIRSlot.php',
    'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRSlotStatus' => 'OpenEMR/FHIR/R4/FHIRElement/FHIRSlotStatus.php',
    'OpenEMR\\FHIR\\R4\\FHIRDomainResource\\FHIRSpecimen' => 'OpenEMR/FHIR/R4/FHIRDomainResource/FHIRSpecimen.php',
    'OpenEMR\\FHIR\\R4\\FHIRResource\\FHIRSpecimen\\FHIRSpecimenCollection' => 'OpenEMR/FHIR/R4/FHIRResource/FHIRSpecimen/FHIRSpecimenCollection.php',
    'OpenEMR\\FHIR\\R4\\FHIRResource\\FHIRSpecimen\\FHIRSpecimenProcessing' => 'OpenEMR/FHIR/R4/FHIRResource/FHIRSpecimen/FHIRSpecimenProcessing.php',
    'OpenEMR\\FHIR\\R4\\FHIRResource\\FHIRSpecimen\\FHIRSpecimenContainer' => 'OpenEMR/FHIR/R4/FHIRResource/FHIRSpecimen/FHIRSpecimenContainer.php',
    'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRSpecimenStatus' => 'OpenEMR/FHIR/R4/FHIRElement/FHIRSpecimenStatus.php',
    'OpenEMR\\FHIR\\R4\\FHIRDomainResource\\FHIRSpecimenDefinition' => 'OpenEMR/FHIR/R4/FHIRDomainResource/FHIRSpecimenDefinition.php',
    'OpenEMR\\FHIR\\R4\\FHIRResource\\FHIRSpecimenDefinition\\FHIRSpecimenDefinitionTypeTested' => 'OpenEMR/FHIR/R4/FHIRResource/FHIRSpecimenDefinition/FHIRSpecimenDefinitionTypeTested.php',
    'OpenEMR\\FHIR\\R4\\FHIRResource\\FHIRSpecimenDefinition\\FHIRSpecimenDefinitionContainer' => 'OpenEMR/FHIR/R4/FHIRResource/FHIRSpecimenDefinition/FHIRSpecimenDefinitionContainer.php',
    'OpenEMR\\FHIR\\R4\\FHIRResource\\FHIRSpecimenDefinition\\FHIRSpecimenDefinitionAdditive' => 'OpenEMR/FHIR/R4/FHIRResource/FHIRSpecimenDefinition/FHIRSpecimenDefinitionAdditive.php',
    'OpenEMR\\FHIR\\R4\\FHIRResource\\FHIRSpecimenDefinition\\FHIRSpecimenDefinitionHandling' => 'OpenEMR/FHIR/R4/FHIRResource/FHIRSpecimenDefinition/FHIRSpecimenDefinitionHandling.php',
    'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRSpecimenContainedPreference' => 'OpenEMR/FHIR/R4/FHIRElement/FHIRSpecimenContainedPreference.php',
    'OpenEMR\\FHIR\\R4\\FHIRDomainResource\\FHIRStructureDefinition' => 'OpenEMR/FHIR/R4/FHIRDomainResource/FHIRStructureDefinition.php',
    'OpenEMR\\FHIR\\R4\\FHIRResource\\FHIRStructureDefinition\\FHIRStructureDefinitionMapping' => 'OpenEMR/FHIR/R4/FHIRResource/FHIRStructureDefinition/FHIRStructureDefinitionMapping.php',
    'OpenEMR\\FHIR\\R4\\FHIRResource\\FHIRStructureDefinition\\FHIRStructureDefinitionContext' => 'OpenEMR/FHIR/R4/FHIRResource/FHIRStructureDefinition/FHIRStructureDefinitionContext.php',
    'OpenEMR\\FHIR\\R4\\FHIRResource\\FHIRStructureDefinition\\FHIRStructureDefinitionSnapshot' => 'OpenEMR/FHIR/R4/FHIRResource/FHIRStructureDefinition/FHIRStructureDefinitionSnapshot.php',
    'OpenEMR\\FHIR\\R4\\FHIRResource\\FHIRStructureDefinition\\FHIRStructureDefinitionDifferential' => 'OpenEMR/FHIR/R4/FHIRResource/FHIRStructureDefinition/FHIRStructureDefinitionDifferential.php',
    'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRStructureDefinitionKind' => 'OpenEMR/FHIR/R4/FHIRElement/FHIRStructureDefinitionKind.php',
    'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRTypeDerivationRule' => 'OpenEMR/FHIR/R4/FHIRElement/FHIRTypeDerivationRule.php',
    'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRExtensionContextType' => 'OpenEMR/FHIR/R4/FHIRElement/FHIRExtensionContextType.php',
    'OpenEMR\\FHIR\\R4\\FHIRDomainResource\\FHIRStructureMap' => 'OpenEMR/FHIR/R4/FHIRDomainResource/FHIRStructureMap.php',
    'OpenEMR\\FHIR\\R4\\FHIRResource\\FHIRStructureMap\\FHIRStructureMapStructure' => 'OpenEMR/FHIR/R4/FHIRResource/FHIRStructureMap/FHIRStructureMapStructure.php',
    'OpenEMR\\FHIR\\R4\\FHIRResource\\FHIRStructureMap\\FHIRStructureMapGroup' => 'OpenEMR/FHIR/R4/FHIRResource/FHIRStructureMap/FHIRStructureMapGroup.php',
    'OpenEMR\\FHIR\\R4\\FHIRResource\\FHIRStructureMap\\FHIRStructureMapInput' => 'OpenEMR/FHIR/R4/FHIRResource/FHIRStructureMap/FHIRStructureMapInput.php',
    'OpenEMR\\FHIR\\R4\\FHIRResource\\FHIRStructureMap\\FHIRStructureMapRule' => 'OpenEMR/FHIR/R4/FHIRResource/FHIRStructureMap/FHIRStructureMapRule.php',
    'OpenEMR\\FHIR\\R4\\FHIRResource\\FHIRStructureMap\\FHIRStructureMapSource' => 'OpenEMR/FHIR/R4/FHIRResource/FHIRStructureMap/FHIRStructureMapSource.php',
    'OpenEMR\\FHIR\\R4\\FHIRResource\\FHIRStructureMap\\FHIRStructureMapTarget' => 'OpenEMR/FHIR/R4/FHIRResource/FHIRStructureMap/FHIRStructureMapTarget.php',
    'OpenEMR\\FHIR\\R4\\FHIRResource\\FHIRStructureMap\\FHIRStructureMapParameter' => 'OpenEMR/FHIR/R4/FHIRResource/FHIRStructureMap/FHIRStructureMapParameter.php',
    'OpenEMR\\FHIR\\R4\\FHIRResource\\FHIRStructureMap\\FHIRStructureMapDependent' => 'OpenEMR/FHIR/R4/FHIRResource/FHIRStructureMap/FHIRStructureMapDependent.php',
    'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRStructureMapInputMode' => 'OpenEMR/FHIR/R4/FHIRElement/FHIRStructureMapInputMode.php',
    'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRStructureMapContextType' => 'OpenEMR/FHIR/R4/FHIRElement/FHIRStructureMapContextType.php',
    'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRStructureMapTargetListMode' => 'OpenEMR/FHIR/R4/FHIRElement/FHIRStructureMapTargetListMode.php',
    'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRStructureMapTransform' => 'OpenEMR/FHIR/R4/FHIRElement/FHIRStructureMapTransform.php',
    'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRStructureMapSourceListMode' => 'OpenEMR/FHIR/R4/FHIRElement/FHIRStructureMapSourceListMode.php',
    'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRStructureMapGroupTypeMode' => 'OpenEMR/FHIR/R4/FHIRElement/FHIRStructureMapGroupTypeMode.php',
    'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRStructureMapModelMode' => 'OpenEMR/FHIR/R4/FHIRElement/FHIRStructureMapModelMode.php',
    'OpenEMR\\FHIR\\R4\\FHIRDomainResource\\FHIRSubscription' => 'OpenEMR/FHIR/R4/FHIRDomainResource/FHIRSubscription.php',
    'OpenEMR\\FHIR\\R4\\FHIRResource\\FHIRSubscription\\FHIRSubscriptionChannel' => 'OpenEMR/FHIR/R4/FHIRResource/FHIRSubscription/FHIRSubscriptionChannel.php',
    'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRSubscriptionStatus' => 'OpenEMR/FHIR/R4/FHIRElement/FHIRSubscriptionStatus.php',
    'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRSubscriptionChannelType' => 'OpenEMR/FHIR/R4/FHIRElement/FHIRSubscriptionChannelType.php',
    'OpenEMR\\FHIR\\R4\\FHIRDomainResource\\FHIRSubstance' => 'OpenEMR/FHIR/R4/FHIRDomainResource/FHIRSubstance.php',
    'OpenEMR\\FHIR\\R4\\FHIRResource\\FHIRSubstance\\FHIRSubstanceInstance' => 'OpenEMR/FHIR/R4/FHIRResource/FHIRSubstance/FHIRSubstanceInstance.php',
    'OpenEMR\\FHIR\\R4\\FHIRResource\\FHIRSubstance\\FHIRSubstanceIngredient' => 'OpenEMR/FHIR/R4/FHIRResource/FHIRSubstance/FHIRSubstanceIngredient.php',
    'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRFHIRSubstanceStatus' => 'OpenEMR/FHIR/R4/FHIRElement/FHIRFHIRSubstanceStatus.php',
    'OpenEMR\\FHIR\\R4\\FHIRDomainResource\\FHIRSubstanceNucleicAcid' => 'OpenEMR/FHIR/R4/FHIRDomainResource/FHIRSubstanceNucleicAcid.php',
    'OpenEMR\\FHIR\\R4\\FHIRResource\\FHIRSubstanceNucleicAcid\\FHIRSubstanceNucleicAcidSubunit' => 'OpenEMR/FHIR/R4/FHIRResource/FHIRSubstanceNucleicAcid/FHIRSubstanceNucleicAcidSubunit.php',
    'OpenEMR\\FHIR\\R4\\FHIRResource\\FHIRSubstanceNucleicAcid\\FHIRSubstanceNucleicAcidLinkage' => 'OpenEMR/FHIR/R4/FHIRResource/FHIRSubstanceNucleicAcid/FHIRSubstanceNucleicAcidLinkage.php',
    'OpenEMR\\FHIR\\R4\\FHIRResource\\FHIRSubstanceNucleicAcid\\FHIRSubstanceNucleicAcidSugar' => 'OpenEMR/FHIR/R4/FHIRResource/FHIRSubstanceNucleicAcid/FHIRSubstanceNucleicAcidSugar.php',
    'OpenEMR\\FHIR\\R4\\FHIRDomainResource\\FHIRSubstancePolymer' => 'OpenEMR/FHIR/R4/FHIRDomainResource/FHIRSubstancePolymer.php',
    'OpenEMR\\FHIR\\R4\\FHIRResource\\FHIRSubstancePolymer\\FHIRSubstancePolymerMonomerSet' => 'OpenEMR/FHIR/R4/FHIRResource/FHIRSubstancePolymer/FHIRSubstancePolymerMonomerSet.php',
    'OpenEMR\\FHIR\\R4\\FHIRResource\\FHIRSubstancePolymer\\FHIRSubstancePolymerStartingMaterial' => 'OpenEMR/FHIR/R4/FHIRResource/FHIRSubstancePolymer/FHIRSubstancePolymerStartingMaterial.php',
    'OpenEMR\\FHIR\\R4\\FHIRResource\\FHIRSubstancePolymer\\FHIRSubstancePolymerRepeat' => 'OpenEMR/FHIR/R4/FHIRResource/FHIRSubstancePolymer/FHIRSubstancePolymerRepeat.php',
    'OpenEMR\\FHIR\\R4\\FHIRResource\\FHIRSubstancePolymer\\FHIRSubstancePolymerRepeatUnit' => 'OpenEMR/FHIR/R4/FHIRResource/FHIRSubstancePolymer/FHIRSubstancePolymerRepeatUnit.php',
    'OpenEMR\\FHIR\\R4\\FHIRResource\\FHIRSubstancePolymer\\FHIRSubstancePolymerDegreeOfPolymerisation' => 'OpenEMR/FHIR/R4/FHIRResource/FHIRSubstancePolymer/FHIRSubstancePolymerDegreeOfPolymerisation.php',
    'OpenEMR\\FHIR\\R4\\FHIRResource\\FHIRSubstancePolymer\\FHIRSubstancePolymerStructuralRepresentation' => 'OpenEMR/FHIR/R4/FHIRResource/FHIRSubstancePolymer/FHIRSubstancePolymerStructuralRepresentation.php',
    'OpenEMR\\FHIR\\R4\\FHIRDomainResource\\FHIRSubstanceProtein' => 'OpenEMR/FHIR/R4/FHIRDomainResource/FHIRSubstanceProtein.php',
    'OpenEMR\\FHIR\\R4\\FHIRResource\\FHIRSubstanceProtein\\FHIRSubstanceProteinSubunit' => 'OpenEMR/FHIR/R4/FHIRResource/FHIRSubstanceProtein/FHIRSubstanceProteinSubunit.php',
    'OpenEMR\\FHIR\\R4\\FHIRDomainResource\\FHIRSubstanceReferenceInformation' => 'OpenEMR/FHIR/R4/FHIRDomainResource/FHIRSubstanceReferenceInformation.php',
    'OpenEMR\\FHIR\\R4\\FHIRResource\\FHIRSubstanceReferenceInformation\\FHIRSubstanceReferenceInformationGene' => 'OpenEMR/FHIR/R4/FHIRResource/FHIRSubstanceReferenceInformation/FHIRSubstanceReferenceInformationGene.php',
    'OpenEMR\\FHIR\\R4\\FHIRResource\\FHIRSubstanceReferenceInformation\\FHIRSubstanceReferenceInformationGeneElement' => 'OpenEMR/FHIR/R4/FHIRResource/FHIRSubstanceReferenceInformation/FHIRSubstanceReferenceInformationGeneElement.php',
    'OpenEMR\\FHIR\\R4\\FHIRResource\\FHIRSubstanceReferenceInformation\\FHIRSubstanceReferenceInformationClassification' => 'OpenEMR/FHIR/R4/FHIRResource/FHIRSubstanceReferenceInformation/FHIRSubstanceReferenceInformationClassification.php',
    'OpenEMR\\FHIR\\R4\\FHIRResource\\FHIRSubstanceReferenceInformation\\FHIRSubstanceReferenceInformationTarget' => 'OpenEMR/FHIR/R4/FHIRResource/FHIRSubstanceReferenceInformation/FHIRSubstanceReferenceInformationTarget.php',
    'OpenEMR\\FHIR\\R4\\FHIRDomainResource\\FHIRSubstanceSourceMaterial' => 'OpenEMR/FHIR/R4/FHIRDomainResource/FHIRSubstanceSourceMaterial.php',
    'OpenEMR\\FHIR\\R4\\FHIRResource\\FHIRSubstanceSourceMaterial\\FHIRSubstanceSourceMaterialFractionDescription' => 'OpenEMR/FHIR/R4/FHIRResource/FHIRSubstanceSourceMaterial/FHIRSubstanceSourceMaterialFractionDescription.php',
    'OpenEMR\\FHIR\\R4\\FHIRResource\\FHIRSubstanceSourceMaterial\\FHIRSubstanceSourceMaterialOrganism' => 'OpenEMR/FHIR/R4/FHIRResource/FHIRSubstanceSourceMaterial/FHIRSubstanceSourceMaterialOrganism.php',
    'OpenEMR\\FHIR\\R4\\FHIRResource\\FHIRSubstanceSourceMaterial\\FHIRSubstanceSourceMaterialAuthor' => 'OpenEMR/FHIR/R4/FHIRResource/FHIRSubstanceSourceMaterial/FHIRSubstanceSourceMaterialAuthor.php',
    'OpenEMR\\FHIR\\R4\\FHIRResource\\FHIRSubstanceSourceMaterial\\FHIRSubstanceSourceMaterialHybrid' => 'OpenEMR/FHIR/R4/FHIRResource/FHIRSubstanceSourceMaterial/FHIRSubstanceSourceMaterialHybrid.php',
    'OpenEMR\\FHIR\\R4\\FHIRResource\\FHIRSubstanceSourceMaterial\\FHIRSubstanceSourceMaterialOrganismGeneral' => 'OpenEMR/FHIR/R4/FHIRResource/FHIRSubstanceSourceMaterial/FHIRSubstanceSourceMaterialOrganismGeneral.php',
    'OpenEMR\\FHIR\\R4\\FHIRResource\\FHIRSubstanceSourceMaterial\\FHIRSubstanceSourceMaterialPartDescription' => 'OpenEMR/FHIR/R4/FHIRResource/FHIRSubstanceSourceMaterial/FHIRSubstanceSourceMaterialPartDescription.php',
    'OpenEMR\\FHIR\\R4\\FHIRDomainResource\\FHIRSubstanceSpecification' => 'OpenEMR/FHIR/R4/FHIRDomainResource/FHIRSubstanceSpecification.php',
    'OpenEMR\\FHIR\\R4\\FHIRResource\\FHIRSubstanceSpecification\\FHIRSubstanceSpecificationMoiety' => 'OpenEMR/FHIR/R4/FHIRResource/FHIRSubstanceSpecification/FHIRSubstanceSpecificationMoiety.php',
    'OpenEMR\\FHIR\\R4\\FHIRResource\\FHIRSubstanceSpecification\\FHIRSubstanceSpecificationProperty' => 'OpenEMR/FHIR/R4/FHIRResource/FHIRSubstanceSpecification/FHIRSubstanceSpecificationProperty.php',
    'OpenEMR\\FHIR\\R4\\FHIRResource\\FHIRSubstanceSpecification\\FHIRSubstanceSpecificationStructure' => 'OpenEMR/FHIR/R4/FHIRResource/FHIRSubstanceSpecification/FHIRSubstanceSpecificationStructure.php',
    'OpenEMR\\FHIR\\R4\\FHIRResource\\FHIRSubstanceSpecification\\FHIRSubstanceSpecificationIsotope' => 'OpenEMR/FHIR/R4/FHIRResource/FHIRSubstanceSpecification/FHIRSubstanceSpecificationIsotope.php',
    'OpenEMR\\FHIR\\R4\\FHIRResource\\FHIRSubstanceSpecification\\FHIRSubstanceSpecificationMolecularWeight' => 'OpenEMR/FHIR/R4/FHIRResource/FHIRSubstanceSpecification/FHIRSubstanceSpecificationMolecularWeight.php',
    'OpenEMR\\FHIR\\R4\\FHIRResource\\FHIRSubstanceSpecification\\FHIRSubstanceSpecificationRepresentation' => 'OpenEMR/FHIR/R4/FHIRResource/FHIRSubstanceSpecification/FHIRSubstanceSpecificationRepresentation.php',
    'OpenEMR\\FHIR\\R4\\FHIRResource\\FHIRSubstanceSpecification\\FHIRSubstanceSpecificationCode' => 'OpenEMR/FHIR/R4/FHIRResource/FHIRSubstanceSpecification/FHIRSubstanceSpecificationCode.php',
    'OpenEMR\\FHIR\\R4\\FHIRResource\\FHIRSubstanceSpecification\\FHIRSubstanceSpecificationName' => 'OpenEMR/FHIR/R4/FHIRResource/FHIRSubstanceSpecification/FHIRSubstanceSpecificationName.php',
    'OpenEMR\\FHIR\\R4\\FHIRResource\\FHIRSubstanceSpecification\\FHIRSubstanceSpecificationOfficial' => 'OpenEMR/FHIR/R4/FHIRResource/FHIRSubstanceSpecification/FHIRSubstanceSpecificationOfficial.php',
    'OpenEMR\\FHIR\\R4\\FHIRResource\\FHIRSubstanceSpecification\\FHIRSubstanceSpecificationRelationship' => 'OpenEMR/FHIR/R4/FHIRResource/FHIRSubstanceSpecification/FHIRSubstanceSpecificationRelationship.php',
    'OpenEMR\\FHIR\\R4\\FHIRDomainResource\\FHIRSupplyDelivery' => 'OpenEMR/FHIR/R4/FHIRDomainResource/FHIRSupplyDelivery.php',
    'OpenEMR\\FHIR\\R4\\FHIRResource\\FHIRSupplyDelivery\\FHIRSupplyDeliverySuppliedItem' => 'OpenEMR/FHIR/R4/FHIRResource/FHIRSupplyDelivery/FHIRSupplyDeliverySuppliedItem.php',
    'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRSupplyDeliveryStatus' => 'OpenEMR/FHIR/R4/FHIRElement/FHIRSupplyDeliveryStatus.php',
    'OpenEMR\\FHIR\\R4\\FHIRDomainResource\\FHIRSupplyRequest' => 'OpenEMR/FHIR/R4/FHIRDomainResource/FHIRSupplyRequest.php',
    'OpenEMR\\FHIR\\R4\\FHIRResource\\FHIRSupplyRequest\\FHIRSupplyRequestParameter' => 'OpenEMR/FHIR/R4/FHIRResource/FHIRSupplyRequest/FHIRSupplyRequestParameter.php',
    'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRSupplyRequestStatus' => 'OpenEMR/FHIR/R4/FHIRElement/FHIRSupplyRequestStatus.php',
    'OpenEMR\\FHIR\\R4\\FHIRDomainResource\\FHIRTask' => 'OpenEMR/FHIR/R4/FHIRDomainResource/FHIRTask.php',
    'OpenEMR\\FHIR\\R4\\FHIRResource\\FHIRTask\\FHIRTaskRestriction' => 'OpenEMR/FHIR/R4/FHIRResource/FHIRTask/FHIRTaskRestriction.php',
    'OpenEMR\\FHIR\\R4\\FHIRResource\\FHIRTask\\FHIRTaskInput' => 'OpenEMR/FHIR/R4/FHIRResource/FHIRTask/FHIRTaskInput.php',
    'OpenEMR\\FHIR\\R4\\FHIRResource\\FHIRTask\\FHIRTaskOutput' => 'OpenEMR/FHIR/R4/FHIRResource/FHIRTask/FHIRTaskOutput.php',
    'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRTaskStatus' => 'OpenEMR/FHIR/R4/FHIRElement/FHIRTaskStatus.php',
    'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRTaskIntent' => 'OpenEMR/FHIR/R4/FHIRElement/FHIRTaskIntent.php',
    'OpenEMR\\FHIR\\R4\\FHIRDomainResource\\FHIRTerminologyCapabilities' => 'OpenEMR/FHIR/R4/FHIRDomainResource/FHIRTerminologyCapabilities.php',
    'OpenEMR\\FHIR\\R4\\FHIRResource\\FHIRTerminologyCapabilities\\FHIRTerminologyCapabilitiesSoftware' => 'OpenEMR/FHIR/R4/FHIRResource/FHIRTerminologyCapabilities/FHIRTerminologyCapabilitiesSoftware.php',
    'OpenEMR\\FHIR\\R4\\FHIRResource\\FHIRTerminologyCapabilities\\FHIRTerminologyCapabilitiesImplementation' => 'OpenEMR/FHIR/R4/FHIRResource/FHIRTerminologyCapabilities/FHIRTerminologyCapabilitiesImplementation.php',
    'OpenEMR\\FHIR\\R4\\FHIRResource\\FHIRTerminologyCapabilities\\FHIRTerminologyCapabilitiesCodeSystem' => 'OpenEMR/FHIR/R4/FHIRResource/FHIRTerminologyCapabilities/FHIRTerminologyCapabilitiesCodeSystem.php',
    'OpenEMR\\FHIR\\R4\\FHIRResource\\FHIRTerminologyCapabilities\\FHIRTerminologyCapabilitiesVersion' => 'OpenEMR/FHIR/R4/FHIRResource/FHIRTerminologyCapabilities/FHIRTerminologyCapabilitiesVersion.php',
    'OpenEMR\\FHIR\\R4\\FHIRResource\\FHIRTerminologyCapabilities\\FHIRTerminologyCapabilitiesFilter' => 'OpenEMR/FHIR/R4/FHIRResource/FHIRTerminologyCapabilities/FHIRTerminologyCapabilitiesFilter.php',
    'OpenEMR\\FHIR\\R4\\FHIRResource\\FHIRTerminologyCapabilities\\FHIRTerminologyCapabilitiesExpansion' => 'OpenEMR/FHIR/R4/FHIRResource/FHIRTerminologyCapabilities/FHIRTerminologyCapabilitiesExpansion.php',
    'OpenEMR\\FHIR\\R4\\FHIRResource\\FHIRTerminologyCapabilities\\FHIRTerminologyCapabilitiesParameter' => 'OpenEMR/FHIR/R4/FHIRResource/FHIRTerminologyCapabilities/FHIRTerminologyCapabilitiesParameter.php',
    'OpenEMR\\FHIR\\R4\\FHIRResource\\FHIRTerminologyCapabilities\\FHIRTerminologyCapabilitiesValidateCode' => 'OpenEMR/FHIR/R4/FHIRResource/FHIRTerminologyCapabilities/FHIRTerminologyCapabilitiesValidateCode.php',
    'OpenEMR\\FHIR\\R4\\FHIRResource\\FHIRTerminologyCapabilities\\FHIRTerminologyCapabilitiesTranslation' => 'OpenEMR/FHIR/R4/FHIRResource/FHIRTerminologyCapabilities/FHIRTerminologyCapabilitiesTranslation.php',
    'OpenEMR\\FHIR\\R4\\FHIRResource\\FHIRTerminologyCapabilities\\FHIRTerminologyCapabilitiesClosure' => 'OpenEMR/FHIR/R4/FHIRResource/FHIRTerminologyCapabilities/FHIRTerminologyCapabilitiesClosure.php',
    'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRCodeSearchSupport' => 'OpenEMR/FHIR/R4/FHIRElement/FHIRCodeSearchSupport.php',
    'OpenEMR\\FHIR\\R4\\FHIRDomainResource\\FHIRTestReport' => 'OpenEMR/FHIR/R4/FHIRDomainResource/FHIRTestReport.php',
    'OpenEMR\\FHIR\\R4\\FHIRResource\\FHIRTestReport\\FHIRTestReportParticipant' => 'OpenEMR/FHIR/R4/FHIRResource/FHIRTestReport/FHIRTestReportParticipant.php',
    'OpenEMR\\FHIR\\R4\\FHIRResource\\FHIRTestReport\\FHIRTestReportSetup' => 'OpenEMR/FHIR/R4/FHIRResource/FHIRTestReport/FHIRTestReportSetup.php',
    'OpenEMR\\FHIR\\R4\\FHIRResource\\FHIRTestReport\\FHIRTestReportAction' => 'OpenEMR/FHIR/R4/FHIRResource/FHIRTestReport/FHIRTestReportAction.php',
    'OpenEMR\\FHIR\\R4\\FHIRResource\\FHIRTestReport\\FHIRTestReportOperation' => 'OpenEMR/FHIR/R4/FHIRResource/FHIRTestReport/FHIRTestReportOperation.php',
    'OpenEMR\\FHIR\\R4\\FHIRResource\\FHIRTestReport\\FHIRTestReportAssert' => 'OpenEMR/FHIR/R4/FHIRResource/FHIRTestReport/FHIRTestReportAssert.php',
    'OpenEMR\\FHIR\\R4\\FHIRResource\\FHIRTestReport\\FHIRTestReportTest' => 'OpenEMR/FHIR/R4/FHIRResource/FHIRTestReport/FHIRTestReportTest.php',
    'OpenEMR\\FHIR\\R4\\FHIRResource\\FHIRTestReport\\FHIRTestReportAction1' => 'OpenEMR/FHIR/R4/FHIRResource/FHIRTestReport/FHIRTestReportAction1.php',
    'OpenEMR\\FHIR\\R4\\FHIRResource\\FHIRTestReport\\FHIRTestReportTeardown' => 'OpenEMR/FHIR/R4/FHIRResource/FHIRTestReport/FHIRTestReportTeardown.php',
    'OpenEMR\\FHIR\\R4\\FHIRResource\\FHIRTestReport\\FHIRTestReportAction2' => 'OpenEMR/FHIR/R4/FHIRResource/FHIRTestReport/FHIRTestReportAction2.php',
    'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRTestReportStatus' => 'OpenEMR/FHIR/R4/FHIRElement/FHIRTestReportStatus.php',
    'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRTestReportActionResult' => 'OpenEMR/FHIR/R4/FHIRElement/FHIRTestReportActionResult.php',
    'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRTestReportParticipantType' => 'OpenEMR/FHIR/R4/FHIRElement/FHIRTestReportParticipantType.php',
    'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRTestReportResult' => 'OpenEMR/FHIR/R4/FHIRElement/FHIRTestReportResult.php',
    'OpenEMR\\FHIR\\R4\\FHIRDomainResource\\FHIRTestScript' => 'OpenEMR/FHIR/R4/FHIRDomainResource/FHIRTestScript.php',
    'OpenEMR\\FHIR\\R4\\FHIRResource\\FHIRTestScript\\FHIRTestScriptOrigin' => 'OpenEMR/FHIR/R4/FHIRResource/FHIRTestScript/FHIRTestScriptOrigin.php',
    'OpenEMR\\FHIR\\R4\\FHIRResource\\FHIRTestScript\\FHIRTestScriptDestination' => 'OpenEMR/FHIR/R4/FHIRResource/FHIRTestScript/FHIRTestScriptDestination.php',
    'OpenEMR\\FHIR\\R4\\FHIRResource\\FHIRTestScript\\FHIRTestScriptMetadata' => 'OpenEMR/FHIR/R4/FHIRResource/FHIRTestScript/FHIRTestScriptMetadata.php',
    'OpenEMR\\FHIR\\R4\\FHIRResource\\FHIRTestScript\\FHIRTestScriptLink' => 'OpenEMR/FHIR/R4/FHIRResource/FHIRTestScript/FHIRTestScriptLink.php',
    'OpenEMR\\FHIR\\R4\\FHIRResource\\FHIRTestScript\\FHIRTestScriptCapability' => 'OpenEMR/FHIR/R4/FHIRResource/FHIRTestScript/FHIRTestScriptCapability.php',
    'OpenEMR\\FHIR\\R4\\FHIRResource\\FHIRTestScript\\FHIRTestScriptFixture' => 'OpenEMR/FHIR/R4/FHIRResource/FHIRTestScript/FHIRTestScriptFixture.php',
    'OpenEMR\\FHIR\\R4\\FHIRResource\\FHIRTestScript\\FHIRTestScriptVariable' => 'OpenEMR/FHIR/R4/FHIRResource/FHIRTestScript/FHIRTestScriptVariable.php',
    'OpenEMR\\FHIR\\R4\\FHIRResource\\FHIRTestScript\\FHIRTestScriptSetup' => 'OpenEMR/FHIR/R4/FHIRResource/FHIRTestScript/FHIRTestScriptSetup.php',
    'OpenEMR\\FHIR\\R4\\FHIRResource\\FHIRTestScript\\FHIRTestScriptAction' => 'OpenEMR/FHIR/R4/FHIRResource/FHIRTestScript/FHIRTestScriptAction.php',
    'OpenEMR\\FHIR\\R4\\FHIRResource\\FHIRTestScript\\FHIRTestScriptOperation' => 'OpenEMR/FHIR/R4/FHIRResource/FHIRTestScript/FHIRTestScriptOperation.php',
    'OpenEMR\\FHIR\\R4\\FHIRResource\\FHIRTestScript\\FHIRTestScriptRequestHeader' => 'OpenEMR/FHIR/R4/FHIRResource/FHIRTestScript/FHIRTestScriptRequestHeader.php',
    'OpenEMR\\FHIR\\R4\\FHIRResource\\FHIRTestScript\\FHIRTestScriptAssert' => 'OpenEMR/FHIR/R4/FHIRResource/FHIRTestScript/FHIRTestScriptAssert.php',
    'OpenEMR\\FHIR\\R4\\FHIRResource\\FHIRTestScript\\FHIRTestScriptTest' => 'OpenEMR/FHIR/R4/FHIRResource/FHIRTestScript/FHIRTestScriptTest.php',
    'OpenEMR\\FHIR\\R4\\FHIRResource\\FHIRTestScript\\FHIRTestScriptAction1' => 'OpenEMR/FHIR/R4/FHIRResource/FHIRTestScript/FHIRTestScriptAction1.php',
    'OpenEMR\\FHIR\\R4\\FHIRResource\\FHIRTestScript\\FHIRTestScriptTeardown' => 'OpenEMR/FHIR/R4/FHIRResource/FHIRTestScript/FHIRTestScriptTeardown.php',
    'OpenEMR\\FHIR\\R4\\FHIRResource\\FHIRTestScript\\FHIRTestScriptAction2' => 'OpenEMR/FHIR/R4/FHIRResource/FHIRTestScript/FHIRTestScriptAction2.php',
    'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRAssertionDirectionType' => 'OpenEMR/FHIR/R4/FHIRElement/FHIRAssertionDirectionType.php',
    'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRAssertionOperatorType' => 'OpenEMR/FHIR/R4/FHIRElement/FHIRAssertionOperatorType.php',
    'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRAssertionResponseTypes' => 'OpenEMR/FHIR/R4/FHIRElement/FHIRAssertionResponseTypes.php',
    'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRTestScriptRequestMethodCode' => 'OpenEMR/FHIR/R4/FHIRElement/FHIRTestScriptRequestMethodCode.php',
    'OpenEMR\\FHIR\\R4\\FHIRDomainResource\\FHIRValueSet' => 'OpenEMR/FHIR/R4/FHIRDomainResource/FHIRValueSet.php',
    'OpenEMR\\FHIR\\R4\\FHIRResource\\FHIRValueSet\\FHIRValueSetCompose' => 'OpenEMR/FHIR/R4/FHIRResource/FHIRValueSet/FHIRValueSetCompose.php',
    'OpenEMR\\FHIR\\R4\\FHIRResource\\FHIRValueSet\\FHIRValueSetInclude' => 'OpenEMR/FHIR/R4/FHIRResource/FHIRValueSet/FHIRValueSetInclude.php',
    'OpenEMR\\FHIR\\R4\\FHIRResource\\FHIRValueSet\\FHIRValueSetConcept' => 'OpenEMR/FHIR/R4/FHIRResource/FHIRValueSet/FHIRValueSetConcept.php',
    'OpenEMR\\FHIR\\R4\\FHIRResource\\FHIRValueSet\\FHIRValueSetDesignation' => 'OpenEMR/FHIR/R4/FHIRResource/FHIRValueSet/FHIRValueSetDesignation.php',
    'OpenEMR\\FHIR\\R4\\FHIRResource\\FHIRValueSet\\FHIRValueSetFilter' => 'OpenEMR/FHIR/R4/FHIRResource/FHIRValueSet/FHIRValueSetFilter.php',
    'OpenEMR\\FHIR\\R4\\FHIRResource\\FHIRValueSet\\FHIRValueSetExpansion' => 'OpenEMR/FHIR/R4/FHIRResource/FHIRValueSet/FHIRValueSetExpansion.php',
    'OpenEMR\\FHIR\\R4\\FHIRResource\\FHIRValueSet\\FHIRValueSetParameter' => 'OpenEMR/FHIR/R4/FHIRResource/FHIRValueSet/FHIRValueSetParameter.php',
    'OpenEMR\\FHIR\\R4\\FHIRResource\\FHIRValueSet\\FHIRValueSetContains' => 'OpenEMR/FHIR/R4/FHIRResource/FHIRValueSet/FHIRValueSetContains.php',
    'OpenEMR\\FHIR\\R4\\FHIRDomainResource\\FHIRVerificationResult' => 'OpenEMR/FHIR/R4/FHIRDomainResource/FHIRVerificationResult.php',
    'OpenEMR\\FHIR\\R4\\FHIRResource\\FHIRVerificationResult\\FHIRVerificationResultPrimarySource' => 'OpenEMR/FHIR/R4/FHIRResource/FHIRVerificationResult/FHIRVerificationResultPrimarySource.php',
    'OpenEMR\\FHIR\\R4\\FHIRResource\\FHIRVerificationResult\\FHIRVerificationResultAttestation' => 'OpenEMR/FHIR/R4/FHIRResource/FHIRVerificationResult/FHIRVerificationResultAttestation.php',
    'OpenEMR\\FHIR\\R4\\FHIRResource\\FHIRVerificationResult\\FHIRVerificationResultValidator' => 'OpenEMR/FHIR/R4/FHIRResource/FHIRVerificationResult/FHIRVerificationResultValidator.php',
    'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRStatus' => 'OpenEMR/FHIR/R4/FHIRElement/FHIRStatus.php',
    'OpenEMR\\FHIR\\R4\\FHIRDomainResource\\FHIRVisionPrescription' => 'OpenEMR/FHIR/R4/FHIRDomainResource/FHIRVisionPrescription.php',
    'OpenEMR\\FHIR\\R4\\FHIRResource\\FHIRVisionPrescription\\FHIRVisionPrescriptionLensSpecification' => 'OpenEMR/FHIR/R4/FHIRResource/FHIRVisionPrescription/FHIRVisionPrescriptionLensSpecification.php',
    'OpenEMR\\FHIR\\R4\\FHIRResource\\FHIRVisionPrescription\\FHIRVisionPrescriptionPrism' => 'OpenEMR/FHIR/R4/FHIRResource/FHIRVisionPrescription/FHIRVisionPrescriptionPrism.php',
    'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRVisionBase' => 'OpenEMR/FHIR/R4/FHIRElement/FHIRVisionBase.php',
    'OpenEMR\\FHIR\\R4\\FHIRElement\\FHIRVisionEyes' => 'OpenEMR/FHIR/R4/FHIRElement/FHIRVisionEyes.php',
    );

    /** @var bool */
    private static $_registered = false;

    /**
     * @return bool
     * @throws \Exception
     */
    public static function register()
    {
        if (self::$_registered) {
            return self::$_registered;
        }
        return self::$_registered = spl_autoload_register(array(__CLASS__, 'loadClass'), true);
    }

    /**
     * @return bool
     */
    public static function unregister()
    {
        if (self::$_registered) {
            if (spl_autoload_unregister(array(__CLASS__, 'loadClass'))) {
                self::$_registered = false;
                return true;
            }
        }
        return false;
    }

    /**
     * Please see associated documentation for more information on what this method looks for.
     *
     * @param string $class
     * @return bool|null
     */
    public static function loadClass($class)
    {
        if (isset(self::$_classMap[$class])) {
            return (bool)require sprintf('%s/%s', self::ROOT_DIR, self::$_classMap[$class]);
        }
        return null;
    }
}
