
--
-- Ensure correct encoding
--
SET NAMES utf8mb4;


--
-- Table structure for table `lang_languages`
--


DROP TABLE IF EXISTS `lang_languages`;
CREATE TABLE `lang_languages` (
  `lang_id` int(11) NOT NULL auto_increment,
  `lang_code` char(2) NOT NULL default '',
  `lang_description` varchar(100) default NULL,
  `lang_is_rtl` TINYINT DEFAULT 0,
  UNIQUE KEY `lang_id` (`lang_id`)
) ENGINE=InnoDB AUTO_INCREMENT=36 ;


--
-- Dumping data for table `lang_languages`
--

INSERT INTO `lang_languages`   (`lang_id`, `lang_code`, `lang_description`, `lang_is_rtl`) VALUES
(1, 'en', 'English (Standard)', 0),
(2, 'se', 'Swedish', 0),
(3, 'es', 'Spanish (Spain)', 0),
(4, 'el', 'Spanish (Latin American)', 0),
(5, 'de', 'German', 0),
(6, 'du', 'Dutch', 0),
(7, 'he', 'Hebrew', 1),
(8, 'fr', 'French (Standard)', 0),
(9, 'fq', 'French (Canadian)', 0),
(10, 'zh', 'Chinese (Simplified)', 0),
(11, 'zt', 'Chinese (Traditional)', 0),
(12, 'ru', 'Russian', 0),
(13, 'hy', 'Armenian', 0),
(14, 'id', 'Bahasa Indonesia', 0),
(15, 'gr', 'Greek', 0),
(16, 'ei', 'English (Indian)', 0),
(17, 'pe', 'Portuguese (European)', 0),
(18, 'pt', 'Portuguese (Brazilian)', 0),
(19, 'ar', 'Arabic', 1),
(20, 'da', 'Danish', 0),
(21, 'tr', 'Turkish', 0),
(22, 'po', 'Polish', 0),
(23, 'it', 'Italian', 0),
(24, 'hi', 'Hindi', 0),
(25, 'ro', 'Romanian', 0),
(26, 'vi', 'Vietnamese', 0),
(27, 'sq', 'Albanian', 0),
(28, 'cs', 'Czech', 0),
(29, 'uk', 'Ukrainian', 0),
(30, 'fa', 'Persian', 1),
(31, 'ja', 'Japanese', 0),
(32, 'fi', 'Finnish', 0),
(33, 'mr', 'Marathi', 0),
(34, 'ta', 'Tamil', 0),
(35, 'dd', 'dummy', 0);

--


--
-- Table structure for table `lang_constants`
--


DROP TABLE IF EXISTS `lang_constants`;
CREATE TABLE `lang_constants` (
  `cons_id` int(11) NOT NULL auto_increment,
  `constant_name` mediumtext BINARY,
  UNIQUE KEY `cons_id` (`cons_id`),
  KEY `constant_name` (`constant_name`(100))
) ENGINE=InnoDB AUTO_INCREMENT=12383 ;


--
-- Dumping data for table `lang_constants`
--

INSERT INTO `lang_constants`   (`cons_id`, `constant_name`) VALUES
(1, 'A'),
(2, 'A check number or claim number to identify the payment'),
(3, 'A claim must be selected to enable this menu.'),
(4, 'A client certificate for the admin user'),
(5, 'A Clinical Decision Rule is patient specific information that is filtered and presented at appropriate times to enhance health and health care'),
(6, 'A clinical document is attached'),
(7, 'A clinical document is attached.'),
(8, 'A code of this type is already selected. Erase the field first if you need to replace it.'),
(9, 'A dated reminder message can be either forwarded by clicking the Forward button or removed from the dated reminders list by clicking on the Set As Completed button'),
(10, 'A dedicated security key needs to be purchased'),
(11, 'A default code is optional as the needed code can be entered at the time of placing the actual order'),
(12, 'A detailed guide on how to enable and setup a Clinical Decision rule is found here'),
(13, 'A distributor is required'),
(14, 'A due date can be specified or a specific time period can be chosen for the dated reminder to to show up'),
(15, 'A few words to indicate the reason for the visit'),
(16, 'A followup appointment can also be scheduled right from the fee sheet.'),
(17, 'A GCAC visit form should be added to this visit.'),
(18, 'A HL7 v2.x message simply consists of several lines of text, each line is called a segment and is further divided into fields by using the pipe (|) character'),
(19, 'A large application like openEMR is used by a multitude of users with varying roles and degrees of responsibility. It is imperative that access to various parts of the program be granted to users on a need to know basis. To achieve this - Access Control Lists (ACL) are used.'),
(20, 'A lot number is required'),
(21, 'A lot number is required!'),
(22, 'A lowercase letter'),
(23, 'A New Appointment'),
(24, 'A new feature helps to group frequently ordered tests so that they can be ordered together'),
(25, 'A new message can thus be sent to a single or multiple users and/or can be about a single or multiple patients'),
(26, 'A new patients credentials could not be sent after portal registration.'),
(27, 'A new tab sub menu will be visible at the top of the Message center page'),
(28, 'A number'),
(29, 'A Patient Must Be Selected to Generate This Report'),
(30, 'A patient with this ID already exists.'),
(31, 'A patient with this name already exists.'),
(32, 'A patient with this SS already exists.'),
(33, 'A Payment is Required!. Please input a payment line item entry.'),
(34, 'A place to document and display the patient\'s past medical history, family history, personal history'),
(35, 'A popup box will alert you about success or failure'),
(36, 'A positive number will show that many past appointments on a Widget in the Patient Summary screen (a negative number will show the past appointments in descending order)'),
(37, 'A positive number will show that many past appointments on a Widget in the Patient Summary screen.'),
(38, 'A product was selected but there is no product section in this form.'),
(39, 'A provider or warehouse can be selected in the dropwdown box. For this option to be displayed \'Support provider in line item in fee sheet\' box must be checked in Administration > Globals> Billing page'),
(40, 'A Recurring Appointment. Please contact your appointment desk for any changes.'),
(41, 'A Referral has an additional action - to print the referral or save it as a pdf file'),
(42, 'A Referral is the most common type of transaction'),
(43, 'A referral source may be specified for each visit.'),
(44, 'A related IPPF code is required!'),
(45, 'A secure (HTTPS) web connection is required for U2F'),
(46, 'A short description of this group that will appear when you hover over the newly created group (ARO).'),
(47, 'A short description of this group, Serum chemistry tests'),
(48, 'A short description of this procedure or result code'),
(49, 'A special character'),
(50, 'A standardized form called the Health Insurance Claim Form is used to submit claims'),
(51, 'A third alternative is to scan the results and save it as a document - TIFF, JPEG or PDF in the patient\'s chart under documents'),
(52, 'A two tabbed form will be revealed'),
(53, 'A unique value to identify this field, not visible to the user'),
(54, 'A useful start would be to obtain a paper lab slip from a few labs and look at the way the tests are organized on the lab slip'),
(55, 'A visit already exists for this group today. Click Cancel to open it, or OK to proceed with creating a new one.'),
(56, 'A visit already exists for this patient today. Click Cancel to open it, or OK to proceed with creating a new one.'),
(57, 'a.c.'),
(58, 'a.m.'),
(59, 'A/C{{anterior chamber}}'),
(60, 'A/F Level Right:'),
(61, 'AAA Segments'),
(62, 'AB'),
(63, 'Abbreviation'),
(64, 'Abcess:'),
(65, 'Abdominal'),
(66, 'Able to Bear Weight four (4) steps:'),
(67, 'Abn'),
(68, 'ABN1'),
(69, 'ABNL'),
(70, 'Abnormal'),
(71, 'Abnormal Blood Test'),
(72, 'Abnormal Hair Growth'),
(73, 'Abnormal Mammogram'),
(74, 'Abort'),
(75, 'Abortion'),
(76, 'Abortion Issues'),
(77, 'Abortion Method'),
(78, 'Abortion-Related Categories'),
(79, 'Abortions'),
(80, 'About'),
(81, 'About Portal Dashboard'),
(82, 'About the calendar'),
(83, 'About Your Portal'),
(84, 'Above upper panic limits'),
(85, 'Absences by Diagnosis'),
(86, 'Accept'),
(87, 'Accept Assignment'),
(88, 'Accept Payment'),
(89, 'Accept Payment for'),
(90, 'Accept Payment for '),
(91, 'Accepts Assignment'),
(92, 'Access can be given to other groups by editing User Memberships or Groups and Access Controls in Administration > ACL'),
(93, 'Access Control'),
(94, 'Access Control List Administration'),
(95, 'Access Control List Help'),
(96, 'Access Control Lists'),
(97, 'Access core data set of patient information at the beginning of an encounter'),
(98, 'Access date'),
(99, 'Access denied'),
(100, 'Access is then granted selectively to portions of the program on a need to know basis.'),
(101, 'access not allowed'),
(102, 'Access not allowed'),
(103, 'Access Not Authorized'),
(104, 'Access Your Medical Records'),
(105, 'Access Your Patient Portal'),
(106, 'Accident'),
(107, 'Account'),
(108, 'Account Id'),
(109, 'Account Id issued for NewCrop eRx service, used to separate multi-facility accounts.'),
(110, 'Account Id issued for Weno eRx service.'),
(111, 'Account Id issued for Your clinics eRx service.'),
(112, 'Account is validated. Send new credentials?'),
(113, 'Account Name'),
(114, 'Account Name issued for NewCrop eRx service.'),
(115, 'Account Password issued for NewCrop eRx service.'),
(116, 'Account Registration'),
(117, 'Accounting'),
(118, 'Accounting (acct)'),
(119, 'Accountings'),
(120, 'Acct'),
(121, 'ACD{{anterior chamber depth}}'),
(122, 'Aches'),
(123, 'Acknowledge as my Electronic Signature'),
(124, 'Acknowledgment Requested (ISA14)'),
(125, 'Acknowledgments, Licensing and Certification'),
(126, 'ACL'),
(127, 'ACL Administration'),
(128, 'ACL Administration (acl)'),
(129, 'ACL Administration Not Authorized'),
(130, 'ACL check failed'),
(131, 'ACL Fine Granular Control'),
(132, 'ACL Updated Successfully'),
(133, 'Acne'),
(134, 'ACO'),
(135, 'ACOM{{Anterior Segment}}'),
(136, 'Act'),
(137, 'Act Date'),
(138, 'Action'),
(139, 'Action Taken'),
(140, 'Action Taken Time'),
(141, 'Action User'),
(142, 'Actions'),
(143, 'Activate'),
(144, 'Activate CCR/CCD Reporting'),
(145, 'activate to sort column ascending'),
(146, 'activate to sort column descending'),
(147, 'Activate UB04/837I Claim Support'),
(148, 'Active'),
(149, 'Active - By default any value added here will be set to Active, to prevent/remove an item from showing up in the drop-down list just uncheck and deactivate'),
(150, 'Active Alert'),
(151, 'Active Alert - that presents as a pop-up notification when a patient\'s chart is entered'),
(152, 'Active Alert Rules'),
(153, 'Active Alerts/Reminders'),
(154, 'Active Chart'),
(155, 'Active Directory - Domains Base'),
(156, 'Active Directory - Domains Controllers'),
(157, 'Active Directory - Suffix Of Account'),
(158, 'Active Encounter'),
(159, 'Active Issue Codes'),
(160, 'Active lists'),
(161, 'Active Messages'),
(162, 'Active Patient'),
(163, 'Active Plans'),
(164, 'Active Templates'),
(165, 'Active{{Appointment}}'),
(166, 'Active{{Code}}'),
(167, 'Active{{Drug}}'),
(168, 'Active{{Issue}}'),
(169, 'Active{{Item}}'),
(170, 'Active{{Note}}'),
(171, 'Active{{Plan}}'),
(172, 'Active{{Service}}'),
(173, 'Activity'),
(174, 'Activity Type'),
(175, 'Actual Receipts'),
(176, 'Acuity'),
(177, 'ACUITY'),
(178, 'Acuity with Autorefraction'),
(179, 'Acuity with Contact Lenses'),
(180, 'Acuity with correction'),
(181, 'Acuity with Cycloplegic Refraction'),
(182, 'Acuity with Manifest Refraction'),
(183, 'Acuity with Pinhole'),
(184, 'Acuity without correction'),
(185, 'Acute Intoxication/Withdrawal'),
(186, 'Acute Manifestation of a Chronic Condition'),
(187, 'Acute on Chronic'),
(188, 'Ad Reviewed'),
(189, 'Add'),
(190, 'add'),
(191, 'ADD'),
(192, 'Add a Company'),
(193, 'Add a condition'),
(194, 'ADD A NEW RECALL'),
(195, 'Add a New Recall'),
(196, 'Add a note to the biller'),
(197, 'Add a Pharmacy'),
(198, 'Add all needed providers in a similar manner'),
(199, 'Add all rules to plan'),
(200, 'add an event for '),
(201, 'Add as a new message'),
(202, 'Add as a new note'),
(203, 'Add as New'),
(204, 'Add as new patient'),
(205, 'Add Bottom Border Row'),
(206, 'Add Buttons'),
(207, 'Add Buttons for Special Chars,Texts to be Displayed on Top of the Editor for inclusion to the text on a Click'),
(208, 'Add Category'),
(209, 'Add Constant'),
(210, 'Add Context'),
(211, 'Add Copay'),
(212, 'Add criteria'),
(213, 'Add Custom Button'),
(214, 'Add Data Bottom Border'),
(215, 'Add desired privileges by moving items (ACOs) from the \'Inactive\' column to the \'Active\' column.'),
(216, 'Add Diagnosis'),
(217, 'Add Drug'),
(218, 'Add Edit Transactions Help'),
(219, 'Add encounter'),
(220, 'Add Encounter'),
(221, 'Add encounter/notes'),
(222, 'Add Facility'),
(223, 'Add Field'),
(224, 'Add following lines to the Apache configuration file'),
(225, 'Add Group'),
(226, 'Add group'),
(227, 'Add ICD Code'),
(228, 'Add Immunization'),
(229, 'Add is not authorized!'),
(230, 'Add Issue'),
(231, 'Add item to track'),
(232, 'Add Language'),
(233, 'Add Lot'),
(234, 'Add manually'),
(235, 'Add Mode'),
(236, 'Add modifiers for this field type. You may select more than one.'),
(237, 'Add More Items'),
(238, 'Add New'),
(239, 'Add new'),
(240, 'Add new category : '),
(241, 'Add new certificates to the Apache configuration file'),
(242, 'Add New Component'),
(243, 'Add New Components'),
(244, 'Add new database'),
(245, 'Add New Entry'),
(246, 'Add New Event'),
(247, 'Add New Form'),
(248, 'ADD NEW GROUP'),
(249, 'Add New Group'),
(250, 'Add New Issue'),
(251, 'Add new lot and transaction'),
(252, 'Add New Message'),
(253, 'Add New Note'),
(254, 'Add new note'),
(255, 'Add New Partner'),
(256, 'Add New Patient'),
(257, 'ADD NEW PLAN'),
(258, 'Add New...'),
(259, 'Add New{{Event}}'),
(260, 'Add New{{Message}}'),
(261, 'Add New{{Provider}}'),
(262, 'Add new{{Rule}}'),
(263, 'Add New{{Type}}'),
(264, 'Add Note'),
(265, 'Add Onsite Portal Activity'),
(266, 'Add Package'),
(267, 'Add Patient'),
(268, 'Add Patient Record'),
(269, 'Add Prescription'),
(270, 'Add Procedure'),
(271, 'Add Provider Number'),
(272, 'Add Recall'),
(273, 'Add Rehab'),
(274, 'Add Rule'),
(275, 'Add the remaining codes, in order to do so the CPT code must already exist in the database'),
(276, 'Add Time to Date'),
(277, 'Add to'),
(278, 'ADD TO EXISTING MESSAGE'),
(279, 'Add To Existing Message'),
(280, 'Add to list'),
(281, 'Add to Medication List'),
(282, 'Add Top Level'),
(283, 'Add Transaction'),
(284, 'Add User'),
(285, 'Add User To Group'),
(286, 'Add.{{Additional Measurements}}'),
(287, 'Add/Edit eRx'),
(288, 'Add/Edit Issue'),
(289, 'Add/Edit Patient Transaction'),
(290, 'added'),
(291, 'Adding'),
(292, 'Adding a participant'),
(293, 'Adding demographics is not authorized.'),
(294, 'Adding item to track failed'),
(295, 'Addison Syndrom'),
(296, 'Addison Syndrome'),
(297, 'Additional Attributes'),
(298, 'Additional Data Points'),
(299, 'Additional Date:'),
(300, 'Additional Diagnosis:'),
(301, 'Additional Findings'),
(302, 'Additional functionality including the ability to send SMS text messages, automated phone dialing, emails etc. can be accessed by enabling the optional MedEx Communication Service'),
(303, 'Additional help to fill out this form is available by hovering over labels of each box and clicking on the dark blue help ? icon that is revealed'),
(304, 'Additional help to fill out this form is available by hovering over labels of each box and clicking on the dark blue help ? icon that is revealed. On mobile devices tap once on the label to reveal the help icon and tap on the icon to show the help section'),
(305, 'Additional History'),
(306, 'Additional history notes'),
(307, 'Additional Info'),
(308, 'Additional information about the individual pages can be found in their respective help files'),
(309, 'Additional information to process paper claims'),
(310, 'Additional Labs'),
(311, 'Additional Notes'),
(312, 'Additional Notes field is for local use in openEMR'),
(313, 'Additional notes for this result or recommendation'),
(314, 'Additional Notes:'),
(315, 'Additional Notes: '),
(316, 'additional scopes'),
(317, 'Additional X-RAY Notes:'),
(318, 'Additionally, the corresponding US Snomed Extension Package can be imported separately after installing the International (English version) Snomed Release'),
(319, 'Additonal Rx{{Additional glasses}}'),
(320, 'addonly'),
(321, 'addonly - can read and add but not modify'),
(322, 'Addr Bk'),
(323, 'Addr Book'),
(324, 'Address'),
(325, 'Address and Postal Code'),
(326, 'Address and State'),
(327, 'Address Book'),
(328, 'Address book entry for the company performing this procedure'),
(329, 'Address book entry for the distributor'),
(330, 'Address book entry for the vendor'),
(331, 'Address Book Types'),
(332, 'Address Label'),
(333, 'Address Labels'),
(334, 'Address Line 1'),
(335, 'Address Line 2'),
(336, 'Address Only'),
(337, 'Address, City, State and Postal Code'),
(338, 'Address, State and Postal Code'),
(339, 'Address1'),
(340, 'Address2'),
(341, 'ADDRESSED TO'),
(342, 'ADDRESSEE'),
(343, 'ADD{{Bifocal Add}}'),
(344, 'ADD{{Near Add}}'),
(345, 'Adj'),
(346, 'Adj Amount'),
(347, 'Adjust'),
(348, 'Adjustment'),
(349, 'Adjustment Amt'),
(350, 'Adjustment Reasons'),
(351, 'Adjustment value for code'),
(352, 'Adjustment value for code '),
(353, 'Adjustments'),
(354, 'Adm adjust'),
(355, 'Admin'),
(356, 'Admin Email Address'),
(357, 'Administer Via'),
(358, 'Administer Via is not relevant in this context and can be left Unassigned'),
(359, 'Administered'),
(360, 'Administered By'),
(361, 'Administered Date'),
(362, 'Administered Site'),
(363, 'Administration'),
(364, 'Administration (admin)'),
(365, 'Administration Site'),
(366, 'Administrators'),
(367, 'Administrators can do anything'),
(368, 'Admit Date'),
(369, 'Adnexa'),
(370, 'Adopted Child'),
(371, 'Adult Weight Screening and Follow-Up'),
(372, 'Adult Weight Screening and Follow-Up (CQM)'),
(373, 'Advance Directive'),
(374, 'Advance Directives'),
(375, 'Advance Directives Warning'),
(376, 'Advance Options'),
(377, 'Advanced'),
(378, 'Advanced - Finer Access Control'),
(379, 'Advantages and Disadvantages of TOTP and U2F'),
(380, 'Advice'),
(381, 'Afar'),
(382, 'Affect normal'),
(383, 'Afrikaans'),
(384, 'after'),
(385, 'after (PM)'),
(386, 'After hrs calls'),
(387, 'After migration from the old password mechanisms where passwords are stored in the users table without salt is complete, this flag should be set to false so that only authentication by the new method is possible'),
(388, 'After performing above configurations, import the admin client certificate to the browser and restart Apache server (empty password).'),
(389, 'After saving the PDF'),
(390, 'After saving the PDF, click [View Log] to check for errors.'),
(391, 'After saving the PDF, click[View Log] to check for errors.'),
(392, 'After saving the TEXT file'),
(393, 'After saving the TEXT file(s), click [View Log] to check for errors.'),
(394, 'After saving the TEXT file(s), click[View Log] to check for errors.'),
(395, 'After saving your batch'),
(396, 'After saving your batch, click [View Log] to check for errors.'),
(397, 'After saving your batch, click[View Log] to check for errors.'),
(398, 'After that the Match column will show the selected patient ID, or 0 to create.'),
(399, 'After the information is correctly entered, click the Save button.'),
(400, 'After Uploading click the button \"Import\"'),
(401, 'After Uploading, click \"Import\"'),
(402, 'After you filled in the spreadsheet with the relevant ICD categories and ICD codes go to Administration > Lists. Select \'Service Category\' from the dropdown box'),
(403, 'After you have finished entering all the ICD 10 codes go to Adminstration > Lists and select \'Code Types\' from the dropdown box. Select \'ICD10 Diagnosis\' from the last dropdown box under ICD 10'),
(404, 'AfterCare Planning'),
(405, 'Afterwards however, you may change your portal credentials anytime from portal menu.'),
(406, 'Again'),
(407, 'Age'),
(408, 'Age at death'),
(409, 'Age By'),
(410, 'Age Category'),
(411, 'Age data is out of range.'),
(412, 'Age Display Format'),
(413, 'Age format for \"age from\" is not valid'),
(414, 'Age format for \"age up to\" is not valid'),
(415, 'Age From'),
(416, 'Age in Years for Display Format Change'),
(417, 'Age max'),
(418, 'Age min'),
(419, 'Age Range'),
(420, 'Aging Columns'),
(421, 'Aging Columns:'),
(422, 'Akan'),
(423, 'Albanian'),
(424, 'Alcohol'),
(425, 'Alcohol consumption'),
(426, 'Alcohol Use'),
(427, 'Alert'),
(428, 'Alert Count'),
(429, 'Alert Notice'),
(430, 'Alert on and after birthday'),
(431, 'Alert on and up to 28 days after birthday'),
(432, 'Alert on patient birthday'),
(433, 'Alert only on birthday'),
(434, 'Alert Time'),
(435, 'Alerts'),
(436, 'Alerts Log'),
(437, 'Alerts/Reminders'),
(438, 'Alert{{Mental Status}}'),
(439, 'ALEUT'),
(440, 'All'),
(441, 'ALL'),
(442, 'all'),
(443, 'All (Collated Format A)'),
(444, 'All (Collated Format B)'),
(445, 'All (Cumulative)'),
(446, 'All Alerts'),
(447, 'All Automated Measure Calculations (AMC)'),
(448, 'All Categories'),
(449, 'All Clinical Quality Measures (CQM)'),
(450, 'All Codes'),
(451, 'All credential fields are case sensitive!'),
(452, 'All Dates'),
(453, 'All Day'),
(454, 'All day event'),
(455, 'All demographics fields, with search and duplication check'),
(456, 'All Encounters'),
(457, 'All Facilities'),
(458, 'All Injuries/Problems/Issues'),
(459, 'All Languages Allowed'),
(460, 'All Messages'),
(461, 'All Official Clinical Quality Measures (CQM) Measure Groups'),
(462, 'All or part of the first name'),
(463, 'All or part of the last name'),
(464, 'All or part of the organization'),
(465, 'All patient interactions in OpenEMR are linked to encounters'),
(466, 'All Patients'),
(467, 'All pending messages are displayed on the MY MESSAGES pane'),
(468, 'All Products'),
(469, 'All Providers'),
(470, 'All Reviewed and Negative:'),
(471, 'All search inputs are case sensitive and must match entries in your profile.'),
(472, 'All sections are not required, rather, they are available based on the information a practitioner believes is critical data for the patient at any given moment in time'),
(473, 'All set. Click Send Request below to finish registration'),
(474, 'All set. Click Send Request below to finish registration.'),
(475, 'All Topics'),
(476, 'All TOTP authenticator apps use the same algorithm and secure hash function - HMAC-SHA1 to generate the unique key'),
(477, 'All Transactions for the patient will appear on the Transactions page in descending order of its date of creation'),
(478, 'All Users'),
(479, 'Allergic'),
(480, 'Allergic to'),
(481, 'Allergies'),
(482, 'Allergies - will show the allergies listed under Issues > Allergies. If eRx is enabled the allergy list has to be entered on the eRx page'),
(483, 'Allergies/Alerting Data'),
(484, 'Allergies:'),
(485, 'Allergy'),
(486, 'Allergy import successfully completed'),
(487, 'Allergy Issue List'),
(488, 'Allergy Reaction'),
(489, 'ALLERGY WARNING'),
(490, 'Allergy Warning'),
(491, 'Allocate'),
(492, 'Allow'),
(493, 'Allow Administrators to Delete Patients'),
(494, 'Allow all available languages as choices on menu at login.'),
(495, 'Allow Check In before the appointment\'s time.'),
(496, 'Allow creation of claims containing diagnoses but not procedures or charges. Most clinics do not want this.'),
(497, 'Allow Debugging Language'),
(498, 'Allow Double Click to select Nation Note text template from any encounter form text area'),
(499, 'Allow Early Check In'),
(500, 'Allow Email'),
(501, 'Allow email messages?'),
(502, 'Allow Email?'),
(503, 'Allow Encounter Claims'),
(504, 'Allow Encounter For Each Appointment'),
(505, 'Allow Health Info Exchange'),
(506, 'Allow Health Information Exchange'),
(507, 'Allow Immunization Info Share'),
(508, 'Allow Immunization Info Sharing'),
(509, 'Allow Immunization Registry Use'),
(510, 'Allow institutional claims support.'),
(511, 'Allow insurance eligibility checks using Office Ally'),
(512, 'Allow Mail Message'),
(513, 'Allow more than one insurance'),
(514, 'Allow multiple databases'),
(515, 'Allow New Patient Registration Widget'),
(516, 'Allow Notice'),
(517, 'Allow Online Appointments'),
(518, 'Allow Online Payments'),
(519, 'Allow Online Secure Chat'),
(520, 'Allow only one insurance'),
(521, 'Allow Onsite New Patient Registration Widget'),
(522, 'Allow Onsite Online Appointments'),
(523, 'Allow Onsite Online Payments'),
(524, 'Allow Onsite Online Secure Chat'),
(525, 'Allow Onsite Patient Ledger'),
(526, 'Allow Onsite Patient to make and view appointments online.'),
(527, 'Allow Onsite Patient to make payments online.'),
(528, 'Allow Onsite Patient to use Secure Chat Application.'),
(529, 'Allow Onsite Patient to view their accounting ledger online.'),
(530, 'Allow Onsite Patients to Reset Credentials'),
(531, 'Allow Patient Flow Board to Select Patients for Drug Testing.'),
(532, 'Allow Patient Ledger'),
(533, 'Allow Patient Portal'),
(534, 'Allow Patient to make and view appointments online.'),
(535, 'Allow Patient to make payments online.'),
(536, 'Allow Patient to use Secure Chat Application.'),
(537, 'Allow Patient to view their accounting ledger online.'),
(538, 'Allow Patients to Reset Credentials'),
(539, 'Allow Postal Mail'),
(540, 'Allow self-signed certificate for SSL (encrypted) connection to CouchDB'),
(541, 'Allow SMS'),
(542, 'Allow SMS (text messages)?'),
(543, 'Allow Statement Exclusions from Printing'),
(544, 'Allow submitted events to be made active instantly?'),
(545, 'Allow telephone messages?'),
(546, 'Allow to use with multiple database'),
(547, 'Allow users to publish Global Events'),
(548, 'Allow users to publish Personal Calendars'),
(549, 'Allow Version 2 Onsite New Patient Registration Widget'),
(550, 'Allow Version 2 Onsite Online Payments'),
(551, 'Allow Version 2 Onsite Patient to make payments online.'),
(552, 'Allow Version 2 Patients to Reset Credentials'),
(553, 'Allow Voice Call'),
(554, 'Allow Voice Message'),
(555, 'Allowed'),
(556, 'Allowed Languages'),
(557, 'Allowed to discount prices (in Fee Sheet or Checkout form) (disc)'),
(558, 'Allowed(c)'),
(559, 'Allows E-Sign on the entire encounter'),
(560, 'Allows E-Signing Individual Forms'),
(561, 'Allows Mail'),
(562, 'Allows Voice msgs'),
(563, 'All{{Mails}}'),
(564, 'All{{Recipients}}'),
(565, 'Already at the top of the page'),
(566, 'already exists'),
(567, 'already exists! Please try again.'),
(568, 'already exists.'),
(569, 'Already registered'),
(570, 'Already used, choose another identifier'),
(571, 'Already used, choose another title'),
(572, 'Also provides a short description of the visit in Patient Reports'),
(573, 'Alt Address'),
(574, 'Alt City'),
(575, 'Alt Postal code'),
(576, 'Alt State'),
(577, 'alter'),
(578, 'Alternate Cover Test'),
(579, 'Alternatively a CPT code can be used. It is 84550 for Serum Uric Acid'),
(580, 'Alternatively download a sample spreadsheet by clicking on the Download button'),
(581, 'Alternatively it can be accessed by clicking in the Messages menu item in the top navigation bar'),
(582, 'Alternatively you could clear all selections and select only the items that you want to be a part of the report'),
(583, 'Alternatively, you may choose to upload an electronic remittance (X12 835) file that you have obtained from your payer or clearinghouse. You can do this by first selecting the \'ERA upload\' option in the initial \'Select Method\' section. This brings up the \'ERA Upload\' Section.'),
(584, 'Alternatively, you may use the search page to upload an electronic remittance (X12 835) file that you have obtained from your payer or clearinghouse.  You can do this by clicking the Browse button and selecting the file to upload, and then clicking Search to perform the upload and display the corresponding invoices.  In this case the other parameters mentioned above do not apply and will be ignored.  Uploading saves the file but does not yet process its contents -- that is done separately as described below.'),
(585, 'Although the HCFA-1500 originally was developed for submitting Medicare claims, it eventually was accepted by all commercial/ private insurance carriers to facilitate the standardization of the claims process'),
(586, 'AM'),
(587, 'AM Program'),
(588, 'Amblyopia'),
(589, 'Ambulance - Air or Water'),
(590, 'Ambulance - Land'),
(591, 'Ambulatory Surgical Center'),
(592, 'AMC'),
(593, 'AMC Tracking'),
(594, 'AMC-2011'),
(595, 'AMC-2014'),
(596, 'AMC-2014 Stage I'),
(597, 'AMC-2014 Stage II'),
(598, 'AMD{{age related macular degeneration}}'),
(599, 'Amend Existing Message'),
(600, 'Amend Existing Note'),
(601, 'Amendment'),
(602, 'Amendment From'),
(603, 'Amendment List'),
(604, 'Amendment Status'),
(605, 'Amendments'),
(606, 'Amendments (write,addonly optional)'),
(607, 'Amendments (write,addonly optional) (amendment)'),
(608, 'Amendments - Enable a user to electronically select the record affected by a patient’s request for amendment and either append the amendment to the affected record or include a link that indicates the amendment’s location'),
(609, 'Amendments for'),
(610, 'American Indian'),
(611, 'American Indian or Alaska Native'),
(612, 'AMEX'),
(613, 'Amharic'),
(614, 'Amount'),
(615, 'Amount Administered'),
(616, 'Amount Charged'),
(617, 'Amount Charges'),
(618, 'Amount Charges:'),
(619, 'Amount Due'),
(620, 'Amount for Past Balance'),
(621, 'Amount for This Visit'),
(622, 'Amount Paid'),
(623, 'Amount:'),
(624, 'Amplitudes'),
(625, 'Amsler'),
(626, 'Amt Billed'),
(627, 'An appointment can be scheduled by clicking on the calendar icon in that cell'),
(628, 'An e-mail with your new account credentials will be sent to the e-mail address supplied earlier. You may still review or edit any part of your information by using the top step buttons to go to the appropriate panels. Note to be sure you have given your correct e-mail address. If after receiving credentials and you have trouble with access to the portal, please contact administration.'),
(629, 'An electronic order and the returned result is in the form of a message called the HL7 message. HL7 stands for Health Level (Application Layer) 7. HL7’s prime objective is to simplify the implementation of interfaces between healthcare software applications and various vendors so as to reduce the pain and cost involved in custom interface programming'),
(630, 'An end date later than the start date is required for repeated events!'),
(631, 'An error occured signing the form'),
(632, 'An error occurred while dumping OpenEMR web directory tree'),
(633, 'An error occurred while dumping phpGACL web directory tree'),
(634, 'An error occurred while dumping SQL-Ledger web directory tree'),
(635, 'An error occurred: Missing file to upload: Use back button!'),
(636, 'An important concept to grasp is that once the secret key delivered via the QR code is captured by the authenticator app there is no further communication between the app and OpenEMR, each will use the current UNIX time and its copy of the user-specific shared secret key to generate the same unique 6 digit number'),
(637, 'An important point to remember is that the various individuals tests in each panel are listed as Results, the fruit, you cannot directly order these individual tests'),
(638, 'An incomplete GCAC issue has been created and linked. Someone will need to complete it later.'),
(639, 'An Issue concerns matters relating to the patient\'s health'),
(640, 'An issue is a medical problem, allergy, medication, surgery or dental issue'),
(641, 'An order has now been successfully created, however a place to receive and document the returned result does not exist as yet and needs to be created'),
(642, 'An Outcome for the problem - Resolved, Improved, Status Quo, Worse, Pending Followup or leave as Unassigned'),
(643, 'An undefined error occurred, please contact your systems administrator.'),
(644, 'An unexpected error has occurred.'),
(645, 'An Updated Appointment'),
(646, 'An uppercase letter'),
(647, 'Analyzed'),
(648, 'and'),
(649, 'And'),
(650, 'AND'),
(651, 'and '),
(652, 'and all subordinate data? This action will be logged'),
(653, 'and modifier'),
(654, 'and processed.'),
(655, 'and resetting claim status.'),
(656, 'and restart Apache server.'),
(657, 'and the Reason is'),
(658, 'android'),
(659, 'Anemia'),
(660, 'Ankle'),
(661, 'Ankle + heel'),
(662, 'Ankle Evaluation Form'),
(663, 'Ankle Problems'),
(664, 'Ankylosing Sondlilitis'),
(665, 'Ankylosing Spondlilitis'),
(666, 'Anorexia'),
(667, 'Another thing you can do in the posting window is request secondary billing. If you select this checkbox before saving, then the original claim will be re-opened and queued on the Billing page, and will be processed during the next billing run.'),
(668, 'Another way to select an ICD code to justify the CPT4 code is to click on the label CPT4 at the beginning of the row'),
(669, 'Answering Service'),
(670, 'Ant'),
(671, 'ante'),
(672, 'Anterior Chamber Depth'),
(673, 'Anterior Segment'),
(674, 'Anterior Segment Default Values'),
(675, 'ant{{anterior}}'),
(676, 'Anus nl, no rectal tenderness/mass'),
(677, 'Anxiety'),
(678, 'any'),
(679, 'Any'),
(680, 'Any additional information pertaining to this provider'),
(681, 'Any carotid bruits appreciated?'),
(682, 'Any Category'),
(683, 'Any changes here will be reviewed by provider staff before commiting to chart. The following apply'),
(684, 'Any changes here will be reviewed by provider staff before committing to your chart. The following apply'),
(685, 'Any changes that you need to make to this particular line item should be made here and saved'),
(686, 'any date'),
(687, 'Any Demographic Search'),
(688, 'Any part of the desired code or its description'),
(689, 'Any part of the desired specialty'),
(690, 'Any part of the drug id or drug name'),
(691, 'Any part of the immunization id or immunization name'),
(692, 'Any part of the patient name, or \"last,first\", or \"X-Y\"'),
(693, 'Anyother Relevant Information'),
(694, 'Anything else occur at the same time?'),
(695, 'Any{{Gender}}'),
(696, 'AOE Q&A'),
(697, 'APD{{afferent pupillary defect}}'),
(698, 'API'),
(699, 'API key for SMS Gateway.'),
(700, 'API Log Option'),
(701, 'API Log Option (Full includes requests and responses).'),
(702, 'API logging'),
(703, 'Apnea'),
(704, 'App'),
(705, 'App Launch URI'),
(706, 'App Logout URI'),
(707, 'App Name'),
(708, 'App Redirect URI'),
(709, 'App Registration Form'),
(710, 'Appearance'),
(711, 'Appearance:'),
(712, 'Append'),
(713, 'Append this message'),
(714, 'Append this note'),
(715, 'Append to the existing message'),
(716, 'Append to the existing note'),
(717, 'Append to this note'),
(718, 'Append to This Note'),
(719, 'Appendectomy'),
(720, 'appendectomy'),
(721, 'Applicable Patients'),
(722, 'Application'),
(723, 'Application name for login page and main window title.'),
(724, 'Application Receiver Code (GS03 - If blank ISA08 will be used)'),
(725, 'Application Sender Code (GS02)'),
(726, 'Application Title'),
(727, 'Applies to the Vitals form and Growth Chart'),
(728, 'Applies to Vitals form'),
(729, 'Apply the changes to the Current event only, to this and all Future occurrences, or to All occurrences?'),
(730, 'apply to affected area'),
(731, 'apply to skin'),
(732, 'Applying'),
(733, 'Applying Patch to site'),
(734, 'Appointment'),
(735, 'Appointment Category'),
(736, 'Appointment Date'),
(737, 'Appointment Display Sets - Color 1'),
(738, 'Appointment Display Sets - Color 2'),
(739, 'Appointment Display Sets - Color 3'),
(740, 'Appointment Display Sets - Color 4'),
(741, 'Appointment Display Sets - Ignore Display Limit (Last Set)'),
(742, 'Appointment Display Style'),
(743, 'Appointment made by'),
(744, 'Appointment Reminder Rule'),
(745, 'Appointment Reminders'),
(746, 'Appointment status'),
(747, 'Appointment Statuses'),
(748, 'Appointment within'),
(749, 'Appointment/Event Color'),
(750, 'Appointments'),
(751, 'Appointments (write optional)'),
(752, 'Appointments (write,wsome optional)'),
(753, 'Appointments (write,wsome optional) (appt)'),
(754, 'Appointments - Group Summary - Number to Display'),
(755, 'Appointments - Onsite Patient Portal - Number to Display'),
(756, 'Appointments - Patient Summary - Number to Display'),
(757, 'Appointments - shows all future appointments as well as Recalls'),
(758, 'Appointments and Encounters'),
(759, 'Appointments for'),
(760, 'Appointments Report'),
(761, 'Appointments-Encounters Report'),
(762, 'Appropriate Results'),
(763, 'Appropriate Testing for Children with Pharyngitis (CQM)'),
(764, 'Approve'),
(765, 'Approve Order'),
(766, 'Approve the patient from Patient/Client->Import->Pending Approval'),
(767, 'Approved'),
(768, 'Approved Events Administration'),
(769, 'Approved Successfully'),
(770, 'Apps'),
(771, 'Appt Date'),
(772, 'Appt Status'),
(773, 'Appt Time'),
(774, 'Appt-Enc'),
(775, 'Appt. Reminders'),
(776, 'Appts'),
(777, 'Appt{{Abbreviation for appointment}}'),
(778, 'App{{Applanation abbreviation}}'),
(779, 'Apr'),
(780, 'April'),
(781, 'AP{{applanation}}'),
(782, 'Arabic'),
(783, 'Aragonese'),
(784, 'Archive'),
(785, 'Archive Log Files'),
(786, 'Archive old files'),
(787, 'Are access control group names to be translated?'),
(788, 'Are appointment category names to be translated?'),
(789, 'Are document category names to be translated?'),
(790, 'Are fees charged for this type?'),
(791, 'are off'),
(792, 'are on'),
(793, 'Are patient note titles to be translated?'),
(794, 'Are the codes stored in external sql tables (0-No, 1-ICD10, 2-SNOMED(RF1), 3-SNOMED(RF2)) ?'),
(795, 'Are you prepared to complete a new GCAC issue for this visit?'),
(796, 'Are you sure to clear chat history?'),
(797, 'Are you sure to post for today?'),
(798, 'Are you sure you want to approve these events?'),
(799, 'Are you sure you want to cancel your changes?'),
(800, 'Are you sure you want to clear chats session history?'),
(801, 'Are you sure you want to completely remove this form?'),
(802, 'Are you sure you want to continue?'),
(803, 'Are you sure you want to delete'),
(804, 'Are you sure you want to delete this disclosure?'),
(805, 'Are you sure you want to delete this event?'),
(806, 'Are you sure you want to delete this item from the database?'),
(807, 'Are you sure you want to delete this message?'),
(808, 'Are you sure you want to delete this note?'),
(809, 'Are you sure you want to delete this plan?'),
(810, 'Are you sure you want to edit these events?'),
(811, 'Are you sure you want to hide these events?'),
(812, 'Are you sure you want to remove namespace'),
(813, 'Are you sure you want to transmit it again?'),
(814, 'Are you sure you want to view these events?'),
(815, 'Are you sure you wish to delete the entire group named'),
(816, 'Are you sure you wish to delete the entire list'),
(817, 'Are you sure you wish to delete the field in'),
(818, 'Are you sure you wish to delete the selected fields?'),
(819, 'Are you sure you\'d like to continue with these actions?'),
(820, 'Area not specified'),
(821, 'Arm'),
(822, 'Armenian'),
(823, 'ARNear{{Auto-refraction near acuity}}'),
(824, 'ARNear{{autorefraction near}}'),
(825, 'Arrival'),
(826, 'Arrive Time'),
(827, 'Arrived'),
(828, 'Arrived late'),
(829, 'Arrythmia'),
(830, 'Arthritis'),
(831, 'Arthritis / degen joint diseas'),
(832, 'Arthritis / degen joint disease'),
(833, 'Article'),
(834, 'AR{{Autorefraction Acuity}}'),
(835, 'AR{{autorefraction}}'),
(836, 'as'),
(837, 'As appears on documents'),
(838, 'As Of'),
(839, 'As the first step choose Group or Custom Favorite Group, as the case may be, as the Top Level Tier 1 and fill in the required details'),
(840, 'As the secret key need by the authenticator is stored on the mobile phone malware can steal these keys and thus compromise authentication'),
(841, 'As this is an infrequently performed process additional help in provided by clicking on the help icon that is revealed when you hover over the label for each box'),
(842, 'As we are creating a Custom Group for manual entry of returned results we need to create a place to enter these results'),
(843, 'As will appear on documents.'),
(844, 'ASC'),
(845, 'Asian'),
(846, 'Assamese'),
(847, 'Assess Penicillin Allergy'),
(848, 'Assessment'),
(849, 'Assign it to this one?'),
(850, 'Assign Severity and Save'),
(851, 'Assign the dosage values etc. and click Save'),
(852, 'Assign the message to the correct patient by clicking Patient: Click to select, assign a Type and forward the message on to the correct clinician or staff member'),
(853, 'Assigned To'),
(854, 'Assistant'),
(855, 'Assisted Living Facility'),
(856, 'Associate'),
(857, 'Associated'),
(858, 'Associated Notes.'),
(859, 'Assume patients permit Messaging'),
(860, 'Assume patients receive HIPAA policy'),
(861, 'Asthma'),
(862, 'at'),
(863, 'At least one search parameter is required if you select All.'),
(864, 'At present e-prescribing from openEMR is possible only in the United States'),
(865, 'At present only Continuity of Care Record (CCR) Continuity of Care Document (CCD) can be sent using phiMail'),
(866, 'At the Navicular'),
(867, 'At the Navicular:'),
(868, 'Athletic team'),
(869, 'Athletic Team'),
(870, 'Athletic/Injury'),
(871, 'ATNA audit CA certificate'),
(872, 'ATNA audit host'),
(873, 'ATNA audit local certificate'),
(874, 'ATNA audit port'),
(875, 'Atropine 1%'),
(876, 'Attending physician'),
(877, 'Attention'),
(878, 'Attention: Pending Documents'),
(879, 'Attn'),
(880, 'Attributes'),
(881, 'Audiological physician'),
(882, 'Audit all Emergency User Queries'),
(883, 'Audit CDR Engine Queries'),
(884, 'Audit Changes'),
(885, 'Audit Log Tamper'),
(886, 'Audit Log Tamper Report'),
(887, 'Audit log tampering evident at entry number'),
(888, 'Audit Log Validated Successfully'),
(889, 'Audit Log Validation Failed'),
(890, 'Audit Logging Backups'),
(891, 'Audit Logging Miscellaneous'),
(892, 'Audit Logging Order'),
(893, 'Audit Logging Patient Record'),
(894, 'Audit Logging Scheduling'),
(895, 'Audit Logging Security Administration'),
(896, 'Audit Logging SELECT Query'),
(897, 'Audit Payment'),
(898, 'Aug'),
(899, 'August'),
(900, 'Aunt'),
(901, 'Auth'),
(902, 'Auth/notes'),
(903, 'Authenticate TOTP'),
(904, 'Authenticate U2F'),
(905, 'Authenticating'),
(906, 'Authenticating the user thus becomes an important factor in this endeavor'),
(907, 'Authentication Argon Hash Memory Cost'),
(908, 'Authentication argon hash memory cost. Suggest PHP Default unless you know what you are doing.'),
(909, 'Authentication Argon Hash Thread Number'),
(910, 'Authentication argon hash thread number. Suggest PHP Default unless you know what you are doing.'),
(911, 'Authentication Argon Hash Time Cost'),
(912, 'Authentication argon hash time cost. Suggest PHP Default unless you know what you are doing.'),
(913, 'Authentication Bcrypt Hash Cost'),
(914, 'Authentication bcrypt hash cost. Suggest PHP Default unless you know what you are doing.'),
(915, 'Authentication Error'),
(916, 'Authentication SHA512 Hash Rounds Number'),
(917, 'Authentication SHA512 hash rounds number.'),
(918, 'Authenticator'),
(919, 'Authenticator apps are available for both ios and android devices at their respective app stores and is free to use'),
(920, 'Author'),
(921, 'Authorization'),
(922, 'Authorization group'),
(923, 'Authorization Status'),
(924, 'Authorizations'),
(925, 'Authorize'),
(926, 'Authorize - any encounters'),
(927, 'Authorize - any encounters (auth_a)'),
(928, 'Authorize - my encounters'),
(929, 'Authorize - my encounters (auth)'),
(930, 'Authorize as my Electronic Signature.'),
(931, 'Authorize or not as needed'),
(932, 'Authorize.Net'),
(933, 'Authorize.net'),
(934, 'Authorized'),
(935, 'Authorized Id'),
(936, 'Authorized Only'),
(937, 'Authorized Users'),
(938, 'Authorizing'),
(939, 'Authy'),
(940, 'Auto Refraction'),
(941, 'Auto Send'),
(942, 'Auto Sign-Off [days]'),
(943, 'Auto Transfer'),
(944, 'Auto-Create New Encounters'),
(945, 'Auto-generated'),
(946, 'Auto-Refraction'),
(947, 'Automated Measure Calculations (AMC)'),
(948, 'Automated Measure Calculations (AMC) - 2011'),
(949, 'Automated Measure Calculations (AMC) - 2014'),
(950, 'Automated Measure Calculations (AMC) - 2014 Stage I'),
(951, 'Automated Measure Calculations (AMC) - 2014 Stage II'),
(952, 'Automated Measure Calculations (AMC) Tracking'),
(953, 'Automated Measures (AMC)'),
(954, 'Automated Voice Message permission'),
(955, 'Automatic'),
(956, 'Automatic from sale'),
(957, 'Automatically applies correct extension on successful upload'),
(958, 'Automatically create a new encounter when an appointment check in status is selected.'),
(959, 'Automatically create a new encounter when appointment status is set to \"@\" (arrived).'),
(960, 'Automatically replicate justification codes in Fee Sheet'),
(961, 'Automatically replicate justification codes in Fee Sheet (basically fills in the blanks with the justification code above it).'),
(962, 'Automobile Medical'),
(963, 'AutoRef'),
(964, 'autosaved'),
(965, 'Auto{{autorefraction}}'),
(966, 'Available Appointments Calendar'),
(967, 'Available categories'),
(968, 'Available Document'),
(969, 'Available Recipients'),
(970, 'Available Services'),
(971, 'Available Times'),
(972, 'Available Tracks'),
(973, 'Avaric'),
(974, 'Avery Label type for printing patient labels from popups in left nav screen'),
(975, 'Avestan'),
(976, 'Avg Monthly'),
(977, 'AVM'),
(978, 'AVM Confirmed'),
(979, 'AVM OK'),
(980, 'Avulsion / avulsion fracture'),
(981, 'Avulsion lateral malleolus'),
(982, 'Avulsion medial malleolus '),
(983, 'Awareness-Based'),
(984, 'Axial Length'),
(985, 'Axillary'),
(986, 'Axis{{Axis in a glasses prescription}}'),
(987, 'Axis{{Axis of a glasses prescription}}'),
(988, 'AXIS{{Axis of a glasses prescription}}'),
(989, 'AxLength{{axial Length}}'),
(990, 'Aymara'),
(991, 'Azerbaijani'),
(992, 'b.i.d.'),
(993, 'Back'),
(994, 'back'),
(995, 'Back eight visits'),
(996, 'Back eleven visits'),
(997, 'Back five visits'),
(998, 'Back four visits'),
(999, 'Back nine visits'),
(1000, 'Back one visit'),
(1001, 'Back Pain'),
(1002, 'Back Problems'),
(1003, 'Back seven visits'),
(1004, 'Back six visits'),
(1005, 'Back Surgery'),
(1006, 'Back ten visits'),
(1007, 'Back three visits'),
(1008, 'Back to Admin Page'),
(1009, 'Back to Client List'),
(1010, 'Back To Editor'),
(1011, 'Back to encounter'),
(1012, 'Back to Patient'),
(1013, 'Back To Patient'),
(1014, 'Back to patient dashboard'),
(1015, 'Back to Users'),
(1016, 'Back To View'),
(1017, 'Back twelve visits'),
(1018, 'Back two visits'),
(1019, 'Background Services'),
(1020, 'Backup'),
(1021, 'Backup Failed missing generated file'),
(1022, 'Backup file has been created. Will now send download.'),
(1023, 'Backup List'),
(1024, 'Backup Successfully taken in'),
(1025, 'Bad check'),
(1026, 'Bad debt'),
(1027, 'Bahasa Indonesia'),
(1028, 'Bal'),
(1029, 'Bal Due'),
(1030, 'Bal-Due'),
(1031, 'Balance'),
(1032, 'balance'),
(1033, 'Balance Amt'),
(1034, 'Balance Due'),
(1035, 'Balance Payment'),
(1036, 'Balanced'),
(1037, 'Bambara'),
(1038, 'Bank Draft'),
(1039, 'Barcode Label'),
(1040, 'Barcode Label Type'),
(1041, 'Barcode type for printing barcode labels from popups in left nav screen.'),
(1042, 'Base of fifth (5th) Metarsal'),
(1043, 'Base of fifth (5th) Metarsal:'),
(1044, 'Base URL for FHIR Server.'),
(1045, 'Base URL for FHIR Server. Url should end with /'),
(1046, 'Based on the individual practice\'s need the tests can be organized into various groups'),
(1047, 'Bashkir'),
(1048, 'Basic patient information is included, such as patient and provider information, insurance, patient health status, recent care provided, care plan information, and reason for referral or transfer'),
(1049, 'Basque'),
(1050, 'Batch Claim'),
(1051, 'Batch Communication Tool'),
(1052, 'Batch Communication Tool (batchcom)'),
(1053, 'Batch Payment Entry'),
(1054, 'Batch Payments'),
(1055, 'Batch processing initiated; this may take a while.'),
(1056, 'Batch Results'),
(1057, 'BatchCom'),
(1058, 'BAT{{Brightness Acuity Testing}}'),
(1059, 'BC{{Base Curve}}'),
(1060, 'Be patient, some files can take several minutes to process!'),
(1061, 'Be patient, this can take a while.'),
(1062, 'Be sure to branch it off the Well Woman Tests line (Tier 1), if properly branched both TSH and vitamin D should have a Tier value of 2'),
(1063, 'because that id does not exist.'),
(1064, 'before'),
(1065, 'before (PM)'),
(1066, 'Before beginning to use the Fee Sheet read through this help page and do some preliminary setup.'),
(1067, 'Before proceeding to configuring the tests themselves you would need to review the values included in the standard release and make changes according to need'),
(1068, 'Before we proceed to create a Custom Group of Tests and save it as a Favorite a quick recap of the principles involved'),
(1069, 'Before you begin customization please ensure that all the ICD and CPT codes you will be needing have been entered into the database'),
(1070, 'Before you start entering data check the spreadsheet once again and make adjustments as needed'),
(1071, 'Before you try out electronic ordering you need to understand the issues involved'),
(1072, 'Begin'),
(1073, 'Begin and End date if information is available'),
(1074, 'Begin Date'),
(1075, 'Begin date if known'),
(1076, 'Beginning Date for Ledger Report'),
(1077, 'Beginning date of service yyyy-mm-dd'),
(1078, 'Beginning hour of day for calendar events.'),
(1079, 'Beginning of Current Work Week'),
(1080, 'Being a software application it can be compromised by malware that steals the secret key or by social engineering'),
(1081, 'Belarusian'),
(1082, 'Belching'),
(1083, 'Below lower panic limits'),
(1084, 'Below this is a table that contains the existing transactions, if any, pertaining to the current patient'),
(1085, 'Benefit Type'),
(1086, 'Bengali'),
(1087, 'Bengali- Bangla'),
(1088, 'Best of Luck.'),
(1089, 'between'),
(1090, 'bg{{image canvas label}}'),
(1091, 'Bidirectional'),
(1092, 'Bifocal'),
(1093, 'Bifocals'),
(1094, 'Bihari'),
(1095, 'Bilateral'),
(1096, 'Bilateral:'),
(1097, 'Bill'),
(1098, 'Bill Date'),
(1099, 'Bill Date:'),
(1100, 'Bill Type'),
(1101, 'Bill/Collect'),
(1102, 'Billed'),
(1103, 'Billed Date'),
(1104, 'Billing'),
(1105, 'Billing (write optional)'),
(1106, 'Billing (write optional) (bill)'),
(1107, 'Billing - provides a summary of the balances - Patient Balance Due, Insurance Balance Due, Total Balance Due and lists the name of the Primary Insurance along with its effective date'),
(1108, 'Billing Address'),
(1109, 'Billing Attn'),
(1110, 'Billing Code Descriptions'),
(1111, 'Billing Code for Requested Service'),
(1112, 'Billing codes'),
(1113, 'Billing Data'),
(1114, 'Billing Department'),
(1115, 'Billing Facility'),
(1116, 'Billing Facility lets you choose the facility used for billing. To create and edit the billing facility go to Administration  > Facilities'),
(1117, 'Billing Information'),
(1118, 'Billing Location'),
(1119, 'Billing Log'),
(1120, 'Billing Log Append'),
(1121, 'Billing log is empty'),
(1122, 'Billing Log Option'),
(1123, 'Billing Log Overwrite'),
(1124, 'Billing log setting to append or overwrite the log file.'),
(1125, 'Billing Manager'),
(1126, 'Billing Note'),
(1127, 'Billing Note for '),
(1128, 'Billing Note:'),
(1129, 'Billing queue results'),
(1130, 'Billing queue results:'),
(1131, 'Billing Report'),
(1132, 'Billing Status'),
(1133, 'Billing Status = Unbilled'),
(1134, 'billing to '),
(1135, 'Billing View'),
(1136, 'Binocular Pupillary Diameter - Distance'),
(1137, 'Binocular Pupillary Diameter - Near'),
(1138, 'Biopsy'),
(1139, 'Birth Certificate'),
(1140, 'Birth Date'),
(1141, 'Birth-24 months'),
(1142, 'Birthing Center'),
(1143, 'Bislama'),
(1144, 'Black'),
(1145, 'Black lines show previously existing information.'),
(1146, 'Black list'),
(1147, 'Black Lung'),
(1148, 'Black or African American'),
(1149, 'Bladder Cancer'),
(1150, 'Bladder Infections'),
(1151, 'Blank'),
(1152, 'Blank Forms'),
(1153, 'Bleeding Problems'),
(1154, 'Blind Spots'),
(1155, 'Blindness'),
(1156, 'Bloating'),
(1157, 'Block all files types that are not found in the White List. Can find interface to edit the White List at Administration->Files.'),
(1158, 'Blocked'),
(1159, 'Blood'),
(1160, 'Blood Pressure'),
(1161, 'Blood pressure'),
(1162, 'Bloody Nose'),
(1163, 'Blue Cross Blue Shield'),
(1164, 'Blue lines in this report are informational.'),
(1165, 'Blue lines in this report are informational. Black lines show previously existing information.  Green lines show changes that were successfully applied.  Red lines indicate errors, or changes that were not applied; these must be processed manually.  Currently denied claims and payment reversals are not handled automatically and so will appear in red.'),
(1166, 'Blurred Vision'),
(1167, 'BMI'),
(1168, 'BMI Status'),
(1169, 'Body'),
(1170, 'Body Region'),
(1171, 'Body Site'),
(1172, 'Body site, if applicable'),
(1173, 'Bone Tenderness:'),
(1174, 'Bone Tenderness: Medial Malleolus'),
(1175, 'Boolean'),
(1176, 'Bosnian'),
(1177, 'Bot'),
(1178, 'Both'),
(1179, 'Both Ears'),
(1180, 'both ears'),
(1181, 'Both Name and Category will be highlighted yellow to provide an additional visual clue that this is an order. A fact that will be appreciated when several orders are entered in the system along with their respective groups and results'),
(1182, 'Both rendering and supervising providers can be set here'),
(1183, 'Bottom'),
(1184, 'Bottom Margin (px)'),
(1185, 'Box 10 - This information indicates whether the patient’s illness or injury is related to employment, auto accident, or other accident'),
(1186, 'Box 10 A. Employment related'),
(1187, 'BOX 10 A. Employment related '),
(1188, 'Box 10 B. Auto Accident'),
(1189, 'BOX 10 B. Auto Accident '),
(1190, 'Box 10 C. Other Accident'),
(1191, 'BOX 10 C. Other Accident '),
(1192, 'Box 10 D - Is used to submit the Early and Periodic Screening, Diagnosis and Treatment (EPSDT) Referral Code'),
(1193, 'Box 10 D. EPSDT Referral Code'),
(1194, 'BOX 10 D. EPSDT Referral Code'),
(1195, 'Box 10. a. Employment related:'),
(1196, 'Box 10. b. Auto Accident:'),
(1197, 'Box 10. c. Other Accident:'),
(1198, 'Box 10. d. EPSDT Referral Code:'),
(1199, 'Box 14 - It identifies the first date of onset of illness, the actual date of injury, or the LMP for pregnancy. Enter the date in the first box and select either Onset of Current Symptoms or Illness or LMP from the drop-down box'),
(1200, 'BOX 14 Date Qualifier'),
(1201, 'BOX 14. Is Populated from the Encounter Screen as the Onset Date'),
(1202, 'Box 14. Onset Date:'),
(1203, 'Box 15 - The Other Date identifies additional date information about the patient’s condition or treatment. Enter the date in the first box and select a qualifier from the drop-down box'),
(1204, 'BOX 15 Other Date Qualifier'),
(1205, 'BOX 15. Date of same or similar illness (yyyy-mm-dd):'),
(1206, 'BOX 15. Date of same or similar illness/Other Date (yyyy-mm-dd):'),
(1207, 'Box 15. Other Date:'),
(1208, 'Box 16 - Dates Patient Unable to Work in Current Occupation - is the time span the patient is or was unable to work'),
(1209, 'Box 16. Date unable to work from'),
(1210, 'BOX 16. Date unable to work from'),
(1211, 'BOX 16. Date unable to work from (yyyy-mm-dd):'),
(1212, 'Box 16. Date unable to work from:'),
(1213, 'Box 16. Date unable to work to'),
(1214, 'BOX 16. Date unable to work to'),
(1215, 'BOX 16. Date unable to work to (yyyy-mm-dd):'),
(1216, 'Box 16. Date unable to work to:'),
(1217, 'Box 17 - The name entered is the referring provider, ordering provider or supervising provider who referred, ordered, or supervised the service(s) or supply(ies) on the claim. If multiple providers are involved, enter one provider using the following priority order: 1. Referring Provider, 2. Ordering Provider, 3. Supervising Provider.'),
(1218, 'Box 17. Provider'),
(1219, 'BOX 17. Provider'),
(1220, 'Box 17. Provider Qualifier'),
(1221, 'BOX 17. Provider Qualifier'),
(1222, 'Box 17. Provider Qualifier:'),
(1223, 'Box 17. Provider:'),
(1224, 'Box 18 - The “Hospitalization Dates Related to Current Services” would refer to an inpatient stay and indicates the admission and discharge dates associated with the service(s) on the claim'),
(1225, 'Box 18. Hospitalization date from'),
(1226, 'BOX 18. Hospitalization date from'),
(1227, 'BOX 18. Hospitalization date from (yyyy-mm-dd): '),
(1228, 'Box 18. Hospitalization date from:'),
(1229, 'Box 18. Hospitalization date to'),
(1230, 'BOX 18. Hospitalization date to'),
(1231, 'BOX 18. Hospitalization date to (yyyy-mm-dd): '),
(1232, 'Box 18. Hospitalization date to:'),
(1233, 'Box 20 - Indicates that services have been rendered by an independent provider as indicated in Box 32 (Service Facility Location Information) and the related costs'),
(1234, 'Box 20. Is Outside Lab used?'),
(1235, 'BOX 20. Is Outside Lab used?'),
(1236, 'Box 22 - Medicaid Resubmission Code and Original Reference Number is the code and original reference number assigned by the destination payer or receiver to indicate a previously submitted claim or encounter'),
(1237, 'Box 22. Medicaid Resubmission Code (ICD-10)'),
(1238, 'Box 22. Medicaid Resubmission Code (ICD-9) '),
(1239, 'BOX 22. Medicaid Resubmission Code (ICD-9) '),
(1240, 'Box 23 - Prior Authorization Number is the payer assigned number authorizing the service(s)'),
(1241, 'Box 23. Prior Authorization No.'),
(1242, 'Box 23. Prior Authorization No. '),
(1243, 'BOX 23. Prior Authorization No. '),
(1244, 'BP'),
(1245, 'BP Diastolic'),
(1246, 'BP Systolic'),
(1247, 'BPD'),
(1248, 'Bpd'),
(1249, 'BPD-D{{abbreviation for Binocular Pupillary Diameter - Distance}}'),
(1250, 'BPD-N{{abbreviation for Binocular Pupillary Diameter - Near}}'),
(1251, 'BPS'),
(1252, 'Bps'),
(1253, 'Brand'),
(1254, 'Brazilian Portuguese'),
(1255, 'Breast'),
(1256, 'Breast Biopsy'),
(1257, 'Breast Discharge'),
(1258, 'Breast Disease'),
(1259, 'Breast Exam'),
(1260, 'Breast Mass'),
(1261, 'Breath'),
(1262, 'Breath Sounds:'),
(1263, 'Breton'),
(1264, 'Brightness Acuity Testing'),
(1265, 'Broken Bones'),
(1266, 'broken form'),
(1267, 'Bronchitis Form'),
(1268, 'Brother'),
(1269, 'Brow'),
(1270, 'Browse'),
(1271, 'Browse for Record'),
(1272, 'Bruising/haematoma'),
(1273, 'Build diagnoses list by clicking appropriate code button.'),
(1274, 'Build Your Plan'),
(1275, 'Bulgarian'),
(1276, 'Bulging Right:'),
(1277, 'Burmese'),
(1278, 'Burning with Urination'),
(1279, 'Burning With Urination'),
(1280, 'Business Associate Agreement'),
(1281, 'Business Phone'),
(1282, 'Busy'),
(1283, 'but not yet processed.'),
(1284, 'Buttock'),
(1285, 'Buttock + S.I.'),
(1286, 'by'),
(1287, 'By'),
(1288, 'By default Active Messages are displayed as indicated in the section below the Messages caption'),
(1289, 'By default all codes are selected, uncheck the codes you do not want and click \'Add\'. These codes will then be added to the current encounter'),
(1290, 'By default only Demographics and Billing information is selected'),
(1291, 'By default only five dated reminders are shown at a time'),
(1292, 'By default the User Memberships section is selected and all the active registered users will be listed in alphabetical order by their user names.'),
(1293, 'by mouth'),
(1294, 'By selecting a payment method the rates calculated for that payment method will be automatically displayed in \'Selected Fee Sheet Codes and Charges for Current Encounter\' section'),
(1295, 'By/Source'),
(1296, 'By:'),
(1297, 'by{{made by/manufacturer}}'),
(1298, 'B{{both sides}}'),
(1299, 'C'),
(1300, 'C/D Ratio{{cup to disc ration}}'),
(1301, 'CA Certificate for verifying the RFC 5425 TLS syslog server.'),
(1302, 'Cache Lifetime (in seconds)'),
(1303, 'Cache template output?'),
(1304, 'Caffeine'),
(1305, 'Caffeine consumption'),
(1306, 'Calendar'),
(1307, 'Calendar Ending Hour'),
(1308, 'Calendar Interval'),
(1309, 'Calendar Screen'),
(1310, 'Calendar Settings'),
(1311, 'Calendar Settings (calendar)'),
(1312, 'Calendar Starting Hour'),
(1313, 'Calendar UI'),
(1314, 'Calendar View'),
(1315, 'calendar_external to events'),
(1316, 'Call Back Notes'),
(1317, 'Call to addForm() goes here.<br>'),
(1318, 'Callback'),
(1319, 'Callback Performed'),
(1320, 'Callback requested'),
(1321, 'Calories'),
(1322, 'Cambodian'),
(1323, 'CAMOS'),
(1324, 'Can not determine OS!'),
(1325, 'Can not set this unless the Summary of Care Sent toggle is set.'),
(1326, 'Can\'t find file!'),
(1327, 'Can\'t upload'),
(1328, 'Canada'),
(1329, 'Cancel'),
(1330, 'cancel'),
(1331, 'Cancel Appointment'),
(1332, 'Cancel Changes'),
(1333, 'Canceled'),
(1334, 'Canceled < 24h'),
(1335, 'Cancer'),
(1336, 'Cancer Screening: Colon Cancer Screening'),
(1337, 'Cancer Screening: Mammogram'),
(1338, 'Cancer Screening: Pap Smear'),
(1339, 'Cancer Screening: Prostate Cancer Screening'),
(1340, 'Cannot add this entry because it already exists!'),
(1341, 'Cannot add/update this entry because a duplicate already exists!'),
(1342, 'cannot be archived, ignored'),
(1343, 'cannot be converted to JPEG. Perhaps ImageMagick is not installed?'),
(1344, 'cannot be deleted, ignored'),
(1345, 'cannot be displayed inline because its type is not supported by the browser.'),
(1346, 'cannot be displayed inline becuase its type is not supported by the browser'),
(1347, 'cannot be displayed inline becuase its type is not supported by the browser.'),
(1348, 'Cannot be used in case of the absence of the cellular coverage'),
(1349, 'Cannot create'),
(1350, 'Cannot create file'),
(1351, 'Cannot delete (from SFTP server) file'),
(1352, 'Cannot delete file'),
(1353, 'Cannot determine a destination filename'),
(1354, 'Cannot find '),
(1355, 'Cannot find a destination filename'),
(1356, 'Cannot find a skip source field for'),
(1357, 'Cannot find a skip target field for'),
(1358, 'Cannot find patient from SQL-Ledger customer id'),
(1359, 'Cannot find postscript document reference in '),
(1360, 'Cannot find provider from SQL-Ledger employee = '),
(1361, 'Cannot Modify Payments.Undistributed is Negative.'),
(1362, 'Cannot open'),
(1363, 'Cannot open '),
(1364, 'Cannot Post for Insurance.The Paying Entity selected is Patient.'),
(1365, 'Cannot Post for Patient.The Paying Entity selected is Insurance.'),
(1366, 'Cannot Post Payments.Undistributed is Negative.'),
(1367, 'Cannot read'),
(1368, 'Cannot read directory'),
(1369, 'Cannot update because you are not editing an existing entry!'),
(1370, 'Capitalize'),
(1371, 'Capitalize all'),
(1372, 'capsule'),
(1373, 'Card'),
(1374, 'Card CVV'),
(1375, 'Card Expiry Date'),
(1376, 'Card Expiry Date and Card Holders Zip'),
(1377, 'Card Holder Zip'),
(1378, 'Card Name'),
(1379, 'Card Number'),
(1380, 'Card Type'),
(1381, 'Cardiac'),
(1382, 'Cardiac Catheterization'),
(1383, 'Cardiac Echo'),
(1384, 'Cardiovascular'),
(1385, 'Care Coordination'),
(1386, 'Care Coordination Only'),
(1387, 'Care documentation'),
(1388, 'Care giver'),
(1389, 'Care Plan'),
(1390, 'Care Plan Form'),
(1391, 'Care plan recommendations'),
(1392, 'Care Team'),
(1393, 'Careful planning is essential before entering the tests to ensure subsequent ease of use and proper display of results'),
(1394, 'Carotid Bruit'),
(1395, 'Carotid{{carotid arteries}}'),
(1396, 'Cartilage / chondral / disc damage'),
(1397, 'Cartilage injury'),
(1398, 'Cartoid pulsations nl, pedal pulses nl'),
(1399, 'CAR{{carotid arteries}}'),
(1400, 'cash'),
(1401, 'Cash'),
(1402, 'Cash Rec'),
(1403, 'Cash Receipts by Provider'),
(1404, 'Catalan- Valencian'),
(1405, 'Cataract'),
(1406, 'Cataract Surgery'),
(1407, 'Cataracts'),
(1408, 'Categories'),
(1409, 'Categories for'),
(1410, 'Category'),
(1411, 'category'),
(1412, 'Category '),
(1413, 'Category - Order, Result and Recommendation need an identifying code'),
(1414, 'Category changed.'),
(1415, 'Category Color Schema'),
(1416, 'Category Details'),
(1417, 'Category Limits'),
(1418, 'Category Name'),
(1419, 'Category name is empty'),
(1420, 'Category/Title'),
(1421, 'Caucasian'),
(1422, 'Causes Receipts to Print Encounter/Primary Provider Info'),
(1423, 'cc Distance{{with correction at distance}}'),
(1424, 'cc Near{{with correction at Near}}'),
(1425, 'CCD'),
(1426, 'CCDA'),
(1427, 'ccDist{{ACT with Correction Distance}}'),
(1428, 'ccDist{{with correction distance}}'),
(1429, 'ccNear{{ACT with Correction Near}}'),
(1430, 'ccNear{{with correction at near}}'),
(1431, 'CCR'),
(1432, 'CCR Approve'),
(1433, 'CCR Patient Review'),
(1434, 'CCR Review and Approve'),
(1435, 'CC{{Chief Complaint}}'),
(1436, 'cc{{with correction}}'),
(1437, 'CC{{with correction}}'),
(1438, 'CDA defines building blocks which can be used to contain healthcare data elements that can be captured, stored, accessed, displayed and transmitted electronically for use and reuse in many formats'),
(1439, 'CDA or Clinical Document Architecture is a document standard developed by the HL7 organization'),
(1440, 'CDC Code'),
(1441, 'CDC-NIP Code'),
(1442, 'CDR'),
(1443, 'CDR Reports Processing Priority'),
(1444, 'Cell'),
(1445, 'Cell Phone'),
(1446, 'Cell phone number'),
(1447, 'Cell Phone Number'),
(1448, 'Centered Layout'),
(1449, 'Central Certification'),
(1450, 'Central Macular Thickness'),
(1451, 'Central/South American'),
(1452, 'Certificate Authority crt file location cannot be empty'),
(1453, 'Certificate Authority key file location cannot be empty'),
(1454, 'Certificate to send to RFC 5425 TLS syslog server.'),
(1455, 'Certificate User'),
(1456, 'Certificates'),
(1457, 'Chamorro'),
(1458, 'ChampUS'),
(1459, 'ChampUSVA'),
(1460, 'change'),
(1461, 'Change'),
(1462, 'Change Activity'),
(1463, 'Change any item available and when ready click Send for review. The changes will be flagged and staff notified to review changes before commiting them to chart. During the time period before changes are reviewed the Revised button will show Pending and profile data is still available for changes. When accessing profile in pending state all previous edits will appear in Blue and current chart values in Red. You may revert any edit to chart value by clicking that red item (or vica versa) but remember that when you click Send for Review then items that populate the field items are the ones that are sent. Revert Edits button changes everything back to chart values and you may make changes from there. So to recap: Items in BLUE are patient edits with items in RED being original values before any edits.'),
(1464, 'Change any item available and when ready click Send for review. The changes will be flagged and staff notified to review changes before committing them to chart. During the time period before changes are reviewed the Revised button will show Pending and profile data is still available for changes. When accessing profile in pending state all previous edits will appear in Blue and current chart values in Red. You may revert any edit to chart value by clicking that red item (or vica versa) but remember that when you click Send for Review then items that populate the field items are the ones that are sent. Revert Edits button changes everything back to chart values and you may make changes from there. So to recap: Items in BLUE are patient edits with items in RED being original values before any edits.'),
(1465, 'Change Credentials'),
(1466, 'Change failed! CouchDB connect error?'),
(1467, 'Change in Vision'),
(1468, 'Change In Vision'),
(1469, 'Change or keep current. Enter 12 to 80 characters. Recommended to include symbols and numbers but not required.'),
(1470, 'Change Password'),
(1471, 'Change Password for'),
(1472, 'Change Portal Credentials'),
(1473, 'Change Status for'),
(1474, 'Change your password before it expires on'),
(1475, 'Changed'),
(1476, 'Changed Bowel'),
(1477, 'Changes the current theme to be more compact.'),
(1478, 'Changes the layout of the login page.'),
(1479, 'Changing patient ID for document'),
(1480, 'Changing the status to Done will remove the message from the active message list'),
(1481, 'Changing the status to New will achieve the same result'),
(1482, 'Changing the status to Read would leave it as a read message in the active messages list of the current user'),
(1483, 'Channels'),
(1484, 'Characteristics'),
(1485, 'Characters Remaining'),
(1486, 'Charge'),
(1487, 'Charge adjustment'),
(1488, 'Charge Coded'),
(1489, 'Charge Total'),
(1490, 'Charges'),
(1491, 'Chart'),
(1492, 'Chart Activity'),
(1493, 'Chart Check-in/out Activity Report'),
(1494, 'Chart History'),
(1495, 'Chart ID'),
(1496, 'Chart ID:'),
(1497, 'Chart Label'),
(1498, 'Chart Location Activity'),
(1499, 'Chart Note'),
(1500, 'Chart Number'),
(1501, 'Chart pulled'),
(1502, 'Chart Storage Locations'),
(1503, 'Chart to Category'),
(1504, 'Chart Tracker'),
(1505, 'Chart Trk'),
(1506, 'Chart View'),
(1507, 'Charting History.'),
(1508, 'Charts Checked Out'),
(1509, 'Charts Out'),
(1510, 'Chat'),
(1511, 'Chat history'),
(1512, 'Chechen'),
(1513, 'Check'),
(1514, 'check'),
(1515, 'Check All'),
(1516, 'Check All - Components'),
(1517, 'Check Amount'),
(1518, 'Check and adjust the settings in the standard release'),
(1519, 'Check Date'),
(1520, 'Check expiration dates.'),
(1521, 'Check for differences of translations with custom language table.'),
(1522, 'Check if a help file exists for this page in'),
(1523, 'Check if you plan to print postcards locally'),
(1524, 'Check if you plan to send postcards via MedEx'),
(1525, 'Check if you plan to use Avery Labels for Reminders or Recalls'),
(1526, 'Check In'),
(1527, 'Check In To'),
(1528, 'Check Input Data'),
(1529, 'Check items to graph'),
(1530, 'Check Lab Results'),
(1531, 'Check mark indicates reviewed'),
(1532, 'Check No'),
(1533, 'Check Number'),
(1534, 'Check Out'),
(1535, 'Check Out Time'),
(1536, 'Check Payment'),
(1537, 'Check the box if this is an encrypted file'),
(1538, 'Check the CPOE (Computerized Provider Order Entry) check-box'),
(1539, 'Check the Enable phiMail Direct Messaging Service check-box'),
(1540, 'Check the Sequence numbers'),
(1541, 'Check this if you want providers to see all appointments by default and not just their own.'),
(1542, 'Check this to go live. Not checked is testing mode.'),
(1543, 'Check to create problem from this diagnosis'),
(1544, 'Check/EOB Date'),
(1545, 'Check/EOB Date:'),
(1546, 'Check/EOB No.'),
(1547, 'Check/EOB No.:'),
(1548, 'Check/Ref Number'),
(1549, 'Check/Reference Number'),
(1550, 'Checkbox list'),
(1551, 'checkbox list'),
(1552, 'checkbox w/ text'),
(1553, 'Checkbox w/text'),
(1554, 'Checkbox(es)'),
(1555, 'Checkboxes above indicate if you want to reject and delete the HL7 file.'),
(1556, 'Checkboxes w/text'),
(1557, 'Checked'),
(1558, 'checked'),
(1559, 'Checked box = yes ,  empty = no'),
(1560, 'Checked box = yes, empty = no'),
(1561, 'Checked Drug Formulary?'),
(1562, 'Checked Out'),
(1563, 'Checked out'),
(1564, 'Checking any of the check boxes will result in a Yes on the CMS 1500 form'),
(1565, 'Checking the Groups and Access Controls checkbox will reveal this section that lists all the categories with sub-categories (ACOs), i.e. the parts of the program controlled by the access control list privileges.'),
(1566, 'Checking the lock checkbox will prevent any futher edits on any forms in this encounter.'),
(1567, 'Checking the Postcards check box will let you print a postcard that can be mailed to a patient'),
(1568, 'Checkout'),
(1569, 'Checksum'),
(1570, 'Chest'),
(1571, 'Chest CTAB'),
(1572, 'Chest Pain'),
(1573, 'Chest Pain:'),
(1574, 'Chest Pains'),
(1575, 'Chest physician'),
(1576, 'Chg'),
(1577, 'Chichewa- Chewa- Nyanja'),
(1578, 'Chief Complaint'),
(1579, 'Chief Complaint 2'),
(1580, 'Chief Complaint 3'),
(1581, 'Child'),
(1582, 'Child in-law'),
(1583, 'Childhood immunization Status (CQM)'),
(1584, 'Chills'),
(1585, 'Chinese'),
(1586, 'Chinese (Simplified)'),
(1587, 'Chinese (Traditional)'),
(1588, 'Chiropractic'),
(1589, 'Choices'),
(1590, 'Cholecystectomy'),
(1591, 'cholecystectomy'),
(1592, 'Cholecystestomy'),
(1593, 'Choose'),
(1594, 'choose'),
(1595, 'Choose a period or dates (YYYY-MM-DD)'),
(1596, 'Choose a section and click an item within it; then in the other section you will see the related items highlighted, and you can click in that section to add and delete relationships.'),
(1597, 'Choose Criteria'),
(1598, 'Choose CSV table'),
(1599, 'Choose Download or Display Inline'),
(1600, 'Choose either current provider or current logged in provider'),
(1601, 'Choose file'),
(1602, 'Choose File'),
(1603, 'Choose from list'),
(1604, 'Choose Layout Direction'),
(1605, 'Choose list'),
(1606, 'Choose one if appropriate'),
(1607, 'Choose one of the four return values that reflect varying degrees of privilege.'),
(1608, 'Choose Paper Size'),
(1609, 'Choose Patient'),
(1610, 'Choose PDF languange Preference'),
(1611, 'Choose print format for this encounter report.'),
(1612, 'Choose the layout (need to logout and then login to see this new setting).'),
(1613, 'Choose your default encounter view'),
(1614, 'Chrome browser version 41 and above, Mozilla Firefox browser version 64 and above, Microsoft Edge browser version 19 and above, Safari browser version 13 and above, Opera browser version 40 and Opera browser version 42 and above support FIDO U2F API'),
(1615, 'Chronic Bronchitis'),
(1616, 'Chronic Joint Pain'),
(1617, 'Chronic Kidney Disease (CKD)'),
(1618, 'Chronic or Inactive Problems'),
(1619, 'Chronic Problems'),
(1620, 'Chronic synovitis / effusion / joint pain / gout'),
(1621, 'Chronic/Inactive Problems'),
(1622, 'Chronic/Recurrent'),
(1623, 'Chuvash'),
(1624, 'Cigs'),
(1625, 'Cirrhosis of the Liver'),
(1626, 'Cirrhosis Of The Liver'),
(1627, 'City'),
(1628, 'City and state must both be filled out'),
(1629, 'City Name'),
(1630, 'City, State'),
(1631, 'City, State Zip'),
(1632, 'City,St,Zip'),
(1633, 'City/State'),
(1634, 'Claim'),
(1635, 'Claim '),
(1636, 'Claim Edit'),
(1637, 'Claim Status'),
(1638, 'Claim test has completed running'),
(1639, 'Claim Type'),
(1640, 'Claim was generated to file'),
(1641, 'Claim was generated to file '),
(1642, 'Claims'),
(1643, 'claims selected.'),
(1644, 'Class'),
(1645, 'Classification'),
(1646, 'Clear'),
(1647, 'clear'),
(1648, 'Clear 2FA'),
(1649, 'CLEAR ACTIVE PATIENT'),
(1650, 'CLEAR ACTIVE THERAPY GROUP'),
(1651, 'Clear All'),
(1652, 'Clear Filters'),
(1653, 'Clear history'),
(1654, 'Clear HL7 Data'),
(1655, 'Clear Justification'),
(1656, 'Clear Log'),
(1657, 'Clear Pad'),
(1658, 'Clear Signature'),
(1659, 'Clear Smarty Cache'),
(1660, 'Clear the log'),
(1661, 'Clearing house info required for EDI 270 batch creation.'),
(1662, 'CLIA Number'),
(1663, 'Click'),
(1664, 'Click \'export\' to export your Category, Subcategory, Item, Content data to a text file. Any resemblance of this file to an XML file is purely coincidental. The opening and closing tags must be on the same line, they must be lowercase with no spaces. To import, browse for a file and click \'import\'. If the data is completely different, it will merge with your existing data. If there are similar item names, The old one will be kept and the new one saved with a number added to the end.'),
(1665, 'Click \'Save\''),
(1666, 'Click \'Save\'. Now you will be able to use the Search feature to search all ICD 10 codes'),
(1667, 'Click a spot on the graphic to add a new annotation, click it again to remove it'),
(1668, 'Click and drag bottom right corner to resize this display'),
(1669, 'Click Browse and select one Electronic Remittance Advice (ERA) file...'),
(1670, 'Click Close to exit the Select Codes pop-up page'),
(1671, 'Click Download Certificate to download the certificates in the file ssl.zip'),
(1672, 'click for more'),
(1673, 'Click for more details'),
(1674, 'Click for order summary'),
(1675, 'Click for results'),
(1676, 'Click for Shorthand Help.'),
(1677, 'Click Got it icon to dismiss this alert forever.'),
(1678, 'Click here'),
(1679, 'Click Here to add a new patient.'),
(1680, 'Click here to add new injury change status and edit daily activity'),
(1681, 'Click here to add new row'),
(1682, 'Click here to choose a date'),
(1683, 'Click here to choose a date and time'),
(1684, 'Click here to choose a start date'),
(1685, 'Click here to choose date time'),
(1686, 'Click here to choose date time from'),
(1687, 'Click here to choose date time to'),
(1688, 'Click Here to Configure This module'),
(1689, 'Click here to delete all options'),
(1690, 'Click here to delete the row'),
(1691, 'Click here to delete the selection'),
(1692, 'Click Here to Disable This module'),
(1693, 'Click here to duplicate the row'),
(1694, 'Click here to edit list of available Lens Materials'),
(1695, 'Click here to edit list of available Lens Treatment Options'),
(1696, 'Click here to Edit the Contact Lens Brand List'),
(1697, 'Click here to Edit the Course/Occurrence List'),
(1698, 'Click here to Edit the Manufacter List'),
(1699, 'Click here to Edit the Supplier List'),
(1700, 'Click here to Edit this Doctor\'s Plan options'),
(1701, 'Click here to Edit this Doctor\'s Quick Pick list'),
(1702, 'Click here to Edit this Provider\'s Exam Default values'),
(1703, 'Click Here to Enable This module'),
(1704, 'Click Here to Install ACL for module'),
(1705, 'Click Here to Install SQL for module'),
(1706, 'Click Here to Install This module'),
(1707, 'click here to search'),
(1708, 'Click here to see observation results'),
(1709, 'Click Here to UnRegister this Module'),
(1710, 'click here to update priority, category and nickname settings'),
(1711, 'click here to update priority, category, nickname and access control settings'),
(1712, 'Click Here to Upgrade ACL for module'),
(1713, 'Click Here to Upgrade SQL for module'),
(1714, 'Click here to view all.'),
(1715, 'Click here to view and graph'),
(1716, 'Click here to view and graph all labdata.'),
(1717, 'Click here to view and graph all vitals.'),
(1718, 'Click here to view patient details'),
(1719, 'Click here to view them all.'),
(1720, 'Click here to view/edit more details'),
(1721, 'Click in signature'),
(1722, 'Click in signature on file'),
(1723, 'Click Install button to install database release from the following date'),
(1724, 'Click OK if you are sure.'),
(1725, 'Click OK to Clear or Cancel to continue processing.'),
(1726, 'Click OK to import these patients into the patient input box'),
(1727, 'Click Okay if you are sure you want to cancel this appointment?'),
(1728, 'Click on Add to bring up the Add/Edit Issue pop-up page'),
(1729, 'Click on Add to List button to add to the bottom section'),
(1730, 'Click on any of the time parts to increase it'),
(1731, 'Click on Create New Transaction to open the Add/Edit Patient Transaction page'),
(1732, 'Click on either the Invoice Search button on the far right, for manual entry or ERA Upload button for uploading an entire electronic remittance advice ERA file'),
(1733, 'Click on the \'Add Group\' button to create this new group (ARO).'),
(1734, 'Click on the + sign adjacent to the Serum Uric Acid test Name to reveal the newly created Result line'),
(1735, 'Click on the + sign at the far end of the Blood Glucose line to bring up the Enter Details pop-up in the Add Mode'),
(1736, 'Click on the Add icon at the far end of the Serum Chemistry line'),
(1737, 'Click on the Add New dropdown box and select an option'),
(1738, 'Click on the Allergy/Intolerance button'),
(1739, 'Click on the black + sign at the far end of the Well Woman Tests line to create a direct descendant or child to this Custom Top Group'),
(1740, 'Click on the black + sign on the Electrolyte Panel line to create a direct descendant or child'),
(1741, 'Click on the blue + sign to see the Procedure Order that was saved'),
(1742, 'Click on the blue plus sign under Name to reveal test names'),
(1743, 'Click on the Diagnosis Codes box to open the Select Diagnosis Codes pop-up window'),
(1744, 'Click on the File menu item on the top left of the Message center page ansd select Setup MedEx'),
(1745, 'Click on the icon next to the \'Access Control List Administration\' title to go to the phpGACL page.'),
(1746, 'Click on the Issues menu item to bring up the Issues page'),
(1747, 'Click on the Ledger menu item in the navigation bar to to enter the Patient Ledger page'),
(1748, 'Click on the Name text box on the left section to bring up the patient finder pop-up'),
(1749, 'Click on the New Recall button to open a new recall scheduling page'),
(1750, 'Click on the the following link to learn more about what is involved.'),
(1751, 'Click Patient Name to Open Patient File'),
(1752, 'Click Refresh and click on the blue + mark that precedes the name Serum Chemistry'),
(1753, 'Click Refresh to view all results, or please input search criteria above to view specific results.'),
(1754, 'Click Register to register the TOTP'),
(1755, 'Click Save'),
(1756, 'Click Save and then Refresh'),
(1757, 'Click Save to close the pop-up'),
(1758, 'Click Save to close the pop-up window'),
(1759, 'Click Save to create a new line with a Name of Well Womans Tests preceded by a vertical line indicating that it has no descendants or children'),
(1760, 'Click Save to save and close the pop-up'),
(1761, 'Click Save to save this problem'),
(1762, 'Click the \'Add New Group\' button to display the \'New Group Information\' section.'),
(1763, 'Click the \'Delete Group\' button to completely remove this group.'),
(1764, 'Click the \'Remove Group\' button to display the \'Remove Group Form\'.'),
(1765, 'Click the \'Yes\' radio button.'),
(1766, 'Click the Clear button to clear the imported patient names and start afresh'),
(1767, 'Click the Clear button to start afresh'),
(1768, 'Click the Delete button to delete all selected codes or select individual codes to be deleted from the drop-down box adjacent to the delete button and then click the Delete button'),
(1769, 'Click the pencil icon to grant and remove access privileges to the selected user'),
(1770, 'Click the Save button'),
(1771, 'Click the Search for Allergy button'),
(1772, 'Click the slashed-eye icon to close.'),
(1773, 'Click the Submit button to display the main log'),
(1774, 'Click the Transmit button to reveal the Direct address box'),
(1775, 'Click this to display/hide additional tests'),
(1776, 'Click to activate and send to this recipient.'),
(1777, 'Click to add a diagnosis'),
(1778, 'Click to add HCFA 1500 miscellaneous billing options'),
(1779, 'Click to add new components'),
(1780, 'Click to add new consultation'),
(1781, 'Click to add patient'),
(1782, 'Click to choose diagnoses to justify.'),
(1783, 'Click to Contract and set to henceforth open in Centered mode'),
(1784, 'Click to display shorthand field names.'),
(1785, 'Click to download'),
(1786, 'Click to edit'),
(1787, 'Click to edit description'),
(1788, 'Click to edit this event'),
(1789, 'Click to Expand and set to henceforth open in Expanded mode'),
(1790, 'Click to generate the report'),
(1791, 'Click to go to page'),
(1792, 'Click to Hide'),
(1793, 'Click to hide advanced search'),
(1794, 'Click to Hide Filters'),
(1795, 'Click to hide search'),
(1796, 'Click to learn more about the Clinical Document Architecture (CDA) and Consolidated CDA (C-CDA)'),
(1797, 'Click to make chat this current recipient only...'),
(1798, 'Click to manually configure access control, recommended for advanced users'),
(1799, 'Click to match patient'),
(1800, 'Click to print'),
(1801, 'Click to receive (add) new lot'),
(1802, 'Click to reveal more information'),
(1803, 'Click to search past and current diagnoses history'),
(1804, 'Click to see more information'),
(1805, 'Click to select'),
(1806, 'Click To Select'),
(1807, 'Click to select a default diagnosis or procedure code for this order'),
(1808, 'Click to select an industry-standard code for this procedure'),
(1809, 'Click to select diagnosis or procedure code to default to order'),
(1810, 'Click to select group'),
(1811, 'Click to select optional procedure code'),
(1812, 'Click to select or change coding'),
(1813, 'Click to select or change CVX code'),
(1814, 'Click to select or change diagnoses'),
(1815, 'Click to select or change service codes'),
(1816, 'Click to select patient'),
(1817, 'Click to select related code'),
(1818, 'Click to select RXCUI code'),
(1819, 'Click to select services to perform if this result is abnormal'),
(1820, 'Click to select services to perform if this result is abnormal.'),
(1821, 'Click to select services to perform if this result is abnormal. This is optional'),
(1822, 'Click to select the desired procedure'),
(1823, 'Click to Show'),
(1824, 'Click to show advanced search'),
(1825, 'Click to Show Filters'),
(1826, 'Click to show messages for all users'),
(1827, 'Click to show messages for only the current user'),
(1828, 'Click to show search'),
(1829, 'Click to sort'),
(1830, 'Click to start or end sql server activity checks.'),
(1831, 'Click to view'),
(1832, 'Click to view Help'),
(1833, 'Click to view or edit'),
(1834, 'Click to view/edit'),
(1835, 'Click Update List to display billing information filtered by the selected Current Criteria'),
(1836, 'Click Upgrade button to upgrade database release from the following date'),
(1837, 'click View Log and review for errors.'),
(1838, 'Click where indicated above to match the patient.'),
(1839, 'Click:'),
(1840, 'Clicking on \'Review\' will list all the codes entered for previous encounters'),
(1841, 'Clicking on either the Enter Name or Enter ID tab will bring up the search box which you can use to select a patient'),
(1842, 'Clicking on Set As Completed will remove the reminder from the active display'),
(1843, 'Clicking on the + button on the patient header panel opens the New Encounter Form'),
(1844, 'Clicking on the Add Issue button brings up the add issue pop-up box'),
(1845, 'Clicking on the Coding cell will bring up the Educational materials pop-up that will let you search by ICD10 code'),
(1846, 'Clicking on the Create A Dated Reminder button will bring up the Send a Reminder popup'),
(1847, 'Clicking on the Create Online/Offsite Portal Credentials button will generate a username and password for the patient that has to be given to the patient'),
(1848, 'Clicking on the Delete button will delete the message'),
(1849, 'Clicking on the first cell under Title will bring up the Add/Edit Issue pop-up page that will let you edit this entry'),
(1850, 'Clicking on the icon next to the caption will display everyone\'s messages and the caption will change to All Messages'),
(1851, 'Clicking on the icon next to their name will bring up the \'Edit\' window.'),
(1852, 'Clicking on the Miscellaneous > MFA Management menu item or User Name > MFA Management menu item brings you to the landing page for managing the multi factor authentication page for that user'),
(1853, 'Clicking on the patient\'s name will reveal the message'),
(1854, 'Clicking on the pencil icon will enter the Edit mode and will display the Enter Details pop-up window that was used to create the entry displayed on this line'),
(1855, 'Clicking on the Show All or Show Inactive buttons will show the appropriate messages'),
(1856, 'Clicking on the slashed eye icon will hide the filters'),
(1857, 'Clicking on the View Log button will bring up the Dated Message Log popup'),
(1858, 'Clicking Options will present a multiselection drop menu to add behaviors to the selected data type. Typing after pull down activates allows search in options.'),
(1859, 'Clicking the button will reveal a popup that will list the E/M codes, check the appropriate code and click \'OK\''),
(1860, 'Clicking the Transmit button will open up a text box where the Direct address of the recipient needs to be entered'),
(1861, 'Client APP ID:'),
(1862, 'Client Certificate Expiration Days'),
(1863, 'Client certificate passphrase'),
(1864, 'Client certificate validation period'),
(1865, 'Client certificate validity should be a valid number.'),
(1866, 'Client Copy'),
(1867, 'Client failed to save. Check system logs'),
(1868, 'Client ID'),
(1869, 'Client medical history summary'),
(1870, 'Client Name'),
(1871, 'Client Name / Client ID'),
(1872, 'Client Number'),
(1873, 'Client Profile - New Clients'),
(1874, 'Client Profile - Unique Clients'),
(1875, 'Client Registrations'),
(1876, 'Client Secret APP ID:'),
(1877, 'Client Type'),
(1878, 'Clients'),
(1879, 'Clinic'),
(1880, 'Clinic Copy'),
(1881, 'Clinic Daily Record'),
(1882, 'Clinic ID'),
(1883, 'Clinical'),
(1884, 'Clinical Decision Rules Alert Manager'),
(1885, 'Clinical documents are produced by arranging or limiting CDA elements in defined ways using templates and Implementation Guides (IG)'),
(1886, 'Clinical History'),
(1887, 'Clinical Instructions'),
(1888, 'Clinical Instructions Form'),
(1889, 'Clinical Plans'),
(1890, 'Clinical Quality Measures (CQM)'),
(1891, 'Clinical Quality Measures (CQM) - 2011'),
(1892, 'Clinical Quality Measures (CQM) - 2014'),
(1893, 'Clinical Reminders'),
(1894, 'Clinical Reminders - is a widget that displays the Passive Alerts for a Clinical Decision Rule'),
(1895, 'Clinical Reminders/Alerts (write,addonly optional)'),
(1896, 'Clinical Reminders/Alerts (write,addonly optional) (alert)'),
(1897, 'Clinical Reports'),
(1898, 'Clinical Rule Action Category'),
(1899, 'Clinical Rule Action Item'),
(1900, 'Clinical Rule Filter Methods'),
(1901, 'Clinical Rule Target Methods'),
(1902, 'Clinical Rules'),
(1903, 'Clinical Rules Age Intervals'),
(1904, 'Clinical Rules Comparisons'),
(1905, 'Clinical Rules Encounter Types'),
(1906, 'Clinical Rules Reminder Due Options'),
(1907, 'Clinical Rules Reminder Inactivation Options'),
(1908, 'Clinical Rules Reminder Intervals'),
(1909, 'Clinical Rules Reminder Methods'),
(1910, 'Clinical Rules Target Intervals'),
(1911, 'Clinical targets'),
(1912, 'Clinical Term'),
(1913, 'Clinical Term Code(s)'),
(1914, 'Clinical View'),
(1915, 'Clinicians'),
(1916, 'Clone'),
(1917, 'Clone Past Visit'),
(1918, 'Close'),
(1919, 'close'),
(1920, 'Close All Current Rx Panels and make this a Preference to stay closed'),
(1921, 'Close and make this a Preference to stay closed'),
(1922, 'Close this panel and delete this Rx'),
(1923, 'Close this panel and make this a Preference to stay closed'),
(1924, 'Close Window'),
(1925, 'close window'),
(1926, 'Close...'),
(1927, 'Closed'),
(1928, 'cm'),
(1929, 'CMS 1500 Form'),
(1930, 'CMS 1500 incl FORM'),
(1931, 'CMS 1500 Margins'),
(1932, 'CMS 1500 Margins Left'),
(1933, 'CMS 1500 Paper Form Format'),
(1934, 'CMS 1500 PDF'),
(1935, 'CMS 1500 PREPRINTED FORM'),
(1936, 'CMS 1500 TEXT'),
(1937, 'CMS 1500 was revised on 2012-02-01 and is hence called Form 1500 (02-12) and is set to expire on 2020-03-31. As of April 1, 2014 only the revised, 02-12 version is accepted.'),
(1938, 'CMS 1500: Box 31 Format'),
(1939, 'CMS 1500: Date in Box 31 (Signature)'),
(1940, 'CMS ID'),
(1941, 'CMS ID For Encounter Claims'),
(1942, 'CMS Margins Left'),
(1943, 'CMS Portal'),
(1944, 'CMS Portal Login'),
(1945, 'CMS Portal Login ID'),
(1946, 'CMS Portal not enabled!'),
(1947, 'CMS Portal Password'),
(1948, 'CMS Portal Request'),
(1949, 'CMS Portal Site Address'),
(1950, 'CMS Portal Username'),
(1951, 'Cmsportal Login'),
(1952, 'CMT{{Central Macular Thickness}}'),
(1953, 'CN VII{{cranial nerve seven}}'),
(1954, 'CN V{{cranial nerve five}}'),
(1955, 'CN2-12 intact'),
(1956, 'CN5{{cranial nerve five}}'),
(1957, 'CN7{{cranial nerve seven}}'),
(1958, 'Co Pay'),
(1959, 'Co Pay Paid'),
(1960, 'Co-managing/referring provider'),
(1961, 'Co-Pay'),
(1962, 'CO-PAY'),
(1963, 'Co-Payment'),
(1964, 'Code'),
(1965, 'code'),
(1966, 'Code Description'),
(1967, 'Code Finder'),
(1968, 'Code must be two letter lowercase'),
(1969, 'Code or symbol to indicate currency'),
(1970, 'Code Search'),
(1971, 'Code Text'),
(1972, 'Code Type'),
(1973, 'code type'),
(1974, 'Code type not recognized'),
(1975, 'Code type not yet defined'),
(1976, 'Code Types'),
(1977, 'Code(s)'),
(1978, 'Coded'),
(1979, 'Codes'),
(1980, 'Codes - Leave blank'),
(1981, 'Coding'),
(1982, 'Coding (click for education)'),
(1983, 'Coding - any encounters (write,wsome optional)'),
(1984, 'Coding - any encounters (write,wsome optional) (coding_a)'),
(1985, 'Coding - my encounters (write,wsome optional)'),
(1986, 'Coding - my encounters (write,wsome optional) (coding)'),
(1987, 'Coding complete'),
(1988, 'Coding done'),
(1989, 'Coding Engine'),
(1990, 'Coding not authorized'),
(1991, 'Coffee'),
(1992, 'Coffee Use'),
(1993, 'Coins'),
(1994, 'Coinsurance'),
(1995, 'Coll w/o'),
(1996, 'Collaborator'),
(1997, 'Collapse'),
(1998, 'collapse'),
(1999, 'Collapse All'),
(2000, 'Collapse all'),
(2001, 'collapse all'),
(2002, 'Collect For'),
(2003, 'Collect Payment'),
(2004, 'Collected'),
(2005, 'Collection Date'),
(2006, 'Collection Date/Time'),
(2007, 'Collections'),
(2008, 'Collections Report'),
(2009, 'Colon Cancer'),
(2010, 'Colon Cancer Screening'),
(2011, 'Colon Cancer Surgery'),
(2012, 'Colonoscopy'),
(2013, 'colonoscopy'),
(2014, 'Color'),
(2015, 'Color for even sets (except when last set is even and all member appointments are displayed and at least one subsequent scheduled appointment exists (not displayed) or not all member appointments are displayed).'),
(2016, 'Color for odd sets (except when last set is odd and all member appointments are displayed and at least one subsequent scheduled appointment exists (not displayed) or not all member appointments are displayed).'),
(2017, 'Color for the last set when all member appointments are displayed and at least one subsequent scheduled appointment exists (not displayed).'),
(2018, 'Color for the last set when not all member appointments are displayed.'),
(2019, 'Color Vision'),
(2020, 'Color:Abbr'),
(2021, 'Column'),
(2022, 'Columns'),
(2023, 'Combine Reminders'),
(2024, 'Combining Lots'),
(2025, 'Comma'),
(2026, 'Comma-separated list of login names to use normal authentication instead of LDAP; useful for setup and debugging.'),
(2027, 'Comment'),
(2028, 'Comments'),
(2029, 'Comments field entry present'),
(2030, 'Comments for this result or recommendation'),
(2031, 'Commercial Insurance Co.'),
(2032, 'Commit Changes'),
(2033, 'Commonly used standards are HOTP (hash-based one-time password, RFC4226), TOTP (time-based one-time password or OCRA (OATH challenge-response algorithm, RFC6287) that were developed and are supported by the OATH (Initiative for Open Authentication)'),
(2034, 'Communication'),
(2035, 'Communication Engine'),
(2036, 'Communications'),
(2037, 'Community health physician'),
(2038, 'Community Mental Health Center'),
(2039, 'Company'),
(2040, 'Company Name'),
(2041, 'Complete'),
(2042, 'Complete Visit Time'),
(2043, 'Completed'),
(2044, 'completed'),
(2045, 'Completed Ad'),
(2046, 'Completed?'),
(2047, 'Completely remove the ability to display the Patient Flow Board.'),
(2048, 'Completion Status'),
(2049, 'Complications by Service Provider'),
(2050, 'Complications of Abortion'),
(2051, 'Components'),
(2052, 'Compose Message'),
(2053, 'Compose new'),
(2054, 'Comprehensive'),
(2055, 'Comprehensive Inpatient Rehabilitation Facility'),
(2056, 'Comprehensive Outpatient Rehabilitation Facility'),
(2057, 'Computer Aided Medical Ordering System'),
(2058, 'Conclusions'),
(2059, 'Condition'),
(2060, 'Condition field not found'),
(2061, 'Condition Status'),
(2062, 'Confidential'),
(2063, 'Config'),
(2064, 'Configuration'),
(2065, 'Configuration Export/Import'),
(2066, 'Configuration saved successfully'),
(2067, 'Configure Apache and OpenEMR to use Client side SSL certificates.'),
(2068, 'Configure Apache to use Client side SSL certificates'),
(2069, 'Configure Apache to use HTTPS.'),
(2070, 'Configure Openemr to use Client side SSL certificates'),
(2071, 'Configure Orders and Results'),
(2072, 'Configure Orders Help'),
(2073, 'Configure the lab test structure'),
(2074, 'Configure tracks'),
(2075, 'Configure Tracks'),
(2076, 'Configuring Multiple Orders'),
(2077, 'Configuring multiple orders'),
(2078, 'Confirm'),
(2079, 'Confirm Create New Patient'),
(2080, 'Confirm Email Address'),
(2081, 'Confirm New Password'),
(2082, 'Confirm Password'),
(2083, 'Confirm Payment'),
(2084, 'Confirm to Delete Current Thread?'),
(2085, 'Confirm to Delete Selected?'),
(2086, 'Confirm to remove item'),
(2087, 'Confirm Username'),
(2088, 'Confirmed'),
(2089, 'Conflicted Allergies'),
(2090, 'Conflicted Medications'),
(2091, 'Conflicted Problems'),
(2092, 'Congenital'),
(2093, 'Congratulations for enabling 2FA'),
(2094, 'Conjuntiva, pupils'),
(2095, 'Conj{{Conjunctiva}}'),
(2096, 'Connection error'),
(2097, 'Connectors'),
(2098, 'Constant'),
(2099, 'Constant Name'),
(2100, 'constant name'),
(2101, 'Constant name is blank'),
(2102, 'constants'),
(2103, 'Constipation'),
(2104, 'Constitutional'),
(2105, 'Construction Firm'),
(2106, 'Consultant physician'),
(2107, 'Consultation Brief Description'),
(2108, 'Consultation Notes - 2008'),
(2109, 'Contact'),
(2110, 'Contact Email'),
(2111, 'Contact Email Address'),
(2112, 'Contact EMR Direct to subscribe to the phiMail Direct messaging service'),
(2113, 'contact info'),
(2114, 'Contact Information'),
(2115, 'Contact Lens'),
(2116, 'Contact Lens Refraction'),
(2117, 'Contact Lenses'),
(2118, 'Contact Medical Information Integration, LLC at http://mi-squared.com for Lab Exchange Service.'),
(2119, 'Contact Medical Information Integration, LLC at http://mi-squared.com or ZH Healthcare at http://zhservices.com for subscribing the eRx service'),
(2120, 'Contact Medical Information Integration, LLC at http://mi-squared.com or ZH Healthcare at http://zhservices.com for subscribing to the NewCrop eRx service.'),
(2121, 'Contact mi-squared at http://www.mi-squared.com/products-services/openemr/ or ZH Healthcare at https://blueehr.com/contact-us/ for subscribing to the NewCrop eRx service.'),
(2122, 'Contact name'),
(2123, 'Contact Open Med Practice, www.openmedpractice.com for subscribing to the Weno Free eRx service.'),
(2124, 'Contact or Notify Phone'),
(2125, 'Contact Person'),
(2126, 'Contact Phone'),
(2127, 'Contact Phone Number'),
(2128, 'Contact Relationship'),
(2129, 'Contact ZMG, LLC (zmghealth@gmail.com) for subscribing the eRx service'),
(2130, 'Contacts'),
(2131, 'contain at least three of the four following items:'),
(2132, 'Container Group Name'),
(2133, 'Content'),
(2134, 'content'),
(2135, 'Contents'),
(2136, 'Context'),
(2137, 'Context name can\'t be empty'),
(2138, 'Continue'),
(2139, 'Continue Assessment'),
(2140, 'Continue completes selected billing option normally.'),
(2141, 'Continuity of Care Document'),
(2142, 'Continuity of Care Document (CCD)'),
(2143, 'Continuity of Care Document (CCD) is an electronic document containing patient specific information that aids in continuity of care'),
(2144, 'Continuity of Care Document (CCD) is meant to be created at the conclusion of an encounter prior to transfer of care to enable the next provider to easily access such information'),
(2145, 'Continuity of Care Record (CCR)'),
(2146, 'Contra Clients'),
(2147, 'Contraception'),
(2148, 'Contraception Issues'),
(2149, 'Contraceptive Complication (specify)'),
(2150, 'Contraceptive Method'),
(2151, 'Contraceptive Products'),
(2152, 'Contraceptive services previously started'),
(2153, 'Contraceptives Start'),
(2154, 'Contrast Acuity'),
(2155, 'Contrast Acuity Testing'),
(2156, 'Contrastart'),
(2157, 'Contrast{{Constrast Visual Acuity}}'),
(2158, 'Control ID'),
(2159, 'Control No.'),
(2160, 'Controlled Substance?'),
(2161, 'Convergence'),
(2162, 'Convergence Amps'),
(2163, 'Conversation'),
(2164, 'Conversation from'),
(2165, 'Convert a JavaScript object into a JSON string, and send it to the server.'),
(2166, 'Convert between plus and minus cylinder'),
(2167, 'Coordinating Counselors'),
(2168, 'COPAY'),
(2169, 'Copay'),
(2170, 'CoPay'),
(2171, 'Copay not positive'),
(2172, 'Copay Paid'),
(2173, 'Copays'),
(2174, 'COPD'),
(2175, 'Copy Pages to Patient Chart'),
(2176, 'Copy these values into current visit.'),
(2177, 'Copy Values'),
(2178, 'Copying the database file. This will take some time...'),
(2179, 'Copyright Notice'),
(2180, 'Cor Disease'),
(2181, 'Core'),
(2182, 'Cornea'),
(2183, 'Cornish'),
(2184, 'Coronary Artery Bypass'),
(2185, 'Coronary Artery Bypass Graft (CABG)'),
(2186, 'Corrected'),
(2187, 'Corsican'),
(2188, 'CouchDB'),
(2189, 'CouchDB Connection Failed.'),
(2190, 'CouchDB Connection SSL'),
(2191, 'CouchDB Database'),
(2192, 'CouchDB database name'),
(2193, 'CouchDB Error Log'),
(2194, 'CouchDB error log is empty'),
(2195, 'CouchDB host'),
(2196, 'CouchDB HostName'),
(2197, 'CouchDB Log Enable'),
(2198, 'CouchDB Password'),
(2199, 'CouchDB Port'),
(2200, 'CouchDB port'),
(2201, 'CouchDB save failed'),
(2202, 'CouchDB SSL Allow Selfsigned Certificate'),
(2203, 'CouchDB UserName'),
(2204, 'Cough'),
(2205, 'Cough:'),
(2206, 'could not connect to server'),
(2207, 'Could not find RxNorm Table! Please install.'),
(2208, 'Could not import the document. Please contact the EMR vendor.'),
(2209, 'could not install ACL'),
(2210, 'could not open table'),
(2211, 'Could not read file'),
(2212, 'Could not read the file'),
(2213, 'could not run sql query'),
(2214, 'Could not send email due to a server problem, '),
(2215, 'Could not send email due to a server problem.'),
(2216, 'Could not send email due to a server problem. '),
(2217, 'Couldn\'t create backup dir:'),
(2218, 'Couldn\'t remove dir:'),
(2219, 'Couldn\'t remove old backup file:'),
(2220, 'Couldn\'t remove old export file: '),
(2221, 'Coumadin Management - INR Monitoring'),
(2222, 'Couns by Method'),
(2223, 'Counseling'),
(2224, 'Counseling activities'),
(2225, 'Counselors'),
(2226, 'Counter Referral Form'),
(2227, 'COUNTER REFERRAL FORM'),
(2228, 'Counter-Referral'),
(2229, 'Country'),
(2230, 'Country Code'),
(2231, 'Country Data Type'),
(2232, 'Country list'),
(2233, 'Country List (write,addonly optional)'),
(2234, 'Country List (write,addonly optional) (country)'),
(2235, 'Country Name should be represent in two letters. (Example: United States is US)'),
(2236, 'county'),
(2237, 'County'),
(2238, 'Coupon'),
(2239, 'Course'),
(2240, 'Cousin'),
(2241, 'Coverage Level'),
(2242, 'Coverage Period'),
(2243, 'Coverage Type'),
(2244, 'CPOE'),
(2245, 'CPT'),
(2246, 'CPT Code'),
(2247, 'CPT Codes'),
(2248, 'CPT4 Procedure/Service'),
(2249, 'CPTII Performance Measures'),
(2250, 'CQM'),
(2251, 'CR (Wet)'),
(2252, 'Crackles:'),
(2253, 'Cranial Nerve 5: Trigeminal Nerve'),
(2254, 'Cranial Nerve 7: Facial Nerve'),
(2255, 'cream'),
(2256, 'Create a Client side SSL certificate for each user or client machine.'),
(2257, 'Create a client side SSL certificate for either a user or a client hostname.'),
(2258, 'CREATE A COUNTER-REFERRAL'),
(2259, 'Create A Dated Reminder'),
(2260, 'CREATE A LOCATION FOR RESULTS'),
(2261, 'Create a new track'),
(2262, 'CREATE A REFERRAL'),
(2263, 'Create a reminder to schedule a future visit'),
(2264, 'Create a reminder to schedule a future visit.'),
(2265, 'CREATE A SIMPLE TRANSACTION TYPE'),
(2266, 'Create a spreadsheet in openoffice/LibreOffice, have 5 columns - CPT Code, Description, Standard, Credit Card and Cash. Fill in the values. From this spreadsheet manually copy and paste the values via Administration > Codes'),
(2267, 'CREATE A TOP LEVEL CUSTOM GROUP'),
(2268, 'CREATE A TOP LEVEL ENTRY'),
(2269, 'Create an Event'),
(2270, 'CREATE AN ORDER'),
(2271, 'Create an Order for a Panel of Tests'),
(2272, 'Create an Order for a Single Test'),
(2273, 'Create and download a full backup'),
(2274, 'Create and modify tracks'),
(2275, 'Create Backup'),
(2276, 'Create batch'),
(2277, 'Create Client Certificate'),
(2278, 'Create Client side SSL certificates'),
(2279, 'Create custom white list of MIME content type of a files to secure your documents system'),
(2280, 'Create Date'),
(2281, 'Create Duplicate'),
(2282, 'Create Encounter'),
(2283, 'Create Eventlog Backup'),
(2284, 'Create follow-up encounter'),
(2285, 'Create new issue'),
(2286, 'Create New Message'),
(2287, 'Create New Patient'),
(2288, 'Create new Track'),
(2289, 'Create New Transaction'),
(2290, 'Create Offsite Portal Credentials'),
(2291, 'Create Online Portal Credentials'),
(2292, 'Create Onsite Portal Credentials'),
(2293, 'Create Patient'),
(2294, 'Create Patient Note'),
(2295, 'CREATE THE CUSTOM ORDERS'),
(2296, 'Create the SSL Certificate Authority and Server certificates.'),
(2297, 'Create Visit'),
(2298, 'Created'),
(2299, 'Creates a report that contains various sections of the patient\'s medical record'),
(2300, 'Creating a Custom Favorite Group to order frequently ordered tests together '),
(2301, 'Creating a Custom Group of Tests as Favorites'),
(2302, 'CREATING A NEW DATED REMINDER'),
(2303, 'CREATING A NEW MESSAGE'),
(2304, 'Creating and Managing Encounters'),
(2305, 'Creating anyway'),
(2306, 'Creating export file'),
(2307, 'Creating new track failed'),
(2308, 'Creating this file on remote host failed'),
(2309, 'Creator'),
(2310, 'Credentials Reset. Below link is only valid for one hour.'),
(2311, 'credit'),
(2312, 'Credit Card'),
(2313, 'Credit or Debit Card'),
(2314, 'Credits'),
(2315, 'Cree'),
(2316, 'Criteria'),
(2317, 'Criteria Actions'),
(2318, 'Croatian'),
(2319, 'Crohn\'s Disease'),
(2320, 'Crohns Disease'),
(2321, 'CR{{Cycloplegic Refraction}}'),
(2322, 'CSV'),
(2323, 'CSV Export'),
(2324, 'CSV File'),
(2325, 'CSV Tables'),
(2326, 'CSV to calendar_external table'),
(2327, 'CTL'),
(2328, 'CTL{{Contact Lens Vision}}'),
(2329, 'CTL{{Contact Lens}}'),
(2330, 'CU.MM'),
(2331, 'Cuban'),
(2332, 'Cup'),
(2333, 'Currency Decimal Places'),
(2334, 'Currency Decimal Point Symbol'),
(2335, 'Currency Designator'),
(2336, 'Currency Thousands Separator'),
(2337, 'Current'),
(2338, 'Current Alcohol'),
(2339, 'Current Authentication Method for'),
(2340, 'Current Authentication Method for the logged in user'),
(2341, 'Current Consultation'),
(2342, 'Current Criteria'),
(2343, 'Current Day'),
(2344, 'Current day highlight color'),
(2345, 'Current every day smoker'),
(2346, 'Current Eye Meds'),
(2347, 'Current file name was changed to'),
(2348, 'Current Glasses'),
(2349, 'Current Hash'),
(2350, 'Current Location'),
(2351, 'Current Logged in User'),
(2352, 'Current Medications'),
(2353, 'Current on record trusted email'),
(2354, 'Current Password'),
(2355, 'Current password to authorize changes.'),
(2356, 'Current Patient'),
(2357, 'Current patient unavailable here. Use Patient Documents'),
(2358, 'Current Provider'),
(2359, 'Current Pt Only'),
(2360, 'Current Recipients'),
(2361, 'Current Recreational Drugs'),
(2362, 'Current RX'),
(2363, 'Current some day smoker'),
(2364, 'Current Status'),
(2365, 'Current Status Time'),
(2366, 'Current Target'),
(2367, 'Current trusted email address on record.'),
(2368, 'Current user'),
(2369, 'Current Value'),
(2370, 'Current Working Procedure Diagnoses'),
(2371, 'Currently Active'),
(2372, 'Currently Busy'),
(2373, 'Currently Busy{{Service}}'),
(2374, 'Currently off-line'),
(2375, 'Currently Running'),
(2376, 'Currently there are 5 types of transactions in OpenEMR'),
(2377, 'Currently there are no facilities.'),
(2378, 'Currently working on making this document'),
(2379, 'Cushing Syndrom'),
(2380, 'Cushing Syndrome'),
(2381, 'Custodial Care Facility'),
(2382, 'Custodian'),
(2383, 'Custom'),
(2384, 'Custom Billing Phone Number'),
(2385, 'Custom Favorite Group - to group individual tests '),
(2386, 'Custom Favorite Group > Custom Favorite Item > Discrete results'),
(2387, 'Custom Favorite Group and Custom Favorite Item is used to create customized groups of orders'),
(2388, 'Custom Favorite Item  - for individual orders or tests'),
(2389, 'Custom Greeting'),
(2390, 'Custom input?'),
(2391, 'Custom Order'),
(2392, 'Custom Report'),
(2393, 'Custom Statement message'),
(2394, 'Custom Sub Group'),
(2395, 'Custom Table'),
(2396, 'Custom text for Flow Board postcards. After changing text, print samples before printing mass quantities!'),
(2397, 'Custom Top Group'),
(2398, 'Customize the Fee Sheet'),
(2399, 'Customize the Transaction Form'),
(2400, 'CVV'),
(2401, 'Cvx Code'),
(2402, 'CVX Code'),
(2403, 'CVX Code Mapping'),
(2404, 'CVX Immunization'),
(2405, 'CV{{Cardiovascular}}'),
(2406, 'Cycle'),
(2407, 'Cyclo 1%'),
(2408, 'CycloMydril'),
(2409, 'Cycloplegic (Wet) Refraction'),
(2410, 'Cyl{{Cylinder}}'),
(2411, 'CYL{{Cylinder}}'),
(2412, 'CYP'),
(2413, 'CYP Factor'),
(2414, 'CYP Report'),
(2415, 'Czech'),
(2416, 'D'),
(2417, 'D&C'),
(2418, 'D&E'),
(2419, 'D&V Full OU{{Ductions and Versions full both eyes}}'),
(2420, 'D.O.B.'),
(2421, 'daily'),
(2422, 'Daily Record'),
(2423, 'Daily Report'),
(2424, 'Daily Summary Report'),
(2425, 'Danish'),
(2426, 'Dashboard'),
(2427, 'Dashboard - summarizes all patient related information'),
(2428, 'Dashboard{{patient file}}'),
(2429, 'Data Alike is already in database, please change code and/or description'),
(2430, 'Data Alike is already in database, please change constant name'),
(2431, 'Data Cols'),
(2432, 'Data Enterer'),
(2433, 'Data Entry - Social Security Number'),
(2434, 'Data Error'),
(2435, 'Data from'),
(2436, 'Data integrity has been compromised'),
(2437, 'data of all encounters so far'),
(2438, 'Data Section'),
(2439, 'Data Type'),
(2440, 'Database'),
(2441, 'Database and Access Control upgrade finished.'),
(2442, 'Database is not installed.'),
(2443, 'Database name'),
(2444, 'Database Patch'),
(2445, 'Database Reporting'),
(2446, 'Database Reporting (database)'),
(2447, 'Database upgrade finished.'),
(2448, 'DataCols must be a number between 1 and 999'),
(2449, 'Date'),
(2450, 'DATE'),
(2451, 'Date & Time Administered'),
(2452, 'Date / Time'),
(2453, 'Date Administered'),
(2454, 'Date and time of sample collection'),
(2455, 'Date and time of this observation'),
(2456, 'Date and time of this report'),
(2457, 'Date and time that the sample was collected'),
(2458, 'Date Cannot be greater than Today'),
(2459, 'Date contraceptive services initially provided'),
(2460, 'Date Created'),
(2461, 'Date Deceased'),
(2462, 'Date Destroyed'),
(2463, 'Date Display Format'),
(2464, 'Date format for \"appointment end\" is not valid'),
(2465, 'Date format for \"appointment start\" is not valid'),
(2466, 'Date format for \"Next Appointment\" is not valid'),
(2467, 'Date format for \"not seen since\" is not valid'),
(2468, 'Date format for \"seen before\" is not valid'),
(2469, 'Date format for \"seen since\" is not valid'),
(2470, 'Date Immunization Information Statements Given'),
(2471, 'Date is missing for code '),
(2472, 'Date Master Criteria'),
(2473, 'Date of appointments'),
(2474, 'Date of appointments mm/dd/yyyy'),
(2475, 'Date of bank deposit yyyy-mm-dd'),
(2476, 'Date of Billing'),
(2477, 'Date of Birth'),
(2478, 'Date of birth'),
(2479, 'Date Of Birth'),
(2480, 'Date of Birth and Age'),
(2481, 'Date of Entry'),
(2482, 'Date of exit'),
(2483, 'Date of Injury'),
(2484, 'Date of Onset'),
(2485, 'Date of onset or hospitalization'),
(2486, 'Date of onset, surgery or start of medication'),
(2487, 'Date of payment yyyy-mm-dd'),
(2488, 'Date of recovery or end of medication'),
(2489, 'Date of referral'),
(2490, 'Date of registration'),
(2491, 'Date of reply'),
(2492, 'Date of Report'),
(2493, 'Date of Service'),
(2494, 'Date of service'),
(2495, 'Date Of Service'),
(2496, 'Date of Service = Today'),
(2497, 'Date of Service is today\'s date by default. If needed it can be changed to any valid date'),
(2498, 'Date of service mm/dd/yyyy'),
(2499, 'Date of Service:'),
(2500, 'Date Of Signature'),
(2501, 'Date of Status Change'),
(2502, 'Date of this letter'),
(2503, 'Date of this order'),
(2504, 'Date of this report'),
(2505, 'Date of VIS Statement'),
(2506, 'Date Ordered'),
(2507, 'Date Range'),
(2508, 'Date Selector'),
(2509, 'Date selector'),
(2510, 'Date Sent'),
(2511, 'Date The Message Was Sent'),
(2512, 'Date Time'),
(2513, 'Date values Cannot be Blank.'),
(2514, 'Date VIS Presented'),
(2515, 'Date VIS Published'),
(2516, 'Date/Appt'),
(2517, 'Date/Notes'),
(2518, 'Date/Notes of Last'),
(2519, 'Date/Time'),
(2520, 'Date:'),
(2521, 'Dated'),
(2522, 'dated'),
(2523, 'Dated Message Log'),
(2524, 'Dated Reminders'),
(2525, 'Dated reminders maximum alerts to show'),
(2526, 'Day'),
(2527, 'day'),
(2528, 'day ago'),
(2529, 'Day Sheet Report'),
(2530, 'Day View'),
(2531, 'Day(s)'),
(2532, 'Day(s) M-F'),
(2533, 'days'),
(2534, 'Days'),
(2535, 'days ago'),
(2536, 'Days and Games Missed'),
(2537, 'Days From Last Encounter'),
(2538, 'Days Missed'),
(2539, 'days of each other'),
(2540, 'Days Of Week'),
(2541, 'Days per Column:'),
(2542, 'Days/Col'),
(2543, 'Days/Col:'),
(2544, 'DB installed'),
(2545, 'DD/MM/YYYY'),
(2546, 'De Identification'),
(2547, 'De Identification Process is completed'),
(2548, 'De Identification Process is ongoing'),
(2549, 'De Identification process is started and running in background'),
(2550, 'De Identified data may not be complete'),
(2551, 'De-identification files will be saved in'),
(2552, 'DEA'),
(2553, 'DEA Number'),
(2554, 'DEA number'),
(2555, 'Deactivate'),
(2556, 'Deactivated'),
(2557, 'Deadline (CST)'),
(2558, 'Deaf'),
(2559, 'Debt'),
(2560, 'Debug Error Logging'),
(2561, 'Debug Hash Verification Time'),
(2562, 'Debug Information'),
(2563, 'DEBUG OUTPUT'),
(2564, 'Debugging'),
(2565, 'Dec'),
(2566, 'Deceased'),
(2567, 'DECEASED'),
(2568, 'DECEASED (1 day ago)'),
(2569, 'DECEASED (Today)'),
(2570, 'Deceased Date'),
(2571, 'Deceased Date should not be greater than Today'),
(2572, 'DECEASED NOTIFICATION'),
(2573, 'Deceased Reason'),
(2574, 'December'),
(2575, 'Decide on the code categories and the order you want them to appear, these will be displayed on the buttons in the \'Select Codes\' section'),
(2576, 'Decide on the Identifying Codes and Standard Codes, remember the Identifying code has to be unique to ensure proper display of results'),
(2577, 'Decide whether or not you will want to order individual tests which are a part of a panel of tests'),
(2578, 'Decimal pounds or pounds and ounces separated by #(e.g. 5#4)'),
(2579, 'Declined To Specify'),
(2580, 'Deductible'),
(2581, 'Deductible Met'),
(2582, 'deep'),
(2583, 'Default'),
(2584, 'Default - Check any check box and this value will show up in the displayed drop-down box as the default value'),
(2585, 'Default Calendar View'),
(2586, 'Default Eligibility X12 Partner'),
(2587, 'Default Encounter Form ID'),
(2588, 'Default Encounter View'),
(2589, 'Default Facility'),
(2590, 'Default font'),
(2591, 'Default font (need to logout/login after change this setting)'),
(2592, 'Default font size'),
(2593, 'Default font size (need to logout/login after change this setting)'),
(2594, 'Default Language'),
(2595, 'Default language if no other is allowed or chosen.'),
(2596, 'Default left print margin for CMS 1500'),
(2597, 'Default left print margin for UB04'),
(2598, 'Default List (write,addonly optional)'),
(2599, 'Default List (write,addonly optional) (default)'),
(2600, 'Default Method'),
(2601, 'Default Password Expiration Days'),
(2602, 'Default password expiration period in days. 0 means this feature is disabled.'),
(2603, 'Default Patient Country'),
(2604, 'Default Patient Country sent to NewCrop eRx, only if patient country is not set.'),
(2605, 'Default Price Level'),
(2606, 'Default Priority'),
(2607, 'Default Provider'),
(2608, 'Default provider changed'),
(2609, 'Default Range'),
(2610, 'Default Reason for Visit'),
(2611, 'Default Rendering Provider in Fee Sheet'),
(2612, 'Default Search Code Type'),
(2613, 'Default Second Tab'),
(2614, 'Default selection for rendering provider in fee sheet.'),
(2615, 'Default Setting'),
(2616, 'Default Sort Direction'),
(2617, 'Default state of New Window checkbox in the patient list.'),
(2618, 'Default Template'),
(2619, 'Default to a provider for line item in the fee sheet'),
(2620, 'Default to a provider for line item in the fee sheet.(only applicable if Support line item billing in option above)'),
(2621, 'Default to previous value'),
(2622, 'Default top print margin for CMS 1500'),
(2623, 'Default top print margin for UB04'),
(2624, 'Default Units'),
(2625, 'Default Units and Range as appropriate'),
(2626, 'Default Value'),
(2627, 'Default Visit Category'),
(2628, 'Default Warehouse'),
(2629, 'Default X12 Partner'),
(2630, 'Default/Global'),
(2631, 'Default: Checked. When checked, messages are processed for patients with Patient Demographic Choice (Phone/Text/Email) set to \'Unassigned\' or \'Yes\'. If this is unchecked, a given type of message can only be sent if its Demographic Choice = \'Yes\'.'),
(2632, 'Defaults'),
(2633, 'Define a default visit category'),
(2634, 'Define lab service locations'),
(2635, 'Del'),
(2636, 'del'),
(2637, 'Delayed Recurrence (> 12 Mo)'),
(2638, 'Delete'),
(2639, 'delete'),
(2640, 'Delete Categories with ID(s) : '),
(2641, 'Delete Category'),
(2642, 'Delete Document'),
(2643, 'Delete Encounter Form'),
(2644, 'Delete failed!'),
(2645, 'Delete Group'),
(2646, 'Delete List'),
(2647, 'Delete Onsite Portal Activity'),
(2648, 'Delete Pages'),
(2649, 'Delete Patient, Encounter, Form, Issue, Document, Payment, Billing or Transaction'),
(2650, 'Delete Plan'),
(2651, 'Delete Row'),
(2652, 'Delete Selected Items'),
(2653, 'Delete Selected Requests'),
(2654, 'Delete Successful'),
(2655, 'Delete successful.'),
(2656, 'Delete this document'),
(2657, 'Delete this form'),
(2658, 'Delete this message'),
(2659, 'Delete this note'),
(2660, 'Deleted Successfully'),
(2661, 'Deleted Successfully.'),
(2662, 'Deleting'),
(2663, 'Deleting this event cannot be undone. It cannot be recovered once it is gone. Are you sure you wish to delete this event?'),
(2664, 'Deletion failed because group has appointments or encounters'),
(2665, 'Delivered'),
(2666, 'Delivery Confirmed'),
(2667, 'Delivery is not allowed to the specified Direct Address.'),
(2668, 'Delivery is not currently permitted to the specified Direct Address.'),
(2669, 'Delivery of the attached clinical document was requested by the patient'),
(2670, 'Delivery of the attached clinical document was requested by the patient.'),
(2671, 'Dementia'),
(2672, 'Demographic changes made here are recorded system-wide'),
(2673, 'Demographics'),
(2674, 'Demographics (write,addonly optional)'),
(2675, 'Demographics (write,addonly optional) (demo)'),
(2676, 'Demographics - patient demographics and insurance information'),
(2677, 'Demographics Fields'),
(2678, 'Demographics filter criteria'),
(2679, 'Demographics Legend Red: Charted Values. Blue: Patient Edits'),
(2680, 'Demographics not authorized'),
(2681, 'Demographics not authorized.'),
(2682, 'Denied'),
(2683, 'denies'),
(2684, 'Denominator'),
(2685, 'Denominator Exception'),
(2686, 'Denominator Exclusion'),
(2687, 'Dental'),
(2688, 'Dental Issue List'),
(2689, 'Dental Issues'),
(2690, 'Dep Date'),
(2691, 'Dependency Modules'),
(2692, 'Dependency Problem'),
(2693, 'Depending on the level of access you can View/Edit the Transaction'),
(2694, 'Depending on the type of bill you are testing you will see HCFA like output on a blank page for HCFA bills, you will see many lines of somewhat garbled text  and information if you are testing an X12 claim. That garbled text is the X12 EDI 4010A format. Occasionally you will see odd characters that look like dominoes or  squiglies, these are control characters such as page feeds and are normal.'),
(2695, 'Depending on whether or not NewCrop eRx module is enabled the method of entry will vary'),
(2696, 'Deposit Date'),
(2697, 'Deposit Date Cannot be greater than Today'),
(2698, 'Deposit Date:'),
(2699, 'Depressed'),
(2700, 'Depression'),
(2701, 'Dept'),
(2702, 'Dermatology'),
(2703, 'Derm{{dermatologic}}'),
(2704, 'DERM{{Dermatology}}'),
(2705, 'DESC'),
(2706, 'Description'),
(2707, 'description'),
(2708, 'Description is default text'),
(2709, 'Description of the Disclosure'),
(2710, 'Description of this procedure or result code'),
(2711, 'Description Translation'),
(2712, 'Desired Filename'),
(2713, 'Destination'),
(2714, 'Destination Filename'),
(2715, 'Destroy'),
(2716, 'Destroy Lot'),
(2717, 'Destroy...'),
(2718, 'Destroyed'),
(2719, 'Destroyed Drugs'),
(2720, 'Destroyed Drugs Report'),
(2721, 'Detail'),
(2722, 'Detail\'s group was saved successfully'),
(2723, 'Detailed exam'),
(2724, 'Detailed HPI'),
(2725, 'Detailed information on how to setup and troubleshoot phiMail messages is available here'),
(2726, 'Details'),
(2727, 'Developer'),
(2728, 'Developmental abnormality'),
(2729, 'Deviation'),
(2730, 'Diabetes'),
(2731, 'Diabetes Mellitus'),
(2732, 'Diabetes: Blood Pressure Management (CQM)'),
(2733, 'Diabetes: Eye Exam'),
(2734, 'Diabetes: Eye Exam (CQM)'),
(2735, 'Diabetes: Foot Exam'),
(2736, 'Diabetes: Foot Exam (CQM)'),
(2737, 'Diabetes: HbA1c Poor Control (CQM)'),
(2738, 'Diabetes: Hemoglobin A1C'),
(2739, 'Diabetes: LDL Management & Control (CQM)'),
(2740, 'Diabetes: Urine Microalbumin'),
(2741, 'Diag'),
(2742, 'Diagnoses'),
(2743, 'Diagnosis'),
(2744, 'Diagnosis Code'),
(2745, 'Diagnosis Codes'),
(2746, 'Diagnosis Codes History'),
(2747, 'Diagnosis Date'),
(2748, 'Diagnosis Description'),
(2749, 'Diagnosis must be coded into a linked encounter'),
(2750, 'Diagnosis Name'),
(2751, 'Diagnosis Report'),
(2752, 'Diagnosis Reporting'),
(2753, 'Diagnosis Reporting Only'),
(2754, 'Diagnosis Title'),
(2755, 'Diagnosis:'),
(2756, 'Diagnosis: '),
(2757, 'Diagnostic'),
(2758, 'Diagnostic Tests:'),
(2759, 'Diagnostics'),
(2760, 'Dials'),
(2761, 'Diam{{Diameter}}'),
(2762, 'DIAM{{Diameter}}'),
(2763, 'Diaphragms/Caps'),
(2764, 'Diarrhea'),
(2765, 'Diastolic'),
(2766, 'Dicom Viewer'),
(2767, 'Dictation'),
(2768, 'Dictation: '),
(2769, 'Did you receive a copy of the HIPAA Notice?'),
(2770, 'Diffuse:'),
(2771, 'Digitally Signed'),
(2772, 'Dilated with'),
(2773, 'Dilation'),
(2774, 'Dilation orders/risks reviewed'),
(2775, 'Dilation Time'),
(2776, 'Dim'),
(2777, 'Direct'),
(2778, 'DIRECT ADDRESS'),
(2779, 'Direct Address'),
(2780, 'Direct Email'),
(2781, 'Direct Mail'),
(2782, 'Direct Message Log'),
(2783, 'Direct Message Received.'),
(2784, 'Direct messaging is currently unavailable.'),
(2785, 'Direct Messaging Send Failure.'),
(2786, 'Directions'),
(2787, 'Director Name'),
(2788, 'Directory delete failed; continuing.'),
(2789, 'Disability'),
(2790, 'Disable'),
(2791, 'Disable Auto Adjustment Calculations in EOB Posting'),
(2792, 'Disable Auto Adjustments'),
(2793, 'Disable automatically calculating balance adjustments for invoice posting'),
(2794, 'Disable Calendar'),
(2795, 'Disable Chart Tracker'),
(2796, 'Disable Client'),
(2797, 'Disable Help Modal'),
(2798, 'Disable Immunizations'),
(2799, 'Disable Insurance Eligibility Reports Download'),
(2800, 'Disable Old Metric Vitals Form'),
(2801, 'Disable Patient Flow Board'),
(2802, 'Disable phpMyAdmin'),
(2803, 'Disable Prescriptions'),
(2804, 'Disable User Groups'),
(2805, 'disabled'),
(2806, 'Disabled'),
(2807, 'Disabled Beneficiary Under Age 65 with Large Group Health Plan (LGHP)'),
(2808, 'Disabled Client'),
(2809, 'Disabling automatic checking would be appropriate if message checking is managed through another mechanism, such as a system cron job'),
(2810, 'Disadvantages being cost of device, potential for loss and running out of battery power'),
(2811, 'Disc'),
(2812, 'DISC'),
(2813, 'Discard'),
(2814, 'Discarded'),
(2815, 'Discharge'),
(2816, 'Discharge From Urethra'),
(2817, 'Discharge Medications'),
(2818, 'Discharge Right'),
(2819, 'Discharge Right:'),
(2820, 'Discharge Summary'),
(2821, 'Discharge Summary - 2009'),
(2822, 'Discharge Time'),
(2823, 'Discharged'),
(2824, 'Disclaimer'),
(2825, 'Disclosure Info'),
(2826, 'Disclosure Type'),
(2827, 'Disclosure Types'),
(2828, 'Disclosures'),
(2829, 'Disclosures (write,addonly optional)'),
(2830, 'Disclosures (write,addonly optional) (disclosure)'),
(2831, 'Disclosures - Record disclosures made for treatment, payment, and health care operations with date, time, patient identification (name or number), user identification (name or number), and a description of the disclosure'),
(2832, 'Discontinue'),
(2833, 'Discount'),
(2834, 'Discount Amount'),
(2835, 'Discount Level'),
(2836, 'Discount Percentage'),
(2837, 'Discounts as Monetary Amounts'),
(2838, 'Discounts at checkout time are entered as money amounts, as opposed to percentage.'),
(2839, 'Discrete Result'),
(2840, 'Discrete Results - for manual entry of returned result values'),
(2841, 'Disease'),
(2842, 'Disease with presumed immunity'),
(2843, 'Dislocation'),
(2844, 'Dismiss'),
(2845, 'Dismiss Form'),
(2846, 'Dismiss Help'),
(2847, 'Disp #'),
(2848, 'Dispatch'),
(2849, 'Dispatch Received Document'),
(2850, 'Dispense Rx'),
(2851, 'Dispense this Rx'),
(2852, 'Dispense this RX'),
(2853, 'Dispensed'),
(2854, 'Display'),
(2855, 'Display Additional measurements (Ks, IOL cals, etc)'),
(2856, 'Display advance directives in the demographics page.'),
(2857, 'Display Application Errors Only'),
(2858, 'Display Documents'),
(2859, 'Display event dates in block?'),
(2860, 'Display Format for US Weights'),
(2861, 'Display how many events?'),
(2862, 'Display Invoice Number or Patient Name in the Cash Receipt Report'),
(2863, 'Display Invoice Number or Patient Name or Both in the Sales Report'),
(2864, 'Display limit reached'),
(2865, 'Display location in block?'),
(2866, 'Display Name'),
(2867, 'Display the Autorefraction Panel'),
(2868, 'Display the calendar?'),
(2869, 'Display the Contact Lens Panel'),
(2870, 'Display the Encounter Billing Note or Patient Billing Note or Both in the Billing Screen.'),
(2871, 'Display the Manifest Refraction panel'),
(2872, 'Display the patient\'s current glasses'),
(2873, 'Display the recurrent appointment widget in the patient summary.'),
(2874, 'Display the Units Column on the Billing Screen'),
(2875, 'Display today\'s events in the block?'),
(2876, 'Display topic in block?'),
(2877, 'Display upcoming events in block?'),
(2878, 'Display Window Errors Only'),
(2879, 'Displayed Columns'),
(2880, 'Displaying the following number of most recent disclosures:'),
(2881, 'Displaying the following number of most recent messages'),
(2882, 'Displaying the following number of most recent notes'),
(2883, 'Displaying the following number of most recent notes:'),
(2884, 'Distance'),
(2885, 'Distance from the \'top\' of the envelope in mm'),
(2886, 'Distance from the right most edge of the envelope in portrait position in mm'),
(2887, 'Distribute'),
(2888, 'Distributed Edits'),
(2889, 'Distributed to Global'),
(2890, 'Distribution'),
(2891, 'Distributions'),
(2892, 'Distributor'),
(2893, 'Dist{{distance}}'),
(2894, 'Divehi- Dhivehi- Maldivian-'),
(2895, 'Divergence'),
(2896, 'Divergence Amps'),
(2897, 'Diverticulitis'),
(2898, 'Diverticulitis Surgery'),
(2899, 'Divirticulitis'),
(2900, 'Divirticulitis Surgery'),
(2901, 'Divorced'),
(2902, 'Dizziness:'),
(2903, 'Do not allow insurance eligibility report log download'),
(2904, 'Do not allow SQL queries to be outputted to screen.'),
(2905, 'Do not change'),
(2906, 'Do not display Allergies uploaded after visiting NewCrop eRx.'),
(2907, 'Do not display Allergy uploaded to NewCrop'),
(2908, 'Do not display Medications uploaded after visiting NewCrop eRx.'),
(2909, 'Do not display Medications uploaded to NewCrop'),
(2910, 'Do not display NewCrop eRx Allergy uploaded'),
(2911, 'Do not display NewCrop eRx Medications uploaded'),
(2912, 'Do not display the calendar.'),
(2913, 'Do not display the patient flow board.'),
(2914, 'Do not display the Recall Board.'),
(2915, 'Do not enter the server URL into your browser address bar, as this will not work'),
(2916, 'Do not inventory and sell any products'),
(2917, 'Do not know what to do!'),
(2918, 'Do Not Print'),
(2919, 'Do not require patient notes to be authorized'),
(2920, 'Do Not Resuscitate Order'),
(2921, 'do not save'),
(2922, 'do not substitute'),
(2923, 'Do Not Use Safe Apostrophe'),
(2924, 'Do not warn or prevent web browser refresh'),
(2925, 'do nothing'),
(2926, 'Do you really want to change Warehouse?'),
(2927, 'Do you really want to clear the log?'),
(2928, 'Do You Really Want to Continue'),
(2929, 'Do you really want to delete'),
(2930, 'Do you really want to delete the selection?'),
(2931, 'Do you really want to delete this group'),
(2932, 'Do you really want to delete?'),
(2933, 'Do you want to close the tabs?'),
(2934, 'Do you want to continue?'),
(2935, 'Do you want to delete this?'),
(2936, 'Do you want to delete?'),
(2937, 'Do you want to remove this record?'),
(2938, 'Do you wish to continue adding this new patient?'),
(2939, 'Do you wish to continue with the new name?'),
(2940, 'Do you wish to PERMANENTLY delete this immunization record?'),
(2941, 'DOB'),
(2942, 'DOB is missing, please enter if possible'),
(2943, 'Doc Id'),
(2944, 'Docs'),
(2945, 'Doctor'),
(2946, 'Doctor:'),
(2947, 'Doctor\'s name and signature'),
(2948, 'Document'),
(2949, 'document'),
(2950, 'document 3 and their status to reach the detailed HPI level'),
(2951, 'Document Categories'),
(2952, 'Document category for lab results does not exist'),
(2953, 'Document category name for storage of electronically received lab results.'),
(2954, 'Document category name for storage of electronically received MDM documents.'),
(2955, 'Document Category or Discard'),
(2956, 'Document Center'),
(2957, 'Document clinical findings in Shorthand Format'),
(2958, 'Document could not be moved to patient id'),
(2959, 'Document created'),
(2960, 'Document Date'),
(2961, 'Document date and issue updated successfully'),
(2962, 'Document ID'),
(2963, 'Document identifying information'),
(2964, 'Document Library'),
(2965, 'Document moved to new category'),
(2966, 'Document moved to patient id'),
(2967, 'Document passed integrity check'),
(2968, 'Document passed integrity check.'),
(2969, 'Document Storage Method'),
(2970, 'Document successfully renamed.'),
(2971, 'Document tagged to Encounter successfully'),
(2972, 'Document Template Management'),
(2973, 'Document Templates'),
(2974, 'Document Uploader/Viewer'),
(2975, 'Document(s)'),
(2976, 'Document/Imaging Store'),
(2977, 'Documentation for a Detailed HPI requires'),
(2978, 'Documents'),
(2979, 'documents'),
(2980, 'Documents (write,addonly optional)'),
(2981, 'Documents (write,addonly optional) (docs)'),
(2982, 'Documents - a repository of the patient\'s scanned/faxed paper documents. It also the place to download patient specific templates'),
(2983, 'Documents Delete'),
(2984, 'Documents Delete (docs_rm)'),
(2985, 'Documents History'),
(2986, 'Documents List'),
(2987, 'Documents setup error'),
(2988, 'DOC{{document format}}'),
(2989, 'DOE'),
(2990, 'Does anything make it better? Worse?'),
(2991, 'Does it occur in certain situations?'),
(2992, 'Does not equal'),
(2993, 'does not have enough data to graph'),
(2994, 'does not match the PV1 encounter number'),
(2995, 'does not seem valid'),
(2996, 'Does this type allow related codes?'),
(2997, 'Domestic Partner'),
(2998, 'Don\'t Save'),
(2999, 'Don\'t Save'),
(3000, 'Don\'t Save Changes'),
(3001, 'DONATE NOW!'),
(3002, 'Done'),
(3003, 'Done with'),
(3004, 'Done with:'),
(3005, 'Done.  Will now send download.'),
(3006, 'DOS'),
(3007, 'Dosage'),
(3008, 'Dose'),
(3009, 'Double click on a DX\'s handle'),
(3010, 'Double Click on this icon to pop up document in a new viewer.'),
(3011, 'double click to edit'),
(3012, 'Double Clicking a NPI box will bring up a current Users dialog for providers.'),
(3013, 'Double Vision'),
(3014, 'Download'),
(3015, 'DOWNLOAD'),
(3016, 'Download - the created CCD is downloaded as a pdf file to the downloads from the browser'),
(3017, 'Download - the created CCR is downloaded as a pdf file to the downloads from the browser'),
(3018, 'Download all patient documents'),
(3019, 'Download Anyway'),
(3020, 'Download billing file, post to accounting and mark as billed'),
(3021, 'Download CCDA file'),
(3022, 'Download Certificates'),
(3023, 'Download configuration data'),
(3024, 'Download CSV File'),
(3025, 'Download document template for this patient and visit'),
(3026, 'Download Documents'),
(3027, 'download encrypted file'),
(3028, 'Download Fax'),
(3029, 'Download HL7 file'),
(3030, 'Download Lab Documents'),
(3031, 'Download Offsite Portal Connection Files'),
(3032, 'Download or Delete a Template'),
(3033, 'Download PDF'),
(3034, 'Download QRDA Category III File'),
(3035, 'Download report as a pdf file into the browser\'s download folder'),
(3036, 'Download Selected'),
(3037, 'Download Selected Statements'),
(3038, 'Download will download a text file containing the order in the HL7v2.3 message format to the downloads directory of your computer'),
(3039, 'Dr Check'),
(3040, 'Dr Visit'),
(3041, 'Dr.'),
(3042, 'Drafts'),
(3043, 'Drag a DX over by its handle'),
(3044, 'Drag the arrow for each diagnosis to sort the list.'),
(3045, 'Drag to move'),
(3046, 'Draw'),
(3047, 'Dribbling'),
(3048, 'Drivers License or State ID'),
(3049, 'Drop files here to upload'),
(3050, 'Drug'),
(3051, 'Drug - Drug Interaction'),
(3052, 'Drug Code'),
(3053, 'Drug Finder'),
(3054, 'Drug Forms'),
(3055, 'Drug ID missing!'),
(3056, 'Drug Intervals'),
(3057, 'Drug Inventory'),
(3058, 'Drug name'),
(3059, 'Drug Name'),
(3060, 'Drug name is required'),
(3061, 'Drug Routes'),
(3062, 'Drug Screen'),
(3063, 'Drug Screen Completed'),
(3064, 'Drug Screen Report'),
(3065, 'Drug units'),
(3066, 'Drug Units'),
(3067, 'Drug Use'),
(3068, 'Drug-Drug'),
(3069, 'Drug-Drug Interaction'),
(3070, 'Drug1 Name{{Drug1 Interaction}}'),
(3071, 'Drug2 Name{{Drug2 Interaction}}'),
(3072, 'Drugs'),
(3073, 'Drugs and Products'),
(3074, 'Dry Mouth'),
(3075, 'DSMIV Diagnosis'),
(3076, 'DT 1'),
(3077, 'DT 2'),
(3078, 'DT 3'),
(3079, 'DT 4'),
(3080, 'DT 5'),
(3081, 'DTaP 1'),
(3082, 'DTaP 2'),
(3083, 'DTaP 3'),
(3084, 'DTaP 4'),
(3085, 'DTaP 5'),
(3086, 'Dual'),
(3087, 'Due'),
(3088, 'Due Date'),
(3089, 'Due date'),
(3090, 'Due date mm/dd/yyyy or yyyy-mm-dd'),
(3091, 'Due Date:'),
(3092, 'Due Ins'),
(3093, 'Due Pt'),
(3094, 'Due Soon'),
(3095, 'Due Status'),
(3096, 'Due Status Update'),
(3097, 'Dumping OpenEMR database'),
(3098, 'Dumping OpenEMR web directory tree'),
(3099, 'Dumping phpGACL database'),
(3100, 'Dumping phpGACL web directory tree'),
(3101, 'Dumping SQL-Ledger database'),
(3102, 'Dumping SQL-Ledger web directory tree'),
(3103, 'Dup Check'),
(3104, 'Dup Check on only Edit'),
(3105, 'Dup Check on only New'),
(3106, 'Duplicate codes are deleted from editor list otherwise, code will append to list.'),
(3107, 'Duplicate Rx -- unchanged from current Rx{{The refraction did not change, New Rx=old Rx}}'),
(3108, 'Duplicated ID on line'),
(3109, 'Duplicated name on line'),
(3110, 'DUPLICATION WARNING'),
(3111, 'Durable Power of Attorney'),
(3112, 'Duration'),
(3113, 'duration'),
(3114, 'Dutch'),
(3115, 'Dx Codes'),
(3116, 'Dx Rep'),
(3117, 'Dysphagia'),
(3118, 'Dyspnea:'),
(3119, 'Dysuria'),
(3120, 'Dzongkha'),
(3121, 'E(T){{intermittent esotropia}}'),
(3122, 'E-Mail'),
(3123, 'E-mail'),
(3124, 'E-Mail Address'),
(3125, 'E-mail Messaging'),
(3126, 'E-mail OK'),
(3127, 'E-PRESCRIBING'),
(3128, 'E-Prescription?'),
(3129, 'E-Reports'),
(3130, 'e-Rx'),
(3131, 'e-Rx EPCS'),
(3132, 'e-Rx Renewal'),
(3133, 'e-signed'),
(3134, 'Each of these groups (AROs) has access to pre-determined parts of the program (ACOs).'),
(3135, 'Each recipient must set their own messages as completed.'),
(3136, 'Each Section has one Narrative Block and zero to many coded Entries'),
(3137, 'Each segment is identified by a unique three letter header that constitutes the first three letters on that line'),
(3138, 'Each test or panel in this group has to be in an individual Custom Favorite Item tier'),
(3139, 'Each Transaction is listed on a separate line'),
(3140, 'Early Recurrence (<2 Mo)'),
(3141, 'Ears'),
(3142, 'Easipro Server'),
(3143, 'Easipro Server Password'),
(3144, 'Easipro Server Username'),
(3145, 'Easy to forget on the computer used to login'),
(3146, 'Easy to setup'),
(3147, 'Easy to use'),
(3148, 'ECG'),
(3149, 'eClaims'),
(3150, 'ECL{{equivalent contact lens power at the corneal level}}'),
(3151, 'ECOM{{external comments abbreviation}}'),
(3152, 'Edema'),
(3153, 'EDI File'),
(3154, 'EDI History'),
(3155, 'edi history'),
(3156, 'EDI History (under Fees) for storing and interpreting EDI claim response files'),
(3157, 'EDI-271 File Upload'),
(3158, 'EDI-271 Response File Upload'),
(3159, 'Edit'),
(3160, 'edit'),
(3161, 'Edit Allergies'),
(3162, 'Edit Appointment'),
(3163, 'Edit Categories'),
(3164, 'Edit Current Patient'),
(3165, 'Edit Definitions'),
(3166, 'Edit definitions'),
(3167, 'Edit Diagnoses for'),
(3168, 'Edit Disclosure'),
(3169, 'Edit Document'),
(3170, 'Edit Entry'),
(3171, 'Edit Event'),
(3172, 'EDIT EXISTING GROUP'),
(3173, 'Edit Facilities'),
(3174, 'Edit Facility'),
(3175, 'Edit Facility Information'),
(3176, 'Edit Facility Specific User Information'),
(3177, 'Edit File in'),
(3178, 'Edit form'),
(3179, 'Edit Global Settings'),
(3180, 'Edit History and Lifestyle'),
(3181, 'Edit is not authorized!'),
(3182, 'Edit Issue'),
(3183, 'Edit layout'),
(3184, 'Edit Layout Properties'),
(3185, 'Edit list'),
(3186, 'Edit Mode'),
(3187, 'Edit Onsite Portal Activity'),
(3188, 'Edit Payment'),
(3189, 'Edit Structure'),
(3190, 'Edit Template'),
(3191, 'Edit this form'),
(3192, 'Edit User'),
(3193, 'Edit User Settings'),
(3194, 'Edit your entered data'),
(3195, 'Editing failed'),
(3196, 'Education'),
(3197, 'Education Date'),
(3198, 'Educational materials for'),
(3199, 'ee the  * GNU General Public License for more details.  *   * You should have received a copy of the GNU General Public License  * along with this program; if not, write to the Free '),
(3200, 'Effective Date'),
(3201, 'Effective Dates'),
(3202, 'Effectiveness'),
(3203, 'eg. aching, burning, radiating pain'),
(3204, 'EIN'),
(3205, 'Either type a search term in appropriate box or double click box to see available codes.'),
(3206, 'Either way data entered by any method will feature in both locations'),
(3207, 'Ejaculations'),
(3208, 'Elbow'),
(3209, 'Elbow Problems'),
(3210, 'Electronic'),
(3211, 'Electronic document received'),
(3212, 'Electronic Notes'),
(3213, 'Electronic orders'),
(3214, 'Electronic Remits'),
(3215, 'Electronic Reports'),
(3216, 'Electronic results can be bidirectional - both order tests and receive results electronically or unidirectional - only receive the results electronically'),
(3217, 'electronically signed on'),
(3218, 'Eligibility'),
(3219, 'Eligibility 270 Inquiry Batch'),
(3220, 'Eligibility Response'),
(3221, 'Eligibility Service Date (270 DTP03)'),
(3222, 'Eligibility status for Vaccine for Children supplied vaccine'),
(3223, 'Eligible'),
(3224, 'Ellipse'),
(3225, 'Email'),
(3226, 'email'),
(3227, 'EMAIL'),
(3228, 'Email Address'),
(3229, 'Email address is missing'),
(3230, 'Email address of the sender for patient reminders. Replies to patient reminders will be directed to this address. It is important to use an address from your clinic\'s domain to avoid help prevent patient reminders from going to junk mail folders.'),
(3231, 'Email address, if any, to receive administrative notifications.'),
(3232, 'Email address, if any, to receive emergency login user activation messages.'),
(3233, 'Email Auth'),
(3234, 'EMAIL Confimed'),
(3235, 'Email Direct'),
(3236, 'Email from Batchcom'),
(3237, 'Email if required'),
(3238, 'Email Notification'),
(3239, 'Email Notification Hours'),
(3240, 'Email Notification Report'),
(3241, 'Email Notification Settings Updated Successfully'),
(3242, 'Email Selected'),
(3243, 'Email Selected Statements'),
(3244, 'Email send before'),
(3245, 'Email Sender'),
(3246, 'Email Sent'),
(3247, 'Email sent to'),
(3248, 'Email Subject'),
(3249, 'email subject'),
(3250, 'Email Text Usable Tags'),
(3251, 'Email Text, Usable Tag: ***NAME*** , i.e. Dear ***NAME***'),
(3252, 'Email Text, Usable Tag: ***NAME*** , i.e. Dear ***NAME***{{Do Not translate the ***NAME*** elements of this constant.}}'),
(3253, 'Email Transport Method'),
(3254, 'Email was sent to following address'),
(3255, 'emails not sent'),
(3256, 'Embed {login} where the OpenEMR login name of the user is to be; for example: uid={login},dc=example,dc=com'),
(3257, 'Emergency Care'),
(3258, 'Emergency contact'),
(3259, 'Emergency Contact'),
(3260, 'Emergency Contact Person'),
(3261, 'Emergency Contact Phone Number'),
(3262, 'Emergency Contraception'),
(3263, 'Emergency Login'),
(3264, 'Emergency Login ACL is chosen. The user is still in active state, please de-activate the user and activate the same when required during emergency situations. Visit Administration->Users for activation or de-activation.'),
(3265, 'Emergency Login activation email will be circulated only if following settings in the interface/globals.php file are configured:'),
(3266, 'Emergency Login Email Address'),
(3267, 'Emergency Login user can do anything'),
(3268, 'Emergency Phone'),
(3269, 'Emergency Room - Hospital'),
(3270, 'Emotional / Behavioral Conditions & Complications'),
(3271, 'Emphysema'),
(3272, 'Employee'),
(3273, 'Employer'),
(3274, 'Employer Address'),
(3275, 'Employer Data'),
(3276, 'Employer Name'),
(3277, 'EMPTY'),
(3278, 'Empty'),
(3279, 'Empty Password Not Allowed'),
(3280, 'Empty table'),
(3281, 'Empty value in \"Email Hours\"'),
(3282, 'Empty value in \"Email Sender\"'),
(3283, 'Empty value in \"Email Subject\"'),
(3284, 'Empty value in \"Email Text\"'),
(3285, 'Empty value in \"Name of Provider\"'),
(3286, 'Empty value in \"Password\"'),
(3287, 'Empty value in \"SMS Hours\"'),
(3288, 'Empty value in \"SMS Text\"'),
(3289, 'Empty value in \"Username\"'),
(3290, 'EMR Direct'),
(3291, 'EMR Direct phiMail is a secure, scalable, standards-based way for participants to send authenticated, encrypted health information directly to known, trusted recipients over the Internet'),
(3292, 'Enable'),
(3293, 'Enable a Payment Gateway Service for processing credit card transactions'),
(3294, 'Enable Alert Log'),
(3295, 'Enable Alert Logging'),
(3296, 'Enable Allergy Check'),
(3297, 'Enable Allergy Check Against Medications and Prescriptions'),
(3298, 'Enable AMC Prompting'),
(3299, 'Enable AMC Report Itemization'),
(3300, 'Enable AMC Reporting'),
(3301, 'Enable AMC Tracking'),
(3302, 'Enable amendments feature'),
(3303, 'Enable ATNA Auditing'),
(3304, 'Enable Audit Log Encryption'),
(3305, 'Enable Audit Logging'),
(3306, 'Enable Audit Trail and Node Authentication (ATNA).'),
(3307, 'Enable Automated Measure Calculations (AMC) Reporting'),
(3308, 'Enable Batch Payment'),
(3309, 'Enable C-CDA Alternate Service'),
(3310, 'Enable C-CDA Service'),
(3311, 'Enable Client'),
(3312, 'Enable Client SSL'),
(3313, 'Enable client SSL certificate authentication.'),
(3314, 'Enable Clinical Active Reminder Popup'),
(3315, 'Enable Clinical Decisions Rules (CDR)'),
(3316, 'Enable Clinical Passive New Reminder(s) Popup'),
(3317, 'Enable Clinical Passive Reminder Widget'),
(3318, 'Enable Clinical Quality Measure (CQM) Reporting'),
(3319, 'Enable Clinical Reminder Popup'),
(3320, 'Enable Clinical Reminder Widget'),
(3321, 'Enable CMS Portal'),
(3322, 'Enable Compact Mode'),
(3323, 'Enable CQM Report Itemization'),
(3324, 'Enable CQM Reporting'),
(3325, 'Enable Database Connection Pooling'),
(3326, 'Enable Easipro'),
(3327, 'Enable Easipro. For licensing options for this feature, please contact'),
(3328, 'Enable EDI History'),
(3329, 'Enable EDI History In Left Menu'),
(3330, 'Enable Encryption of Items Stored on CouchDB'),
(3331, 'Enable Encryption of Items Stored on Drive'),
(3332, 'Enable Extension'),
(3333, 'Enable Facility'),
(3334, 'Enable Fees In Left Menu'),
(3335, 'Enable Fees Submenu'),
(3336, 'Enable FHIR Provider Client Service'),
(3337, 'Enable follow-up encounters'),
(3338, 'Enable follow-up encounters feature'),
(3339, 'Enable Group Therapy'),
(3340, 'Enable Help Modal'),
(3341, 'Enable Hylafax Support'),
(3342, 'Enable import status message after visiting NewCrop eRx.'),
(3343, 'Enable import status message for NewCrop erx'),
(3344, 'Enable Itemization of AMC Reports'),
(3345, 'Enable Itemization of CQM Reports'),
(3346, 'Enable Itemization of Standard Clinical Rules Reports'),
(3347, 'Enable Lab Exchange'),
(3348, 'Enable lock toggle'),
(3349, 'Enable log for document uploads/downloads to CouchDB'),
(3350, 'Enable logging of all SQL SELECT queries.'),
(3351, 'Enable logging of backup related activities.'),
(3352, 'Enable logging of CDR Engine Queries.'),
(3353, 'Enable logging of miscellaneous activities.'),
(3354, 'Enable logging of ordering activities.'),
(3355, 'Enable logging of patient record modifications.'),
(3356, 'Enable logging of scheduling activities.'),
(3357, 'Enable logging of security and administration activities.'),
(3358, 'Enable MedEx Communication Service'),
(3359, 'Enable NewCrop eRx import status message'),
(3360, 'Enable NewCrop eRx Service'),
(3361, 'Enable NewCrop eRx Service.'),
(3362, 'Enable OAuth2 Password Grant (Not considered secure)'),
(3363, 'Enable OAuth2 Password Grant. Recommend turning this setting off for production server. Recommend only using for testing.'),
(3364, 'Enable Office Ally Insurance Eligibility'),
(3365, 'Enable Offsite Patient Portal'),
(3366, 'Enable Offsite Patient Portal.'),
(3367, 'Enable only one type of portal by checking the relevant check-box'),
(3368, 'Enable Onsite Patient Portal'),
(3369, 'Enable Onsite Patient Portal Document Download'),
(3370, 'Enable Onsite Patient Portal new patient to self register.'),
(3371, 'Enable Onsite Patient Portal.'),
(3372, 'Enable OpenEMR Patient Portal FHIR REST API (EXPERIMENTAL)'),
(3373, 'Enable OpenEMR Patient Portal FHIR RESTful API.'),
(3374, 'Enable OpenEMR Patient Portal REST API (EXPERIMENTAL)'),
(3375, 'Enable OpenEMR Patient Portal RESTful API.'),
(3376, 'Enable OpenEMR REST API'),
(3377, 'Enable OpenEMR RESTful API. SSL Required'),
(3378, 'Enable OpenEMR Standard FHIR REST API'),
(3379, 'Enable OpenEMR Standard FHIR RESTful API.'),
(3380, 'Enable OpenEMR Standard REST API'),
(3381, 'Enable OpenEMR Standard RESTful API.'),
(3382, 'Enable Patient Portal'),
(3383, 'Enable Patient Portal Document Download'),
(3384, 'Enable Patient Portal new patient to self register.'),
(3385, 'Enable Patient Reminder Widget'),
(3386, 'Enable percent-based price levels'),
(3387, 'Enable phiMail Direct Messaging Service'),
(3388, 'Enable Posting'),
(3389, 'Enable Prompting For Automated Measure Calculations (AMC) Required Data'),
(3390, 'Enable Random Drug Testing'),
(3391, 'Enable Reporting of Tracking Date For Automated Measure Calculations (AMC)'),
(3392, 'Enable Scanner Support'),
(3393, 'Enable Standard Report Itemization'),
(3394, 'Enable support for the open source WordPress Portal by Sunset Systems'),
(3395, 'Enable Text Templates in Encounter Forms'),
(3396, 'Enable the Medical Information Integration, LLC Lab Exchange Service.'),
(3397, 'Enable the OpenEMR Support LLC Lab Exchange Service.'),
(3398, 'Enable User Certificate Authentication'),
(3399, 'Enable Version 1 Onsite Patient Portal'),
(3400, 'Enable Version 2 Onsite Patient Portal'),
(3401, 'Enable Version 2 Onsite Patient Portal new patient to self register.'),
(3402, 'Enable Weno eRx Service'),
(3403, 'Enable ZMG, LLC eRx service'),
(3404, 'enabled'),
(3405, 'Enabled'),
(3406, 'Enabled Client'),
(3407, 'Enabled Services'),
(3408, 'Enables choose due date to message'),
(3409, 'Enables groups module in system.'),
(3410, 'Enables the ability to download documents in the Onsite Patient Portal by the user.'),
(3411, 'Enables the ability to download documents in the Patient Portal by the user.'),
(3412, 'Enables the old Charges panel for entering billing codes and payments. Not recommended, use the Fee Sheet instead.'),
(3413, 'Enables to submit changes for all appointments of a recurrence at once.'),
(3414, 'Enabling EMR Direct phiMail'),
(3415, 'Enc'),
(3416, 'Enc#'),
(3417, 'Encnter'),
(3418, 'Encounter'),
(3419, 'encounter'),
(3420, 'Encounter '),
(3421, 'encounter acute inpatient or ED'),
(3422, 'Encounter Balance'),
(3423, 'Encounter Billing Note'),
(3424, 'Encounter Checkup Procedure'),
(3425, 'Encounter Count'),
(3426, 'encounter data'),
(3427, 'Encounter Date'),
(3428, 'Encounter Diagnosis'),
(3429, 'Encounter Dt / Rsn'),
(3430, 'Encounter EDI Record'),
(3431, 'Encounter Esigned'),
(3432, 'Encounter Forms'),
(3433, 'encounter health and behavior assessment'),
(3434, 'Encounter History'),
(3435, 'Encounter ID'),
(3436, 'encounter influenza'),
(3437, 'Encounter Information'),
(3438, 'Encounter Information (encounters)'),
(3439, 'Encounter number'),
(3440, 'Encounter Number'),
(3441, 'encounter nursing discharge'),
(3442, 'encounter nursing facility'),
(3443, 'encounter occupational therapy'),
(3444, 'encounter office visit'),
(3445, 'encounter outpatient'),
(3446, 'encounter outpatient w/PCP & obgyn'),
(3447, 'Encounter Page Size'),
(3448, 'Encounter Payment'),
(3449, 'encounter pregnancy'),
(3450, 'encounter preventive medicine - individual counseling'),
(3451, 'encounter preventive medicine 40 and older'),
(3452, 'encounter preventive medicine group counseling'),
(3453, 'encounter preventive medicine other services'),
(3454, 'encounter preventive medicine services 18 and older'),
(3455, 'Encounter Preview'),
(3456, 'Encounter Provider'),
(3457, 'encounter psychiatric & psychologic'),
(3458, 'Encounter statistics'),
(3459, 'Encounter Summary'),
(3460, 'Encounter type'),
(3461, 'Encounter was coded'),
(3462, 'Encounter:'),
(3463, 'Encounter: encounter non-acute inpt, outpatient, or ophthalmology'),
(3464, 'Encounters'),
(3465, 'Encounters & Forms'),
(3466, 'Encounters &amp; Forms'),
(3467, 'Encounters not authorized'),
(3468, 'Encounters Report'),
(3469, 'Encounters Section'),
(3470, 'Encrypted File'),
(3471, 'Encryption'),
(3472, 'End'),
(3473, 'End (yyyy-mm-dd): '),
(3474, 'End Date'),
(3475, 'End date'),
(3476, 'End Date From'),
(3477, 'End Date leave blank if ongoing'),
(3478, 'End date must be equal or bigger than start date'),
(3479, 'End date must be later than Begin date!'),
(3480, 'End date should be greater than Begin date'),
(3481, 'End Date To'),
(3482, 'End Date:'),
(3483, 'End of Day by Provider or allow Totals Only'),
(3484, 'End Of Day Report'),
(3485, 'End of report'),
(3486, 'End of Requisition'),
(3487, 'End Time'),
(3488, 'End watching server processes for upgrade version'),
(3489, 'End-Stage Renal Disease Beneficiary in MCP with Employer`s Group Plan'),
(3490, 'End-Stage Renal Disease Treatment Facility'),
(3491, 'Ending date'),
(3492, 'Ending date of service yyyy-mm-dd'),
(3493, 'Ending DOS mm/dd/yyyy if you wish to enter a range'),
(3494, 'Ending hour of day for calendar events.'),
(3495, 'Endo Abnormal Blood'),
(3496, 'Endocrine'),
(3497, 'Endoscopy'),
(3498, 'ENDO{{Endocrine}}'),
(3499, 'Enforce E-Mail in Portal Log On Dialog'),
(3500, 'Engineer'),
(3501, 'Engineering Firm'),
(3502, 'English'),
(3503, 'English '),
(3504, 'English (Indian)'),
(3505, 'English (Standard)'),
(3506, 'Enscript command used by Hylafax.'),
(3507, 'Ensure OpenEMR has write privileges to directory'),
(3508, 'Ensure that Identifying Codes are unique'),
(3509, 'ENT Discharge'),
(3510, 'ENT Pain'),
(3511, 'Enter 1 under sequence, more about sequence numbers later'),
(3512, 'Enter a Begin Date'),
(3513, 'Enter a diagnosis code to exclude all invoices not containing it'),
(3514, 'Enter a sequence 1'),
(3515, 'Enter an amendment...'),
(3516, 'Enter an End Date if the problem has been resolved'),
(3517, 'Enter Application Name'),
(3518, 'Enter body of letter here'),
(3519, 'Enter City'),
(3520, 'Enter Database root Password'),
(3521, 'Enter Database root Username'),
(3522, 'Enter Details'),
(3523, 'Enter Details for Custom Favorite Group'),
(3524, 'Enter Details for Discrete Results'),
(3525, 'Enter Details for Group'),
(3526, 'Enter Details for Individual Custom Favorite Item'),
(3527, 'Enter Details for Individual Procedures'),
(3528, 'Enter Details for Recommendation'),
(3529, 'Enter Diagnosis'),
(3530, 'Enter Drugs'),
(3531, 'Enter E-Mail Address'),
(3532, 'Enter email address to receive registration.'),
(3533, 'Enter Encounter'),
(3534, 'Enter Encounter Number'),
(3535, 'Enter Facility Name'),
(3536, 'Enter ID'),
(3537, 'Enter Immunizations'),
(3538, 'Enter Key'),
(3539, 'Enter Last'),
(3540, 'Enter name'),
(3541, 'Enter needed information to help process this particular claim'),
(3542, 'Enter new data'),
(3543, 'Enter new office note here'),
(3544, 'Enter new State'),
(3545, 'Enter Occurrence if appropriate'),
(3546, 'Enter or select the options in the various boxes to filter the results according to need and press Filter'),
(3547, 'Enter Password'),
(3548, 'Enter Provider Details'),
(3549, 'Enter Recipient\'s Direct Address'),
(3550, 'Enter required authentication code'),
(3551, 'Enter Self if None'),
(3552, 'Enter Serum Uric Acid in the Name box'),
(3553, 'Enter Serum Uric Acid order in the Description box'),
(3554, 'Enter Serum Uric Acid result under Description'),
(3555, 'Enter Serum Uric Acid under Name'),
(3556, 'Enter the category data in the appropriate fields and click \'Save\'. These will be used to group the ICD codes and will be displayed on the buttons in the \'Select Codes\' section'),
(3557, 'Enter the code from your authentication application on your device'),
(3558, 'Enter the default range values if applicable, used in manual entry of results.'),
(3559, 'Enter the default units for this test.'),
(3560, 'Enter the details - Name - Well Woman Tests, Description - Well Woman Tests, an appropriate sequence number depending on the procedure orders already entered, Order From - Local Lab'),
(3561, 'Enter the details as follows Name - Blood Glucose, Description - Fasting Glucose result, Sequence - 1, Identifying Code - any unique value - WWT01R, Default Units - mg/dL, Default Range - 70-100, leave Followup Services blank and click Save'),
(3562, 'Enter the Direct address and click Send CCR/Send CCD as the case may be'),
(3563, 'Enter the following: Name - Blood Glucose, Description - Fasting Blood Glucose, Sequence - 1, Order From - Local Lab'),
(3564, 'Enter the laterality of this procedure, if applicable.'),
(3565, 'Enter the Logical Observation Identifiers Names and Codes (LOINC) code for this procedure'),
(3566, 'Enter the Logical Observation Identifiers Names and Codes (LOINC) code for this procedure. LOINC is a database and universal standard for identifying medical laboratory observations.'),
(3567, 'Enter the LOINC code for this procedure'),
(3568, 'Enter the OpenEMR login password for the user and click Submit'),
(3569, 'Enter the Re Identification code'),
(3570, 'Enter the relevant site if applicable.'),
(3571, 'Enter the Server Address, Username, and Password provided to you'),
(3572, 'Enter the Severity of the allergy'),
(3573, 'Enter the specimen type if applicable.'),
(3574, 'Enter the values 3.4 - 7.2 - Men, 2.4–6.1 - Women'),
(3575, 'Enter their OpenEMR username in the notification user field'),
(3576, 'Enter User Login ID'),
(3577, 'Enter values in this section to create a new group also known as Access Request Object (ARO)'),
(3578, 'Enter your credentials'),
(3579, 'Enter your existing current password used to login.'),
(3580, 'Enter your password to sign the form'),
(3581, 'Enter your search criteria above'),
(3582, 'Enter Your Zip'),
(3583, 'Entered By'),
(3584, 'Entered in Error'),
(3585, 'Entered User Name is unavalable!'),
(3586, 'entries'),
(3587, 'Envelope Height in mm'),
(3588, 'Envelope Width in mm'),
(3589, 'Envelope x-axis starting pt'),
(3590, 'Envelope y-axis starting pt'),
(3591, 'Environmental'),
(3592, 'EOB Data Entry'),
(3593, 'EOB Data Entry (eob)'),
(3594, 'EOB Id'),
(3595, 'EOB Invoice'),
(3596, 'EOB Posting - Electronic Remittances'),
(3597, 'EOB Posting - Instructions'),
(3598, 'EOB Posting - Invoice'),
(3599, 'EOB Posting - Patient Note'),
(3600, 'EOB Posting - Search'),
(3601, 'EOBs'),
(3602, 'Epilepsy'),
(3603, 'Episode'),
(3604, 'EPSDT'),
(3605, 'EPSDT:'),
(3606, 'Equals'),
(3607, 'Equivalent contact lens power at the corneal level'),
(3608, 'ERA'),
(3609, 'ERA Files'),
(3610, 'ERA Posting'),
(3611, 'ERA Upload'),
(3612, 'Erase'),
(3613, 'Eraser'),
(3614, 'Erections'),
(3615, 'Error'),
(3616, 'ERROR'),
(3617, 'Error confirming receipt of lab results'),
(3618, 'Error creating directory!'),
(3619, 'Error finding diagnosis element. Try again.'),
(3620, 'Error getting lab results from Lab Exchange Network'),
(3621, 'Error in \"Gender\" selection'),
(3622, 'Error in \"HIPAA\" selection'),
(3623, 'Error in \"Process\" selection'),
(3624, 'Error in \"SMS Gateway\" selection'),
(3625, 'Error in \"Sort By\" selection'),
(3626, 'Error in gzip compression of file: '),
(3627, 'Error in YES or NO option'),
(3628, 'ERROR Missing Patient ID'),
(3629, 'Error number'),
(3630, 'Error opening uploaded file for reading'),
(3631, 'Error processing file'),
(3632, 'Error processing upload'),
(3633, 'Error Removing Message'),
(3634, 'Error retrieving results from Lab Exchange Network'),
(3635, 'Error retrieving values.'),
(3636, 'Error saving document'),
(3637, 'Error when granting file privilege to the OpenEMR user.'),
(3638, 'Error while adding new plan'),
(3639, 'Error while deleting the plan'),
(3640, 'error while registering form!'),
(3641, 'Error while saving to the file'),
(3642, 'Error while updating the plan'),
(3643, 'Error while writing to file'),
(3644, 'Error! Images state save failed.'),
(3645, 'ERROR!... in Update'),
(3646, 'error(s) encountered from new results'),
(3647, 'Error, Class ZipArchive does not exist'),
(3648, 'Error, Could not create file archive'),
(3649, 'Error, the CA Certificate File doesn\'t exist'),
(3650, 'Error, the CA Key File doesn\'t exist'),
(3651, 'Error, the file does not exist'),
(3652, 'ERROR, unable to collect data from server'),
(3653, 'Error, unable to create client certificate.'),
(3654, 'Error, unable to create the admin.p12 certificate.'),
(3655, 'Error, unable to create the Certificate Authority certificate.'),
(3656, 'Error, unable to create the Server certificate.'),
(3657, 'Error, unable to create zip file with all the certificates'),
(3658, 'Error, unable to open file'),
(3659, 'Error, User Certificate Authentication is not enabled in OpenEMR'),
(3660, 'ERROR. Could not open'),
(3661, 'Error. Not authorized'),
(3662, 'Error. Try again later'),
(3663, 'Error. You need to install the Archive/Tar.php php module.'),
(3664, 'ERROR: could not open table.sql, broken form?'),
(3665, 'Error: Duplicated field ID'),
(3666, 'Error: duplicated ID'),
(3667, 'Error: duplicated ID on line'),
(3668, 'Error: duplicated name on line'),
(3669, 'ERROR: Field'),
(3670, 'ERROR: Missing ZipArchive PHP Module'),
(3671, 'ERROR: No ICD import directory.'),
(3672, 'Error: passwords don\'t match. Please check your typing.'),
(3673, 'Error: passwords don\'t match. Please check your typing.'),
(3674, 'Error: the file does not exist'),
(3675, 'ERROR: The following variable contains invalid characters'),
(3676, 'ERROR: Unable to copy the file.'),
(3677, 'Error: Unable to create downloadable archive'),
(3678, 'ERROR: Unable to Create Zip Archive.'),
(3679, 'ERROR: Unable to extract the file.'),
(3680, 'ERROR: Unable to load the file into the database.'),
(3681, 'ERROR: Unable to set the version number.'),
(3682, 'Errors'),
(3683, 'eRx'),
(3684, 'eRx Account Status'),
(3685, 'eRx Logs'),
(3686, 'ERX Name'),
(3687, 'ERX Password'),
(3688, 'ERX Role'),
(3689, 'ERX User'),
(3690, 'Erythema:'),
(3691, 'eSign'),
(3692, 'eSign Log'),
(3693, 'Eskimo'),
(3694, 'Esophoria'),
(3695, 'Esotropia'),
(3696, 'Esperanto'),
(3697, 'Est'),
(3698, 'Established'),
(3699, 'Established Patient'),
(3700, 'Estonian'),
(3701, 'Ethnicity'),
(3702, 'Ethnicity or Race'),
(3703, 'Ethnicity-Race List (write,addonly optional)'),
(3704, 'Ethnicity-Race List (write,addonly optional) (ethrace)'),
(3705, 'Ethnoracial'),
(3706, 'ETIN'),
(3707, 'ETOH'),
(3708, 'ET{{esotropia}}'),
(3709, 'Event'),
(3710, 'Event Begins'),
(3711, 'Event Category'),
(3712, 'Event Date'),
(3713, 'event date or starting date'),
(3714, 'Event Description'),
(3715, 'Event Details'),
(3716, 'Event does not repeat'),
(3717, 'Event Duration'),
(3718, 'Event duration in minutes'),
(3719, 'Event Fee'),
(3720, 'Event Location'),
(3721, 'Event repeats every'),
(3722, 'Event repeats on'),
(3723, 'Event start time'),
(3724, 'Event title'),
(3725, 'Event Title'),
(3726, 'Event Website'),
(3727, 'Events'),
(3728, 'Events for'),
(3729, 'Events open in new window'),
(3730, 'Events Scheduled'),
(3731, 'every'),
(3732, 'Every'),
(3733, 'Every 2nd'),
(3734, 'every 3 hours'),
(3735, 'Every 3rd'),
(3736, 'every 4 hours'),
(3737, 'Every 4th'),
(3738, 'every 5 hours'),
(3739, 'Every 5th'),
(3740, 'every 6 hours'),
(3741, 'Every 6th'),
(3742, 'every 8 hours'),
(3743, 'Every Fourth'),
(3744, 'Every name in the address book appears here, not only physicians.'),
(3745, 'Every Other'),
(3746, 'Every Third'),
(3747, 'Every, every other, every 3rd, etc.'),
(3748, 'Ewe'),
(3749, 'Exam and test results'),
(3750, 'Exam results'),
(3751, 'Exam Room #'),
(3752, 'Exam Room Number'),
(3753, 'Examination'),
(3754, 'Examination Date'),
(3755, 'Example'),
(3756, 'Example authenticator apps include'),
(3757, 'Example Privacy_Agreement.txt becomes Privacy Agreement button in Patient Documents'),
(3758, 'Examples'),
(3759, 'Examples of Sections are - Medications, Allergies, Vital Signs'),
(3760, 'Exams/Tests'),
(3761, 'Exam{{Physical Exam}}'),
(3762, 'Except'),
(3763, 'Excessive Tearing'),
(3764, 'Exclude in Portal'),
(3765, 'Excluded Appointments - Tooltip - Number to Display'),
(3766, 'Excluded Patients'),
(3767, 'Exclusion'),
(3768, 'Exclusive Provider Organization (EPO)'),
(3769, 'Executables not allowed'),
(3770, 'Executive Paper Size'),
(3771, 'Exercise'),
(3772, 'Exercise patterns'),
(3773, 'Exercise Patterns'),
(3774, 'Exist'),
(3775, 'existing claim status is not altered.'),
(3776, 'Existing Forms'),
(3777, 'Exit'),
(3778, 'Exit from Administration'),
(3779, 'Exit Mail'),
(3780, 'Exophoria'),
(3781, 'Exotropia'),
(3782, 'Exp'),
(3783, 'Exp Date'),
(3784, 'Expand'),
(3785, 'expand'),
(3786, 'Expand / Collapse'),
(3787, 'Expand All'),
(3788, 'Expand All Document Categories'),
(3789, 'Expand All Document Categories by Default'),
(3790, 'Expand Form'),
(3791, 'Expand/Collapse this form'),
(3792, 'Expanded View'),
(3793, 'Expected form_encounter.pid to be '),
(3794, 'Expiration'),
(3795, 'Expiration Date'),
(3796, 'Expired'),
(3797, 'Expires'),
(3798, 'expires in'),
(3799, 'Export'),
(3800, 'Export as CSV'),
(3801, 'Export Billing'),
(3802, 'Export Configuration'),
(3803, 'Export File'),
(3804, 'Export Individual Invoices'),
(3805, 'Export OFX'),
(3806, 'Export Patient Demographics'),
(3807, 'Export Patient Demographics XML'),
(3808, 'Export PQRI Report'),
(3809, 'Export QRDA Report'),
(3810, 'Export Selected as CSV'),
(3811, 'Export Selected to Collections'),
(3812, 'Export to CSV'),
(3813, 'Export to external billing system'),
(3814, 'Export Zero Balances'),
(3815, 'Exposure to Foreign Countries'),
(3816, 'Exposure To Foreign Countries'),
(3817, 'Ext'),
(3818, 'Ext Time Collected'),
(3819, 'Extended family'),
(3820, 'External'),
(3821, 'External Data'),
(3822, 'External Data - any external data linked to either encounters or procedures'),
(3823, 'External Data Loads'),
(3824, 'External Database Import Utility'),
(3825, 'External Draw Panel'),
(3826, 'External Exam'),
(3827, 'External Exam Default Values'),
(3828, 'External ID'),
(3829, 'External Id'),
(3830, 'External identifier'),
(3831, 'External Only'),
(3832, 'External Organization'),
(3833, 'External Provider'),
(3834, 'External Referral'),
(3835, 'External Referral Followups'),
(3836, 'External referral?'),
(3837, 'External Referrals'),
(3838, 'Extract the zip file'),
(3839, 'Extracting the file. This will take some time...'),
(3840, 'Exudate:'),
(3841, 'Eye'),
(3842, 'Eye Coding Fields'),
(3843, 'Eye Coding Terms'),
(3844, 'Eye Contact Lens Brand list'),
(3845, 'Eye Contact Lens Manufacturer list'),
(3846, 'Eye Contact Lens Supplier list'),
(3847, 'Eye Dx{{eye diagnosis}}'),
(3848, 'Eye Exam'),
(3849, 'Eye Exam Default Values for New Providers'),
(3850, 'Eye Irritation'),
(3851, 'Eye Lens Material'),
(3852, 'Eye Lens Treatments'),
(3853, 'Eye Med'),
(3854, 'Eye Meds'),
(3855, 'Eye Orders Defaults'),
(3856, 'Eye Pain'),
(3857, 'Eye QP List ANTSEG for New Providers'),
(3858, 'Eye QP List EXT for New Providers'),
(3859, 'Eye QP List RETINA for New Providers'),
(3860, 'Eye Redness'),
(3861, 'Eye Surgery'),
(3862, 'Eyedropper'),
(3863, 'Eyes'),
(3864, 'E{{esophoria}}'),
(3865, 'F'),
(3866, 'F/H Blood Problems'),
(3867, 'F/H Female Hirsutism/Striae'),
(3868, 'Facilities'),
(3869, 'Facility'),
(3870, 'facility'),
(3871, 'Facility Administration'),
(3872, 'Facility City'),
(3873, 'Facility Code'),
(3874, 'Facility Color Schema'),
(3875, 'Facility Country code'),
(3876, 'Facility Fax'),
(3877, 'Facility ID'),
(3878, 'Facility Name'),
(3879, 'Facility NPI'),
(3880, 'Facility Phone'),
(3881, 'Facility reflects the facility in which the visit occurred'),
(3882, 'Facility Specific User Information'),
(3883, 'Facility State'),
(3884, 'Facility Street'),
(3885, 'Facility Taxonomy'),
(3886, 'Facility Zip'),
(3887, 'Facility Zip Code'),
(3888, 'Facility:'),
(3889, 'FAIL'),
(3890, 'Failed'),
(3891, 'failed'),
(3892, 'Failed - already has group with the same name'),
(3893, 'Failed Patients'),
(3894, 'Failed Registration'),
(3895, 'Failed since file already exists'),
(3896, 'Failed to add patient to portal'),
(3897, 'Failed to compute a unique filename'),
(3898, 'Failed to create'),
(3899, 'Failed to create folder'),
(3900, 'Failed to create new group'),
(3901, 'Failed to create temporary folder. CouchDB will not work.'),
(3902, 'Failed to generate'),
(3903, 'Failed to get URL:'),
(3904, 'Failed to send'),
(3905, 'Failed to unregister module.'),
(3906, 'Failed UTF8 encoding check! Could not automatically fix.'),
(3907, 'Failed.'),
(3908, 'failure'),
(3909, 'Failure'),
(3910, 'FAILURE NOTICE: Direct Message Send Failed.'),
(3911, 'FAILURE: Couldn\'t create the zip'),
(3912, 'FAILURE: No patients for measure'),
(3913, 'Falls: Screening, Risk-Assessment, and Plan of Care to Prevent Future Falls (CQM)'),
(3914, 'False'),
(3915, 'Family Health History'),
(3916, 'Family History'),
(3917, 'Family history - Documents the patient\'s family history, an ICD10 diagnosis can be linked to the medical conditions'),
(3918, 'Family History of Glaucoma'),
(3919, 'Family History:'),
(3920, 'Family Member'),
(3921, 'Family Payment'),
(3922, 'Family Size'),
(3923, 'Fancy'),
(3924, 'Faroese'),
(3925, 'Farsi'),
(3926, 'Fasting'),
(3927, 'Fatal'),
(3928, 'Father'),
(3929, 'Fathers History'),
(3930, 'Fatigue'),
(3931, 'Fatigued'),
(3932, 'Favorites'),
(3933, 'Fax'),
(3934, 'Fax Count'),
(3935, 'Fax number'),
(3936, 'Fax sending failed'),
(3937, 'Fax/Scan'),
(3938, 'Faxes In'),
(3939, 'Faxes Out'),
(3940, 'Features'),
(3941, 'Feb'),
(3942, 'February'),
(3943, 'FECA'),
(3944, 'Federal Drug ID'),
(3945, 'Federal EIN'),
(3946, 'Federal Tax ID'),
(3947, 'Federally Qualified Health Center'),
(3948, 'Fee'),
(3949, 'fee'),
(3950, 'Fee is not allowed'),
(3951, 'Fee Sheet'),
(3952, 'Fee Sheet for'),
(3953, 'Fee Sheet Options'),
(3954, 'Fee sheet tab is already opened'),
(3955, 'Fees'),
(3956, 'Female'),
(3957, 'Female AP'),
(3958, 'Female Condoms'),
(3959, 'Female G'),
(3960, 'Female LC'),
(3961, 'Female P'),
(3962, 'Female Symptoms'),
(3963, 'Female VSC'),
(3964, 'Fetch'),
(3965, 'Fetching following file from portal'),
(3966, 'Fever'),
(3967, 'Fever:'),
(3968, 'FH Blood Problems'),
(3969, 'FHD, WUXGA'),
(3970, 'FHIR Server Base Address'),
(3971, 'FH{{Family History}}'),
(3972, 'Fibroids'),
(3973, 'FIDO U2F - Universal 2nd Factor from the Fast IDentity Online alliance'),
(3974, 'Field'),
(3975, 'Field \'name\' cannot be NULL'),
(3976, 'Field ID'),
(3977, 'Field not suitable for edit option M'),
(3978, 'Field type to use for employer or subscriber country in demographics.'),
(3979, 'Field type to use for employer or subscriber state in demographics.'),
(3980, 'Field(s) are missing!'),
(3981, 'FIELD: Text(.a); '),
(3982, 'Fields in This Form'),
(3983, 'Fields{{visual fields}}'),
(3984, 'Fifth account message'),
(3985, 'Fijian'),
(3986, 'File'),
(3987, 'File base name becomes Menu selection'),
(3988, 'File Error'),
(3989, 'file in the Documentation directory to learn how to automate the process of creating log backups'),
(3990, 'file location'),
(3991, 'File management'),
(3992, 'file missing'),
(3993, 'File Name'),
(3994, 'File not found'),
(3995, 'File Not Found'),
(3996, 'File on server (modification date)'),
(3997, 'File path not found.'),
(3998, 'File privilege granted to OpenEMR user.'),
(3999, 'File retrieval from CouchDB failed'),
(4000, 'File Room'),
(4001, 'File to upload'),
(4002, 'File to Upload'),
(4003, 'File with same name already exists at location:'),
(4004, 'Filename'),
(4005, 'Filename must end with \".pdf\"'),
(4006, 'Files'),
(4007, 'Files base name becomes a pending document selection in Portal Documents.'),
(4008, 'Files type white list'),
(4009, 'Files with empty thumbnail'),
(4010, 'filetype is not accepted'),
(4011, 'Filipino'),
(4012, 'fill'),
(4013, 'Fill any of the Below Row.'),
(4014, 'Fill here only if sending email notification to patients'),
(4015, 'Fill in any missing details or edit existing information. This will be saved in the patient\'s demographics page in openEMR'),
(4016, 'Fill in the CPT codes using the displayed format. The common E/M codes are already filled in, add more as needed'),
(4017, 'Fill in the details as required and click Save'),
(4018, 'Fill in the details for the Organ/Disease Panel as before and click Save to close the pop-up'),
(4019, 'Fill in the details in a fashion similar to that used for allergies'),
(4020, 'Fill in the necessary details in a fashion similar to that for Medical Problems'),
(4021, 'Fill in the reason and select a provider and clinic and click the Add Recall button to complete the process'),
(4022, 'Fill in the required details especially for the external facilities and click Save'),
(4023, 'Fill in the values below'),
(4024, 'Fill Instructions'),
(4025, 'Fill the Row.'),
(4026, 'Fill your first and last name'),
(4027, 'Filling in the other fields will help provide additional details pertinent to the referral'),
(4028, 'Filter'),
(4029, 'Filter for Constants'),
(4030, 'Filter for Definitions'),
(4031, 'filtered from'),
(4032, 'Filters'),
(4033, 'filters'),
(4034, 'Final'),
(4035, 'Final Diagnosis'),
(4036, 'Final diagnosis by specialist'),
(4037, 'Final Status'),
(4038, 'Financial'),
(4039, 'Financial Close Date (yyyy-mm-dd)'),
(4040, 'Financial Reporting - anything'),
(4041, 'Financial Reporting - anything (rep_a)'),
(4042, 'Financial Reporting - my encounters'),
(4043, 'Financial Reporting - my encounters (rep)'),
(4044, 'Financial Review'),
(4045, 'Financial Review Date'),
(4046, 'Financial Summary by Service Code'),
(4047, 'Financial transactions corresponding to the date range, if any, will be listed in the table'),
(4048, 'Find'),
(4049, 'Find Available'),
(4050, 'Find Available Appointments'),
(4051, 'Find Available{{Provider}}'),
(4052, 'Find Code History'),
(4053, 'Find Patient'),
(4054, 'Find Patient Education Materials'),
(4055, 'Find Procedure Order'),
(4056, 'Findings'),
(4057, 'Findings by specialist'),
(4058, 'Fine'),
(4059, 'Finish'),
(4060, 'Finish Payments'),
(4061, 'Finished'),
(4062, 'finished'),
(4063, 'Finished Deleting'),
(4064, 'Finnish'),
(4065, 'First'),
(4066, 'First account message'),
(4067, 'First day in the week'),
(4068, 'First day of the week'),
(4069, 'First Modern Contraception at this Clinic (with Prior Contraceptive Use)'),
(4070, 'First Modern Contraceptive Use (Lifetime)'),
(4071, 'First Name'),
(4072, 'First name'),
(4073, 'First Name:'),
(4074, 'First Visit or Consultation'),
(4075, 'First visit: No Old Records'),
(4076, 'First-time visits only'),
(4077, 'Firstname Lastname'),
(4078, 'First{{Name}}'),
(4079, 'Fitness'),
(4080, 'Fitness Level'),
(4081, 'Fitness level for this player on this day'),
(4082, 'Fitness Testing'),
(4083, 'Fitness to Play'),
(4084, 'Fix encounter dates - any encounters'),
(4085, 'Fix encounter dates - any encounters (date_a)'),
(4086, 'Fix this'),
(4087, 'Fixed'),
(4088, 'FL'),
(4089, 'Flash'),
(4090, 'Flatulence'),
(4091, 'Flow'),
(4092, 'Flow Board'),
(4093, 'Flow Board will only display completed checkouts for this many minutes. Zero is continuous display.'),
(4094, 'Flow Board: Allow Date Range'),
(4095, 'Flow Board: Default Ending Date'),
(4096, 'Flow Board: Default Starting Date'),
(4097, 'Flow Board: Disable'),
(4098, 'Flow Board: display completed checkouts (minutes)'),
(4099, 'Flow Board: Enable Random Drug Testing'),
(4100, 'Flow Board: Ending Date'),
(4101, 'Flow Board: Max tests per Patient per year'),
(4102, 'Flow Board: Percentage of Patients to Drug Test'),
(4103, 'Flow Board: Show Encounter Number'),
(4104, 'Flow Board: Show Patient ID'),
(4105, 'Flow Board: Show Staff Action'),
(4106, 'Flow Board: Show Visit Reason'),
(4107, 'Flow Board: Timer Refresh Interval'),
(4108, 'Flu season'),
(4109, 'Flu Season'),
(4110, 'Flu Vaccination'),
(4111, 'Fluid and electrolyte problem'),
(4112, 'FMS'),
(4113, 'Folio Paper Size'),
(4114, 'Follow manually'),
(4115, 'Follow these instructions for installing or upgrading the following database'),
(4116, 'Follow Up'),
(4117, 'Follow up for'),
(4118, 'Follow Up Note'),
(4119, 'Follow Up Reason'),
(4120, 'Following audit log entry number is missing'),
(4121, 'Following is a new custom constant:'),
(4122, 'Following is a new custom language:'),
(4123, 'Following is a new definition (Language, Constant, Definition):'),
(4124, 'Following rows in the audit log have been tampered'),
(4125, 'Followup Services'),
(4126, 'Followups Indicated'),
(4127, 'Font Size'),
(4128, 'Font Size in Pt'),
(4129, 'Food Intolerance'),
(4130, 'Foot'),
(4131, 'Foot Problems'),
(4132, 'Foot:'),
(4133, 'Football Injuries'),
(4134, 'Football Injury'),
(4135, 'Football Injury Report'),
(4136, 'Footwear Type'),
(4137, 'for'),
(4138, 'For'),
(4139, 'for '),
(4140, 'For a Recognized Panel of Tests'),
(4141, 'For a search to show results the codes must exist in the database.'),
(4142, 'For added ease of use the Fee Sheet needs to be customized'),
(4143, 'For an existing patient, go to Patient Summary->Documents. For a new patient, go to Miscellanous->New Documents'),
(4144, 'For code'),
(4145, 'For Custom Groups'),
(4146, 'For Dates'),
(4147, 'For detailed instructions close the \'Enter Details\' pop-up and click on the Help icon on the main form. '),
(4148, 'For detailed instructions close the \'Enter Provider Details\' popup and click on the Help icon on the main form. '),
(4149, 'For each issue type there is a list of commonly selected titles which are customizable for your clinic\'s specific needs'),
(4150, 'For ease of use it is rendered as a unique 6 digit number'),
(4151, 'For editing the values under Procedures you would need to modify'),
(4152, 'For Encounter Claims'),
(4153, 'for Encounter on'),
(4154, 'For example:'),
(4155, 'For example: Privacy_Agreement.txt becomes Privacy Agreement button in Patient Documents.'),
(4156, 'For Firefox click'),
(4157, 'For full billing functionality in the United States CPT/HCPCS codes will then need to be installed'),
(4158, 'For HCFA 02/12 Box 15 is Other Date with a qualifier to specify what the date indicates'),
(4159, 'For HCFA 02/12 Onset date specified on the Encounter Form needs a qualifier'),
(4160, 'For Identifying Code use 34392 the code used by a major lab, if using an external lab this is a vendor specific code if not you can assign any unique value'),
(4161, 'for Invoice'),
(4162, 'For manual lab entry you can give the organization any name  - e.g Local Lab and click Save'),
(4163, 'For Medicare only, forces the referring provider to be the same as the rendering provider.'),
(4164, 'For more information on Issues see the '),
(4165, 'for OBR placer order number'),
(4166, 'for patient'),
(4167, 'For procedures performed in the practice, whether it is an office based procedure or a lab or radiological procedure done in the facility, the provider can be defined as Local Lab, Office Based or have any descriptive name'),
(4168, 'For proper display of results the Identifying Codes for each test entered in the Procedure Orders module has to be unique'),
(4169, 'For proper display of results this is a required field'),
(4170, 'For proper display of the order and results the entry indicating a result has to be the immediate successor or child of an order'),
(4171, 'For proper tabulated display of tests and results an identifying code is required'),
(4172, 'For Provider'),
(4173, 'For Referred Organization/Practitioner'),
(4174, 'For the deceased notification to appear the date of death must be noted under Medical Dashboard > Edit Demographics > Misc'),
(4175, 'For the name to appear on the drop-down list it must be first entered in Administration > Address Book '),
(4176, 'For the past'),
(4177, 'For the Procedure Module to be useful several tests have to be setup using the above methods'),
(4178, 'For the Standard Code use the LOINC code 24326-1'),
(4179, 'For this name to show in the drop-down box in the Procedures > Providers setup page select only Lab Service as the Type even if it represents a Radiological facility'),
(4180, 'for this patient not yet assigned to any encounter.'),
(4181, 'For those interested details of OTP'),
(4182, 'For those interested in details of what constitutes a Continuity of Care Record (CCR) click on the eye icon'),
(4183, 'For those interested in what happens under the hood'),
(4184, 'For those lines the Description will indicate the details of the code'),
(4185, 'For those with administrative privileges an icon is displayed next to the My Messages caption'),
(4186, 'For TOTP to work a unique secret key must be shared between OpenEMR and the user'),
(4187, 'For U2F support on Linux click'),
(4188, 'for variable'),
(4189, 'for:'),
(4190, 'Force Billing Widget Open'),
(4191, 'Force Create New Patient'),
(4192, 'Force logging of all Emergency User (ie. breakglass) activities.'),
(4193, 'Force Show'),
(4194, 'Forearm'),
(4195, 'Form'),
(4196, 'form'),
(4197, 'Form element not found'),
(4198, 'Form Keys'),
(4199, 'Form signed successfully'),
(4200, 'Form validation failed. Fix any errors and resubmit.'),
(4201, 'Format'),
(4202, 'format'),
(4203, 'Format for age display'),
(4204, 'Format incorrect for NDC'),
(4205, 'Format used to display most dates.'),
(4206, 'Format used to display most times.'),
(4207, 'Formatted Report'),
(4208, 'Former smoker'),
(4209, 'Forms'),
(4210, 'Forms Administration'),
(4211, 'Forms Administration (forms)'),
(4212, 'Forms Esigned'),
(4213, 'Formularies are inserted into table'),
(4214, 'Formularies inserted into table'),
(4215, 'Forward'),
(4216, 'FORWARD A DATED REMINDER'),
(4217, 'Forward message to practice.'),
(4218, 'Forward one drawing'),
(4219, 'Forward Pages via Fax'),
(4220, 'Forward this Reminder'),
(4221, 'Forward to current canvas'),
(4222, 'Forwarded'),
(4223, 'Forwarded Portal Message Re: '),
(4224, 'Foster Child'),
(4225, 'Fourth'),
(4226, 'Fourth account message'),
(4227, 'Fracture'),
(4228, 'Fracture at the Navicula'),
(4229, 'Fracture lateral malleolus'),
(4230, 'Fracture medial malleolus'),
(4231, 'Fracture, Base of fifth (5th) Metatarsal'),
(4232, 'Frame'),
(4233, 'Frame support required'),
(4234, 'Free authenticator app'),
(4235, 'French'),
(4236, 'French (Canadian)'),
(4237, 'French (Standard)'),
(4238, 'Frequency'),
(4239, 'Frequent Colds'),
(4240, 'Frequent Illness'),
(4241, 'Fri'),
(4242, 'Friday'),
(4243, 'Friend'),
(4244, 'From'),
(4245, 'FROM'),
(4246, 'from'),
(4247, 'From Date Cannot be Greater than To Date.'),
(4248, 'From date should be less than To date'),
(4249, 'From Period'),
(4250, 'From the Issues Menu item on the Nav Bar'),
(4251, 'From the Patient dashboard via the individual Issues widgets on the right hand column'),
(4252, 'From your clinic'),
(4253, 'From:'),
(4254, 'From: '),
(4255, 'FROM_CITY'),
(4256, 'FROM_EMAIL'),
(4257, 'FROM_FNAME'),
(4258, 'FROM_LNAME'),
(4259, 'FROM_MNAME'),
(4260, 'FROM_PHONE'),
(4261, 'FROM_PHONECELL'),
(4262, 'FROM_POSTAL'),
(4263, 'FROM_STATE'),
(4264, 'FROM_STREET'),
(4265, 'FROM_TITLE'),
(4266, 'FROM_VALEDICTORY'),
(4267, 'Front Office'),
(4268, 'Front Office Receipts'),
(4269, 'Front Office Receipts Report'),
(4270, 'Front Rec'),
(4271, 'Frontal Right:'),
(4272, 'Fr{{Friday}}'),
(4273, 'FTCF{{Full to count fingers}}'),
(4274, 'FTN{{Finger Tension abbreviation}}'),
(4275, 'FT{{finger tension}}'),
(4276, 'Fula- Fulah- Pulaar- Pular'),
(4277, 'Full Logging'),
(4278, 'Full Name'),
(4279, 'Full or Initial'),
(4280, 'Full path to directory containing MySQL executables.'),
(4281, 'Full path to directory containing Perl executables.'),
(4282, 'Full path to directory for event log backup.'),
(4283, 'Full path to directory used for temporary files.'),
(4284, 'Full Play'),
(4285, 'Full Screen'),
(4286, 'Full Training'),
(4287, 'Fullscreen'),
(4288, 'Fully Paid'),
(4289, 'Functional and Cognitive Status'),
(4290, 'Functional and Cognitive Status Form'),
(4291, 'Functional Cognitive Status'),
(4292, 'Functional Condition'),
(4293, 'Funding Source'),
(4294, 'Further information regarding using the e-prescribing modules can be found by clicking this link'),
(4295, 'Future'),
(4296, 'Future Appointments'),
(4297, 'F{{Friday}}'),
(4298, 'G'),
(4299, 'G/DL'),
(4300, 'Galaxy S9/S9 Plus'),
(4301, 'Galician'),
(4302, 'Gall Bladder Condition'),
(4303, 'Gall Stones'),
(4304, 'Game Period'),
(4305, 'Games'),
(4306, 'Games Missed'),
(4307, 'games/events'),
(4308, 'Games/Events Missed'),
(4309, 'Ganda'),
(4310, 'Gastritis'),
(4311, 'Gastro Pain'),
(4312, 'Gastrointestinal'),
(4313, 'Gateway API Login Auth Name or Secret'),
(4314, 'Gateway Publishable Key'),
(4315, 'Gateway Transaction Key'),
(4316, 'GCAC Statistics Report'),
(4317, 'GCAC Stats'),
(4318, 'GCAC visit form is missing'),
(4319, 'Gender'),
(4320, 'Gender '),
(4321, 'General'),
(4322, 'General data'),
(4323, 'General Issue List'),
(4324, 'General physician'),
(4325, 'General Service Category'),
(4326, 'General Tab - lists the risk factors / past medical conditions on the left and the Results of various clinical exams, procedures and tests on the right'),
(4327, 'General Theme'),
(4328, 'General Theme (need to logout/login after change this setting)'),
(4329, 'Generally a good idea to include it'),
(4330, 'Generally, the first field in a group should be Label Cols = 1 Data Cols = number of Layout columns from Group Properties.'),
(4331, 'Generate'),
(4332, 'Generate and download CMS 1500 paper claims'),
(4333, 'Generate and download CMS 1500 paper claims on Preprinted form'),
(4334, 'Generate and download HCFA 1500 paper claims'),
(4335, 'Generate and download UB-04 CMS1450'),
(4336, 'Generate and download UB-04 CMS1450 with form'),
(4337, 'Generate and download X12 batch'),
(4338, 'Generate and download X12 encounter claim batch'),
(4339, 'Generate and transmit permissible prescriptions electronically (All Prescriptions).'),
(4340, 'Generate and transmit permissible prescriptions electronically (Not including controlled substances).'),
(4341, 'Generate and transmit permissible prescriptions electronically.'),
(4342, 'Generate CMS 1500'),
(4343, 'Generate CMS 1500 PDF'),
(4344, 'Generate CMS 1500 TEXT'),
(4345, 'Generate HCFA'),
(4346, 'Generate Institutional X12 837I'),
(4347, 'Generate Invoice'),
(4348, 'Generate Letter'),
(4349, 'Generate Letter regarding '),
(4350, 'Generate new key'),
(4351, 'Generate PQRI report (Method A)'),
(4352, 'Generate PQRI report (Method A) - 2011'),
(4353, 'Generate PQRI report (Method E)'),
(4354, 'Generate PQRI report (Method E) - 2011'),
(4355, 'Generate QRDA I – 2014'),
(4356, 'Generate QRDA III - 2014'),
(4357, 'Generate Report'),
(4358, 'Generate Report - that opens the CCD in a separate tab on the browser'),
(4359, 'Generate Report - that opens the CCR in a separate tab on the browser'),
(4360, 'Generate Report that creates a report and displays it in a separate tab on the browser '),
(4361, 'Generate safe key'),
(4362, 'Generate thumbnail'),
(4363, 'Generate thumbnail images'),
(4364, 'Generate Thumbnails'),
(4365, 'Generate Username And Password For'),
(4366, 'Generate X12'),
(4367, 'Generate X12 837I'),
(4368, 'Generate X12 Encounter'),
(4369, 'Generate/Download QRDA I - 2014'),
(4370, 'Generated on'),
(4371, 'Generated thumbnail(s)'),
(4372, 'Generates'),
(4373, 'Genericname1'),
(4374, 'Genericname2'),
(4375, 'Genericval1'),
(4376, 'Genericval2'),
(4377, 'Genitourinary'),
(4378, 'Genitourinary medicine physician'),
(4379, 'GEN{{General}}'),
(4380, 'Georgian'),
(4381, 'German'),
(4382, 'Gest age'),
(4383, 'Gestational Age'),
(4384, 'Get History'),
(4385, 'GET HL7'),
(4386, 'Get HL7'),
(4387, 'Get Started'),
(4388, 'Give a Name to this group, in our case it will be called Serum Chemistry'),
(4389, 'Give it a sequence number of 3'),
(4390, 'GI{{Gastrointestinal}}'),
(4391, 'Glare{{Acuity under Glare conditions}}'),
(4392, 'Glaucoma'),
(4393, 'Glaucoma Family History'),
(4394, 'Glaucoma Zone'),
(4395, 'Global'),
(4396, 'Global All Patients'),
(4397, 'Global Default Patient Country'),
(4398, 'Global ID'),
(4399, 'Global Settings'),
(4400, 'Globals'),
(4401, 'GM/DL'),
(4402, 'GO'),
(4403, 'Go'),
(4404, 'go'),
(4405, 'Go Back'),
(4406, 'Go back'),
(4407, 'Go to'),
(4408, 'Go to Administration > Address Book > Add New'),
(4409, 'Go to Administration > Globals > CDR > Dated reminders maximum alerts to show and change the value to a higher number'),
(4410, 'Go to Administration > Globals > Connectors'),
(4411, 'Go to Administration > Globals > Connectors and check the Enable MedEx Communication Service check box and click Save'),
(4412, 'Go to Administration > Lists, select each one of the above lists from the drop-down box and make changes as needed'),
(4413, 'Go to Administration > Lists. Select \'Fee Sheet\' from the dropdown box'),
(4414, 'Go to Adminstration > Codes. Select ICD 10 under Type, enter ICD 10 Code, enter Description, under category select an appropriate category, this ICD 10 code will then appear when the button with that category is clicked'),
(4415, 'Go to Adminstration > Lists and select \'Code Types\' from the dropdown box. Use either ICD 9 or ICD 10, inactivate ICD 9 and select \'No\' in the last dropdown box under ICD 10'),
(4416, 'Go to Procedures > Providers and click on the Add New button'),
(4417, 'Go to week of'),
(4418, 'Go Today'),
(4419, 'Goal A'),
(4420, 'Goal and Methods'),
(4421, 'Goal B'),
(4422, 'Goal C'),
(4423, 'Gonioscopy'),
(4424, 'Gonio{{Gonioscopy abbreviation}}'),
(4425, 'Google Auth'),
(4426, 'Got It'),
(4427, 'Grace Period'),
(4428, 'Grade of Injury'),
(4429, 'Grade:'),
(4430, 'grams'),
(4431, 'Grand Total'),
(4432, 'Grand Totals'),
(4433, 'Grandchild'),
(4434, 'Grandparent'),
(4435, 'Graphable'),
(4436, 'Great Grandparent'),
(4437, 'Greater Than'),
(4438, 'Greater Than or Equal To'),
(4439, 'Greek'),
(4440, 'Greek, Modern'),
(4441, 'Green lines show changes that were successfully applied.'),
(4442, 'Group'),
(4443, 'Group > Group > Procedure Order > Discrete Result'),
(4444, 'Group > Procedure Order > Discrete Result'),
(4445, 'Group appointments'),
(4446, 'Group Attendance Form'),
(4447, 'Group Attendance Statuses'),
(4448, 'Group detailed log of appointment in patient record'),
(4449, 'Group detailed log of appointment in patient record (gdlog)'),
(4450, 'Group Details'),
(4451, 'Group Encounter'),
(4452, 'Group Encounter Form'),
(4453, 'Group encounter log'),
(4454, 'Group encounter log (glog)'),
(4455, 'Group Finder'),
(4456, 'Group Home'),
(4457, 'Group Id'),
(4458, 'Group name'),
(4459, 'Group Name'),
(4460, 'Group names cannot be blank'),
(4461, 'Group names cannot start with numbers or spaces.'),
(4462, 'Group names cannot start with numbers.'),
(4463, 'Group Number'),
(4464, 'Group number'),
(4465, 'Group Payment'),
(4466, 'Group Properties'),
(4467, 'Group Search'),
(4468, 'Group Statuses'),
(4469, 'Group Type'),
(4470, 'Group\'s name'),
(4471, 'Group:'),
(4472, 'Groupname'),
(4473, 'Groups'),
(4474, 'Groups (groups)'),
(4475, 'Groups and Access Controls'),
(4476, 'Growth Chart'),
(4477, 'Growth-Chart'),
(4478, 'gtts(drops)'),
(4479, 'Guamanian'),
(4480, 'Guarani'),
(4481, 'Guaraní'),
(4482, 'Guardian'),
(4483, 'Guardian Email Address'),
(4484, 'Guardian\'s Name'),
(4485, 'Guardians Name'),
(4486, 'Guest counselors'),
(4487, 'Gujarati'),
(4488, 'GU{{Genitourinary}}'),
(4489, 'Gynecological Exam'),
(4490, 'h'),
(4491, 'H(T){{intermittent hypertropia}}'),
(4492, 'h.s.'),
(4493, 'H/O Hepatitis'),
(4494, 'had been successfully deleted. Any sub-categories if present were moved below'),
(4495, 'Haematoma / bruising'),
(4496, 'HAI Status'),
(4497, 'Haitian- Haitian Creole'),
(4498, 'Half-Sibling'),
(4499, 'Hand + fingers'),
(4500, 'Hand Problems'),
(4501, 'Handicapped dependent'),
(4502, 'Happy Birthday'),
(4503, 'Hard copy OTP'),
(4504, 'Hard copy OTP is used for online banking in some countries'),
(4505, 'Hard Disk'),
(4506, 'Hardship w/o'),
(4507, 'has been linked to visit'),
(4508, 'has expired'),
(4509, 'Hash'),
(4510, 'Hash Algorithm for Authentication'),
(4511, 'Hash did not exist for this file. A new hash was generated.'),
(4512, 'Hash does not match. Data integrity has been compromised.'),
(4513, 'Hashing algorithm for authentication. Suggest PHP Default unless you know what you are doing.'),
(4514, 'Hausa'),
(4515, 'Hawaiian'),
(4516, 'Hazardous activities'),
(4517, 'Hazardous Activities'),
(4518, 'HB{{abbreviation for Horizontal Prism Base}}'),
(4519, 'HCFA 1500 or CMS 1500 - both refer to the same form. Prior to 2001 the federal agency within the United States Department of Health and Human Services (HHS) that administers the Medicare program was called Health Care Financing Administration (HCFA) since then it is called Centers for Medicare & Medicaid Services (CMS)'),
(4520, 'HCFA FORM'),
(4521, 'HCFA left margin in points'),
(4522, 'HCFA Margins'),
(4523, 'HCFA top margin in points'),
(4524, 'HCPCS Procedure/Service'),
(4525, 'HD'),
(4526, 'HD+'),
(4527, 'he PostCalendar '),
(4528, 'Head'),
(4529, 'Head Circ'),
(4530, 'Head Circumference'),
(4531, 'Headache'),
(4532, 'Headaches'),
(4533, 'Header'),
(4534, 'health care operations'),
(4535, 'Health Care Operations'),
(4536, 'Health Care Providers'),
(4537, 'Health centre/clinic'),
(4538, 'Health Insurance Claim Form'),
(4539, 'Health Level-7 or HL7 refers to a set of international standards for transfer of clinical and administrative data between software applications used by various healthcare providers'),
(4540, 'Health Maintenance Organization'),
(4541, 'Health Maintenance Organization (HMO) Medicare Risk'),
(4542, 'Hearing Loss'),
(4543, 'Heart Attack'),
(4544, 'Heart Disease'),
(4545, 'Heart Failure'),
(4546, 'Heart Problem'),
(4547, 'Heart Problems'),
(4548, 'Heart Surgery'),
(4549, 'Heart Transplant'),
(4550, 'HEART:'),
(4551, 'Heartburn'),
(4552, 'Heat or Cold'),
(4553, 'Heat Or Cold'),
(4554, 'Heavy tobacco smoker'),
(4555, 'Hebrew'),
(4556, 'Hebrew (modern)'),
(4557, 'HEENT'),
(4558, 'Height'),
(4559, 'Height/Length'),
(4560, 'Help'),
(4561, 'help'),
(4562, 'Help content goes here'),
(4563, 'Hematemesis'),
(4564, 'Hematochezia'),
(4565, 'Hematologic'),
(4566, 'Hematuria'),
(4567, 'Hemoglobin'),
(4568, 'Hemoglobin A1C'),
(4569, 'Hemoptysis'),
(4570, 'Hepatitis'),
(4571, 'Hepatitis A 1'),
(4572, 'Hepatitis A 2'),
(4573, 'Hepatitis B 1'),
(4574, 'Hepatitis B 2'),
(4575, 'Hepatitis B 3'),
(4576, 'here'),
(4577, 'Here is what we do know.'),
(4578, 'Here you can customize the ACL further.'),
(4579, 'Herero'),
(4580, 'Hernia Repair'),
(4581, 'Herniated Disc'),
(4582, 'Herpes'),
(4583, 'Hertel Exophthalmometry'),
(4584, 'HERT{{Hertel exophthalmometry}}'),
(4585, 'Hesitancy'),
(4586, 'heyyo. you have been here for '),
(4587, 'Hib 1'),
(4588, 'Hib 2'),
(4589, 'Hib 3'),
(4590, 'Hib 4'),
(4591, 'Hidden'),
(4592, 'Hidden Events Administration'),
(4593, 'Hide'),
(4594, 'Hide Billing Widget'),
(4595, 'Hide Details'),
(4596, 'Hide Empty E-Sign Logs On Report'),
(4597, 'Hide Encryption/Decryption Options In Document Management'),
(4598, 'Hide Help Modal'),
(4599, 'Hide Menu'),
(4600, 'Hide print feature'),
(4601, 'Hide Reminders'),
(4602, 'hide this field'),
(4603, 'Hide/Show Columns'),
(4604, 'HIE'),
(4605, 'High'),
(4606, 'High (high)'),
(4607, 'High Blood Pressure'),
(4608, 'High{{Priority}}'),
(4609, 'Hindi'),
(4610, 'Hip + groin'),
(4611, 'Hip and groin'),
(4612, 'Hip Problems'),
(4613, 'Hip Replacement'),
(4614, 'Hipaa Message'),
(4615, 'HIPAA Notice Received'),
(4616, 'Hiri Motu'),
(4617, 'Hirsutism/Striae'),
(4618, 'Hispanic'),
(4619, 'Hispanic - Other (Born in US)'),
(4620, 'Hispanic - Other (Born outside US)'),
(4621, 'Hispanic or Latino'),
(4622, 'Historical information -source unspecified'),
(4623, 'History'),
(4624, 'History & Lifestyle'),
(4625, 'History - patient\'s past medical history, family history, personal history'),
(4626, 'History and Lifestyle'),
(4627, 'History and Lifestyle Help'),
(4628, 'History and Physical 2008'),
(4629, 'History Data'),
(4630, 'History Date'),
(4631, 'History Fields'),
(4632, 'History Murmur'),
(4633, 'History not authorized'),
(4634, 'History of Heart Murmur'),
(4635, 'History of Present Illness: A detailed HPI may be completed by using either four or more HPI elements OR the status of three chronic or inactive problems.'),
(4636, 'History Order'),
(4637, 'History order'),
(4638, 'Hits'),
(4639, 'HIV'),
(4640, 'Hives'),
(4641, 'HL7'),
(4642, 'HL7 - MSH-11 - Processing ID'),
(4643, 'HL7 - MSH-3.1 - Sending application'),
(4644, 'HL7 - MSH-4.1 - Sending facility'),
(4645, 'HL7 - MSH-5.1 - Receiving application'),
(4646, 'HL7 - MSH-6.1 - Receiving facility'),
(4647, 'HL7 Code'),
(4648, 'HL7 is supported by more than 1,600 members from over 50 countries, making it a widely accepted standard'),
(4649, 'HL7 Viewer'),
(4650, 'HL7-V3 Concept Code'),
(4651, 'HMOL/L'),
(4652, 'Hmong'),
(4653, 'Hold down [Ctrl] for multiple selections or to unselect'),
(4654, 'Hold down Ctrl button to select multiple issues'),
(4655, 'Hold down Ctrl to select multiple items'),
(4656, 'Hold down Ctrl to select multiple squads'),
(4657, 'Holidays management'),
(4658, 'Home'),
(4659, 'Home Phone'),
(4660, 'Home Phone Number'),
(4661, 'Homeless'),
(4662, 'Homeless or similar?'),
(4663, 'Homeless Shelter'),
(4664, 'Homeless, etc'),
(4665, 'Homeless, etc.'),
(4666, 'Hooks'),
(4667, 'Horiz Base{{abbreviation for Horizontal Prism Base}}'),
(4668, 'Horiz Prism{{abbreviation for Horizontal Prism Power}}'),
(4669, 'Horizontal Prism Base'),
(4670, 'Horizontal Prism Power'),
(4671, 'Hospice'),
(4672, 'Hospital date needed for successful billing of hospital encounters'),
(4673, 'Host'),
(4674, 'Host Name'),
(4675, 'Host Name cannot be empty'),
(4676, 'hour'),
(4677, 'Hour'),
(4678, 'Hours'),
(4679, 'hours'),
(4680, 'How bad is it? 0-10, mild, mod, severe?'),
(4681, 'How did Injury Occur?'),
(4682, 'How did Injury Occur?:'),
(4683, 'How did they hear about us'),
(4684, 'How long does it last?'),
(4685, 'How many months ahead to query for upcoming events?'),
(4686, 'How Referred'),
(4687, 'How to sort a drop-lists'),
(4688, 'How-to Build the Impression/Plan'),
(4689, 'However SMS text messages can be intercepted and the use of SMS as a method of implementing out-of-band two-factor authentication is discouraged'),
(4690, 'HPI'),
(4691, 'HPI Elements'),
(4692, 'HPI:'),
(4693, 'HP{{abbreviation for Horizontal Prism Power}}'),
(4694, 'HT'),
(4695, 'HTML'),
(4696, 'HTML Output?'),
(4697, 'HTN{{hypertension}}'),
(4698, 'Http Error'),
(4699, 'Https link for the OpenEMR Support LLC Lab Exchange Service.'),
(4700, 'HT{{hyperphoria}}'),
(4701, 'Hungarian'),
(4702, 'Hylafax Directory'),
(4703, 'Hylafax Enscript Command'),
(4704, 'Hylafax Server'),
(4705, 'Hylafax server hostname.'),
(4706, 'Hyperactive'),
(4707, 'Hyperphoria'),
(4708, 'Hypertension'),
(4709, 'Hypertension: Blood Pressure Measurement'),
(4710, 'Hypertension: Blood Pressure Measurement (CQM)'),
(4711, 'Hyperthyroidism'),
(4712, 'hypo(T){{intermittent hypotropia}}'),
(4713, 'Hypothyroidism'),
(4714, 'Hypotropia'),
(4715, 'hypoT{{hypotropia}}'),
(4716, 'Hysterectomy'),
(4717, 'I'),
(4718, 'I am busy during this time.'),
(4719, 'I do not have permission to read '),
(4720, 'I have read and accept the'),
(4721, 'I have read and my practice agrees to the'),
(4722, 'I know but we need it!'),
(4723, 'IBAN'),
(4724, 'ICD'),
(4725, 'ICD10 Diagnosis'),
(4726, 'ICD10 Procedure/Service'),
(4727, 'ICD9'),
(4728, 'ICD9 Diagnosis'),
(4729, 'ICD9 Procedure/Service'),
(4730, 'Icelandic'),
(4731, 'icon'),
(4732, 'Icon Legend'),
(4733, 'Icons'),
(4734, 'ID'),
(4735, 'id'),
(4736, 'Id'),
(4737, 'ID - select a unique three letter id, all in lower case'),
(4738, 'ID cannot be blank'),
(4739, 'ID Card'),
(4740, 'ID Card/Photos - will display any ID Card or patient photo that has been uploaded to Documents > Patient Information > Patient ID Card and Patient Photograph folders'),
(4741, 'ID Number (ETIN)'),
(4742, 'IDays'),
(4743, 'identified as'),
(4744, 'Identifier'),
(4745, 'Identifier(one word)'),
(4746, 'Identifying Code'),
(4747, 'Idle Session Timeout Seconds'),
(4748, 'Ido'),
(4749, 'if'),
(4750, 'If a field\'s Data Col = 0 the data field will immediately follow its label field on the same line'),
(4751, 'If a field\'s Label Col = 0 the label will immediately follow the previous data field in the Order sequence, on the same line as the Data field.'),
(4752, 'If a field\'s Label Col = 1 the label field will go to a new line unless the previous field\'s total column values (Label + Data) is less than number of Layout columns from Group Properties or Layout Properties.'),
(4753, 'If a product is sold then change the default to reflect required number. Leave it at one for procedures'),
(4754, 'If a wrong code was selected click on the Coding text-box to to bring up the Select Codes pop-up page'),
(4755, 'If all data for all columns are complete for this form'),
(4756, 'If all the details were entered correctly you will see Blood Glucose in the Name column with a vertical bar before it indicating that it has no descendants or children, Result in the Category column, WWT01R in the Code column, the Tier column value should be 3 and the Description column should say Fasting Glucose result'),
(4757, 'If billing justification is used enter the name of the diagnosis code type.'),
(4758, 'If configured correctly the Name column should say Blood Glucose with a vertical bar before it indicating no descendants or children, the Category column should say Custom Order and both Name and Category columns will be highlighted in pink indicating a custom grouped order'),
(4759, 'If desired the current message can be printed'),
(4760, 'If enabled, this will send the execution time it took to verify hash to the php error log.'),
(4761, 'If enabled, use LDAP for login and authentication.'),
(4762, 'If enabled, uses the specified active directory for login and authentication.'),
(4763, 'if entered, select only those who have had this service'),
(4764, 'If it it still active i.e. End Date is not entered it will be displayed in red, if the problem has an end Date then it will be displayed in black'),
(4765, 'If name, any part of lastname or lastname,firstname'),
(4766, 'If NewCrop eRx - the electronic prescription module, is enabled the NewCrop MedEntry and NewCrop Account Status buttons will be appear here'),
(4767, 'If not listed you can add the drug to the Title text-box'),
(4768, 'If only capture the QR code but do not register the TOTP key with OpenEMR this feature will not be enabled at login'),
(4769, 'If patient has appointment click OK to create encounter otherwise, cancel this and then create an encounter for today visit.'),
(4770, 'If paying by'),
(4771, 'If person is deceased, then enter date of death.'),
(4772, 'If phone is lost will not be able to login'),
(4773, 'If privileges have to be modified then it can be done either one user at a time at Administration > Users or more conveniently on this page i.e. Administration > ACL where all users are listed on one page and more options are available.'),
(4774, 'If set as high will restrict visibility of encounter to users belonging to certain groups (AROs). By default - Physicians and Administrators'),
(4775, 'If SMTP is used, the server`s hostname or IP address.'),
(4776, 'If SMTP is used, the server`s TCP port number (usually 25).'),
(4777, 'If so desired the default board can be disabled by going to Administration > Calendar > Recall Board: Disable and checking the checkbox and click Save'),
(4778, 'If so you will have to create individual Procedure Orders (the orders) for these tests along with Discrete Results (the place to enter and display the returned result)'),
(4779, 'If successful it authenticates the user'),
(4780, 'If the checkbox is checked and the message is sent to multiple users then each user has to sign off on the message by clicking the Set As Completed Button for that message'),
(4781, 'If the checkbox is checked then each individual of a group receiving this message will have to sign off by clicking the Set As Completed button'),
(4782, 'If the csv file has been uploaded, then click on the \"Import holiday events\" button. NOTE that clicking on the button will remove all the existing rows in the calendar_external table'),
(4783, 'If the desired title is not included, it can be typed into the text box below the list'),
(4784, 'If the displayed table says No matching record found it means that the ICD10 code set is not installed'),
(4785, 'If the help file does not exist create one and place it in'),
(4786, 'If the issue has not been linked to an encounter it will display 0'),
(4787, 'If the medical problem is not listed in the drop-down box click on Coding text-box to bring up the Select Codes pop-up page'),
(4788, 'If the message is forwarded it will show up in the active messages list of the user to whom the message was forwarded and disappear from the current user\'s active messages list'),
(4789, 'If the Offsite Patient portal is enabled there will be either a button that says Create Offsite Portal Credentials provided the patient has given permission to access the online patient portal or a message that says Patient has not authorized the Patient Portal'),
(4790, 'If the Online Patient portal is enabled there will be either a button that says Create Online Portal Credentials provided the patient has given permission to access the online patient portal or a message that says Patient has not authorized the Patient Portal'),
(4791, 'If the Online/Offsite Portal Credentials has already been set the button will change to'),
(4792, 'If the patient has any demographic data entered in openEMR it will automatically populate the relevant fields on the right sections'),
(4793, 'If the patient has not authorized patient portal then a Patient has not authorized the Patient Portal message will be shown here'),
(4794, 'If the patient is being added to the recall list on the day of the visit it would reflect the current date'),
(4795, 'If the patient is calling back to be added to the list the last visit may be in the remote past. Be aware that the 1,2,3 plus years are calculated and displayed on the Date box at the bottom of this section'),
(4796, 'If the patient is deceased then the deceased notification will appear in red in this section'),
(4797, 'If the report is sent electronically all steps needed for safe and secure transmission of Protected Health Information (PHI) must be followed'),
(4798, 'If there is no vendor enter any arbitrary unique number, preferably a 5 digit zero-padded e.g. 00211'),
(4799, 'If these tests are being sent to the same external lab they will have identical vendor specific Identifying Codes causing duplicate lines to appear when results are displayed'),
(4800, 'If they have been configured correctly each result should have a Tier value of 4, indicating they are the successor or child to the first line above with a Tier value of 3, i.e Electrolyte Panel'),
(4801, 'If this page does not refresh, reload the Messages page manually'),
(4802, 'If unassigned will default to php.ini setting for date.timezone.'),
(4803, 'if unemployed enter Student'),
(4804, 'If value is left as zero, will be sorted alphabetically'),
(4805, 'If YMD is selected for age display, switch to just Years when patients older than this value in years'),
(4806, 'If you are having troubles logging into your account.'),
(4807, 'If you are interested in what happens under the hood'),
(4808, 'If you are only using a small subset of the CPT codes you can manually enter it in Administration > Codes'),
(4809, 'If you are planning on entering different prices for different modalities of payment go to Administration > Lists'),
(4810, 'If you are unsure or were using a development version between two releases, then choose the older of possible releases'),
(4811, 'If you are upgrading from a version below 5.0.0 to version 5.0.0 or greater, do note that this upgrade can take anywhere from several minutes to several hours (you will only see a whitescreen until it is complete; do not stop the script before it is complete or you risk corrupting your data)'),
(4812, 'If you are using Electronic lab entry then fill in the required details and click Save'),
(4813, 'If you are using multiple labs enter the details for each one of them'),
(4814, 'If you change e-RX Role for ePrescription, it may affect the ePrescription workflow. If you face any difficulty, contact your ePrescription vendor.'),
(4815, 'If you change your Smartphone you can recapture the TOTP key QR code on to a new device by first logging in using the authenticator app on your old phone and then going to Miscellaneous > MFA Authentication and clicking the View button on the Current Authentication Method section'),
(4816, 'If you check the check box in any of these cells it will generate an entry in the last cell called Progress'),
(4817, 'If you choose to do a manual entry click the \'Invoice Search\' radio button. It displays two sections \'Post Item\' and \'Invoice Search\''),
(4818, 'If you choose to integrate lab results with the patient\'s record then some preliminary setup has to be performed'),
(4819, 'If you click on any user in the \'User Memberships\' section you will now see these newly created group (ARO) in the \'Inactive\' column. These can now be assigned in the usual fashion as needed.'),
(4820, 'If you click on the edit icon next to this newly created group (ARO) you will note that the \'Active\' column contains only a single entry - Placeholder (Maintains empty ACLs). As yet this new group (ARO) has NO access to any part of the program as there are no ACOs assigned in the \'Active\' column.'),
(4821, 'If you Click the blue + sign on Serum Chemistry you will see a new line called Organ/Disease Panel with a Category of Sub Group'),
(4822, 'If you continue to experience this error please contact support.'),
(4823, 'If you do not find a required value in the drop-down box you will need to add it via Administration > Lists > Procedure Units. Refer to the help file in Procedures > Providers'),
(4824, 'If you do not select a match the patient will be created.'),
(4825, 'If you do not select at least one of these, OpenEMR will operate in a receive-only mode'),
(4826, 'If you do not submit orders electronically or receive result electronically leave it as the default value, Download'),
(4827, 'If you do not want to do so the following method involves adding data manually using the openEMR interface'),
(4828, 'If you drill down to the Electrolyte Panel line and click on the + sign in the Name column you should see Sodium listed underneath it with a Category value of Result with a Tier value of 4'),
(4829, 'If you drill down to the Electrolyte Panel line you should see it have a Category of Order and be highlighted in yellow indicating that it is a search-able and valid order and has a Tier value of 3'),
(4830, 'If you had selected multiple codes they will be separated by semi-colons'),
(4831, 'If you have already filled the calendar_external table, then click on \"Synchronize\" button to have the holidays in the calendar view. NOTE that clicking on the button will remove all the existing items in the calendar view related to holidays'),
(4832, 'If you have an old superbill you can use its grouping of codes as a template to start the customization'),
(4833, 'If you have chosen to upload electronic remittances, then the search window redisplays itself with the matching invoices from the X12 file.  You may click on any of these invoice numbers (as described below) if you wish to make any corrections before the remittance information is applied. To apply the changes, click the Process ERA File button at the bottom of the page.  This will produce a new window with a detailed report.'),
(4834, 'If you have chosen to upload electronic remittances, then the search window redisplays itself with the matching invoices from the X12 file. You may click on any of these invoice numbers (as described above) if you wish to make any corrections before the remittance information is applied. To apply the changes, click the \'Process ERA File\' button at the bottom of the page. This will produce a new window with a detailed report.'),
(4835, 'If you have enabled the TOTP method the next time you login you will be asked to enter the TOTP password'),
(4836, 'If you have entered a Pay Date in the search page, this will override the posting date of payments and adjustments that are otherwise taken from the X12 file.  This may be useful for reporting purposes, if you want your receipts reporting to use your posting date rather than the insurance company\'s processing date.  Note that this will also affect dates of prior payments and adjustments that are put into secondary claims.'),
(4837, 'If you have entered a Pay Date in the search page, this will override the posting date of payments and adjustments that are otherwise taken from the X12 file. This may be useful for reporting purposes, if you want your receipts reporting to use your posting date rather than the insurance company\'s processing date. Note that this will also affect dates of prior payments and adjustments that are put into secondary claims.'),
(4838, 'If you have followed all the above steps correctly you should see Serum Uric Acid under Name, it will be preceded by a vertical bar indicating the absence of descendants or children to this entry'),
(4839, 'If you have followed the above steps correctly the Serum Uric Acid Test should now have a + sign preceding the Name indicating the presence of successors or children'),
(4840, 'If you have lost your Smartphone those with administrator privileges can delete the keys by going to Administration > Users and checking the Clear 2FA checkbox and clicking Save'),
(4841, 'If you have NewCrop eRx module enabled then the allergies have to be entered on the NewCrop MedEntry page'),
(4842, 'If you have not already done some pre-configuration, including adding providers, do so by going to Procedures > Providers'),
(4843, 'If you have the need to order individual components of the panel you will have to create a separate Procedure Order for each individual component of the panel and store the returned result under a Discrete Result created in a fashion similar to that used earlier to create an order for Serum Uric Acid'),
(4844, 'If you hit the refresh button without setting any filters then all dated reminders for the user will appear below'),
(4845, 'If you leave it at the default of 0 then the top level entries that you make will be sorted alphabetically'),
(4846, 'If you made changes and want to re-send it, delete the original (in Communications) and try again.'),
(4847, 'If you made changes and want to re-send it, delete the original (in Communications) or wait 60 seconds, and try again.'),
(4848, 'If you need to manually enter the returned result each test (Custom Favorite Item) should have a Discrete Result as a direct descendant'),
(4849, 'If you see no entries in the Order From drop-down box it means that you have not set up a lab under Procedures > Providers'),
(4850, 'If you want to change data types, or add rows or columns'),
(4851, 'If you want to upgrade the database, then place the database zip file in the following directory'),
(4852, 'If your search was successful the search results will be displayed in the search results box below'),
(4853, 'Igbo'),
(4854, 'Ignore'),
(4855, 'IIS Code'),
(4856, 'Illness'),
(4857, 'IM'),
(4858, 'Image canvas'),
(4859, 'Image Results'),
(4860, 'Images'),
(4861, 'Imaging'),
(4862, 'Imaging Integration, and DICOM Diagnostic Imaging Reports - 2009'),
(4863, 'Imaging Service'),
(4864, 'Immune System'),
(4865, 'Immunization'),
(4866, 'Immunization Administered Site'),
(4867, 'Immunization Code'),
(4868, 'Immunization Completion Status'),
(4869, 'Immunization Date'),
(4870, 'Immunization Expiration Date'),
(4871, 'Immunization Information Source'),
(4872, 'Immunization Lot Number'),
(4873, 'Immunization Manufacturer'),
(4874, 'Immunization Observation Criteria'),
(4875, 'Immunization Observation Results'),
(4876, 'Immunization Ordering Provider'),
(4877, 'Immunization Refusal Reason'),
(4878, 'Immunization Registry'),
(4879, 'Immunization Registry Status'),
(4880, 'Immunization Registry Status Effective Date'),
(4881, 'Immunization Report'),
(4882, 'Immunization Service'),
(4883, 'Immunization Title'),
(4884, 'Immunization Vaccine Eligibility Results'),
(4885, 'Immunizations'),
(4886, 'Immunizations - lists immunization history and allows for adding new entries or editing existing ones'),
(4887, 'Immunize'),
(4888, 'Immunologic'),
(4889, 'Immuno{{immunologic}}'),
(4890, 'IMMUNO{{Immunology/Rheumatology}}'),
(4891, 'Imp'),
(4892, 'Imp Plan'),
(4893, 'Implants'),
(4894, 'Import'),
(4895, 'Import All'),
(4896, 'Import CCDA'),
(4897, 'Import CCR'),
(4898, 'Import certificate to the browser.'),
(4899, 'Import Configuration'),
(4900, 'Import deferred for time-to-live'),
(4901, 'Import Formularies'),
(4902, 'Import holiday events'),
(4903, 'Import Holidays'),
(4904, 'Import Patient'),
(4905, 'Import Patient Demographics'),
(4906, 'Import Patient Demographics XML'),
(4907, 'Import Pharmacies'),
(4908, 'Import Pharmacies Script'),
(4909, 'Important - the Identifying Code for Custom Favorite Group is always user defined'),
(4910, 'Important Codes'),
(4911, 'IMPORTANT: The NPI number also exists in the Address Book entry for the provider, take care to enter the correct NPI number'),
(4912, 'IMPORTANT: This upload tool is only for uploading documents on patients that are not yet entered into the system. To upload files for patients whom already have been entered into the system, please use the upload tool linked within the Patient Summary screen.'),
(4913, 'Imported Allergies'),
(4914, 'Imported from Accounting'),
(4915, 'Imported Medications'),
(4916, 'Imported Problems'),
(4917, 'Importing the entire CPT code set after you license it from the American Medical Association would get you all the relevant CPT codes in one fell swoop'),
(4918, 'Impression/Plan'),
(4919, 'Impression/Plan Builder'),
(4920, 'Improved'),
(4921, 'IMP{{impression}}'),
(4922, 'in'),
(4923, 'IN'),
(4924, 'In a likewise fashion you will create a Discrete Result for Potassium, Chloride and Carbon Dioxide'),
(4925, 'In a likewise manner create a Custom Favorite Item each for TSH (Sequence 2, Identifying Code WWT02, Standard Code 30166-3) and Vitamin D (Sequence 3, Identifying Code WWT03, Standard Code 35365-6)'),
(4926, 'In a likewise manner create a Discrete Result each for TSH (Sequence - 2, Identifying Code - WWT02R, Default Units - mU/L, Default Range - 0.4-4, leave Followup Services blank) and Vitamin D (Sequence - 3, Identifying Code - WWT03R, Default Units - ng/mL, Default Range - 0-20, leave Followup Services blank)'),
(4927, 'In addition there are 2 checkboxes'),
(4928, 'In addition to creating a Referral the system also allows you to print a blank referral form that can be manually filled to generate a Referral'),
(4929, 'In any case establishing a connection, ensuring HIPAA compliance, data security etc will require coding, the cost of which is generally borne by the lab. They however will only approve if the volume of business justifies their investment'),
(4930, 'In Current Chat'),
(4931, 'in each eye'),
(4932, 'In exam room'),
(4933, 'In House'),
(4934, 'in left eye'),
(4935, 'in nostril'),
(4936, 'In Office'),
(4937, 'In openEMR the Continuity of Care Record (CCR) reports to be generated can be limited to a specific date range by checking the Use Date Range check-box and entering the desired date range'),
(4938, 'In order to fulfill Meaningful Use requirements for Computerized Provider Order Entry (CPOE) for lab and radiology tests this module needs to be used'),
(4939, 'In order to properly store and retrieve test results and place new orders, tests/orders have to be setup in a hierarchical manner'),
(4940, 'In order to record the values of the results returned you have to create a separate Discrete Result (Tier 4) for each of the panel\'s constituents, the fruit, as direct descendants of this (General Health Panel) branch (Tier 3). Examples of the results being CBC - Hemoglobin, CBC - Hematocrit, CMP - Sodium, CMP - Potassium, TSH etc. '),
(4941, 'In order to register your device, please provide your OpenEMR login password'),
(4942, 'In order to send Continuity of Care Record (CCR) and /or Continuity of Care Document (CCD) optionally check phiMail Allow CCD Send and/or phiMail Allow CCR Send to enable the Transmit feature for these data types'),
(4943, 'In our case we will choose Local Lab that was setup previously'),
(4944, 'In our case we will leave it as Unassigned'),
(4945, 'In Portrait mode, determines the height of the envelope along the y-axis in mm'),
(4946, 'In Portrait mode, determines the width of the envelope along the x-axis in mm'),
(4947, 'in right eye'),
(4948, 'In short electronic orders can be done, it involves a significant amount of testing and customization to be certified by the lab, generally through a third party and can only happen if the lab agrees to give the green light to the project'),
(4949, 'In the \'Post Item\' section that is displayed at the top you may enter a source (e.g. check number), pay date and check amount. The reason for the source and pay date is so that you don\'t have to enter them over and over again for each claim. The amount that you enter will be decreased for each invoice that is given part of the payment, and hopefully will end at zero when you are done.'),
(4950, 'In the above example an order for a single test was created, i.e. Serum Uric Acid'),
(4951, 'In the default installation click on Add to bring up the Add/Edit Issue pop-up page'),
(4952, 'In the patient\'s words'),
(4953, 'In the second stage of Meaningful Use, the CCD, but not the CCR, was included as part of the standard for clinical document exchange'),
(4954, 'In this case the Custom Favorite Group will be called Preop Labs and the two recognized panels will be direct descendants, each in a Custom Favorite Item Tier named CBC and Renal Panel respectively'),
(4955, 'In this case you will create a Procedure Order, the fruit bearing branch called General Health Panel (Tier 3)'),
(4956, 'In total, there are seventeen sections that can be included within a Continuity of Care Record (CCR)'),
(4957, 'In Use'),
(4958, 'in-house'),
(4959, 'In-process'),
(4960, 'Inactive'),
(4961, 'Inactive - Lost to follow - up'),
(4962, 'Inactive - Moved or gone elsewhere'),
(4963, 'Inactive - Permanently inactive'),
(4964, 'Inactive - Unspecified'),
(4965, 'Inactive Days'),
(4966, 'Inactive Messages'),
(4967, 'Inbox'),
(4968, 'INCITS Code'),
(4969, 'Include all values reported for each result code'),
(4970, 'Include Checksum'),
(4971, 'Include Completed'),
(4972, 'Include inactive'),
(4973, 'Include Inactive'),
(4974, 'Include inactive users'),
(4975, 'Include Uncategorized'),
(4976, 'Include Unstructured data'),
(4977, 'Include Vitals'),
(4978, 'Include vitals data?'),
(4979, 'Included Providers'),
(4980, 'including CVF{{Confrontational Visual Fields}} and Pupils'),
(4981, 'Inclusion'),
(4982, 'Income'),
(4983, 'Incoming results requiring attention:'),
(4984, 'Incomplete'),
(4985, 'Incomplete Abortion Treatment'),
(4986, 'Incontinence'),
(4987, 'Incorporate clinical lab-test results into certified EHR technology as structured data.'),
(4988, 'Incorrect password!'),
(4989, 'Increase the limit to a larger number say 100 so that you can decide on which ones to act upon'),
(4990, 'increased:'),
(4991, 'Indemnity Insurance'),
(4992, 'Independent Clinic'),
(4993, 'Independent Laboratory'),
(4994, 'Indeterminate'),
(4995, 'Indian'),
(4996, 'Indian Health Service Free-standing Facility'),
(4997, 'Indian Health Service Provider-based Facility'),
(4998, 'Indicates abnormality'),
(4999, 'Indicates if this issue is an ophthalmic-specific medication'),
(5000, 'Indicates if this issue is currently active'),
(5001, 'Indications'),
(5002, 'Indicator for specialized usage'),
(5003, 'Indigent Patients'),
(5004, 'Indigent Patients Report'),
(5005, 'Indigents'),
(5006, 'Individual access can be tailored to fit the needs by assigning a user to one or more groups (AROs). The user will then inherit all the privileges, i.e have access to parts of the program (ACO), of each group (ARO) the user belongs to.'),
(5007, 'Individual pages can override 2nd and 3rd options by implementing a log message.'),
(5008, 'Individual tests or even individual recognized panel of tests can be grouped together as a Custom Favorite Group'),
(5009, 'Indonesian'),
(5010, 'Induced Abortion'),
(5011, 'Industry'),
(5012, 'Ineligible'),
(5013, 'Infection / Abscess'),
(5014, 'Infections'),
(5015, 'Infert Couns'),
(5016, 'Infertility'),
(5017, 'Influenza 1'),
(5018, 'Influenza 2'),
(5019, 'Influenza Immunization for Patients >= 50 Years Old'),
(5020, 'Influenza Immunization for Patients >= 50 Years Old (CQM)'),
(5021, 'Influenza Vaccine'),
(5022, 'Info'),
(5023, 'Info test 1'),
(5024, 'Info test 2'),
(5025, 'Info test 3'),
(5026, 'Info test 4'),
(5027, 'Info test 5'),
(5028, 'Info test 6'),
(5029, 'Informant'),
(5030, 'Information'),
(5031, 'Information regarding the Patient Portal is also shown in the header section'),
(5032, 'Information Source'),
(5033, 'inf{{inferior}}'),
(5034, 'inhalations'),
(5035, 'Inhale'),
(5036, 'inhilations'),
(5037, 'Initial Patient Population'),
(5038, 'Initial Treatment'),
(5039, 'Initial User'),
(5040, 'Initially Open Group'),
(5041, 'Inj/Rehab'),
(5042, 'Injectables'),
(5043, 'Injection'),
(5044, 'Injured Body Part'),
(5045, 'Injured Out'),
(5046, 'Injury'),
(5047, 'Injury Mechanism'),
(5048, 'Injury Overview Report'),
(5049, 'Injury Surveillance'),
(5050, 'Injury Type'),
(5051, 'Injury/illness-related'),
(5052, 'Inline'),
(5053, 'Inpatient Hospital'),
(5054, 'Inpatient Psychiatric Facility'),
(5055, 'Input does not begin with a MSH segment'),
(5056, 'Input Fields'),
(5057, 'INR'),
(5058, 'Ins 1'),
(5059, 'Ins 2 or Ins 3'),
(5060, 'Ins Address'),
(5061, 'Ins adjust'),
(5062, 'Ins bundling'),
(5063, 'Ins Code'),
(5064, 'Ins Group'),
(5065, 'Ins Name'),
(5066, 'Ins overpaid'),
(5067, 'Ins Policy'),
(5068, 'Ins refund'),
(5069, 'Ins Summary'),
(5070, 'Ins/fin issue'),
(5071, 'Ins1'),
(5072, 'Ins2'),
(5073, 'Ins3'),
(5074, 'Insert'),
(5075, 'Insert failed: '),
(5076, 'Insert normals'),
(5077, 'Insert normals - 100/100'),
(5078, 'Insert normals - 11/11'),
(5079, 'Insert old events into tables'),
(5080, 'Insert special field'),
(5081, 'Insert the key into the USB port'),
(5082, 'Insert U2F Key'),
(5083, 'Insert your key into a USB port and click the Authenticate button below.'),
(5084, 'Inserted'),
(5085, 'Insomnia'),
(5086, 'Inspect the log'),
(5087, 'Inspection'),
(5088, 'Instability / subluxation'),
(5089, 'INSTALL'),
(5090, 'Install'),
(5091, 'Install ACL'),
(5092, 'Install Code Set'),
(5093, 'install DB'),
(5094, 'Install it by going to Administration > Other > External Data Loads > ICD10 > Staged Releases and click Install'),
(5095, 'Install Layout Service Codes'),
(5096, 'Install SQL'),
(5097, 'Install the EMR Direct trust anchor certificate'),
(5098, 'Installation Details'),
(5099, 'Installations processing a large number of Direct messages may want a shorter interval'),
(5100, 'Installed Release'),
(5101, 'Installing codes in openEMR'),
(5102, 'Instructed'),
(5103, 'Instruction'),
(5104, 'Instructions'),
(5105, 'Instructions:'),
(5106, 'Insufficient inventory for product'),
(5107, 'Insufficient inventory for product ID'),
(5108, 'Insulin Dependent Diabetes'),
(5109, 'Insurance'),
(5110, 'insurance'),
(5111, 'Insurance Address'),
(5112, 'Insurance Adj'),
(5113, 'Insurance Adjustment'),
(5114, 'Insurance Balance'),
(5115, 'Insurance Balance Due'),
(5116, 'Insurance Comp'),
(5117, 'Insurance Companies'),
(5118, 'Insurance Company'),
(5119, 'Insurance Company Search/Add'),
(5120, 'Insurance Credit'),
(5121, 'Insurance Data'),
(5122, 'Insurance ID'),
(5123, 'Insurance Information'),
(5124, 'Insurance information on file'),
(5125, 'Insurance Name'),
(5126, 'Insurance Numbers'),
(5127, 'Insurance Payment'),
(5128, 'Insurance Payments'),
(5129, 'Insurance Provider'),
(5130, 'Insurance Search/Select/Add'),
(5131, 'Insurance Types'),
(5132, 'Insurances'),
(5133, 'Insured'),
(5134, 'Intake Conclusion'),
(5135, 'Intake Date'),
(5136, 'Integers1-100'),
(5137, 'Integrating lab results into a patient\'s chart in openEMR can be done manually i.e. both ordering tests and uploading the received results or electronically'),
(5138, 'Intellectual Decline'),
(5139, 'Inter-pupillary distance'),
(5140, 'Interact with created transactions'),
(5141, 'Interlingua'),
(5142, 'Interlingue'),
(5143, 'Intermediate Care Facility/Mentally Retarded'),
(5144, 'Intermittent Esotropia'),
(5145, 'Intermittent Exotropia'),
(5146, 'intermittent hyperphoria'),
(5147, 'Intermittent hypotropia'),
(5148, 'Internal Allergies'),
(5149, 'Internal error - no pages were selected!'),
(5150, 'Internal error - patient ID was not provided!'),
(5151, 'Internal error accessing uploaded file!'),
(5152, 'Internal error in tableNameFromLayout'),
(5153, 'Internal error!'),
(5154, 'Internal error, no drug ID specified!'),
(5155, 'Internal error: Cannot find MSH-10'),
(5156, 'Internal error: claim '),
(5157, 'Internal error: encounter \''),
(5158, 'Internal error: pid or encounter is missing.'),
(5159, 'Internal error: we do not seem to be in an encounter!'),
(5160, 'Internal Identifier (pid)'),
(5161, 'Internal Medications'),
(5162, 'Internal Problems'),
(5163, 'Internal Referrals'),
(5164, 'Internal Time Collected'),
(5165, 'International Duty'),
(5166, 'Internet Explorer browser version 6 to Internet Explorer browser version 11 does not support FIDO U2F API'),
(5167, 'Interpreter'),
(5168, 'Interpreter needed?'),
(5169, 'Interstitial Lung Disease'),
(5170, 'Interval'),
(5171, 'Interval (minutes)'),
(5172, 'Interval between message checks (set to zero for manual checks only)'),
(5173, 'Intervention'),
(5174, 'Intervention Provided'),
(5175, 'Intolerance'),
(5176, 'Intradermal'),
(5177, 'Intramuscular'),
(5178, 'intramuscularly'),
(5179, 'Intraocular Pressures'),
(5180, 'Intraocular Pressures (mmHg) by Date'),
(5181, 'intravenously'),
(5182, 'Introduction'),
(5183, 'Inuktitut'),
(5184, 'Inupiaq'),
(5185, 'Invalid character in'),
(5186, 'Invalid Content'),
(5187, 'Invalid Credit Card Number'),
(5188, 'Invalid Credit Card Values: Please correct'),
(5189, 'Invalid Current Credentials Error.'),
(5190, 'Invalid Date format or value! Type date as YYYY-MM-DD or use the calendar.'),
(5191, 'Invalid date range'),
(5192, 'Invalid encapsulated data encoding type'),
(5193, 'Invalid File'),
(5194, 'Invalid layout ID'),
(5195, 'Invalid length for'),
(5196, 'Invalid non-numeric character in'),
(5197, 'Invalid or missing payer in source for code '),
(5198, 'Invalid password'),
(5199, 'Invalid recipient address. Please try again.'),
(5200, 'Invalid Service Codes'),
(5201, 'Invalid source designation \"'),
(5202, 'Invalid Total!'),
(5203, 'Invalid username or password'),
(5204, 'InvAmt'),
(5205, 'Inventory'),
(5206, 'Inventory Activity'),
(5207, 'Inventory and sell both drugs and non-drug products'),
(5208, 'Inventory and sell drugs only'),
(5209, 'Inventory is not available for this order.'),
(5210, 'Inventory List'),
(5211, 'Inventory Transactions'),
(5212, 'Invoice'),
(5213, 'invoice'),
(5214, 'Invoice Actions'),
(5215, 'Invoice Balance'),
(5216, 'Invoice Balance cannot be posted. No Encounter is created.'),
(5217, 'Invoice Date'),
(5218, 'Invoice Details'),
(5219, 'Invoice has no date!'),
(5220, 'Invoice Number'),
(5221, 'Invoice Reference Number'),
(5222, 'Invoice reference number pool, if used'),
(5223, 'Invoice Reference Number Pools'),
(5224, 'Invoice Refno Pool'),
(5225, 'Invoice Search'),
(5226, 'Invoice:'),
(5227, 'IOP Chart'),
(5228, 'IOP Dilated{{Dilated Intraocular Pressure}}'),
(5229, 'IOP Graph'),
(5230, 'ios'),
(5231, 'iPad Pro 10.5 inches'),
(5232, 'iPad Pro 12.5 inches'),
(5233, 'iPad/iPad Mini, XGA'),
(5234, 'iPhone 6/7/8 Plus'),
(5235, 'iPhone X/XS'),
(5236, 'iPhone XR/XS Max'),
(5237, 'IPPF'),
(5238, 'IPPF Abortion'),
(5239, 'IPPF Contraception'),
(5240, 'IPPF SRH Data for'),
(5241, 'IPPF Statistics Report'),
(5242, 'IPPF Stats'),
(5243, 'IPV 1'),
(5244, 'IPV 2'),
(5245, 'IPV 3'),
(5246, 'IPV 4'),
(5247, 'Iris'),
(5248, 'Irish'),
(5249, 'Irregular Heart Beat'),
(5250, 'Irritability'),
(5251, 'Irritation'),
(5252, 'is a different language version of the following database'),
(5253, 'is a different version of the following database'),
(5254, 'is a more recent version of the following database'),
(5255, 'Is a record of all financial transactions between the patient and the practice'),
(5256, 'is a required field.'),
(5257, 'is a root node and can not be deleted.'),
(5258, 'is an extension of the following database'),
(5259, 'Is Authorizing Signature'),
(5260, 'Is Confidential'),
(5261, 'Is Enabled'),
(5262, 'Is it ok to map these CVX codes to already existent immunizations?'),
(5263, 'is misplaced or unknown'),
(5264, 'is not a number'),
(5265, 'is not a valid email address'),
(5266, 'Is not selected'),
(5267, 'is not valid'),
(5268, 'is not valid (decimal fractions are OK).'),
(5269, 'Is PHP using Safe Mode?'),
(5270, 'Is Required. Contact Provider.'),
(5271, 'Is Required. Please Add in Contacts.'),
(5272, 'Is selected'),
(5273, 'Is text from form layouts to be translated?'),
(5274, 'Is text from lists to be translated?'),
(5275, 'Is The File Encrypted?'),
(5276, 'Is this a Clinical Term code type?'),
(5277, 'Is this a diagnosis type?'),
(5278, 'Is this a Medical Problem code type?'),
(5279, 'Is this a Medication type?'),
(5280, 'Is this a procedure/service type?'),
(5281, 'Is this active?'),
(5282, 'Is this code type active?'),
(5283, 'Is this code type used in claims?'),
(5284, 'Is this Okay?'),
(5285, 'Is this really OK?'),
(5286, 'Is this type hidden in the fee sheet?'),
(5287, 'Is this using external sql tables? If it is, then choose the format.'),
(5288, 'is too long'),
(5289, 'ISO 639-2 Code'),
(5290, 'Issue'),
(5291, 'issue'),
(5292, 'Issue Date'),
(5293, 'Issue ID'),
(5294, 'Issue Subtypes'),
(5295, 'Issue Title'),
(5296, 'Issue Type'),
(5297, 'Issue Types'),
(5298, 'Issues'),
(5299, 'Issues (Injuries/Medical/Allergy)'),
(5300, 'Issues (Injuries/Medical/Allergy):'),
(5301, 'Issues - summarizes the patient\'s medical problems, allergies, medications, surgeries and dental issues'),
(5302, 'Issues and Encounters'),
(5303, 'Issues and Encounters for'),
(5304, 'Issues and Immunizations wiki page'),
(5305, 'Issues can also be linked to zero or more encounters'),
(5306, 'Issues Help'),
(5307, 'Issues List'),
(5308, 'Issues not authorized'),
(5309, 'Issues Section'),
(5310, 'It allows the browser to communicate directly to the USB device avoiding the need for the user to do anything more than insert the device into an USB port and tap it to activate it'),
(5311, 'It also lets you create new groups (AROs) as well as remove existing ones.'),
(5312, 'It can also just receive results electronically'),
(5313, 'It can be either linked to a patient or just be a message addressed to another user(s)'),
(5314, 'It combines what the user knows i.e. user password with what the user has i.e. a device that is unique or a mechanism to generate/receive a unique code to be used at each login'),
(5315, 'It consists of three sections '),
(5316, 'It consists of two parts - defining a Provider and configuring the Orders and Results'),
(5317, 'It consists of two parts - the Receiving application and Receiving facility'),
(5318, 'It consists of two parts - the Sending application and Sending facility'),
(5319, 'It contains a left and right section'),
(5320, 'It contains a QR code that needs to be captured by the authenticator app'),
(5321, 'It contains structured data that is included in the Continuity of Care Record (CCR) set to the the Clinical Document Architecture standard'),
(5322, 'It does not refer to the actual referral that has been created'),
(5323, 'It does so by using an algorithm to combine the current UNIX time with the secret key to generate an ever changing unique key'),
(5324, 'It has four tabs'),
(5325, 'It has three tiers '),
(5326, 'It is a commercial messaging module available to openEMR practices utilizing version 5.0.1 and higher'),
(5327, 'It is a field in the HL7 Message header known as Processing ID'),
(5328, 'It is a part of the medical record'),
(5329, 'It is also a subscription based service'),
(5330, 'It is also necessary to list an ICD10 code in order for the problem to be listed in Continuity of Care Report (CCR) and Continuity of Care Document (CCD)'),
(5331, 'It is divided into two sections'),
(5332, 'It is essential that you read through the first four sections to understand the underlying principles'),
(5333, 'It is far easier and intuitive to make major changes and reorganize the data on the spreadsheet before you start entering the data in openEMR'),
(5334, 'It is important to realize that this manages the MFA for the logged in user'),
(5335, 'It is important to understand the function of these two icons as all subsequent steps needed to properly set up the hierarchy will depend on the correct use of these two icons'),
(5336, 'It is intended to include only the information that is critical to effectively continue care'),
(5337, 'It is issued to health care providers in the United States by the Centers for Medicare and Medicaid Services (CMS)'),
(5338, 'It is not necessary for local lab, instead you can use any arbitrary unique number'),
(5339, 'It is not necessary to fill default Diagnosis Codes as ICD10 codes can be entered at the time of the actual ordering of the test'),
(5340, 'It is not submitted with the claim'),
(5341, 'It is not uncommon to order several blood tests together, grouping them as a panel of tests facilitates this process'),
(5342, 'It is prudent to follow up with provider if not contacted.'),
(5343, 'It is the basic paper claim form prescribed by many payers for claims submitted by individual doctors & practices, nurses, and professionals, including therapists, chiropractors, and out-patient clinics, and in some cases, for ambulance services'),
(5344, 'It is used to link problems with encounters and is also used to see which encounters are associated to a particular issue'),
(5345, 'It is useful to practice on a trial site to become familiar with the process before doing so on the production openEMR application'),
(5346, 'It lets you search by ICD 9 and ICD 10 diagnostic codes and CPT4 and HCPCS service/procedure codes'),
(5347, 'It lets you send messages and dated reminders to staff members, add patient to the recall list and send SMS text messages to patients'),
(5348, 'It serves as a necessary bridge to a different environment, often with new clinicians who know nothing about the patient, enabling next provider to easily'),
(5349, 'It therefore stands to reason that you cannot create a Counter-Referral by itself'),
(5350, 'It uses an open standard and therefore available from various manufactures'),
(5351, 'It uses the HMAC-SHA256 hash function to generate a unique private key for the account'),
(5352, 'It uses this private key to sign the challenge and sends the response back to the application'),
(5353, 'It will be displayed in the visit summary'),
(5354, 'It will bring up the Enter Details pop-up form'),
(5355, 'It will bring up the Multi patient finder  popup'),
(5356, 'It will display the justify display pop-up. It has a search box that wil let you search for a ICD code.  It will also display the 10 most commonly used ICD codes. You can select any or all codes by checking the J (justify) checkbox and pressing update'),
(5357, 'It will have a value of 2 in the Tier column indicating it is a successor or child on the first line above having a Tier value of 1 which in this case is Serum Chemistry'),
(5358, 'It will have two sections - the Issues Section and the Encounters Section'),
(5359, 'It will help later in troubleshooting problems that may arise with your configuration of the Procedure Orders module'),
(5360, 'It will open the Create New Message section'),
(5361, 'It will take you to the MedEx sign-up page'),
(5362, 'It will then appear in the Allergies widget on the Patient Dashboard as well as under allergies in the Issues page'),
(5363, 'It will then appear in the Medications widget on the Patient Dashboard as well as under Medications in the Issues page'),
(5364, 'Italian'),
(5365, 'Item'),
(5366, 'item'),
(5367, 'Item Details'),
(5368, 'items'),
(5369, 'Items load failed'),
(5370, 'IU/L'),
(5371, 'IUD'),
(5372, 'IV'),
(5373, 'Jaeger'),
(5374, 'Jaeger{{Near Acuity Type Jaeger}}'),
(5375, 'Jan'),
(5376, 'January'),
(5377, 'Japanese'),
(5378, 'Jaundice'),
(5379, 'Javanese'),
(5380, 'Job Description'),
(5381, 'Job ID'),
(5382, 'Joint dislocations'),
(5383, 'Joint Pain'),
(5384, 'Joint sprains'),
(5385, 'Jul'),
(5386, 'July'),
(5387, 'Jump to Next Row'),
(5388, 'Jun'),
(5389, 'June'),
(5390, 'Just below the check information is a blue area where you put in your search parameters.  You can search by patient name, chart number, encounter number or date of service, or any combination of these.  You may also select whether you want to see all invoices, open invoices, or only invoices that are due (by the patient).  Click the Search button to perform the search.'),
(5391, 'Just Mine'),
(5392, 'Justification Entries'),
(5393, 'Justify'),
(5394, 'Justify Dx'),
(5395, 'Justify each CPT code with one or more justifications using the dropdown box. These will reflect the diagnosis codes that was previously selected in \'Select Codes\''),
(5396, 'Justify/Save'),
(5397, 'J{{Justify Header}}'),
(5398, 'k, here\'s the rest '),
(5399, 'K1{{Keratometry 1}}'),
(5400, 'K2{{Keratometry 2}}'),
(5401, 'Kalaallisut, Greenlandic'),
(5402, 'Kannada'),
(5403, 'Kanuri'),
(5404, 'Kashmiri'),
(5405, 'Kazakh'),
(5406, 'key'),
(5407, 'Key'),
(5408, 'Key access failed with error'),
(5409, 'Key for multiple database credentials encryption'),
(5410, 'Key Name'),
(5411, 'Keywords'),
(5412, 'kg'),
(5413, 'kg/m^2'),
(5414, 'Khmer'),
(5415, 'Kidney Cancer'),
(5416, 'Kidney Failure'),
(5417, 'Kidney Infections'),
(5418, 'Kidney Stones'),
(5419, 'Kidney Transplant'),
(5420, 'Kikuyu, Gikuyu'),
(5421, 'Kindle Fire HDX, Laptop MDPI, WXGA'),
(5422, 'Kinyarwanda'),
(5423, 'Kiosk'),
(5424, 'Kirundi'),
(5425, 'Knee'),
(5426, 'Knee Problems'),
(5427, 'Knee Replacement'),
(5428, 'Komi'),
(5429, 'Kongo'),
(5430, 'Korean'),
(5431, 'Kurdish'),
(5432, 'Kwanyama, Kuanyama'),
(5433, 'Kyrgyz'),
(5434, 'Lab'),
(5435, 'Lab Documents'),
(5436, 'Lab Exchange Site Address'),
(5437, 'Lab Exchange Site ID'),
(5438, 'Lab Exchange Token ID'),
(5439, 'Lab Order'),
(5440, 'Lab overview'),
(5441, 'Lab Overview'),
(5442, 'Lab Query Status'),
(5443, 'Lab Reference ID'),
(5444, 'Lab Report'),
(5445, 'Lab Result'),
(5446, 'Lab Results'),
(5447, 'Lab Results (write,addonly optional)'),
(5448, 'Lab Results Category Name'),
(5449, 'Lab Results Report'),
(5450, 'Lab Service'),
(5451, 'Lab Test Results'),
(5452, 'Lab/File'),
(5453, 'Label'),
(5454, 'Label cannot be blank'),
(5455, 'Label Cols'),
(5456, 'Label for this type'),
(5457, 'Label printed by'),
(5458, 'LabelCols must be a number between 1 and 999'),
(5459, 'Labels'),
(5460, 'Labels can be printed either for one patient or for all the selected patients'),
(5461, 'Laboratory Information'),
(5462, 'Laboratory Test'),
(5463, 'Labs'),
(5464, 'Laceration / skin condition'),
(5465, 'Laceration/abrasion'),
(5466, 'LAC{{left anterior chamber}}'),
(5467, 'LADate'),
(5468, 'LAD{{left adnexa}}'),
(5469, 'Laminas Module'),
(5470, 'Landscape'),
(5471, 'Language'),
(5472, 'Language Code'),
(5473, 'Language definition added'),
(5474, 'Language Interface Tool'),
(5475, 'Language Interface Tool (language)'),
(5476, 'Language List (write,addonly optional)'),
(5477, 'Language List (write,addonly optional) (language)'),
(5478, 'Language Name'),
(5479, 'Language:'),
(5480, 'Lao'),
(5481, 'Laotian'),
(5482, 'Laptop HiDPI, WXGA+'),
(5483, 'Laser Interferometry'),
(5484, 'Laser Interferometry Acuity'),
(5485, 'Last'),
(5486, 'Last Activity Date'),
(5487, 'Last Appendectomy'),
(5488, 'Last Bill Date'),
(5489, 'Last Bill Date:'),
(5490, 'Last Breast Exam'),
(5491, 'Last Calendar Year'),
(5492, 'Last Cataract Surgery'),
(5493, 'Last Cholecystestomy'),
(5494, 'last date of this event'),
(5495, 'Last Encounter'),
(5496, 'Last Gyn. Exam'),
(5497, 'Last Heart Surgery'),
(5498, 'Last Hernia Repair'),
(5499, 'Last Hip Replacement'),
(5500, 'Last Hysterectomy'),
(5501, 'Last Knee Replacement'),
(5502, 'Last Level Billed'),
(5503, 'Last Mammogram'),
(5504, 'Last Menstrual Period'),
(5505, 'Last Modified'),
(5506, 'Last Month'),
(5507, 'Last Name'),
(5508, 'Last name'),
(5509, 'Last name, First name'),
(5510, 'Last name, first name'),
(5511, 'Last name, first name (title)'),
(5512, 'Last name, first name (title: comments)'),
(5513, 'Last Name:'),
(5514, 'Last Physical Exam'),
(5515, 'Last Prostate Exam'),
(5516, 'Last Rectal Exam'),
(5517, 'Last Reviewed'),
(5518, 'Last Run Started At'),
(5519, 'Last Saved'),
(5520, 'Last Sigmoid/Colonoscopy'),
(5521, 'Last Stmt'),
(5522, 'Last Tonsillectomy'),
(5523, 'Last Tx Date'),
(5524, 'Last update'),
(5525, 'Last update by'),
(5526, 'Last Verified On'),
(5527, 'Last Visit'),
(5528, 'Last X-ray'),
(5529, 'Last{{Name}}'),
(5530, 'Late Recurrence (2-12 Mo)'),
(5531, 'Lateral Malleolus'),
(5532, 'Lateral malleolus:'),
(5533, 'Laterality'),
(5534, 'Laterality of this procedure, if applicable'),
(5535, 'laterally displaced PMI:'),
(5536, 'Latest Health Alerts'),
(5537, 'Latest Medical Records'),
(5538, 'Latest Results Only'),
(5539, 'Latest Visit or Consultation'),
(5540, 'Latin'),
(5541, 'Latvian'),
(5542, 'lat{{lateral}}'),
(5543, 'Launch'),
(5544, 'Launch URI'),
(5545, 'Law Firm'),
(5546, 'Lawyer'),
(5547, 'Layout'),
(5548, 'Layout (need to logout/login after change this setting)'),
(5549, 'Layout Based'),
(5550, 'Layout Columns'),
(5551, 'Layout Editor'),
(5552, 'Layout groups'),
(5553, 'Layout ID'),
(5554, 'Layout ID is required'),
(5555, 'Layout Properties'),
(5556, 'Layout Style'),
(5557, 'Layout-Based Transaction Forms'),
(5558, 'Layout-Based Visit Forms'),
(5559, 'Layouts'),
(5560, 'lb'),
(5561, 'LBF Encounter Form Preview'),
(5562, 'LBF_Validations'),
(5563, 'lbs'),
(5564, 'LB{{left brow}}'),
(5565, 'LCMT{{left Central Macular Thickness}}'),
(5566, 'LCUP{{left cup}}'),
(5567, 'LC{{left conjunctiva}}'),
(5568, 'LDAP - Distinguished Name of User'),
(5569, 'LDAP - Login Exclusions'),
(5570, 'LDAP - Server Name or URI'),
(5571, 'LDL'),
(5572, 'LD{{left disc}}'),
(5573, 'leave blank if still active'),
(5574, 'Leave Blank To Keep Original Filename'),
(5575, 'Leave blank to keep password unchanged.'),
(5576, 'Leave Coding Blank'),
(5577, 'Leave coding blank as currently you can only enter ICD10 codes'),
(5578, 'Leave Destination blank'),
(5579, 'Leave it blank if the problem is still active'),
(5580, 'Leave Message With'),
(5581, 'Leave the Followup Services blank and click Save'),
(5582, 'Leave The Form'),
(5583, 'Leaving the pass phrase blank will not encrypt the document'),
(5584, 'Ledger'),
(5585, 'Ledger - Summarizes and tabulates all the charges, payments, adjustments and balances for all encounters pertaining to the patient'),
(5586, 'Left'),
(5587, 'Left Arm'),
(5588, 'Left Deltoid'),
(5589, 'Left Ear'),
(5590, 'left ear'),
(5591, 'Left Gluteus Medius'),
(5592, 'Left Lens'),
(5593, 'Left Lower Forearm'),
(5594, 'Left Margin (mm)'),
(5595, 'Left Thigh'),
(5596, 'Left Vastus Lateralis'),
(5597, 'Left w/o visit'),
(5598, 'Left-Form Layout'),
(5599, 'Left:'),
(5600, 'Left: '),
(5601, 'Leg Pain/Cramping'),
(5602, 'Legal'),
(5603, 'Legal Authenticator'),
(5604, 'Legal Paper Size'),
(5605, 'Legend:'),
(5606, 'Length'),
(5607, 'Length of modifier, 0 if none'),
(5608, 'Lens'),
(5609, 'Lens Material'),
(5610, 'Lens Material Options'),
(5611, 'Lens Thickness'),
(5612, 'Lens Treatments'),
(5613, 'Less Than'),
(5614, 'Less Than or Equal To'),
(5615, 'Less-private information (write,addonly optional)'),
(5616, 'Less-private information (write,addonly optional) (relaxed)'),
(5617, 'Lets you delete a line or row. Hit \'Refresh\' and the line will have a strikethrough across it'),
(5618, 'Lets you filter the results as per the chosen criteria'),
(5619, 'Lets you send messages to staff members about patient related matters'),
(5620, 'Letter'),
(5621, 'Letter Generator'),
(5622, 'Letter Paper Size'),
(5623, 'Letterhead that doctor signs'),
(5624, 'Letterhead that patient signs'),
(5625, 'Lev Fn{{levator function}}'),
(5626, 'Levator Function'),
(5627, 'Level of urgency'),
(5628, 'LF{{levator function}}'),
(5629, 'LH{{left hertel measurement}}'),
(5630, 'Liability'),
(5631, 'Liability Medical'),
(5632, 'Library'),
(5633, 'License/ID'),
(5634, 'Licensed Prescriber'),
(5635, 'Licensed Prescriber First Name'),
(5636, 'Licensed Prescriber Last Name'),
(5637, 'Licensed Prescriber NPI'),
(5638, 'Licensed Prescriber Title (Prefix)'),
(5639, 'LicensedPrescriber Last name'),
(5640, 'LicensedPrescriber NPI'),
(5641, 'LicensedPrescriber UPIN'),
(5642, 'Life partner'),
(5643, 'Life threatening severity'),
(5644, 'Lifestyle'),
(5645, 'Lifestyle - lists the patient\'s use of Tobacco, Coffee, Alcohol, Recreational Drugs etc'),
(5646, 'Lifestyle status'),
(5647, 'Ligament tear or sprain'),
(5648, 'Light tobacco smoker'),
(5649, 'Likewise Laterality is not relevant in this context and can be left Unassigned'),
(5650, 'Limburgish, Limburgan, Limburger'),
(5651, 'Limit Of Events'),
(5652, 'Limited Exam'),
(5653, 'Limited HPI'),
(5654, 'Limits'),
(5655, 'Line'),
(5656, 'Lingala'),
(5657, 'Link'),
(5658, 'Link To Patient'),
(5659, 'Link/Add Issues (Injuries/Medical/Allergy) to Current Visit'),
(5660, 'Linked'),
(5661, 'Linked document'),
(5662, 'Linked procedure order'),
(5663, 'linked to document'),
(5664, 'linked to procedure order'),
(5665, 'List'),
(5666, 'List box'),
(5667, 'list box'),
(5668, 'list box w/ add'),
(5669, 'List box w/add'),
(5670, 'List box w/search'),
(5671, 'List Editor'),
(5672, 'List encounters'),
(5673, 'List Forms'),
(5674, 'List groups'),
(5675, 'List Insurance Companies'),
(5676, 'List item ID'),
(5677, 'List items can not start with a number.'),
(5678, 'List items contains illegal character(s).'),
(5679, 'List layout items'),
(5680, 'List lists'),
(5681, 'List modifiers, up to 4 can be listed, each separated by a space or a colon'),
(5682, 'List Name'),
(5683, 'List names cannot start with numbers.'),
(5684, 'List of '),
(5685, 'List of health care practitioners'),
(5686, 'List of previous refractions'),
(5687, 'List of previously dispensed Spectacle and Contact Lens Rxs'),
(5688, 'List Prescriptions'),
(5689, 'List used by above Country Data Type option.'),
(5690, 'List used by above State Data Type option.'),
(5691, 'Listening port of the RFC 5425 TLS syslog server.'),
(5692, 'Listing an ICD10 code will let you search for educational material for that particular code '),
(5693, 'Lists'),
(5694, 'Lists (lists)'),
(5695, 'Lithuanian'),
(5696, 'Living Will'),
(5697, 'LI{{Laser Interferometry Acuity}}'),
(5698, 'LI{{Laser Interferometry}}'),
(5699, 'LI{{left iris}}'),
(5700, 'LK{{left cornea}}'),
(5701, 'LLL:'),
(5702, 'LLL{{left lower eyelid}}'),
(5703, 'LL{{left iris}}'),
(5704, 'LL{{left lens}}'),
(5705, 'LMAC{{left macula}}'),
(5706, 'LMC{{left medial chathus}}'),
(5707, 'LMP'),
(5708, 'Load Compendium'),
(5709, 'Load Definitions'),
(5710, 'Load Lab Compendium'),
(5711, 'Load Lab Configuration'),
(5712, 'Load OE Question Options'),
(5713, 'Load Order Definitions'),
(5714, 'Load Order Entry Questions'),
(5715, 'LOAD SUCCESSFUL. Codes inserted'),
(5716, 'Loading'),
(5717, 'LOADING'),
(5718, 'Loading data'),
(5719, 'Loading more results'),
(5720, 'Loading prior image'),
(5721, 'Loading the files into the database. This will take some time...'),
(5722, 'Loading... Please wait'),
(5723, 'LOC'),
(5724, 'Local'),
(5725, 'Local Content'),
(5726, 'Local Filesystem'),
(5727, 'Local Filesystem will store the order as a HL7v2.3 message in a predefined location in the local server hosting openEMR'),
(5728, 'Locale'),
(5729, 'Locality'),
(5730, 'Location'),
(5731, 'location of the openemr machine and may contain sensitive data, so it is recommended to manually delete the files after its use'),
(5732, 'Location of this lot'),
(5733, 'Location unspecified'),
(5734, 'Location where Hylafax stores faxes.'),
(5735, 'Location where scans are stored.'),
(5736, 'Location:'),
(5737, 'Lock'),
(5738, 'Lock an e-signed form individually'),
(5739, 'Lock e-signed encounters and their forms'),
(5740, 'Lock?'),
(5741, 'Locked'),
(5742, 'Locked Payment Pending'),
(5743, 'Log all NewCrop eRx Requests and / or Responses.'),
(5744, 'Log entire document'),
(5745, 'Log In'),
(5746, 'Log in'),
(5747, 'Log In Name is unavailable. Try again!'),
(5748, 'Log is cleared. Please close window.'),
(5749, 'Log Out'),
(5750, 'Log Types'),
(5751, 'Log was already empty. Please close window.'),
(5752, 'Logged in'),
(5753, 'Logged in as'),
(5754, 'Logged in as: '),
(5755, 'Logged out.'),
(5756, 'Logging'),
(5757, 'Login'),
(5758, 'login'),
(5759, 'Login - details are only required if you are connecting to a facility using the SFTP protocol '),
(5760, 'Login Into Facility'),
(5761, 'Login name of WordPress user for portal access'),
(5762, 'Login Page Layout'),
(5763, 'Login to remote host'),
(5764, 'Login to this remote host failed'),
(5765, 'Login Trusted Email'),
(5766, 'Login User Name'),
(5767, 'Login with your user id and password and it will automatically authenticate you'),
(5768, 'Logout'),
(5769, 'logout'),
(5770, 'Logs'),
(5771, 'Logs Viewer'),
(5772, 'LOINC'),
(5773, 'LOINC Code'),
(5774, 'LOINC, rhymes with oink, is a database and universal standard for identifying medical laboratory observations'),
(5775, 'Look back one drawing'),
(5776, 'Look Up'),
(5777, 'Lot'),
(5778, 'Lot ID missing!'),
(5779, 'Lot Number'),
(5780, 'Low'),
(5781, 'Low Priority'),
(5782, 'Lower leg'),
(5783, 'Lower Lids'),
(5784, 'Lowest Priority'),
(5785, 'Low{{Priority}}'),
(5786, 'LP{{left peripheral retina}}'),
(5787, 'LT{{lens thickness}}'),
(5788, 'Luba-Katanga'),
(5789, 'Luhn'),
(5790, 'LUL{{left upper eyelid}}'),
(5791, 'Lumbar spine'),
(5792, 'LUNCH'),
(5793, 'Lunch'),
(5794, 'Lung Cancer'),
(5795, 'Lung Cancer Surgery'),
(5796, 'LUNGS:'),
(5797, 'Lungs:'),
(5798, 'Lupus'),
(5799, 'Luxembourgish, Letzeburgesch'),
(5800, 'LVIT{{left vitreous}}'),
(5801, 'LV{{left vessels}}'),
(5802, 'L{{left side}}'),
(5803, 'L{{left}}'),
(5804, 'M'),
(5805, 'MA Category'),
(5806, 'MA Client Accepting Abortion'),
(5807, 'MA Stats'),
(5808, 'Macedonian'),
(5809, 'Macula'),
(5810, 'Mail'),
(5811, 'Mail Order'),
(5812, 'Mail Sent'),
(5813, 'Mailing Address'),
(5814, 'Main'),
(5815, 'Main Address'),
(5816, 'Main and API'),
(5817, 'Main Counselors'),
(5818, 'Main Log'),
(5819, 'Main Menu Role'),
(5820, 'Main Provider'),
(5821, 'Main Top Pane Screen'),
(5822, 'Main Top Pane Screen(Or Default First Tab)'),
(5823, 'Mainly Authorize.Net uses two keys'),
(5824, 'Maintain active medication allergy list.'),
(5825, 'Maintain active medication list.'),
(5826, 'Maintain an up-to-date problem list of current and active diagnoses.'),
(5827, 'Make modifications to current categories.'),
(5828, 'Make new appointment for'),
(5829, 'Make Payment'),
(5830, 'Make subsequent fields in the same row, Label = 0 Data = 0 and ensure enough columns are available from previous items to allow space for this new item. Otherwise result could be unpredictable'),
(5831, 'Make sure \"'),
(5832, 'Making batch text files for uploading to Clearing House and will mark as billed'),
(5833, 'Malagasy'),
(5834, 'Malaise:'),
(5835, 'Malay'),
(5836, 'Malayalam'),
(5837, 'Male'),
(5838, 'Male Condoms'),
(5839, 'Male VSC'),
(5840, 'Maltese'),
(5841, 'Mammogram'),
(5842, 'Manage'),
(5843, 'Manage Hooks'),
(5844, 'Manage Lists'),
(5845, 'Manage Modules'),
(5846, 'Manage modules'),
(5847, 'Manage modules (manage_modules)'),
(5848, 'Manage Multi Factor Authentication'),
(5849, 'Manage Templates'),
(5850, 'Manage Translations'),
(5851, 'Management'),
(5852, 'Manager'),
(5853, 'Mandatory'),
(5854, 'Mandatory and specified fields'),
(5855, 'Mandatory or specified fields only, dup check, no search'),
(5856, 'Mandatory or specified fields only, search and dup check'),
(5857, 'Mandatory or specified fields only, use patient validation Zend module'),
(5858, 'Manifest (Dry) Refraction'),
(5859, 'Manual'),
(5860, 'Manual Posting'),
(5861, 'Manual Processing Required'),
(5862, 'Manually retrieve description on Fee Sheet'),
(5863, 'Manually type into the New DX box above.'),
(5864, 'Manufacturer'),
(5865, 'Manx'),
(5866, 'Many code items have a lookup/hint.'),
(5867, 'Many companies block operations with USB ports on corporate computers'),
(5868, 'Many of the LOINC codes can be used for both tests and their results'),
(5869, 'Maori'),
(5870, 'Mar'),
(5871, 'Marathi'),
(5872, 'Marathi (Marathi)'),
(5873, 'Marathi (Marāṭhī)'),
(5874, 'March'),
(5875, 'Marginal Reflex Distance'),
(5876, 'Marital'),
(5877, 'Marital Status'),
(5878, 'Mark all as read'),
(5879, 'Mark as Billed'),
(5880, 'Mark as billed but skip billing'),
(5881, 'Mark as Cleared'),
(5882, 'Mark as not billed'),
(5883, 'Mark Message as Completed'),
(5884, 'Mark Note as Completed'),
(5885, 'Mark these reports as reviewed'),
(5886, 'Marked as cleared'),
(5887, 'Married'),
(5888, 'Marshallese'),
(5889, 'Mask'),
(5890, 'Mask for Invoice Numbers'),
(5891, 'Mask for Patient IDs'),
(5892, 'Mask for Product IDs'),
(5893, 'Mass Immunization Center'),
(5894, 'Match'),
(5895, 'Match case'),
(5896, 'Match Found'),
(5897, 'Match Patient'),
(5898, 'Matched Patient'),
(5899, 'Matching for Patient'),
(5900, 'MaternalAunt'),
(5901, 'MaternalCousin'),
(5902, 'MaternalGrandparent'),
(5903, 'MaternalGreatgrandparent'),
(5904, 'MaternalUncle'),
(5905, 'Matrix'),
(5906, 'max'),
(5907, 'Max'),
(5908, 'Max 255 characters'),
(5909, 'max file count reached'),
(5910, 'max file count reached - reload names below'),
(5911, 'Max Size'),
(5912, 'Maxillary Right:'),
(5913, 'Maximum Age'),
(5914, 'Maximum characters'),
(5915, 'Maximum Failed Login Attempts'),
(5916, 'Maximum Failed Login Attempts (0 for no maximum).'),
(5917, 'Maximum idle time in seconds before logout. Default is 7200 (2 hours).'),
(5918, 'Maximum number of times a Patient can be tested in a year'),
(5919, 'Maximum number of times a Patient can be tested in a year. Zero is no limit.'),
(5920, 'Maximum reasonable inventory, 0 if not applicable'),
(5921, 'Maximum Size'),
(5922, 'Maximum Size (entering 0 will allow any size)'),
(5923, 'Maximum size of thumbnail file'),
(5924, 'May'),
(5925, 'MBO '),
(5926, 'MC'),
(5927, 'mcg'),
(5928, 'MDM Document Category Name'),
(5929, 'Means none of last three passwords are allowed when changing a password.'),
(5930, 'Measure Blood Pressure'),
(5931, 'Measure Group Code'),
(5932, 'Measure INR'),
(5933, 'Measurement'),
(5934, 'MedEx automates Appointment Reminders and Recalls using phone calls, text messages and e-mails'),
(5935, 'MedEx Communication Service'),
(5936, 'MedEx needs a valid mobile number to send SMS messages...'),
(5937, 'MedEx Setup'),
(5938, 'Medial Canthi'),
(5939, 'Medial malleolus:'),
(5940, 'Medicaid'),
(5941, 'Medicaid Original Reference No.'),
(5942, 'Medical'),
(5943, 'Medical Abortion'),
(5944, 'Medical Administration'),
(5945, 'Medical Dashboard Help'),
(5946, 'Medical History'),
(5947, 'Medical Issue'),
(5948, 'Medical issue'),
(5949, 'Medical Issues'),
(5950, 'Medical prescription'),
(5951, 'Medical Problem'),
(5952, 'Medical problem'),
(5953, 'Medical Problem Issue List'),
(5954, 'Medical Problems'),
(5955, 'Medical Problems - will show the patient\'s medical issues, Issues > Medical Problems'),
(5956, 'Medical Record'),
(5957, 'Medical Record #'),
(5958, 'Medical Record Dashboard'),
(5959, 'Medical Records'),
(5960, 'Medical Records and History (write,addonly optional) (med)'),
(5961, 'Medical Records Sent'),
(5962, 'Medical Specialty'),
(5963, 'Medical Summary Given'),
(5964, 'Medical System'),
(5965, 'Medical Type'),
(5966, 'Medical/History (write,addonly optional)'),
(5967, 'Medical/History (write,addonly optional) (med)'),
(5968, 'Medicare Part B'),
(5969, 'Medicare Referrer Is Renderer'),
(5970, 'Medication'),
(5971, 'Medication Allergy List'),
(5972, 'Medication Issue List'),
(5973, 'Medication List'),
(5974, 'Medication Reconciliation Performed?'),
(5975, 'Medications'),
(5976, 'Medications - lists the medications under Issues > Medications. If eRx is enabled the medication list has to be entered on the eRx page'),
(5977, 'Medications Allergy List'),
(5978, 'Medications:'),
(5979, 'Medicine Units'),
(5980, 'Medium'),
(5981, 'Medium{{Priority}}'),
(5982, 'MedlinePlus Connect'),
(5983, 'med{{medial}}'),
(5984, 'Member Association Statistics Report'),
(5985, 'Member Id'),
(5986, 'Memory Problems'),
(5987, 'Men'),
(5988, 'Men and Women'),
(5989, 'Men Only'),
(5990, 'Menarche'),
(5991, 'Menopause'),
(5992, 'Menstrual Flow'),
(5993, 'Menstrual Frequency'),
(5994, 'Mental Illness'),
(5995, 'Mental Status'),
(5996, 'Menu'),
(5997, 'Menu (menu)'),
(5998, 'Menu Text'),
(5999, 'Menus'),
(6000, 'Menus (menus)'),
(6001, 'Merge'),
(6002, 'Merge complete.'),
(6003, 'Merge Patients'),
(6004, 'Merge to any patient'),
(6005, 'Message'),
(6006, 'Message and Reminder Center'),
(6007, 'Message Center'),
(6008, 'Message Center Help'),
(6009, 'Message content is not plain text so it has been stored as a document.'),
(6010, 'Message from patient'),
(6011, 'Message Log'),
(6012, 'Message Sent'),
(6013, 'Message Status'),
(6014, 'Message Title'),
(6015, 'Message to patient'),
(6016, 'Message to Reviewer'),
(6017, 'Message type'),
(6018, 'MESSAGE:'),
(6019, 'Messages'),
(6020, 'Messages - due date'),
(6021, 'Messages Screen'),
(6022, 'Messages You have sent Today'),
(6023, 'Messages, Reminders'),
(6024, 'Messages, Reminders, Recalls'),
(6025, 'Messaging'),
(6026, 'Method'),
(6027, 'Method and Specific Product'),
(6028, 'Method Change at this Clinic'),
(6029, 'Method for sending outgoing email.'),
(6030, 'Method of Destruction'),
(6031, 'Mexican/MexAmer/Chicano'),
(6032, 'Mexico'),
(6033, 'MFA'),
(6034, 'MFA Authorization'),
(6035, 'MFA Manaagement'),
(6036, 'MFA Management'),
(6037, 'MFA Verification'),
(6038, 'mg'),
(6039, 'mg/1cc'),
(6040, 'mg/2cc'),
(6041, 'mg/3cc'),
(6042, 'mg/4cc'),
(6043, 'mg/5cc'),
(6044, 'MG/DL'),
(6045, 'mid'),
(6046, 'Middle'),
(6047, 'Middle Name'),
(6048, 'Middle name'),
(6049, 'Middle{{Name}}'),
(6050, 'Midlevel Prescriber'),
(6051, 'Midlevel Prescriber DEA'),
(6052, 'Midlevel Prescriber First name'),
(6053, 'Midlevel Prescriber Last name'),
(6054, 'Midlevel Prescriber NPI'),
(6055, 'Midlevel Prescriber Prefix'),
(6056, 'Midlevel Prescriber UPIN'),
(6057, 'Mid{{Middle Distance Add}}'),
(6058, 'Mid{{middle Rx strength}}'),
(6059, 'Mid{{Middle segment in a trifocal glasses prescription}}'),
(6060, 'mid{{middle}}'),
(6061, 'Mien'),
(6062, 'Migrant or seasonal worker?'),
(6063, 'Migrant Seasonal'),
(6064, 'Migrant/Seasonal'),
(6065, 'Mil/CU.MM'),
(6066, 'Mild'),
(6067, 'Mild to moderate'),
(6068, 'Military Treatment Facility'),
(6069, 'MIME Type'),
(6070, 'MimeType'),
(6071, 'Min'),
(6072, 'min'),
(6073, 'Min length is 8 with upper,lowercase,numbers mix'),
(6074, 'Mini'),
(6075, 'Minimal Logging'),
(6076, 'Minimize this panel'),
(6077, 'Minimum Age'),
(6078, 'Minimum length of password.'),
(6079, 'Minimum Password Length'),
(6080, 'Minor joint strain +/- synovitis'),
(6081, 'minute'),
(6082, 'Minute'),
(6083, 'Minutes'),
(6084, 'minutes'),
(6085, 'Mirth IP'),
(6086, 'Misc'),
(6087, 'Misc Billing Options'),
(6088, 'Misc Billing Options for HCFA-1500'),
(6089, 'Misc Billing Options HCFA'),
(6090, 'Miscellaneous'),
(6091, 'Miscellaneous Billing Options for HCFA-1500'),
(6092, 'Missed'),
(6093, 'missing'),
(6094, 'Missing a required field'),
(6095, 'Missing a required field and will be highlighted'),
(6096, 'Missing email config record'),
(6097, 'Missing Fee'),
(6098, 'Missing Identifying Code'),
(6099, 'Missing Insurance Payer Id'),
(6100, 'Missing Mods Only'),
(6101, 'Missing or Invalid'),
(6102, 'Missing Patient ID'),
(6103, 'Missing PID.'),
(6104, 'Missing report date'),
(6105, 'Missing slash after payer in source for code '),
(6106, 'Missing SMS config record'),
(6107, 'Missing Subscriber Policy Number or DOB'),
(6108, 'Missing Title'),
(6109, 'Missing user credentials'),
(6110, 'Missing/invalid notification id'),
(6111, 'Mixed'),
(6112, 'mL'),
(6113, 'ml'),
(6114, 'MM/DD/YYYY'),
(6115, 'mm/hg'),
(6116, 'mmHg'),
(6117, 'MMR 1'),
(6118, 'MMR 2'),
(6119, 'mm{{millimeters}}'),
(6120, 'Mobile'),
(6121, 'Mobile Phone'),
(6122, 'Mobile phones'),
(6123, 'Mobile phones are ubiquitous and are generally easily accessible by any user'),
(6124, 'Mobile Unit'),
(6125, 'Mod'),
(6126, 'Mod Date'),
(6127, 'Mode - Do Not Show SQL Queries'),
(6128, 'Moderate'),
(6129, 'Moderate Priority'),
(6130, 'Moderate to severe'),
(6131, 'Moderate/Low Priority'),
(6132, 'Modern/images'),
(6133, 'Modifier'),
(6134, 'Modifier 22: Increased Procedural Services: When the work required to provide a service is substantially greater than typically required, it may be identified by adding modifier 22 to the usual procedure code.'),
(6135, 'Modifier 24: Unrelated Evaluation and Management Service by the Same Physician During a Postoperative Period'),
(6136, 'Modifier 25: Significant, separately identifiable evaluation and management (E/M) service by the same physician on the day of a procedure or other service'),
(6137, 'Modifier 57: Indicates an Evaluation and Management (E/M) service resulted in the initial decision to perform surgery either the day before a major surgery (90 day global) or the day of a major surgery.'),
(6138, 'Modifier(s)'),
(6139, 'Modifiers'),
(6140, 'Modify'),
(6141, 'Modify Date'),
(6142, 'Modify Patient Form'),
(6143, 'Modify Payments'),
(6144, 'Modifying'),
(6145, 'ModLength'),
(6146, 'Module'),
(6147, 'Module Directory not found'),
(6148, 'Module Installer'),
(6149, 'Module Name'),
(6150, 'Module name already exist'),
(6151, 'Modules'),
(6152, 'Modules (modle)'),
(6153, 'Mon'),
(6154, 'Mon thru Fri'),
(6155, 'Mon, Wed &amp; Fri'),
(6156, 'Monday'),
(6157, 'Mongolian'),
(6158, 'Monocular Pupillary Diameter - Distance'),
(6159, 'Monocular Pupillary Diameter - Near'),
(6160, 'month'),
(6161, 'Month'),
(6162, 'Month View'),
(6163, 'Month(s)'),
(6164, 'Monthly Income'),
(6165, 'months'),
(6166, 'Months'),
(6167, 'months ago'),
(6168, 'Mood/Affect Nml{{Mood and affect normal}}'),
(6169, 'More Actions'),
(6170, 'More appointments may exist'),
(6171, 'More information about Clinical Decision Rule can be found here'),
(6172, 'More information about Issues can be found here'),
(6173, 'More information about what phiMail is and how to set it up is available here'),
(6174, 'More information available at the openEMR MedEx wiki page'),
(6175, 'More information on how to edit this form and other such forms can be found here'),
(6176, 'More information on the use of phiMail messages is available here'),
(6177, 'More options'),
(6178, 'More than'),
(6179, 'More than 100 records found. Please narrow your search criteria.'),
(6180, 'More than 50 results, please make your search more specific.'),
(6181, 'More than one appointment was found'),
(6182, 'Moreover there is a recurring cost incurred in sending the text messages'),
(6183, 'Most activities in relation to a patient are based on an encounter'),
(6184, 'Most column headers can be clicked to change sort order'),
(6185, 'Most often this is due to a Username/Password mismatch'),
(6186, 'Most recent from'),
(6187, 'Most recent lab data:'),
(6188, 'Most recent visit'),
(6189, 'Most recent vitals from:'),
(6190, 'Mother'),
(6191, 'Mother\'s Name'),
(6192, 'Mothers History'),
(6193, 'Mothers Name'),
(6194, 'Motility'),
(6195, 'Mouth'),
(6196, 'Move'),
(6197, 'Move Document to Category:'),
(6198, 'Move Down'),
(6199, 'Move failed!'),
(6200, 'Move the individual items from \'Active\' to \'Inactive\' or vice-versa by selecting the items and pressing the relevant button with the double chevron.'),
(6201, 'Move to Patient'),
(6202, 'Move to...'),
(6203, 'Move Up'),
(6204, 'Moving'),
(6205, 'Mo{{Monday}}'),
(6206, 'MPD-D{{abbreviation for Monocular Pupillary Diameter - Distance}}'),
(6207, 'MPD-N{{abbreviation for Monocular Pupillary Diameter - Near}}'),
(6208, 'MR (Dry)'),
(6209, 'Mr.'),
(6210, 'MRD{{marginal reflex distance}}'),
(6211, 'MRN (pid)'),
(6212, 'MRN Reference'),
(6213, 'MRNear{{Manifest Near Acuity}}'),
(6214, 'MRNear{{manifest refraction near}}'),
(6215, 'Mrs.'),
(6216, 'MR{{Manifest Refraction}}'),
(6217, 'Ms.'),
(6218, 'MSH-11'),
(6219, 'MSH-3.1'),
(6220, 'MSH-4.1'),
(6221, 'MSH-5.1'),
(6222, 'MSH-6.1'),
(6223, 'MSH.8 message type is not supported'),
(6224, 'MSH.8 message type is not valid'),
(6225, 'MSP'),
(6226, 'MSP Code'),
(6227, 'MSP Remit Codes'),
(6228, 'Multi Factor Authorization - MFA has been increasingly used to authenticate a user without making the process of authentication too onerous'),
(6229, 'Multi Factor Authorization Help'),
(6230, 'Multi Language Tool'),
(6231, 'Multi-select desired DX(s) and click the'),
(6232, 'Multi-Select Facilties'),
(6233, 'Multi-Select Provider'),
(6234, 'Multiple areas'),
(6235, 'Multiple DataBase'),
(6236, 'Multiple files can be uploaded at one time by selecting them using CTRL+Click or SHIFT+Click.'),
(6237, 'Multiple Lots'),
(6238, 'Multiple modifiers can be separated by colons or spaces, maximum of 4 (M1:M2:M3:M4)'),
(6239, 'Multiple Select List'),
(6240, 'Multipledb'),
(6241, 'Multipledb (multipledb)'),
(6242, 'Multiracial'),
(6243, 'Murmur:'),
(6244, 'Musc Ache'),
(6245, 'Musc Aches'),
(6246, 'Musc Redness'),
(6247, 'Musc Stiffness'),
(6248, 'Musc Swelling'),
(6249, 'Musc Warm'),
(6250, 'Muscle'),
(6251, 'Muscle injury'),
(6252, 'Musculoskeletal'),
(6253, 'Musculo{{musculoskeletal}}'),
(6254, 'Must be 12 to 80 characters'),
(6255, 'Must be current email address on file.'),
(6256, 'Must be empty if SMTP authentication is not used.'),
(6257, 'Must be future date'),
(6258, 'Must choose at least one day!'),
(6259, 'Mutually Defined'),
(6260, 'MVA'),
(6261, 'MVX Code'),
(6262, 'My default facility'),
(6263, 'My Default Values'),
(6264, 'My Health'),
(6265, 'My Messages'),
(6266, 'My Term'),
(6267, 'Myself'),
(6268, 'M{{Monday}}'),
(6269, 'Māori'),
(6270, 'N.B.{{Nota bene}}'),
(6271, 'N/A'),
(6272, 'n/a'),
(6273, 'N/A{{not applicable}}'),
(6274, 'Name'),
(6275, 'NAME'),
(6276, 'Name (click for more)'),
(6277, 'Name - Select a provider name from the drop-down list'),
(6278, 'Name 1'),
(6279, 'Name 2'),
(6280, 'Name and Title of Immunization Administrator'),
(6281, 'Name for this Category, Procedure or Result'),
(6282, 'Name in EMR'),
(6283, 'Name must be like codetype_code_language.pdf, for example icd9_274.11_en.pdf'),
(6284, 'Name of Events'),
(6285, 'Name of insurance company'),
(6286, 'Name of Provider'),
(6287, 'Name of the sender for patient reminders.'),
(6288, 'Name of the Surgeon'),
(6289, 'Name of zend template for html print'),
(6290, 'Name of zend template for html print, possible to add custom template in the PrescriptionTemplate module'),
(6291, 'Name of zend template for pdf export'),
(6292, 'Name of zend template for pdf export, possible to add custom template in the PrescriptionTemplate module'),
(6293, 'Name on Card'),
(6294, 'Name Translation'),
(6295, 'Name/Value'),
(6296, 'Name:'),
(6297, 'Names'),
(6298, 'Namespace'),
(6299, 'Narcotic drugs imported'),
(6300, 'NARES:'),
(6301, 'NARES: Normal Right'),
(6302, 'Narrative'),
(6303, 'nasal'),
(6304, 'Nasal mucosa pink, septum midline'),
(6305, 'Nation Notes'),
(6306, 'Nation Notes (nationnotes)'),
(6307, 'Nation Notes (nn_configure)'),
(6308, 'Nation Notes Configure'),
(6309, 'Nation Notes Replace Buttons'),
(6310, 'Nationality'),
(6311, 'NationNotes'),
(6312, 'Native Data Loads'),
(6313, 'Native Hawaiian or Other Pacific Islander'),
(6314, 'Natural Child'),
(6315, 'Natural child'),
(6316, 'Natural Parent'),
(6317, 'Natural Sibling'),
(6318, 'Nauru'),
(6319, 'Nausea'),
(6320, 'Nav Bar'),
(6321, 'Navajo, Navaho'),
(6322, 'Navigation'),
(6323, 'Navigation area includes encounter forms'),
(6324, 'Navigation area uses full height of frameset'),
(6325, 'Navigation Area Visit Forms'),
(6326, 'Navigation Area Width'),
(6327, 'Navigation Area Width for Frames'),
(6328, 'Navigation menu consists of pairs of radio buttons'),
(6329, 'Navigation menu is a tree view'),
(6330, 'Navigation uses a sliding menu'),
(6331, 'NCI CONCEPT ID'),
(6332, 'NCOM{{Neuro comments}}'),
(6333, 'NCPDP'),
(6334, 'NDC'),
(6335, 'NDC Data'),
(6336, 'NDC Number'),
(6337, 'Ndonga'),
(6338, 'Near'),
(6339, 'Near Acuity AutoRefraction'),
(6340, 'Near Acuity Manifest Refraction'),
(6341, 'Near Acuity with Autorefraction'),
(6342, 'Near Acuity with Correction'),
(6343, 'Near Acuity with Manifest (Dry) refraction'),
(6344, 'Near Acuity without Correction'),
(6345, 'Near Point of Accomodation'),
(6346, 'Near Point of Convergence'),
(6347, 'Necessary Medical Equipment'),
(6348, 'Neck'),
(6349, 'Neck Problems'),
(6350, 'Neck supple'),
(6351, 'Need more than one drug.'),
(6352, 'Need to enter a description'),
(6353, 'Need to enter a Return Value'),
(6354, 'Need to enter identifier'),
(6355, 'Need to enter title'),
(6356, 'need to logout/login after changing these settings'),
(6357, 'Needs a Smartphone'),
(6358, 'Needs Auth'),
(6359, 'Needs Justify'),
(6360, 'Needs secondary billing'),
(6361, 'Negative'),
(6362, 'Negative payments not accepted'),
(6363, 'Negatives'),
(6364, 'Neg{{negative}}'),
(6365, 'Neighbor'),
(6366, 'Neo 10%'),
(6367, 'Neo 2.5%'),
(6368, 'Nepali'),
(6369, 'Nerve injury'),
(6370, 'Network Indicator'),
(6371, 'Neural condition / nerve damage'),
(6372, 'Neuro'),
(6373, 'Neuro Numbness'),
(6374, 'Neuro Weakness'),
(6375, 'Neuro-physiology'),
(6376, 'Neuro/Phys Exam Default Values'),
(6377, 'Neurologic'),
(6378, 'Neurology'),
(6379, 'Neuro{{neurologic}}'),
(6380, 'NEURO{{Neurology}}'),
(6381, 'Never'),
(6382, 'Never Alcohol'),
(6383, 'Never smoker'),
(6384, 'New'),
(6385, 'New =>'),
(6386, 'New Acceptors'),
(6387, 'New Alerts'),
(6388, 'New Allergy'),
(6389, 'New amendment request'),
(6390, 'New Appointment'),
(6391, 'New Categories'),
(6392, 'New Category'),
(6393, 'New Clients'),
(6394, 'New Consultation'),
(6395, 'New Crop'),
(6396, 'New Definition set added'),
(6397, 'New Document'),
(6398, 'New Documents'),
(6399, 'New Due Clinical Reminders'),
(6400, 'New Dx{{new diagnosis}}'),
(6401, 'New Encounter'),
(6402, 'New encounter created with id'),
(6403, 'New Encounter Form'),
(6404, 'New encounters not authorized'),
(6405, 'New Enctr'),
(6406, 'New Facility Information'),
(6407, 'New file'),
(6408, 'New Files'),
(6409, 'New form validation'),
(6410, 'New Group'),
(6411, 'New group encounter created with id'),
(6412, 'New Group Encounter Form'),
(6413, 'New Group Information'),
(6414, 'New group was saved successfully'),
(6415, 'New Immunization Record'),
(6416, 'New in ACL Ver 4'),
(6417, 'New in ACL Ver 5'),
(6418, 'New in ACL Ver 6'),
(6419, 'New in ACL Ver 7'),
(6420, 'New in ACL Ver 8'),
(6421, 'New in openEMR ver 5.0.2 '),
(6422, 'New Inj/Status'),
(6423, 'New Items (see above for details)'),
(6424, 'New Layout'),
(6425, 'New Limit of Events'),
(6426, 'New List'),
(6427, 'New Message'),
(6428, 'new messages'),
(6429, 'New Note'),
(6430, 'New or Current Password'),
(6431, 'New or Current Username'),
(6432, 'New Orders'),
(6433, 'New Paragraph'),
(6434, 'New Password'),
(6435, 'New Patient'),
(6436, 'NEW PATIENT'),
(6437, 'New Patient Encounter'),
(6438, 'New Patient Form'),
(6439, 'New Patient ID'),
(6440, 'New patient registration received from patient portal. Reminder to check for possible new appointment'),
(6441, 'New Patients'),
(6442, 'New Payment'),
(6443, 'New Portal Login'),
(6444, 'New Procedure Order'),
(6445, 'New Pt'),
(6446, 'New Recall'),
(6447, 'New results from Lab Exchange'),
(6448, 'New Search'),
(6449, 'New Submissions'),
(6450, 'New to openEMR 5.0.2'),
(6451, 'New User'),
(6452, 'New Value'),
(6453, 'New Visit'),
(6454, 'New/Search'),
(6455, 'NewCrop Account Status'),
(6456, 'NewCrop Admin'),
(6457, 'NewCrop call failed'),
(6458, 'NewCrop Doctor'),
(6459, 'NewCrop eRx Account Id'),
(6460, 'NewCrop eRx Account Name'),
(6461, 'NewCrop eRx Debug Setting'),
(6462, 'NewCrop eRx Default Patient Country'),
(6463, 'NewCrop eRx Name'),
(6464, 'NewCrop eRx Partner Name'),
(6465, 'NewCrop eRx Password'),
(6466, 'NewCrop eRX Role'),
(6467, 'NewCrop eRx Role'),
(6468, 'NewCrop eRx Site Address'),
(6469, 'NewCrop eRx SOAP Request Time-To-Live for Allergies'),
(6470, 'NewCrop eRx SOAP Request Time-To-Live for Medications'),
(6471, 'NewCrop eRx User Role'),
(6472, 'NewCrop eRx User Role * invalid selection *'),
(6473, 'NewCrop eRx Web Service Address'),
(6474, 'NewCrop Manager'),
(6475, 'NewCrop MedEntry'),
(6476, 'NewCrop Midlevel Prescriber'),
(6477, 'NewCrop Nurse'),
(6478, 'NewCrop Supervising Doctor'),
(6479, 'Newer'),
(6480, 'NewRx'),
(6481, 'Newspaper'),
(6482, 'Next'),
(6483, 'Next Appointment Date'),
(6484, 'Next Day'),
(6485, 'Next Month'),
(6486, 'Next month (hold for menu)'),
(6487, 'Next of Kin Relationship'),
(6488, 'Next Scheduled Run'),
(6489, 'Next Visit'),
(6490, 'Next Visit Orders'),
(6491, 'Next Week'),
(6492, 'Next year (hold for menu)'),
(6493, 'Nick Name'),
(6494, 'Nickname'),
(6495, 'Niece/Nephew'),
(6496, 'Night Sweats'),
(6497, 'NKDA{{No known drug allergies}}'),
(6498, 'Nl ext genitalia, vag mucosa, cervix'),
(6499, 'No'),
(6500, 'NO'),
(6501, 'no'),
(6502, 'No access'),
(6503, 'No active patient reminders.'),
(6504, 'No adenopathy (2 areas required)'),
(6505, 'No adjustment reason type found for'),
(6506, 'No adnexal tenderness/masses'),
(6507, 'No alert'),
(6508, 'No amendment requests available'),
(6509, 'No Appointments'),
(6510, 'No archive files present'),
(6511, 'No Archives'),
(6512, 'No Assessment to Display.'),
(6513, 'No audit log tampering detected in the selected date range.'),
(6514, 'No automatic refresh'),
(6515, 'No billing system is currently active'),
(6516, 'No Bills Found to Include in OFX Export'),
(6517, 'No Bills Found to Include in OFX Export<br>'),
(6518, 'No Changes Detected'),
(6519, 'No code was specified!'),
(6520, 'No Configuration Defined for this Module'),
(6521, 'No data available in table'),
(6522, 'No Data to Process'),
(6523, 'No Diagnosis'),
(6524, 'no diagnosis was auto-generated from the clinical findings.'),
(6525, 'No Documents'),
(6526, 'No Documents Found'),
(6527, 'No Encounter could be created'),
(6528, 'No encounter...'),
(6529, 'No end date'),
(6530, 'No entries found, use the form below to add an entry.'),
(6531, 'No errors found'),
(6532, 'No Events'),
(6533, 'No Fax Number Saved For The Selected Organization'),
(6534, 'No files staged for installation'),
(6535, 'No form selected to order!'),
(6536, 'No group was selected'),
(6537, 'No hernia'),
(6538, 'No Hooks Available in this Module'),
(6539, 'No Hooks enabled for this Module'),
(6540, 'No injury/illness'),
(6541, 'No Insurance Companies Found'),
(6542, 'No interactions found'),
(6543, 'No invoices were checked.'),
(6544, 'No Issues'),
(6545, 'No issues in this encounter.'),
(6546, 'No items under selected category'),
(6547, 'No items were selected!'),
(6548, 'No Known Allergies'),
(6549, 'No Known Clinical Instructions'),
(6550, 'No Known Encounters'),
(6551, 'No Known Immunizations'),
(6552, 'No Known Lab Results'),
(6553, 'No Known Medications'),
(6554, 'No Known Plan of Care'),
(6555, 'No Known Problems'),
(6556, 'No Known Procedures'),
(6557, 'No Known Referrals'),
(6558, 'No Known Social Functional Status'),
(6559, 'No Known Social History'),
(6560, 'No Known Vitals'),
(6561, 'No lab data documented.'),
(6562, 'No log file exist for the selected date'),
(6563, 'No logging'),
(6564, 'No logs older than 7 days'),
(6565, 'No masses, tenderness'),
(6566, 'No match Patient record found for the given Re Idenitification code'),
(6567, 'No matches for'),
(6568, 'No matches found. Try search again.'),
(6569, 'No matches were found.'),
(6570, 'No matches were found. Create the new patient now?'),
(6571, 'No matching records found'),
(6572, 'No member fields found for'),
(6573, 'No method enabled'),
(6574, 'No Minimum'),
(6575, 'No Name'),
(6576, 'No new messages on'),
(6577, 'No new results found'),
(6578, 'No notes'),
(6579, 'No ogrganomegoly'),
(6580, 'No openings were found for this period.'),
(6581, 'No Order found, please enter procedure order first'),
(6582, 'No organomegaly'),
(6583, 'No other phone numbers listed'),
(6584, 'No parameters selected'),
(6585, 'No Partners Found'),
(6586, 'No Patient record found for given Selection criteria'),
(6587, 'No Patient record found for the given Re Identification code'),
(6588, 'No peripheral edema'),
(6589, 'No Pharmacies Found'),
(6590, 'No Prescriptions Found'),
(6591, 'No prescriptions selected'),
(6592, 'No presenting illness/injury'),
(6593, 'No previous entries.'),
(6594, 'No Primary Business Entity selected in facility list'),
(6595, 'No prior encounters.'),
(6596, 'No procedures in this encounter.'),
(6597, 'No provider was matched'),
(6598, 'No Providers Found'),
(6599, 'No rash or abnormal lesions'),
(6600, 'No Recall'),
(6601, 'No records available'),
(6602, 'No records found'),
(6603, 'No records found.'),
(6604, 'No records found. Please expand your search criteria.'),
(6605, 'No registered SMART apps in the system'),
(6606, 'No reminder/recall'),
(6607, 'No Reminders'),
(6608, 'No Result Found, for the above search criteria.'),
(6609, 'No Results'),
(6610, 'No results found'),
(6611, 'No results found for'),
(6612, 'No Results Found For Search'),
(6613, 'No results found, please try again.'),
(6614, 'No results, please tray again.'),
(6615, 'No results, please try again.'),
(6616, 'No scopes'),
(6617, 'No Settings avaliable in this module'),
(6618, 'No Show'),
(6619, 'No show'),
(6620, 'no signature in document'),
(6621, 'No signatures on file'),
(6622, 'No Sinus Tenderness:'),
(6623, 'No skin dimpling or breast nodules'),
(6624, 'NO SUCH CONTEXT NAME'),
(6625, 'No table selected! Select a table.'),
(6626, 'No testicular tenderness, masses'),
(6627, 'No Thanks'),
(6628, 'No thrills or heaves'),
(6629, 'No track selected'),
(6630, 'No tracks have been documented.'),
(6631, 'No version of Internet Explorer supports U2F'),
(6632, 'No visit'),
(6633, 'No vitals have been documented.'),
(6634, 'No, Cancel'),
(6635, 'No-fault Insurance including Auto is Primary'),
(6636, 'No:'),
(6637, 'Nocturia'),
(6638, 'Non Paid'),
(6639, 'Non Provider'),
(6640, 'Non Reported Report'),
(6641, 'Non specific injury'),
(6642, 'Non-electronic'),
(6643, 'Non-Insulin Dependent Diabetes'),
(6644, 'Non-Insured'),
(6645, 'Non-residential Substance Abuse Treatment Facility'),
(6646, 'Non-SRH Medical'),
(6647, 'Non-SRH Non-Medical'),
(6648, 'None'),
(6649, 'none'),
(6650, 'None defined'),
(6651, 'None documented'),
(6652, 'None have been documented'),
(6653, 'None of the above'),
(6654, 'None of the Top Distribution Row Can be Completly Blank.'),
(6655, 'None Selected'),
(6656, 'None{{Advanced_Directives}}'),
(6657, 'None{{Amendment}}'),
(6658, 'None{{Appointment}}'),
(6659, 'None{{Authorization}}'),
(6660, 'None{{Category}}'),
(6661, 'none{{Code}}'),
(6662, 'None{{Diagnosis}}'),
(6663, 'None{{Disclosure}}'),
(6664, 'None{{Encounter}}'),
(6665, 'None{{Group}}'),
(6666, 'None{{Immunizations}}'),
(6667, 'None{{Insurance}}'),
(6668, 'None{{Issues}}'),
(6669, 'None{{Issue}}'),
(6670, 'None{{Note}}'),
(6671, 'None{{Partner}}'),
(6672, 'None{{Patient}}'),
(6673, 'None{{Prescriptions}}'),
(6674, 'None{{Recipients}}'),
(6675, 'None{{Result}}'),
(6676, 'None{{Sales}}'),
(6677, 'None{{Sensitivity}}'),
(6678, 'None{{Side}}'),
(6679, 'none{{Symptoms}}'),
(6680, 'none{{Template}}'),
(6681, 'None{{Therapy Group}}'),
(6682, 'None{{Transaction}}'),
(6683, 'Noninsulin Dependent Diabetes'),
(6684, 'Nor'),
(6685, 'Normal'),
(6686, 'Normal (normal)'),
(6687, 'Normal BL'),
(6688, 'Normal Cardiac Exam:'),
(6689, 'Normal Cardiac Exam: '),
(6690, 'Normal Lung Exam:'),
(6691, 'Normal Lung Exam: '),
(6692, 'Normal Office Visit'),
(6693, 'Normal Oropharynx:'),
(6694, 'Normal Right'),
(6695, 'Normal Right:'),
(6696, 'Normal View'),
(6697, 'normal:'),
(6698, 'Normally this should be checked. Not related to access control.'),
(6699, 'North Ndebele'),
(6700, 'Northern Sami'),
(6701, 'Norwegian'),
(6702, 'Norwegian Bokmal'),
(6703, 'Norwegian Bokmål'),
(6704, 'Norwegian Nynorsk'),
(6705, 'Nose'),
(6706, 'Nosebleed'),
(6707, 'not a letter or number'),
(6708, 'Not active'),
(6709, 'Not Administered'),
(6710, 'Not all fields are required for all codes or code types.'),
(6711, 'Not all old browsers support U2F. Using the latest versions of modern browsers - Chrome, Firefox, Safari, Edge and Opera should suffice'),
(6712, 'Not Allowed'),
(6713, 'Not allowed to delete the Administrators group'),
(6714, 'Not Allowed to Edit'),
(6715, 'Not allowed to inactivate all security objects'),
(6716, 'Not allowed to inactivate anything from the Administrators ACL'),
(6717, 'Not allowed to remove the admin user from the Administrators group'),
(6718, 'Not allowed to remove this user from the Administrators group'),
(6719, 'Not Applicable'),
(6720, 'Not authorised to access PostCalendar module'),
(6721, 'Not Authorized'),
(6722, 'Not authorized'),
(6723, 'Not authorized for this squad!'),
(6724, 'Not authorized for this squad.'),
(6725, 'Not authorized to manage users!'),
(6726, 'Not authorized to sign results'),
(6727, 'Not authorized to view this encounter'),
(6728, 'Not authorized!'),
(6729, 'Not Available'),
(6730, 'Not Billed'),
(6731, 'Not billed'),
(6732, 'Not Checked'),
(6733, 'Not checked out'),
(6734, 'Not Coded'),
(6735, 'Not documented'),
(6736, 'Not Due'),
(6737, 'Not Esigned'),
(6738, 'Not Examined'),
(6739, 'Not Examined:'),
(6740, 'Not Examined: '),
(6741, 'Not For Diagnostic Use'),
(6742, 'not found'),
(6743, 'Not Found'),
(6744, 'not found!'),
(6745, 'Not Hispanic or Latino'),
(6746, 'Not installed'),
(6747, 'Not Installed'),
(6748, 'Not Possible'),
(6749, 'Not required.'),
(6750, 'Not required. This password is for generated admin.p12'),
(6751, 'Not seen since'),
(6752, 'Not sent'),
(6753, 'Not Sent Yet'),
(6754, 'Not Specified'),
(6755, 'Not Specified.'),
(6756, 'Not VFC eligible'),
(6757, 'Not yet implemented.'),
(6758, 'Note'),
(6759, 'NOTE'),
(6760, 'Note Codes'),
(6761, 'Note it is recommended to avoid approving SMART apps that do not register as a confidential client. These apps are less secure and should be highly restricted in the OAUTH2 scopes you allow them to access.'),
(6762, 'Note it will take 5-10 minutes to fully process after you click Install'),
(6763, 'Note it will take 5-10 minutes to fully process after you click Upgrade'),
(6764, 'Note that Audit Logging needs to be enabled above'),
(6765, 'Note that the Eventlog Backup is currently set to save in the following folder'),
(6766, 'Note that the pop-up form heading will now read Enter Details for Custom Favorite Group'),
(6767, 'Note that the pop-up form heading will now read Enter Details for Discrete Results'),
(6768, 'Note that the pop-up form heading will now read Enter Details for Individual Procedures'),
(6769, 'Note there is no \'Save\' button.'),
(6770, 'Note this refers to the Continuity of Care Record (CCR) or Continuity of Care Document (CCD) as the case may be'),
(6771, 'Note Type'),
(6772, 'Note: 12:00 noon is PM, not AM'),
(6773, 'NOTE: Importing external data can take more than an hour depending on your hardware configuration. For example, one of the RxNorm data tables contain in excess of 6 million rows.'),
(6774, 'NOTE: Only the Biannual International Snomed Release is currently supported'),
(6775, 'NOTE: Only the Biannual International Snomed Releases and the US Snomed Releases are currently supported'),
(6776, 'NOTE: Only the full monthly RxNorm release is currently supported'),
(6777, 'NOTE: Only the XML formats and Eligible Professionals valuesets supported'),
(6778, 'NOTE: The import can take up to several hours'),
(6779, 'Note: This code has not been authorized.'),
(6780, 'Note: This code was not entered by an authorized user. Only authorized codes may be uploaded to the Open Medical Billing Network for processing. If you wish to upload these codes, please select an authorized user here.'),
(6781, 'Note: This copay was entered against billing that has not been authorized. Please review status.'),
(6782, 'Note: this is not an email address'),
(6783, 'NOTE: Uploading files with duplicate names will cause the files to be automatically renamed (for example, file.jpg will become file.1.jpg). Filenames are considered unique per patient, not per category.'),
(6784, 'NOTE: Uploading files with duplicate names will cause the files to be automatically renamed. For example \'<i>file.jpg</i>\' will become \'<i>file.jpg.1</i>\'. Filenames are considered unique per patient, not per category. '),
(6785, 'Notes'),
(6786, 'NOTES'),
(6787, 'Notes - A short description that will show up as a tooltip'),
(6788, 'Notes - any encounters (write,addonly optional)'),
(6789, 'Notes - any encounters (write,addonly optional) (notes_a)'),
(6790, 'Notes - my encounters (write,addonly optional)'),
(6791, 'Notes - my encounters (write,addonly optional) (notes)'),
(6792, 'Notes by'),
(6793, 'Notes not authorized'),
(6794, 'Nothing found - sorry'),
(6795, 'Nothing Pending for Approval'),
(6796, 'Nothing Recorded'),
(6797, 'Nothing returned to report'),
(6798, 'Nothing to display'),
(6799, 'Nothing to import for Allergy'),
(6800, 'Nothing to import for Prescription'),
(6801, 'Nothing to Post! Please review entries or use Cancel to exit transaction'),
(6802, 'Nothing To Report'),
(6803, 'Nothing to show'),
(6804, 'Nothing was selected'),
(6805, 'Notice'),
(6806, 'Notice how the Top Group entry that was initially created called Serum Chemistry now has a blue + sign before its name indicating the presence of descendants or children to this entry'),
(6807, 'Notice Received'),
(6808, 'NOTICE:: PostCalendar Submission/Modification'),
(6809, 'Notification'),
(6810, 'Notification Email Address'),
(6811, 'Notification FAILED'),
(6812, 'Notification FAILED: Not Portal Authorized'),
(6813, 'Notification sent to'),
(6814, 'Notification Settings'),
(6815, 'Notifications'),
(6816, 'Notify Admin About Event Submission/Modification?'),
(6817, 'Notify Patient'),
(6818, 'Notify Patients Portal'),
(6819, 'Notify via Patient Portal'),
(6820, 'Nov'),
(6821, 'November'),
(6822, 'Now is the time to check and adjust the settings in openEMR for default units, sites, etc., refer to the help file in Procedures > Providers'),
(6823, 'Now posting for'),
(6824, 'Now posting for:'),
(6825, 'Now printing'),
(6826, 'Now printing $stmt_count statements and updating encounters.'),
(6827, 'Now printing $stmt_count statements and updating invoices.'),
(6828, 'Now printing $stmt_count statements; encounters will not be updated.'),
(6829, 'Now printing $stmt_count statements; invoices will not be updated.'),
(6830, 'Now when you bring up the Select Codes pop-up you will see all the ICD10 codes listed'),
(6831, 'Now when you bring up the Select Diagnosis Codes pop-up you will see all the ICD10 codes listed'),
(6832, 'NPA{{near point of accomodation}}'),
(6833, 'NPC{{near point of convergence}}'),
(6834, 'NPI'),
(6835, 'NPI - Enter the Provider\'s unique 10-digit National Provider Identifier or NPI identification number'),
(6836, 'NQF'),
(6837, 'Number'),
(6838, 'Number labs'),
(6839, 'Number of Appointments on Statement'),
(6840, 'Number of Appointments to display in the Group Summary'),
(6841, 'Number of Appointments to display in the Onsite Patient Portal'),
(6842, 'Number of Appointments to display in the Patient Summary'),
(6843, 'Number of columns in year view.'),
(6844, 'Number of days before showing fifth account message'),
(6845, 'Number of days before showing first account message'),
(6846, 'Number of days before showing first account message.'),
(6847, 'Number of days before showing fourth account message'),
(6848, 'Number of days before showing second account message'),
(6849, 'Number of days before showing third account message'),
(6850, 'Number of days that the client certificate is valid.'),
(6851, 'Number of days to search from the start date'),
(6852, 'Number of digits after decimal point for currency, usually 0 or 2.'),
(6853, 'Number of encounters to display per page.'),
(6854, 'Number of Excluded Appointments to display in the Tooltip'),
(6855, 'Number of games or events missed, if any'),
(6856, 'Number of hours in advance to send email notifications.'),
(6857, 'Number of hours in advance to send Phone notification.'),
(6858, 'Number of hours in advance to send SMS notifications.'),
(6859, 'Number of Messages Displayed in Patient Summary'),
(6860, 'Number of Minutes to display completed checkouts'),
(6861, 'Number of Minutes to display completed checkouts. Zero is continuous display'),
(6862, 'Number of past history columns'),
(6863, 'Number of patients to display per page in the patient list.'),
(6864, 'Numbness'),
(6865, 'Numerator'),
(6866, 'Numeric display order'),
(6867, 'Nuosu'),
(6868, 'Nursing Facility'),
(6869, 'Nutrition'),
(6870, 'Nutritional'),
(6871, 'O.A.F.V.'),
(6872, 'O2 Sat'),
(6873, 'OAuth2 using SMART-on-FHIR profile (see http://docs.smarthealthit.org)'),
(6874, 'Obesity I'),
(6875, 'Obesity II'),
(6876, 'Obesity III'),
(6877, 'Objective'),
(6878, 'Obligatory participation'),
(6879, 'Observation'),
(6880, 'Observation Criteria'),
(6881, 'Observation Criteria Value'),
(6882, 'Observation Form'),
(6883, 'Observation Results'),
(6884, 'Observation Results in Immunization'),
(6885, 'Occitan'),
(6886, 'Occupation'),
(6887, 'Occupational physician'),
(6888, 'occurred while uploading file named'),
(6889, 'Occurrence'),
(6890, 'Oct'),
(6891, 'October'),
(6892, 'OD'),
(6893, 'OD{{right eye}}'),
(6894, 'oeFHIR'),
(6895, 'of'),
(6896, 'of quantity'),
(6897, 'of tablets'),
(6898, 'of the month every'),
(6899, 'Ofc Notes'),
(6900, 'Off'),
(6901, 'Off (Recommended setting)'),
(6902, 'Off Campus-Outpatient Hospital'),
(6903, 'Off: No Service.'),
(6904, 'Office'),
(6905, 'Office Announcements'),
(6906, 'Office Note'),
(6907, 'Office Notes'),
(6908, 'Office Visit'),
(6909, 'Official Clinical Quality Measures (CQM) Measure Groups'),
(6910, 'Offsite Https link for the Patient Portal.'),
(6911, 'Offsite Https link for the Patient Portal.(Patient Link)'),
(6912, 'Offsite Patient Portal Password'),
(6913, 'Offsite Patient Portal Password(Put Blank If not Registered).'),
(6914, 'Offsite Patient Portal Provider ID'),
(6915, 'Offsite Patient Portal Provider ID(Put Blank If not Registered).'),
(6916, 'Offsite Patient Portal Site Address'),
(6917, 'Offsite Patient Portal Site Address (Patient Link)'),
(6918, 'Offsite Patient Portal Username'),
(6919, 'Offsite Patient Portal Username(Put Blank If not Registered).'),
(6920, 'Offsite Portal web Service Failed'),
(6921, 'Offspring'),
(6922, 'Offspring History'),
(6923, 'Oh Snap!'),
(6924, 'OID'),
(6925, 'ointment'),
(6926, 'Ojibwe, Ojibwa'),
(6927, 'OK'),
(6928, 'Ok'),
(6929, 'OK to close this other popup window?'),
(6930, 'OK to link the GCAC issue dated'),
(6931, 'Old'),
(6932, 'Old Church Slavonic, Church Slavonic, Old Bulgarian'),
(6933, 'Old Clients'),
(6934, 'Old fracture non / malunion'),
(6935, 'Old style layout with no left menu'),
(6936, 'Old-style static form without search or duplication check'),
(6937, 'Older'),
(6938, 'Older than'),
(6939, 'Oldest drawing'),
(6940, 'Omit'),
(6941, 'Omit circumferences'),
(6942, 'Omit employer information in patient demographics'),
(6943, 'Omit Employers'),
(6944, 'Omit form, route and interval which then become part of dosage'),
(6945, 'Omit insurance and some other things from the demographics form'),
(6946, 'Omit internal users?'),
(6947, 'Omit method of payment from the co-pay panel'),
(6948, 'omit to autoassign'),
(6949, 'On'),
(6950, 'on'),
(6951, 'on file email'),
(6952, 'On first page'),
(6953, 'On for Both Roles'),
(6954, 'On for Patient Role'),
(6955, 'On for Users Role'),
(6956, 'On Hand'),
(6957, 'On mobile devices tap once on the label to reveal the help icon and tap on the icon to show the help section'),
(6958, 'On opening, all dx code rows that match the new procedure from procedure order form will be marked and then will scroll to the first match.'),
(6959, 'On Order'),
(6960, 'On Site'),
(6961, 'On the other hand if you click register but do not capture the QR code with the authenticator app you will not be able to login'),
(6962, 'On these lines the Code column will be blank'),
(6963, 'On this date there is a holiday, use it anyway?'),
(6964, 'On: HAPI FHIR.'),
(6965, 'On: Smart on FHIR.'),
(6966, 'Once a rule is setup it can be enabled for a particular patient'),
(6967, 'Once a Transaction is saved it will appear on the Transaction page'),
(6968, 'Once an appointment is scheduled the name automatically drops off the recall board'),
(6969, 'Once an appointment is scheduled the recall will drop off the Recall Board'),
(6970, 'Once completed, view and store this encounter as a PDF file'),
(6971, 'Once finished editing, click Save. The procedure forms current procedure diagnoses will fill exactly as built in this dialog.'),
(6972, 'Once saved the entity for a Custom Favorite Group cannot be changed. If you need to change the entity you have to delete this entry and create a new one'),
(6973, 'Once the app captures the QR code it will show the OpenEMR user name in the app'),
(6974, 'Once the Primary Business Facility is set, changing the facility id will affect NewCrop ePrescription.'),
(6975, 'Once the Primary Business Facility is set, it should not be changed. Changing the facility will affect the working in NewCrop ePrescription.'),
(6976, 'Once this feature is enabled you will be required to type in the 6 digit key at each login'),
(6977, 'Once this is done the shared secret key that is unique for each user should only exist in OpenEMR and on the user\'s authenticator app'),
(6978, 'Once this step is completed you can proceed to next step - to configure the tests that can be ordered from the system'),
(6979, 'Once you change your password, you will have to re-login.'),
(6980, 'Once you select a justification code for the first CPT line all subsequent CPT code lines will have the same justification. Can be manually altered later if so desired'),
(6981, 'Oncology: Medical and Radiation – Pain Intensity Quantified (CQM)'),
(6982, 'One Day Ago'),
(6983, 'One Day Ahead'),
(6984, 'One Encounter Per Day'),
(6985, 'One Month Ago'),
(6986, 'One Month Ahead'),
(6987, 'One or more transactions failed'),
(6988, 'One such lab uses 905 for Uric Acid and in our example we will enter that number in the box'),
(6989, 'One Time PIN'),
(6990, 'One Time verification PIN'),
(6991, 'One Week Ahead'),
(6992, 'One Year Ago'),
(6993, 'One Year Ahead'),
(6994, 'One-time password or OTP is a commonly used strategy used to provide a unique code for each login'),
(6995, 'Online'),
(6996, 'Online Support'),
(6997, 'Online Support Link'),
(6998, 'Online Users'),
(6999, 'Only Active'),
(7000, 'Only applicable if a provider or collated list was chosen above. PRIMARY only selects patients that the provider is the primary provider. ENCOUNTER selects all patients that the provider has seen.'),
(7001, 'Only entries with a Code are billable'),
(7002, 'Only for comparisons'),
(7003, 'Only for HTML5 compatible browsers.'),
(7004, 'only if billing location'),
(7005, 'Only images files are accepted'),
(7006, 'Only Inactive'),
(7007, 'Only Mine'),
(7008, 'Only one TOTP Key can be set up per user'),
(7009, 'Only recall to provider, no reminder'),
(7010, 'Only reminder to provider, no recall'),
(7011, 'Only Show Diagnosis Reporting Codes'),
(7012, 'Only Show Service Code Finance Reporting Codes'),
(7013, 'Only upload active prescriptions'),
(7014, 'Only upload active prescriptions to NewCrop eRx.'),
(7015, 'Onset'),
(7016, 'Onset of Current Symptoms or Illness'),
(7017, 'Onset of Illness:'),
(7018, 'Onset of Ilness: '),
(7019, 'Onset of Swelling:'),
(7020, 'Onset/hosp. date'),
(7021, 'Onset/hosp. date - is used for billing hospital encounters'),
(7022, 'Onset/hosp. date:'),
(7023, 'Onsite Activity Views'),
(7024, 'Onsite Patient Activities'),
(7025, 'Onsite Patient Portal'),
(7026, 'Onsite Patient Portal Site Address'),
(7027, 'Onsite Portal'),
(7028, 'Onsite Portal Activities'),
(7029, 'Onsite Portal Reviewed'),
(7030, 'Oops!'),
(7031, 'Open'),
(7032, 'Open a spreadsheet and type in the various groups, procedure orders and discrete results, arrange according to need'),
(7033, 'Open a spreadsheet in openoffice/LibreOffice create 5 columns - three for E/M / CPT codes and two for the ICD code categories'),
(7034, 'Open all expandable forms in expanded state'),
(7035, 'Open and review the message content and any attachments'),
(7036, 'Open Demographics in New Window from Patient Flow Board'),
(7037, 'Open Encounter'),
(7038, 'Open Fee Sheet'),
(7039, 'Open Forms Module'),
(7040, 'Open in New Window'),
(7041, 'Open Med Practice and its suppliers use their commercially reasonable efforts to provide the most current and complete data available to them concerning prescription histories, drug interactions and formularies, patient allergies and other factors, but by your use of this service you acknowledge that (1) the completeness and accuracy of such data depends upon the completeness and accuracy with which it is entered into connected electronic databases by physicians, physician’s offices, pharmaceutical benefits managers, electronic medical records firms, and other network participants, (2) such data is subject to error or omission in input, storage or retrieval, transmission and display, technical disruption, power or service outages, or other interruptions in electronic communication, any or all of which may be beyond the control of Open Med Practice and its suppliers, and (3) some information may be unavailable due to regulatory, contractual, privacy or other legal restrictions. You are responsible to use your clinical judgment at all times in rendering medical service and advice.'),
(7042, 'Open Patient'),
(7043, 'Open Patient in New Window'),
(7044, 'Open the Quick Pick panels'),
(7045, 'Open the Shorthand Window and display Shorthand Codes'),
(7046, 'Open Today`s Visit'),
(7047, 'Open/Close Ant Seg panels'),
(7048, 'Open/Close External Exam panels'),
(7049, 'Open/Close Imp/Plan panels'),
(7050, 'Open/Close Neuro panels'),
(7051, 'Open/Close Post Seg panels'),
(7052, 'Open/Close the Anterior Segment drawing panel'),
(7053, 'Open/Close the Anterior Segment Exam Quick Picks panel'),
(7054, 'Open/Close the detailed HPI panel'),
(7055, 'Open/Close the External drawing panel'),
(7056, 'Open/Close the External Exam Quick Picks panel'),
(7057, 'Open/Close the HPI Canvas'),
(7058, 'Open/Close the Imp/Plan drawing panel'),
(7059, 'Open/Close the Impression/Plan Builder panel'),
(7060, 'Open/Close the Neuro drawing panel'),
(7061, 'Open/Close the Neuro Exam Quick Picks panel'),
(7062, 'Open/Close the PMH draw panel'),
(7063, 'Open/Close the PMSFH summary panel'),
(7064, 'Open/Close the Retina drawing panel'),
(7065, 'Open/Close the Retinal Exam Quick Picks panel'),
(7066, 'Open/Close the Shorthand Window and Codes'),
(7067, 'Open/Close the Shorthand Window and display Shorthand Codes'),
(7068, 'Open/Close the Shorthand Window and display Shorthand Codes next to each field'),
(7069, 'OpenEMR'),
(7070, 'OpenEMR allows one TOTP but multiple U2F methods per user'),
(7071, 'OpenEMR already has a Certificate Authority configured.'),
(7072, 'OpenEMR App Registration'),
(7073, 'OpenEMR Application'),
(7074, 'OpenEMR Application Category'),
(7075, 'OpenEMR Authorization'),
(7076, 'OpenEMR Database Upgrade'),
(7077, 'OpenEMR Database Upgrade for De-identification'),
(7078, 'OpenEMR does not recognize the incoming file in the contrib directory. This is most likely because you need to configure the release in the supported_external_dataloads table in the MySQL database.'),
(7079, 'OpenEMR Login'),
(7080, 'OpenEMR must be configured to use certificates before it can create client certificates.'),
(7081, 'OpenEMR offers 2 methods of 2FA'),
(7082, 'OpenEMR Portal'),
(7083, 'OpenEMR Product Registration'),
(7084, 'OpenEMR requires Javascript to perform user authentication.'),
(7085, 'OpenEMR Users'),
(7086, 'Openings'),
(7087, 'Opens in Bottom frame'),
(7088, 'Opens in Top frame'),
(7089, 'Operation Failed'),
(7090, 'Operative Note - 2009'),
(7091, 'Operator'),
(7092, 'Opthalmic'),
(7093, 'Optic Discs'),
(7094, 'Optic Nerve Analysis'),
(7095, 'Option'),
(7096, 'Option one, apply the changes to only the Current event. Option two, apply to this event and all Future occurrences or lastly, apply to All event occurrences?'),
(7097, 'Option to save method of document storage.'),
(7098, 'Option to support inventory and sales of products'),
(7099, 'Optional'),
(7100, 'Optional category name for an ID Card image that can be viewed from the patient summary page.'),
(7101, 'Optional category name for photo images that can be viewed from the patient summary page.'),
(7102, 'Optional category name of a document to link to from the patient summary page. Lets you click on a patient name to see their ID card.'),
(7103, 'Optional default range for manual entry of results'),
(7104, 'Optional default units for manual entry of results'),
(7105, 'Optional Destination Name'),
(7106, 'Optional Destination or Dicom Study Name'),
(7107, 'Optional drug name, use % as a wildcard'),
(7108, 'Optional end date'),
(7109, 'Optional end date mm/dd/yyyy'),
(7110, 'Optional immunization name or code, use % as a wildcard'),
(7111, 'Optional information about this event'),
(7112, 'Optional lot number, use % as a wildcard'),
(7113, 'Optional numeric patient ID'),
(7114, 'Optional procedure code'),
(7115, 'Optional procedure/service code'),
(7116, 'Options'),
(7117, 'OR'),
(7118, 'Or'),
(7119, 'or choose'),
(7120, 'or click and drag for faster selection.'),
(7121, 'Or create this new field ID'),
(7122, 'Or Out To'),
(7123, 'or select from inventory'),
(7124, 'or Shift-click to decrease it'),
(7125, 'Or upload ERA file:'),
(7126, 'or utilize the Impression/Plan Builder'),
(7127, 'Oral'),
(7128, 'Oral mucosa pink, throat clear'),
(7129, 'Order'),
(7130, 'Order - The order in which the item will be displayed - incrementing by 10 will allow for up to 9 values to be inserted in between if so desired at a later date'),
(7131, 'Order and Result Types'),
(7132, 'Order Catalog'),
(7133, 'Order Date'),
(7134, 'Order Descriptions'),
(7135, 'Order Form'),
(7136, 'Order From'),
(7137, 'Order ID'),
(7138, 'Order must be a number between 1 and 999'),
(7139, 'Order must be a number between 1 and 9999'),
(7140, 'Order Name'),
(7141, 'Order Notes'),
(7142, 'Order Priorities'),
(7143, 'Order Processor'),
(7144, 'Order Questions'),
(7145, 'Order Results'),
(7146, 'Order Status'),
(7147, 'Order Statuses'),
(7148, 'Order Summary'),
(7149, 'Order Tracks'),
(7150, 'Order Type'),
(7151, 'Order Types'),
(7152, 'Order/Result Type'),
(7153, 'Ordered'),
(7154, 'Ordered By'),
(7155, 'Ordered Procedure'),
(7156, 'Ordering'),
(7157, 'Ordering a recognized panel of tests'),
(7158, 'Ordering Physician'),
(7159, 'Ordering Provider'),
(7160, 'Ordering tests individually can be tedious and there are two ways of ordering multiple tests together'),
(7161, 'Orders'),
(7162, 'Orders and Results are setup in an hierarchical manner, there are four tiers in this hierarchy'),
(7163, 'Orders Path'),
(7164, 'Orders Path - is only required if you are submitting an electronic order to an external facility'),
(7165, 'Order{{Sequence}}'),
(7166, 'Organ injury'),
(7167, 'Organization'),
(7168, 'Organization Name'),
(7169, 'Organizational Unit Name'),
(7170, 'Organizations'),
(7171, 'Orientated x 3'),
(7172, 'Oriented TPP{{oriented to person and place}}'),
(7173, 'Origin'),
(7174, 'Origin Description'),
(7175, 'Original'),
(7176, 'Original Checksum'),
(7177, 'Original file'),
(7178, 'Original file deletion error'),
(7179, 'Oriya'),
(7180, 'Oromo'),
(7181, 'OROPHARYNX: '),
(7182, 'Ortho'),
(7183, 'Orthophoric'),
(7184, 'Orthopnea'),
(7185, 'ORTHO{{Orthopedics}}'),
(7186, 'Ortho{{orthophoric}}'),
(7187, 'OR{{as in AND/OR, ie. not an abbreviation}}'),
(7188, 'OS'),
(7189, 'Osetoarthritis'),
(7190, 'Ossetian, Ossetic'),
(7191, 'Osteopathy'),
(7192, 'OS{{left eye}}'),
(7193, 'Other'),
(7194, 'other'),
(7195, 'OTHER'),
(7196, 'Other (specify)'),
(7197, 'Other - lists items not covered in the above sections'),
(7198, 'Other - Specified'),
(7199, 'Other adult'),
(7200, 'Other Documents'),
(7201, 'Other Federal Program'),
(7202, 'Other HCFA'),
(7203, 'Other injury not elsewhere specified'),
(7204, 'Other Liability Insurance is Primary'),
(7205, 'Other Logs'),
(7206, 'other month'),
(7207, 'Other Non-Federal Programs'),
(7208, 'Other Notes'),
(7209, 'Other Pertinent Symptoms'),
(7210, 'Other Pertinent Symptoms:'),
(7211, 'Other Place of Service'),
(7212, 'Other Provider'),
(7213, 'Other pt resp'),
(7214, 'Other Registry'),
(7215, 'Other stress/Over use injury'),
(7216, 'Other Surgical'),
(7217, 'Other/Generic Abortion-Related'),
(7218, 'Other/Miscellaneous'),
(7219, 'Others'),
(7220, 'Otherwise known as Dated Reminders are short messages of up to 160 characters'),
(7221, 'otherwise you will destroy references to/from existing data.'),
(7222, 'OTP can be delivered by various methods'),
(7223, 'OTP can be generated either using time synchronization where the current time is combined with a secret key and hashed to generate the OTP or using mathematical algorithms were an initial seed (a random number) is combined with the previously used password to generate the OTP'),
(7224, 'Ottawa Ankle Rules'),
(7225, 'OU'),
(7226, 'Our Out To'),
(7227, 'OUT'),
(7228, 'Out Of Office'),
(7229, 'Out Time'),
(7230, 'Outbound Referral'),
(7231, 'Outcome'),
(7232, 'Outline Data Col'),
(7233, 'Outline Entire Row'),
(7234, 'Outlook'),
(7235, 'Outpatient Hospital'),
(7236, 'Output Type'),
(7237, 'OU{{both eyes}}'),
(7238, 'Over'),
(7239, 'Overall Status Of Discharge'),
(7240, 'OVERDUE'),
(7241, 'Overlay CMS 1500 on the Preprinted form'),
(7242, 'Override (if necessary) the appointment display limit to allow all appointments to be displayed for the last set'),
(7243, 'Override HIPAA choice'),
(7244, 'Overuse'),
(7245, 'Overview'),
(7246, 'Overweight'),
(7247, 'Overwrite HIPAA choice'),
(7248, 'Owner'),
(7249, 'Oxygen Saturation'),
(7250, 'oz'),
(7251, 'P'),
(7252, 'p.c.'),
(7253, 'p.m.'),
(7254, 'p.r.n.'),
(7255, 'Pachymetry'),
(7256, 'Pachymetry: Central Corneal Thickness'),
(7257, 'Pachy{{Pachymetry}}'),
(7258, 'Pacific Islander'),
(7259, 'Paedeatric'),
(7260, 'Page'),
(7261, 'Page not found'),
(7262, 'Page Validation'),
(7263, 'Pages'),
(7264, 'Paid'),
(7265, 'Paid amount that you will allocate'),
(7266, 'Paid Amt'),
(7267, 'Paid Via'),
(7268, 'Pain'),
(7269, 'Pali'),
(7270, 'Palliative care physician'),
(7271, 'Palpitation'),
(7272, 'PAM{{Potential Acuity Meter}}'),
(7273, 'Pan'),
(7274, 'Panjabi, Punjabi'),
(7275, 'Pap Smear'),
(7276, 'Paper'),
(7277, 'Paper Size'),
(7278, 'Paralysis'),
(7279, 'Parent'),
(7280, 'parent in-law'),
(7281, 'Parent Recall'),
(7282, 'Parent Written Record'),
(7283, 'Parental decision'),
(7284, 'Parse HL7'),
(7285, 'Partially Administered'),
(7286, 'Participant\'s name'),
(7287, 'participants'),
(7288, 'Participants '),
(7289, 'Partner'),
(7290, 'Partner Name'),
(7291, 'Partner Name issued for NewCrop eRx service.'),
(7292, 'Partner not configured'),
(7293, 'Pashto, Pushto'),
(7294, 'Pass Phrase'),
(7295, 'Pass phrase to decrypt document'),
(7296, 'Passed Patients'),
(7297, 'Passive Alert'),
(7298, 'Passive Alert - that will be displayed in the Clinical Reminders widget section'),
(7299, 'Passive Alert Rules'),
(7300, 'password'),
(7301, 'Password'),
(7302, 'Password Change'),
(7303, 'Password change successful'),
(7304, 'Password change successful.'),
(7305, 'Password does not meet minimum requirements and should contain at least each of the following items: A number, a lowercase letter, an uppercase letter, a special character (not a letter or number).'),
(7306, 'Password does not meet minimum requirements and should contain at least three of the four following items: A number, a lowercase letter, an uppercase letter, a special character (Not a leter or number).'),
(7307, 'Password Expiration'),
(7308, 'Password Expiration Grace Period'),
(7309, 'Password for Phone Gateway.'),
(7310, 'Password for Phone Gateway. Automated VOIP service provided by Maviq. Please visit http://signup.maviq.com for more information.'),
(7311, 'Password for SMS Gateway'),
(7312, 'Password for SMS Gateway.'),
(7313, 'Password for the above user'),
(7314, 'Password security has recently been upgraded.'),
(7315, 'Password to connect to CouchDB'),
(7316, 'Password too short. Minimum 8 characters required.'),
(7317, 'Password too short. Minimum characters required'),
(7318, 'Password update error!'),
(7319, 'Password:'),
(7320, 'Passwords do not match'),
(7321, 'Passwords do not match.'),
(7322, 'Passwords Don\'t match!'),
(7323, 'Passwords must be 8-12 characters long and include one capital letter, one lower case letter and one special character'),
(7324, 'Past Appoinments'),
(7325, 'Past Appointment Display Widget'),
(7326, 'Past Appointments'),
(7327, 'Past Appointments - will show all past appointments'),
(7328, 'Past Date'),
(7329, 'Past due'),
(7330, 'Past Due'),
(7331, 'Past Due Interval (Clinical Reminders)'),
(7332, 'Past Due Interval (Patient Reminders)'),
(7333, 'Past Encounter List'),
(7334, 'Past Encounters'),
(7335, 'Past Encounters and Documents'),
(7336, 'Past Encounters for'),
(7337, 'Past Medical History'),
(7338, 'Past meetings'),
(7339, 'Past Ocular History'),
(7340, 'Past Ocular Surgery'),
(7341, 'Past Surgical History'),
(7342, 'Past Therapy Group Encounters'),
(7343, 'Past Year'),
(7344, 'Paste HL7 Data'),
(7345, 'Paste the data to import into the text area below:'),
(7346, 'Pat'),
(7347, 'Pat Ledger'),
(7348, 'Patch'),
(7349, 'Patch was also installed, updating version patch indicator'),
(7350, 'PaternalAunt'),
(7351, 'PaternalCousin'),
(7352, 'PaternalGrandparent'),
(7353, 'PaternalGreatgrandparent'),
(7354, 'PaternalUncle'),
(7355, 'Path for Event Log Backup'),
(7356, 'Path to CA Certificate File'),
(7357, 'Path to CA Key File'),
(7358, 'Path to MySQL Binaries'),
(7359, 'Path to Perl Binaries'),
(7360, 'Path to Temporary Files'),
(7361, 'Patient'),
(7362, 'PATIENT'),
(7363, 'patient'),
(7364, 'Patient Access'),
(7365, 'Patient Address'),
(7366, 'Patient Address is missing'),
(7367, 'Patient Adj'),
(7368, 'Patient Adjustment'),
(7369, 'Patient allergies'),
(7370, 'Patient Allergies'),
(7371, 'Patient already in form'),
(7372, 'Patient and Insured Informatiom - Boxes 1 - 13 and Physician or Supplier Information - Boxes 14 - 33'),
(7373, 'Patient Appointment'),
(7374, 'Patient Balance'),
(7375, 'Patient Balance Due'),
(7376, 'Patient Billing Note'),
(7377, 'Patient birthday alert requires turning off'),
(7378, 'Patient Characteristics'),
(7379, 'Patient chart ID'),
(7380, 'Patient Chat'),
(7381, 'Patient Checkout'),
(7382, 'Patient Checkout for '),
(7383, 'Patient City'),
(7384, 'Patient City is missing'),
(7385, 'Patient city missing'),
(7386, 'Patient Communication sent'),
(7387, 'Patient Comunication Sent'),
(7388, 'Patient Country'),
(7389, 'Patient Country is missing. Also you have not set default Patient Country in Global Settings'),
(7390, 'Patient Coverage'),
(7391, 'Patient Credentials Reset'),
(7392, 'Patient Credit'),
(7393, 'Patient Dashboard'),
(7394, 'Patient Data'),
(7395, 'Patient Date Of Birth'),
(7396, 'Patient Date Of Birth is missing'),
(7397, 'Patient decision'),
(7398, 'Patient Default'),
(7399, 'Patient Demographics'),
(7400, 'Patient details'),
(7401, 'Patient Details'),
(7402, 'Patient DOB'),
(7403, 'Patient DOB missing'),
(7404, 'Patient Document'),
(7405, 'Patient Document Template Forms'),
(7406, 'Patient Document Template Maintenance'),
(7407, 'Patient Document Template Upload'),
(7408, 'Patient Document Templates'),
(7409, 'Patient Documents'),
(7410, 'Patient Education'),
(7411, 'Patient Education Materials'),
(7412, 'Patient Encounter'),
(7413, 'Patient Encounter Form'),
(7414, 'Patient Encounters'),
(7415, 'Patient Finder'),
(7416, 'Patient Finder Screen'),
(7417, 'Patient First name'),
(7418, 'Patient First Name'),
(7419, 'Patient First name is missing'),
(7420, 'Patient Flow Board'),
(7421, 'Patient Flow Board Report'),
(7422, 'Patient Flow Board Rooms'),
(7423, 'Patient Flow Board Timer Interval'),
(7424, 'Patient Gender'),
(7425, 'Patient Gender is missing'),
(7426, 'Patient has not authorized the Patient Portal.'),
(7427, 'Patient Height Vital is required under age 19'),
(7428, 'Patient History'),
(7429, 'Patient History / Lifestyle'),
(7430, 'Patient Home phone'),
(7431, 'Patient ID'),
(7432, 'Patient Id'),
(7433, 'Patient ID card'),
(7434, 'Patient ID Category Name'),
(7435, 'Patient identifying information'),
(7436, 'Patient Images'),
(7437, 'Patient Immunization'),
(7438, 'Patient Information'),
(7439, 'Patient Information (patients)'),
(7440, 'Patient Instructions'),
(7441, 'Patient Insurance Distribution'),
(7442, 'Patient Insurance Distribution Report'),
(7443, 'Patient insurance/financial information'),
(7444, 'Patient is required to enter their contact e-mail if present in Demographics Contact.'),
(7445, 'Patient Issues'),
(7446, 'Patient Label Type'),
(7447, 'Patient Last name'),
(7448, 'Patient Last Name'),
(7449, 'Patient Last name is missing'),
(7450, 'Patient Ledger'),
(7451, 'Patient Ledger by Date'),
(7452, 'Patient Ledger Help'),
(7453, 'Patient Level Billing Note (Collections)'),
(7454, 'Patient List'),
(7455, 'Patient List Columns'),
(7456, 'Patient List Creation'),
(7457, 'Patient List New Window'),
(7458, 'Patient List Page Size'),
(7459, 'Patient Login'),
(7460, 'Patient Lookup Errors'),
(7461, 'Patient Mail'),
(7462, 'Patient may change their logon from portal login dialog.'),
(7463, 'Patient Medical Problems'),
(7464, 'Patient Medications'),
(7465, 'Patient Menu Role'),
(7466, 'Patient Message'),
(7467, 'Patient Messages'),
(7468, 'Patient Messaging'),
(7469, 'Patient must be set manually'),
(7470, 'Patient Name'),
(7471, 'Patient name'),
(7472, 'Patient Name & Address'),
(7473, 'Patient Name and ID'),
(7474, 'Patient Name and Invoice'),
(7475, 'Patient Name Required'),
(7476, 'Patient Name/ID'),
(7477, 'Patient Note'),
(7478, 'Patient Note Types'),
(7479, 'Patient Notes'),
(7480, 'Patient Notes (write,addonly optional)'),
(7481, 'Patient Notes (write,addonly optional) (notes)'),
(7482, 'Patient Number'),
(7483, 'Patient Payment'),
(7484, 'Patient Payments'),
(7485, 'Patient Photo Category Name'),
(7486, 'PATIENT PORTAL'),
(7487, 'Patient Portal'),
(7488, 'Patient Portal (patientportal)'),
(7489, 'Patient Portal (portal)'),
(7490, 'Patient Portal connectivity issue'),
(7491, 'Patient Portal Documents'),
(7492, 'Patient Portal is turned off'),
(7493, 'Patient Portal Login'),
(7494, 'Patient Portal Secure'),
(7495, 'Patient Portal Site Address'),
(7496, 'Patient Portal Web Address'),
(7497, 'Patient Printed Report'),
(7498, 'Patient Recalls'),
(7499, 'Patient Record Report'),
(7500, 'Patient Record Request'),
(7501, 'Patient Records Request'),
(7502, 'Patient Religion'),
(7503, 'Patient Reminder'),
(7504, 'Patient Reminder - that is used to communicate relevant information pertaining to that particular Clinical Decision Rule and is shown in the Patient Reminders widget as Well as under Administration > Patient Reminders'),
(7505, 'Patient Reminder Batch Job'),
(7506, 'Patient Reminder Creation Processing Priority'),
(7507, 'Patient Reminder Rules'),
(7508, 'Patient Reminder Sender Email'),
(7509, 'Patient Reminder Sender Name'),
(7510, 'Patient Reminders'),
(7511, 'Patient Reminders (write,addonly optional)'),
(7512, 'Patient Reminders (write,addonly optional) (reminder)'),
(7513, 'Patient Reminders - a list reminders for preventive or follow-up care according to patient preferences based on demographic data, specific conditions, and/or medication list as well as the status of the notification'),
(7514, 'Patient Report'),
(7515, 'Patient Reported Outcomes'),
(7516, 'Patient Reports'),
(7517, 'Patient Reports Help'),
(7518, 'Patient Request'),
(7519, 'Patient Requested Medical Records'),
(7520, 'Patient Resource'),
(7521, 'Patient Results'),
(7522, 'Patient Search'),
(7523, 'Patient Search Not Available'),
(7524, 'Patient search or select.'),
(7525, 'Patient Search Results Style'),
(7526, 'Patient Search/Add Screen'),
(7527, 'Patient Secure Mail'),
(7528, 'Patient Setting'),
(7529, 'Patient sex missing'),
(7530, 'Patient Signature'),
(7531, 'Patient Signed'),
(7532, 'Patient Signed Date'),
(7533, 'Patient State'),
(7534, 'Patient state missing'),
(7535, 'Patient Statement Bill'),
(7536, 'Patient statements can be generated as plain text or with a modern graphical appearance.'),
(7537, 'Patient Street Address'),
(7538, 'Patient street missing'),
(7539, 'Patient Summary'),
(7540, 'Patient Surveys'),
(7541, 'Patient Template'),
(7542, 'Patient Transactions'),
(7543, 'Patient Transactions Help'),
(7544, 'Patient validation'),
(7545, 'Patient Weight Vital is required under age 19'),
(7546, 'Patient Zip'),
(7547, 'Patient Zip Code missing'),
(7548, 'Patient\'s number'),
(7549, 'patient(s) in the database that match the demographic information you have entered.'),
(7550, 'Patient/Client'),
(7551, 'Patient:'),
(7552, 'PatientID'),
(7553, 'Patients'),
(7554, 'Patients (patients)'),
(7555, 'Patients Processed'),
(7556, 'Patients with debt'),
(7557, 'Patient’s health status'),
(7558, 'Paused status checks.'),
(7559, 'Pay'),
(7560, 'Pay attention to the \"Done with\" checkboxes.  After the insurances are marked complete then we will start asking the patient to pay the remaining balance; if you fail to mark all of the insurances complete then the remaining amount will not be collected!  Also if there is a balance that the patient should pay, then set the due date appropriately, as this will affect the language that appears on patient statements.'),
(7561, 'Pay attention to the \'Done with\' checkboxes. After the insurances are marked complete then we will start asking the patient to pay the remaining balance; if you fail to mark all of the insurances complete then the remaining amount will not be collected! Also if there is a balance that the patient should pay, then set the due date appropriately, as this will affect the language that appears on patient statements.'),
(7562, 'Pay Date'),
(7563, 'Pay Date:'),
(7564, 'Pay Invoice'),
(7565, 'Pay Now'),
(7566, 'Pay Status'),
(7567, 'Payee Name'),
(7568, 'Payer'),
(7569, 'Payer ID'),
(7570, 'Payer Id For Eligibility'),
(7571, 'Payer ID For Encounter Claims'),
(7572, 'Payer Type'),
(7573, 'Paying'),
(7574, 'Paying Entity'),
(7575, 'Payment'),
(7576, 'payment'),
(7577, 'Payment Adjustment Code'),
(7578, 'Payment against'),
(7579, 'Payment Amount'),
(7580, 'Payment Amount must be Numeric'),
(7581, 'Payment Category'),
(7582, 'Payment date'),
(7583, 'Payment Date'),
(7584, 'payment entered on'),
(7585, 'Payment From'),
(7586, 'Payment Gateways'),
(7587, 'Payment Information'),
(7588, 'Payment Ins'),
(7589, 'Payment List'),
(7590, 'Payment Method'),
(7591, 'Payment note'),
(7592, 'Payment Sort By'),
(7593, 'Payment Status'),
(7594, 'Payment successfully sent for authorization. You will be notified when payment is posted. Until payment is accepted and you are notified, you may resubmit this payment at anytime with new amounts or different credit card. Thank you'),
(7595, 'Payment successfully sent for review and posting to your account.'),
(7596, 'Payment Tracking Id'),
(7597, 'Payment Type'),
(7598, 'Payment Validated: Save?'),
(7599, 'Payment value for code'),
(7600, 'Payment value for code '),
(7601, 'Payment was successfully authorized and your card is charged.'),
(7602, 'Payments'),
(7603, 'Payor'),
(7604, 'Payor ID'),
(7605, 'Payor/Carrier Code'),
(7606, 'PCP'),
(7607, 'Pct (%) of rows'),
(7608, 'PD-D{{abbreviation for Binocular Pupillary Diameter - Distance}}'),
(7609, 'PD-N{{abbreviation for Binocular Pupillary Diameter - Near}}'),
(7610, 'PDF'),
(7611, 'PDF buttons will save, mark claim reviewed and download claim'),
(7612, 'PDF Document Parse Error and not included. Check if included in archive.'),
(7613, 'PDF Download Selected'),
(7614, 'PDF Download Selected Statements'),
(7615, 'PDF Language'),
(7616, 'Pdf With Form'),
(7617, 'Pdf Without Form'),
(7618, 'PD{{Inter-pupillary distance}}'),
(7619, 'PD{{pupillary distance}}'),
(7620, 'Pelvis and buttock'),
(7621, 'Pemphigus'),
(7622, 'Pencil'),
(7623, 'pend'),
(7624, 'Pending'),
(7625, 'Pending Action'),
(7626, 'Pending Approval'),
(7627, 'Pending Auth since'),
(7628, 'Pending Documents'),
(7629, 'Pending F/U'),
(7630, 'Pending followup'),
(7631, 'Pending Followup from Results'),
(7632, 'Pending Orders'),
(7633, 'Pending Res'),
(7634, 'Pending Review'),
(7635, 'Pending Rx Count'),
(7636, 'Pending since'),
(7637, 'Penicillin Allergy'),
(7638, 'Pennington Firm OpenEMR  v'),
(7639, 'Peptic Ulcer Disease'),
(7640, 'Per Encounter'),
(7641, 'per min'),
(7642, 'Per Nostril'),
(7643, 'per nostril'),
(7644, 'Per Oris'),
(7645, 'per oris'),
(7646, 'Per Rectum'),
(7647, 'per rectum'),
(7648, 'Percent'),
(7649, 'Percentage'),
(7650, 'Percentage of Patients to Drug Test'),
(7651, 'Percentage of Patients to select for Random Drug Testing.'),
(7652, 'Percentile'),
(7653, 'Perforated Right:'),
(7654, 'Perform Search'),
(7655, 'Perform this action'),
(7656, 'Performance Percentage'),
(7657, 'performed'),
(7658, 'Performer'),
(7659, 'Performing Laboratory Facility'),
(7660, 'Performing organization'),
(7661, 'Period'),
(7662, 'Period in days where a user may login with an expired password.'),
(7663, 'Perioperative Care'),
(7664, 'Periph'),
(7665, 'Peripheral'),
(7666, 'Periph{{peripheral retina}}'),
(7667, 'Periph{{periphery}}'),
(7668, 'Permit unsalted passwords'),
(7669, 'Persian'),
(7670, 'Persian (Farsi)'),
(7671, 'Person'),
(7672, 'Personalize'),
(7673, 'Persons needing a recall, no appt scheduled yet'),
(7674, 'Persons needing a recall, no appt scheduled yet.'),
(7675, 'PG'),
(7676, 'Pharm'),
(7677, 'Pharm Com Count'),
(7678, 'Pharmacies'),
(7679, 'Pharmacies Imported'),
(7680, 'Pharmacy'),
(7681, 'Pharmacy Dispensary'),
(7682, 'Pharmacy Dispensary (drugs)'),
(7683, 'Pharmacy Id'),
(7684, 'Pharmacy Import / Update'),
(7685, 'Pharmacy missing NCPDP ID or less than 7 digits'),
(7686, 'Pharmacy missing NPI  or less than 10 digits'),
(7687, 'Pharmacy not assigned to the patient'),
(7688, 'Pheumothorax'),
(7689, 'phiMail Allow CCD Send'),
(7690, 'phiMail Allow CCR Send'),
(7691, 'phiMail Message Check Interval (minutes)'),
(7692, 'phiMail notification user'),
(7693, 'phiMail Password'),
(7694, 'phiMail Server Address'),
(7695, 'phiMail Username'),
(7696, 'PHIN Questions'),
(7697, 'Phone'),
(7698, 'Phone Biz'),
(7699, 'Phone call list'),
(7700, 'Phone Call List'),
(7701, 'Phone Call List report'),
(7702, 'Phone call made by'),
(7703, 'Phone Cell'),
(7704, 'Phone Contact'),
(7705, 'Phone Gateway Password'),
(7706, 'Phone Gateway URL'),
(7707, 'Phone Gateway Username'),
(7708, 'Phone Home'),
(7709, 'Phone Notification Hour'),
(7710, 'Phone number'),
(7711, 'Phone Number'),
(7712, 'Phone number for billing inquiries'),
(7713, 'Phone Number for Vendor Support that Appears on the About Page.'),
(7714, 'Phone(W)'),
(7715, 'Photophobia'),
(7716, 'Photos'),
(7717, 'PHP compressed'),
(7718, 'PHP CURL module should be enabled in your server.'),
(7719, 'PHP Default'),
(7720, 'PHP extracted'),
(7721, 'php-GACL access controls are turned off'),
(7722, 'PHP-gacl is not installed'),
(7723, 'Physical Exam'),
(7724, 'Physician'),
(7725, 'Physician Request'),
(7726, 'Physician Signature'),
(7727, 'Physician Type'),
(7728, 'Physician\'s UPIN'),
(7729, 'Physicians'),
(7730, 'PH{{pinhole acuity}}'),
(7731, 'PH{{Pinhole Vision}}'),
(7732, 'PH{{Pinhole}}'),
(7733, 'pick'),
(7734, 'Pick'),
(7735, 'Pick a CSS theme.'),
(7736, 'Pick a general theme (need to logout/login after change this setting).'),
(7737, 'Pick a general theme (need to logout/login after changing this setting).'),
(7738, 'PID'),
(7739, 'Pid'),
(7740, 'PID (Pelvic Inflammatory Disease)'),
(7741, 'Pill Size'),
(7742, 'Pills'),
(7743, 'Pinhole Vision'),
(7744, 'Place of Employment-Worksite'),
(7745, 'Place the database zip file in the following directory if want the option to install'),
(7746, 'Place the downloaded ICD 10 database zip files into the following directory'),
(7747, 'Place the downloaded ICD 9 database zip file into the following directory'),
(7748, 'Place the downloaded RxNorm database zip file into the following directory'),
(7749, 'Place the downloaded Snomed database zip file into the following directory'),
(7750, 'Place the downloaded VALUESET database zip file into the following directory'),
(7751, 'Place your logo in sites/default/images and type the filename including gif extension here.'),
(7752, 'Placeholder'),
(7753, 'Placeholder (Maintains empty ACLs)'),
(7754, 'Placeholder (Maintains empty ACLs) (filler)'),
(7755, 'Placeholder (placeholder)'),
(7756, 'Plain Text'),
(7757, 'Plan'),
(7758, 'Plan Added Successfully'),
(7759, 'Plan Already in list_options'),
(7760, 'Plan copay if known'),
(7761, 'Plan Description'),
(7762, 'Plan Name'),
(7763, 'Plan Name Already Exists'),
(7764, 'Plan Name Already Taken'),
(7765, 'Plan Name Missing'),
(7766, 'Plan of Care'),
(7767, 'Plan of Care Type'),
(7768, 'Plan Set'),
(7769, 'Plan Status Changed'),
(7770, 'Plan Status Failed to Change'),
(7771, 'Plan Type'),
(7772, 'Plan Updated Successfully'),
(7773, 'Plan:'),
(7774, 'Planned Activity'),
(7775, 'Planned Date'),
(7776, 'Plans'),
(7777, 'Plans Configuration'),
(7778, 'Player'),
(7779, 'Playing Position'),
(7780, 'Please call if any of the above information is incorrect'),
(7781, 'Please call if any of the above information is incorrect.'),
(7782, 'Please call or message if any of the above information is incorrect.'),
(7783, 'Please call our office to schedule'),
(7784, 'Please change your password.'),
(7785, 'Please Choose a file'),
(7786, 'Please choose a patient'),
(7787, 'Please choose a valid selection from the list.'),
(7788, 'Please choose a valid selection.'),
(7789, 'Please choose a value for'),
(7790, 'Please choose date range criteria above, and click Refresh to view results.'),
(7791, 'Please choose the proper formatted EDI-271 file'),
(7792, 'Please Click download button to download the De Identified data'),
(7793, 'Please Click download button to download the Re Identified data'),
(7794, 'Please click on Openings to select a time.'),
(7795, 'Please close this window.'),
(7796, 'Please compare the new name'),
(7797, 'Please Confirm'),
(7798, 'Please consider sending in a donation to'),
(7799, 'Please contact your provider.'),
(7800, 'Please contact your providers office with the following account information'),
(7801, 'Please contact your systems administrator, the following component(s) are required but are missing.'),
(7802, 'Please correct the value(s) before proceeding!'),
(7803, 'Please create the following directory before proceeding'),
(7804, 'Please delete characters'),
(7805, 'Please do not accept this prescription unless it was received via facimile.'),
(7806, 'Please do not accept this prescription unless it was received via facsimile.'),
(7807, 'Please do NOT use your browsers stop or reload button while this page is running unless more than 10 minutes have elapsed, this will not cause the process to  stop on the server and will consume uneccesary resources.'),
(7808, 'PLEASE ENABLE CURL EXTENSION'),
(7809, 'PLEASE ENABLE OPENSSL EXTENSION'),
(7810, 'PLEASE ENABLE SOAP EXTENSION'),
(7811, 'PLEASE ENABLE XML EXTENSION'),
(7812, 'Please ensure that there is only one image file - jpeg, png or bmp in the Patient Photograph folder'),
(7813, 'Please enter a date for Last Reviewed.'),
(7814, 'Please enter a date.'),
(7815, 'Please enter a dollar amount using only numbers and a decimal point.'),
(7816, 'Please enter a due date'),
(7817, 'Please enter a enter valid range'),
(7818, 'Please enter a message'),
(7819, 'Please enter a monetary amount using only numbers and a decimal point.'),
(7820, 'Please enter a name for this key.'),
(7821, 'Please Enter a New Password'),
(7822, 'Please enter a title!'),
(7823, 'Please enter a username of 12 to 80 characters. Recommended to include symbols and numbers but not required.'),
(7824, 'Please enter a valid Direct Address above.'),
(7825, 'Please enter at least the item\'s name'),
(7826, 'Please enter at least the track\'s name'),
(7827, 'Please enter card comfirmation authorization'),
(7828, 'Please enter correct Re Identification code'),
(7829, 'Please Enter End Date greater than Begin Date!'),
(7830, 'Please enter more characters'),
(7831, 'Please Enter New Credentials'),
(7832, 'Please enter new search string'),
(7833, 'Please enter the correct Re Identification code'),
(7834, 'Please enter the password'),
(7835, 'Please fill in credit information and send for review.'),
(7836, 'Please fill out facility city properly'),
(7837, 'Please fill out facility fax properly'),
(7838, 'Please fill out facility name properly'),
(7839, 'Please fill out facility phone properly'),
(7840, 'Please fill out facility postal code properly'),
(7841, 'Please fill out facility state properly'),
(7842, 'Please fill out facility street properly'),
(7843, 'Please Fill the Check Number'),
(7844, 'Please Fill the Check/Ref Number'),
(7845, 'Please Fill the Date'),
(7846, 'Please Fill the Payment Amount'),
(7847, 'Please Fill the Payment Category'),
(7848, 'Please Fill the Payment From'),
(7849, 'Please Fill the Post To Date'),
(7850, 'Please fill them in before continuing.'),
(7851, 'Please follow up.'),
(7852, 'Please give this key a name'),
(7853, 'Please ignore this email if you did not make this request'),
(7854, 'Please indicate visit reason'),
(7855, 'Please input search criteria above, and click Submit to start report.'),
(7856, 'Please input search criteria above, and click Submit to view results.'),
(7857, 'Please input search criteria above, and click Submit to view results. (Results will be displayed in a pop up window)'),
(7858, 'Please login again.'),
(7859, 'Please note that this can take a very long time, up to several minutes, your web browser may not appear very active during this time but generating a bill is a  complicated process and your web browser is merely waiting for more information.'),
(7860, 'Please Note: constants are case sensitive and any string is allowed.'),
(7861, 'Please only use alphabetic characters'),
(7862, 'Please only use alphabetic characters with no spaces'),
(7863, 'Please pay this amount'),
(7864, 'Please place your install files in following directory'),
(7865, 'Please provide a valid e-mail address to proceed'),
(7866, 'Please provide a valid email address'),
(7867, 'Please refer to'),
(7868, 'Please reset the password.'),
(7869, 'Please restart the apache server before playing with de-identification'),
(7870, 'Please return this bottom part with your payment'),
(7871, 'Please see forum and wiki'),
(7872, 'Please see forum or wiki'),
(7873, 'Please see http://www.open-emr.org/wiki/index.php/LBV_Forms for more on this topic'),
(7874, 'Please see the attached PDF.'),
(7875, 'Please Select'),
(7876, 'Please select a format'),
(7877, 'Please select a language'),
(7878, 'Please Select a Patient.'),
(7879, 'Please select a Primary Business Entity facility with \'Tax ID\' as your facility Tax ID. If you are an individual practitioner, use your tax id. This is used for identifying you in the NewCrop system.'),
(7880, 'Please select a Primary Business Entity facility with \'Tax ID\' as your facility Tax ID. If you are an individual practitioner, use your tax id. This is used for identifying you in the NewCrop system.'),
(7881, 'Please select a procedure provider'),
(7882, 'Please Select A Recipient'),
(7883, 'Please Select a Recipient for Message.'),
(7884, 'Please select a start date and end date'),
(7885, 'Please select a valid recipient'),
(7886, 'Please Select an Active Group'),
(7887, 'Please select an adjustment reason for code'),
(7888, 'Please select an adjustment reason for code '),
(7889, 'Please select an event'),
(7890, 'Please select an item that has more data'),
(7891, 'Please select any Search Option.'),
(7892, 'Please select at least one criteria to download'),
(7893, 'Please select at least one patient.'),
(7894, 'Please select at least one prescription!'),
(7895, 'Please select encounter'),
(7896, 'Please select From date'),
(7897, 'Please select image procedure'),
(7898, 'Please select message(s) to delete'),
(7899, 'Please select the desired pages to copy or forward:'),
(7900, 'Please Select the Payment Method'),
(7901, 'Please select the prior release you are converting from'),
(7902, 'Please select To date'),
(7903, 'Please Select Type Of Payment.'),
(7904, 'Please select visit category'),
(7905, 'Please select X12 partner, required to create the 270 batch'),
(7906, 'Please set'),
(7907, 'Please set de_identification_config variable back to zero'),
(7908, 'Please set pharmacy in patient\'s chart!'),
(7909, 'Please Specify at least One Direct Address'),
(7910, 'Please start new De Identification process'),
(7911, 'Please supply a heading'),
(7912, 'Please try again or contact the providers office for further assistance.'),
(7913, 'Please upgrade OpenEMR Database to include De Identification procedures, function, tables'),
(7914, 'Please use valid NPI'),
(7915, 'Please view De Identification error log table for more details'),
(7916, 'Please visit De Identification screen after some time'),
(7917, 'Please visit Re Identification screen after some time'),
(7918, 'Please visit the screen after some time'),
(7919, 'Please wait...'),
(7920, 'Plot item'),
(7921, 'Plot selected Items'),
(7922, 'Plural'),
(7923, 'plus 1 year'),
(7924, 'plus 2 years'),
(7925, 'plus 3 years'),
(7926, 'PM'),
(7927, 'PM Program'),
(7928, 'PMH'),
(7929, 'PMH Dx'),
(7930, 'PMH{{Past Medical History}}'),
(7931, 'PMSFH Panel'),
(7932, 'PMSFH{{Abbreviation for Past medical Surgical Family and Social History}}'),
(7933, 'Pmt Method'),
(7934, 'PND'),
(7935, 'Pneumococcal Conjugate 1'),
(7936, 'Pneumococcal Conjugate 2'),
(7937, 'Pneumococcal Conjugate 3'),
(7938, 'Pneumococcal Conjugate 4'),
(7939, 'Pneumococcal Vaccine'),
(7940, 'Pneumonia Vaccination'),
(7941, 'Pneumonia Vaccination Status for Older Adults'),
(7942, 'Pneumonia Vaccination Status for Older Adults (CQM)'),
(7943, 'Podiatric'),
(7944, 'Podiatry'),
(7945, 'POH{{Past Ocular History}}'),
(7946, 'Point of Service (POS)'),
(7947, 'Policy'),
(7948, 'Policy Begin Date'),
(7949, 'Policy effective date'),
(7950, 'Policy No'),
(7951, 'Policy Number'),
(7952, 'Polish'),
(7953, 'Polydypsia'),
(7954, 'Polygon'),
(7955, 'Polyps'),
(7956, 'Polyuria'),
(7957, 'Poor Appetite'),
(7958, 'Poor Circulation'),
(7959, 'Poor Hearing'),
(7960, 'Pop Out'),
(7961, 'Pop Out Full Screen.'),
(7962, 'Pop ups need to be enabled to see these reports'),
(7963, 'Populate Fee Sheet'),
(7964, 'Populate the year view with events?'),
(7965, 'Popups'),
(7966, 'Port'),
(7967, 'Portal'),
(7968, 'Portal Account Name'),
(7969, 'Portal Activity'),
(7970, 'Portal Alerts'),
(7971, 'Portal Audits'),
(7972, 'Portal Chats'),
(7973, 'Portal Credential Information'),
(7974, 'Portal Dashboard'),
(7975, 'Portal Document Review'),
(7976, 'Portal ID'),
(7977, 'Portal ID does not match request from portal!'),
(7978, 'Portal Mail'),
(7979, 'Portal Only'),
(7980, 'Portal password is missing'),
(7981, 'Portal Payments'),
(7982, 'Portal Requests'),
(7983, 'Portal Uses Server Base Path (internal)'),
(7984, 'Portrait'),
(7985, 'Portuguese'),
(7986, 'Portuguese (Angolan)'),
(7987, 'Portuguese (Brazilian)'),
(7988, 'Portuguese (European)'),
(7989, 'POS Code'),
(7990, 'Position'),
(7991, 'Position of Gaze'),
(7992, 'Positive'),
(7993, 'Positives'),
(7994, 'Possible'),
(7995, 'Post Date'),
(7996, 'Post For'),
(7997, 'Post Item'),
(7998, 'Post Nasal Drip'),
(7999, 'Post Payment'),
(8000, 'Post Payments'),
(8001, 'Post surgical'),
(8002, 'Post to accounting and mark as billed'),
(8003, 'Post To Date'),
(8004, 'Post To Date Cannot be greater than Today'),
(8005, 'Post To Date must be greater than the financial close date.'),
(8006, 'Post To Date Must be greater than the Financial Close Date.'),
(8007, 'Post-Abortion Care'),
(8008, 'Post-Abortion Contraception'),
(8009, 'Post-Abortion Counseling'),
(8010, 'Post-Abortion Followup'),
(8011, 'Postal'),
(8012, 'Postal Code'),
(8013, 'Postal code'),
(8014, 'Postal Code and Box Number'),
(8015, 'PostCalendar'),
(8016, 'PostCalendar Administration'),
(8017, 'PostCalendar Category Settings'),
(8018, 'PostCalendar Global Settings'),
(8019, 'Postcard'),
(8020, 'POSTCARD'),
(8021, 'Postcard printed by'),
(8022, 'Postcards'),
(8023, 'Posted on'),
(8024, 'Posterior Segment'),
(8025, 'Posting'),
(8026, 'Posting Date'),
(8027, 'post{{posterior}}'),
(8028, 'Pos{{Abbreviation for Position}}'),
(8029, 'POS{{Past Ocular Surgery}}'),
(8030, 'Potential Acuity'),
(8031, 'Potential Acuity Meter'),
(8032, 'Powered by'),
(8033, 'PPE + Prev Med/Surg Hx'),
(8034, 'PQRI'),
(8035, 'PQRI Registry ID'),
(8036, 'PQRI Registry Name'),
(8037, 'Practice'),
(8038, 'Practice Default Setting'),
(8039, 'Practice Settings'),
(8040, 'Practice Settings (practice)'),
(8041, 'Practitioner'),
(8042, 'Pre Participation Assessment'),
(8043, 'Pre Pay'),
(8044, 'Pre Payment'),
(8045, 'Pre-Abortion Consultation'),
(8046, 'Pre-Abortion Counseling'),
(8047, 'Pre-payment Amount'),
(8048, 'Pref Cat'),
(8049, 'Preference'),
(8050, 'Preferences'),
(8051, 'Preferences updated successfully'),
(8052, 'Preferred Event Category'),
(8053, 'Preferred Language'),
(8054, 'Preferred Pharmacy'),
(8055, 'Preferred Provider Organization (PPO)'),
(8056, 'Preg Test'),
(8057, 'Preliminary'),
(8058, 'Preparing To Run Report'),
(8059, 'Prepay'),
(8060, 'Prepend Blank Row'),
(8061, 'Prescription'),
(8062, 'Prescription - lists the prescriptions of the current patient'),
(8063, 'prescription has reached its limit of'),
(8064, 'Prescription History'),
(8065, 'Prescription History import successfully completed'),
(8066, 'Prescription Label'),
(8067, 'Prescription Report'),
(8068, 'Prescription successfully removed.'),
(8069, 'Prescription Transmit Review'),
(8070, 'Prescriptions'),
(8071, 'Prescriptions (write,addonly optional)'),
(8072, 'Prescriptions (write,addonly optional) (rx)'),
(8073, 'Prescriptions and Dispensations'),
(8074, 'Prescriptions and other referrals'),
(8075, 'Prescriptions and/or referrals by specialist'),
(8076, 'Prescriptions Report'),
(8077, 'Prescriptions/Referrals'),
(8078, 'Present'),
(8079, 'Presenting Complaint'),
(8080, 'Presenting Issue(s)'),
(8081, 'Press Continue to proceed'),
(8082, 'Press the flashing button on the USB key within 1 minute of inserting it and click on register to register the key with OpenEMR'),
(8083, 'Press this icon to build your Impression/Plan.'),
(8084, 'Presumed Diagnosis'),
(8085, 'Presumed diagnosis by specialist'),
(8086, 'Prev'),
(8087, 'Prev Med/Surg Hx'),
(8088, 'Prev. month (hold for menu)'),
(8089, 'Prev. year (hold for menu)'),
(8090, 'Prevent Web Browser Refresh'),
(8091, 'Preventative Care'),
(8092, 'Prevention Rehab'),
(8093, 'Preventive Care and Screening: Tobacco Use: Screening and Cessation Intervention (CQM)'),
(8094, 'Preview Event'),
(8095, 'Preview file'),
(8096, 'Preview not available for this document type'),
(8097, 'Preview of'),
(8098, 'Previous'),
(8099, 'Previous Consultations'),
(8100, 'Previous Day'),
(8101, 'Previous Encounter Drawings'),
(8102, 'Previous History/Screening'),
(8103, 'Previous Month'),
(8104, 'Previous Week'),
(8105, 'Price'),
(8106, 'Price can be manually set or if already set can be altered here'),
(8107, 'Price changed'),
(8108, 'Price Discounting'),
(8109, 'Price Level'),
(8110, 'Price level changed'),
(8111, 'Price Level:'),
(8112, 'Pricelevel'),
(8113, 'Prices'),
(8114, 'Primary'),
(8115, 'Primary Business Entity'),
(8116, 'Primary Business Entity tax id is used as account id for NewCrop ePrescription. Changing the facility will affect the working in NewCrop.'),
(8117, 'Primary Business Entity tax id is used as the account id for NewCrop ePrescription.'),
(8118, 'Primary Care'),
(8119, 'Primary Care Provider'),
(8120, 'Primary Facility City'),
(8121, 'Primary Facility Country code'),
(8122, 'Primary Facility State'),
(8123, 'Primary Facility Street Address'),
(8124, 'Primary Facility Zip Code'),
(8125, 'Primary Ins'),
(8126, 'Primary Insurance'),
(8127, 'Primary Insurance Data'),
(8128, 'Primary Insurance Provider'),
(8129, 'Primary Provider'),
(8130, 'Print'),
(8131, 'Print (HTML)'),
(8132, 'Print (PDF)'),
(8133, 'Print Amendments'),
(8134, 'Print Any Encounter'),
(8135, 'Print Blank Referral Form'),
(8136, 'Print Command'),
(8137, 'Print Custom Message'),
(8138, 'Print Date'),
(8139, 'Print End of Day Report 1'),
(8140, 'Print End of Day Report 2'),
(8141, 'Print End of Day Report 3'),
(8142, 'Print Entire Listing'),
(8143, 'Print Format'),
(8144, 'Print Four Panel'),
(8145, 'Print Ledger'),
(8146, 'Print locally'),
(8147, 'Print message'),
(8148, 'Print Multiple'),
(8149, 'Print Multiple To Fax'),
(8150, 'Print name, sign and date.'),
(8151, 'Print Notes'),
(8152, 'Print Page 1'),
(8153, 'Print Page 2'),
(8154, 'Print Patient Address Label'),
(8155, 'Print Patient Billing Note'),
(8156, 'Print Receipts by Provider'),
(8157, 'Print Record'),
(8158, 'Print Record (HTML)'),
(8159, 'Print Record (PDF)'),
(8160, 'Print remotely'),
(8161, 'Print Report'),
(8162, 'Print Selected'),
(8163, 'Print Selected Statements'),
(8164, 'Print Shot Record'),
(8165, 'Print the Next Appointment on the Bottom of the Ledger'),
(8166, 'Print This Encounter'),
(8167, 'Print this form'),
(8168, 'Print this note'),
(8169, 'Print This Note'),
(8170, 'Print To'),
(8171, 'Print To Fax'),
(8172, 'Print View'),
(8173, 'printable'),
(8174, 'Printable Version'),
(8175, 'Printed'),
(8176, 'Printer'),
(8177, 'Printing Log Option'),
(8178, 'Printing results:'),
(8179, 'Printing skipped; see test output in'),
(8180, 'Printing skipped; see test output in '),
(8181, 'Prints the CMS 1500 on the Preprinted form'),
(8182, 'Prior Auth'),
(8183, 'Prior Authorization'),
(8184, 'Prior Authorization Form'),
(8185, 'Prior Exam'),
(8186, 'Prior Eye Meds'),
(8187, 'Prior IMP/PLAN'),
(8188, 'Prior Refractions'),
(8189, 'Prior Visit'),
(8190, 'Prior Visits'),
(8191, 'Priority'),
(8192, 'Priority '),
(8193, 'Prism'),
(8194, 'Prism Diopters'),
(8195, 'Prison Correctional Facility'),
(8196, 'Private'),
(8197, 'Problem'),
(8198, 'Problem DX'),
(8199, 'Problem List'),
(8200, 'Problems'),
(8201, 'Problems & Diagnoses'),
(8202, 'Problems/Issues'),
(8203, 'Proc Bat'),
(8204, 'Proc Cat'),
(8205, 'Proc Load'),
(8206, 'Proc Pending Rev'),
(8207, 'Proc Prov'),
(8208, 'Proc Res'),
(8209, 'Procedure'),
(8210, 'Procedure Body Sites'),
(8211, 'Procedure Body Sites - Arm, Buttock and Other - used for immunization - modify as needed'),
(8212, 'Procedure Boolean Results'),
(8213, 'Procedure Boolean Results - No and Yes'),
(8214, 'Procedure Code'),
(8215, 'Procedure Codes'),
(8216, 'Procedure Lateralities'),
(8217, 'Procedure Lateralities - Left, Right and Bilateral'),
(8218, 'Procedure Name'),
(8219, 'Procedure Note - 2010'),
(8220, 'Procedure Order'),
(8221, 'Procedure order'),
(8222, 'Procedure Order Details'),
(8223, 'Procedure Order for'),
(8224, 'Procedure order not found'),
(8225, 'procedure order not found in database contact tech support'),
(8226, 'Procedure Orders and Reports'),
(8227, 'Procedure Picker'),
(8228, 'Procedure provider'),
(8229, 'Procedure Provider'),
(8230, 'Procedure Provider Help'),
(8231, 'Procedure Providers'),
(8232, 'Procedure Report'),
(8233, 'Procedure Report Abnormal'),
(8234, 'Procedure Report Abnormal - No, Yes, High, Low Above upper panic limit and Below lower panic limit'),
(8235, 'Procedure Report Statuses'),
(8236, 'Procedure Report Statuses - Final, Reviewed, Preliminary, Canceled, Error and Corrected'),
(8237, 'Procedure Result Abnormal'),
(8238, 'Procedure Result Statuses'),
(8239, 'Procedure Result Statuses - Final, Preliminary, Canceled, Error, Corrected and Incomplete'),
(8240, 'Procedure Results'),
(8241, 'Procedure Routes'),
(8242, 'Procedure Routes - Injection, Oral and Other'),
(8243, 'Procedure Specimen Types'),
(8244, 'Procedure Specimen Types - Blood, Saliva, Urine and Other'),
(8245, 'Procedure Statistics Report'),
(8246, 'Procedure Test'),
(8247, 'Procedure Tier'),
(8248, 'Procedure Type'),
(8249, 'Procedure Types'),
(8250, 'Procedure Types - Group, Procedure Order, Discrete Result, Recommendation, Custom Favorite Group and Custom Favorite Item. Used in the next step - Configure the lab test structure'),
(8251, 'Procedure Units'),
(8252, 'Procedure Units - various units needed to define result values - may need to add to this list depending on the tests that are included, will vary according to need'),
(8253, 'Procedure/Service'),
(8254, 'Procedures'),
(8255, 'Proceeding to Preferences'),
(8256, 'Process'),
(8257, 'Process and Send Reminders'),
(8258, 'Process ERA File'),
(8259, 'Process New Files'),
(8260, 'Process new files for CSV records'),
(8261, 'Process Reminders'),
(8262, 'Process takes some time'),
(8263, 'Processed'),
(8264, 'Processed By'),
(8265, 'Processed Date'),
(8266, 'processed successfully'),
(8267, 'Processing'),
(8268, 'Processing and Sending Patient Reminders'),
(8269, 'Processing Details'),
(8270, 'Processing format'),
(8271, 'Processing Patient Reminders'),
(8272, 'Processing Time'),
(8273, 'Processing...'),
(8274, 'Product'),
(8275, 'Product added'),
(8276, 'Product Contraceptive Method'),
(8277, 'Product deleted'),
(8278, 'Production'),
(8279, 'Products'),
(8280, 'Products but no prescription drugs and no templates'),
(8281, 'Products Provided'),
(8282, 'Prof.'),
(8283, 'Profile'),
(8284, 'Profile Demographics'),
(8285, 'Profile Edits Red = Charted Values Blue = Patient Edits'),
(8286, 'Profiles'),
(8287, 'Prog.{{Progressive lenses}}'),
(8288, 'Progress'),
(8289, 'Progress Note - 2010'),
(8290, 'Progress Notes'),
(8291, 'Progressive'),
(8292, 'Properties'),
(8293, 'Proprietary hardware tokens'),
(8294, 'Proprietary hardware tokens are tamper proof and are not connected to the internet or any network'),
(8295, 'Prostate Cancer'),
(8296, 'Prostate Cancer Screening'),
(8297, 'Prostate Exam'),
(8298, 'Prostate Problems'),
(8299, 'Prostate w/o enlrgmt, nodules, tender'),
(8300, 'Protection Indicator'),
(8301, 'Protection Indicator Effective Date'),
(8302, 'Protocol'),
(8303, 'Protocol - consists of two parts - the method used to send orders and receive results and whether it is used to receive results only or is used to send orders and receive result i.e. bidirectional'),
(8304, 'Provide absolute path'),
(8305, 'Provide absolute path of file'),
(8306, 'Provide absolute path of following file in Path to CA Certificate File'),
(8307, 'Provide absolute path of following file in Path to CA Key File'),
(8308, 'Provide clinical summaries for patients for each office visit (New).'),
(8309, 'Provide clinical summaries for patients for each office visit.'),
(8310, 'Provide Password for'),
(8311, 'Provide patients with an electronic copy of their health information (including diagnostic test results, problem list, medication lists, medication allergies), upon request.'),
(8312, 'Provide patients with timely electronic access to their health information (including lab results, problem list, medication lists, medication allergies) within four business days of the information being available to the EP.'),
(8313, 'Provide Records to Patient for Visit'),
(8314, 'Provide TOTP code'),
(8315, 'Provide valid Email Address'),
(8316, 'Provided Clinical Summary?'),
(8317, 'Provided Education Resource(s)?'),
(8318, 'Provider'),
(8319, 'provider'),
(8320, 'Provider Access'),
(8321, 'Provider Dashboard'),
(8322, 'Provider Id'),
(8323, 'Provider ID'),
(8324, 'Provider ID at Specified Facility'),
(8325, 'Provider Matching Errors'),
(8326, 'Provider Missing Add one in Choices'),
(8327, 'provider name'),
(8328, 'Provider not available, please choose another.'),
(8329, 'Provider not available, use it anyway?'),
(8330, 'Provider Number'),
(8331, 'Provider Number (Type)'),
(8332, 'Provider Qualifier Code'),
(8333, 'Provider Relationship'),
(8334, 'Provider Type'),
(8335, 'Provider/Warehouse'),
(8336, 'Provider:'),
(8337, 'Providers'),
(8338, 'Providers NPI'),
(8339, 'Providers See Entire Calendar'),
(8340, 'PRO{{Patient Reported Outcomes}}'),
(8341, 'Prv'),
(8342, 'PSA'),
(8343, 'Psoriasis'),
(8344, 'Psych'),
(8345, 'Psych Diagnosis'),
(8346, 'Psych Medication'),
(8347, 'Psychiatric'),
(8348, 'Psychiatric Brief Letter'),
(8349, 'Psychiatric Diagnosis'),
(8350, 'Psychiatric Examination'),
(8351, 'Psychiatric Facility-Partial Hospitalization'),
(8352, 'Psychiatric History'),
(8353, 'Psychiatric Intake'),
(8354, 'Psychiatric Medication'),
(8355, 'Psychiatric Residential Treatment Center'),
(8356, 'Psych{{psychiatric}}'),
(8357, 'PSYCH{{Psychiatry}}'),
(8358, 'Pt %'),
(8359, 'Pt Debt'),
(8360, 'Pt Notes'),
(8361, 'Pt Notes/Auth'),
(8362, 'Pt overpaid'),
(8363, 'Pt paid'),
(8364, 'Pt Paid'),
(8365, 'Pt Rec Request'),
(8366, 'Pt refund'),
(8367, 'Pt released'),
(8368, 'Pt Report'),
(8369, 'PT Student, or leave blank'),
(8370, 'PT_CITY'),
(8371, 'PT_DOB'),
(8372, 'PT_EMAIL'),
(8373, 'PT_FNAME'),
(8374, 'PT_LNAME'),
(8375, 'PT_MNAME'),
(8376, 'PT_PHONE_CELL'),
(8377, 'PT_PHONE_HOME'),
(8378, 'PT_POSTAL'),
(8379, 'PT_SSN'),
(8380, 'PT_STATE'),
(8381, 'PT_STREET'),
(8382, 'Pubid'),
(8383, 'Public'),
(8384, 'Public Agency'),
(8385, 'Public Health Clinic'),
(8386, 'Public health physician'),
(8387, 'Public Health Service (PHS) or Other Federal Agency'),
(8388, 'Public Patient Id'),
(8389, 'Publicity Code'),
(8390, 'Publicity Code Effective Date'),
(8391, 'Publish'),
(8392, 'Publish Patient to FHIR Server'),
(8393, 'Pubpid'),
(8394, 'Puerto Rican'),
(8395, 'puff'),
(8396, 'Pulmonary'),
(8397, 'PULM{{Pulmonary}}'),
(8398, 'Pulse'),
(8399, 'Punjabi'),
(8400, 'Pupils'),
(8401, 'Purchase'),
(8402, 'Purchase/Return'),
(8403, 'Purchases'),
(8404, 'px'),
(8405, 'Pyschiatry'),
(8406, 'P{{Justify Header}}'),
(8407, 'Pāli'),
(8408, 'q.3h'),
(8409, 'q.4h'),
(8410, 'q.5h'),
(8411, 'q.6h'),
(8412, 'q.8h'),
(8413, 'q.d.'),
(8414, 'q.i.d.'),
(8415, 'QHD'),
(8416, 'QOE'),
(8417, 'QOH'),
(8418, 'QOH is less than monthly usage'),
(8419, 'Qty'),
(8420, 'QTY'),
(8421, 'Quality'),
(8422, 'Quality Measures (CQM)'),
(8423, 'Quantity'),
(8424, 'Quantity changed'),
(8425, 'Quantity for NDC'),
(8426, 'Quantity On Hand'),
(8427, 'quantity seems unusable'),
(8428, 'Quantity:'),
(8429, 'Quechua'),
(8430, 'Query Error'),
(8431, 'Question Mark'),
(8432, 'Queue for HCFA batch processing'),
(8433, 'Queue for HCFA batch processing and printing'),
(8434, 'Queue for UB-92 batch processing'),
(8435, 'Queue for UB-92 batch processing and printing'),
(8436, 'Queued'),
(8437, 'Queued Events Administration'),
(8438, 'Queued for'),
(8439, 'Queued for Transfer'),
(8440, 'Queued Submissions Administration'),
(8441, 'Quick Picks'),
(8442, 'Quit'),
(8443, 'Quit Alcohol'),
(8444, 'QWXGA'),
(8445, 'R'),
(8446, 'R/LG{{right/left gonioscopy}}'),
(8447, 'R/LPACH{{right/left pachymetry}}'),
(8448, 'R/LSCH1{{right/left Schirmers I (w/o anesthesia)}}'),
(8449, 'R/LSCH2{{right/left Schirmers II (w/ anesthesia)}}'),
(8450, 'R/LTBUT{{right/left Tear Break Up Time}}'),
(8451, 'RA for Patient, Encounter, or Trace'),
(8452, 'Race'),
(8453, 'Race and Ethnicity'),
(8454, 'Race/Ethnicity'),
(8455, 'RAC{{right anterior chamber}}'),
(8456, 'Radio'),
(8457, 'Radio buttons'),
(8458, 'Radio Group Master'),
(8459, 'Radio Group Member'),
(8460, 'RAD{{right adnexa}}'),
(8461, 'Random Drug Screen'),
(8462, 'Range'),
(8463, 'Rashes'),
(8464, 'Rate'),
(8465, 'Rather than granting access to each ACO individually for each user the program grants access to groups that request these privileges. These groups are called Access Request Objects (ARO).'),
(8466, 'Ratio'),
(8467, 'Raw Report'),
(8468, 'RB{{right brow}}'),
(8469, 'RCMT{{right Central Macular Thickness}}'),
(8470, 'RCOM{{right comments}}'),
(8471, 'RCUP{{right cup}}'),
(8472, 'RC{{right conjunctiva}}'),
(8473, 'RD{{retinal detachment}}'),
(8474, 'RD{{right disc}}'),
(8475, 'Re Identification'),
(8476, 'Re Identification Process is completed'),
(8477, 'Re Identification Process is ongoing'),
(8478, 'Re-identification files will be saved in'),
(8479, 'Re-Injury?'),
(8480, 'Re-Open'),
(8481, 'Re-Open Visit'),
(8482, 'Re-opened'),
(8483, 'Re-opening this visit will cause a void. Payment information will need to be re-entered. Do you want to proceed?'),
(8484, 'Reaction'),
(8485, 'Reaction - hives, nausea, shortness of breath or unassigned'),
(8486, 'Reactions'),
(8487, 'Reactivate'),
(8488, 'react{{reactivity}}'),
(8489, 'Read'),
(8490, 'Read Only'),
(8491, 'Read the help file there to understand the initial pre-configuration steps'),
(8492, 'Read these two wiki articles for customizing the Fee Sheet'),
(8493, 'Read this wiki page for more details'),
(8494, 'Read through this help file and its supporting documents before you start to configure the orders and results'),
(8495, 'Read-only from History'),
(8496, 'Real Name'),
(8497, 'Really delete'),
(8498, 'Reason'),
(8499, 'Reason Deceased'),
(8500, 'Reason for Death'),
(8501, 'Reason for Referral'),
(8502, 'Reason for referral'),
(8503, 'Reason for visit'),
(8504, 'Reason for Visit'),
(8505, 'Reason must be at least 10 characters!'),
(8506, 'Reason/Form'),
(8507, 'Reason/Plan'),
(8508, 'Recalculate'),
(8509, 'Recall'),
(8510, 'Recall Board'),
(8511, 'RECALL BOARD - Default - without MedEx Communication Service'),
(8512, 'Recall Board: Disable'),
(8513, 'Recall Campaigns'),
(8514, 'Recall only - any method'),
(8515, 'Recall only - no calls'),
(8516, 'Recall Reason'),
(8517, 'Recall Schedule'),
(8518, 'Recall to provider'),
(8519, 'Recall When'),
(8520, 'Recalls'),
(8521, 'Receipt'),
(8522, 'Receipt for Payment'),
(8523, 'Receipt Generated'),
(8524, 'Receipts by Payment Method Report'),
(8525, 'Receipts Summary'),
(8526, 'Received'),
(8527, 'Received By'),
(8528, 'Received Faxes'),
(8529, 'Received messages are processed and a new Patient Note is delivered to a specified user and appears in that user\'s Message Center'),
(8530, 'Received, not reviewed'),
(8531, 'Received, unreviewed'),
(8532, 'Receiver'),
(8533, 'Receiver ID'),
(8534, 'Receiver ID (ISA08)'),
(8535, 'Receiver ID Qualifier (ISA07)'),
(8536, 'Receiver IDs'),
(8537, 'Receiver IDs - is only required if you are submitting an electronic order to an external facility'),
(8538, 'RECEIVING A MESSAGE'),
(8539, 'Receiving Fac.'),
(8540, 'Recent three passwords are not allowed.'),
(8541, 'Recently Completed'),
(8542, 'Recipient'),
(8543, 'Recipient List Is Empty'),
(8544, 'Recipient Name'),
(8545, 'Recipient of the Disclosure'),
(8546, 'Recipient required unless status is Done'),
(8547, 'Recommend not leaving or refreshing or you may lose data.'),
(8548, 'Recommend setting the Path for Event Log Backup in Globals settings in the Miscellaneous section to something other than your tmp/temp directory.'),
(8549, 'Recommendation'),
(8550, 'Recommendation - Optional'),
(8551, 'Recommendation For Follow Up'),
(8552, 'Recommendations'),
(8553, 'Recommendations and treatment'),
(8554, 'Recommendations by specialist'),
(8555, 'Recommended setting is warn and prevent web browser refresh. Only use other settings if needed and use at own risk.'),
(8556, 'RECORD'),
(8557, 'Record'),
(8558, 'Record already exist'),
(8559, 'Record and chart changes in vital signs ( Height / Weight / BP with in scope ).'),
(8560, 'Record and chart changes in vital signs (BP out of scope).'),
(8561, 'Record and chart changes in vital signs (Height / Weight out of scope).'),
(8562, 'Record and chart changes in vital signs (New).'),
(8563, 'Record and chart changes in vital signs (SET 1).'),
(8564, 'Record and chart changes in vital signs.'),
(8565, 'Record demographics.'),
(8566, 'Record Disclosure'),
(8567, 'Record of Fitness'),
(8568, 'Record Payment'),
(8569, 'Record Request'),
(8570, 'Record Request Date'),
(8571, 'Record smoking status for patients 13 years old or older.'),
(8572, 'Records'),
(8573, 'records found'),
(8574, 'records found.'),
(8575, 'records per page'),
(8576, 'Recreational drug use'),
(8577, 'Recreational Drugs'),
(8578, 'Rectal'),
(8579, 'Rectal Exam'),
(8580, 'rectally'),
(8581, 'Rectangle'),
(8582, 'Recurrence'),
(8583, 'Recurrent Appointment Display Widget'),
(8584, 'Recurrent Appointments'),
(8585, 'Recurrent Appointments - shows all recurring appointments'),
(8586, 'Recurring appointment'),
(8587, 'Red Desaturation'),
(8588, 'Red Desat{{red desaturation}}'),
(8589, 'Red lines  indicate errors, or changes that were not applied; these must be processed manually. Currently denied claims and payment reversals are not handled automatically and so will appear in red.'),
(8590, 'Red Triangle indicates a required code that is missing'),
(8591, 'Redirect URI'),
(8592, 'Redirection'),
(8593, 'Redness'),
(8594, 'Redo'),
(8595, 'reduced:'),
(8596, 'Ref Prov'),
(8597, 'Refer'),
(8598, 'Refer By'),
(8599, 'Refer Date'),
(8600, 'Refer To'),
(8601, 'Refer to Message'),
(8602, 'Reference'),
(8603, 'Reference classification (risk level)'),
(8604, 'Reference range of results'),
(8605, 'Reference Reason'),
(8606, 'Reference this Account Id: '),
(8607, 'Reference this Account Number'),
(8608, 'Referer'),
(8609, 'Referer name and signature'),
(8610, 'Referral'),
(8611, 'Referral By'),
(8612, 'Referral Card'),
(8613, 'Referral Date'),
(8614, 'Referral Form'),
(8615, 'REFERRAL FORM'),
(8616, 'Referral ID'),
(8617, 'Referral Provider'),
(8618, 'Referral Reason'),
(8619, 'Referral Source'),
(8620, 'Referral Source for Encounters'),
(8621, 'Referral To'),
(8622, 'Referrals'),
(8623, 'Referrals Report'),
(8624, 'Referred by'),
(8625, 'Referred By'),
(8626, 'Referred By, Outcome and Destination can be left blank'),
(8627, 'Referred to'),
(8628, 'Referrer'),
(8629, 'Referrer Address'),
(8630, 'Referrer Diagnosis'),
(8631, 'Referrer diagnosis'),
(8632, 'Referrerid'),
(8633, 'Referring physician and practice'),
(8634, 'Referring provider'),
(8635, 'Referring Provider'),
(8636, 'ReFill'),
(8637, 'Refill'),
(8638, 'Refill Rx'),
(8639, 'Refills'),
(8640, 'refills'),
(8641, 'Reflexes normal'),
(8642, 'Refraction Comments'),
(8643, 'Refraction Method'),
(8644, 'Refractive States'),
(8645, 'Refresh'),
(8646, 'Refresh Screen'),
(8647, 'Refresh the Message Center or just reopen it'),
(8648, 'Refreshing Reminders'),
(8649, 'Refund'),
(8650, 'Refused'),
(8651, 'Refused To State'),
(8652, 'reg_re'),
(8653, 'regarding'),
(8654, 'regarding appointment dated'),
(8655, 'Register'),
(8656, 'register'),
(8657, 'Register Time Based One Time Password Key'),
(8658, 'Register TOTP Key for'),
(8659, 'Register U2F Key for'),
(8660, 'Register Universal 2nd Factor Key'),
(8661, 'Register your installation with OEMR to receive important notifications, such as security fixes and new release announcements.'),
(8662, 'Registered'),
(8663, 'registered'),
(8664, 'Registered email'),
(8665, 'Registered id'),
(8666, 'Registered Modules'),
(8667, 'Registered username'),
(8668, 'Registration Date'),
(8669, 'Registration error'),
(8670, 'Registration failed with error'),
(8671, 'Registration Form'),
(8672, 'Rehabilitation'),
(8673, 'Rehabilitation physician'),
(8674, 'Rejected'),
(8675, 'Relapse Potential'),
(8676, 'Relate To'),
(8677, 'Related'),
(8678, 'Related Issue'),
(8679, 'Related Patient Notes'),
(8680, 'Relation(s) / Children'),
(8681, 'Relations'),
(8682, 'Relationship'),
(8683, 'Relative ordering of this entity'),
(8684, 'Relatives'),
(8685, 'Relatives - lists the patient relatives having various medical conditions like Cancer, Diabetes, Hypertension etc'),
(8686, 'Relatives Blood Pressure'),
(8687, 'Relatives Cancer'),
(8688, 'Relatives Diabetes'),
(8689, 'Relatives Epilepsy'),
(8690, 'Relatives Heart'),
(8691, 'Relatives Mental Illness'),
(8692, 'Relatives Stroke'),
(8693, 'Relatives Suicide'),
(8694, 'Relatives Tuberculosis'),
(8695, 'Relay Health credentials are missing from this user account.'),
(8696, 'Relay Health ID'),
(8697, 'Release'),
(8698, 'Release Date'),
(8699, 'Relevant for insurance claim submission in the United States'),
(8700, 'Religion'),
(8701, 'Religious Affiliation'),
(8702, 'Religious exemption'),
(8703, 'Reload'),
(8704, 'reload names below'),
(8705, 'Relogin'),
(8706, 'Remdr'),
(8707, 'Remember grouping of tests is only for conveniently organizing the data in the Procedure Order module in openEMR, for this process to work, configuring the Procedure Orders (the tests themselves) and the Discrete Result (the place to enter and display the returned result) are critically important'),
(8708, 'Remember Me'),
(8709, 'Remember Selected Facility'),
(8710, 'Remember the dictum that Identifying codes have to be unique, you should not set up a custom grouping of a panel of tests as well have the panels setup as individual recognized panel, i.e. have CBC and Renal panel grouped as a Custom Favorite and list CBC and Renal Panel separately as individually ordered panels'),
(8711, 'Remember these Discrete Results or fruit (Tier 4)  will have to hang off the fruit bearing branch or Procedure Order namely Electrolyte Panel (Tier 3)'),
(8712, 'Reminder'),
(8713, 'Reminder Campaigns'),
(8714, 'Reminder done'),
(8715, 'Reminder intervals'),
(8716, 'Reminder Not Sent Yet'),
(8717, 'Reminder only - any method'),
(8718, 'Reminder only - no calls'),
(8719, 'Reminder Sent'),
(8720, 'Reminder Sent On'),
(8721, 'Reminder to provider'),
(8722, 'Reminder/recall - any method'),
(8723, 'Reminder/recall - no calls'),
(8724, 'Reminder/recall - to provider'),
(8725, 'Reminders'),
(8726, 'REMIT TO'),
(8727, 'Remote Host'),
(8728, 'Remote Host - is only required if you are submitting an electronic order to an external facility or just receiving results from it'),
(8729, 'Remove'),
(8730, 'Remove all rules from plan'),
(8731, 'Remove Bottom Pane'),
(8732, 'REMOVE GROUP'),
(8733, 'Remove Group'),
(8734, 'Remove Group Form'),
(8735, 'Remove multi-factor authentications for this person.'),
(8736, 'Remove Tab'),
(8737, 'Remove this Prescription from the list of RXs dispensed'),
(8738, 'Removes support for immunizations'),
(8739, 'Removes support for phpMyAdmin'),
(8740, 'Removes support for prescriptions'),
(8741, 'Removes the bottom pane by default on start up.'),
(8742, 'Removes the Chart Tracker feature'),
(8743, 'Renal Stones'),
(8744, 'Rename'),
(8745, 'Rename Group'),
(8746, 'Rendering'),
(8747, 'Rendering Provider'),
(8748, 'Rendering Provider Number'),
(8749, 'Rendering Provider Number (Type)'),
(8750, 'Reorder'),
(8751, 'Reorder At'),
(8752, 'Reorder point has been reached'),
(8753, 'Reorder point, 0 if not applicable'),
(8754, 'Rep'),
(8755, 'Repeat'),
(8756, 'Repeat New Password'),
(8757, 'Repeat password'),
(8758, 'Repeating event'),
(8759, 'Repeating Info:'),
(8760, 'Repeats'),
(8761, 'REPLACE'),
(8762, 'Replace'),
(8763, 'Replace entire code set'),
(8764, 'Replace the existing group and option values with these ones taking care to match the E/M codes'),
(8765, 'Replace the hostname and port with the values provided to you by EMR Direct'),
(8766, 'replaced'),
(8767, 'Replies'),
(8768, 'Replies from patients are displayed directly in your EHR'),
(8769, 'Replies retrieved'),
(8770, 'Reply'),
(8771, 'Reply Date'),
(8772, 'Reply From'),
(8773, 'Reply to this message'),
(8774, 'Report'),
(8775, 'report'),
(8776, 'Report - Clinical'),
(8777, 'Report - Generates and downloads the patient\'s Continuity of Care Record (CCR), Continuity of Care Document (CCD) and Patient Report'),
(8778, 'Report - Patient List Creation'),
(8779, 'Report by'),
(8780, 'Report Content'),
(8781, 'Report Date'),
(8782, 'Report End (Relinquished Care Date)'),
(8783, 'Report has been sent to the patient.'),
(8784, 'Report History/Results'),
(8785, 'Report of visit'),
(8786, 'Report Results'),
(8787, 'Report Results/History'),
(8788, 'Report Start (Assumed Care Date)'),
(8789, 'Report Status'),
(8790, 'Report Totals'),
(8791, 'Report was faxed. Click to view.'),
(8792, 'Report/ Form'),
(8793, 'Report?'),
(8794, 'Reportable'),
(8795, 'Reported'),
(8796, 'Reported Date'),
(8797, 'Reports'),
(8798, 'Reports consisting of various portions of the patient\'s medical record can be created here'),
(8799, 'Request & Response'),
(8800, 'Request Content Fails Integrity Test'),
(8801, 'Request Description'),
(8802, 'Request Eligibility'),
(8803, 'Request ID is missing!'),
(8804, 'Request ignored - claims processing is already running!'),
(8805, 'Request is not same origin!'),
(8806, 'Request Message'),
(8807, 'Request New Appointment'),
(8808, 'Request Only'),
(8809, 'Request Status'),
(8810, 'Request Type'),
(8811, 'Request type not implemented'),
(8812, 'request was received from portal patient'),
(8813, 'Requested By'),
(8814, 'Requested Date'),
(8815, 'Requested Service'),
(8816, 'Requested template does not exist'),
(8817, 'Requests Sent'),
(8818, 'Require Audit'),
(8819, 'Require Strong Passwords'),
(8820, 'Require Unique Passwords'),
(8821, 'Required'),
(8822, 'required'),
(8823, 'Required Co Pay'),
(8824, 'Required Field Missing: Please choose the EDI-271 file to upload'),
(8825, 'Required field missing: Please enter the First name'),
(8826, 'Required field missing: Please enter the Last name'),
(8827, 'Required field missing: Please enter the User Name'),
(8828, 'Required fields'),
(8829, 'Requirements'),
(8830, 'Requisition Number'),
(8831, 'Resending this report.'),
(8832, 'RESERVED'),
(8833, 'Reserved'),
(8834, 'Reserved for use to define Scheduled Vacation Time'),
(8835, 'Reserved to define when a provider may not have available appointments after.'),
(8836, 'Reserved to define when an event did not occur as specified.'),
(8837, 'Reserved todefine when a provider may haveavailable appointments after.'),
(8838, 'Reset'),
(8839, 'Reset button resets the edited claim to the fee sheet version. If subsequently saved, it will replace last claim version and be considered reviewed. Otherwise, claim is reset to fee sheet version.'),
(8840, 'Reset claim form to Fee Sheet Version'),
(8841, 'Reset Credentials'),
(8842, 'Reset Offsite Portal Credentials'),
(8843, 'Reset Online Portal Credentials'),
(8844, 'Reset Onsite Portal Credentials'),
(8845, 'Reset to no patient'),
(8846, 'Reset Version'),
(8847, 'Resident physician'),
(8848, 'Residential Substance Abuse Treatment Facility'),
(8849, 'Resist the temptation to start entering data in an unorganized manner'),
(8850, 'Resn'),
(8851, 'Resolve Orphan Results'),
(8852, 'Resolved'),
(8853, 'Resource (select one)'),
(8854, 'Resources'),
(8855, 'Respiration'),
(8856, 'Respirator effort unlabored'),
(8857, 'Respiratory'),
(8858, 'Response'),
(8859, 'Response Only'),
(8860, 'Responsible Party'),
(8861, 'Responsive Vertical Menu Style for Tabs'),
(8862, 'Restore'),
(8863, 'Restore Archive'),
(8864, 'Restrict non-authorized users to the Schedule Facilities set in User admin.'),
(8865, 'Restrict Users to Facilities'),
(8866, 'Restricted Training'),
(8867, 'Result'),
(8868, 'Result Name'),
(8869, 'Result Status'),
(8870, 'Result status or abnormality is missing'),
(8871, 'Result, use % as a wildcard'),
(8872, 'Results'),
(8873, 'Results and'),
(8874, 'Results Found For Search'),
(8875, 'Results Group'),
(8876, 'Results Only'),
(8877, 'Results Path'),
(8878, 'Results Path - is only required if you are submitting an electronic order to an external facility or just receiving results from it'),
(8879, 'Results per page'),
(8880, 'Results/Details'),
(8881, 'Resuming status checks.'),
(8882, 'Retina'),
(8883, 'Retina Default Values'),
(8884, 'Retinal Exam'),
(8885, 'Retracted Right:'),
(8886, 'Return'),
(8887, 'Return above part with your payment'),
(8888, 'Return button simply returns, then refreshes billing manager'),
(8889, 'Return Home'),
(8890, 'Return to calendar'),
(8891, 'Return To Report Results'),
(8892, 'Return to this page and you will be able to complete the ICD10 installation process by clicking on the ICD10 section header'),
(8893, 'Return to this page and you will be able to complete the ICD9 installation process by clicking on the ICD9 section header'),
(8894, 'Return to this page and you will be able to complete the RxNorm installation process by clicking on the RXNORM section header'),
(8895, 'Return to this page and you will be able to complete the Snomed installation process by clicking on the SNOMED section header'),
(8896, 'Return to this page and you will be able to complete the Valueset installation process by clicking on the VALUESET section header'),
(8897, 'Return Value'),
(8898, 'Return Visit'),
(8899, 'Returned to Play'),
(8900, 'Reuse of previous passwords not allowed!'),
(8901, 'Reuse of three previous passwords not allowed!'),
(8902, 'Revenue'),
(8903, 'Revenue Code'),
(8904, 'Revenue Code for this item. Type for hints/search'),
(8905, 'Revenue Code for this item. Type to search'),
(8906, 'Revenue Code for this item. Type to search or double click for list'),
(8907, 'Revert'),
(8908, 'Revert Edits'),
(8909, 'Review'),
(8910, 'Review & Approve'),
(8911, 'Review all the parameters that are entered and only then move to the next step. This is because once you create a group (ARO) you will NOT be able of modify any of the data that you have entered in THIS section. You can only delete the entire group (ARO) and start afresh.'),
(8912, 'Review and Approve'),
(8913, 'Review Audits'),
(8914, 'Review of PMH:'),
(8915, 'Review of System'),
(8916, 'Review of Systems'),
(8917, 'Review Of Systems'),
(8918, 'Review of Systems Checks'),
(8919, 'Review Status'),
(8920, 'Review UB04'),
(8921, 'Reviewed'),
(8922, 'Reviewed Date'),
(8923, 'Revise'),
(8924, 'Revision'),
(8925, 'Rheumatoid Arthritis'),
(8926, 'Rheumotoid Arthritis'),
(8927, 'RH{{right hertel measurement}}'),
(8928, 'Right'),
(8929, 'Right Arm'),
(8930, 'Right Deltoid'),
(8931, 'Right Ear'),
(8932, 'right ear'),
(8933, 'Right Gluteus Medius'),
(8934, 'Right Lens'),
(8935, 'Right Lower Forearm'),
(8936, 'Right Margin (mm)'),
(8937, 'Right Thigh'),
(8938, 'Right Vastus Lateralis'),
(8939, 'Right-Form Layout'),
(8940, 'Right:'),
(8941, 'Ringing in Ears'),
(8942, 'Ringing In Ears'),
(8943, 'Risk Category Assessment'),
(8944, 'Risk Factors'),
(8945, 'Risk Level'),
(8946, 'Risky Beh.'),
(8947, 'RI{{right iris}}'),
(8948, 'RK{{right cornea}}'),
(8949, 'RLL:'),
(8950, 'RLL{{right lower eyelid}}'),
(8951, 'RL{{right lens}}'),
(8952, 'RMAC{{right macula}}'),
(8953, 'RMC{{right medial canthus}}'),
(8954, 'Role'),
(8955, 'ROM'),
(8956, 'Romanian'),
(8957, 'Romansh'),
(8958, 'Room 1'),
(8959, 'Room 2'),
(8960, 'Room 3'),
(8961, 'Room Number'),
(8962, 'Roommate'),
(8963, 'Roster'),
(8964, 'ROS{{Review of Systems}}'),
(8965, 'Round and Reactive'),
(8966, 'Route'),
(8967, 'Route of administration, if applicable'),
(8968, 'Routed'),
(8969, 'Rows'),
(8970, 'RP{{right peripheral retina}}'),
(8971, 'RRR without MOR'),
(8972, 'Rub:'),
(8973, 'Rubs:'),
(8974, 'Rule'),
(8975, 'Rule Add'),
(8976, 'Rule Detail'),
(8977, 'Rule Developer'),
(8978, 'Rule Edit'),
(8979, 'Rule Funding Source'),
(8980, 'Rule Release'),
(8981, 'Rule Set'),
(8982, 'Rule Set and Plan Set selections are not consistent. Please fix and Submit again.'),
(8983, 'Rule Title'),
(8984, 'Rules'),
(8985, 'rules already in plan'),
(8986, 'Rules Configuration'),
(8987, 'RUL{{right upper eyelid}}'),
(8988, 'Run Setup again or contact support for assistance'),
(8989, 'Running Command: '),
(8990, 'Rupture'),
(8991, 'Rural Health Clinic'),
(8992, 'Russian'),
(8993, 'RVIT{{right vitreous}}'),
(8994, 'RV{{right vessels}}'),
(8995, 'Rx'),
(8996, 'RX'),
(8997, 'Rx Bottom Margin (px)'),
(8998, 'RX Date'),
(8999, 'Rx Details'),
(9000, 'Rx Dispensed History'),
(9001, 'Rx Enable DEA #'),
(9002, 'Rx Enable NPI'),
(9003, 'Rx Enable State Lic. #'),
(9004, 'Rx History'),
(9005, 'Rx html print - zend module'),
(9006, 'Rx ID'),
(9007, 'Rx Left Margin (px)'),
(9008, 'Rx Log'),
(9009, 'Rx NLM Drug-Drug'),
(9010, 'Rx Paper Size'),
(9011, 'Rx pdf - zend template'),
(9012, 'RX Print Date'),
(9013, 'Rx Right Margin (px)'),
(9014, 'Rx Show DEA #'),
(9015, 'Rx Show NPI'),
(9016, 'Rx Show State Lic. #'),
(9017, 'Rx Top Margin (px)'),
(9018, 'Rx Type'),
(9019, 'Rx Type{{Type of glasses prescription}}'),
(9020, 'Rx/Distance'),
(9021, 'RXCUI Code'),
(9022, 'RXCUI Medication'),
(9023, 'RxNorm'),
(9024, 'RxNorm Database'),
(9025, 'R{{History of Refraction}}'),
(9026, 'R{{right side}}'),
(9027, 'R{{right}}'),
(9028, 'S'),
(9029, 'S.S.'),
(9030, 'S3:'),
(9031, 'S4:'),
(9032, 'SA  *  * To read the license please read the docs/license.txt or visit  * http://www.gnu.org/copyleft/gpl.html  *  */  //========================================================================= // '),
(9033, 'Safe key database'),
(9034, 'Sale'),
(9035, 'Sales'),
(9036, 'Sales by Item'),
(9037, 'Sales by Product Report'),
(9038, 'Saliva'),
(9039, 'Same Day'),
(9040, 'Samoan'),
(9041, 'Sample'),
(9042, 'Sanction Type'),
(9043, 'Sango'),
(9044, 'Sanskrit (Samskrta)'),
(9045, 'Sanskrit (Saṁskṛta)'),
(9046, 'Sardinian'),
(9047, 'Sat'),
(9048, 'Sat &amp; Sun'),
(9049, 'Saturday'),
(9050, 'Save'),
(9051, 'SAVE'),
(9052, 'Save & Exit'),
(9053, 'Save Activity'),
(9054, 'Save and Checkout'),
(9055, 'Save and Close'),
(9056, 'Save and Continue'),
(9057, 'Save and Delete Request'),
(9058, 'Save and Dispense'),
(9059, 'Save and Print'),
(9060, 'Save and Transmit'),
(9061, 'Save as New'),
(9062, 'Save as new message'),
(9063, 'Save as new note'),
(9064, 'Save button saves claim and marks reviewed'),
(9065, 'Save Category'),
(9066, 'Save Certificate Settings'),
(9067, 'Save Changes'),
(9068, 'Save Claim'),
(9069, 'Save claim for batch processing'),
(9070, 'Save codes history'),
(9071, 'Save Completed'),
(9072, 'Save Current'),
(9073, 'Save for printing to a pre printed sheet'),
(9074, 'Save for printing with form'),
(9075, 'Save Form'),
(9076, 'Save Immunization'),
(9077, 'Save Level'),
(9078, 'Save New Field'),
(9079, 'Save New Group'),
(9080, 'Save New List'),
(9081, 'Save new template'),
(9082, 'Save omission selections'),
(9083, 'Save Patient Demographics'),
(9084, 'Save Payer'),
(9085, 'Save Report as PDF'),
(9086, 'Save Successful'),
(9087, 'Save Successful for chart ID'),
(9088, 'Save to Chart'),
(9089, 'Save Transaction'),
(9090, 'Saved Successfully'),
(9091, 'Saved to Documents->Onsite Portal->Reviewed - Open there to move or rename.'),
(9092, 'Saved to Patient Documents'),
(9093, 'Saving denied'),
(9094, 'Sa{{Saturday}}'),
(9095, 'sc Distance{{without correction distance}}'),
(9096, 'sc Near{{without correction near}}'),
(9097, 'Scan the following QR code with your preferred authenticator app to register a new TOTP key.'),
(9098, 'Scanned'),
(9099, 'Scanned Encounter Note'),
(9100, 'Scanner Directory'),
(9101, 'Scanner In'),
(9102, 'scDist{{ACT without Correction Distance}}'),
(9103, 'scDist{{without correction distance}}'),
(9104, 'Schedule'),
(9105, 'Schedule A New Appointment'),
(9106, 'Schedule Facilities:'),
(9107, 'Schedule New Appointment'),
(9108, 'Scheduled'),
(9109, 'Scheduling'),
(9110, 'Schirmer I'),
(9111, 'Schirmer II'),
(9112, 'Schirmers I'),
(9113, 'Schirmers I (w/o anesthesia)'),
(9114, 'Schirmers II'),
(9115, 'Schirmers II (w/ anesthesia)'),
(9116, 'School'),
(9117, 'SCHOOL NOTE'),
(9118, 'School Record'),
(9119, 'Sclera'),
(9120, 'scNear{{ACT without Correction Near}}'),
(9121, 'scNear{{without correction near}}'),
(9122, 'Scoliosis'),
(9123, 'Scopes'),
(9124, 'Scopes Requested'),
(9125, 'Scottish Gaelic- Gaelic'),
(9126, 'Screen'),
(9127, 'Screening / Testing'),
(9128, 'script error'),
(9129, 'Script Error: See Browser Console for Detail'),
(9130, 'SC{{Acuity without correction}}'),
(9131, 'sc{{without correction}}'),
(9132, 'SC{{without correction}}'),
(9133, 'SE'),
(9134, 'SE Address'),
(9135, 'SE City'),
(9136, 'SE Country'),
(9137, 'SE Locality'),
(9138, 'SE Postal Code'),
(9139, 'SE State'),
(9140, 'SE Zip Code'),
(9141, 'Search'),
(9142, 'SEARCH'),
(9143, 'search'),
(9144, 'search again'),
(9145, 'Search all columns'),
(9146, 'Search and select a patient and click OK'),
(9147, 'Search Appointment'),
(9148, 'Search by'),
(9149, 'Search by any demographics'),
(9150, 'Search by:'),
(9151, 'Search Diagnoses'),
(9152, 'Search for'),
(9153, 'Search for Additional Codes'),
(9154, 'Search for patient by entering whole or part of any demographics field information'),
(9155, 'Search for the drug by typing its name in the Search for Allergy text-box'),
(9156, 'Search for:'),
(9157, 'Search global settings'),
(9158, 'Search In'),
(9159, 'Search in'),
(9160, 'Search Not Available'),
(9161, 'Search or Add Patient'),
(9162, 'Search Patient By Any Demographics'),
(9163, 'Search Patient By Any Demographics, Dual additionally lets direct access to Patient Finder, Comprehensive has collapsed input box, Fixed is similar to Dual with fixed size, None is do not show'),
(9164, 'Search Payment'),
(9165, 'Search Payments'),
(9166, 'Search Products'),
(9167, 'Search Results'),
(9168, 'Search Results:'),
(9169, 'Search Selected'),
(9170, 'Search Services'),
(9171, 'Search string does not match with list in database'),
(9172, 'Search string should have at least three characters'),
(9173, 'search term was not found, please try another search'),
(9174, 'Search Text'),
(9175, 'Search the Events'),
(9176, 'Search user settings'),
(9177, 'Search with exact method'),
(9178, 'Search/Add'),
(9179, 'Search/Add Insurer'),
(9180, 'Searching'),
(9181, 'Searching for appointments'),
(9182, 'Searching...'),
(9183, 'Seatbelt'),
(9184, 'Seatbelt use'),
(9185, 'Seatbelt Use'),
(9186, 'Second'),
(9187, 'second'),
(9188, 'Second account message'),
(9189, 'Secondary'),
(9190, 'Secondary billing'),
(9191, 'Secondary Insurance'),
(9192, 'Secondary Insurance Data'),
(9193, 'Secondary Insurance Provider'),
(9194, 'Secondary Medicare Type'),
(9195, 'seconds'),
(9196, 'Section ID'),
(9197, 'Section ID and Name Cannot be Empty'),
(9198, 'Section Name'),
(9199, 'Section saved successfully'),
(9200, 'Secure Chat'),
(9201, 'Secure Electronic Messaging'),
(9202, 'Secure File Transfer Protocol, or SFTP is a network protocol that provides file access, file transfer, and file management over a secure connection'),
(9203, 'Secure Messaging'),
(9204, 'Secure Password Required'),
(9205, 'Secure Patient Chat'),
(9206, 'Secure Upload Files with White List'),
(9207, 'Security'),
(9208, 'See All'),
(9209, 'See All Messages'),
(9210, 'See Authorizations'),
(9211, 'See couchdb error log'),
(9212, 'See Customize the Fee Sheet'),
(9213, 'See Growth-Chart'),
(9214, 'See messages from the last set of generated claims'),
(9215, 'See observation results'),
(9216, 'See Setup the Fee Sheet'),
(9217, 'See the Clinical Reminders widget for more details'),
(9218, 'Seen since'),
(9219, 'Seen within'),
(9220, 'Segment name'),
(9221, 'Segments Batch Claim'),
(9222, 'Seizures'),
(9223, 'Sel'),
(9224, 'select'),
(9225, 'Select'),
(9226, 'Select \'Price Levels\' and enter Credit Card and Cash'),
(9227, 'Select a Component'),
(9228, 'Select a Context'),
(9229, 'Select a date range and click Submit'),
(9230, 'Select a lab from the Order From drop-down box'),
(9231, 'Select a patient by clicking on the patient input box'),
(9232, 'Select a percentage of the rows or or select dates'),
(9233, 'Select a surgery if it is listed in the drop-down box or enter a new surgery name under Title'),
(9234, 'Select a text or html template and upload for selected patient or all portal patients.'),
(9235, 'Select a Time Span'),
(9236, 'Select a User'),
(9237, 'Select a validation rule'),
(9238, 'Select Action'),
(9239, 'Select All'),
(9240, 'Select all'),
(9241, 'Select Amendment Date'),
(9242, 'Select amendments to print'),
(9243, 'Select an appropriate ICD/CPT code. This helps search for education material to give to the patient for that particular problem'),
(9244, 'Select as appropriate and fill in the text box and click Save'),
(9245, 'Select below to Zip Directory of image slices.'),
(9246, 'Select Bidirectional or Results Only as appropriate, again only used for electronic orders'),
(9247, 'Select Blood in the Specimen Type drop-down box'),
(9248, 'Select CAMOS Entries for Printing'),
(9249, 'Select Case'),
(9250, 'Select category'),
(9251, 'Select Code'),
(9252, 'Select Codes'),
(9253, 'Select Communication Preferences'),
(9254, 'Select corresponding checkboxes to delete'),
(9255, 'Select Credit Card Payment Gateway'),
(9256, 'Select Criteria to Remove'),
(9257, 'Select CSV table'),
(9258, 'Select Custom Favorite Group from the Procedure Tier drop-down box'),
(9259, 'Select Custom Favorite Item in the Procedure Tier drop-down box'),
(9260, 'Select Data Required for De Identification'),
(9261, 'Select data to be included in De Identified data'),
(9262, 'Select date'),
(9263, 'Select Default Codes'),
(9264, 'Select desired squad'),
(9265, 'Select Diagnosis'),
(9266, 'Select Diagnosis Codes'),
(9267, 'Select Diagnosis for De Identification request'),
(9268, 'Select Discrete Result from the Procedure Tier'),
(9269, 'Select Discrete Result from the Procedure Tier drop-down box'),
(9270, 'Select Discrete Result under Procedure Tier in the Enter Details pop-up'),
(9271, 'Select Drug'),
(9272, 'Select Drugs'),
(9273, 'Select Drugs for De Identification request'),
(9274, 'Select EDI-271 file'),
(9275, 'Select Encounter'),
(9276, 'Select field'),
(9277, 'Select Field'),
(9278, 'Select Fields'),
(9279, 'Select for printing'),
(9280, 'Select from the displayed list'),
(9281, 'Select Group'),
(9282, 'Select Group in the drop-down box labeled Procedure Tier'),
(9283, 'Select Group under Procedure Tier, think of it as creating a large branch off the main tree trunk, and call it Organ/Disease Panel'),
(9284, 'Select Image Procedure'),
(9285, 'Select Immunizations'),
(9286, 'Select Immunizations for De Identification request'),
(9287, 'Select Insurance, by typing'),
(9288, 'Select Issue'),
(9289, 'Select items'),
(9290, 'Select Lab Service in the Type drop-down box and enter a name under organization'),
(9291, 'Select Language'),
(9292, 'Select list'),
(9293, 'Select List'),
(9294, 'Select Method'),
(9295, 'Select MG/DL as Default Units'),
(9296, 'Select Month'),
(9297, 'Select One'),
(9298, 'Select one or more diagnosis codes to justify the service'),
(9299, 'Select one or more files to upload'),
(9300, 'Select only one code per problem'),
(9301, 'Select Options for Current Encounter'),
(9302, 'Select Options for Current Procedure Order Id '),
(9303, 'Select output'),
(9304, 'Select Pharmacy'),
(9305, 'SELECT PLAN'),
(9306, 'Select Primary Physician'),
(9307, 'Select Procedure Order from Procedure Tier pop-up box'),
(9308, 'Select Procedure Order in Procedure Tier'),
(9309, 'Select Providers'),
(9310, 'Select Referral from the Transaction type drop-down box'),
(9311, 'Select Requested By'),
(9312, 'Select Role'),
(9313, 'Select SMS Gateway'),
(9314, 'Select source'),
(9315, 'Select State and City to Import for Pharmacy'),
(9316, 'Select Supervisor'),
(9317, 'Select Template'),
(9318, 'Select Template Context'),
(9319, 'Select the appropriate choice - Debugging or Production'),
(9320, 'Select the appropriate radio button. Enter the search term in the search box and click \'Search\''),
(9321, 'Select the configuration items to export'),
(9322, 'Select the default font'),
(9323, 'Select the default font (need to logout/login after changing this setting).'),
(9324, 'Select the default font size'),
(9325, 'Select the default font size (need to logout/login after changing this setting).'),
(9326, 'Select the diagnoses to include in the Impression/Plan.'),
(9327, 'Select the group (ARO) that you wish to remove.'),
(9328, 'Select the issue primarily responsible for any missed events on this day'),
(9329, 'Select the Lab From lab name'),
(9330, 'Select the message type to more accurately reflect the type of message you are sending. You may choose to leave it as unassigned'),
(9331, 'Select the name of the entity from the Name drop-down box'),
(9332, 'Select the type of Occurrence of the problem from the drop-down box, the choices are Unknown or N/A, First, Early Recurrence, Late Recurrence, Delayed Recurrence, Chronic/Recurrent and Acute on Chronic'),
(9333, 'Select to print patient address labels from popups in left nav screen.'),
(9334, 'Select to transmit'),
(9335, 'Select Track'),
(9336, 'Select Transaction Type'),
(9337, 'Select Type'),
(9338, 'Select User'),
(9339, 'SELECT Users FROM The Dropdown LIST'),
(9340, 'Select Users From The Dropdown List'),
(9341, 'Select which languages, if any, may be chosen at login. (only pertinent if above All Languages Allowed is turned off)'),
(9342, 'Select Year'),
(9343, 'Select Yes to confirm group deletion'),
(9344, 'Select your current facility in the login page'),
(9345, 'Select/Add Authentication Method for the logged in user'),
(9346, 'Select/Add New Authentication Method for'),
(9347, 'Select1'),
(9348, 'Select2'),
(9349, 'Selected'),
(9350, 'Selected Encounter'),
(9351, 'Selected Fee Sheet Codes and Charges for Current Encounter'),
(9352, 'Selected Files'),
(9353, 'Selected files and data will be removed from folders and tables'),
(9354, 'Selecting the width for responsive vertical style menus in tab based layout (need to logout/login after changing this setting)'),
(9355, 'Selecting this will create a message that needs to be processed by each recipient individually (this is not a group task).'),
(9356, 'Seleted Message id'),
(9357, 'Self'),
(9358, 'Self Pay'),
(9359, 'SEND'),
(9360, 'Send'),
(9361, 'Send A Dated Reminder'),
(9362, 'Send a Reminder'),
(9363, 'Send an email to '),
(9364, 'Send CCD'),
(9365, 'Send CCR'),
(9366, 'Send Complete - Prescription(s) Return Status'),
(9367, 'Send Emails'),
(9368, 'Send for Review'),
(9369, 'Send in progress'),
(9370, 'Send It'),
(9371, 'Send Message'),
(9372, 'Send message'),
(9373, 'Send message from the permanent group therapist to the personal therapist'),
(9374, 'Send message from the permanent group therapist to the personal therapist (gm)'),
(9375, 'Send NewRx'),
(9376, 'Send Notes'),
(9377, 'Send Payment'),
(9378, 'Send Reminders Batch'),
(9379, 'Send reminders to patients per patient preference for preventive/follow up care.'),
(9380, 'Send Request'),
(9381, 'Send Selected to Archive'),
(9382, 'Send Selected to Trash'),
(9383, 'Send Summaries with Referrals'),
(9384, 'Send this file'),
(9385, 'Send This Message'),
(9386, 'Send to'),
(9387, 'Send To'),
(9388, 'SEND TO'),
(9389, 'Send to all'),
(9390, 'Send to Archive'),
(9391, 'Send To HIE failed'),
(9392, 'Send to portal'),
(9393, 'Send to Portal'),
(9394, 'Send to Trash'),
(9395, 'Sender'),
(9396, 'Sender ID'),
(9397, 'Sender ID (ISA06)'),
(9398, 'Sender ID Qualifier (ISA05)'),
(9399, 'Sender IDs'),
(9400, 'Sender IDs - is only required if you are submitting an electronic order to an external facility'),
(9401, 'sender name'),
(9402, 'SENDING A MESSAGE'),
(9403, 'Sending application name will be provided by the facility that you will be connecting to'),
(9404, 'Sending facility name is user defined'),
(9405, 'Sending Invoice to Patient Portal Completed'),
(9406, 'Sending To'),
(9407, 'Sensitivities'),
(9408, 'Sensitivities (sensitivities)'),
(9409, 'Sensitivity'),
(9410, 'Sensitivity - lets you limit the information in this encounter to those with appropriate privileges'),
(9411, 'Sensitivity:'),
(9412, 'Sensory exam normal'),
(9413, 'Sent'),
(9414, 'Sent - Confirmed'),
(9415, 'Sent By, Leave Blank For All'),
(9416, 'Sent by:'),
(9417, 'Sent Date'),
(9418, 'Sent Items'),
(9419, 'Sent Medical Records?'),
(9420, 'Sent successfully'),
(9421, 'Sent Summary of Care Electronically?'),
(9422, 'Sent Summary of Care?'),
(9423, 'sent to printer.'),
(9424, 'Sent To, Leave Blank For All'),
(9425, 'Sent to:'),
(9426, 'Sent, but delivery not yet confirmed.'),
(9427, 'Sent, not received'),
(9428, 'Sent{{Mails}}'),
(9429, 'Sep'),
(9430, 'Separated'),
(9431, 'September'),
(9432, 'Seq'),
(9433, 'Sequence'),
(9434, 'Serbian'),
(9435, 'Serv Rep'),
(9436, 'Server error: try again later'),
(9437, 'Server Login'),
(9438, 'Server may be offline'),
(9439, 'Server message:'),
(9440, 'Server says thanks. Images state saved.'),
(9441, 'Server Status'),
(9442, 'Service'),
(9443, 'Service added'),
(9444, 'Service Category'),
(9445, 'Service Code'),
(9446, 'Service Code Finance Reporting'),
(9447, 'Service Codes'),
(9448, 'Service Date'),
(9449, 'Service Date From'),
(9450, 'Service Date To'),
(9451, 'Service Date:'),
(9452, 'Service deleted'),
(9453, 'Service Facility'),
(9454, 'Service is not compatible with the sex of this client.'),
(9455, 'Service Location'),
(9456, 'Service Name'),
(9457, 'Service provided by specialist'),
(9458, 'Service provider changed'),
(9459, 'Service Reporting'),
(9460, 'Service Reporting Only'),
(9461, 'Services'),
(9462, 'Services by Category'),
(9463, 'Services Provided'),
(9464, 'Services provided'),
(9465, 'Services/Products'),
(9466, 'Session Type'),
(9467, 'Set'),
(9468, 'Set a facility cookie to remember the selected facility between logins.'),
(9469, 'Set As Completed'),
(9470, 'SET AS COMPLETED'),
(9471, 'Set aside some uninterrupted time for the data entry'),
(9472, 'Set Gateway to Production Mode'),
(9473, 'Set POS code in encounter'),
(9474, 'Set Price Level'),
(9475, 'Set processing priority for CDR engine based reports.'),
(9476, 'Set processing priority for creation of Patient Reminders (in full clinic mode).'),
(9477, 'Set the priority level'),
(9478, 'Set this to the full absolute path. For creating client SSL certificates for HTTPS.'),
(9479, 'Set To'),
(9480, 'Set to Default'),
(9481, 'Set to the number of prior passwords that are not allowed to use when changing a password.'),
(9482, 'set value to'),
(9483, 'Set which radio button is selected by default in \'Search for Additional Codes\' section'),
(9484, 'Sets the font of the address text on the envelope in mm'),
(9485, 'Setting'),
(9486, 'Setting the version number in the database...'),
(9487, 'Setting up 2FA'),
(9488, 'Settings'),
(9489, 'Setup MedEx'),
(9490, 'Setup the Fee Sheet'),
(9491, 'Several additional drop-down and text boxes will be visible'),
(9492, 'Severe'),
(9493, 'Severe Migraine'),
(9494, 'Severity'),
(9495, 'Severity information will be missing if interaction is found'),
(9496, 'Severity of Pain'),
(9497, 'Severity of Pain:'),
(9498, 'Sex'),
(9499, 'Sexually Transmitted Disease'),
(9500, 'SFTP'),
(9501, 'SFTP will send the order as a HL7v2.3 message to the receiving lab using the SFTP protocol'),
(9502, 'Sha-1 Hash'),
(9503, 'Sharing'),
(9504, 'Shell command for printing from the server.'),
(9505, 'Shift'),
(9506, 'Shona'),
(9507, 'Short Description'),
(9508, 'Shorthand'),
(9509, 'Shorthand Help'),
(9510, 'Shortness of Breath'),
(9511, 'Shortness Of Breath'),
(9512, 'Shortness Of Breath 2'),
(9513, 'Shot Record'),
(9514, 'Shot Record as of:'),
(9515, 'Should be Enabled'),
(9516, 'should be like nnnnn-nnnn-nn'),
(9517, 'Should be two letters'),
(9518, 'should contain 10 digits'),
(9519, 'should contain only 10 digits'),
(9520, 'Shoulder'),
(9521, 'Shoulder + clavicle'),
(9522, 'Shoulder Problems'),
(9523, 'Show'),
(9524, 'Show Active'),
(9525, 'Show Additional Insurance Information'),
(9526, 'Show Aging on Custom Statement'),
(9527, 'Show All'),
(9528, 'Show all payment history in Patient Ledger'),
(9529, 'Show all procedures'),
(9530, 'Show All Results'),
(9531, 'Show All Transactions'),
(9532, 'Show as Busy'),
(9533, 'Show Authorized Only'),
(9534, 'Show Available Times'),
(9535, 'Show both US and metric (main unit is metric)'),
(9536, 'Show both US and metric (main unit is US)'),
(9537, 'Show button for download fax template'),
(9538, 'Show button in the prescription list for download fax template'),
(9539, 'Show Current Signature On File'),
(9540, 'Show Details'),
(9541, 'Show Diagnoses Section'),
(9542, 'Show Errors Only?'),
(9543, 'Show Extra Logo on Login'),
(9544, 'Show Graph'),
(9545, 'Show Help Modal'),
(9546, 'Show hovering event text on mouseover?'),
(9547, 'Show how many events on admin pages?'),
(9548, 'Show Inactive'),
(9549, 'Show Insurance Address Information in the Insurance Panel of Demographics.'),
(9550, 'Show IOP by Date'),
(9551, 'Show IOP by Time'),
(9552, 'Show Menu'),
(9553, 'Show metric only'),
(9554, 'Show Mini Logo 1'),
(9555, 'Show Mini Logo 2'),
(9556, 'Show Notes'),
(9557, 'Show only latest values reported for each result code'),
(9558, 'Show only procedures not omitted'),
(9559, 'Show Patient Encounter Number in Patient Flow Board'),
(9560, 'Show Patient ID in Patient Flow Board'),
(9561, 'Show Patient Notes'),
(9562, 'Show pounds and ounces'),
(9563, 'Show pounds as decimal value'),
(9564, 'Show Primary Complete'),
(9565, 'Show Products Section'),
(9566, 'Show Receipt'),
(9567, 'Show records'),
(9568, 'Show Reminders'),
(9569, 'Show Report'),
(9570, 'Show search/submit links in block?'),
(9571, 'Show Selected for Drug Screens'),
(9572, 'Show Services Section'),
(9573, 'Show Status of Drug Screens'),
(9574, 'Show the custom state form for the add list widget (will ask for title and abbreviation).'),
(9575, 'Show the Impression/Plan Builder panel'),
(9576, 'Show the last three Refractions'),
(9577, 'Show this category on the patient summary screen even if no issues have been entered for this category.'),
(9578, 'Show Title on Login'),
(9579, 'Show track history'),
(9580, 'Show Unbilled Only'),
(9581, 'Show US only'),
(9582, 'Show Visit Reason in Patient Flow Board'),
(9583, 'show/hide executed query log'),
(9584, 'Show/Hide the Selection Area'),
(9585, 'Showing'),
(9586, 'Showing 0 to 0 of 0 entries'),
(9587, 'Showing items'),
(9588, 'Showing page'),
(9589, 'Showing result'),
(9590, 'Shows the hierarchal level of this line'),
(9591, 'Shutting Down Service ...'),
(9592, 'Sibling'),
(9593, 'Sibling History'),
(9594, 'Sibling in-law'),
(9595, 'Siblings'),
(9596, 'Sickle Cell'),
(9597, 'Sig'),
(9598, 'Sigmoid/Colonoscopy'),
(9599, 'Sign'),
(9600, 'Sign In'),
(9601, 'Sign Lab Results (write,addonly optional)'),
(9602, 'Sign Lab Results (write,addonly optional) (sign)'),
(9603, 'Sign Results'),
(9604, 'Sign-up'),
(9605, 'Sign-up successful for'),
(9606, 'Signature'),
(9607, 'Signature on File'),
(9608, 'Signature On File'),
(9609, 'Signature:'),
(9610, 'Signed'),
(9611, 'Signed Date'),
(9612, 'Signed Rx'),
(9613, 'Significant Other'),
(9614, 'Significant Swelling:'),
(9615, 'Simplified'),
(9616, 'Simplified Co-Pay'),
(9617, 'Simplified Demographics'),
(9618, 'Simplified Prescriptions'),
(9619, 'Since'),
(9620, 'Sincerely,'),
(9621, 'Sindhi'),
(9622, 'Single'),
(9623, 'Single Tests'),
(9624, 'Single-selection list'),
(9625, 'Single-selection list with ability to add to the list'),
(9626, 'Singular'),
(9627, 'Sinhala'),
(9628, 'Sinhala, Sinhalese'),
(9629, 'Sinus Problems'),
(9630, 'Sinus Surgery'),
(9631, 'SINUS TENDERNESS:'),
(9632, 'Sinusitis'),
(9633, 'Sister'),
(9634, 'Site'),
(9635, 'Site Address (required for OAuth2 and FHIR)'),
(9636, 'Site Address (required for OAuth2 and FHIR). Example is'),
(9637, 'Site ID'),
(9638, 'Site ID for the Medical Information Integration, LLC Lab Exchange Service.'),
(9639, 'Site ID for the OpenEMR Support LLC Lab Exchange Service.'),
(9640, 'Site Worker'),
(9641, 'Six Months Ago'),
(9642, 'Six Months Ahead'),
(9643, 'Size'),
(9644, 'size'),
(9645, 'Size Height'),
(9646, 'Size must be a number between 1 and 999'),
(9647, 'Size Width'),
(9648, 'Size/List'),
(9649, 'Skilled Nursing Facility'),
(9650, 'Skin'),
(9651, 'Skin Cancer'),
(9652, 'Skin Disease'),
(9653, 'Skin Other'),
(9654, 'Skip Authorization of Patient Notes'),
(9655, 'Skipping illegal layout name'),
(9656, 'Skipping illegal list name'),
(9657, 'Skipping missing layout name'),
(9658, 'Skipping missing list name'),
(9659, 'Skipping section'),
(9660, 'Skipping SQL-Ledger dump - not implemented for Windows server'),
(9661, 'Sl.No'),
(9662, 'Slab Off'),
(9663, 'Sleep'),
(9664, 'Sleep patterns'),
(9665, 'Sleep Patterns'),
(9666, 'Sleeping'),
(9667, 'Sliding'),
(9668, 'Slovak'),
(9669, 'Slovene'),
(9670, 'Sm debt w/o'),
(9671, 'Smart App'),
(9672, 'SMART apps that display on the patient summary page can be enabled or disabled from this screen. Any OAUTH2 client requesting the \'launch\' scope will allow EMR users to launch an app from within the EHR.'),
(9673, 'SMART Enabled Apps'),
(9674, 'Smartphones can have authenticator apps that can calculate OTP using either time based or algorithm based approaches and is a common method of OTP delivery'),
(9675, 'Smarty Cache has been cleared'),
(9676, 'Smoker, current status unknown'),
(9677, 'Smoking'),
(9678, 'Smoking Status'),
(9679, 'SMS'),
(9680, 'SMS Auth'),
(9681, 'SMS based delivery of OTP is easy to implement with no additional steps needed by the user'),
(9682, 'SMS Confirmed'),
(9683, 'SMS Gateway'),
(9684, 'SMS Gateway API key'),
(9685, 'SMS Gateway API Key'),
(9686, 'SMS Gateway Password'),
(9687, 'SMS Gateway Username'),
(9688, 'SMS Messages'),
(9689, 'SMS Notification'),
(9690, 'SMS Notification Hours'),
(9691, 'SMS Notification Settings Updated Successfully'),
(9692, 'SMS OK'),
(9693, 'SMS send before'),
(9694, 'SMS Sent'),
(9695, 'SMS Text Usable Tags'),
(9696, 'SMS Text Usable Tags:'),
(9697, 'SMS Text, Usable Tag: ***NAME***, ***PROVIDER***, ***DATE***, ***STARTTIME***, ***ENDTIME***<br> i.e. Dear ***NAME***'),
(9698, 'SMS Text, Usable Tags: '),
(9699, 'SMS Zone'),
(9700, 'SMS zone - This section lets use send and receive SMS texts'),
(9701, 'SMS/Email Alert Settings'),
(9702, 'SMS/Email Alert Settings Updated Successfully'),
(9703, 'SMTP Password for Authentication'),
(9704, 'SMTP Security Protocol'),
(9705, 'SMTP security protocol to connect with. Required by some servers such as gmail.'),
(9706, 'SMTP Server Hostname'),
(9707, 'SMTP Server Port Number'),
(9708, 'SMTP User for Authentication'),
(9709, 'SNOMED'),
(9710, 'SNOMED (RF1) Clinical Term'),
(9711, 'SNOMED (RF1) Diagnosis'),
(9712, 'SNOMED (RF1) Procedure'),
(9713, 'SNOMED (RF2) Clinical Term'),
(9714, 'SNOMED (RF2) Diagnosis'),
(9715, 'SNOMED (RF2) Procedure'),
(9716, 'SNOMED Clinical Term'),
(9717, 'SNOMED Database'),
(9718, 'SNOMED Diagnosis'),
(9719, 'SNOMED Procedure'),
(9720, 'SNOMED-CT Code'),
(9721, 'Snoring'),
(9722, 'SOAP'),
(9723, 'Soap Import Status'),
(9724, 'Soc Hx{{Social History}}'),
(9725, 'Social'),
(9726, 'Social Difficulties'),
(9727, 'Social History'),
(9728, 'Social History Element'),
(9729, 'Social History:'),
(9730, 'Social Security Number'),
(9731, 'Social Security(Optional)'),
(9732, 'solution'),
(9733, 'Somali'),
(9734, 'Somatic Context'),
(9735, 'Some authorizations were not displayed. Click here to view all'),
(9736, 'Some codes were not displayed.'),
(9737, 'Some encounters were not displayed. Click here to view all.'),
(9738, 'Some error has occured during De Identification Process'),
(9739, 'Some global parameters on the setup and printing of the generated claims can be set in Adminstration > Globals > Billing'),
(9740, 'Some notes were not displayed.'),
(9741, 'Some office notes were not displayed. Click here to view all.'),
(9742, 'Some smaller local labs may agree to deal directly with the practice'),
(9743, 'some words'),
(9744, 'Someone else has just changed this visit. Please cancel this page and try again.'),
(9745, 'Something went wrong'),
(9746, 'Something went wrong.'),
(9747, 'Something went wrong. Please try again.'),
(9748, 'Soon Due Interval (Clinical Reminders)'),
(9749, 'Soon Due Interval (Patient Reminders)'),
(9750, 'Sore Throat'),
(9751, 'Sorry No Appointment is Fixed'),
(9752, 'Sorry you are not privileged enough. Enrollment is limited to Adminstrator accounts.'),
(9753, 'Sorry! Not Authorized.'),
(9754, 'Sorry, there was a problem uploading your file'),
(9755, 'Sorry, there was a problem!'),
(9756, 'Sorry. Can not update history.'),
(9757, 'Sort alphabetically'),
(9758, 'Sort by'),
(9759, 'Sort By'),
(9760, 'Sort by Category'),
(9761, 'Sort by Checksum'),
(9762, 'Sort by Comments'),
(9763, 'Sort by Crt User'),
(9764, 'Sort by date'),
(9765, 'Sort by date/time'),
(9766, 'Sort by Event'),
(9767, 'Sort by Group'),
(9768, 'Sort by New Checksum'),
(9769, 'Sort by Old Checksum'),
(9770, 'Sort by PatientID'),
(9771, 'Sort by seq'),
(9772, 'Sort by Success'),
(9773, 'Sort by Tamper date/time'),
(9774, 'Sort by User'),
(9775, 'Sort by vaccine'),
(9776, 'Sort Down'),
(9777, 'Sort Result by'),
(9778, 'Sort Up'),
(9779, 'Source'),
(9780, 'Source CSV File'),
(9781, 'Source File'),
(9782, 'Source File Path'),
(9783, 'Source is missing for code '),
(9784, 'Source Lot'),
(9785, 'Source of the document'),
(9786, 'Source Patient'),
(9787, 'Source patient has no DOB'),
(9788, 'Source patient not found'),
(9789, 'Source:'),
(9790, 'South Ndebele'),
(9791, 'Southern Sotho'),
(9792, 'Space'),
(9793, 'SPACE'),
(9794, 'Span Entire Row'),
(9795, 'Spanish'),
(9796, 'Spanish (Latin American)'),
(9797, 'Spanish (Spain)'),
(9798, 'Spanish- Castilian'),
(9799, 'Special characters are not allowed'),
(9800, 'Special treatment for the Vitals form'),
(9801, 'Specialist'),
(9802, 'Specialist name and signature'),
(9803, 'Specialized physician'),
(9804, 'Specialty'),
(9805, 'Specialty Systems'),
(9806, 'Specialty:'),
(9807, 'Specific'),
(9808, 'Specific Application'),
(9809, 'Specific Contraceptive Service'),
(9810, 'Specific Result'),
(9811, 'Specific Service'),
(9812, 'Specified'),
(9813, 'Specifies formatting for codes. # = digit, * = any character. Empty if not used.'),
(9814, 'Specifies formatting for codes. # = digit, @ = alpha, * = any character. Empty if not used.'),
(9815, 'Specifies formatting for invoice reference numbers.  # = digit, * = any character.  Empty if not used.'),
(9816, 'Specifies formatting for invoice reference numbers.  # = digit, @ = alpha, * = any character.  Empty if not used.'),
(9817, 'Specifies formatting for product NDC fields.  # = digit, * = any character.  Empty if not used.'),
(9818, 'Specifies formatting for product NDC fields.  # = digit, @ = alpha, * = any character.  Empty if not used.'),
(9819, 'Specifies formatting for the external patient ID.  # = digit, * = any character.  Empty if not used.'),
(9820, 'Specifies formatting for the external patient ID.  # = digit, @ = alpha, * = any character.  Empty if not used.'),
(9821, 'Specify the interval for automatic message checking, 5 or 10 minutes as a starting point'),
(9822, 'Specify the OpenEMR user who will receive notification of new incoming Direct messages'),
(9823, 'Specimen'),
(9824, 'Specimen number/identifier'),
(9825, 'Specimen Type'),
(9826, 'Specimen type'),
(9827, 'Speech Dictation'),
(9828, 'Spermicides'),
(9829, 'Sph{{Sphere}}'),
(9830, 'SPH{{Sphere}}'),
(9831, 'Splenectomy'),
(9832, 'Spouse'),
(9833, 'Spouses History'),
(9834, 'Sputum'),
(9835, 'Sputum:'),
(9836, 'SQ'),
(9837, 'sql'),
(9838, 'SQL-Ledger'),
(9839, 'Squad'),
(9840, 'Squad Membership'),
(9841, 'Squads'),
(9842, 'Squads (squads)'),
(9843, 'SRH'),
(9844, 'SRH - Family Planning'),
(9845, 'SRH Non Family Planning'),
(9846, 'SRH Referrals'),
(9847, 'SRH Visit Form'),
(9848, 'Srv Date'),
(9849, 'SS'),
(9850, 'SSL Certificate Administration'),
(9851, 'SSN'),
(9852, 'Stability'),
(9853, 'Stack Trace'),
(9854, 'Staged Releases'),
(9855, 'Standard'),
(9856, 'Standard check'),
(9857, 'Standard Code'),
(9858, 'Standard Code (LOINC)'),
(9859, 'Standard Error Logging'),
(9860, 'Standard Measures'),
(9861, 'Standard Measures (Active Alerts)'),
(9862, 'Standard Measures (Passive Alerts)'),
(9863, 'Standard Measures (Patient Reminders)'),
(9864, 'Standard Name'),
(9865, 'Standard; Simplified: only title, start date, comments and an Active checkbox;no diagnosis, occurrence, end date, referred-by or sports fields. ; Football Injury'),
(9866, 'Start'),
(9867, 'Start (yyyy-mm-dd): '),
(9868, 'Start Another Report'),
(9869, 'Start Assessment'),
(9870, 'Start Batch Processing'),
(9871, 'Start by clicking on Add Top Level to bring up the Enter Details pop-up box in the Add Mode'),
(9872, 'Start by clicking on the black plus sign at the end of the Serum Chemistry line to bring up the Enter Details pop-up'),
(9873, 'Start by clicking the Browse button and selecting the file to upload, and then clicking \'Upload\' to perform the upload and display the corresponding invoices. In this case the other parameters mentioned above do not apply and will be ignored. Uploading saves the file but does not yet process its contents -- that is done separately as described below.'),
(9874, 'Start Date'),
(9875, 'Start date'),
(9876, 'Start Date at This Clinic'),
(9877, 'Start Date should not be greater than End Date'),
(9878, 'Start date:'),
(9879, 'Start Date:'),
(9880, 'Start entering the data in an orderly manner, tier by tier, one top order group at a time'),
(9881, 'Start Time'),
(9882, 'Start watching server processes for upgrade version'),
(9883, 'Starting date'),
(9884, 'Starting Date'),
(9885, 'Starting date for search'),
(9886, 'Starting Date From'),
(9887, 'Starting Date To'),
(9888, 'stat'),
(9889, 'State'),
(9890, 'State Data Type'),
(9891, 'State Lic. #'),
(9892, 'State License Number'),
(9893, 'State list'),
(9894, 'State List (write,addonly optional)'),
(9895, 'State List (write,addonly optional) (state)'),
(9896, 'State List Widget Custom Fields'),
(9897, 'State Or Province'),
(9898, 'State/Locality'),
(9899, 'State/Parish'),
(9900, 'State:'),
(9901, 'Statement Appearance'),
(9902, 'Statement Logo GIF Filename'),
(9903, 'STATEMENT SUMMARY'),
(9904, 'statements and updating invoices.'),
(9905, 'Statements Sent'),
(9906, 'Statements Sent:'),
(9907, 'statements; invoices will not be updated.'),
(9908, 'Static Text'),
(9909, 'Statistics'),
(9910, 'Stats'),
(9911, 'Status'),
(9912, 'Status in the group'),
(9913, 'Status in the meeting'),
(9914, 'Status Of Admission'),
(9915, 'Status of Claim'),
(9916, 'Status quo'),
(9917, 'Status Type'),
(9918, 'STD/AIDS Couns'),
(9919, 'Stength and Conditioning'),
(9920, 'Step Child'),
(9921, 'Step Parent'),
(9922, 'Step Sibling'),
(9923, 'Stepchild'),
(9924, 'Steps for uploading CCR XML'),
(9925, 'Steps to install the DSM IV database'),
(9926, 'Steps to install the ICD 10 database'),
(9927, 'Steps to install the ICD 9 database'),
(9928, 'Steps to install the RxNorm database'),
(9929, 'Steps to install the Snomed database'),
(9930, 'Steps to install the VALUSET database'),
(9931, 'Stereopsis'),
(9932, 'Stiff Joints'),
(9933, 'Stiffness'),
(9934, 'Still Loading...'),
(9935, 'Stock Months'),
(9936, 'Stomach Pains'),
(9937, 'Stop'),
(9938, 'STOP'),
(9939, 'Stopping activity status checks. Internal Server Error'),
(9940, 'Stopping status checks. Csrf Error. No harm to upgrade and will continue.'),
(9941, 'Store your safe key at settings globals in security tab'),
(9942, 'Stored Hash'),
(9943, 'Strabismus'),
(9944, 'Strain of muscle'),
(9945, 'Streak'),
(9946, 'Stream'),
(9947, 'Street'),
(9948, 'Street Address'),
(9949, 'Street and Number'),
(9950, 'Strength'),
(9951, 'Strength and Conditioning'),
(9952, 'Strep Throat'),
(9953, 'Stress fracture'),
(9954, 'Stress Test'),
(9955, 'Stripe'),
(9956, 'Stroke'),
(9957, 'stroke'),
(9958, 'Strong password means at least 8 characters, and at least three of: a number, a lowercase letter, an uppercase letter, a special character.'),
(9959, 'Strong password means at least one of each: a number, a lowercase letter, an uppercase letter, a special character.'),
(9960, 'Style'),
(9961, 'Style of form used for adding new patients'),
(9962, 'Style your messsage and/or add Image/Video'),
(9963, 'Stylings'),
(9964, 'Sub Group'),
(9965, 'Sub-category'),
(9966, 'Sub-Total'),
(9967, 'Subcategory'),
(9968, 'subcategory'),
(9969, 'subcutaneously'),
(9970, 'Subject'),
(9971, 'Subjective'),
(9972, 'Sublingual'),
(9973, 'sublingual'),
(9974, 'Submit'),
(9975, 'submit'),
(9976, 'Submit All Content'),
(9977, 'Submit and Delete Request'),
(9978, 'Submit Changes For All Appts At Once'),
(9979, 'Submit Event'),
(9980, 'submit form'),
(9981, 'Submit Payment for Authorization'),
(9982, 'Submit Selected Content'),
(9983, 'Submitted'),
(9984, 'submitted'),
(9985, 'Submitted by'),
(9986, 'Submitter EDI Access Number (PER06)'),
(9987, 'Subscriber'),
(9988, 'Subscriber Address'),
(9989, 'Subscriber City'),
(9990, 'Subscriber Country'),
(9991, 'Subscriber Date of Birth'),
(9992, 'Subscriber Employer'),
(9993, 'Subscriber Employer (SE)'),
(9994, 'Subscriber Employer Address'),
(9995, 'Subscriber Employer City'),
(9996, 'Subscriber Employer Country'),
(9997, 'Subscriber Employer State'),
(9998, 'Subscriber Employer Street'),
(9999, 'Subscriber Employer Zip'),
(10000, 'Subscriber Employer Zip Code'),
(10001, 'Subscriber First Name'),
(10002, 'Subscriber Last Name'),
(10003, 'Subscriber Member'),
(10004, 'Subscriber Middle Name'),
(10005, 'Subscriber Phone'),
(10006, 'Subscriber Relationship'),
(10007, 'Subscriber relationship is not self but name is the same! Is this really OK?'),
(10008, 'Subscriber relationship is not self but SS number is the same!'),
(10009, 'Subscriber relationship is self but name is different! Is this really OK?'),
(10010, 'Subscriber relationship is self but SS number is different!'),
(10011, 'Subscriber Sex'),
(10012, 'Subscriber SS'),
(10013, 'Subscriber State'),
(10014, 'Subscriber Zip'),
(10015, 'Subscriber/Policy'),
(10016, 'Subscribers will receive the username, password, and server address information with which to configure OpenEMR'),
(10017, 'Subscribter Phone'),
(10018, 'Substance'),
(10019, 'Substance Refusal Reason'),
(10020, 'Substitution'),
(10021, 'substitution allowed'),
(10022, 'Subtitle'),
(10023, 'Subtype'),
(10024, 'Success'),
(10025, 'success'),
(10026, 'Success confirming receipt of lab result'),
(10027, 'Success getting lab results'),
(10028, 'Success retrieving results from Lab Exchange Network'),
(10029, 'Successful Transfers'),
(10030, 'Successfully added category'),
(10031, 'successfully added to category,'),
(10032, 'Successfully Completed'),
(10033, 'Successfully Deleted'),
(10034, 'Successfully Imported the details. Please approve the patient from the Pending Approval Screen'),
(10035, 'Successfully installed the database.'),
(10036, 'Successfully installed the following database'),
(10037, 'Successfully Modified'),
(10038, 'Successfully ordered form'),
(10039, 'Successfully Saved.Would you like to Allocate?'),
(10040, 'Successfully Saved.Would you like to Distribute?'),
(10041, 'Successfully Sent'),
(10042, 'successfully stored.'),
(10043, 'Successfully upgraded'),
(10044, 'Successfully upgraded the database.'),
(10045, 'Successfully upgraded the following database'),
(10046, 'successfully.'),
(10047, 'Suffix'),
(10048, 'Suggestions for the Imp/Plan are built from the Exam, the Past Ocular History (POH and POS) and the Past Medical History (PMH)'),
(10049, 'Suicide'),
(10050, 'Suite'),
(10051, 'Summary'),
(10052, 'Summary of'),
(10053, 'Summary of Acuities for this patient'),
(10054, 'Summary Of Care Provided?'),
(10055, 'Summary of Care Provided?'),
(10056, 'Summary of Care Sent'),
(10057, 'Summary of Care Sent Electronically'),
(10058, 'Sun'),
(10059, 'Sundanese'),
(10060, 'Sunday'),
(10061, 'Superbill'),
(10062, 'Superbill Codes'),
(10063, 'Superbill Codes Administration'),
(10064, 'Superbill Codes Administration (superbill)'),
(10065, 'Superbill Report'),
(10066, 'Superbill/Fee Sheet'),
(10067, 'Superbills'),
(10068, 'Superbills, sometimes referred to as Encounter Forms or Routing Slips, are an essential part of most medical practices.'),
(10069, 'Superuser'),
(10070, 'Superuser - can delete patients, encounters, issues (super)'),
(10071, 'Supervising'),
(10072, 'Supervising Doctor'),
(10073, 'Supervising Doctor DEA'),
(10074, 'Supervising Doctor First name'),
(10075, 'Supervising Doctor Last name'),
(10076, 'Supervising Doctor NPI'),
(10077, 'Supervising Doctor UPIN'),
(10078, 'Supervising Provider'),
(10079, 'Supervisor'),
(10080, 'Supplier'),
(10081, 'Supplier facility name'),
(10082, 'Support calendar events that apply to multiple providers'),
(10083, 'Support export/import of configuration data via the Backup page.'),
(10084, 'Support Multi-Provider Events'),
(10085, 'Support Phone Number'),
(10086, 'Support provider in line item in fee sheet'),
(10087, 'Supports AES-256-CBC encryption/decryption only.'),
(10088, 'Supports TripleDES encryption/decryption only.'),
(10089, 'sup{{superior}}'),
(10090, 'Surface Type'),
(10091, 'Surgeon'),
(10092, 'Surgeries'),
(10093, 'Surgery'),
(10094, 'Surgery Issue List'),
(10095, 'Suspended'),
(10096, 'suspension'),
(10097, 'Su{{Sunday}}'),
(10098, 'Svc Date'),
(10099, 'Svc Date:'),
(10100, 'Swahili'),
(10101, 'Swati'),
(10102, 'Sweating:'),
(10103, 'Swedish'),
(10104, 'Swelling'),
(10105, 'Swelling Right'),
(10106, 'Swollen Joints'),
(10107, 'Swollen Lymph Nodes'),
(10108, 'Symbol used as the decimal point for currency. Not used if Decimal Places is 0.'),
(10109, 'Symbol used to separate thousands for currency.'),
(10110, 'Symptoms'),
(10111, 'Synchronize'),
(10112, 'Synchronize translations with custom language table.'),
(10113, 'Synchronized new custom constant:'),
(10114, 'Synchronized new custom language:'),
(10115, 'Synchronized new definition (Language, Constant, Definition):'),
(10116, 'Syncope'),
(10117, 'Syndromic Surveillance'),
(10118, 'Syndromic Surveillance - Non Reported Issues'),
(10119, 'Syndromic Surveillance Report'),
(10120, 'Synovitis, impingement, bursitis'),
(10121, 'System'),
(10122, 'System Error Logging Options'),
(10123, 'System Error Logging Options.'),
(10124, 'Systolic'),
(10125, 'S{{Saturday}}'),
(10126, 's{{suffix to make Document plural, ie. Documents}}'),
(10127, 'S{{Sunday}}'),
(10128, 'T'),
(10129, 'T-Score'),
(10130, 't.i.d.'),
(10131, 'T.V.'),
(10132, 'Tab Log'),
(10133, 'Table'),
(10134, 'Table Action'),
(10135, 'Table Args'),
(10136, 'Table Code'),
(10137, 'Table creation failed'),
(10138, 'Table update failed'),
(10139, 'Tables'),
(10140, 'tablet'),
(10141, 'Tabs'),
(10142, 'Tabs Layout Theme'),
(10143, 'Tabs Layout Theme (need to logout/login after change this setting)'),
(10144, 'Tag to Encounter'),
(10145, 'Tag to Image Procedure'),
(10146, 'Tagalog'),
(10147, 'Tahitian'),
(10148, 'Tajik'),
(10149, 'Take'),
(10150, 'Take care and click on the black + sign on the Electrolyte Panel line to create these Discrete Results'),
(10151, 'Take Insurance, from Drop Down'),
(10152, 'Take Payment From, from Drop Down'),
(10153, 'Takeback'),
(10154, 'Takes long'),
(10155, 'Takes you to the Register Time Based One Time Password Key - TOTP page'),
(10156, 'Takes you to the Register Universal 2nd Factor Key - U2F page'),
(10157, 'Tall Navigation Area'),
(10158, 'Tamil'),
(10159, 'Tamper Date'),
(10160, 'Tampered Checksum'),
(10161, 'Target and source DOB do not match'),
(10162, 'Target and source pid may not be the same!'),
(10163, 'Target and source SSN do not match'),
(10164, 'Target Date'),
(10165, 'Target Patient'),
(10166, 'Target patient has no DOB'),
(10167, 'Target patient not found'),
(10168, 'Target/Action Groups'),
(10169, 'Targets'),
(10170, 'Taskman: Documents in openEMR'),
(10171, 'Tatar'),
(10172, 'Tax Id'),
(10173, 'Tax ID'),
(10174, 'Tax Rate'),
(10175, 'Taxes'),
(10176, 'Taxonomy'),
(10177, 'TA{{temporal arteries}}'),
(10178, 'TB'),
(10179, 'TBUT'),
(10180, 'TBUT{{tear breakup time}}'),
(10181, 'Td'),
(10182, 'Team Injury Overview'),
(10183, 'Team Roster'),
(10184, 'Team Roster View'),
(10185, 'Team/Squad'),
(10186, 'Tear Break Up Time'),
(10187, 'Tel'),
(10188, 'Telehealth'),
(10189, 'Telephone Country Code'),
(10190, 'Tell me more'),
(10191, 'Telugu'),
(10192, 'Temp'),
(10193, 'Temp Location'),
(10194, 'Temp Method'),
(10195, 'Temp. Art.{{temporal arteries}}'),
(10196, 'Temperature'),
(10197, 'Template'),
(10198, 'Template Name'),
(10199, 'Template names cannot start with numbers.'),
(10200, 'Template selector changed'),
(10201, 'Template:'),
(10202, 'Templates'),
(10203, 'Temporal Art.{{Temporal Artery}}'),
(10204, 'Temporal Arteries'),
(10205, 'Temporal Artery'),
(10206, 'Temporary Lodging'),
(10207, 'temp{{temporal}}'),
(10208, 'Tendon injury'),
(10209, 'Tendonitis / osis / bursitis'),
(10210, 'Tension'),
(10211, 'Tentative Invoice Ref No'),
(10212, 'Terms and Conditions'),
(10213, 'Tertiary'),
(10214, 'Tertiary Insurance'),
(10215, 'Tertiary Insurance Data'),
(10216, 'Tertiary Insurance provider'),
(10217, 'Test only, skip updates'),
(10218, 'Test Ordered'),
(10219, 'Test Scheduling'),
(10220, 'Test System'),
(10221, 'Test/Order'),
(10222, 'Tests Performed'),
(10223, 'Text'),
(10224, 'Text Diagnosis'),
(10225, 'Text field'),
(10226, 'Text for Custom statement message.'),
(10227, 'Text for fifth account message.'),
(10228, 'Text for first account message.'),
(10229, 'Text for fourth account message.'),
(10230, 'Text for second account message.'),
(10231, 'Text for third account message.'),
(10232, 'Text Message permission'),
(10233, 'Text-date'),
(10234, 'text-date'),
(10235, 'Textarea'),
(10236, 'textarea'),
(10237, 'Textbox'),
(10238, 'textbox'),
(10239, 'Textbox list'),
(10240, 'textbox list'),
(10241, 'Thai'),
(10242, 'Thank You'),
(10243, 'Thank you'),
(10244, 'Thank you for allowing us to serve you.'),
(10245, 'Thank you for choosing'),
(10246, 'Thank You.'),
(10247, 'The \'Clear\' button will remove all annotations.'),
(10248, 'The \'Edit\' window is divided into two columns, \'Active\' and \'Inactive\'. The groups (AROs) that are listed in the active column are those groups that the user belongs to.'),
(10249, 'The \'Select Codes\' section will now have all the CPT and ICD codes that you entered grouped under the categories that you had decided upon'),
(10250, 'The *Tab* key creates each entry.'),
(10251, 'The 1500 Claim Form may also be used to report patient encounter data to federal, state, and/or other public health agencies'),
(10252, 'The 837P (Professional) is the standard format used by health care professionals and suppliers to transmit health care claims electronically'),
(10253, 'The ability to link individual issues to patient encounters will let the user quickly determine the outcome of the issue over time'),
(10254, 'The above statement failed'),
(10255, 'The ACL page two sections.'),
(10256, 'The actual amounts that will be displayed must exist in the database'),
(10257, 'The actual tests or procedures that can be searched for and ordered are highlighted in yellow'),
(10258, 'The Add icon is used to setup a tier that will be a direct descendant of this tier'),
(10259, 'The advantage of integrating the results with the patient\'s chart as structured data is the ability to manipulate it to see trends in one convenient location, to plot graphs with the data and use it in data analysis'),
(10260, 'The advantage of scanning the results into the chart is simplicity - no setup is required other than defining a directory/folder in the patient\'s chart under Documents where the result will be stored. Being unstructured data it does not have the above advantages and will not fulfill Meaningful Use criteria for Computerized Provider Order Entry (CPOE)'),
(10261, 'The Allscripts solution integrates the Allscripts ePrescribe web site with openEMR'),
(10262, 'The American Medical Association has defined 9 panels that can be ordered. Each panel contains several tests grouped together'),
(10263, 'The amount will be displayed in either the Payment or Adjustment column as the case may be'),
(10264, 'The Apache SSL server certificate and public key'),
(10265, 'The application generates challenge - a random number and passes it to the USB key along with the nonce and checksum stored in the application'),
(10266, 'The application then uses the public key that the USB device sent on registration to verify the response'),
(10267, 'The appointment status changes and encounter creations are managed through the Patient Tracker.'),
(10268, 'The Auth Name or API key for selected account. Auth Name for Authorize.Net and API Secret for Stripe.'),
(10269, 'The Balance column would be empty'),
(10270, 'The basic purpose of the authenticator app is to generate a 20 bytes (160 bits) code encoded in base32 using a secure hash function, SHA-1, and is called HMAC-SHA1 (Hash-based Message Authentication Code)'),
(10271, 'The basis for CCR is a Patient Care Referral Form developed by the Massachusetts Department of Public Health'),
(10272, 'The Billed Date/Payor column will show the date the line item payment was received and the Payor name - either insurance or patient'),
(10273, 'The Billed Date/Payor column will show the date the line item was billed and the Payor - either insurance or patient'),
(10274, 'The Body contains the clinical data that may be structured and organized as one or more sections or may be an unstructured blob of data'),
(10275, 'The Body Site, Administer Via and Laterality boxes can be left as Unassigned'),
(10276, 'The bottom group consists of the Copays'),
(10277, 'The Category column will be Custom Top Group and will be highlighted in pink'),
(10278, 'The Category column will say Order indicating that it is an order'),
(10279, 'The Category will be Result'),
(10280, 'The CDA is a plain text document that is coded using the Extensible Markup Language (XML) and contains a Header and Body'),
(10281, 'The Certificate Authority certificate'),
(10282, 'The Charge column would be blank'),
(10283, 'The Charge will be the actual amount being charged for each line item'),
(10284, 'The claim file: '),
(10285, 'The CMS 1500 form has 33 boxes and is divided into two sections'),
(10286, 'The Code column should have 905, the vendor specific Identifying code that was entered previously'),
(10287, 'The Code column will be empty as items listed as a Group are not used in the actual reporting of results and therefore do not have a distinct code number'),
(10288, 'The Code will be R905, the Identifying Code value that was entered for the Discrete Result'),
(10289, 'The code you entered was not valid'),
(10290, 'The compatible staged US Extension SNOMED package has already been installed.'),
(10291, 'The Contacts cell has various bits of contact information like phone numbers, email etc'),
(10292, 'The Continuity of Care Document (CCD) and Continuity of Care Record (CCR) were both selected as acceptable formats to extract information for clinical care summaries as a part of Meaningful Use Stage 1'),
(10293, 'The Continuity of Care Record (CCR) has been developed jointly by ASTM International - an organization that is involved in the development and delivery of voluntary consensus, the Massachusetts Medical Society (MMS), the Health Information Management and Systems Society (HIMSS), the American Academy of Family Physicians (AAFP), and the American Academy of Pediatrics'),
(10294, 'The Continuity of Care Record (CCR) is the clinical record of the patient’s current and historical health care status'),
(10295, 'The core dataset consists of'),
(10296, 'The corresponding private key'),
(10297, 'The created report can contain as much or as little information based on the need'),
(10298, 'The Current Authentication Method for the logged in user section will now feature the activated methods'),
(10299, 'The Current Authentication Method lists all the methods that are active'),
(10300, 'The custmomized Fee Sheet can be used. If and when you come across a code that is not there in the custom \'Select Codes\' section you can always use the \'Search for Additional Codes\' section'),
(10301, 'The Custom Favorite Item Tier should be the direct descendant or child of the relevant Custom Favorite Group'),
(10302, 'The custom grouping will also let you group two recognized panel of tests into a custom group and thus order them together, e.g. a custom group of Preop Labs may contain two panels, CBC and Renal Panel'),
(10303, 'The dashboard is the central location for convenient access the patient\'s medical record'),
(10304, 'The Dashboard page is divided into three sections'),
(10305, 'The data integrity test failed for this form'),
(10306, 'The data section of the dashboard page lists all pertinent items related to a patient'),
(10307, 'The dated reminder will start to appear 5 days before the reminder date under Dated Reminders '),
(10308, 'The default code type to search for in the Fee Sheet.'),
(10309, 'The default fee sheet can be modified and customized to make it more useful.'),
(10310, 'The default fee sheet is divided into several sections and is designed to be filled from top to bottom with the save button at the very end.'),
(10311, 'The default form can be customized by editing it in Administration > Layouts'),
(10312, 'The default has two buttons that is set for \'New Patient\' and \'Established\' patient'),
(10313, 'The default installation has six such groups - Accounting, Administrators, Clinicians, Emergency Login, Front Office and Physicians.'),
(10314, 'The default installation has the following items'),
(10315, 'The default installation lists 5 types of issues that can be documented'),
(10316, 'The default installation will not make the phone call automatically'),
(10317, 'The default is \'Standard\' usually used to reflect rates charged for insurance billing. You can have a different amount charged for credit card payment and for cash payment'),
(10318, 'The default is Normal, i.e. it is visible to everyone. Selecting High will restrict it to users belonging to the Physicians and Administrators groups by default'),
(10319, 'The default issue type is set to Problem'),
(10320, 'The default messaging center is divided into three sections - Messages, Reminders and Recalls'),
(10321, 'The default values for the rendering providers can be set'),
(10322, 'the Denial code is'),
(10323, 'the Denial Group code is'),
(10324, 'The Description column displays the short description that was entered, Serum chemistry tests'),
(10325, 'The Description column will reflect the description value that was entered previously'),
(10326, 'The Description should say Serum Uric Acid result'),
(10327, 'The Description will detail the type of payment or adjustment - Cash, Check, Electronic etc '),
(10328, 'The destination form was closed'),
(10329, 'The destination form was closed.'),
(10330, 'The destination form was closed; I cannot act on your selection.'),
(10331, 'The difference between the two is that for a panel of tests that are ordered together the individual tests are represented by Discrete Result only and these tests cannot be ordered separately unless they have also been setup as single tests'),
(10332, 'The Discrete result Tier must be the direct descendant or child of a Procedure Order Tier for proper display of results'),
(10333, 'The Discrete Results for each panel will contain the names of the individual tests to hold the values of the returned results - WBC, Hemoglobin, Platelets, Sodium, Potassium etc'),
(10334, 'The display window can be resized by clicking and dragging the bottom right corner of the window'),
(10335, 'The Each Appointment option will allow a new encounter regardless of same day visit.'),
(10336, 'The Encounter Preview button is useful for showing encounter type layout forms as seen when using form in an encounter. Note, this feature is only useful for showing encounter forms and won\'t display system forms like Demographics'),
(10337, 'The Encounters Section will display the date of encounter as well as the presenting complaint'),
(10338, 'The end result was a confusing collection of documents containing ambiguous and/or conflicting information'),
(10339, 'The Enter Details pop-up box will open in the Add Mode'),
(10340, 'The Enter Provider Details pop-up will be visible'),
(10341, 'The entire collection of ACOs forms the Access Control List (ACL).'),
(10342, 'The entity for a Custom Favorite Item is the entity chosen for the Custom Favorite Group and cannot be changed'),
(10343, 'The entity performing this procedure'),
(10344, 'The Entries contain data used for further computer processing'),
(10345, 'The entries highlighted in yellow can be ordered as a test or procedure those highlighted in pink can be ordered as a Custom Group'),
(10346, 'The EP, eligible hospital or CAH who receives a patient from another setting of care or provider of care or believes an encounter is relevant should perform medication reconciliation.'),
(10347, 'The EP, eligible hospital or CAH who transitions their patient to another setting of care or provider of care or refers their patient to another provider of care should provide summary of care record for each transition of care or referral (Measure A).'),
(10348, 'The EP, eligible hospital or CAH who transitions their patient to another setting of care or provider of care or refers their patient to another provider of care should provide summary of care record for each transition of care or referral (Measure B).'),
(10349, 'The EP, eligible hospital or CAH who transitions their patient to another setting of care or provider of care or refers their patient to another provider of care should provide summary of care record for each transition of care or referral.'),
(10350, 'The event(s) have been approved.'),
(10351, 'The event(s) have been hidden.'),
(10352, 'The exported data appears in the text area below.  You can copy and paste this into an email or to any other desired destination.'),
(10353, 'The exported data appears in the text area below. You can copy and paste this into an email or to any other desired destination (or) download the below link.'),
(10354, 'The exported data appears in the text area below. You can copy and paste this into an email or to any other desired destination.'),
(10355, 'The exported data appears in the text area below. You can copy and paste this into an email or to any other desired destination.{{MARK FOR DELETION DURING NEXT TRANSLATION BUILD}}'),
(10356, 'The features of a MedEx enabled installation are explained in this video'),
(10357, 'The file cannot be generated again. Do you want to proceed?'),
(10358, 'The file could not be saved to CouchDB.'),
(10359, 'The file could not be succesfully renamed, this error is usually related to permissions problems on the storage system.'),
(10360, 'The file could not be succesfully stored, this error is usually related to permissions problems on the storage system'),
(10361, 'The filter section can be hidden or revealed by clicking the arrowhead  on the bottom right '),
(10362, 'The filtered results will show up in the section below it'),
(10363, 'The finder table is grouped by past procedures then diagnosis code. Although there may be duplicate dx codes, they will be grouped with the appropriate procedure making building diagnoses list easier.'),
(10364, 'The first (\"target\") chart is the one that is considered the most complete and accurate. Demographics, history and insurance sections for this one will be retained.'),
(10365, 'The first column contains the Group/Category name that will be displayed on the button'),
(10366, 'The first column is the name that you gave this entry, i.e. Serum Chemistry. A vertical bar will precede the actual name. That indicates that there are no descendants or children to this entry'),
(10367, 'The first four sections deal with creating procedure orders in a structured manner in order to facilitate easy ordering of tests and entering the returned results manually'),
(10368, 'The first line will show the Encounter date and Reason as well as the Provider for that encounter'),
(10369, 'The first section lets you either link this message to a patient if so desired.'),
(10370, 'The first Segment in every HL7 Message is always the Message Header, a Segment that conveys the metadata of the message like who sent it and when. The Message header is indicated in the first three letters of the segment as MSH'),
(10371, 'The first step is signing up for a production Direct messaging account with EMR Direct by registering on their website'),
(10372, 'The first step is to download the SNOMED CT release. Access to SNOMED CT is provided by IHTSDO and their member countries. For more information see'),
(10373, 'The first step is to download the VALUESET release. Access to VALUESET is provided by NLM. Only valueset for Eligible Professionals need to be downloaded and it should be downloaded in XML format from Sorted By CMS ID column. For more details see the below link'),
(10374, 'The first step is to open an account with the Unified Medical Language System web site'),
(10375, 'The first step is to plan what your Fee Sheet \'Select Codes\' section should display'),
(10376, 'The first step is to select a Transaction type'),
(10377, 'The first step would be to create a top level entry. Do so by clicking on Add Top Level button'),
(10378, 'The first tab is the referral tab that constitutes the referral being made'),
(10379, 'The first two numbers in the first and second colum will be used to determine the sort order of the buttons and the lists that are present in the popup'),
(10380, 'The following calendar event has been added:'),
(10381, 'The following calendar event has been modifed:'),
(10382, 'The following categories will be removed from your category List'),
(10383, 'The following database release is currently installed'),
(10384, 'The following documents were attached to this Direct message:'),
(10385, 'The following EDI file failed save to archive'),
(10386, 'The following EDI file has been uploaded'),
(10387, 'The following EDI file upload failed to open'),
(10388, 'The following Emergency Login User is activated:'),
(10389, 'The following errors occurred'),
(10390, 'The following field has an invalid value'),
(10391, 'The following fields are empty.'),
(10392, 'The following fields are required'),
(10393, 'The following fields have to be filled to send a request.'),
(10394, 'The following fields have to be filled to send request.'),
(10395, 'The following International Snomed Release languages are supported'),
(10396, 'The following occurred'),
(10397, 'The following problems have the same diagnosis codes. Encounter issues will not be updated. Please use the encounter interface instead.'),
(10398, 'The following steps will help customize the Fee Sheet to mimic the old paper superbill with a list of CPT4 and ICD codes arranged in categories'),
(10399, 'The group (ARO) that you created will now appear in alphabetical order in the \'Groups and Access Controls\' section.'),
(10400, 'The Header defines the context for the clinical document as a whole'),
(10401, 'The header section will reveal patient specific information across most pages related to the patient\'s medical record'),
(10402, 'The Health Insurance Claim Form is often referred to by its form number CMS 1500 (HCFA 1500)'),
(10403, 'The help file is divided into the following sections'),
(10404, 'The help file there will guide you on further steps in setting up the lab tests'),
(10405, 'The help icon will let you access context sensitive help for each of the pages accessed'),
(10406, 'The hostname of the ATNA audit repository machine.'),
(10407, 'The hostname or URI of your LDAP or Active Directory server.'),
(10408, 'The Identifying Code has to be unique in order for the results to display correctly, you could just use R905 as an example'),
(10409, 'The Identifying code has to be unique, if sending to an external lab the vendor supplied Identifying Code has to be entered. We will enter an arbitrary unique value - WWT01'),
(10410, 'The Identifying Code is a vendor-specific code identifying this procedure or result. You can see examples of it in the paper lab slips that the labs use'),
(10411, 'The Identifying Code is essential for the proper display and tabulation of results'),
(10412, 'The Identifying Code of R34392-1, an arbitrary number, in this case the Identifying Code preceded by R to indicate result and succeeded by 1 to indicate the first in the sequence, it could be anything unique you choose'),
(10413, 'The information entered here is used to display a summary of the encounter. It is also used for billing purposes'),
(10414, 'The information entered in this form will be used to complete a paper claim'),
(10415, 'The information provided in the New Encounter Form and Fee Sheet in openEMR is used to generate the paper claim as well as electronic claims'),
(10416, 'The initial efforts led to the creation of duplicative and conflicting Implementation Guides (IGs) published by different standards organizations'),
(10417, 'The initial screen lets you select a method by offering you these two options.'),
(10418, 'The initial window is the invoice search page.  At the top you may enter a source (e.g. check number), pay date and check amount.  The reason for the source and pay date is so that you don\'t have to enter them over and over again for each claim.  The amount that you enter will be decreased for each invoice that is given part of the payment, and hopefully will end at zero when you are done.'),
(10419, 'The input should be a CSV file with 3 columns: layout ID, code type and code.'),
(10420, 'The installation directory needs to be created.'),
(10421, 'The installed International SNOMED version is not compatible with the staged US Extension SNOMED package.'),
(10422, 'The installed International SNOMED version is out of date and not compatible with the staged US Extension SNOMED file.'),
(10423, 'The installed version and the staged files are the same.'),
(10424, 'The installed version is a more recent version than the staged files.'),
(10425, 'The Instruction manual on how to fill the CMS 1500 form can be found here'),
(10426, 'The IP address of your domain controller(s).'),
(10427, 'The Issues can be entered in one of two ways'),
(10428, 'The Issues section will display all the issues entered for the patient and will display the type of issue, its title and a description'),
(10429, 'The items listed in the \'Active\' column delineate the privileges of this group (ARO) and constitutes this group\'s Access Control List (ACL).'),
(10430, 'The items that have asterisks after them are mandated'),
(10431, 'The label that appears to the user on the form'),
(10432, 'The last cell on the line in Encounter'),
(10433, 'The last line of this encounter block will give the encounter totals of Charges, Payments, Adjustments and the Balance'),
(10434, 'The last section deals with electronic orders'),
(10435, 'The last visit date will automatically be filled'),
(10436, 'The latest version is FHIR – Fast Healthcare Interoperability Resources – is a next generation standards framework created by HL7. This is gaining popularity but has not yet been widely implemented'),
(10437, 'The legacy code finder is still available for codes not found in this finder or code list editing.'),
(10438, 'The length should not exceed the following number of characters'),
(10439, 'The log entry with following id has been deleted'),
(10440, 'The log table will show a list of both messages and dated reminders if any'),
(10441, 'The LOINC code for serum uric acid is 3084-1, LOINC refers to it as Urate in Serum or Plasma'),
(10442, 'The merge will not run unless SSN and DOB for the two charts are identical. DOBs cannot be empty.'),
(10443, 'The message could not be sent at this time.'),
(10444, 'The message status will be New as it a new message that is being created'),
(10445, 'The messages that were sent by the user on that day will be displayed in the table below'),
(10446, 'The messaging center conveniently consolidates communications options in one place'),
(10447, 'The messaging center will open with the Messages tab activated and will display the logged in user\'s messages as indicated by the caption My Messages'),
(10448, 'The minimum information required to create a new encounter is to select a visit category'),
(10449, 'The miscellaneous billing options for HCFA-1500 form is used to provide additional information for an individual claim'),
(10450, 'The most common method is called 2-Factor Authorization or 2FA'),
(10451, 'The most important issue that needs to be addressed is who you are trying to connect to and what needs to happen at their end. Most major labs will not deal with individuals practices, in such cases a third party vendor will act an an intermediary who will be responsible for setting up a connection between the practice and the lab through their (the intermediary\'s) interface'),
(10452, 'The most popular maker of Security Keys is Yubico it offers regular USB versions as well as those made for devices that require USB-C connections, such as Apple’s newer Mac OS systems'),
(10453, 'The most popular open-source Electronic Health Record and Medical Practice Management solution.'),
(10454, 'The Name cell contains the name, date of birth, patient ID and date of last visit'),
(10455, 'The Narrative Block contains information that is rendered as readable text'),
(10456, 'The National Uniform Claim Committee (NUCC) is responsible for the maintenance of the 1500 Claim Form'),
(10457, 'The Nav Bar allows one to quickly navigate to various parts of the patient\'s medical record'),
(10458, 'The new category will be a sub-category of '),
(10459, 'The new list'),
(10460, 'The new password can not be the same as the current password.'),
(10461, 'The new password fields are not the same.'),
(10462, 'The new password is the same as the current password. Click Okay to accept anyway.'),
(10463, 'The NewCrop eRx Partner Name, NewCrop eRx Name and NewCrop eRx Password will be provided by the vendor'),
(10464, 'The next box is Body Site, not relevant for a blood test but may be more useful in say tracking injections or ordering X-rays'),
(10465, 'The next few lines will list all the E/M and CPT codes that were billed, one line per code'),
(10466, 'The next group consists of the ICD codes'),
(10467, 'The next three cells are the action cells that let you perform some recall activity'),
(10468, 'The next two boxes denoting the Identifying Code and Standard Code are very important'),
(10469, 'The Notes cell lets you add a note to an action that you take in the 3 action cells or just a note without any association to the action'),
(10470, 'The Number of Future Appointments to Display on the Statement.'),
(10471, 'The number of staged files is incorrect. Only place the file that you wish to install/upgrade to.'),
(10472, 'The number of staged files is incorrect. Only place the files that you wish to install/upgrade to.'),
(10473, 'The Office: Phone cell lets you indicate a phone call was made'),
(10474, 'The option Span Entire Row is useful when using Static Text in allowing text to wrap and span entire row regardless of column settings. Another use could be to create an empty row as spacer or add additional option Add Bottom Border to create a line break.Only Bottom Border Row is useful here.'),
(10475, 'The options for Outline and Border will either wrap a row in thin border or add a border to the bottom of an item.'),
(10476, 'The order in which the Category, Procedure or Result appears'),
(10477, 'The other 4 transaction types are simple transaction types - Patient Request, Physician Request, Legal and Billing'),
(10478, 'The other Segments contain additional information in a strictly structured fashion'),
(10479, 'The page will be redirected to Demographics. You can edit the country field and clickthrough to NewCrop again.'),
(10480, 'The page you requested was not found. Please check that you typed the URL correctly.'),
(10481, 'The parts of the program to which access can be controlled are called Access Control Objects (ACOs). '),
(10482, 'The password must be at least eight characters, and should'),
(10483, 'The password you entered is invalid'),
(10484, 'The Past Ocular History (POH) and Past Medical History (PMH) are negative.'),
(10485, 'The patient already registered to the group'),
(10486, 'The patient record request has been recorded.'),
(10487, 'The patient reminders have been sent'),
(10488, 'The patient reminders have been updated'),
(10489, 'The patient was not logged in when submitting this form'),
(10490, 'The patient will have to change their credentials at the first login'),
(10491, 'The Patients Rights'),
(10492, 'The Payment, Adjustment and Balance will be blank as these lines reflect only the charges being made'),
(10493, 'The payments posted cannot go below this date.This ensures that after taking the final report nobody post for previous dates.'),
(10494, 'The pop-up form heading will now read Enter Details for Individual Custom Favorite Item'),
(10495, 'The portal has data for this patient and form. Load it now?'),
(10496, 'The previous message can however be viewed by clicking on the View Log button'),
(10497, 'The Procedure Order page lists the following procedure types'),
(10498, 'The procedure request needs to be structured in a hierarchical manner and a unique identifying code assigned to it that will then be used to track and tabulate the result'),
(10499, 'The Procedures module is used to place and review orders'),
(10500, 'The process for forwarding the message is quite similar to that of creating a new message'),
(10501, 'The Progress cell lists all the actions along with any associated notes if any'),
(10502, 'The providers office has been notified. Thank you.'),
(10503, 'The public access key for secure tokenize of credit or debit card authorization. PCI compliance'),
(10504, 'The QR code also contains the user name and needs to be captured by the user on to their mobile device using an authenticator app'),
(10505, 'The raw data feed release can be obtained from'),
(10506, 'The Recall cell has the date of recall and the reason for recall'),
(10507, 'The Recalls tab has two buttons New Recall and Recall Board'),
(10508, 'The Recommendation Tier is optional'),
(10509, 'The remaining information below applies only if you are posting manually, or if you are doing manual corrections.'),
(10510, 'The reminder for the current day will have an orange exclamation icon'),
(10511, 'The reminders that are past the due date will have a red exclamation triangle icon'),
(10512, 'The requested document is not present at the expected location on the filesystem or there are not sufficient permissions to access it'),
(10513, 'The requested document is not present at the expected location on the filesystem or there are not sufficient permissions to access it.'),
(10514, 'The rest may be left blank if so preferred'),
(10515, 'The rest of the boxes related to the NewCrop eRx service can be left at default values'),
(10516, 'The Result Line will begin with a Name Serum Uric Acid that will be preceded by a vertical bar indicating no successors or children'),
(10517, 'The results could not be loaded'),
(10518, 'The results, Discrete Result, will be the fruit on this branch and we will create one such Discrete Result for each of the component tests, Sodium, Potassium, Chloride and Carbon Dioxide'),
(10519, 'The rows containing the CPT4 codes has several boxes that need to be filled to ensure proper billing of claims'),
(10520, 'The saved Medical Problem will now be listed as a single line in the main Issues page under Medical Problems'),
(10521, 'The screen refresh time in Seconds for the Patient Flow Board Screen.'),
(10522, 'The search field cannot be empty. Please enter a search term'),
(10523, 'The Search results are displayed in the section \'Search Results\'.'),
(10524, 'The second (\"source\") chart will have its demographics, history and insurance sections discarded.  Its other data will be merged into the target chart.'),
(10525, 'The second column contains the options that will be displayed when the button is clicked'),
(10526, 'The second column is Category and should say Top Group to indicate its position as the top item in this particular hierarchical tree that we will be constructing'),
(10527, 'The second section lets you choose to whom you wish to send the message'),
(10528, 'The second tab, is somewhat ambiguously named as Counter-Referral, is the place to document the received reply to the referral being made'),
(10529, 'The section labeled \'Invoice Search\' is where you put in your search parameters. You can search by patient name, chart number, encounter number or date of service, or any combination of these. You may also select whether you want to see all invoices, open invoices, or only invoices that are due (by the patient). Click the \'Search\' button to perform the search.'),
(10530, 'The selected code will be added to the coding text-box and the Description on the code will be added to the Title text-box'),
(10531, 'The selected codes will then appear in the \'Selected Fee Sheet Codes and Charges for Current Encounter\' section'),
(10532, 'The selections in this section will be used in charging for this encounter'),
(10533, 'The sequence is the order in which this top order item will be displayed on the page, 1 to denote the first top level group'),
(10534, 'The server address will be of the form '),
(10535, 'The setup for lab tests will be described in detail, minor modification to these steps will be needed to setup in-office procedures and other procedure types'),
(10536, 'The somewhat ambiguously named Counter-Referral is the space where the reply to the referral being made can be documented'),
(10537, 'The Source and Date columns are copied from the first page, so normally you will not need to touch those.  You can put a payment amount in the Pay column, an adjustment amount in the Adjust column, or both.  You can also click the \"W\" on the right to automatically compute an adjustment value that writes off the remainder of the charge for that line item.'),
(10538, 'The Source and Date columns are copied from the first page, so normally you will not need to touch those. You can put a payment amount in the Pay column, an adjustment amount in the Adjust column, or both. You can also click the \'W\' on the right to automatically compute an adjustment value that writes off the remainder of the charge for that line item.'),
(10539, 'The Specimen Type will be Blood, this drop-down list can also be edited as needed'),
(10540, 'The staged files release dates are not all from the same release.'),
(10541, 'The staged files revisions are not all from the same release.'),
(10542, 'The staged US Extension SNOMED package can not be installed until after the International SNOMED package has been installed.'),
(10543, 'The Standard Code is optional if using a local i.e. practice based lab but recommended when using an external lab'),
(10544, 'The Standard Code will be the LOINC code if sending to an external lab or can be any unique number. We will enter the LOINC code for Fasting Glucose 1558-6'),
(10545, 'the status of three chronic/inactive problems'),
(10546, 'The subsequent lines will indicate the details of the payments received, adjustments made and the balance due'),
(10547, 'The suffix of the account.'),
(10548, 'The system does not permit uploading files of with size 0.'),
(10549, 'The system does not permit uploading files with MIME content type'),
(10550, 'The system is also designed to parse incoming HL7 messages and place the results in the appropriate patient chart, failing which it will give you an opportunity to manually link it to a patient chart'),
(10551, 'The system is designed to both place orders electronically and receive the results electronically'),
(10552, 'The third column will contain the CPT code'),
(10553, 'The Tier column value will be 1 indicating it is a top level item'),
(10554, 'The Tier column value will be 3, indicating this is a successor or child to the first line above it having a value of 2'),
(10555, 'The Tier column will be 2, indicating this is a successor or child to the first line above it having a value of 1'),
(10556, 'The Tier Column would be 1 indicating it is the Top Group'),
(10557, 'The time granularity of the calendar and the smallest interval in minutes for an appointment slot.'),
(10558, 'The Title will be the name of the new group (ARO) that you are going to create.'),
(10559, 'The top group consists of charges for the encounter - one row per charge'),
(10560, 'The top portion of the Recall Board allows the setting of filters to display specified data'),
(10561, 'The traditional mechanism of using a login and password is no longer considered to be sufficient to prevent an unauthorized user from gaining access to the application'),
(10562, 'The translated label that will appear on the form in current language'),
(10563, 'The translated Title that will appear in current language'),
(10564, 'The translation of description in current language'),
(10565, 'The translation tables are synchronized.'),
(10566, 'The type of this entity'),
(10567, 'The Type will be blank'),
(10568, 'The Type will Insurance or Patient'),
(10569, 'The Type would be Allergy'),
(10570, 'The Type would be Dental Issues'),
(10571, 'The Type would be Medication'),
(10572, 'The Type would be Problem indicating a medical problem'),
(10573, 'The Type would be Surgery'),
(10574, 'The UB-04 (CMS 1450) is a claim form used by hospitals, nursing facilities, in-patient, and other facility providers'),
(10575, 'The Unit column would be blank'),
(10576, 'The Units will be 1 as each code is billed only once for the encounter'),
(10577, 'The upcoming reminders have a green exclamation icon'),
(10578, 'The USB devices communicate with the host computer using the human interface device (HID) protocol, essentially mimicking a keyboard'),
(10579, 'The USB key needs to be plugged in to the computer and then registered with OpenEMR'),
(10580, 'The USB key takes this the nonce supplied by the application after confirming the checksum and generates a private key using the process similar to that used in the registration process'),
(10581, 'The user\'s actual privileges are determined by the access to the parts of the program i.e. (ACO) that each group (ARO) has.'),
(10582, 'The Username fields are not the same.'),
(10583, 'The Username is your Direct Address'),
(10584, 'The values in the drop-down box can be edited by following the steps outlined in the Procedures > Providers help file'),
(10585, 'The values listed here will show up in the drop-down boxes that will be used to process orders'),
(10586, 'The vendor-specific code identifying this procedure or result'),
(10587, 'The vendor-specific code identifying this procedure or result. If no vendor enter any arbitrary unique number, preferably a 5 digit zero-padded e.g. 00211'),
(10588, 'The very first step would be install the ICD codes. Go to Administraion > Other > External Data Loads. Select the Code sets you want to install and click Install'),
(10589, 'The very last line of this report will give the Grand Total of Charges, Payments, Adjustments and the Balance'),
(10590, 'The Weno Exchange is well integrated with openEMR and is not subscription based'),
(10591, 'The X12 files as well as the resulting HTML output reports are archived in the \"era\" subdirectory of the main OpenEMR installation directory.  You will want to refer to these archives from time to time.  The URL is '),
(10592, 'The X12 files as well as the resulting HTML output reports are archived in the \'era\' subdirectory of the main OpenEMR installation directory. You will want to refer to these archives from time to time.'),
(10593, 'The zip file will contain the following items'),
(10594, 'Theme'),
(10595, 'Theme of the tabs layout (need to logout and then login to see this new setting).'),
(10596, 'Theme of the tabs layout (need to logout and then login to see this new setting). Note this is only applicable if use the Light or Manila general theme below.'),
(10597, 'Then pass it\'s name as a value to the element'),
(10598, 'Then press the flashing button on your key within 1 minute to complete registration'),
(10599, 'Then press the flashing button on your key within 1 minute.'),
(10600, 'Then the raw data feed release can be obtained from'),
(10601, 'Therapeutic Injections'),
(10602, 'Therapy'),
(10603, 'Therapy group'),
(10604, 'Therapy Group'),
(10605, 'Therapy Group Encounter'),
(10606, 'Therapy Group Finder'),
(10607, 'There are'),
(10608, 'There are 10 settings that are related to procedures included in the standard release of openEMR'),
(10609, 'There are 3 forms in the Core category - Demographics, Facility Specific User Information and History and all 5 forms in Transactions that can be edited '),
(10610, 'There are currently no prescriptions'),
(10611, 'There are errors with your submission.  These are outlined below.'),
(10612, 'There are four message statuses - New, Forwarded, Read and Done'),
(10613, 'There are multiple options regarding patient portals and information on how to setup the patient portal is available here'),
(10614, 'There are multiple patients with portal login'),
(10615, 'There are nine C-CDA templates that are currently defined'),
(10616, 'There are no charts checked out.'),
(10617, 'There are no clients registered in the system'),
(10618, 'There are no disclosures recorded for this patient.'),
(10619, 'There are no Glasses or Contact Lens Presciptions on file for this patient'),
(10620, 'There are no messages on file for this patient.'),
(10621, 'There are no New Submissions'),
(10622, 'There are no notes on file for this patient.'),
(10623, 'There are no record(s) found.'),
(10624, 'There are no transactions on file for this patient.'),
(10625, 'There are several versions of HL7, versions 2.x and version 3'),
(10626, 'There are several ways to customize the fee sheet. It depends on how comfortable you are in adding information to the database itself'),
(10627, 'There are three actions that are possible - Create a New Dated Reminder, Forward and Set as Completed'),
(10628, 'There are three actions that can be performed here - edit an existing group (ARO), add a new group (ARO) or delete an existing group (ARO).'),
(10629, 'There are three main types of reports that can be created, two pertain to continuity of ongoing care - Continuity of Care Record (CCR) and Continuity of Care Document (CCD) and the third - Patient Report that creates a document containing various sections of the patient\'s medical record including demographics, medical issues, procedures and encounters. It also has the ability to include all or any of the scanned documents in the patient\'s chart'),
(10630, 'There are three options available when you create a Continuity of Care Document (CCD)'),
(10631, 'There are three options available when you create a Continuity of Care Record (CCR)'),
(10632, 'There are three sets of actions that can be performed on this page, in addition the form can be customized'),
(10633, 'There are two buttons that enable you to Check or Clear all available check-boxes'),
(10634, 'There are two options for the records that will be created'),
(10635, 'There are two sections that are visible'),
(10636, 'There are two sources that can be searched - MedlinePlus Connect or Local Content'),
(10637, 'There are two ways this can be accomplished, either by the manual method, by searching and entering data for individual invoices or by uploading an entire electronic remittance advice ERA file.'),
(10638, 'There are various selections to be filled, the minimum data needed to successfully save the referral is Referral Date, Refer To and Reason'),
(10639, 'There has been a mail error sending to'),
(10640, 'There is a lab order'),
(10641, 'There is a Post error'),
(10642, 'There is already a category named'),
(10643, 'There is already a subcategory named'),
(10644, 'There is already an item named'),
(10645, 'There is already an open patient record request.'),
(10646, 'There is no COA entry for AR account '),
(10647, 'There is no COA entry for cash account '),
(10648, 'There is no COA entry for income account '),
(10649, 'There is no current patient'),
(10650, 'There is no local content for this topic.'),
(10651, 'There is no match for invoice id'),
(10652, 'There is no match for invoice id = '),
(10653, 'There is no parts entry for services ID '),
(10654, 'There is no patient with portal login'),
(10655, 'There was a problem sending the message.'),
(10656, 'There was an error while processing your request.'),
(10657, 'There was an OpenEMR SQL Escaping ERROR of the following string'),
(10658, 'Therefore each user has to individually activate this feature'),
(10659, 'These ACOs are grouped into ten broad categories that are part of the default installation. They are - Administration, Accounting, Patient Information, Encounter Information, Squads, Sensitivities, Lists, Placeholder, Nation Notes and Patient Portal. Each of these categories has one or several sub-categories that provide access to specific parts of the program.'),
(10660, 'These are free and can be downloaded from the respective app store for ios and android devices'),
(10661, 'These are the 2012 links'),
(10662, 'These are used to populate fields 3 and 4 in the HL7 MSH - message header'),
(10663, 'These are used to populate fields 5 and 6 in the HL7 MSH - message header'),
(10664, 'These credentials will be used by the patient to login to the patient portal for the first time'),
(10665, 'These custom groups are application specific and not user specific'),
(10666, 'These entries will be used to define the Providers in the Procedures module'),
(10667, 'These groups (AROs) can then be given a set of privileges by assigning different categories (ACOs).'),
(10668, 'These items can be edited if the user has sufficient privilege'),
(10669, 'These lists are used to determine who can access what in openEMR. They work in a top down manner, i.e. initially everybody is denied access to those parts of the program controlled by the ACL.'),
(10670, 'These numbers need to match to successfully authenticate the user'),
(10671, 'These Patient notes are sent without an assigned patient'),
(10672, 'These sub-categories represent the actual Access Control Objects (ACOs).'),
(10673, 'These templates are text only and will not render any other formatting other than pure text.'),
(10674, 'These three steps are essential before orders can be placed and received results linked to a patient\'s chart'),
(10675, 'These Transactions are generally used to document events that have already occurred'),
(10676, 'These two actions are available for all transactions'),
(10677, 'They are displayed in rows and are sub divided into three groups'),
(10678, 'They are Electrolyte Panel, Basic Metabolic Panel, Comprehensive Metabolic Panel, Renal Function Panel, General Health Panel, Obstetric Panel, Acute Hepatitis panel, Hepatic Function Panel and Lipid Panel'),
(10679, 'They are listed in ascending order by encounter date'),
(10680, 'They do not share the vulnerabilities of SMS based methods and generally do not require an internet connection except to keep their clocks synchronized with the current time'),
(10681, 'They will be provided by the facility that you will be connecting to'),
(10682, 'Thickened Right:'),
(10683, 'Thigh'),
(10684, 'Thigh + hamstring'),
(10685, 'Things that back office can only read'),
(10686, 'Things that back office can read and enter but not modify'),
(10687, 'Things that back office can read and modify'),
(10688, 'Things that back office can read and partly modify'),
(10689, 'Things that clinicians can only read'),
(10690, 'Things that clinicians can read and enter but not modify'),
(10691, 'Things that clinicians can read and modify'),
(10692, 'Things that clinicians can read and partly modify'),
(10693, 'Things that front office can only read'),
(10694, 'Things that front office can read and enter but not modify'),
(10695, 'Things that front office can read and modify'),
(10696, 'Things that front office can read and partly modify'),
(10697, 'Things that physicians can only read'),
(10698, 'Things that physicians can read and enter but not modify'),
(10699, 'Things that physicians can read and modify'),
(10700, 'Things that physicians can read and partly modify'),
(10701, 'Third'),
(10702, 'Third account message'),
(10703, 'This account already exists.'),
(10704, 'This action CANNOT be undone.'),
(10705, 'This action cannot be undone.'),
(10706, 'This action cannot be undone. Are you sure you wish to delete this form?'),
(10707, 'This action will be logged'),
(10708, 'This action will reset your claim!'),
(10709, 'This administration page is for managing the list of OAUTH2 registered applications that are authorized to use the APIs.'),
(10710, 'This Allows a Date Range to be Selected in Patient Flow Board.'),
(10711, 'This appointment slot is already used, please choose another.'),
(10712, 'This appointment slot is already used, use it anyway?'),
(10713, 'This appointment slot is not available, please choose another.'),
(10714, 'This Calendar Year'),
(10715, 'This claim has been canceled.'),
(10716, 'This claim has been closed.'),
(10717, 'This claim has been denied.Reason:-'),
(10718, 'This claim has been forwarded to next level.'),
(10719, 'This claim has HCFA 1500 miscellaneous billing options'),
(10720, 'This client is currently disabled'),
(10721, 'This code is optional if only using manual lab data entry'),
(10722, 'This code is optional, but is a good practice to do so.'),
(10723, 'This code is optional, but is a good practice.'),
(10724, 'This code is optional.'),
(10725, 'This code type does not accept relations.'),
(10726, 'This completes a basic setup and will let use use the Fee Sheet to document charges for billing purposes'),
(10727, 'This context contains categories, which will be deleted. Do you still want to continue?'),
(10728, 'This Conversation'),
(10729, 'This Custom Favorite item can only be sent to the displayed lab, the one that was chosen in the Custom Favorite Group'),
(10730, 'This determines how appointments display on the calendar.'),
(10731, 'This determines which color schema used for appointment'),
(10732, 'This dialog is generated from patient problem diagnoses and the accumulated diagnoses of all past procedures.'),
(10733, 'This Enables provider in line item in the fee sheet'),
(10734, 'This Encounter'),
(10735, 'This encounter has been billed. If you need to change it, it must be re-opened.'),
(10736, 'This encounter has been billed. To make changes, re-open it or select Add More Items.'),
(10737, 'This encounter is locked. No new forms can be added.'),
(10738, 'This EOB item does not meet minimum print requirements setup in Globals or there is an unknown error.'),
(10739, 'This fax has already been sent.'),
(10740, 'This feature is not yet available'),
(10741, 'This feature is used to add patients to a recall list, i.e those that need an appointment at a future date but the appointment has not yet been scheduled'),
(10742, 'This feature is very experimental and not fully tested. Use at your own risk!'),
(10743, 'This feature will allow the default POS facility code to be overridden from the encounter.'),
(10744, 'This feature will allow the default POS facility code to be overriden from the encounter.'),
(10745, 'This field is used to decide whether to process the message as defined in HL7 Application (level 7) Processing rules'),
(10746, 'This form allows you to enter details of a visit or patient interaction'),
(10747, 'This fully functional Recall Board included in the default install can be used to add patients to the recall list'),
(10748, 'This gives you the option to delete any unwanted individual test in the group'),
(10749, 'This has to entered once in this form'),
(10750, 'This help file is divided into four sections'),
(10751, 'This help file is divided into the following sections'),
(10752, 'This ICD code can be automatically added to to Problem List by checking the P (Problem) checkbox. This selected item will show up in the Issues section under Medical problems'),
(10753, 'This invoice number has been changed to '),
(10754, 'This is a child of result'),
(10755, 'This is done in Administration > Users.'),
(10756, 'This is followed by the Edit and Add columns containing a pencil icon and a + icon'),
(10757, 'This is not a valid request'),
(10758, 'This is passed to the application along with checksum value and is unique for each USB key and thereby the user who owns it'),
(10759, 'This is public information maintained by HHS/CMS. We cannot be responsible for the data received'),
(10760, 'This is required for both manual lab result entry and for electronic ordering tests and receiving results'),
(10761, 'This is required for your security as well as ours.'),
(10762, 'This is the Beginning date for the Ledger Report.'),
(10763, 'This is the chart that is to be merged into the main chart and then deleted.'),
(10764, 'This is the default Beginning date for the Patient Flow Board. (only applicable if Allow Date Range in option above is Enabled)'),
(10765, 'This is the default Ending date for the Patient Flow Board. (only applicable if Allow Date Range in option above is Enabled)'),
(10766, 'This is the default left print margin for CMS 1500. It will adjust the final printed output left or right.'),
(10767, 'This is the default left print margin for UB04. It will adjust the final printed output left or right.'),
(10768, 'This is the default top print margin for CMS 1500. It will adjust the final printed output up or down.'),
(10769, 'This is the default top print margin for UB04. It will adjust the final printed output up or down.'),
(10770, 'This is the Ending date for the Patient Flow Board Date Range. (only applicable if Allow Date Range in option above is Enabled)'),
(10771, 'This is the latest of multiple result values.'),
(10772, 'This is the main chart that is to receive the merged data.'),
(10773, 'This is the number of messages that will be displayed in the messages widget in the patient summary screen.'),
(10774, 'This is the recommended method for a non-technical user, if executed carefully will reduce configuration errors'),
(10775, 'This is where the referrals and various other simple transactions are created'),
(10776, 'This item does not have enough data to graph'),
(10777, 'This item will be displayed on the page on a single line'),
(10778, 'This key is generated by the application and is presented to the user in the form of a QR code'),
(10779, 'This key name is already in use by you. Try again.'),
(10780, 'This layout does not exist.'),
(10781, 'This layout ID already exists'),
(10782, 'This lets you manually enter the reply to the referral as structured data'),
(10783, 'This lets you set the price level for the charges and let you charge different rates for different modes of payment.'),
(10784, 'this location'),
(10785, 'This message need not necessarily be linked to a patient'),
(10786, 'This message text is not saved automatically. Copy and save it as appropriate for the content.'),
(10787, 'This method will however result in the data becoming non-structured and one would loose the ability to document the reply in an electronic format'),
(10788, 'This module is being used by '),
(10789, 'This module is in test mode. The database will not be changed.'),
(10790, 'This module is subscription based and needs to be enabled from Administration > Globals > Connectors > Enable NewCrop eRx Service'),
(10791, 'This module is well integrated with openEMR, there are however two non-subscription based alternatives, Weno and Allscripts that can be used instead'),
(10792, 'This module promotes efficient entry of EOB data.'),
(10793, 'This Month to Date'),
(10794, 'This name already exists under this parent.'),
(10795, 'This namespace already exists in database'),
(10796, 'This new category will be a sub-category of '),
(10797, 'This order was already transmitted on'),
(10798, 'This page allows you to review each of the supported external dataloads that you can install and upgrade. Each section below can be expanded by clicking on the section header to review the status of the particular database of interest.'),
(10799, 'This page deactivated for security reasons.'),
(10800, 'This page lets you configure the orders and results'),
(10801, 'This page will inline include the login page, so that we do not have to click relogin every time.'),
(10802, 'This patient already has an appointment scheduled for'),
(10803, 'This patient does not allow SMS messaging!'),
(10804, 'This patient has no activity.'),
(10805, 'This patient ID is already in use!'),
(10806, 'This portals authentication.'),
(10807, 'This product allows only one lot per warehouse.'),
(10808, 'This protocol is not implemented'),
(10809, 'This report currently only works for ICD9 codes.'),
(10810, 'This section allows you to create and remove groups and modify or grant access privileges to existing groups. Check the check box to display section'),
(10811, 'This section can be customized to group the codes into various categories'),
(10812, 'This section DOES NOT let you create new ACOs.'),
(10813, 'This section is where the codes use to charge for the visit are selected'),
(10814, 'This section lets you search for the needed code if it is not in the default or customized options in \'Select Code\' section'),
(10815, 'This section will allow the logged in user to view existing methods or to delete them '),
(10816, 'This sets the Default Calendar View, Default is Day.'),
(10817, 'This specifies the Printing of the Custom End of Day Report grouped Provider or allow the Printing of Totals Only'),
(10818, 'This specifies whether to include date in Box 31.'),
(10819, 'This specifies which revision of the form the billing module should generate'),
(10820, 'This step will generate a file which you have to save for future use.'),
(10821, 'This step will generate a file which you have to save for future use. The file cannot be generated again. Do you want to proceed?'),
(10822, 'This user is not a member of any group'),
(10823, 'This user will receive notification of new incoming Direct messages'),
(10824, 'This utility is experimental.  Back up your database and documents before using it!'),
(10825, 'This utility is experimental. Back up your database and documents before using it!'),
(10826, 'This visit begins new contraceptive use'),
(10827, 'This visit will need a GCAC form, referral or procedure service.'),
(10828, 'This was the older metric-only Vitals form, now deprecated.'),
(10829, 'This Week to Date'),
(10830, 'This will abandon your unsaved changes. Are you sure?'),
(10831, 'This will activate the CCR(Continuity of Care Record) and CCD(Continuity of Care Document) reporting.'),
(10832, 'This will allow printing of a custom Message on the statements.'),
(10833, 'This will allow printing of the Patient Billing Note on the statements.'),
(10834, 'This will allow selection of the debugging (\'dummy\') language.'),
(10835, 'This will allow the display of help modal on help enabled pages'),
(10836, 'This will allow the use of the custom End of Day report and indicate which report to use.'),
(10837, 'This will allow use of the custom Dunning Messages on the statements.'),
(10838, 'This will be a \"dry run\" with no physical data updates.'),
(10839, 'This will clear the data from all Anterior Segment Exam fields'),
(10840, 'This will clear the data from all External Exam fields'),
(10841, 'This will clear the data from all Retina Exam fields'),
(10842, 'This will copy the selected code to the Diagnosis Codes box in the underlying Enter Details for Individual Custom Favorite Item pop-up form'),
(10843, 'This will create a backup in tar format and then send it to your web browser so you can save it'),
(10844, 'This will deactivate document the encryption and decryption features, and hide them in the UI.'),
(10845, 'This will disable the Edit button on all forms whose parent encounter is e-signed'),
(10846, 'This will disable the Edit button on any form that is e-signed'),
(10847, 'This will Display the Invoice Number in the Sales Report or the Patient Name and ID or Patient Name and Invoice Number.'),
(10848, 'This will enable encryption of items that are stored on CouchDB.'),
(10849, 'This will enable encryption of items that are stored on the drive.'),
(10850, 'This will enable signing an entire encounter, rather than individual forms'),
(10851, 'This will enable signing individual forms separately'),
(10852, 'This will enable the Ability to Exclude Selected Patient Statements from Printing.'),
(10853, 'This will fill in the Title text-box as well as ICD10 code in the Coding text-box'),
(10854, 'This will force the Billing Widget in the Patient Summary screen to always be open.'),
(10855, 'This will give the user the option to lock (separate locking and signing)'),
(10856, 'This will give you the option to set different price levels when you are manually entering CPT codes'),
(10857, 'This will hide empty e-sign logs on the patient report'),
(10858, 'This will hide the Billing Widget in the Patient Summary screen'),
(10859, 'This will merge two patient charts into one.  It is useful when a patient has been duplicated by mistake.  If that happens often, fix your office procedures - do not run this routinely!'),
(10860, 'This will not prevent you from going to the e-Prescriptions site.'),
(10861, 'This Will Print the Next Appointment on the Bottom of the Patient Ledger'),
(10862, 'This will re-display the secret key via the QR code that can then be captured and stored on the new Smartphone via its authenticator app'),
(10863, 'This will register a new U2F USB key'),
(10864, 'This will reveal the Register TOTP Key section for logged in user'),
(10865, 'This will Show Aging on the custom Statement.'),
(10866, 'This will turn off use of safe apostrophe, which is done by converting \' and \" to `.(it is highly recommended that this setting is turned off and that safe apostrophe\'s are used)'),
(10867, 'This will use the custom immunizations list rather than the standard CVX immunization list.'),
(10868, 'This will use the custom Statement showing the description instead of the codes.'),
(10869, 'This will use the custom Statment showing the description instead of the codes.'),
(10870, 'Thoracic physician'),
(10871, 'Thoracic spine'),
(10872, 'Those with adequate privilege would be able to able to Delete the transaction'),
(10873, 'Thous/CU.MM'),
(10874, 'Three Months Ago'),
(10875, 'Three Months Ahead'),
(10876, 'Three or four digits at back of your card'),
(10877, 'Thrills'),
(10878, 'Throat'),
(10879, 'Throat Cancer'),
(10880, 'Throat Cancer Surgery'),
(10881, 'Thrombosis/Stroke'),
(10882, 'Thu'),
(10883, 'Thumbnail size'),
(10884, 'Thurdsay'),
(10885, 'Thursday'),
(10886, 'Thus far the tests that can be ordered were placed in the Procedure Order Tier, only one test at a time can be placed in this tier, when ordering a recognized panel of tests the entire panel of tests is grouped together as a single test e.g. Sodium, Potassium, Chloride and Carbon dioxide grouped as Electrolyte Panel. The results of the individual returned tests in the panel are recorded as Discrete Results'),
(10887, 'Thyroid normal'),
(10888, 'Thyroid Problems'),
(10889, 'Th{{Thursday}}'),
(10890, 'TIA'),
(10891, 'Tibetan Standard, Tibetan, Central'),
(10892, 'TID'),
(10893, 'Tier'),
(10894, 'Tier 1 - Group - e.g. Serum Chemistry'),
(10895, 'Tier 1 entries should be of Category Top Group'),
(10896, 'Tier 2 - Group (will display in category column as Sub Group) - e.g. Organ/Disease Panel'),
(10897, 'Tier 2 - Procedure Order - e.g. Serum Uric Acid'),
(10898, 'Tier 3 - Discrete Result - e.g. Serum Uric Acid - will hold the returned result value and Default Units, Default Range etc'),
(10899, 'Tier 3 - Procedure Order - e.g. Electrolyte Panel'),
(10900, 'Tier 4 - Discrete Result - The actual test names to hold the results returned Na, K, Cl, CO2 and Default Units, Default Range etc'),
(10901, 'Tigrinya'),
(10902, 'Time'),
(10903, 'Time Display Format'),
(10904, 'Time Increment for Add (minutes 1-60)'),
(10905, 'Time selection'),
(10906, 'Time slot is available, saving event'),
(10907, 'Time slot is open, saving event'),
(10908, 'Time Zone'),
(10909, 'Time-To-Live for Allergies SOAP Request in seconds'),
(10910, 'Time-To-Live for Medications SOAP Request in seconds'),
(10911, 'Time-To-Live for NewCrop eRx Allergies SOAP Request in seconds.'),
(10912, 'Time-To-Live for NewCrop eRx Medications SOAP Request in seconds.'),
(10913, 'Timed event'),
(10914, 'Times array (N/A)'),
(10915, 'Timestamp and Text'),
(10916, 'Timing'),
(10917, 'TIN'),
(10918, 'Tinnitus'),
(10919, 'Tips'),
(10920, 'Title'),
(10921, 'Title - The value that will be displayed - Each word to begin with an uppercase letter'),
(10922, 'Title is required'),
(10923, 'Title V'),
(10924, 'TitleCols must be a number between 1 and 999'),
(10925, 'Titles'),
(10926, 'TM\'S:'),
(10927, 'TMs/EAMs/EE, ext nose'),
(10928, 'To'),
(10929, 'to'),
(10930, 'TO'),
(10931, 'to absolute path of file'),
(10932, 'To access it click on the Recall Board menu item in the top navigation bar or click on the Recall Board button in the Message Center'),
(10933, 'To add a copay click the \'Add Copay\' button'),
(10934, 'To add messages, please click here'),
(10935, 'To add more options to the dropdown menu go to Administration > Lists > Manage Lists and select \'Price Level\' in the dropdown box and enter the types e.g: Credit Card, Cash etc.'),
(10936, 'To add notes, please click '),
(10937, 'To add notes, please click here'),
(10938, 'To Affected Area'),
(10939, 'to affected area'),
(10940, 'To allow for each procedure line to have a separate provider you have to check the \'Support provider in line item in fee sheet\' checkbox in Administration > Globals > Billing. If not checked the rendering provider in this section will be used for all claims'),
(10941, 'To authorize the patient portal for the patient go to Dashboard > Demographics > Edit > Choices and select Yes in Allow Patient Portal drop-down box and Save'),
(10942, 'To automatically open the specified form. Some sports teams use football_injury_audit here.'),
(10943, 'To be able to link this issue to an encounter click on the button to bring up the Issues and Encounters pop-up page'),
(10944, 'To Billing View'),
(10945, 'to category'),
(10946, 'To change and activate the default parameters in the Fee Sheet go to Administration > Globals > Billing'),
(10947, 'To Clinical View'),
(10948, 'To configure the lab test go to Procedures > Configuration'),
(10949, 'To copay'),
(10950, 'To create a new message click on the Add New button at the bottom'),
(10951, 'To create another panel of tests you will repeat this process but will start by creating a Procedure Order or fruit bearing branch Tier 3, for example - Acute Hepatitis panel under the main branch or Sub Group Organ/Disease Panel (Tier 2)'),
(10952, 'To date must be later than From date!'),
(10953, 'To ded\'ble'),
(10954, 'To delete any or all the selected ICD10 codes click again on the Diagnosis Codes box to bring up the Select Diagnosis Codes pop-up window'),
(10955, 'To delink just click on the item to delink and it will get delinked and will no longer be highlighted'),
(10956, 'To Dems'),
(10957, 'To disable automatic message checking go to Administration > Globals > Connectors  and set phiMail Message Check Interval to 0 (zero) '),
(10958, 'To Disable client side SSL certificates, comment above lines in Apache configuration file and set'),
(10959, 'To Disable client side SSL certificates, comment above lines in Apache configuration file and turn off the \'Enable Client SSL\' global setting in OpenEMR and restart Apache server.'),
(10960, 'To Disable HTTPS, comment the above lines in Apache configuration file and restart Apache server.'),
(10961, 'To display the copay amount it must have been entered in the patient\'s insurance under Edit > Demographics'),
(10962, 'To do so click on the black + sign at the far end on the Serum Uric Acid order line to bring up the Enter Details pop-up'),
(10963, 'To edit an existing group (ARO) click on the icon next to the desired group. This will bring up the edit window.'),
(10964, 'To enable any other form of connectivity will require writing new code'),
(10965, 'To enable Client side ssl certificates'),
(10966, 'To Enable Client side SSL certificates authentication, HTTPS should be enabled.'),
(10967, 'To enable help - Go to  Administration > Globals > Features > Enable Help Modal'),
(10968, 'To enable help - Go to the User Name on top left > Settings > Features > Enable Help Modal'),
(10969, 'To enable help - Go to the User Name on top right > Settings > Features > Enable Help Modal'),
(10970, 'To Enable only HTTPS, perform the above changes and restart Apache server. If you want to configure client side certificates also, please configure them in the next section.'),
(10971, 'To enable Patient Portal go to Administration > Portal > Enable Version 2 Onsite Patient Portal, Enable Offsite Patient Portal or Enable CMS Portal'),
(10972, 'To Enctr'),
(10973, 'To filter by sex'),
(10974, 'To fulfill Meaningful use requirements and help track its use you can check on the Sent Summary of Care check-box and the Sent Summary of Care Electronically check-box if appropriate'),
(10975, 'To fully delete hit \'Save\''),
(10976, 'To get started you choose one of the two radio buttons. \'Invoice Search\' or \'ERA Upload\' '),
(10977, 'To help explore the various components of the Report page especially if you want to use it as an instruction manual it is suggested that you reduce the size of the browser to cover half the viewport, resize the help pop-up by clicking and dragging the bottom right corner of the pop-up. Open another instance of the browser and resize it to cover the other half of the viewport, login to openEMR '),
(10978, 'To help familiarize you with the various components of the Dashboard page it is suggested that you reduce the size of the browser to cover half the viewport, resize the help pop-up by clicking and dragging the bottom right corner of the pop-up. Open another instance of the browser and resize it to cover the other half of the viewport, login to openEMR'),
(10979, 'To help simplify implementations, commonly used templates were harmonized from existing CDA implementation guides and consolidated into a single implementation guide – the C-CDA Implementation Guide (IG) (07/2012)'),
(10980, 'To History'),
(10981, 'To include the scanned documents that are a part of the patient\'s record select the desired records by check the relevant check-boxes'),
(10982, 'To Issues'),
(10983, 'To link the Issues to an encounter first select the issue, it will be highlighted yellow, then click on one or more encounters to link them, the selected encounters will be highlighted in purple'),
(10984, 'To link this encounter/consult to an existing issue, click the '),
(10985, 'To link this encounter/consult to an existing issue, click the desired issue above to highlight it and then click [Save]. Hold down [Ctrl] button to select multiple issues.'),
(10986, 'To link this encounter/consult to an existing issue, click the desired issue above to highlight it and then click Save'),
(10987, 'to login again'),
(10988, 'To move the groups from one column to another select one or more items from the column that you need to move them out of and press the relevant button with the double chevrons.'),
(10989, 'To proceed you need a USB security key, a secure HTTPS web connection and a browser that supports U2F'),
(10990, 'To recap, a Group called Serum Chemistry (Tier 1) was created, a direct descendant or child called Serum Uric Acid (Tier 2) was created beneath it as a Procedure Order which had a single direct descendant or child also called Serum Uric Acid (Tier 3) as a Discrete Result that will hold the result value'),
(10991, 'To receive error notifications from the Direct Messaging service a valid Notification Email Address needs to be entered for the user named in Administration > Globals > Connectors > phiMail notification user'),
(10992, 'To record disclosures, please click'),
(10993, 'To register you need an authenticator app installed on your Smartphone'),
(10994, 'To resend, delete the file from Communications and try again.'),
(10995, 'To resend, delete the file from Communications, reload this page and try again.'),
(10996, 'To reveal the filters click on the eye icon'),
(10997, 'to run'),
(10998, 'To see to all the ACOs that are available click on the eye icon.'),
(10999, 'To select a particular code identify it in the returned results and click on it to select'),
(11000, 'To select multiple groups hold down the \'Shift\' or \'Ctrl\' keys while clicking.'),
(11001, 'To setup https access with client certificate authentication, do the following'),
(11002, 'To Skin'),
(11003, 'to skin'),
(11004, 'To summarize'),
(11005, 'to this visit?'),
(11006, 'To upload CCR document of already existing patient use Patient Summary Screen->Documents. For CCR document of a new patient use Miscellanous->New Documents screen'),
(11007, 'To use the help page as an instruction manual it is suggested that you reduce the size of the browser to cover half the viewport, resize the help pop-up by clicking and dragging the bottom right corner of the pop-up. Open another instance of the browser and resize it to cover the other half of the viewport, login to openEMR '),
(11008, 'To use this help file as an instruction manual it is best to resize your browser to occupy half the screen, open another instance of the browser to fill the other half of the screen, login to openEMR and open the help file in this browser and resize it by clicking and dragging the bottom right corner so that it occupies the entire half screen'),
(11009, 'To use this help file as an instruction manual it is suggested that you reduce the size of the browser to cover half the viewport, resize the help pop-up by clicking and dragging the bottom right corner of the pop-up. Open another instance of the browser and resize it to cover the other half of the viewport, login to openEMR'),
(11010, 'To:'),
(11011, 'To: '),
(11012, 'TO_CITY'),
(11013, 'TO_FAX'),
(11014, 'TO_FNAME'),
(11015, 'TO_LNAME'),
(11016, 'TO_MNAME'),
(11017, 'TO_ORGANIZATION'),
(11018, 'TO_PHONE'),
(11019, 'TO_PHONECELL'),
(11020, 'TO_POSTAL'),
(11021, 'TO_STATE'),
(11022, 'TO_STREET'),
(11023, 'TO_TITLE'),
(11024, 'TO_VALEDICTORY'),
(11025, 'Tobacco'),
(11026, 'Tobacco Cessation Intervention'),
(11027, 'Tobacco Cessation Intervention (CQM)'),
(11028, 'Tobacco use'),
(11029, 'Tobacco Use'),
(11030, 'Tobacco Use Assessment'),
(11031, 'Tobacco Use Assessment (CQM)'),
(11032, 'Today'),
(11033, 'TODAY'),
(11034, 'today'),
(11035, 'Today\'s Balance'),
(11036, 'Today\'s Charges'),
(11037, 'Today\'s Date'),
(11038, 'Today\'s Events'),
(11039, 'Toggle'),
(11040, 'Toggle All'),
(11041, 'Toggle navigation'),
(11042, 'Toggle the Patient Panel'),
(11043, 'Toggle the right-sided PMSFH panel'),
(11044, 'Token ID for the Medical Information Integration, LLC Lab Exchange Service.'),
(11045, 'Token ID for the OpenEMR Support LLC Lab Exchange Service.'),
(11046, 'Tonga (Tonga Islands)'),
(11047, 'Tonsillectomy'),
(11048, 'tonsillectomy'),
(11049, 'Tooltips'),
(11050, 'Top'),
(11051, 'Top Group'),
(11052, 'Top Margin (mm)'),
(11053, 'Topic'),
(11054, 'Total'),
(11055, 'total'),
(11056, 'Total active actions'),
(11057, 'Total active reminders after update'),
(11058, 'Total active reminders before update'),
(11059, 'Total Adj'),
(11060, 'Total amount due'),
(11061, 'Total Amount Paid'),
(11062, 'Total Balance Due'),
(11063, 'Total Charge'),
(11064, 'Total Charges'),
(11065, 'Total Clients'),
(11066, 'Total Co-Pay'),
(11067, 'Total Cost'),
(11068, 'Total Distribution for following check number is not full'),
(11069, 'total entries'),
(11070, 'Total failed reminders sent via email'),
(11071, 'Total failed reminders sent via phone'),
(11072, 'Total for'),
(11073, 'Total for '),
(11074, 'Total for category'),
(11075, 'Total inactivated reminders'),
(11076, 'Total Minimum Amount of Statement to Allow Printing'),
(11077, 'Total Minimum Dollar Amount of Statement to Allow Printing.(only applicable if Allow Statement Exclusions from Printing is enabled)'),
(11078, 'Total new reminders'),
(11079, 'Total number of appointments'),
(11080, 'Total number of Drug Screen entries'),
(11081, 'Total Number of Immunizations'),
(11082, 'Total Number of Issues'),
(11083, 'Total number of Patient Flow Board entries'),
(11084, 'Total Number of Patients'),
(11085, 'Total of'),
(11086, 'Total Pages'),
(11087, 'Total Patient Balance'),
(11088, 'Total patients'),
(11089, 'Total Patients'),
(11090, 'Total Payments'),
(11091, 'Total Records'),
(11092, 'total records'),
(11093, 'Total Records Found'),
(11094, 'Total size'),
(11095, 'Total SRH & Family Planning'),
(11096, 'Total successful reminders sent via email'),
(11097, 'Total successful reminders sent via phone'),
(11098, 'Total Time'),
(11099, 'Total Transfers'),
(11100, 'Total unchanged reminders'),
(11101, 'Total unsent reminders after sending process'),
(11102, 'Total unsent reminders after update'),
(11103, 'Total unsent reminders before sending process'),
(11104, 'Total unsent reminders before update'),
(11105, 'Total updated reminders'),
(11106, 'Totals'),
(11107, 'Totals for'),
(11108, 'Totals for '),
(11109, 'Totals Only'),
(11110, 'TOTP'),
(11111, 'TOTP - Cons'),
(11112, 'TOTP - Pros'),
(11113, 'TOTP - Time-Based One-Time Password'),
(11114, 'TOTP Key'),
(11115, 'TOTP Method already exists and is enabled. Try again.'),
(11116, 'TOTP Registration'),
(11117, 'TOTP Verification'),
(11118, 'To{{Destination}}'),
(11119, 'to{{Destination}}'),
(11120, 'TO{{Destination}}'),
(11121, 'to{{Range}}'),
(11122, 'To{{Range}}'),
(11123, 'to{{range}}'),
(11124, 'To{{range}}'),
(11125, 'Tpn{{Tonopen abbreviation}}'),
(11126, 'TP{{tonopen}}'),
(11127, 'tr'),
(11128, 'Track'),
(11129, 'Track Report'),
(11130, 'Tracks'),
(11131, 'Tracks - if the Track Anything feature is enabled it will display a list of values that can be tracked and graphed'),
(11132, 'Train'),
(11133, 'Trainer'),
(11134, 'Training'),
(11135, 'Training Type'),
(11136, 'Transact'),
(11137, 'Transaction'),
(11138, 'transaction'),
(11139, 'Transaction failed, insufficient quantity in destination lot'),
(11140, 'Transaction failed, quantity is less than zero'),
(11141, 'Transaction Id'),
(11142, 'Transaction Type'),
(11143, 'Transactions'),
(11144, 'transactions'),
(11145, 'Transactions (write optional)'),
(11146, 'Transactions (write optional) (trans)'),
(11147, 'Transactions - lists various notes about happenings in a patient\'s chart with respect to billing, legal, patient request, physician request and also generates a patient referral or counter-referral'),
(11148, 'Transactions are for events or information not necessarily tied to one specific visit or encounter'),
(11149, 'Transactions provides a mechanism to link an activity to patient that is not encounter based'),
(11150, 'Transactions, e.g. referrals (write optional) (trans)'),
(11151, 'Transactions/Referrals'),
(11152, 'Transdermal'),
(11153, 'Transfer'),
(11154, 'Transfer date'),
(11155, 'Transfer failed, insufficient quantity in source lot'),
(11156, 'Transfer Summary'),
(11157, 'Transfer to'),
(11158, 'Transferred By'),
(11159, 'Transferred Date'),
(11160, 'Transfers'),
(11161, 'Transition Of Care'),
(11162, 'Transition/Transfer of Care?'),
(11163, 'Translate Access Control Groups'),
(11164, 'Translate Appointment Categories'),
(11165, 'Translate Document Categories'),
(11166, 'Translate Layouts'),
(11167, 'Translate Lists'),
(11168, 'Translate Patient Note Titles'),
(11169, 'translate this'),
(11170, 'Translation'),
(11171, 'Translations'),
(11172, 'Transmit'),
(11173, 'Transmit - securely transmit the CCD using phiMail Direct Messaging'),
(11174, 'Transmit - securely transmit the CCR using phiMail Direct Messaging'),
(11175, 'Transmit failed'),
(11176, 'Transmit Order'),
(11177, 'Transmit Selected Orders'),
(11178, 'Trash'),
(11179, 'Trauma'),
(11180, 'Treatment'),
(11181, 'Treatment Completion Status'),
(11182, 'Treatment Goals'),
(11183, 'Treatment Plan'),
(11184, 'Treatment Planning'),
(11185, 'Treatment Received'),
(11186, 'Treatment:'),
(11187, 'Treatment: '),
(11188, 'Tree'),
(11189, 'Trend'),
(11190, 'trftime($month_format, mktime(0, 0, 0, $i, 1, 2000)) );             $month_value'),
(11191, 'Tribal 638 Free-standing Facility'),
(11192, 'Tribal 638 Provider-based Facility'),
(11193, 'Trifocal'),
(11194, 'Trifocals'),
(11195, 'Trigger point / compartment syndrome / DOMS / cramp'),
(11196, 'Trimalleolar'),
(11197, 'Tropic 2.5%'),
(11198, 'True'),
(11199, 'Trunk and abdomen'),
(11200, 'Trusted Direct Email Address'),
(11201, 'Trusted Email'),
(11202, 'Trying'),
(11203, 'Trying to create user with existing username!'),
(11204, 'Tsonga'),
(11205, 'tsp'),
(11206, 'Tswana'),
(11207, 'TTS'),
(11208, 'Tuberculosis'),
(11209, 'Tue'),
(11210, 'Tues &amp; Thur'),
(11211, 'Tuesday'),
(11212, 'Tumour'),
(11213, 'Turkish'),
(11214, 'Turkmen'),
(11215, 'Turn off auto calculations of adjustments in EOB'),
(11216, 'Turn Off birthday alert'),
(11217, 'Turn on Enable Client SSL'),
(11218, 'Turn on to show all payment history in Patient Ledger'),
(11219, 'Turn the Tooltips on/off'),
(11220, 'Tu{{Tuesday}}'),
(11221, 'Twi'),
(11222, 'twice daily'),
(11223, 'Two Years Ago'),
(11224, 'Two Years Ahead'),
(11225, 'Tx Date'),
(11226, 'Tympanic Membrane'),
(11227, 'Type'),
(11228, 'Type a brief message and hit Send Message '),
(11229, 'Type a name for the key in the text box'),
(11230, 'Type a name for your key, insert it into a USB port and click the Register button below'),
(11231, 'Type Id or Name.3 characters minimum (including spaces).'),
(11232, 'Type in Electrolyte Panel as the Name'),
(11233, 'Type in the location of the directory or folder in which the created orders (HL7 messages) will be stored'),
(11234, 'Type in the location of the directory or folder in which the returned results (HL7 messages) will be stored'),
(11235, 'Type in the URL of the external facility to which the order will be sent, this will be provided by the facility'),
(11236, 'Type in the username and password provided by the facility'),
(11237, 'Type Message...'),
(11238, 'Type of columns displayed for patient search results'),
(11239, 'Type of Disclosure'),
(11240, 'Type of Events'),
(11241, 'Type of group'),
(11242, 'Type of screen layout'),
(11243, 'Type or scan the patient identifier here'),
(11244, 'Type Sodium under Name and Sodium result under description'),
(11245, 'Type the message and click Send Message '),
(11246, 'Type the name of the drug in the Drug Search text-box'),
(11247, 'Type to search and select revenue code'),
(11248, 'Type Your message here'),
(11249, 'Types of Orders and Results'),
(11250, 'T{{one letter abbreviation for Tension/Pressure}}'),
(11251, 'T{{Thursday}}'),
(11252, 'T{{Tuesday}}'),
(11253, 'U2F'),
(11254, 'U2F - Cons'),
(11255, 'U2F - Pros'),
(11256, 'U2F devices are relatively costly'),
(11257, 'U2F Key Authentication error'),
(11258, 'U2F Key Verification'),
(11259, 'U2F Registration'),
(11260, 'U2F USB Device'),
(11261, 'UAC Appl'),
(11262, 'UAC Tot'),
(11263, 'UB04 FORM'),
(11264, 'UB04 FORM PDF'),
(11265, 'UB04 left margin in points'),
(11266, 'UB04 Margins'),
(11267, 'UB04 Margins Left'),
(11268, 'UB04 TEXT PDF'),
(11269, 'UB04 top margin in points'),
(11270, 'UCSMC codes provided by the University of Calgary Sports Medicine Centre'),
(11271, 'Ukrainian'),
(11272, 'Ulcerations'),
(11273, 'Ulcerative Colitis'),
(11274, 'Ulcers:'),
(11275, 'Unable insert version information into database'),
(11276, 'Unable to access directory'),
(11277, 'Unable to access URL'),
(11278, 'Unable to create'),
(11279, 'Unable to create patient document subdirectory'),
(11280, 'Unable to decrypt these comments since decryption failed.'),
(11281, 'Unable to decrypt these comments since the PHP mycrypt module is not installed.'),
(11282, 'Unable to decrypt these comments since the PHP openssl module is not installed.'),
(11283, 'Unable to either create credentials or send email.'),
(11284, 'Unable to find window to build'),
(11285, 'Unable to find your records. Be sure to use your correct Dob, First and Last name and Email of record.'),
(11286, 'Unable to find your records. Be sure to use your correct Dob, First and Last name and Email of record. If you have opted out of email with none on file then leave blank.'),
(11287, 'Unable to locate the data in this file.'),
(11288, 'Unable to match this payment in ar_activity'),
(11289, 'Unable to modify application config Please give write permission to'),
(11290, 'Unable to save file: Use back button!'),
(11291, 'Unapplied'),
(11292, 'Unassigned'),
(11293, 'Unauthorized'),
(11294, 'Unauthorized access to ePrescription'),
(11295, 'Unauthorized access.'),
(11296, 'Unbilled'),
(11297, 'Unbilled Only'),
(11298, 'Uncategorized'),
(11299, 'Uncle'),
(11300, 'under tongue'),
(11301, 'Underneath it will be some common drugs'),
(11302, 'Underneath it will be some common problems'),
(11303, 'Underweight'),
(11304, 'Undiagnosed'),
(11305, 'Undistributed'),
(11306, 'UNDISTRIBUTED'),
(11307, 'Undistributed is'),
(11308, 'Undo'),
(11309, 'Undo Checkout'),
(11310, 'Unexpected non-match, creating new patient for segment'),
(11311, 'Unique Clients'),
(11312, 'Unique human-readable identifier for this type'),
(11313, 'Unique Installation ID'),
(11314, 'Unique installation ID. Creates a random UUID if empty.'),
(11315, 'Unique New Clients'),
(11316, 'Unique numeric identifier for this type'),
(11317, 'Unique Seen Patients'),
(11318, 'Unique Seen Patients Report'),
(11319, 'Unique SP'),
(11320, 'Unit'),
(11321, 'Units'),
(11322, 'units'),
(11323, 'Units applicable to the result value'),
(11324, 'Units for Visit Forms'),
(11325, 'Units must be a number'),
(11326, 'Units not defined'),
(11327, 'Units/L'),
(11328, 'Unknown'),
(11329, 'unknown (see log)'),
(11330, 'Unknown Error'),
(11331, 'Unknown if ever smoked'),
(11332, 'Unknown or N/A'),
(11333, 'Unknown Selection'),
(11334, 'Unknown Transaction Error Maybe Subscriber Effective or DOB Dates'),
(11335, 'Unknown user id:'),
(11336, 'Unknown version'),
(11337, 'Unknown.'),
(11338, 'Unlike a message sent in Messages the dated reminder is not a part of the medical record'),
(11339, 'Unlike ordering a recognized panel as a single test and thus have all the component tests performed these three tests will be presented as three individual tests'),
(11340, 'Unlike the regular Groups that were created earlier, each Custom Favorite Group has an Identifying Code that has to be unique. As this is our custom group and not a lab recognized panel we will give it our arbitrary unique Identifying Code - CFGWWT001'),
(11341, 'Unlike the regular Procedure Order a Diagnostic Codes box is present allowing you to enter one or more ICD10 Diagnosis Codes as default diagnoses for this order'),
(11342, 'Unlike the regular Top Groups created thus far the Code column will have a value CFGWWT001'),
(11343, 'Unlike TOTP where there is no communication between the application and the device having the authenticator app each time the USB key is plugged in the application communicates with the USB key via the browser'),
(11344, 'unlink patient'),
(11345, 'Unnamed insurance company'),
(11346, 'Unregistered'),
(11347, 'Unregistered Modules'),
(11348, 'Unrelated Friend'),
(11349, 'Unselect All'),
(11350, 'Unselected'),
(11351, 'Unspecified'),
(11352, 'unstructured'),
(11353, 'Unstructured Documents - 2010'),
(11354, 'UNSUPPORTED database load file'),
(11355, 'Unsupported MDM OBX result type'),
(11356, 'until'),
(11357, 'until date'),
(11358, 'Until then you will continue to see payment details here.'),
(11359, 'Untimely filing'),
(11360, 'Unused'),
(11361, 'UOR'),
(11362, 'Up to'),
(11363, 'UPCOMING'),
(11364, 'Upcoming Appointments'),
(11365, 'Upcoming Events'),
(11366, 'Update'),
(11367, 'update'),
(11368, 'Update Active'),
(11369, 'Update by'),
(11370, 'Update Drug'),
(11371, 'Update files'),
(11372, 'Update Info'),
(11373, 'Update information when the patient goes to another provider, to support safety, quality, and continuity of patient care'),
(11374, 'Update List'),
(11375, 'Update Lot'),
(11376, 'Update policy number from ERA'),
(11377, 'Update Provider Number'),
(11378, 'Update Selected Items'),
(11379, 'Update Status'),
(11380, 'Update the chart to activate the Builder.'),
(11381, 'Update the chart to build this list'),
(11382, 'Update the following settings in Administration->Globals->Security'),
(11383, 'Update the following variables in file'),
(11384, 'Update User Information'),
(11385, 'Updated By'),
(11386, 'Updated fields will be purple.'),
(11387, 'Updated!'),
(11388, 'Updates Successful'),
(11389, 'Updating Access Controls'),
(11390, 'Updating demographics is not authorized.'),
(11391, 'Updating global configuration defaults'),
(11392, 'Updating version indicators'),
(11393, 'UPGRADE'),
(11394, 'Upgrade'),
(11395, 'Upgrade ACL'),
(11396, 'Upgrade Database'),
(11397, 'Upgrade SQL'),
(11398, 'Upgrades the OpenEMR database to include Procedures, Functions and tables needed for De-identification process'),
(11399, 'Upgrading will continue'),
(11400, 'UPIN'),
(11401, 'Upload'),
(11402, 'Upload / Save'),
(11403, 'Upload a Template'),
(11404, 'Upload and Apply'),
(11405, 'Upload and Install'),
(11406, 'Upload configuration data'),
(11407, 'Upload Document'),
(11408, 'Upload failed!'),
(11409, 'Upload For'),
(11410, 'Upload Image to'),
(11411, 'Upload import file:'),
(11412, 'Upload Item'),
(11413, 'Upload Patient Education PDF to'),
(11414, 'Upload processed successfully'),
(11415, 'Upload Report'),
(11416, 'Upload Template for'),
(11417, 'Upload the xml file under the category CCR'),
(11418, 'Upload this file:'),
(11419, 'Uploaded'),
(11420, 'Upon a successful search you are presented with a list of invoices. You may click on one of the invoice numbers to open a second window, which is the data entry page for manual posting. You may also click on a patient name if you want to enter a note that the front office staff will see when the patient checks in, and you may select invoices to appear on patient statements and print those statements.'),
(11421, 'Upon clicking an invoice number the \"manual posting window\" appears. Here you can change the due date and notes for the invoice, select the party for whom you are posting, and select the insurances for which all expected paymants have been received.  Most importantly, for each billing code for which an amount was charged, you can enter payment and adjustment information.'),
(11422, 'Upon clicking an invoice number the \'manual posting window\' appears. Here you can change the due date and notes for the invoice, select the party for whom you are posting, and select the insurances for which all expected payments have been received. Most importantly, for each billing code for which an amount was charged, you can enter payment and adjustment information.'),
(11423, 'Upon entering the page there are two buttons visible below the navigation bar'),
(11424, 'Upon logging in to openEMR a small envelope icon is visible on the top right. It shows the number of pending messages and dated reminders'),
(11425, 'Upon reaching a predetermined point, either a date or value, the rule will trigger one or more events'),
(11426, 'Upon searching you are presented with a list of invoices.  You may click on one of the invoice numbers to open a second window, which is the data entry page for manual posting.  You may also click on a patient name if you want to enter a note that the front office staff will see when the patient checks in, and you may select invoices to appear on patient statements and print those statements.'),
(11427, 'Upon selecting a list to edit the edit page with the list values will be displayed'),
(11428, 'Upon successful registration you will be taken back to the Manage Multi Factor Authentication landing page'),
(11429, 'Upper arm'),
(11430, 'Upper Lids'),
(11431, 'Urdu'),
(11432, 'Urgency'),
(11433, 'Urgent Care'),
(11434, 'Urgent Care Facility'),
(11435, 'URI'),
(11436, 'Urine'),
(11437, 'Urine Dribbling'),
(11438, 'Urine Frequency'),
(11439, 'Urine Hesitancy'),
(11440, 'Urine Microalbumin'),
(11441, 'Urine Stream'),
(11442, 'Urine Urgency'),
(11443, 'URL'),
(11444, 'URL for NewCrop eRx Site Address.'),
(11445, 'URL for OpenEMR support.'),
(11446, 'URL for Phone Gateway.'),
(11447, 'URL for Phone Gateway. Automated VOIP service provided by Maviq. Please visit http://signup.maviq.com for more information.'),
(11448, 'URL for the WordPress site that supports the portal'),
(11449, 'URLs for NewCrop eRx Service Address, separated by a semi-colon.'),
(11450, 'USA'),
(11451, 'Usage'),
(11452, 'Usage - is only required if you are submitting an electronic order to an external facility'),
(11453, 'Usage Indicator (ISA15)'),
(11454, 'Usage Tips'),
(11455, 'USB based tokens are used for Universal 2nd Factor - U2F authentication and as they are connected to a computer do not need batteries'),
(11456, 'Use % alone in a field to just sort on that column'),
(11457, 'Use 24 hour time format?'),
(11458, 'Use a pdf template from zend module'),
(11459, 'Use a unique word to identify this group, it has to be a single word, if using two words link them together with an underscore or hyphen.'),
(11460, 'Use Active Directory'),
(11461, 'Use an html template from zend module'),
(11462, 'Use Avery Labels'),
(11463, 'Use Blood or Serum as Specimen Type'),
(11464, 'Use certified EHR technology to identify patient-specific education resources and provide those resources to the patient if appropriate(New).'),
(11465, 'Use certified EHR technology to identify patient-specific education resources and provide those resources to the patient if appropriate.'),
(11466, 'Use Charges Panel'),
(11467, 'Use CPOE for medication orders directly entered by any licensed healthcare professional who can enter orders into the medical record per state, local and professional guidelines.'),
(11468, 'Use CPOE for medication orders.'),
(11469, 'Use CPOE for medication orders.(Alternative)'),
(11470, 'Use CPOE for procedure orders.'),
(11471, 'Use CPOE for radiology orders.'),
(11472, 'Use Custom Dunning Messages'),
(11473, 'Use Custom End of Day Report'),
(11474, 'Use Custom Immunization List'),
(11475, 'Use Custom Statement'),
(11476, 'Use Date Range'),
(11477, 'Use Defaults'),
(11478, 'Use Delete Option to Remove.'),
(11479, 'Use international date style?'),
(11480, 'Use LDAP for Authentication'),
(11481, 'Use Portal Dashboard to confirm with patient.'),
(11482, 'Use servers protocol and host in urls (portal internal only).'),
(11483, 'Use source filename'),
(11484, 'Use SSL (encrypted) connection to CouchDB'),
(11485, 'Use the fee sheet to charge for services or products. '),
(11486, 'Use the fields below for a purchase or transfer.'),
(11487, 'Use the help file on that page for further help'),
(11488, 'Use the latest versions of the following modern browsers - Chrome, Firefox, Safari, Edge and Opera'),
(11489, 'Use the Select User dropdown box to select the user(s) to whom the message will be sent'),
(11490, 'Use this feature only with newly installed sites, '),
(11491, 'Use this image'),
(11492, 'Use this section to delete existing groups or Access Request Objects (AROs)'),
(11493, 'Use topics?'),
(11494, 'Use Username'),
(11495, 'Used to enter information that pertains to this particular claim in order to facilitate processing and submitting this claim'),
(11496, 'User'),
(11497, 'User '),
(11498, 'User / Groups'),
(11499, 'User Administration'),
(11500, 'User and Facility Administration'),
(11501, 'User and Group Administration'),
(11502, 'User Cannot be Deleted'),
(11503, 'User Certificate Authentication is disabled'),
(11504, 'User Debug Error Catch'),
(11505, 'User Debugging Mode.'),
(11506, 'User Debugging Options'),
(11507, 'User Defined'),
(11508, 'User Defined Area 11'),
(11509, 'User Defined Area 12'),
(11510, 'User Defined Field'),
(11511, 'User Defined List 1'),
(11512, 'User Defined List 2'),
(11513, 'User Defined List 3'),
(11514, 'User Defined List 4'),
(11515, 'User Defined List 5'),
(11516, 'User Defined List 6'),
(11517, 'User Defined List 7'),
(11518, 'User Defined Text 1'),
(11519, 'User Defined Text 2'),
(11520, 'User Defined Text 3'),
(11521, 'User Defined Text 4'),
(11522, 'User Defined Text 5'),
(11523, 'User Defined Text 6'),
(11524, 'User Defined Text 7'),
(11525, 'User Defined Text 8'),
(11526, 'User First name'),
(11527, 'User Id'),
(11528, 'User ID'),
(11529, 'User is required to have this access control for Active Alerts and Passive Alerts'),
(11530, 'User Logon (If 03 above, else leave spaces) (ISA02)'),
(11531, 'User logon Required Indicator (ISA01~ use 00 or 03)'),
(11532, 'User Manual'),
(11533, 'User Memberships'),
(11534, 'User Name'),
(11535, 'User Name must be at least 12 characters!'),
(11536, 'User name or Host name cannot be empty'),
(11537, 'User or Host name'),
(11538, 'User Password'),
(11539, 'User Password (ISA04~ if 01 above, else leave spaces)'),
(11540, 'User password required Indicator (ISA03~ use 00 or 01)'),
(11541, 'User Settings'),
(11542, 'User Signature'),
(11543, 'User Specific Setting'),
(11544, 'User\'s New Password'),
(11545, 'Userlist1'),
(11546, 'Userlist2'),
(11547, 'Userlist3'),
(11548, 'Userlist4'),
(11549, 'Userlist5'),
(11550, 'Userlist6'),
(11551, 'Userlist7'),
(11552, 'username'),
(11553, 'Username'),
(11554, 'Username for Phone Gateway.'),
(11555, 'Username for Phone Gateway. Automated VOIP service provided by Maviq. Please visit http://signup.maviq.com for more information.'),
(11556, 'Username for SMS Gateway'),
(11557, 'Username for SMS Gateway.'),
(11558, 'Username to connect to CouchDB'),
(11559, 'Username:'),
(11560, 'Users'),
(11561, 'Users is the standard windows CN, replace the DC stuff with your domain.'),
(11562, 'Users may leave it plugged in at all times thus negating its function in 2FA'),
(11563, 'Users with appropriate privileges can edit these items by clicking on the Edit button'),
(11564, 'Users/Groups/Logs Administration'),
(11565, 'Users/Groups/Logs Administration (users)'),
(11566, 'Usertext1'),
(11567, 'Usertext2'),
(11568, 'Usertext3'),
(11569, 'Usertext4'),
(11570, 'Usertext5'),
(11571, 'Usertext6'),
(11572, 'Usertext7'),
(11573, 'Usertext8'),
(11574, 'uses php <a href=\"http://php.net/strftime\">strftime</a> format'),
(11575, 'Using 2FA'),
(11576, 'Using a fruit tree as an easier to visualize analogy will explain the concept of this hierarchy better, the trunk of the tree is the Group (Serum Chemistry), the fruit bearing branch is the actual order, Procedure Order (Serum Uric acid) and the fruit is the result, Discrete Result, also called (Serum Uric Acid) that will hold the value of the returned result. Just as the fruit is not borne on the main trunk you should not place a Discrete Result as a direct descendant or child of a Top Group. Similarly the fruit bearing branch (Procedure Order) cannot be placed as a direct descendant or child of a fruit (Discrete Result)'),
(11577, 'Using technology to improve productivity'),
(11578, 'Using the details entered into the system openEMR will generate valid HL7 v2.3 messages in 3 formats, a text file that is automatically downloaded to the downloads folder of your browser, a HL7 message that is written to a folder or directory on the server running openEMR or use SFTP - Secure File Transfer Protocol, which is a network protocol that provides file access, file transfer, and file management over a secure connection and transfer this message to a lab'),
(11579, 'Using the Feesheet'),
(11580, 'Using the main headings on the lab slip will help start this process - Organ/Disease Panels, Hematology, Individual Tests, Microbiology, Other'),
(11581, 'Using this fruit tree analogy we can get a better understanding of the steps needed to create an order for a panel of tests'),
(11582, 'Utilize at your own risk. Always verify data received'),
(11583, 'UTIs'),
(11584, 'Uyghur, Uighur'),
(11585, 'Uzbek'),
(11586, 'VABiNoc{{Binocular visual acuity}}'),
(11587, 'VABiNoc{{Binocular Visual Acuity}}'),
(11588, 'VACATION'),
(11589, 'Vacation'),
(11590, 'Vaccine'),
(11591, 'Vaccine funding program eligibility category'),
(11592, 'Vaccine Type'),
(11593, 'Vaginal Ring'),
(11594, 'Valedictory'),
(11595, 'Validate'),
(11596, 'validate'),
(11597, 'Validate and Clear'),
(11598, 'Validate and Clear validates then sets claims status only, to billed, leaving billing process unaltered and claim submission resets to unsubmitted.'),
(11599, 'Validate Log'),
(11600, 'Validate Only'),
(11601, 'Validate Only does a claim validation dry run for errors leaving claim status unaltered.'),
(11602, 'Validating'),
(11603, 'Validating Claim'),
(11604, 'Validation error: Fix and resubmit.'),
(11605, 'Validation error: Fix and resubmit. Payment values are preserved!'),
(11606, 'Validation error: Fix and resubmit. This popup info is preserved!'),
(11607, 'Validation mechanism for when modifying patient demographics.'),
(11608, 'Validation rule'),
(11609, 'Value'),
(11610, 'Value 1'),
(11611, 'Value 2'),
(11612, 'Value if comparing'),
(11613, 'Value Should be Numeric'),
(11614, 'Var1'),
(11615, 'Var2'),
(11616, 'variable to one to run de-identification upgrade script'),
(11617, 'Variation in red color discrimination between the eyes (eg. OD=100, OS=75)'),
(11618, 'Variation in white (muscle) light brightness discrimination between the eyes (eg. OD=$1.00, OS=$0.75)'),
(11619, 'Varicella 1'),
(11620, 'Varicella 2'),
(11621, 'Varicose Veins'),
(11622, 'Various text fields and drop-down boxes will be displayed'),
(11623, 'Vascular condition'),
(11624, 'Vascular injury'),
(11625, 'Vascular Surgery'),
(11626, 'Va{{Visual Acuities}}'),
(11627, 'VB{{abbreviation for Vertical Prism Base}}'),
(11628, 'VD{{abbreviation for Vertex Distance}}'),
(11629, 'Venda'),
(11630, 'Vendor'),
(11631, 'Verification Status'),
(11632, 'Verified On'),
(11633, 'Verify'),
(11634, 'Version'),
(11635, 'Version 1 Onsite Patient Portal Site Address'),
(11636, 'Version 2 Onsite Patient Portal Site Address'),
(11637, 'Version 2.x is widely used in the healthcare industry and openEMR uses HL7 version 2.3 '),
(11638, 'Version Number'),
(11639, 'Vert Base{{abbreviation for Vertical Prism Base}}'),
(11640, 'Vert Distance{{abbreviation for Vertex Distance}}'),
(11641, 'Vert Fissure{{vertical fissure height}}'),
(11642, 'Vert Fissure{{vertical fissure}}'),
(11643, 'Vert Fusional Amps'),
(11644, 'Vert Prism{{abbreviation for Vertical Prism Power}}'),
(11645, 'Vertex Distance'),
(11646, 'Vertical Fissure: central height between lid margins'),
(11647, 'Vertical Fusional'),
(11648, 'Vertical Menu Style'),
(11649, 'Vertical Menu Style for frame based layouts'),
(11650, 'Vertical Menu Style for Frames'),
(11651, 'Vertical Prism Base'),
(11652, 'Vertical Prism Power'),
(11653, 'Vertigo'),
(11654, 'Very secure'),
(11655, 'Vessels'),
(11656, 'Veteran`s Administration'),
(11657, 'Veterans Administration Plan'),
(11658, 'Vfc'),
(11659, 'VFC'),
(11660, 'VFC eligible- American Indian/Alaskan Native'),
(11661, 'VFC eligible- Uninsured'),
(11662, 'VFC eligible-Federally Qualified Health Center Patient (under-insured)'),
(11663, 'VFC eligible-Medicaid/Medicaid Managed Care'),
(11664, 'VF{{vertical fissure}}'),
(11665, 'via{{shipped by/supplier}}'),
(11666, 'Vietnamese'),
(11667, 'View'),
(11668, 'view'),
(11669, 'view - can only read but not add or modify'),
(11670, 'View Allergies'),
(11671, 'View an x12-835 ERA file'),
(11672, 'View Batch Claim x12 text'),
(11673, 'View Blank Referral Form'),
(11674, 'View CCD'),
(11675, 'View CCDA'),
(11676, 'View Comprehensive Patient Report'),
(11677, 'View CSV tables'),
(11678, 'View details'),
(11679, 'View document'),
(11680, 'View EDI x12 file'),
(11681, 'View encounter'),
(11682, 'View ERA x12 text'),
(11683, 'View events in a popup window?'),
(11684, 'View Facility Specific User Information'),
(11685, 'View Four Panel'),
(11686, 'View local x12 file'),
(11687, 'View Log'),
(11688, 'View Messages'),
(11689, 'View mode - only administrator can edit another administrator user'),
(11690, 'View Page 1'),
(11691, 'View Page 2'),
(11692, 'View Past and Future Reminders'),
(11693, 'View Past Encounter'),
(11694, 'View Past Encounters'),
(11695, 'View Patient'),
(11696, 'View Plan Rules'),
(11697, 'View Printable'),
(11698, 'View Printable Report'),
(11699, 'View Printable Version'),
(11700, 'View related encounters'),
(11701, 'View Report'),
(11702, 'View the README file'),
(11703, 'View the Summary Report sent to Fax Server.'),
(11704, 'View the Summary Report sent via Fax Server on'),
(11705, 'View, Download, Transmit (VDT)  (Measure B)'),
(11706, 'View, Download, Transmit (VDT) (Measure A)'),
(11707, 'View/Add/Update groups'),
(11708, 'View/Add/Update groups (gadd)'),
(11709, 'View/Create/Update groups appointment in calendar'),
(11710, 'View/Create/Update groups appointment in calendar (gcalendar)'),
(11711, 'View/Edit'),
(11712, 'View/Edit Allergies'),
(11713, 'View/edit issue'),
(11714, 'View/Print'),
(11715, 'View/Print Blank Referral Form'),
(11716, 'View/Print Blank Referral Form - that can be filled by hand'),
(11717, 'View:'),
(11718, 'VISA'),
(11719, 'VISA/MC/AMEX/Dis'),
(11720, 'VISA/MC/Discovery/HSA'),
(11721, 'Visceral damage/trauma/surgery'),
(11722, 'VisForm'),
(11723, 'Vision'),
(11724, 'Visit'),
(11725, 'Visit Attributes'),
(11726, 'Visit Categories'),
(11727, 'Visit Category'),
(11728, 'Visit Category:'),
(11729, 'Visit Date'),
(11730, 'Visit date'),
(11731, 'Visit Details'),
(11732, 'Visit Form Attributes'),
(11733, 'Visit form ID must start with LBF. Transaction form ID must start with LBT.'),
(11734, 'Visit Forms'),
(11735, 'Visit Forum'),
(11736, 'Visit History'),
(11737, 'Visit Patient Home Page'),
(11738, 'Visit Provider Home Page'),
(11739, 'Visit Reason'),
(11740, 'Visit Status'),
(11741, 'Visit Summary'),
(11742, 'Visit Test Server'),
(11743, 'Visit Type'),
(11744, 'Visited Patients'),
(11745, 'Visits'),
(11746, 'Visits From'),
(11747, 'Visual Acuities'),
(11748, 'Visual Acuity'),
(11749, 'Visual Fields'),
(11750, 'Visualize this as not making a fruit hang off another fruit. Instead it should hang off the fruit bearing branch'),
(11751, 'Vital Signs'),
(11752, 'Vitals'),
(11753, 'Vitals (Metric)'),
(11754, 'Vitals Form Options'),
(11755, 'Vitreous'),
(11756, 'Voice'),
(11757, 'Voice Messages'),
(11758, 'Voice Sent'),
(11759, 'Voice your opinion'),
(11760, 'Void Checkout and Re-Open'),
(11761, 'Volapuk'),
(11762, 'Volapük'),
(11763, 'Vomiting'),
(11764, 'Voucher Number'),
(11765, 'VP{{abbreviation for Vertical Prism Power}}'),
(11766, 'V{{One letter abbrevation for Vision}}'),
(11767, 'W'),
(11768, 'W Rx{{Acuity with correction}}'),
(11769, 'W2W{{white-to-white}}'),
(11770, 'Waist Circ'),
(11771, 'Waist Circumference'),
(11772, 'Waiting'),
(11773, 'Walk-In'),
(11774, 'Walk-in Retail Health Clinic'),
(11775, 'Walloon'),
(11776, 'Walt Pennington'),
(11777, 'Ward of court'),
(11778, 'Warehouse'),
(11779, 'Warehouse changed'),
(11780, 'Warehouse maximum, 0 if not applicable'),
(11781, 'Warehouse minimum, 0 if not applicable'),
(11782, 'Warehouses'),
(11783, 'Warm'),
(11784, 'Warn and prevent web browser refresh'),
(11785, 'Warn, but do not prevent web browser refresh'),
(11786, 'Warning'),
(11787, 'WARNING'),
(11788, 'WARNING - FOLLOWING ACTIVE MEDICATIONS ARE ALLERGIES'),
(11789, 'Warning, Check Number already exist in the database'),
(11790, 'Warning, patient has ambiguous codes in the problems list!'),
(11791, 'Warning: A visit was already created for this patient today!'),
(11792, 'Warning: Contraception for a patient under 10 or over 50.'),
(11793, 'Warning: Contraceptive method is not compatible with a male patient.'),
(11794, 'WARNING: If you are using the 2012-10-31 Spanish version, then note you need to unzip it once before placing it in the contrib/snomed (this is because the released file was \"double-zipped\").'),
(11795, 'Warning: Navigation error. Please refresh this page.'),
(11796, 'Warning: Patient ID is not unique!'),
(11797, 'Warning: There is no product matching the contraceptive service.'),
(11798, 'Warning: There is no service matching the contraceptive product.'),
(11799, 'WARNING: This will overwrite configuration information with data from the uploaded file!'),
(11800, 'WARNINGS'),
(11801, 'Warnings'),
(11802, 'WARNINGS and Alerts/Reminders'),
(11803, 'was already uploaded'),
(11804, 'was not found'),
(11805, 'We appreciate prompt payment of balances due'),
(11806, 'We appreciate prompt payment of balances due.'),
(11807, 'We are going to create the test that can be ordered called Serum Uric Acid'),
(11808, 'We are sorry you are having troubles with your account.'),
(11809, 'we have seen your above patient for evaluation and treatment at our outpatient psychiatry clinic. Thank you for this referral.'),
(11810, 'We ran into some problems connecting your EHR to the MedEx servers'),
(11811, 'We received a credentials reset request. The link to reset your credentials is below.'),
(11812, 'We were unable to create an account.'),
(11813, 'We will be basing the Electrolyte panel off the main trunk or Group (Serum Chemistry)'),
(11814, 'We will be creating an order for three tests Blood Glucose, TSH and Vitamin D and group it in a custom group called Well Woman Tests and create a place to manually enter the returned results'),
(11815, 'We will go through the process of setting up the order for a single blood test - Serum Uric Acid'),
(11816, 'We will now create the order, or Procedure Order, called Electrolyte Panel that can be visualized as the fruit bearing branch in our hypothetical fruit tree'),
(11817, 'We will set up the order for the Electrolyte panel that consists of Serum Sodium, Potassium, Chloride and Carbon Dioxide'),
(11818, 'We will start with the most basic unit of the Procedure Orders module, to set up a single lab test order and the ability to manually record the returned result'),
(11819, 'We will use a Discrete Result for each test to hold the returned result values'),
(11820, 'We will use this branch to hold all the 9 panels, here we will be just creating the order representing one panel, the Electrolyte Panel'),
(11821, 'Weakness'),
(11822, 'Wear RX'),
(11823, 'Web based methods'),
(11824, 'Web based methods use Authentication-as-a-service and deliver OTP without need for tokens'),
(11825, 'Web Reference'),
(11826, 'Web Search'),
(11827, 'Website'),
(11828, 'Website link for the Onsite Patient Portal.'),
(11829, 'Website link for the Patient Portal.'),
(11830, 'Website link for the Version 1 Onsite Patient Portal.'),
(11831, 'Website link for the Version 2 Onsite Patient Portal.'),
(11832, 'Wed'),
(11833, 'Wednesday'),
(11834, 'Week'),
(11835, 'week'),
(11836, 'Week View'),
(11837, 'Week(s)'),
(11838, 'Weekly Exposures'),
(11839, 'weeks'),
(11840, 'Weeks'),
(11841, 'Weight'),
(11842, 'Weight Assessment and Counseling for Children and Adolescents'),
(11843, 'Weight Assessment and Counseling for Children and Adolescents (CQM)'),
(11844, 'Weight Change'),
(11845, 'Weight Loss'),
(11846, 'Weight loss clinic'),
(11847, 'Welcome'),
(11848, 'Welcome to OpenEMR'),
(11849, 'Welsh'),
(11850, 'Weno Account Clinic ID information missing'),
(11851, 'Weno Account ID information missing'),
(11852, 'Weno Admin'),
(11853, 'Weno eRx Account Id'),
(11854, 'Weno eRx Account Pass'),
(11855, 'Weno eRx Clinic ID'),
(11856, 'Weno Provider ID'),
(11857, 'Weno Sample Code'),
(11858, 'Weno Service is Enabled'),
(11859, 'Western Frisian'),
(11860, 'We{{Wednesday}}'),
(11861, 'What constitutes the order and what is its electronic format, how is it sent, how is the result received, if the system will only receive results or send orders and receive results, what labs you will be connecting to and what needs to happen at the other end, whether or not a third party will be involved in this transaction'),
(11862, 'What is to be counted?'),
(11863, 'What kind of sorting will be in the drop lists.'),
(11864, 'Wheezes:'),
(11865, 'Wheezing'),
(11866, 'Wheezing:'),
(11867, 'When a new user is created, access control is granted by the administrator or by a user with similar privileges by selecting which groups (AROs) a user can belong to.'),
(11868, 'When and how often?'),
(11869, 'When Checked, Demographics Will Open in New Window from Patient Flow Board.'),
(11870, 'When Checked, Last Staff to Update Board Will Show in Patient Flow Board.'),
(11871, 'When checked, messages are processed for patients with Patient Demographic Choice: \"Hipaa Notice Received\" set to \"Unassigned\" or \"Yes\". When unchecked, this choice must = \"YES\" to process the patient reminder. For patients with Choice =\"No\", Reminders will need to be processed manually.'),
(11872, 'When Checked, Patient Encounter Number Will Show in Patient Flow Board.'),
(11873, 'When Checked, Patient ID Will Show in Patient Flow Board.'),
(11874, 'When Checked, Visit Reason Will Show in Patient Flow Board.'),
(11875, 'When dealing with protected health information (PHI) and personally identifying information (PII) it is important to allow only authorized users access to the data'),
(11876, 'When done, click Submit (below) to apply your choices.'),
(11877, 'When such an order is placed the returned results will contains the values for all components of CBC, Comprehensive Metabolic Panel and TSH'),
(11878, 'When the generated report is displayed in a separate tab there is an option that lets you view a Printable Version that can be printed'),
(11879, 'When the key is first registered it generates a random number, which is called a nonce'),
(11880, 'When the user initially visits this page the following message will be visible'),
(11881, 'When you place an order you can search for Well Woman Tests under favorites and select it to automatically order Blood Glucose, TSH and Vitamin D with a single click'),
(11882, 'Where may related scanned or paper documents be found?'),
(11883, 'Where on your body does it occur?'),
(11884, 'Whether Insured'),
(11885, 'which days are your weekend days?'),
(11886, 'Which notes are to be displayed in the Billing Screen'),
(11887, 'While forwarding a dated reminder the old message is displayed, it can be overwritten'),
(11888, 'While it is intuitive to think of this module as the place where lab tests and imaging studies can be ordered and reviewed this module can also be used to track other procedures performed in office'),
(11889, 'While lab tests and radiological tests can be performed in the practice facility they are generally done at an external facility and the provider details for that entity will have to be entered in openEMR before the Procedure module setup can begin'),
(11890, 'Whiplash'),
(11891, 'White'),
(11892, 'White list'),
(11893, 'White-to-white'),
(11894, 'Who'),
(11895, 'Who replied?'),
(11896, 'Whose Online'),
(11897, 'Widowed'),
(11898, 'Width'),
(11899, 'Width in pixels of the left navigation frame in frame based layout.'),
(11900, 'Width in pixels of the left navigation frame.'),
(11901, 'Will add another dropdown menu in the CPT line to let you select a provider for that line item'),
(11902, 'will be hidden if'),
(11903, 'will have the following validation rules'),
(11904, 'With checked items plot'),
(11905, 'with import'),
(11906, 'with preferred language'),
(11907, 'With selected:'),
(11908, 'with the old name'),
(11909, 'With the U2F key you will need to plug it in to the USB port and then access OpenEMR using the latest versions of the following modern browsers - Chrome, Firefox, Safari, Edge and Opera and pressing the button on the device'),
(11910, 'with value'),
(11911, 'With whom may we leave a message?'),
(11912, 'Withheld'),
(11913, 'within hours'),
(11914, 'within hours:'),
(11915, 'within minutes'),
(11916, 'within minutes:'),
(11917, 'Without Facility'),
(11918, 'Without Provider'),
(11919, 'Without Update'),
(11920, 'Witness'),
(11921, 'wk'),
(11922, 'WNL'),
(11923, 'Wolof'),
(11924, 'Women'),
(11925, 'Women Only'),
(11926, 'WordPress Portal'),
(11927, 'Work'),
(11928, 'WORK NOTE'),
(11929, 'Work Phone'),
(11930, 'Work Phone Number'),
(11931, 'Work related?'),
(11932, 'Work/ Education/ Hobbies'),
(11933, 'Work/School Note'),
(11934, 'workday'),
(11935, 'Worker`s Compensation'),
(11936, 'Workers Compensation Health Plan'),
(11937, 'Working Aged Beneficiary or Spouse with Employer Group Health Plan'),
(11938, 'Working on request.'),
(11939, 'Working!'),
(11940, 'Working... this may take a minute.'),
(11941, 'Worse'),
(11942, 'Would you like the balance amount to apply to Global Account?'),
(11943, 'Would You Like them to be Marked as Cleared.'),
(11944, 'Would you like to Allocate?'),
(11945, 'Would you like to Cancel Distribution for this Patient?'),
(11946, 'Would you like to Delete Payment Distribution?'),
(11947, 'Would you like to Delete Payments?'),
(11948, 'Would you like to Modify and Finish Payments?'),
(11949, 'Would you like to Modify Payments?'),
(11950, 'Would you like to Post and Finish Payments?'),
(11951, 'Would you like to Post Payments?'),
(11952, 'Would you like to save?'),
(11953, 'Wrist'),
(11954, 'Wrist and hand'),
(11955, 'Wrist Problems'),
(11956, 'write'),
(11957, 'write - can read and fully modify'),
(11958, 'write off'),
(11959, 'Write Once'),
(11960, 'wsome'),
(11961, 'wsome - can read and partially modify'),
(11962, 'WSXGA+'),
(11963, 'WT'),
(11964, 'W{{Current Rx - wearing}}'),
(11965, 'W{{Wednesday}}'),
(11966, 'x Canceled'),
(11967, 'x Cancelled'),
(11968, 'X(T){{intermittent exophoria}}'),
(11969, 'X-ray'),
(11970, 'X-RAY Interpretation:'),
(11971, 'X-Ray Interpretation:'),
(11972, 'X12 only ICN resubmission No.'),
(11973, 'X12 only replacement claim:'),
(11974, 'X12 only: Replacement Claim'),
(11975, 'X12 only: Replacement Claim '),
(11976, 'X12 only: Replacement Claim, X12 only ICN resubmission No is used for electronic resubmission of claims. Requirement varies by insurer'),
(11977, 'X12 OPTIONS'),
(11978, 'X12 Partner'),
(11979, 'X12 Partners'),
(11980, 'x12 Segments'),
(11981, 'x12 Text'),
(11982, 'Xhosa'),
(11983, 'XHR Failed:'),
(11984, 'XML'),
(11985, 'XT{{exotropia}}'),
(11986, 'X{{exophoria}}'),
(11987, 'Y'),
(11988, 'year'),
(11989, 'Year'),
(11990, 'Year View'),
(11991, 'Year(s)'),
(11992, 'Years'),
(11993, 'years ago'),
(11994, 'Years or months'),
(11995, 'Years, months and days'),
(11996, 'Yes'),
(11997, 'YES'),
(11998, 'yes'),
(11999, 'YES!'),
(12000, 'Yes, Delete and Log'),
(12001, 'Yes, Delete this form'),
(12002, 'Yes/No'),
(12003, 'Yes:'),
(12004, 'Yiddish'),
(12005, 'Yoruba'),
(12006, 'You are about to delete template'),
(12007, 'You are about to delete the following form from this encounter'),
(12008, 'You are about to permanently replace the existing template. Are you sure you wish to continue?'),
(12009, 'You are currently logged in as'),
(12010, 'You are currently not signed in.'),
(12011, 'You are in Grace Login period. Change your password before'),
(12012, 'You are not allowed to delete this event'),
(12013, 'You are not allowed to edit this event'),
(12014, 'You are not authorized for this.'),
(12015, 'You are not authorized to access this squad'),
(12016, 'You are not authorized to access this squad.'),
(12017, 'You are not authorized to add/edit issues'),
(12018, 'You are not authorized to schedule appointments.'),
(12019, 'You are not authorized to see this encounter.'),
(12020, 'You are not authorized!'),
(12021, 'You are posting against an old encounter?'),
(12022, 'You are sending to yourself!'),
(12023, 'You are using patient validation module'),
(12024, 'You can add multiple patients to the list'),
(12025, 'You can add multiple users by selecting them one at a time'),
(12026, 'You can also add an Issue from this page by clicking on the Add Issue button to bring up the Add issue pop-up page'),
(12027, 'You can change the type or leave it as it is'),
(12028, 'You can click on the envelope icon to access the messaging center'),
(12029, 'You can click on the patient name to quickly access the patient\'s chart'),
(12030, 'You can click on the Select All button to choose all authorized users'),
(12031, 'You can close the edit box by clicking on the \'slashed eye\' icon next to the group\'s name.'),
(12032, 'You can delete the recall by clicking on the X button on the top right corner of the cell'),
(12033, 'You can download the Loinc Universal LabOrders ValueSet.csv file from here'),
(12034, 'You can edit the title if you so choose'),
(12035, 'You can enter data into all 5 categories from this page'),
(12036, 'You can link the allergy to one or more encounters if appropriate'),
(12037, 'You can link the medication to one or more encounters if appropriate'),
(12038, 'You can not access this function directly.'),
(12039, 'You can not change status to \'Arrive\' before the appointment\'s time'),
(12040, 'You can only add to the existing message and cannot edit previously entered data'),
(12041, 'You can only place an order for Electrolyte Panel and have the entire panel tested and have their results returned'),
(12042, 'You can only select'),
(12043, 'You can search for and select the codes by clicking once on each line containing the code'),
(12044, 'You can sort the pending messages in ascending or descending order by clicking on the arrowhead in each cell of the table header'),
(12045, 'You can then proceed to link the newly added issue to encounters'),
(12046, 'You can upload content and label them by ICD10 code enable you to search and download the selected material'),
(12047, 'You can use LOINC codes for the Standard Codes'),
(12048, 'You can use the above method to create orders for the rest of the Organ/Disease Panels except for the General Health Panel that consists of CBC, Comprehensive Metabolic Panel and TSH and the Obstetric Panel that has CBC as one of its components'),
(12049, 'You can use the codes given on the paper lab slip of a local lab of major lab as the Identifying codes'),
(12050, 'You cannot access this page directly.'),
(12051, 'You cannot add a blank value for a category!'),
(12052, 'You cannot add a blank value for a subcategory!'),
(12053, 'You cannot add a blank value for an item!'),
(12054, 'You cannot edit the already chosen lab, if sending to different lab delete entry and create a new one'),
(12055, 'You cannot enter a future date with a completed value of YES.'),
(12056, 'You could manually edit this date should you choose to or an entirely different date'),
(12057, 'You did not choose any actions.'),
(12058, 'You do not have access to view/edit this note'),
(12059, 'You have'),
(12060, 'You have an invoice due for payment in your Patient Documents. There you may pay, download or print the invoice. Thank you.'),
(12061, 'You have attempted to alter content which is locked. Remove the lock if you want to do this. To unlock, remove the line, \'/*lock::*/\''),
(12062, 'You have been signed out. Thank you.'),
(12063, 'You have been successfully logged out.'),
(12064, 'You have chosen to be self insured or currently do not have insurance. Click next to continue registration.'),
(12065, 'You have finished the assessment.'),
(12066, 'You have not entered any clinical services or products. Click Cancel to add them. Or click OK if you want to save as-is.'),
(12067, 'You have now successfully completed an order for a single lab test'),
(12068, 'You have selected to delete'),
(12069, 'You have to have an understanding how the program is structured and the ability and willingness to modify the underlying code.'),
(12070, 'You have unsaved changes.'),
(12071, 'You have unsaved changes. Abandon them?'),
(12072, 'You have unsaved changes. Do you really want to close this form?'),
(12073, 'You may be required to change your password during first login.'),
(12074, 'You may only upload .txt files'),
(12075, 'You may optionally upload HL7 results from a file'),
(12076, 'You may put text here as the default complaint in the New Patient Encounter form.'),
(12077, 'You may still use formatting if template is also used in Nation Notes however, pure text will still render here.'),
(12078, 'You may type in a name of the person referring or leave blank'),
(12079, 'You may want to try returning to the the previous page and verifying that all fields have been filled out correctly.'),
(12080, 'You must activate Weno first! Go to Administration, Globals, Connectors'),
(12081, 'You must agree to the HIPAA Business Associate Agreement'),
(12082, 'You must agree to the Terms & Conditions before signing up'),
(12083, 'You must confirm this Username.'),
(12084, 'You must enter a new or reenter current password to keep it. Even for Username change.'),
(12085, 'You must enter a pass phrase to encrypt the document'),
(12086, 'You must enter a reason to cancel this appointment?'),
(12087, 'You must enter your own password to change user passwords. Leave blank to keep password unchanged.'),
(12088, 'You must first select an item in the section whose radio button is checked.'),
(12089, 'You must first select or add a patient or therapy group.'),
(12090, 'You must first select or add a patient.'),
(12091, 'You must first select or create an encounter.'),
(12092, 'You must select a visit category'),
(12093, 'You must select a visit category.'),
(12094, 'You must select some fields to continue.'),
(12095, 'You need administrator privileges to add more options'),
(12096, 'You need administrator privileges to disable the default Recall Board'),
(12097, 'You need administrator privileges to enable the MedEx Communication Service'),
(12098, 'You need administrator privileges to give access to other groups'),
(12099, 'You need administrator privileges to increase the number of reminders to show'),
(12100, 'You need administrator privileges to perform the changes to the values in the drop-down boxes.'),
(12101, 'You need administrator privileges to perform the setup'),
(12102, 'You need administrator privileges to perform this action'),
(12103, 'You need to go back and and create a provider'),
(12104, 'You should be running this test if this claim appeared to generate successfully but the actual claim file does not contain any data or only an unfinished portion of the amount of data it is supposed to contain. It is obvious with HCFA claims because they are human readable, with X12 claims it is a more difficult process to determine if the claim is properly complete.'),
(12105, 'You should not make Discrete Result for Potassium be a descendant of a preceding Discrete Result i.e Sodium , i.e have a Tier value of 5'),
(12106, 'You should select at least one context'),
(12107, 'You should select at least one Provider'),
(12108, 'You will be automatically redirected to Demographics. You may make the necessary corrections and navigate to NewCrop again.'),
(12109, 'You will be notified when the payment transaction is confirmed.'),
(12110, 'You will be notified when your payment is applied for this invoice.'),
(12111, 'You will need Administrator privileges to edit this form'),
(12112, 'You will need Administrator privileges to enable the patient portal'),
(12113, 'You will need Administrator Privileges to install the ICD10 code set'),
(12114, 'You will need Administrator privileges to setup phiMail Direct Messaging'),
(12115, 'You will need Administrator privileges to setup the NewCrop service and has to be setup in conjunction with technical support from the NewCrop eRx service'),
(12116, 'Your account has been successfully created however, we were unable to send the account information.'),
(12117, 'Your browser does not support HTML5 audio'),
(12118, 'Your Clinical Report'),
(12119, 'Your credentials are provided by your provider'),
(12120, 'Your current TOTP key QR code is displayed below.'),
(12121, 'your email address'),
(12122, 'Your end date is invalid'),
(12123, 'Your event has been deleted.'),
(12124, 'Your event has been modified.'),
(12125, 'Your event has been submitted.'),
(12126, 'Your file doesn\'t have an extension'),
(12127, 'Your file is too large'),
(12128, 'Your first day of the week.'),
(12129, 'Your Id is missing. Cancel and try again.'),
(12130, 'Your installation of OpenEMR has been registered'),
(12131, 'Your Lab Results'),
(12132, 'Your list name has been changed to meet naming requirements.'),
(12133, 'Your message was submitted for delivery to'),
(12134, 'Your name for this category, procedure or result'),
(12135, 'Your new credentials have been sent. Check your email inbox and also possibly your spam folder. Once you log into your patient portal feel free to make an appointment or send us a secure message. We look forward to seeing you soon.'),
(12136, 'your next appointment at'),
(12137, 'Your on file email address'),
(12138, 'Your one time credential reset link has expired. Reset and try again.'),
(12139, 'Your Password'),
(12140, 'Your Password Expired. Please change your password.'),
(12141, 'Your Password Expires on'),
(12142, 'Your password expires today. Please change your password now.'),
(12143, 'Your Password Expires today. Please change your password.'),
(12144, 'Your password is your signature'),
(12145, 'Your Portal Login Web Address. Bookmark for future logins.'),
(12146, 'Your PostCalendar configuration has been reset to use defaults.'),
(12147, 'Your PostCalendar configuration has been updated.'),
(12148, 'Your repeating frequency must be an integer.'),
(12149, 'Your repeating frequency must be at least 1.'),
(12150, 'Your safe key is'),
(12151, 'Your start date is greater than your end date'),
(12152, 'Your start date is invalid'),
(12153, 'Your submission failed.'),
(12154, 'Your weekend days'),
(12155, 'Yubikey also sells more expensive U2F keys designed to work with mobile devices'),
(12156, 'yyyy-mm-dd'),
(12157, 'YYYY-MM-DD'),
(12158, 'yyyy-mm-dd date associated with this document'),
(12159, 'yyyy-mm-dd date destroyed'),
(12160, 'yyyy-mm-dd date of birth'),
(12161, 'yyyy-mm-dd Date of Birth'),
(12162, 'yyyy-mm-dd date of expiration'),
(12163, 'yyyy-mm-dd Date of onset or hospitalization'),
(12164, 'yyyy-mm-dd date of onset, surgery or start of medication'),
(12165, 'yyyy-mm-dd date of purchase or transfer'),
(12166, 'yyyy-mm-dd date of recovery or end of medication'),
(12167, 'yyyy-mm-dd Date of return to play'),
(12168, 'yyyy-mm-dd Date of service'),
(12169, 'yyyy-mm-dd date of this letter'),
(12170, 'yyyy-mm-dd date returned to play'),
(12171, 'yyyy-mm-dd document date'),
(12172, 'yyyy-mm-dd End Date'),
(12173, 'yyyy-mm-dd event date or starting date'),
(12174, 'yyyy-mm-dd H:m End Date'),
(12175, 'yyyy-mm-dd H:m End date'),
(12176, 'yyyy-mm-dd H:m Start Date'),
(12177, 'yyyy-mm-dd H:m Start date'),
(12178, 'yyyy-mm-dd hh:mm:ss'),
(12179, 'yyyy-mm-dd Hours(24):minutes'),
(12180, 'yyyy-mm-dd last date of this event'),
(12181, 'yyyy-mm-dd Start Date'),
(12182, 'yyyy-mm-dd starting date for search'),
(12183, 'ZEF segment internal error'),
(12184, 'Zend Module'),
(12185, 'Zend Module check in addition to standard check'),
(12186, 'Zero'),
(12187, 'Zhuang, Chuang'),
(12188, 'Zip'),
(12189, 'Zip Code'),
(12190, 'ZIP Code'),
(12191, 'Zip/Country:'),
(12192, 'Zoom'),
(12193, 'Zoom in'),
(12194, 'Zoom out'),
(12195, 'Zoom: click-drag, Pan: shift-click-drag, Restore: double-click'),
(12196, 'Zulu'),
(12197, ' but was '),
(12198, ' could not be accessed.'),
(12199, ' Do you really want to delete'),
(12200, ' Drug'),
(12201, ' emails not sent'),
(12202, ' from'),
(12203, ' has been created. '),
(12204, ' has been re-opened.'),
(12205, ' History'),
(12206, ' is not a number'),
(12207, ' is ready for re-billing.'),
(12208, ' LLL:'),
(12209, ' Lot'),
(12210, ' Medicaid Original Reference No. '),
(12211, ' min'),
(12212, ' not found!'),
(12213, ' Pecularities in many browsers may mean that the output below enters your screen in sudden jerks and that there are long pauses of several seconds where it  appears as though things may have crashed. That is not the case, you will eventually see output coming out line by line. There may be sequential numbers appearing  below, this is to indicate that even though nothing else may be displaying there is activity going on. These numbers will be interspersed with the content of the  billing and that is normal.'),
(12214, ' prescription has reached its limit of'),
(12215, ' until '),
(12216, ' update failed, not in database?'),
(12217, ' was marked as billed only.'),
(12218, ' was queued successfully.'),
(12219, '! Left w/o visit'),
(12220, '\" for code '),
(12221, '\" is CHECKED in PostCalendar Settings!'),
(12222, '# Ins/fin issue'),
(12223, '# of tablets:'),
(12224, '$'),
(12225, '$ Coding done'),
(12226, '$label (yyyy-mm-dd): '),
(12227, '%'),
(12228, '% Canceled < 24h'),
(12229, '% Cancelled <  24h '),
(12230, '\' should exist but does not.'),
(12231, '(% matches any string, _ matches any character)'),
(12232, '([ctrl] + click to select multiple recipients)'),
(12233, '(Back)'),
(12234, '(Click to edit)'),
(12235, '(Email delivery is immediate, while automated VOIP is sent to the service provider for further processing.)'),
(12236, '(More)'),
(12237, '(New Patient)'),
(12238, '(Notes and Authorizations)'),
(12239, '(Patient Notes)'),
(12240, '(Select one of these, or type your own title)'),
(12241, '(Shift-)Click or drag to change value'),
(12242, '* Reminder done'),
(12243, '** Please move surgeries to Issues!'),
(12244, '*Required'),
(12245, '+ Chart pulled'),
(12246, '+1'),
(12247, '+2'),
(12248, '+3'),
(12249, '- None'),
(12250, '- Not Reported'),
(12251, '-- All --'),
(12252, '--Select Role--'),
(12253, '.'),
(12254, '0'),
(12255, '0-10'),
(12256, '0-24'),
(12257, '02/12{{CMS 1500 format date revision setting in globals}}'),
(12258, '08/05{{CMS 1500 format date revision setting in globals}}'),
(12259, '1'),
(12260, '1 = North America. See http://www.wtng.info/ for a list of other country codes.'),
(12261, '1 Day From Now'),
(12262, '1 Month From Now'),
(12263, '1 Week From Now'),
(12264, '1 Year From Now'),
(12265, '1.Rest 2. Ice for two days 3. Compression, leave the dressing in place unless the foot develops numbness or pale color 4. Elevate the foot and leg'),
(12266, '11-14'),
(12267, '12 hr'),
(12268, '15-19'),
(12269, '1mm'),
(12270, '1st'),
(12271, '1st{{nth}}'),
(12272, '2'),
(12273, '2 Days From Now'),
(12274, '2 Months From Now'),
(12275, '2 Weeks From Now'),
(12276, '2 Years From Now'),
(12277, '2-20 years'),
(12278, '20-24'),
(12279, '2011 Automated Measure Calculations (AMC)'),
(12280, '2011 Clinical Quality Measures (CQM)'),
(12281, '2011 Official Clinical Quality Measures (CQM) Measure Groups'),
(12282, '2014 Automated Measure Calculations (AMC)'),
(12283, '2014 Automated Measure Calculations (AMC) - Stage I'),
(12284, '2014 Automated Measure Calculations (AMC) - Stage II'),
(12285, '2014 Clinical Quality Measures (CQM)'),
(12286, '2014 Official Clinical Quality Measures (CQM) Measure Groups'),
(12287, '2111-13'),
(12288, '24 hr'),
(12289, '25+'),
(12290, '25-29'),
(12291, '271 Returned'),
(12292, '2mm'),
(12293, '2nd'),
(12294, '2nd{{every}}'),
(12295, '2nd{{nth}}'),
(12296, '3 Days From Now'),
(12297, '3 months'),
(12298, '3 Months From Now'),
(12299, '3 times daily'),
(12300, '3 Weeks From Now'),
(12301, '30-34'),
(12302, '35-39'),
(12303, '3mm'),
(12304, '3rd'),
(12305, '3rd{{every}}'),
(12306, '3rd{{nth}}'),
(12307, '4 Days From Now'),
(12308, '4 months'),
(12309, '4 Months From Now'),
(12310, '4 times daily'),
(12311, '4 Weeks From Now'),
(12312, '40-44'),
(12313, '45+'),
(12314, '465.9, URI'),
(12315, '466.0, Bronchitis, Acute NOS'),
(12316, '486.0, Pneumonia, Acute'),
(12317, '491.21, COPD Exacerbation'),
(12318, '491.8, Bronchitis, Chronic'),
(12319, '493.92, Asthma, Acute Exac.'),
(12320, '496.0, COPD'),
(12321, '4K UHD'),
(12322, '4mm'),
(12323, '4th'),
(12324, '4th{{every}}'),
(12325, '4th{{nth}}'),
(12326, '5 Days From Now'),
(12327, '5 Months From Now'),
(12328, '5 Weeks From Now'),
(12329, '519.7, Bronchospasm'),
(12330, '5mm'),
(12331, '5th'),
(12332, '5th{{every}}'),
(12333, '6 Days From Now'),
(12334, '6 months'),
(12335, '6 Months From Now'),
(12336, '6 Weeks From Now'),
(12337, '6th'),
(12338, '6th{{every}}'),
(12339, '7 Months From Now'),
(12340, '8 Months From Now'),
(12341, '8-12 characters long, including at least one upper case letter, one lower case letter, one number, one special character and no common strings'),
(12342, '824.0 Fracture, medial malleolus, closed'),
(12343, '824.2 Fracture, lateral malleolus, closed'),
(12344, '824.6 Fracture, Trimalleolar, closed'),
(12345, '825.32 Fracture, of Navicular (ankle)'),
(12346, '825.35 Fracture, Base of fifth (5th) Metatarsal'),
(12347, '845.00 ankle sprain NOS'),
(12348, '845.01 Sprain Medial (Deltoid) Lig.'),
(12349, '845.02 Sprain, Calcaneal fibular'),
(12350, '9 Months From Now'),
(12351, '99212 Established - Uncomplicated'),
(12352, '99213 Established - Low Complexity'),
(12353, '< In exam room'),
(12354, '< Not Reported'),
(12355, '= Took Place'),
(12356, '> 3 HPI elements'),
(12357, '> Checked out'),
(12358, '> Did Not Take Place'),
(12359, '?'),
(12360, '? Did Not Attend'),
(12361, '? No show'),
(12362, '@ Arrived'),
(12363, '@ Attended'),
(12364, '[Change View]'),
(12365, '[Date of Last Encounter]'),
(12366, '[Days Since Last Encounter]'),
(12367, '[EOBs]'),
(12368, '[Export OFX]'),
(12369, '[not recommended]'),
(12370, '[Number Of Encounters]'),
(12371, '[Reports]'),
(12372, '[Select All]'),
(12373, '[SQL-Ledger]'),
(12374, '[Start Batch Processing]'),
(12375, '[View Log]'),
(12376, '[View Printable Report]'),
(12377, '^ Pending'),
(12378, '_PC_DUR_HOURS'),
(12379, '_PC_DUR_MINUTES'),
(12380, '_PC_LOCALE'),
(12381, '~ Arrived late'),
(12382, '~ Late Arrival');

--


--
-- Table structure for table `lang_definitions`
--


DROP TABLE IF EXISTS `lang_definitions`;
CREATE TABLE `lang_definitions` (
  `def_id` int(11) NOT NULL auto_increment,
  `cons_id` int(11) NOT NULL default '0',
  `lang_id` int(11) NOT NULL default '0',
  `definition` mediumtext,
  UNIQUE KEY `def_id` (`def_id`),
  KEY `cons_id` (`cons_id`)
) ENGINE=InnoDB AUTO_INCREMENT=197734 ;


--
-- Dumping data for table `lang_definitions`
--

INSERT INTO `lang_definitions` VALUES (1, 1, 2, 'En');
INSERT INTO `lang_definitions` VALUES (2, 2, 2, 'Ett betalningsnr för att identifiera betalningen');
INSERT INTO `lang_definitions` VALUES (3, 4, 2, 'Klientcertifikat för admin användaren');
INSERT INTO `lang_definitions` VALUES (4, 7, 2, 'Ett klinikdokument är bifogat');
INSERT INTO `lang_definitions` VALUES (5, 13, 2, 'En distributör behövs');
INSERT INTO `lang_definitions` VALUES (6, 17, 2, 'Ett GCAC besöksformulär ska läggas till för detta besök');
INSERT INTO `lang_definitions` VALUES (7, 20, 2, 'Ett lot-nr krävs!');
INSERT INTO `lang_definitions` VALUES (8, 21, 2, 'Ett lot-nr krävs!');
INSERT INTO `lang_definitions` VALUES (9, 22, 2, 'En liten bokstav');
INSERT INTO `lang_definitions` VALUES (10, 28, 2, 'Ett tal');
INSERT INTO `lang_definitions` VALUES (11, 30, 2, 'En patient med detta ID finns redan');
INSERT INTO `lang_definitions` VALUES (12, 31, 2, 'En patient med detta namn finns redan');
INSERT INTO `lang_definitions` VALUES (13, 32, 2, 'En patient med detta personnummer ( SS ) finns redan');
INSERT INTO `lang_definitions` VALUES (14, 36, 2, 'ייהי)7)))');
INSERT INTO `lang_definitions` VALUES (15, 37, 2, 'Ett positivt nummer kommer visa antalet tidigare bokningar i en ruta på patientöversikten.');
INSERT INTO `lang_definitions` VALUES (16, 43, 2, 'Den remitterande instansen kan framgå vid varje besök');
INSERT INTO `lang_definitions` VALUES (17, 44, 2, 'En relaterad IPPF kod krävs!');
INSERT INTO `lang_definitions` VALUES (18, 49, 2, 'Ett specialtecken');
INSERT INTO `lang_definitions` VALUES (19, 53, 2, 'Ett unikt värde, som ej är synlig för användaren, identifierar detta fält.');
INSERT INTO `lang_definitions` VALUES (20, 57, 2, 'Före måltid');
INSERT INTO `lang_definitions` VALUES (21, 58, 2, 'förmiddag');
INSERT INTO `lang_definitions` VALUES (22, 62, 2, 'AB');
INSERT INTO `lang_definitions` VALUES (23, 63, 2, 'Förkortning');
INSERT INTO `lang_definitions` VALUES (24, 64, 2, 'Abscess');
INSERT INTO `lang_definitions` VALUES (25, 65, 2, 'Abdominell');
INSERT INTO `lang_definitions` VALUES (26, 66, 2, 'kan bära vikt fyra (4) steg:');
INSERT INTO `lang_definitions` VALUES (27, 67, 2, 'Patologisk');
INSERT INTO `lang_definitions` VALUES (28, 68, 2, 'ABN1');
INSERT INTO `lang_definitions` VALUES (29, 70, 2, 'Patologisk');
INSERT INTO `lang_definitions` VALUES (30, 71, 2, 'Patologiskt blodprov');
INSERT INTO `lang_definitions` VALUES (31, 72, 2, 'Avvikande hårväxt');
INSERT INTO `lang_definitions` VALUES (32, 73, 2, 'Patologisk mammografi');
INSERT INTO `lang_definitions` VALUES (33, 75, 2, 'Abort');
INSERT INTO `lang_definitions` VALUES (34, 76, 2, 'Abortrelaterad problematik');
INSERT INTO `lang_definitions` VALUES (35, 77, 2, 'Abortmetod');
INSERT INTO `lang_definitions` VALUES (36, 78, 2, 'Abortrelaterade kategorier');
INSERT INTO `lang_definitions` VALUES (37, 79, 2, 'Aborter');
INSERT INTO `lang_definitions` VALUES (38, 82, 2, 'Om kalendern');
INSERT INTO `lang_definitions` VALUES (39, 85, 2, 'Frånvaro av Diagnos');
INSERT INTO `lang_definitions` VALUES (40, 87, 2, 'Acceptera uppdrag');
INSERT INTO `lang_definitions` VALUES (41, 89, 2, 'acceptera betalning för');
INSERT INTO `lang_definitions` VALUES (42, 90, 2, 'acceptera betalning för');
INSERT INTO `lang_definitions` VALUES (43, 91, 2, 'Accepterar uppdrag');
INSERT INTO `lang_definitions` VALUES (44, 93, 2, 'Åtkomstkontroll');
INSERT INTO `lang_definitions` VALUES (45, 94, 2, 'Hantera åtkomst');
INSERT INTO `lang_definitions` VALUES (46, 102, 2, 'Åtkomst ej tillåten');
INSERT INTO `lang_definitions` VALUES (47, 103, 2, 'Åtkomst ej tillåten');
INSERT INTO `lang_definitions` VALUES (48, 105, 2, 'Öppna patientöversikten');
INSERT INTO `lang_definitions` VALUES (49, 113, 2, 'Konto namn');
INSERT INTO `lang_definitions` VALUES (50, 117, 2, 'Redovisning');
INSERT INTO `lang_definitions` VALUES (51, 122, 2, 'värker');
INSERT INTO `lang_definitions` VALUES (52, 124, 2, 'Begärt godokännande (ISA14)');
INSERT INTO `lang_definitions` VALUES (53, 125, 2, 'Godkännande, licenser och certifikat');
INSERT INTO `lang_definitions` VALUES (54, 126, 2, 'Användarlista (ACL)');
INSERT INTO `lang_definitions` VALUES (55, 127, 2, 'Administration av användarlista (ACL)');
INSERT INTO `lang_definitions` VALUES (56, 129, 2, 'Ej behörig administrera användarlista (ACL)');
INSERT INTO `lang_definitions` VALUES (57, 133, 2, 'Akne');
INSERT INTO `lang_definitions` VALUES (58, 136, 2, 'Aktuellt');
INSERT INTO `lang_definitions` VALUES (59, 137, 2, 'Aktivitetsdatum');
INSERT INTO `lang_definitions` VALUES (60, 138, 2, 'Åtgärd');
INSERT INTO `lang_definitions` VALUES (61, 142, 2, 'Åtgärder');
INSERT INTO `lang_definitions` VALUES (62, 144, 2, 'Rapportera fortsatt vårdbegäran (CCR/CCD)');
INSERT INTO `lang_definitions` VALUES (63, 148, 2, 'Aktiva');
INSERT INTO `lang_definitions` VALUES (64, 150, 2, 'Aktiv påminnelse');
INSERT INTO `lang_definitions` VALUES (65, 152, 2, 'Regler för aktiv påminnelse');
INSERT INTO `lang_definitions` VALUES (66, 153, 2, 'Aktiva påminnelser');
INSERT INTO `lang_definitions` VALUES (67, 158, 2, 'Aktivt besök');
INSERT INTO `lang_definitions` VALUES (68, 159, 2, 'Códigos de questões ativas');
INSERT INTO `lang_definitions` VALUES (69, 160, 2, 'Aktiva listor');
INSERT INTO `lang_definitions` VALUES (70, 162, 2, 'Aktiv patient');
INSERT INTO `lang_definitions` VALUES (71, 163, 2, 'Aktuella planeringar');
INSERT INTO `lang_definitions` VALUES (72, 173, 2, 'Aktiviteter');
INSERT INTO `lang_definitions` VALUES (73, 174, 2, 'Aktivitetstyp');
INSERT INTO `lang_definitions` VALUES (74, 185, 2, 'Akut förgiftning / Utsättning');
INSERT INTO `lang_definitions` VALUES (75, 187, 2, 'Akut försämring av kronisk');
INSERT INTO `lang_definitions` VALUES (76, 189, 2, 'Lägg till');
INSERT INTO `lang_definitions` VALUES (77, 190, 2, 'lägg till');
INSERT INTO `lang_definitions` VALUES (78, 191, 2, 'Lägg till');
INSERT INTO `lang_definitions` VALUES (79, 192, 2, 'Lägg till ett företag');
INSERT INTO `lang_definitions` VALUES (80, 197, 2, 'Lägg till ett apotek');
INSERT INTO `lang_definitions` VALUES (81, 200, 2, 'lägg till ett händelse för');
INSERT INTO `lang_definitions` VALUES (82, 202, 2, 'Lägg till som en ny anteckning');
INSERT INTO `lang_definitions` VALUES (83, 203, 2, 'Lägg till som ny');
INSERT INTO `lang_definitions` VALUES (84, 206, 2, 'Lägg till knappar');
INSERT INTO `lang_definitions` VALUES (85, 207, 2, 'Lägg till knappar för specialtecken och texter att visa längst upp i editorn för inkludering i texten med ett klick');
INSERT INTO `lang_definitions` VALUES (86, 208, 2, 'Lägg till en ny Kategori');
INSERT INTO `lang_definitions` VALUES (87, 209, 2, 'Lägg till en ny Konstant');
INSERT INTO `lang_definitions` VALUES (88, 210, 2, 'Lägg till ett sammanhang');
INSERT INTO `lang_definitions` VALUES (89, 211, 2, 'Lägg till en delbetalning');
INSERT INTO `lang_definitions` VALUES (90, 212, 2, 'Lägg till ett nytt kriterium');
INSERT INTO `lang_definitions` VALUES (91, 213, 2, 'Lägg till anpassad knapp');
INSERT INTO `lang_definitions` VALUES (92, 216, 2, 'Lägg till en ny diagnos');
INSERT INTO `lang_definitions` VALUES (93, 217, 2, 'Lägg till ett nytt Läkemedel');
INSERT INTO `lang_definitions` VALUES (94, 220, 2, 'Lägg till ett nytt besök');
INSERT INTO `lang_definitions` VALUES (95, 221, 2, 'Lägg till ett nytt besök/anteckning');
INSERT INTO `lang_definitions` VALUES (96, 222, 2, 'Lägg till en ny klinik');
INSERT INTO `lang_definitions` VALUES (97, 223, 2, 'Lägg till ett nytt fält');
INSERT INTO `lang_definitions` VALUES (98, 224, 2, 'Lägg till följande meningar till Apache konfigurationsfilen');
INSERT INTO `lang_definitions` VALUES (99, 225, 2, 'Lägg till en ny Grupp');
INSERT INTO `lang_definitions` VALUES (100, 227, 2, 'Lägg till en ny diagnos-kod (ICD)');
INSERT INTO `lang_definitions` VALUES (101, 228, 2, 'Lägg till en ny vaccination');
INSERT INTO `lang_definitions` VALUES (102, 229, 2, 'Inte tillåtet att lägga till!');
INSERT INTO `lang_definitions` VALUES (103, 230, 2, 'Lägg till händelse');
INSERT INTO `lang_definitions` VALUES (104, 232, 2, 'Lägg till ett nytt Språk');
INSERT INTO `lang_definitions` VALUES (105, 238, 2, 'Lägg till Ny');
INSERT INTO `lang_definitions` VALUES (106, 239, 2, 'Lägg till Ny');
INSERT INTO `lang_definitions` VALUES (107, 240, 2, 'Lägg till en ny kategori:');
INSERT INTO `lang_definitions` VALUES (108, 241, 2, 'Lägg till ett nytt certifikat till Apache konfigurationsfil');
INSERT INTO `lang_definitions` VALUES (109, 249, 2, 'Lägg till en ny grupp');
INSERT INTO `lang_definitions` VALUES (110, 251, 2, 'Lägg till en ny lot och överföring');
INSERT INTO `lang_definitions` VALUES (111, 253, 2, 'Lägg till en ny kommentar');
INSERT INTO `lang_definitions` VALUES (112, 254, 2, 'Lägg till en ny kommentar');
INSERT INTO `lang_definitions` VALUES (113, 255, 2, 'Lägg till en ny partner');
INSERT INTO `lang_definitions` VALUES (114, 264, 2, 'Lägg till en ny anteckning');
INSERT INTO `lang_definitions` VALUES (115, 268, 2, 'Lägg till en ny patient');
INSERT INTO `lang_definitions` VALUES (116, 269, 2, 'Lägg till ett nytt recept');
INSERT INTO `lang_definitions` VALUES (117, 270, 2, 'Lägg till åtgärd');
INSERT INTO `lang_definitions` VALUES (118, 271, 2, 'Lägg till Vårdgivares nummer');
INSERT INTO `lang_definitions` VALUES (119, 273, 2, 'Lägg till rehab');
INSERT INTO `lang_definitions` VALUES (120, 274, 2, 'Lägg till en ny regel');
INSERT INTO `lang_definitions` VALUES (121, 277, 2, 'Tillägg till');
INSERT INTO `lang_definitions` VALUES (122, 281, 2, 'Lägg till i medicinlista');
INSERT INTO `lang_definitions` VALUES (123, 282, 2, 'Tillägg av högsta nivå');
INSERT INTO `lang_definitions` VALUES (124, 283, 2, 'Lägg till en ny överföring');
INSERT INTO `lang_definitions` VALUES (125, 284, 2, 'Lägg till en ny användare');
INSERT INTO `lang_definitions` VALUES (126, 285, 2, 'Lägg till användaren i gruppen');
INSERT INTO `lang_definitions` VALUES (127, 287, 2, 'Lägg till/ändra elektroniskt recept');
INSERT INTO `lang_definitions` VALUES (128, 289, 2, 'Lägg till/ändra patientens överföringar');
INSERT INTO `lang_definitions` VALUES (129, 290, 2, 'tillagd');
INSERT INTO `lang_definitions` VALUES (130, 293, 2, 'Ej tillåtet att lägga till personuppgifter.');
INSERT INTO `lang_definitions` VALUES (131, 295, 2, 'Mb Addison');
INSERT INTO `lang_definitions` VALUES (132, 296, 2, 'Mb Addison');
INSERT INTO `lang_definitions` VALUES (133, 297, 2, 'Flera attribut');
INSERT INTO `lang_definitions` VALUES (134, 300, 2, 'Ytterligare Diagnos:');
INSERT INTO `lang_definitions` VALUES (135, 305, 2, 'Kompletterande anamnes');
INSERT INTO `lang_definitions` VALUES (136, 306, 2, 'Kompletterande anamnesuppgifter');
INSERT INTO `lang_definitions` VALUES (137, 307, 2, 'Kompletterande Information');
INSERT INTO `lang_definitions` VALUES (138, 310, 2, 'Kompletterande Lab. svar');
INSERT INTO `lang_definitions` VALUES (139, 311, 2, 'Kompletterande noteringar');
INSERT INTO `lang_definitions` VALUES (140, 313, 2, 'Ytterligare noteringar för detta resultat eller rekomendation');
INSERT INTO `lang_definitions` VALUES (141, 314, 2, 'Ytterligare noteringar:');
INSERT INTO `lang_definitions` VALUES (142, 315, 2, 'Ytterligare noteringar:');
INSERT INTO `lang_definitions` VALUES (143, 317, 2, 'Ytterligare röntgenanteckningar:');
INSERT INTO `lang_definitions` VALUES (144, 318, 2, 'Som tillägg, motsvarande US Snomed Extension Package can importeras separat efter instalation av den internationella (engelska) Snomed utgåvan');
INSERT INTO `lang_definitions` VALUES (145, 320, 2, 'Lägg endast till');
INSERT INTO `lang_definitions` VALUES (146, 322, 2, 'Adressbok');
INSERT INTO `lang_definitions` VALUES (147, 323, 2, 'Adressbok');
INSERT INTO `lang_definitions` VALUES (148, 324, 2, 'Adress');
INSERT INTO `lang_definitions` VALUES (149, 327, 2, 'Adressbok');
INSERT INTO `lang_definitions` VALUES (150, 328, 2, 'Tillgång till adressboken för företaget som utför denna åtgärd');
INSERT INTO `lang_definitions` VALUES (151, 329, 2, 'Tillgång till adressboken för distributören');
INSERT INTO `lang_definitions` VALUES (152, 330, 2, 'Tillgång till adressboken för försäljare');
INSERT INTO `lang_definitions` VALUES (153, 331, 2, 'Typer av adressböcker');
INSERT INTO `lang_definitions` VALUES (154, 339, 2, 'Adress1');
INSERT INTO `lang_definitions` VALUES (155, 340, 2, 'Adress2');
INSERT INTO `lang_definitions` VALUES (156, 342, 2, 'ADRESSATEN');
INSERT INTO `lang_definitions` VALUES (157, 345, 2, 'Justera');
INSERT INTO `lang_definitions` VALUES (158, 346, 2, 'Korrigera mängd');
INSERT INTO `lang_definitions` VALUES (159, 347, 2, 'Justera');
INSERT INTO `lang_definitions` VALUES (160, 348, 2, 'Korrigering');
INSERT INTO `lang_definitions` VALUES (161, 349, 2, 'Justera mängd');
INSERT INTO `lang_definitions` VALUES (162, 350, 2, 'Orsak till justering');
INSERT INTO `lang_definitions` VALUES (163, 352, 2, 'Justering av värde för kod');
INSERT INTO `lang_definitions` VALUES (164, 353, 2, 'Justeringar');
INSERT INTO `lang_definitions` VALUES (165, 354, 2, 'Administrera justeringar');
INSERT INTO `lang_definitions` VALUES (166, 355, 2, 'Administrera');
INSERT INTO `lang_definitions` VALUES (167, 356, 2, 'Admin E-postadress');
INSERT INTO `lang_definitions` VALUES (168, 357, 2, 'Administrera via');
INSERT INTO `lang_definitions` VALUES (169, 359, 2, 'Administrerad av');
INSERT INTO `lang_definitions` VALUES (170, 360, 2, 'Administrerad av');
INSERT INTO `lang_definitions` VALUES (171, 362, 2, 'Administrera plats');
INSERT INTO `lang_definitions` VALUES (172, 363, 2, 'Administration');
INSERT INTO `lang_definitions` VALUES (173, 365, 2, 'Administrera plats');
INSERT INTO `lang_definitions` VALUES (174, 366, 2, 'Administratörer');
INSERT INTO `lang_definitions` VALUES (175, 367, 2, 'Administratörer kan göra allt');
INSERT INTO `lang_definitions` VALUES (176, 368, 2, 'Godkänn datum');
INSERT INTO `lang_definitions` VALUES (177, 371, 2, 'Viktkontroller med uppföljning för vuxna');
INSERT INTO `lang_definitions` VALUES (178, 372, 2, 'Viktkontroller med uppföljning för vuxna');
INSERT INTO `lang_definitions` VALUES (179, 373, 2, 'Avancerade råd');
INSERT INTO `lang_definitions` VALUES (180, 374, 2, 'Avancerade råd');
INSERT INTO `lang_definitions` VALUES (181, 375, 2, 'Varning i avancerade råd');
INSERT INTO `lang_definitions` VALUES (182, 377, 2, 'Avancerad');
INSERT INTO `lang_definitions` VALUES (183, 380, 2, 'Råd');
INSERT INTO `lang_definitions` VALUES (184, 382, 2, 'Neutral grundstämning');
INSERT INTO `lang_definitions` VALUES (185, 386, 2, 'Joursamtal');
INSERT INTO `lang_definitions` VALUES (186, 387, 2, 'Efter flytt från det gamla lösenordshanteringen där lösenord sparadesokrypterat i användartabellenska denna flagga markeras så att enbart inloggning med den nya metoden kan användas');
INSERT INTO `lang_definitions` VALUES (187, 388, 2, 'Efter genomförandet av ovannämnda konfigurationer, importera admin. klientens certifikat till webläsaren och starta om Apache server ( tömma lösenord )');
INSERT INTO `lang_definitions` VALUES (188, 390, 2, 'Efter att PDF sparats, klicka på [View Log] för att söka efter fel.');
INSERT INTO `lang_definitions` VALUES (189, 393, 2, 'Efter sparandet av TEXT filer , klicka på [View Log] för att leta efter fel');
INSERT INTO `lang_definitions` VALUES (190, 396, 2, 'Efter sparandet av ditt parti, klicka på [View Log] för att granska för fel.');
INSERT INTO `lang_definitions` VALUES (191, 399, 2, 'När informationen är korrekt införd, klicka på Spara knappen.');
INSERT INTO `lang_definitions` VALUES (192, 404, 2, 'Planering av eftervård');
INSERT INTO `lang_definitions` VALUES (193, 406, 2, 'Igen');
INSERT INTO `lang_definitions` VALUES (194, 407, 2, 'Ålder');
INSERT INTO `lang_definitions` VALUES (195, 409, 2, 'Ålder av');
INSERT INTO `lang_definitions` VALUES (196, 410, 2, 'Ålderskategori');
INSERT INTO `lang_definitions` VALUES (197, 411, 2, 'Denna Åder är utanför befintlig intervall');
INSERT INTO `lang_definitions` VALUES (198, 412, 2, 'Format för att visa ålder');
INSERT INTO `lang_definitions` VALUES (199, 413, 2, 'Detta format för \"ålder från\" är inte tillåtet');
INSERT INTO `lang_definitions` VALUES (200, 414, 2, 'Detta format för \"ålder upp till\" är inte tillåtet');
INSERT INTO `lang_definitions` VALUES (201, 415, 2, 'Ålder från');
INSERT INTO `lang_definitions` VALUES (202, 416, 2, 'Ändra format för att visa ålder i år');
INSERT INTO `lang_definitions` VALUES (203, 417, 2, 'Högsta ålder');
INSERT INTO `lang_definitions` VALUES (204, 418, 2, 'Lägsta ålder');
INSERT INTO `lang_definitions` VALUES (205, 419, 2, 'Åldersintervall');
INSERT INTO `lang_definitions` VALUES (206, 421, 2, 'Kolumner med åldern');
INSERT INTO `lang_definitions` VALUES (207, 423, 2, 'Albansk');
INSERT INTO `lang_definitions` VALUES (208, 424, 2, 'Alkohol');
INSERT INTO `lang_definitions` VALUES (209, 425, 2, 'Alkoholkonsumtion');
INSERT INTO `lang_definitions` VALUES (210, 428, 2, 'Antal varningar');
INSERT INTO `lang_definitions` VALUES (211, 435, 2, 'Varningar');
INSERT INTO `lang_definitions` VALUES (212, 439, 2, 'Aleut-befolkning');
INSERT INTO `lang_definitions` VALUES (213, 440, 2, 'Alla');
INSERT INTO `lang_definitions` VALUES (214, 441, 2, 'Alla');
INSERT INTO `lang_definitions` VALUES (215, 443, 2, 'Alla (format A)');
INSERT INTO `lang_definitions` VALUES (216, 444, 2, 'Alla (format B)');
INSERT INTO `lang_definitions` VALUES (217, 445, 2, 'Allt ( Kumulativt )');
INSERT INTO `lang_definitions` VALUES (218, 448, 2, 'Alla Kategorier');
INSERT INTO `lang_definitions` VALUES (219, 450, 2, 'Alla koder');
INSERT INTO `lang_definitions` VALUES (220, 453, 2, 'Hela dagen');
INSERT INTO `lang_definitions` VALUES (221, 454, 2, 'Heldagshändelse');
INSERT INTO `lang_definitions` VALUES (222, 455, 2, 'Alla demografiska fält , med sökning och dubbel kontroll');
INSERT INTO `lang_definitions` VALUES (223, 457, 2, 'Alla kliniker');
INSERT INTO `lang_definitions` VALUES (224, 458, 2, 'Alla skador/problem/frågeställningar');
INSERT INTO `lang_definitions` VALUES (225, 459, 2, 'All språk är tillåtna');
INSERT INTO `lang_definitions` VALUES (226, 462, 2, 'Hela förnamnet eller en del av det');
INSERT INTO `lang_definitions` VALUES (227, 463, 2, 'Hela efternamnet eller en del av det');
INSERT INTO `lang_definitions` VALUES (228, 464, 2, 'Hela organisationen eller delar av namnet');
INSERT INTO `lang_definitions` VALUES (229, 468, 2, 'Alla produkter');
INSERT INTO `lang_definitions` VALUES (230, 469, 2, 'Alla vårdgivare');
INSERT INTO `lang_definitions` VALUES (231, 470, 2, 'Alla granskade och Negativa:');
INSERT INTO `lang_definitions` VALUES (232, 475, 2, 'Alla ämnen');
INSERT INTO `lang_definitions` VALUES (233, 478, 2, 'Alla användare');
INSERT INTO `lang_definitions` VALUES (234, 479, 2, 'Allergisk');
INSERT INTO `lang_definitions` VALUES (235, 481, 2, 'Allergier');
INSERT INTO `lang_definitions` VALUES (236, 484, 2, 'Allergier:');
INSERT INTO `lang_definitions` VALUES (237, 485, 2, 'Allergi');
INSERT INTO `lang_definitions` VALUES (238, 486, 2, 'Import av allergier klart');
INSERT INTO `lang_definitions` VALUES (239, 487, 2, 'Lista på allergier');
INSERT INTO `lang_definitions` VALUES (240, 488, 2, 'Allergisk reaktion');
INSERT INTO `lang_definitions` VALUES (241, 491, 2, 'Tilldela');
INSERT INTO `lang_definitions` VALUES (242, 492, 2, 'Tillåta');
INSERT INTO `lang_definitions` VALUES (243, 494, 2, 'Tillåt alla tillgängliga språk som val i menyn vid inloggning');
INSERT INTO `lang_definitions` VALUES (244, 496, 2, 'Tillåt att skapa krav innehållande diagnoser , men ej procedurer eller betalningar. De flesta kliniker vill inte ha det');
INSERT INTO `lang_definitions` VALUES (245, 497, 2, 'Tillåt debugg språk');
INSERT INTO `lang_definitions` VALUES (246, 500, 2, 'E-post tillåten');
INSERT INTO `lang_definitions` VALUES (247, 501, 2, 'Är e-post meddelande tillåtet ?');
INSERT INTO `lang_definitions` VALUES (248, 502, 2, 'Tillåt e-post?');
INSERT INTO `lang_definitions` VALUES (249, 503, 2, 'Tillåt krav i patient möte');
INSERT INTO `lang_definitions` VALUES (250, 506, 2, 'Tillåt utbyte av hälsoinformationen');
INSERT INTO `lang_definitions` VALUES (251, 508, 2, 'Tillåt att informationen om vaccinationer delas');
INSERT INTO `lang_definitions` VALUES (252, 509, 2, 'Tillåt användning av vaccinationsregistret');
INSERT INTO `lang_definitions` VALUES (253, 512, 2, 'Tillåt e-post meddelanden');
INSERT INTO `lang_definitions` VALUES (254, 533, 2, 'Tillåt patient-inloggning');
INSERT INTO `lang_definitions` VALUES (255, 541, 2, 'Tillåt SMS');
INSERT INTO `lang_definitions` VALUES (256, 542, 2, 'Är SMS meddelanden tillåtna ?');
INSERT INTO `lang_definitions` VALUES (257, 544, 2, 'Tillåt aktuella händelser att vara aktiva omedelbart ?');
INSERT INTO `lang_definitions` VALUES (258, 545, 2, 'Tillåt telefon meddelanden?');
INSERT INTO `lang_definitions` VALUES (259, 547, 2, 'Tillåt användare att publicera Globala Händelser');
INSERT INTO `lang_definitions` VALUES (260, 548, 2, 'Tillåt användare att publicera personliga kalendrar');
INSERT INTO `lang_definitions` VALUES (261, 554, 2, 'Tillåt telefonsvarare');
INSERT INTO `lang_definitions` VALUES (262, 555, 2, 'Tillåten');
INSERT INTO `lang_definitions` VALUES (263, 556, 2, 'Godkända språk');
INSERT INTO `lang_definitions` VALUES (264, 558, 2, 'Godkänt');
INSERT INTO `lang_definitions` VALUES (265, 566, 2, 'finns redan');
INSERT INTO `lang_definitions` VALUES (266, 568, 2, 'Finns redan');
INSERT INTO `lang_definitions` VALUES (267, 570, 2, 'Används redan, välj en annan identitetsbeteckning');
INSERT INTO `lang_definitions` VALUES (268, 571, 2, 'Används redan, välj en annan titel');
INSERT INTO `lang_definitions` VALUES (269, 573, 2, 'Alternativ Adress');
INSERT INTO `lang_definitions` VALUES (270, 577, 2, 'Ändra');
INSERT INTO `lang_definitions` VALUES (271, 584, 2, 'Alternativt kan du använda sökfunktionen för att lägga upp ett elektroniskt godkännande (X12 83l fil) som du fått från din betalare eller clearingorganisationer. Du kan göra detta genom att klicka på knappen Bläddra och välj den fil som ska laddas upp och sedan klicka på Sök för att ladda upp och visa motsvarande fakturor. I detta fall gäller inte de andra parametrar som nämns ovan och de kommer att ignoreras. Överföring sparar filen men processar ännuinte innehållet - detta är gjort separat enligt nedan.');
INSERT INTO `lang_definitions` VALUES (272, 586, 2, 'förmiddag');
INSERT INTO `lang_definitions` VALUES (273, 587, 2, 'Förmiddagens program');
INSERT INTO `lang_definitions` VALUES (274, 592, 2, 'Automatisk beräkning av åtgärder (AMC)');
INSERT INTO `lang_definitions` VALUES (275, 593, 2, 'Spåra AMC');
INSERT INTO `lang_definitions` VALUES (276, 600, 2, 'Ändra Befintlig notering');
INSERT INTO `lang_definitions` VALUES (277, 610, 2, 'Amerikansk indian');
INSERT INTO `lang_definitions` VALUES (278, 611, 2, 'Amerikans indian eller född i alaska');
INSERT INTO `lang_definitions` VALUES (279, 612, 2, 'AMEX');
INSERT INTO `lang_definitions` VALUES (280, 613, 2, 'Etiopier');
INSERT INTO `lang_definitions` VALUES (281, 614, 2, 'Belopp');
INSERT INTO `lang_definitions` VALUES (282, 615, 2, 'Administrerat belopp');
INSERT INTO `lang_definitions` VALUES (283, 617, 2, 'Begärt belopp');
INSERT INTO `lang_definitions` VALUES (284, 620, 2, 'Belopp från tidigare Saldo');
INSERT INTO `lang_definitions` VALUES (285, 621, 2, 'Belopp för besöket');
INSERT INTO `lang_definitions` VALUES (286, 622, 2, 'Belopp som betalts');
INSERT INTO `lang_definitions` VALUES (287, 623, 2, 'Belopp:');
INSERT INTO `lang_definitions` VALUES (288, 626, 2, 'fakturerat belopp');
INSERT INTO `lang_definitions` VALUES (289, 630, 2, 'Ett slutdatum senare än startdatum krävs för upprepade händelser!');
INSERT INTO `lang_definitions` VALUES (290, 632, 2, 'ett fel uppstod när OpenEMR sparades');
INSERT INTO `lang_definitions` VALUES (291, 633, 2, 'Ett fel uppstod när phpGACL sparades');
INSERT INTO `lang_definitions` VALUES (292, 634, 2, 'Ett fel uppstod när SQL-ledger sparades');
INSERT INTO `lang_definitions` VALUES (293, 638, 2, 'En ofullständig GCAC fråga har inrättats och knutits. Någon kommer att behöva fylla i det senare.');
INSERT INTO `lang_definitions` VALUES (294, 644, 2, 'Ett oförutsett fel uppkom');
INSERT INTO `lang_definitions` VALUES (295, 646, 2, 'En stor bokstav');
INSERT INTO `lang_definitions` VALUES (296, 648, 2, 'och');
INSERT INTO `lang_definitions` VALUES (297, 649, 2, 'Och');
INSERT INTO `lang_definitions` VALUES (298, 650, 2, 'OCH');
INSERT INTO `lang_definitions` VALUES (299, 651, 2, 'och');
INSERT INTO `lang_definitions` VALUES (300, 652, 2, 'och alla underordnade data? Denna åtgärd kommer att loggas');
INSERT INTO `lang_definitions` VALUES (301, 653, 2, 'och modifierare');
INSERT INTO `lang_definitions` VALUES (302, 654, 2, 'och hanterad.');
INSERT INTO `lang_definitions` VALUES (303, 656, 2, 'och starta om Apache servern.');
INSERT INTO `lang_definitions` VALUES (304, 657, 2, 'och orsaken är');
INSERT INTO `lang_definitions` VALUES (305, 659, 2, 'Anemi');
INSERT INTO `lang_definitions` VALUES (306, 660, 2, 'Ankel');
INSERT INTO `lang_definitions` VALUES (307, 661, 2, 'Ankel + häl');
INSERT INTO `lang_definitions` VALUES (308, 662, 2, 'Ankel Utvärderingsformulär');
INSERT INTO `lang_definitions` VALUES (309, 663, 2, 'Ankel problem');
INSERT INTO `lang_definitions` VALUES (310, 664, 2, 'Ankyloserande Spondylit');
INSERT INTO `lang_definitions` VALUES (311, 665, 2, 'Ankyloserande Spondylit');
INSERT INTO `lang_definitions` VALUES (312, 666, 2, 'Anorexia');
INSERT INTO `lang_definitions` VALUES (313, 667, 2, 'En annan sak du kan göra i utstationering fönstret är att begära en sekundära fakturering. Om du markerar rutan innan du sparar, så kommer den ursprungliga fordran att öppnas igen och köas på faktureringssidan och sedan behandlas under nästa faktureringskörning.');
INSERT INTO `lang_definitions` VALUES (314, 671, 2, 'framåt');
INSERT INTO `lang_definitions` VALUES (315, 676, 2, 'Anus, ingen rektal ömhet');
INSERT INTO `lang_definitions` VALUES (316, 677, 2, 'Ångest');
INSERT INTO `lang_definitions` VALUES (317, 679, 2, 'Valfri');
INSERT INTO `lang_definitions` VALUES (318, 682, 2, 'någon Kategori');
INSERT INTO `lang_definitions` VALUES (319, 688, 2, 'Någon del av en kod eller dess beskrivning');
INSERT INTO `lang_definitions` VALUES (320, 689, 2, 'Någon del av önskad specialitet');
INSERT INTO `lang_definitions` VALUES (321, 690, 2, 'någon del av medicinens namn eller id');
INSERT INTO `lang_definitions` VALUES (322, 691, 2, 'Någon del av vaccinations namn eller id');
INSERT INTO `lang_definitions` VALUES (323, 692, 2, 'Någon del av patientens namn, eller \"efternamn, förnamn \" eller \"X-Y \"');
INSERT INTO `lang_definitions` VALUES (324, 693, 2, 'Någon annan relevant information');
INSERT INTO `lang_definitions` VALUES (325, 699, 2, 'API nyckel till SMS portal');
INSERT INTO `lang_definitions` VALUES (326, 703, 2, 'Andningsuppehåll');
INSERT INTO `lang_definitions` VALUES (327, 710, 2, 'Utseende');
INSERT INTO `lang_definitions` VALUES (328, 711, 2, 'Utseende:');
INSERT INTO `lang_definitions` VALUES (329, 714, 2, 'Lägg till denna notering');
INSERT INTO `lang_definitions` VALUES (330, 716, 2, 'Lägg till den nuvarande noteringen');
INSERT INTO `lang_definitions` VALUES (331, 717, 2, 'Lägg till denna anmärkning');
INSERT INTO `lang_definitions` VALUES (332, 718, 2, 'Bifoga till denna notering');
INSERT INTO `lang_definitions` VALUES (333, 719, 2, 'Appendektomi');
INSERT INTO `lang_definitions` VALUES (334, 721, 2, 'Tällämpliga patienter');
INSERT INTO `lang_definitions` VALUES (335, 722, 2, 'Ansökan');
INSERT INTO `lang_definitions` VALUES (336, 723, 2, 'Namn på program vid inloggning och titel på sidan');
INSERT INTO `lang_definitions` VALUES (337, 724, 2, 'Mottagarkod (GS03. Om blank kommer ISA08 användas)');
INSERT INTO `lang_definitions` VALUES (338, 725, 2, 'Sändarkod (GS02)');
INSERT INTO `lang_definitions` VALUES (339, 726, 2, 'Programmets titel');
INSERT INTO `lang_definitions` VALUES (340, 727, 2, 'Gäller Formulär för vitalparametrar och tillväxtkurva');
INSERT INTO `lang_definitions` VALUES (341, 728, 2, 'Gäller formulär för vitalparametrar');
INSERT INTO `lang_definitions` VALUES (342, 729, 2, 'Tillämpa ändringen på nuvarande händelse, nuvarande och alla kommande händelser eller alla händelser?');
INSERT INTO `lang_definitions` VALUES (343, 730, 2, 'tillämpas på berörda området');
INSERT INTO `lang_definitions` VALUES (344, 731, 2, 'appliceras på huden');
INSERT INTO `lang_definitions` VALUES (345, 732, 2, 'Lägger till');
INSERT INTO `lang_definitions` VALUES (346, 733, 2, 'Lägger till patch till sidan');
INSERT INTO `lang_definitions` VALUES (347, 734, 2, 'Bokning');
INSERT INTO `lang_definitions` VALUES (348, 736, 2, 'Boknings datum');
INSERT INTO `lang_definitions` VALUES (349, 742, 2, 'Sätt att visa bokning');
INSERT INTO `lang_definitions` VALUES (350, 744, 2, 'Påminnelser för bokning');
INSERT INTO `lang_definitions` VALUES (351, 746, 2, 'Boknings status');
INSERT INTO `lang_definitions` VALUES (352, 747, 2, 'Boknings status');
INSERT INTO `lang_definitions` VALUES (353, 748, 2, 'Bokas inom');
INSERT INTO `lang_definitions` VALUES (354, 749, 2, 'Bokning/händelse färg');
INSERT INTO `lang_definitions` VALUES (355, 750, 2, 'Bokningar');
INSERT INTO `lang_definitions` VALUES (356, 751, 2, 'Bokningar ( valfritt att skriva )');
INSERT INTO `lang_definitions` VALUES (357, 752, 2, 'Bokningar (Skriv, några valbara)');
INSERT INTO `lang_definitions` VALUES (358, 758, 2, 'Bokningar och besök');
INSERT INTO `lang_definitions` VALUES (359, 760, 2, 'Bokningsrapport');
INSERT INTO `lang_definitions` VALUES (360, 761, 2, 'Boknings och besöksrapport');
INSERT INTO `lang_definitions` VALUES (361, 764, 2, 'Godkänn');
INSERT INTO `lang_definitions` VALUES (362, 767, 2, 'Godkänd');
INSERT INTO `lang_definitions` VALUES (363, 768, 2, 'Godkända administrativa händelser');
INSERT INTO `lang_definitions` VALUES (364, 774, 2, 'Bokningar-besök');
INSERT INTO `lang_definitions` VALUES (365, 776, 2, 'Bokningar');
INSERT INTO `lang_definitions` VALUES (366, 779, 2, 'Apr');
INSERT INTO `lang_definitions` VALUES (367, 780, 2, 'April');
INSERT INTO `lang_definitions` VALUES (368, 782, 2, 'Arabisk');
INSERT INTO `lang_definitions` VALUES (369, 784, 2, 'Arkivera');
INSERT INTO `lang_definitions` VALUES (370, 787, 2, 'Ska gruppnamnen översättas?');
INSERT INTO `lang_definitions` VALUES (371, 788, 2, 'Ska bokningstyperna översättas?');
INSERT INTO `lang_definitions` VALUES (372, 789, 2, 'Ska dokumenttyperna översättas?');
INSERT INTO `lang_definitions` VALUES (373, 790, 2, 'Ska avgifter tas ut för denna typ?');
INSERT INTO `lang_definitions` VALUES (374, 793, 2, 'Ska överskrifter på patientanteckningar översättas?');
INSERT INTO `lang_definitions` VALUES (375, 794, 2, 'Är koderna lagrade i externa sql-tabeller (0-Nej, 1-ICD10, 2-SNOMED(RF1), 3-SNOMED(RF2) )');
INSERT INTO `lang_definitions` VALUES (376, 795, 2, 'Är du beredd att genomföra en ny GCAC fråga för detta besök?');
INSERT INTO `lang_definitions` VALUES (377, 797, 2, 'Är du säker du vill bokföra dagens händelser?');
INSERT INTO `lang_definitions` VALUES (378, 798, 2, 'Är du säker på att du vill godkänna dessa händelser?');
INSERT INTO `lang_definitions` VALUES (379, 801, 2, 'Är du säker på att du vill ta bort detta formulär?');
INSERT INTO `lang_definitions` VALUES (380, 804, 2, 'Är du säker på att du vill ta bort denna friskrivning?');
INSERT INTO `lang_definitions` VALUES (381, 805, 2, 'Är du säker på att du vill ta bort denna händelse?');
INSERT INTO `lang_definitions` VALUES (382, 806, 2, 'Är du säker du vill ta bort detta från databasen?');
INSERT INTO `lang_definitions` VALUES (383, 808, 2, 'Är du säker på att du vill ta bort detta meddelande?');
INSERT INTO `lang_definitions` VALUES (384, 810, 2, 'Är du säker på att du vill ändra dessa händelser?');
INSERT INTO `lang_definitions` VALUES (385, 811, 2, 'Är du säker på att du vill dölja dessa händelser?');
INSERT INTO `lang_definitions` VALUES (386, 814, 2, 'Är du säker på att du vill visa dessa händelser?');
INSERT INTO `lang_definitions` VALUES (387, 815, 2, 'Är du säker på att du vill ta bort hela den valda gruppen');
INSERT INTO `lang_definitions` VALUES (388, 816, 2, 'Är du säker på att du vill ta bort hela listan');
INSERT INTO `lang_definitions` VALUES (389, 817, 2, 'Är du säker på att du vill ta bort fältet i');
INSERT INTO `lang_definitions` VALUES (390, 818, 2, 'Är du säker på att du vill ta bort markerade fält?');
INSERT INTO `lang_definitions` VALUES (391, 819, 2, 'Är du säker på att du vill fortsätta med dessa åtgärder?');
INSERT INTO `lang_definitions` VALUES (392, 820, 2, 'Område är ej specifiserat');
INSERT INTO `lang_definitions` VALUES (393, 821, 2, 'Arm');
INSERT INTO `lang_definitions` VALUES (394, 822, 2, 'Armensk');
INSERT INTO `lang_definitions` VALUES (395, 829, 2, 'Arrytmi');
INSERT INTO `lang_definitions` VALUES (396, 830, 2, 'Artrit');
INSERT INTO `lang_definitions` VALUES (397, 831, 2, 'Artrit / Degenerativ ledsjukdom');
INSERT INTO `lang_definitions` VALUES (398, 832, 2, 'Artrit / Degenerativ ledsjukdom');
INSERT INTO `lang_definitions` VALUES (399, 836, 2, 'som');
INSERT INTO `lang_definitions` VALUES (400, 838, 2, 'Per');
INSERT INTO `lang_definitions` VALUES (401, 845, 2, 'Asiatisk');
INSERT INTO `lang_definitions` VALUES (402, 848, 2, 'Bedömning');
INSERT INTO `lang_definitions` VALUES (403, 853, 2, 'Tilldelas');
INSERT INTO `lang_definitions` VALUES (404, 854, 2, 'Assistent');
INSERT INTO `lang_definitions` VALUES (405, 861, 2, 'Astma');
INSERT INTO `lang_definitions` VALUES (406, 862, 2, 'på');
INSERT INTO `lang_definitions` VALUES (407, 863, 2, 'Minst en sök parameter krävs om du väljer Alla');
INSERT INTO `lang_definitions` VALUES (408, 866, 2, 'Vid Båtbenet');
INSERT INTO `lang_definitions` VALUES (409, 867, 2, 'Vid Båtbenet:');
INSERT INTO `lang_definitions` VALUES (410, 868, 2, 'Idrottsgrupp');
INSERT INTO `lang_definitions` VALUES (411, 869, 2, 'Idrottsgrupp');
INSERT INTO `lang_definitions` VALUES (412, 870, 2, 'Idrottsskada');
INSERT INTO `lang_definitions` VALUES (413, 871, 2, 'CA certifikat för ATNA revision');
INSERT INTO `lang_definitions` VALUES (414, 872, 2, 'Värd för ATNA revision');
INSERT INTO `lang_definitions` VALUES (415, 873, 2, 'Lokalt certifikat för ATNA revision');
INSERT INTO `lang_definitions` VALUES (416, 874, 2, 'Posrt för ATNA revision');
INSERT INTO `lang_definitions` VALUES (417, 877, 2, 'Observera');
INSERT INTO `lang_definitions` VALUES (418, 879, 2, 'OBS');
INSERT INTO `lang_definitions` VALUES (419, 883, 2, 'revision CDR urval');
INSERT INTO `lang_definitions` VALUES (420, 890, 2, 'Revisionsloggning backup');
INSERT INTO `lang_definitions` VALUES (421, 891, 2, 'revisionsloggning blandad');
INSERT INTO `lang_definitions` VALUES (422, 892, 2, 'Revisionsloggning sorteringsordning');
INSERT INTO `lang_definitions` VALUES (423, 893, 2, 'Revisionsloggning patientjournal');
INSERT INTO `lang_definitions` VALUES (424, 894, 2, 'revisionsloggning schemaläggning');
INSERT INTO `lang_definitions` VALUES (425, 895, 2, 'Hantera säkerhet för revisorslog');
INSERT INTO `lang_definitions` VALUES (426, 896, 2, 'Urval av revisorlog');
INSERT INTO `lang_definitions` VALUES (427, 898, 2, 'Aug');
INSERT INTO `lang_definitions` VALUES (428, 899, 2, 'Augusti');
INSERT INTO `lang_definitions` VALUES (429, 901, 2, 'Rättigheter');
INSERT INTO `lang_definitions` VALUES (430, 902, 2, 'Rättighet/anteckningar');
INSERT INTO `lang_definitions` VALUES (431, 922, 2, 'Grupprättigheter');
INSERT INTO `lang_definitions` VALUES (432, 923, 2, 'Status på auktorisation');
INSERT INTO `lang_definitions` VALUES (433, 924, 2, 'Tillstånd');
INSERT INTO `lang_definitions` VALUES (434, 925, 2, 'Bemyndiga');
INSERT INTO `lang_definitions` VALUES (435, 926, 2, 'Auktorisera – alla möten');
INSERT INTO `lang_definitions` VALUES (436, 928, 2, 'Auktorisera - Mina möten');
INSERT INTO `lang_definitions` VALUES (437, 933, 2, 'Auktorisera.net');
INSERT INTO `lang_definitions` VALUES (438, 934, 2, 'Auktoriserad');
INSERT INTO `lang_definitions` VALUES (439, 936, 2, 'Enbart auktoriserade');
INSERT INTO `lang_definitions` VALUES (440, 941, 2, 'Skicka automatiskt');
INSERT INTO `lang_definitions` VALUES (441, 944, 2, 'Skapa nytt besök automatiskt');
INSERT INTO `lang_definitions` VALUES (442, 945, 2, 'Autogenererad');
INSERT INTO `lang_definitions` VALUES (443, 947, 2, 'Automatiska beräkningar (AMC)');
INSERT INTO `lang_definitions` VALUES (444, 952, 2, 'Spåra automatiska beräkningar (ATM)');
INSERT INTO `lang_definitions` VALUES (445, 953, 2, 'Automatiska mätningar (AMC)');
INSERT INTO `lang_definitions` VALUES (446, 955, 2, 'Automatiskt');
INSERT INTO `lang_definitions` VALUES (447, 959, 2, 'Automatiskt skapa nytt besök när bokningsstatus är satt till ”@” (Kommit)');
INSERT INTO `lang_definitions` VALUES (448, 962, 2, 'Trafikmedicin');
INSERT INTO `lang_definitions` VALUES (449, 964, 2, 'Sparad automatisk');
INSERT INTO `lang_definitions` VALUES (450, 967, 2, 'Tillgängliga kategorier');
INSERT INTO `lang_definitions` VALUES (451, 971, 2, 'Tillgängliga tider');
INSERT INTO `lang_definitions` VALUES (452, 976, 2, 'Månadsgenomsnitt');
INSERT INTO `lang_definitions` VALUES (453, 980, 2, 'Avulsion / avulsion fraktur');
INSERT INTO `lang_definitions` VALUES (454, 981, 2, 'Avulsion laterala malleolus');
INSERT INTO `lang_definitions` VALUES (455, 982, 2, 'Avulsion mediala malleolus');
INSERT INTO `lang_definitions` VALUES (456, 983, 2, 'Medvetandebaserad');
INSERT INTO `lang_definitions` VALUES (457, 985, 2, 'Axillär');
INSERT INTO `lang_definitions` VALUES (458, 992, 2, '2 ggr/dag');
INSERT INTO `lang_definitions` VALUES (459, 993, 2, 'Tillbaka');
INSERT INTO `lang_definitions` VALUES (460, 994, 2, 'tillbaka');
INSERT INTO `lang_definitions` VALUES (461, 995, 2, 'Bakåt 8 besök');
INSERT INTO `lang_definitions` VALUES (462, 996, 2, 'Bakåt 11 besök');
INSERT INTO `lang_definitions` VALUES (463, 997, 2, 'Bakåt 5 besök');
INSERT INTO `lang_definitions` VALUES (464, 998, 2, 'Bakåt 4 besök');
INSERT INTO `lang_definitions` VALUES (465, 999, 2, 'Bakåt 9 besök');
INSERT INTO `lang_definitions` VALUES (466, 1000, 2, 'Bakåt 1 besök');
INSERT INTO `lang_definitions` VALUES (467, 1001, 2, 'Ryggsmärta');
INSERT INTO `lang_definitions` VALUES (468, 1002, 2, 'Ryggproblem');
INSERT INTO `lang_definitions` VALUES (469, 1003, 2, 'Bakåt 7 besök');
INSERT INTO `lang_definitions` VALUES (470, 1004, 2, 'Bakåt 6 besök');
INSERT INTO `lang_definitions` VALUES (471, 1005, 2, 'Ryggkirurgi');
INSERT INTO `lang_definitions` VALUES (472, 1006, 2, 'Bakåt 10 besök');
INSERT INTO `lang_definitions` VALUES (473, 1007, 2, 'Bakåt 3 besök');
INSERT INTO `lang_definitions` VALUES (474, 1008, 2, 'Tillbaka till Admin sidan');
INSERT INTO `lang_definitions` VALUES (475, 1013, 2, 'Tillbaka till patient');
INSERT INTO `lang_definitions` VALUES (476, 1015, 2, 'Tillbaka till användare');
INSERT INTO `lang_definitions` VALUES (477, 1016, 2, 'Tillbaka till Visa');
INSERT INTO `lang_definitions` VALUES (478, 1017, 2, 'Bakåt 12 besök');
INSERT INTO `lang_definitions` VALUES (479, 1018, 2, 'Bakåt 2 besök');
INSERT INTO `lang_definitions` VALUES (480, 1019, 2, 'Bakgrunds tjänster');
INSERT INTO `lang_definitions` VALUES (481, 1020, 2, 'Backup');
INSERT INTO `lang_definitions` VALUES (482, 1022, 2, 'Backup-filen har skapats. Kommer nu skicka till nedladdning.');
INSERT INTO `lang_definitions` VALUES (483, 1024, 2, 'Backup genomfört i');
INSERT INTO `lang_definitions` VALUES (484, 1025, 2, 'Dålig kontroll');
INSERT INTO `lang_definitions` VALUES (485, 1026, 2, 'Dålig fordran');
INSERT INTO `lang_definitions` VALUES (486, 1027, 2, 'Bahasa Indonesia');
INSERT INTO `lang_definitions` VALUES (487, 1028, 2, 'Bal');
INSERT INTO `lang_definitions` VALUES (488, 1031, 2, 'Balans');
INSERT INTO `lang_definitions` VALUES (489, 1032, 2, 'balans');
INSERT INTO `lang_definitions` VALUES (490, 1033, 2, 'Saldo mängd');
INSERT INTO `lang_definitions` VALUES (491, 1034, 2, 'Balanserade skulder');
INSERT INTO `lang_definitions` VALUES (492, 1038, 2, 'Bankavdrag');
INSERT INTO `lang_definitions` VALUES (493, 1042, 2, 'Basen av femte (5e) Metarsal');
INSERT INTO `lang_definitions` VALUES (494, 1043, 2, 'Basen av femte (5e) Metarsal');
INSERT INTO `lang_definitions` VALUES (495, 1050, 2, 'Samlingsfaktura');
INSERT INTO `lang_definitions` VALUES (496, 1051, 2, 'Samlingskummunikationsverktyg');
INSERT INTO `lang_definitions` VALUES (497, 1053, 2, 'Samlingsbetalning inskrivning');
INSERT INTO `lang_definitions` VALUES (498, 1054, 2, 'samlingsbetalning');
INSERT INTO `lang_definitions` VALUES (499, 1055, 2, 'Batchprocess påbörjad, detta kan ta ett tag.');
INSERT INTO `lang_definitions` VALUES (500, 1056, 2, 'Samlingsresultat');
INSERT INTO `lang_definitions` VALUES (501, 1057, 2, 'BatchCom');
INSERT INTO `lang_definitions` VALUES (502, 1063, 2, 'För att ID inte existerar');
INSERT INTO `lang_definitions` VALUES (503, 1072, 2, 'Starta');
INSERT INTO `lang_definitions` VALUES (504, 1074, 2, 'Startdatum');
INSERT INTO `lang_definitions` VALUES (505, 1077, 2, 'Tjänstens startdatum åååå-mm-dd');
INSERT INTO `lang_definitions` VALUES (506, 1078, 2, 'Start klockslag för kalenderhändelse');
INSERT INTO `lang_definitions` VALUES (507, 1082, 2, 'Rapningar');
INSERT INTO `lang_definitions` VALUES (508, 1086, 2, 'Bengali');
INSERT INTO `lang_definitions` VALUES (509, 1089, 2, 'Mellan');
INSERT INTO `lang_definitions` VALUES (510, 1095, 2, 'Bilateral');
INSERT INTO `lang_definitions` VALUES (511, 1096, 2, 'Bilaterala:');
INSERT INTO `lang_definitions` VALUES (512, 1099, 2, 'Faktura datuma:');
INSERT INTO `lang_definitions` VALUES (513, 1101, 2, 'Faktura');
INSERT INTO `lang_definitions` VALUES (514, 1102, 2, 'Fakturerade');
INSERT INTO `lang_definitions` VALUES (515, 1104, 2, 'Fakturering');
INSERT INTO `lang_definitions` VALUES (516, 1105, 2, 'Fakturering (skriv alternativ)');
INSERT INTO `lang_definitions` VALUES (517, 1109, 2, 'Fakturering attestera');
INSERT INTO `lang_definitions` VALUES (518, 1111, 2, 'Betalningskod för begärd service');
INSERT INTO `lang_definitions` VALUES (519, 1112, 2, 'Betalningskoder');
INSERT INTO `lang_definitions` VALUES (520, 1113, 2, 'Faktureringsdata');
INSERT INTO `lang_definitions` VALUES (521, 1114, 2, 'Fakturering avdelning');
INSERT INTO `lang_definitions` VALUES (522, 1115, 2, 'Fakturering Klinik');
INSERT INTO `lang_definitions` VALUES (523, 1117, 2, 'Faktureringsinformation');
INSERT INTO `lang_definitions` VALUES (524, 1118, 2, 'Faktureringsadress');
INSERT INTO `lang_definitions` VALUES (525, 1125, 2, 'Fakturaansvarig');
INSERT INTO `lang_definitions` VALUES (526, 1126, 2, 'Faktura Anmärkning');
INSERT INTO `lang_definitions` VALUES (527, 1127, 2, 'Fakturera anmärkning för');
INSERT INTO `lang_definitions` VALUES (528, 1128, 2, 'Fakturera notering:');
INSERT INTO `lang_definitions` VALUES (529, 1130, 2, 'Fakturera kö resultat:');
INSERT INTO `lang_definitions` VALUES (530, 1131, 2, 'Faktureringsrapport');
INSERT INTO `lang_definitions` VALUES (531, 1132, 2, 'Faktura status');
INSERT INTO `lang_definitions` VALUES (532, 1133, 2, 'Faktura status = Ej skickad');
INSERT INTO `lang_definitions` VALUES (533, 1134, 2, 'fakturera till');
INSERT INTO `lang_definitions` VALUES (534, 1138, 2, 'Biopsi');
INSERT INTO `lang_definitions` VALUES (535, 1140, 2, 'Födelsedatum');
INSERT INTO `lang_definitions` VALUES (536, 1141, 2, 'Födelse – 24 månader');
INSERT INTO `lang_definitions` VALUES (537, 1144, 2, 'Svart');
INSERT INTO `lang_definitions` VALUES (538, 1147, 2, 'Sotlunga');
INSERT INTO `lang_definitions` VALUES (539, 1148, 2, 'Afrikans amerikan');
INSERT INTO `lang_definitions` VALUES (540, 1149, 2, 'Cancer i urinblåsan');
INSERT INTO `lang_definitions` VALUES (541, 1150, 2, 'Infektioner i urinblåsan');
INSERT INTO `lang_definitions` VALUES (542, 1152, 2, 'Blankt formulär');
INSERT INTO `lang_definitions` VALUES (543, 1153, 2, 'Problem med blödning');
INSERT INTO `lang_definitions` VALUES (544, 1154, 2, 'Blinda punkter');
INSERT INTO `lang_definitions` VALUES (545, 1156, 2, 'Svullnad');
INSERT INTO `lang_definitions` VALUES (546, 1158, 2, 'Blockerade');
INSERT INTO `lang_definitions` VALUES (547, 1159, 2, 'Blod');
INSERT INTO `lang_definitions` VALUES (548, 1160, 2, 'Blodtryck');
INSERT INTO `lang_definitions` VALUES (549, 1161, 2, 'Blodtryck');
INSERT INTO `lang_definitions` VALUES (550, 1162, 2, 'Näsblod');
INSERT INTO `lang_definitions` VALUES (551, 1163, 2, 'Blått kors blå sköld');
INSERT INTO `lang_definitions` VALUES (552, 1165, 2, 'Blå linjerna i denna rapport är informativa. Svarta linjer visar tidigare information. Gröna linjerna visar förändringar som tillämpats framgångsrikt. Röda linjer visar fel eller förändringar som inte har genomförts, och dessa måste behandlas manuellt. För närvarande nekas fordringar och betalning reverseringar inte hanteras automatiskt och det kommer att visas i rött.');
INSERT INTO `lang_definitions` VALUES (553, 1166, 2, 'Dimsyn');
INSERT INTO `lang_definitions` VALUES (554, 1167, 2, 'BMI');
INSERT INTO `lang_definitions` VALUES (555, 1168, 2, 'BMI status');
INSERT INTO `lang_definitions` VALUES (556, 1170, 2, 'kroppsregion');
INSERT INTO `lang_definitions` VALUES (557, 1171, 2, 'Bkroppsdel');
INSERT INTO `lang_definitions` VALUES (558, 1172, 2, 'Kroppsdel, om tillämplig');
INSERT INTO `lang_definitions` VALUES (559, 1173, 2, 'Benömhet:');
INSERT INTO `lang_definitions` VALUES (560, 1174, 2, 'Benömhet: Malleoulus Medialis');
INSERT INTO `lang_definitions` VALUES (561, 1175, 2, 'Logisk');
INSERT INTO `lang_definitions` VALUES (562, 1179, 2, 'Båda öronen');
INSERT INTO `lang_definitions` VALUES (563, 1180, 2, 'båda öronen');
INSERT INTO `lang_definitions` VALUES (564, 1183, 2, 'Botten');
INSERT INTO `lang_definitions` VALUES (565, 1187, 2, 'RUTA 10 A. Anställningsrelaterad');
INSERT INTO `lang_definitions` VALUES (566, 1189, 2, 'RUTA 10 B. Bilolycka');
INSERT INTO `lang_definitions` VALUES (567, 1191, 2, 'RUTA 10 C. Övriga olyckor');
INSERT INTO `lang_definitions` VALUES (568, 1204, 2, 'BOX 15 Andere datum Qualifier');
INSERT INTO `lang_definitions` VALUES (569, 1205, 2, 'Ruta 15. Datum för samma eller liknande sjukdom (åååå-mm-dd)');
INSERT INTO `lang_definitions` VALUES (570, 1211, 2, 'FÄLT 16. Datum, oförmögen till arbete från (åååå-mm-dd):');
INSERT INTO `lang_definitions` VALUES (571, 1215, 2, 'FÄLT 16. Datum, oförmögen att arbeta tills (åååå-mm-dd):');
INSERT INTO `lang_definitions` VALUES (572, 1227, 2, 'FÄLT 18. Sjukhusvistelse datum, från (åååå-mm-dd):');
INSERT INTO `lang_definitions` VALUES (573, 1231, 2, 'FÄLT 18. Sjukhusvistelse till, datum (åååå-mm-dd):');
INSERT INTO `lang_definitions` VALUES (574, 1235, 2, 'FÄLT 20. Används externt lab?');
INSERT INTO `lang_definitions` VALUES (575, 1239, 2, 'Fält 22. Medicaid återinskickningskod (ICD-9)');
INSERT INTO `lang_definitions` VALUES (576, 1243, 2, 'Fält 23. Tidigare godkännande nr.');
INSERT INTO `lang_definitions` VALUES (577, 1244, 2, 'Blodtryck');
INSERT INTO `lang_definitions` VALUES (578, 1245, 2, 'BT Diastoliskt');
INSERT INTO `lang_definitions` VALUES (579, 1246, 2, 'BT Systoliskt');
INSERT INTO `lang_definitions` VALUES (580, 1248, 2, 'BT Diastoliskt');
INSERT INTO `lang_definitions` VALUES (581, 1252, 2, 'BT Systoliskt');
INSERT INTO `lang_definitions` VALUES (582, 1254, 2, 'Brasiliansk portugisiska');
INSERT INTO `lang_definitions` VALUES (583, 1255, 2, 'Bröst');
INSERT INTO `lang_definitions` VALUES (584, 1256, 2, 'Bröst Biopsi');
INSERT INTO `lang_definitions` VALUES (585, 1257, 2, 'Bröst Avsluta');
INSERT INTO `lang_definitions` VALUES (586, 1258, 2, 'Bröstsjukdom');
INSERT INTO `lang_definitions` VALUES (587, 1259, 2, 'Bröstundersökning');
INSERT INTO `lang_definitions` VALUES (588, 1260, 2, 'Bröstvävnad');
INSERT INTO `lang_definitions` VALUES (589, 1262, 2, 'Andningsljud:');
INSERT INTO `lang_definitions` VALUES (590, 1265, 2, 'Brutna ben');
INSERT INTO `lang_definitions` VALUES (591, 1267, 2, 'Bronkit Formulär');
INSERT INTO `lang_definitions` VALUES (592, 1270, 2, 'Bläddra');
INSERT INTO `lang_definitions` VALUES (593, 1271, 2, 'Bläddra efter journal');
INSERT INTO `lang_definitions` VALUES (594, 1272, 2, 'Blåmärken / hematom');
INSERT INTO `lang_definitions` VALUES (595, 1276, 2, 'Utbuktningen Höger:');
INSERT INTO `lang_definitions` VALUES (596, 1278, 2, 'Sveda vid vattenkastning');
INSERT INTO `lang_definitions` VALUES (597, 1279, 2, 'Sveda vid vattenkastning');
INSERT INTO `lang_definitions` VALUES (598, 1282, 2, 'Upptagen');
INSERT INTO `lang_definitions` VALUES (599, 1283, 2, 'ännu ej behandlad');
INSERT INTO `lang_definitions` VALUES (600, 1284, 2, 'Skinka');
INSERT INTO `lang_definitions` VALUES (601, 1285, 2, 'Skinkan och SI-led');
INSERT INTO `lang_definitions` VALUES (602, 1286, 2, 'via');
INSERT INTO `lang_definitions` VALUES (603, 1287, 2, 'via');
INSERT INTO `lang_definitions` VALUES (604, 1293, 2, 'via munnen');
INSERT INTO `lang_definitions` VALUES (605, 1295, 2, 'Genom / Källa');
INSERT INTO `lang_definitions` VALUES (606, 1296, 2, 'Av:');
INSERT INTO `lang_definitions` VALUES (607, 1299, 2, 'Kopia');
INSERT INTO `lang_definitions` VALUES (608, 1301, 2, 'CA certifikat för att verifiera RFS 5425 TLS syslog server');
INSERT INTO `lang_definitions` VALUES (609, 1302, 2, 'Cache, livstid (i sekunder)');
INSERT INTO `lang_definitions` VALUES (610, 1303, 2, 'Cache template output?');
INSERT INTO `lang_definitions` VALUES (611, 1305, 2, 'Kaffe konsumtion');
INSERT INTO `lang_definitions` VALUES (612, 1306, 2, 'Kalender');
INSERT INTO `lang_definitions` VALUES (613, 1307, 2, 'Kalender sluttid');
INSERT INTO `lang_definitions` VALUES (614, 1308, 2, 'Kalender interval');
INSERT INTO `lang_definitions` VALUES (615, 1309, 2, 'Kalender skärm');
INSERT INTO `lang_definitions` VALUES (616, 1310, 2, 'Kalenderinställningar');
INSERT INTO `lang_definitions` VALUES (617, 1312, 2, 'Kalender starttid');
INSERT INTO `lang_definitions` VALUES (618, 1313, 2, 'Kalender UI');
INSERT INTO `lang_definitions` VALUES (619, 1314, 2, 'Kalendervy');
INSERT INTO `lang_definitions` VALUES (620, 1317, 2, 'Anrop till addForm() skriv här. <br>');
INSERT INTO `lang_definitions` VALUES (621, 1321, 2, 'Kalorier');
INSERT INTO `lang_definitions` VALUES (622, 1322, 2, 'Kambodjan');
INSERT INTO `lang_definitions` VALUES (623, 1323, 2, 'CAMOS');
INSERT INTO `lang_definitions` VALUES (624, 1329, 2, 'Avbryt');
INSERT INTO `lang_definitions` VALUES (625, 1332, 2, 'Förkasta ändringar');
INSERT INTO `lang_definitions` VALUES (626, 1333, 2, 'Avbruten');
INSERT INTO `lang_definitions` VALUES (627, 1335, 2, 'Cancer');
INSERT INTO `lang_definitions` VALUES (628, 1336, 2, 'Cancer screening: Colon cancer screening');
INSERT INTO `lang_definitions` VALUES (629, 1337, 2, 'Scancer screening: Mammografi');
INSERT INTO `lang_definitions` VALUES (630, 1338, 2, 'Cancer screening: Pap smear');
INSERT INTO `lang_definitions` VALUES (631, 1339, 2, 'Cancer screening: Prostata cancer');
INSERT INTO `lang_definitions` VALUES (632, 1340, 2, 'Det går ej att lägga till detta för att det redan existerar!');
INSERT INTO `lang_definitions` VALUES (633, 1341, 2, 'Kan inte lägga till / uppdatera den här posten eftersom duplikat redan finns!');
INSERT INTO `lang_definitions` VALUES (634, 1342, 2, 'Kan inte lagra. Kastat.');
INSERT INTO `lang_definitions` VALUES (635, 1343, 2, 'kan inte konverteras till JPEG. Kanske ImageMagick inte är installerad?');
INSERT INTO `lang_definitions` VALUES (636, 1344, 2, 'Kan inte tas bort. Utan åtgärd.');
INSERT INTO `lang_definitions` VALUES (637, 1345, 2, 'kan inte visas online eftersom denna filtyp inte stöds av webbläsaren.');
INSERT INTO `lang_definitions` VALUES (638, 1346, 2, 'kan inte visas online eftersom denna filtyp inte stöds av webbläsaren.');
INSERT INTO `lang_definitions` VALUES (639, 1347, 2, 'kan inte visas online eftersom den typen inte stöds av webbläsaren.');
INSERT INTO `lang_definitions` VALUES (640, 1349, 2, 'Det går inte att skapa');
INSERT INTO `lang_definitions` VALUES (641, 1354, 2, 'Kan ej hitta');
INSERT INTO `lang_definitions` VALUES (642, 1355, 2, 'Kan ej hitta filnamnet');
INSERT INTO `lang_definitions` VALUES (643, 1358, 2, 'Kan inte hitta patienten från SQL-ledgers kundnummer');
INSERT INTO `lang_definitions` VALUES (644, 1359, 2, 'Kan ej hitta postscript dokumenthänvisning i');
INSERT INTO `lang_definitions` VALUES (645, 1360, 2, 'Kan inte hitta vårdgivaren i SQL-ledger');
INSERT INTO `lang_definitions` VALUES (646, 1361, 2, 'Kan inte ändra betalning. Odebiterat belopp är negativt.');
INSERT INTO `lang_definitions` VALUES (647, 1363, 2, 'Går inte att öppna');
INSERT INTO `lang_definitions` VALUES (648, 1364, 2, 'Kan inte bokföra på försäkring. Betalningsansvarig är patienten.');
INSERT INTO `lang_definitions` VALUES (649, 1365, 2, 'Kan inte bokföra på patient. Betalningsansvarig är försäkring.');
INSERT INTO `lang_definitions` VALUES (650, 1366, 2, 'Kan inte bokföra betalning. Odebiterat belopp är negativt.');
INSERT INTO `lang_definitions` VALUES (651, 1367, 2, 'Kan ej läsa');
INSERT INTO `lang_definitions` VALUES (652, 1368, 2, 'Kan ej läsa i mappen');
INSERT INTO `lang_definitions` VALUES (653, 1369, 2, 'Kan inte uppdatera eftersom du inte redigerar en befintlig post!');
INSERT INTO `lang_definitions` VALUES (654, 1370, 2, 'Stor bokstav');
INSERT INTO `lang_definitions` VALUES (655, 1372, 2, 'kapsel');
INSERT INTO `lang_definitions` VALUES (656, 1373, 2, 'Kort');
INSERT INTO `lang_definitions` VALUES (657, 1382, 2, 'Hjärtkateterisering');
INSERT INTO `lang_definitions` VALUES (658, 1383, 2, 'Hjärteko');
INSERT INTO `lang_definitions` VALUES (659, 1384, 2, 'Kardiovaskulära');
INSERT INTO `lang_definitions` VALUES (660, 1396, 2, 'Brosk / menisk skada');
INSERT INTO `lang_definitions` VALUES (661, 1397, 2, 'Broskskada');
INSERT INTO `lang_definitions` VALUES (662, 1398, 2, 'Inga karotispulsar. Inga fotpulsar.');
INSERT INTO `lang_definitions` VALUES (663, 1400, 2, 'kontanter');
INSERT INTO `lang_definitions` VALUES (664, 1401, 2, 'Kontanter');
INSERT INTO `lang_definitions` VALUES (665, 1402, 2, 'Kontantbetalning');
INSERT INTO `lang_definitions` VALUES (666, 1403, 2, 'Kontantkvitton från vårdgivare');
INSERT INTO `lang_definitions` VALUES (667, 1406, 2, 'Kataraktkirurgi');
INSERT INTO `lang_definitions` VALUES (668, 1407, 2, 'Katarakt');
INSERT INTO `lang_definitions` VALUES (669, 1408, 2, 'Kategorier');
INSERT INTO `lang_definitions` VALUES (670, 1409, 2, 'Kategorier av');
INSERT INTO `lang_definitions` VALUES (671, 1410, 2, 'Kategori');
INSERT INTO `lang_definitions` VALUES (672, 1411, 2, 'kategori');
INSERT INTO `lang_definitions` VALUES (673, 1412, 2, 'Kategori');
INSERT INTO `lang_definitions` VALUES (674, 1416, 2, 'Kategori Detaljer');
INSERT INTO `lang_definitions` VALUES (675, 1417, 2, 'Kategori Gränser');
INSERT INTO `lang_definitions` VALUES (676, 1418, 2, 'Kategorinamn');
INSERT INTO `lang_definitions` VALUES (677, 1419, 2, 'Kategorinamn är tomt');
INSERT INTO `lang_definitions` VALUES (678, 1420, 2, 'Kategori/Titel');
INSERT INTO `lang_definitions` VALUES (679, 1421, 2, 'Kaukasisk');
INSERT INTO `lang_definitions` VALUES (680, 1422, 2, 'Kvitto på kontaktorsak att skriva för besök. Primär vårdgivar information');
INSERT INTO `lang_definitions` VALUES (681, 1444, 2, 'Mobiltelefon');
INSERT INTO `lang_definitions` VALUES (682, 1445, 2, 'Mobiltelefon');
INSERT INTO `lang_definitions` VALUES (683, 1447, 2, 'Mobiltelefonnummer');
INSERT INTO `lang_definitions` VALUES (684, 1449, 2, 'Central Certifiering');
INSERT INTO `lang_definitions` VALUES (685, 1451, 2, 'Central/sydamerikan');
INSERT INTO `lang_definitions` VALUES (686, 1452, 2, 'CA certifikats fil-mapp kan inte vara tom');
INSERT INTO `lang_definitions` VALUES (687, 1453, 2, 'CA nyckelfilsmapp kan inte vara tom');
INSERT INTO `lang_definitions` VALUES (688, 1454, 2, 'CA certifikat för att skicka till RFS 5425 TLS syslog server');
INSERT INTO `lang_definitions` VALUES (689, 1455, 2, 'Certifikat användare');
INSERT INTO `lang_definitions` VALUES (690, 1456, 2, 'Certifikat');
INSERT INTO `lang_definitions` VALUES (691, 1458, 2, 'ChampUS');
INSERT INTO `lang_definitions` VALUES (692, 1459, 2, 'ChampUSVA');
INSERT INTO `lang_definitions` VALUES (693, 1460, 2, 'ändra');
INSERT INTO `lang_definitions` VALUES (694, 1461, 2, 'Ändra');
INSERT INTO `lang_definitions` VALUES (695, 1462, 2, 'Ändra Aktivitet');
INSERT INTO `lang_definitions` VALUES (696, 1466, 2, 'Gick inte ändra. CouchDB fel?');
INSERT INTO `lang_definitions` VALUES (697, 1467, 2, 'Synpåverkan');
INSERT INTO `lang_definitions` VALUES (698, 1468, 2, 'Synpåverkan');
INSERT INTO `lang_definitions` VALUES (699, 1470, 2, 'Byta lösenord');
INSERT INTO `lang_definitions` VALUES (700, 1475, 2, 'Ändrad');
INSERT INTO `lang_definitions` VALUES (701, 1476, 2, 'Förändrad tarm');
INSERT INTO `lang_definitions` VALUES (702, 1479, 2, 'Byter patientidentitet för dokument');
INSERT INTO `lang_definitions` VALUES (703, 1484, 2, 'Karaktär');
INSERT INTO `lang_definitions` VALUES (704, 1485, 2, 'Tecken kvar');
INSERT INTO `lang_definitions` VALUES (705, 1486, 2, 'Avgift');
INSERT INTO `lang_definitions` VALUES (706, 1487, 2, 'Justering av avgift');
INSERT INTO `lang_definitions` VALUES (707, 1488, 2, 'Avgift kodad');
INSERT INTO `lang_definitions` VALUES (708, 1490, 2, 'Avgifter');
INSERT INTO `lang_definitions` VALUES (709, 1491, 2, 'Patientkort');
INSERT INTO `lang_definitions` VALUES (710, 1492, 2, 'Patientkort aktivitet');
INSERT INTO `lang_definitions` VALUES (711, 1493, 2, 'Patientkort Check-in/out Aktivitetsrapport?');
INSERT INTO `lang_definitions` VALUES (712, 1495, 2, 'Patientkort ID');
INSERT INTO `lang_definitions` VALUES (713, 1496, 2, 'Patientkort ID');
INSERT INTO `lang_definitions` VALUES (714, 1498, 2, 'Patientkort placering Aktivitet');
INSERT INTO `lang_definitions` VALUES (715, 1499, 2, 'Patientkort notering');
INSERT INTO `lang_definitions` VALUES (716, 1500, 2, 'Patientkort nr');
INSERT INTO `lang_definitions` VALUES (717, 1502, 2, 'Patientkort lagring placering');
INSERT INTO `lang_definitions` VALUES (718, 1504, 2, 'Patientkort spåra');
INSERT INTO `lang_definitions` VALUES (719, 1505, 2, 'Patientkort spåra');
INSERT INTO `lang_definitions` VALUES (720, 1508, 2, 'Patientkort utcheckning');
INSERT INTO `lang_definitions` VALUES (721, 1509, 2, 'Patientkort utcheckning');
INSERT INTO `lang_definitions` VALUES (722, 1513, 2, 'Controleer of u van plan bent om ansichtkaarten te verzenden via MedEx');
INSERT INTO `lang_definitions` VALUES (723, 1514, 2, 'Betalningsanvisning');
INSERT INTO `lang_definitions` VALUES (724, 1515, 2, 'Alla betalningsanvisningar');
INSERT INTO `lang_definitions` VALUES (725, 1517, 2, 'Betalningsanvisning belopp');
INSERT INTO `lang_definitions` VALUES (726, 1519, 2, 'Betalningsanvisning datum');
INSERT INTO `lang_definitions` VALUES (727, 1521, 2, 'Kontrollera skillnader i översättning med översättningstabellen');
INSERT INTO `lang_definitions` VALUES (728, 1527, 2, 'checka in till');
INSERT INTO `lang_definitions` VALUES (729, 1528, 2, 'Kontrollera indata');
INSERT INTO `lang_definitions` VALUES (730, 1530, 2, 'Kontrollera labdata');
INSERT INTO `lang_definitions` VALUES (731, 1531, 2, 'Markering betyder påtittat');
INSERT INTO `lang_definitions` VALUES (732, 1532, 2, 'Betalningsanvisning nr');
INSERT INTO `lang_definitions` VALUES (733, 1533, 2, 'Betalningsanvisning nr');
INSERT INTO `lang_definitions` VALUES (734, 1536, 2, 'Betalningsanvisning betalning');
INSERT INTO `lang_definitions` VALUES (735, 1537, 2, 'Markera ifall filen är krypterad');
INSERT INTO `lang_definitions` VALUES (736, 1541, 2, 'Markera om vårdgivare ska se alla bokade besök som standard och ej enbart deras egna');
INSERT INTO `lang_definitions` VALUES (737, 1543, 2, 'Markera för att skapa \'Problem\' utifrån denna diagnos');
INSERT INTO `lang_definitions` VALUES (738, 1545, 2, 'Check / EOB Datum:');
INSERT INTO `lang_definitions` VALUES (739, 1547, 2, 'Check / EOB Nr:');
INSERT INTO `lang_definitions` VALUES (740, 1548, 2, 'Check / Ref Nr');
INSERT INTO `lang_definitions` VALUES (741, 1549, 2, 'Check / Referensnummer');
INSERT INTO `lang_definitions` VALUES (742, 1550, 2, 'Markeringsrutor lista');
INSERT INTO `lang_definitions` VALUES (743, 1551, 2, 'Markeringsrutor lista');
INSERT INTO `lang_definitions` VALUES (744, 1552, 2, 'Markeringsruta m text');
INSERT INTO `lang_definitions` VALUES (745, 1553, 2, 'Markeringsruta m text');
INSERT INTO `lang_definitions` VALUES (746, 1557, 2, 'Markerade fält = ja, tom = nej');
INSERT INTO `lang_definitions` VALUES (747, 1559, 2, 'Markerade fält = ja, tom = nej');
INSERT INTO `lang_definitions` VALUES (748, 1568, 2, 'Kassa');
INSERT INTO `lang_definitions` VALUES (749, 1569, 2, 'Kontrollsumma');
INSERT INTO `lang_definitions` VALUES (750, 1570, 2, 'Bröstkorg');
INSERT INTO `lang_definitions` VALUES (751, 1571, 2, 'Chest CTAB');
INSERT INTO `lang_definitions` VALUES (752, 1572, 2, 'Bröstsmärtor');
INSERT INTO `lang_definitions` VALUES (753, 1573, 2, 'Bröstsmärta:');
INSERT INTO `lang_definitions` VALUES (754, 1574, 2, 'Bröstsmärtor');
INSERT INTO `lang_definitions` VALUES (755, 1576, 2, 'Byt');
INSERT INTO `lang_definitions` VALUES (756, 1578, 2, 'Huvudproblem');
INSERT INTO `lang_definitions` VALUES (757, 1581, 2, 'Barn');
INSERT INTO `lang_definitions` VALUES (758, 1583, 2, 'Barnvaccinations status');
INSERT INTO `lang_definitions` VALUES (759, 1584, 2, 'Frossbrytningar');
INSERT INTO `lang_definitions` VALUES (760, 1585, 2, 'Kinesiska');
INSERT INTO `lang_definitions` VALUES (761, 1586, 2, 'Kinesiska (Förenklad)');
INSERT INTO `lang_definitions` VALUES (762, 1587, 2, 'Kinesiska (traditionell)');
INSERT INTO `lang_definitions` VALUES (763, 1589, 2, 'Val');
INSERT INTO `lang_definitions` VALUES (764, 1590, 2, 'Kolecystektomi');
INSERT INTO `lang_definitions` VALUES (765, 1592, 2, 'Kolecystektomi');
INSERT INTO `lang_definitions` VALUES (766, 1593, 2, 'Välj');
INSERT INTO `lang_definitions` VALUES (767, 1596, 2, 'Välj ett avsnitt och klicka på ett objekt i den ;i den andra sektionen visas relaterade objekt. Klicka på avsnitten om du vill lägga till och ta bort relationer.');
INSERT INTO `lang_definitions` VALUES (768, 1597, 2, 'Välj kriteria');
INSERT INTO `lang_definitions` VALUES (769, 1602, 2, 'Välj fil');
INSERT INTO `lang_definitions` VALUES (770, 1603, 2, 'Välj från lista');
INSERT INTO `lang_definitions` VALUES (771, 1605, 2, 'Välj lista');
INSERT INTO `lang_definitions` VALUES (772, 1611, 2, 'Välj utskriftsformat för besöksrapport');
INSERT INTO `lang_definitions` VALUES (773, 1615, 2, 'Kronisk bronkit');
INSERT INTO `lang_definitions` VALUES (774, 1616, 2, 'Kronisk ledvärk');
INSERT INTO `lang_definitions` VALUES (775, 1617, 2, 'Kroniska njurbesvär');
INSERT INTO `lang_definitions` VALUES (776, 1620, 2, 'Kronisk synovit / utgjutning / ledvärk / gikt');
INSERT INTO `lang_definitions` VALUES (777, 1622, 2, 'Kronisk / Återkommande');
INSERT INTO `lang_definitions` VALUES (778, 1625, 2, 'Levercirros');
INSERT INTO `lang_definitions` VALUES (779, 1626, 2, 'Levercirros');
INSERT INTO `lang_definitions` VALUES (780, 1627, 2, 'Stad');
INSERT INTO `lang_definitions` VALUES (781, 1629, 2, 'Stadsnamn');
INSERT INTO `lang_definitions` VALUES (782, 1630, 2, 'Stad, stat');
INSERT INTO `lang_definitions` VALUES (783, 1631, 2, 'Stad, stat postnummer');
INSERT INTO `lang_definitions` VALUES (784, 1633, 2, 'Stad / stat');
INSERT INTO `lang_definitions` VALUES (785, 1634, 2, 'Begär');
INSERT INTO `lang_definitions` VALUES (786, 1635, 2, 'Begär');
INSERT INTO `lang_definitions` VALUES (787, 1637, 2, 'Begäran status');
INSERT INTO `lang_definitions` VALUES (788, 1639, 2, 'Begäran typ');
INSERT INTO `lang_definitions` VALUES (789, 1640, 2, 'Begäran skapade fil');
INSERT INTO `lang_definitions` VALUES (790, 1641, 2, 'Begäran skapade fil');
INSERT INTO `lang_definitions` VALUES (791, 1642, 2, 'Begäran');
INSERT INTO `lang_definitions` VALUES (792, 1645, 2, 'Klassificering');
INSERT INTO `lang_definitions` VALUES (793, 1646, 2, 'Rensa');
INSERT INTO `lang_definitions` VALUES (794, 1649, 2, 'RENSA AKTIV PATIENT');
INSERT INTO `lang_definitions` VALUES (795, 1651, 2, 'Rensa allt');
INSERT INTO `lang_definitions` VALUES (796, 1654, 2, 'Rensa HL7 data');
INSERT INTO `lang_definitions` VALUES (797, 1655, 2, 'Rensa justering');
INSERT INTO `lang_definitions` VALUES (798, 1659, 2, 'Rensa Smarty Cache');
INSERT INTO `lang_definitions` VALUES (799, 1662, 2, 'CLIA Antal');
INSERT INTO `lang_definitions` VALUES (800, 1663, 2, 'Klicka');
INSERT INTO `lang_definitions` VALUES (801, 1664, 2, 'Klicka \'export\' för att exportera din kategori, underkategori, enhet eller innehållsdata till en textfil. Någon likhet mellan denna textfil och en XML-fil är enbart en tillfällighet. Start och sluttaggar måste vara på samma rad, måste vara med små bokstäver och utan mellanrum. För att importera, bläddra efter filen, klicka på \'import\'. Om data är helt annorlunda kommer det läggas till existerande data. Om det finns likvärdiga enhetsnamn kommer de gamla att behållas och de nya läggas till med en siffra i slutet av namnet.');
INSERT INTO `lang_definitions` VALUES (802, 1667, 2, 'Klicka på en plats på bilden för att lägga till notering. Klicka igen för att ta bort den.');
INSERT INTO `lang_definitions` VALUES (803, 1671, 2, 'Klicka ”Download Certificate” för att ladda ner certifikatet i filen ssl.zip');
INSERT INTO `lang_definitions` VALUES (804, 1672, 2, 'Klicka för mer');
INSERT INTO `lang_definitions` VALUES (805, 1673, 2, 'Klicka för mer detaljer');
INSERT INTO `lang_definitions` VALUES (806, 1674, 2, 'Klicka för att beställa summering');
INSERT INTO `lang_definitions` VALUES (807, 1675, 2, 'Klicka för resultat');
INSERT INTO `lang_definitions` VALUES (808, 1678, 2, 'Klicka här');
INSERT INTO `lang_definitions` VALUES (809, 1679, 2, 'Klicka här för att lägga till patient');
INSERT INTO `lang_definitions` VALUES (810, 1680, 2, 'Klicka här för att lägga till ny skada, byta status och ändra dagliga aktiviteter');
INSERT INTO `lang_definitions` VALUES (811, 1682, 2, 'Klicka här för att välja ett datum');
INSERT INTO `lang_definitions` VALUES (812, 1683, 2, 'Klicka här för att välja datum och klockslag');
INSERT INTO `lang_definitions` VALUES (813, 1684, 2, 'Klicka här för att välja startdatum');
INSERT INTO `lang_definitions` VALUES (814, 1707, 2, 'Klicka här för att söka');
INSERT INTO `lang_definitions` VALUES (815, 1710, 2, 'Klicka här för att uppdatera prioritet, kategori och smeknamn inställningar');
INSERT INTO `lang_definitions` VALUES (816, 1714, 2, 'Klicka här, för att se alla.');
INSERT INTO `lang_definitions` VALUES (817, 1715, 2, 'Klicka här för att se och rita');
INSERT INTO `lang_definitions` VALUES (818, 1717, 2, 'Klicka här för att se och rita all vitalparametrar');
INSERT INTO `lang_definitions` VALUES (819, 1718, 2, 'Klicka här för att se patient detaljer');
INSERT INTO `lang_definitions` VALUES (820, 1719, 2, 'Klicka här för att se alla');
INSERT INTO `lang_definitions` VALUES (821, 1720, 2, 'Klicka här för att se/ändra mer detaljer');
INSERT INTO `lang_definitions` VALUES (822, 1723, 2, 'Klicka ”install” knappen för att installera databas utgåva sedan följande datum');
INSERT INTO `lang_definitions` VALUES (823, 1730, 2, 'Klicka någonstans på tid för att öka');
INSERT INTO `lang_definitions` VALUES (824, 1751, 2, 'Klicka på patientnamn för att öppna patientfilen');
INSERT INTO `lang_definitions` VALUES (825, 1753, 2, 'Klicka ”uppdatera” för att se alla resultat eller var vänlig ange sökkriterier ovan för att se specifika resultat');
INSERT INTO `lang_definitions` VALUES (826, 1777, 2, 'Klicka för att lägga till diagnos');
INSERT INTO `lang_definitions` VALUES (827, 1779, 2, 'Lklicka för att lägga till komponent');
INSERT INTO `lang_definitions` VALUES (828, 1780, 2, 'Klicka för att lägga till konsultation');
INSERT INTO `lang_definitions` VALUES (829, 1785, 2, 'Klicka för att ladda ner');
INSERT INTO `lang_definitions` VALUES (830, 1786, 2, 'Klicka för att ändra');
INSERT INTO `lang_definitions` VALUES (831, 1787, 2, 'Klicka för att ändra beskrivning');
INSERT INTO `lang_definitions` VALUES (832, 1788, 2, 'Klicka för att ändra denna händelse');
INSERT INTO `lang_definitions` VALUES (833, 1790, 2, 'Klicka för att skapa rapporten');
INSERT INTO `lang_definitions` VALUES (834, 1800, 2, 'Klicka för att skriva ut');
INSERT INTO `lang_definitions` VALUES (835, 1801, 2, 'Klicka för att lägga till/ta emot ny lot');
INSERT INTO `lang_definitions` VALUES (836, 1805, 2, 'Klicka för att välja');
INSERT INTO `lang_definitions` VALUES (837, 1806, 2, 'Klicka för att välja');
INSERT INTO `lang_definitions` VALUES (838, 1808, 2, 'Klicka för att välja en industristandard kod för denna åtgärd');
INSERT INTO `lang_definitions` VALUES (839, 1811, 2, 'Klicka för att välja valbar åtgärdskod');
INSERT INTO `lang_definitions` VALUES (840, 1813, 2, 'Klicka för att välja eller byta CVX kod');
INSERT INTO `lang_definitions` VALUES (841, 1814, 2, 'Klicka för att välja eller ändra diagnoser');
INSERT INTO `lang_definitions` VALUES (842, 1815, 2, 'Klicka för att välja eller ändra tjänst kod');
INSERT INTO `lang_definitions` VALUES (843, 1816, 2, 'Klicka för att välja patient');
INSERT INTO `lang_definitions` VALUES (844, 1817, 2, 'Klicka för att välja tillhörande kod');
INSERT INTO `lang_definitions` VALUES (845, 1819, 2, 'Klicka för att välja tjänster att utföra om resultatet är avvikande');
INSERT INTO `lang_definitions` VALUES (846, 1822, 2, 'Klicka för att välja önskad åtgärd');
INSERT INTO `lang_definitions` VALUES (847, 1829, 2, 'Klicka för att sortera');
INSERT INTO `lang_definitions` VALUES (848, 1831, 2, 'Klicka för att visa eller redigera');
INSERT INTO `lang_definitions` VALUES (849, 1833, 2, 'Klicka för att visa eller redigera');
INSERT INTO `lang_definitions` VALUES (850, 1834, 2, 'Klicka för visa/redigera');
INSERT INTO `lang_definitions` VALUES (851, 1836, 2, 'Klicka Uppdatera knappen för att uppdatera databasutgåvan från följande datum');
INSERT INTO `lang_definitions` VALUES (852, 1839, 2, 'Klicka på:');
INSERT INTO `lang_definitions` VALUES (853, 1862, 2, 'Kund certifikat utgångsdatum');
INSERT INTO `lang_definitions` VALUES (854, 1864, 2, 'kund certifikat giltighetsperiod');
INSERT INTO `lang_definitions` VALUES (855, 1865, 2, 'Kundcertifikats giltighet ska vara ett giltigt nummer');
INSERT INTO `lang_definitions` VALUES (856, 1866, 2, 'kund kopia');
INSERT INTO `lang_definitions` VALUES (857, 1869, 2, 'Sammanfattning av kundens sjukdomshistoria');
INSERT INTO `lang_definitions` VALUES (858, 1870, 2, 'Kund namn');
INSERT INTO `lang_definitions` VALUES (859, 1872, 2, 'Kund nummer');
INSERT INTO `lang_definitions` VALUES (860, 1873, 2, 'Kundprofil - Ny kund');
INSERT INTO `lang_definitions` VALUES (861, 1874, 2, 'Kundprofil - Unika kunder');
INSERT INTO `lang_definitions` VALUES (862, 1878, 2, 'Kunder');
INSERT INTO `lang_definitions` VALUES (863, 1879, 2, 'Klinik');
INSERT INTO `lang_definitions` VALUES (864, 1880, 2, 'Klinik kopiera');
INSERT INTO `lang_definitions` VALUES (865, 1881, 2, 'Kliniken Daily Record');
INSERT INTO `lang_definitions` VALUES (866, 1882, 2, 'Klinik ID');
INSERT INTO `lang_definitions` VALUES (867, 1883, 2, 'Klinisk');
INSERT INTO `lang_definitions` VALUES (868, 1884, 2, 'Kliniskt beslutsstöd Påminnelsehantering');
INSERT INTO `lang_definitions` VALUES (869, 1886, 2, 'Anamnes');
INSERT INTO `lang_definitions` VALUES (870, 1889, 2, 'Klinisk planering');
INSERT INTO `lang_definitions` VALUES (871, 1890, 2, 'Kliniska kvalitetskrav');
INSERT INTO `lang_definitions` VALUES (872, 1893, 2, 'Klinikens påminnelser');
INSERT INTO `lang_definitions` VALUES (873, 1897, 2, 'Klinikens rapporter');
INSERT INTO `lang_definitions` VALUES (874, 1898, 2, 'Kliniskt beslutsstöd Kategorier');
INSERT INTO `lang_definitions` VALUES (875, 1899, 2, 'Kliniskt beslutsstöd Enheter');
INSERT INTO `lang_definitions` VALUES (876, 1900, 2, 'Kliniskt beslutsstöd Urvalsfunktioner');
INSERT INTO `lang_definitions` VALUES (877, 1901, 2, 'Kliniskt beslutsstöd Mål metoder');
INSERT INTO `lang_definitions` VALUES (878, 1902, 2, 'Kliniskt beslutsstöd Enheter');
INSERT INTO `lang_definitions` VALUES (879, 1903, 2, 'Kliniskt beslutsstöd ålders intervaller');
INSERT INTO `lang_definitions` VALUES (880, 1904, 2, 'Kliniskt beslutsstöd jämförelser');
INSERT INTO `lang_definitions` VALUES (881, 1905, 2, 'Kliniskt beslutsstöd Typer av besök');
INSERT INTO `lang_definitions` VALUES (882, 1906, 2, 'Kliniskt beslutsstöd Påminnelser giltighet inställningar');
INSERT INTO `lang_definitions` VALUES (883, 1907, 2, 'Kliniskt beslutsstöd Påminnelser inaktiveringsinställningar');
INSERT INTO `lang_definitions` VALUES (884, 1908, 2, 'Kliniskt beslutsstöd påminnelser intervaller');
INSERT INTO `lang_definitions` VALUES (885, 1909, 2, 'Kliniskt beslutsstöd påminnelser metoder');
INSERT INTO `lang_definitions` VALUES (886, 1910, 2, 'Kliniskt beslutsstöd Mål intervaller');
INSERT INTO `lang_definitions` VALUES (887, 1911, 2, 'Kliniska mål');
INSERT INTO `lang_definitions` VALUES (888, 1912, 2, 'Kliniskt begrepp');
INSERT INTO `lang_definitions` VALUES (889, 1913, 2, 'Kliniska begrepp koder');
INSERT INTO `lang_definitions` VALUES (890, 1915, 2, 'Kliniskt verksamma');
INSERT INTO `lang_definitions` VALUES (891, 1916, 2, 'Kopiera');
INSERT INTO `lang_definitions` VALUES (892, 1917, 2, 'Kopiera tidigare besök');
INSERT INTO `lang_definitions` VALUES (893, 1918, 2, 'Stäng');
INSERT INTO `lang_definitions` VALUES (894, 1925, 2, 'Stäng fönstret');
INSERT INTO `lang_definitions` VALUES (895, 1927, 2, 'Stängt');
INSERT INTO `lang_definitions` VALUES (896, 1928, 2, 'cm');
INSERT INTO `lang_definitions` VALUES (897, 1931, 2, 'CMS 1500 marginal');
INSERT INTO `lang_definitions` VALUES (898, 1940, 2, 'CMS-id');
INSERT INTO `lang_definitions` VALUES (899, 1955, 2, 'CN2-12 intakta');
INSERT INTO `lang_definitions` VALUES (900, 1958, 2, 'Medbetalare');
INSERT INTO `lang_definitions` VALUES (901, 1959, 2, 'Medbetalare Betalning');
INSERT INTO `lang_definitions` VALUES (902, 1962, 2, 'Medbetalare');
INSERT INTO `lang_definitions` VALUES (903, 1964, 2, 'Kod');
INSERT INTO `lang_definitions` VALUES (904, 1965, 2, 'kod');
INSERT INTO `lang_definitions` VALUES (905, 1967, 2, 'Kodsökare');
INSERT INTO `lang_definitions` VALUES (906, 1968, 2, 'Kod måste vara två bokstäver (små bokstäver)');
INSERT INTO `lang_definitions` VALUES (907, 1969, 2, 'Kod eller symbol för att ange valuta');
INSERT INTO `lang_definitions` VALUES (908, 1971, 2, 'Kod text');
INSERT INTO `lang_definitions` VALUES (909, 1973, 2, 'Kod typer');
INSERT INTO `lang_definitions` VALUES (910, 1976, 2, 'Kod typer');
INSERT INTO `lang_definitions` VALUES (911, 1977, 2, 'Koder');
INSERT INTO `lang_definitions` VALUES (912, 1978, 2, 'Kodad');
INSERT INTO `lang_definitions` VALUES (913, 1979, 2, 'Koder');
INSERT INTO `lang_definitions` VALUES (914, 1981, 2, 'Kodning');
INSERT INTO `lang_definitions` VALUES (915, 1983, 2, 'Kodning – alla besök (skriv, med valbara alternativ)');
INSERT INTO `lang_definitions` VALUES (916, 1985, 2, 'Kodning – mina besök (skriv, med valbara alternativ)');
INSERT INTO `lang_definitions` VALUES (917, 1990, 2, 'Kodning ej godkänd');
INSERT INTO `lang_definitions` VALUES (918, 1991, 2, 'Kaffe');
INSERT INTO `lang_definitions` VALUES (919, 1994, 2, 'Med-försäkring');
INSERT INTO `lang_definitions` VALUES (920, 1995, 2, 'Förf.saml w / o');
INSERT INTO `lang_definitions` VALUES (921, 1997, 2, 'Komprimera alla');
INSERT INTO `lang_definitions` VALUES (922, 1998, 2, 'Komprimera alla');
INSERT INTO `lang_definitions` VALUES (923, 1999, 2, 'Komprimera alla');
INSERT INTO `lang_definitions` VALUES (924, 2000, 2, 'Komprimera alla');
INSERT INTO `lang_definitions` VALUES (925, 2001, 2, 'Komprimera alla');
INSERT INTO `lang_definitions` VALUES (926, 2005, 2, 'samlings datum');
INSERT INTO `lang_definitions` VALUES (927, 2007, 2, 'Samlingar');
INSERT INTO `lang_definitions` VALUES (928, 2008, 2, 'Samlingsrapport');
INSERT INTO `lang_definitions` VALUES (929, 2009, 2, 'Koloncancer');
INSERT INTO `lang_definitions` VALUES (930, 2010, 2, 'Koloncancer screening');
INSERT INTO `lang_definitions` VALUES (931, 2011, 2, 'Koloncancer Kirurgi');
INSERT INTO `lang_definitions` VALUES (932, 2012, 2, 'Koloskopi');
INSERT INTO `lang_definitions` VALUES (933, 2013, 2, 'Koloskopi');
INSERT INTO `lang_definitions` VALUES (934, 2014, 2, 'Färg');
INSERT INTO `lang_definitions` VALUES (935, 2020, 2, 'Färg förkortning');
INSERT INTO `lang_definitions` VALUES (936, 2021, 2, 'Kolumn');
INSERT INTO `lang_definitions` VALUES (937, 2022, 2, 'Kolumner');
INSERT INTO `lang_definitions` VALUES (938, 2024, 2, 'Slå ihop grupper');
INSERT INTO `lang_definitions` VALUES (939, 2025, 2, 'Komma');
INSERT INTO `lang_definitions` VALUES (940, 2027, 2, 'Kommentar');
INSERT INTO `lang_definitions` VALUES (941, 2028, 2, 'Kommentarer');
INSERT INTO `lang_definitions` VALUES (942, 2030, 2, 'Kommentarer om detta resultat eller rekomendation');
INSERT INTO `lang_definitions` VALUES (943, 2031, 2, 'Commercial Insurance Co');
INSERT INTO `lang_definitions` VALUES (944, 2032, 2, 'Godkänn Ändringar');
INSERT INTO `lang_definitions` VALUES (945, 2036, 2, 'Förbindelser');
INSERT INTO `lang_definitions` VALUES (946, 2039, 2, 'Företag');
INSERT INTO `lang_definitions` VALUES (947, 2040, 2, 'Företag namn');
INSERT INTO `lang_definitions` VALUES (948, 2041, 2, 'Komplett');
INSERT INTO `lang_definitions` VALUES (949, 2046, 2, 'Klar?');
INSERT INTO `lang_definitions` VALUES (950, 2047, 2, 'Remover por completo la capacidad de mostrar el Tablero de Flujo de Pacientes');
INSERT INTO `lang_definitions` VALUES (951, 2048, 2, 'Estado de finalización');
INSERT INTO `lang_definitions` VALUES (952, 2049, 2, 'Komplikationer orsakade av vårdgivare');
INSERT INTO `lang_definitions` VALUES (953, 2050, 2, 'Abortkomplikationer');
INSERT INTO `lang_definitions` VALUES (954, 2051, 2, 'Enheter');
INSERT INTO `lang_definitions` VALUES (955, 2057, 2, 'Datorstödd Medicinskt beställningssystem');
INSERT INTO `lang_definitions` VALUES (956, 2058, 2, 'Slutsatser');
INSERT INTO `lang_definitions` VALUES (957, 2064, 2, 'Inställningar');
INSERT INTO `lang_definitions` VALUES (958, 2065, 2, 'Inställningar import/export');
INSERT INTO `lang_definitions` VALUES (959, 2067, 2, 'Konfigurera Apache och open EMR för att använda klient SSL certifikat');
INSERT INTO `lang_definitions` VALUES (960, 2068, 2, 'Konfigurera Apache att använda Klient SSL certifikat');
INSERT INTO `lang_definitions` VALUES (961, 2069, 2, 'Konfigurera apache för att använda HTTPS');
INSERT INTO `lang_definitions` VALUES (962, 2070, 2, 'Konfigurera openEMR för att använda Klient SSL certifikat');
INSERT INTO `lang_definitions` VALUES (963, 2079, 2, 'Bekräfta Skapa ny patient');
INSERT INTO `lang_definitions` VALUES (964, 2081, 2, 'Bekräfta Nytt lösenord');
INSERT INTO `lang_definitions` VALUES (965, 2083, 2, 'Bekräfta Betalning');
INSERT INTO `lang_definitions` VALUES (966, 2092, 2, 'Medfödd');
INSERT INTO `lang_definitions` VALUES (967, 2094, 2, 'Konjunktiva, pupiller');
INSERT INTO `lang_definitions` VALUES (968, 2097, 2, 'Sammanbindningar');
INSERT INTO `lang_definitions` VALUES (969, 2098, 2, 'Konstant');
INSERT INTO `lang_definitions` VALUES (970, 2100, 2, 'Konstant namn');
INSERT INTO `lang_definitions` VALUES (971, 2101, 2, 'Konstantnamn är tomt');
INSERT INTO `lang_definitions` VALUES (972, 2102, 2, 'Konstanter');
INSERT INTO `lang_definitions` VALUES (973, 2103, 2, 'Förstoppning');
INSERT INTO `lang_definitions` VALUES (974, 2104, 2, 'Konstitutionella');
INSERT INTO `lang_definitions` VALUES (975, 2107, 2, 'Konsultation, kortfattad beskrivning');
INSERT INTO `lang_definitions` VALUES (976, 2109, 2, 'Kontakt');
INSERT INTO `lang_definitions` VALUES (977, 2110, 2, 'E-postadress');
INSERT INTO `lang_definitions` VALUES (978, 2111, 2, 'Epostadresser');
INSERT INTO `lang_definitions` VALUES (979, 2112, 2, 'Kontakta EMR direkt för att prenumerera på phiMail Direct meddelande service');
INSERT INTO `lang_definitions` VALUES (980, 2113, 2, 'Kontaktinformation');
INSERT INTO `lang_definitions` VALUES (981, 2117, 2, 'Kontaktlinser');
INSERT INTO `lang_definitions` VALUES (982, 2118, 2, 'Contact Medical Information Integration, LLC at http://mi-squared.com for Lab Exchange Service.');
INSERT INTO `lang_definitions` VALUES (983, 2119, 2, 'Contact Medical Information Integration, LLC at http://mi-squared.com or ZH Healthcare at http://zhservices.com for subscribing the eRx service');
INSERT INTO `lang_definitions` VALUES (984, 2122, 2, 'Kontaktnamn');
INSERT INTO `lang_definitions` VALUES (985, 2125, 2, 'Kontaktperson');
INSERT INTO `lang_definitions` VALUES (986, 2127, 2, 'Kontakttelefonnummer');
INSERT INTO `lang_definitions` VALUES (987, 2129, 2, 'Contact ZMG, LLC (zmghealth@gmail.com) for subscribing the eRx service');
INSERT INTO `lang_definitions` VALUES (988, 2131, 2, 'Innehåller minst tre av följande fyra enheter:');
INSERT INTO `lang_definitions` VALUES (989, 2132, 2, 'Behållare Gruppnamn');
INSERT INTO `lang_definitions` VALUES (990, 2133, 2, 'Innehåll');
INSERT INTO `lang_definitions` VALUES (991, 2134, 2, 'innehåll');
INSERT INTO `lang_definitions` VALUES (992, 2136, 2, 'Sammanhang');
INSERT INTO `lang_definitions` VALUES (993, 2137, 2, 'Sammanhangsnamn kan inte vara tomt');
INSERT INTO `lang_definitions` VALUES (994, 2138, 2, 'Fortsätt');
INSERT INTO `lang_definitions` VALUES (995, 2142, 2, 'Vårdplanerings dokument');
INSERT INTO `lang_definitions` VALUES (996, 2145, 2, 'Vårdplanering');
INSERT INTO `lang_definitions` VALUES (997, 2146, 2, 'kontraindikationer');
INSERT INTO `lang_definitions` VALUES (998, 2147, 2, 'Preventivmedel');
INSERT INTO `lang_definitions` VALUES (999, 2148, 2, 'Preventivmedelsproblematik');
INSERT INTO `lang_definitions` VALUES (1000, 2149, 2, 'Preventivmedelsproblematik (specificera)');
INSERT INTO `lang_definitions` VALUES (1001, 2150, 2, 'Preventivmedel Metod');
INSERT INTO `lang_definitions` VALUES (1002, 2151, 2, 'Preventivmedel');
INSERT INTO `lang_definitions` VALUES (1003, 2152, 2, 'Preventivmedel, tjänster som tidigare startats');
INSERT INTO `lang_definitions` VALUES (1004, 2153, 2, 'Preventivmedel start');
INSERT INTO `lang_definitions` VALUES (1005, 2158, 2, 'Kontrollnummer');
INSERT INTO `lang_definitions` VALUES (1006, 2159, 2, 'Kontrollnummer');
INSERT INTO `lang_definitions` VALUES (1007, 2168, 2, 'medbetalare');
INSERT INTO `lang_definitions` VALUES (1008, 2169, 2, 'Medbetalare');
INSERT INTO `lang_definitions` VALUES (1009, 2170, 2, 'Medbetalare');
INSERT INTO `lang_definitions` VALUES (1010, 2171, 2, 'medbetalare nekar');
INSERT INTO `lang_definitions` VALUES (1011, 2173, 2, 'Medbetalare');
INSERT INTO `lang_definitions` VALUES (1012, 2174, 2, 'COPD');
INSERT INTO `lang_definitions` VALUES (1013, 2175, 2, 'Kopiera Sidor till Patientdiagram');
INSERT INTO `lang_definitions` VALUES (1014, 2177, 2, 'Kopiera Värderingar');
INSERT INTO `lang_definitions` VALUES (1015, 2178, 2, 'Kopiera databasfilen. Detta tar en stund...');
INSERT INTO `lang_definitions` VALUES (1016, 2179, 2, 'Upphovsrättsskydd');
INSERT INTO `lang_definitions` VALUES (1017, 2184, 2, 'Coronary Artery Bypass');
INSERT INTO `lang_definitions` VALUES (1018, 2185, 2, 'Coronary Artery Bypass Graft (CABG)');
INSERT INTO `lang_definitions` VALUES (1019, 2186, 2, 'Rättad');
INSERT INTO `lang_definitions` VALUES (1020, 2188, 2, 'CouchDB');
INSERT INTO `lang_definitions` VALUES (1021, 2189, 2, 'Kunde inte ansluta till CouchDB');
INSERT INTO `lang_definitions` VALUES (1022, 2191, 2, 'CouchDB databas');
INSERT INTO `lang_definitions` VALUES (1023, 2192, 2, 'CouchDB databas namn');
INSERT INTO `lang_definitions` VALUES (1024, 2195, 2, 'CouchDB värd');
INSERT INTO `lang_definitions` VALUES (1025, 2196, 2, 'CouchDB värdnamn');
INSERT INTO `lang_definitions` VALUES (1026, 2197, 2, 'CouchDB log på');
INSERT INTO `lang_definitions` VALUES (1027, 2198, 2, 'CouchDB lösenord');
INSERT INTO `lang_definitions` VALUES (1028, 2199, 2, 'CouchDB port');
INSERT INTO `lang_definitions` VALUES (1029, 2200, 2, 'CouchDB port');
INSERT INTO `lang_definitions` VALUES (1030, 2203, 2, 'CouchDB användarnamn');
INSERT INTO `lang_definitions` VALUES (1031, 2204, 2, 'Hosta');
INSERT INTO `lang_definitions` VALUES (1032, 2205, 2, 'Hosta:');
INSERT INTO `lang_definitions` VALUES (1033, 2211, 2, 'Kunde ej läsa fil');
INSERT INTO `lang_definitions` VALUES (1034, 2214, 2, 'Kunde inte skicka e-post på grund av en server problem');
INSERT INTO `lang_definitions` VALUES (1035, 2216, 2, 'Kunde inte skicka e-post på grund av en server problem');
INSERT INTO `lang_definitions` VALUES (1036, 2217, 2, 'Kunde inte skapa backup');
INSERT INTO `lang_definitions` VALUES (1037, 2218, 2, 'Kunde inte ta bort mapp');
INSERT INTO `lang_definitions` VALUES (1038, 2219, 2, 'Kunde inte ta bort gammal backup fil');
INSERT INTO `lang_definitions` VALUES (1039, 2220, 2, 'Kunde inte ta bort gammal export fil');
INSERT INTO `lang_definitions` VALUES (1040, 2221, 2, 'Waran INR kontroll');
INSERT INTO `lang_definitions` VALUES (1041, 2222, 2, 'Couns av metod');
INSERT INTO `lang_definitions` VALUES (1042, 2223, 2, 'Rådgivning');
INSERT INTO `lang_definitions` VALUES (1043, 2224, 2, 'Rådgivning, Aktivitet');
INSERT INTO `lang_definitions` VALUES (1044, 2227, 2, 'svarsremiss, formulär');
INSERT INTO `lang_definitions` VALUES (1045, 2228, 2, 'Nation');
INSERT INTO `lang_definitions` VALUES (1046, 2229, 2, 'Land');
INSERT INTO `lang_definitions` VALUES (1047, 2231, 2, 'Typ av nationsdata');
INSERT INTO `lang_definitions` VALUES (1048, 2232, 2, 'Nationslista');
INSERT INTO `lang_definitions` VALUES (1049, 2233, 2, 'Nationslista');
INSERT INTO `lang_definitions` VALUES (1050, 2235, 2, 'Nationsnamn ska representeras av två bokstäver');
INSERT INTO `lang_definitions` VALUES (1051, 2236, 2, 'Landsting');
INSERT INTO `lang_definitions` VALUES (1052, 2238, 2, 'kupong');
INSERT INTO `lang_definitions` VALUES (1053, 2245, 2, 'CPT');
INSERT INTO `lang_definitions` VALUES (1054, 2246, 2, 'CPT Koder');
INSERT INTO `lang_definitions` VALUES (1055, 2247, 2, 'CPT Koder');
INSERT INTO `lang_definitions` VALUES (1056, 2248, 2, 'CPT4 Åtgärder/Tjänster');
INSERT INTO `lang_definitions` VALUES (1057, 2249, 2, 'CPTII Mått på utförande');
INSERT INTO `lang_definitions` VALUES (1058, 2250, 2, 'Kvalitetscertifikat (GCP)');
INSERT INTO `lang_definitions` VALUES (1059, 2252, 2, 'Sprickor:');
INSERT INTO `lang_definitions` VALUES (1060, 2255, 2, 'kräm');
INSERT INTO `lang_definitions` VALUES (1061, 2256, 2, 'Skapa klient certifikat SSL för varje användare eller dator');
INSERT INTO `lang_definitions` VALUES (1062, 2257, 2, 'Skapa klientcertifikat för antingen användare eller datornamn');
INSERT INTO `lang_definitions` VALUES (1063, 2269, 2, 'Skapa en händelse');
INSERT INTO `lang_definitions` VALUES (1064, 2273, 2, 'Skapa och ladda ner en fullständig backup');
INSERT INTO `lang_definitions` VALUES (1065, 2275, 2, 'Skapa beackup');
INSERT INTO `lang_definitions` VALUES (1066, 2276, 2, 'Skapa grupp');
INSERT INTO `lang_definitions` VALUES (1067, 2277, 2, 'Skapa kientcertifikat');
INSERT INTO `lang_definitions` VALUES (1068, 2278, 2, 'Skapa klient SSL certifikat');
INSERT INTO `lang_definitions` VALUES (1069, 2281, 2, 'Skapa kopia');
INSERT INTO `lang_definitions` VALUES (1070, 2283, 2, 'Skapa backup av händelselog');
INSERT INTO `lang_definitions` VALUES (1071, 2285, 2, 'Skapa ny aktivitet');
INSERT INTO `lang_definitions` VALUES (1072, 2287, 2, 'Skapa ny patient');
INSERT INTO `lang_definitions` VALUES (1073, 2290, 2, 'Skapa externa port rättigheter');
INSERT INTO `lang_definitions` VALUES (1074, 2292, 2, 'Skapa interna port rättigheter');
INSERT INTO `lang_definitions` VALUES (1075, 2294, 2, 'Skapa Patientanteckning');
INSERT INTO `lang_definitions` VALUES (1076, 2296, 2, 'Skapa SSL certifikat utgivare och server certifikat');
INSERT INTO `lang_definitions` VALUES (1077, 2297, 2, 'Skapa besök');
INSERT INTO `lang_definitions` VALUES (1078, 2298, 2, 'Skapad');
INSERT INTO `lang_definitions` VALUES (1079, 2306, 2, 'Skapa exportfil');
INSERT INTO `lang_definitions` VALUES (1080, 2308, 2, 'Skapande av fil på värden misslyckades');
INSERT INTO `lang_definitions` VALUES (1081, 2309, 2, 'Skapare');
INSERT INTO `lang_definitions` VALUES (1082, 2311, 2, 'kredit');
INSERT INTO `lang_definitions` VALUES (1083, 2312, 2, 'Kreditkort');
INSERT INTO `lang_definitions` VALUES (1084, 2314, 2, 'Kredit');
INSERT INTO `lang_definitions` VALUES (1085, 2316, 2, 'Kriterier');
INSERT INTO `lang_definitions` VALUES (1086, 2319, 2, 'Crohn\'s sjukdom');
INSERT INTO `lang_definitions` VALUES (1087, 2320, 2, 'Chrons sjukdom');
INSERT INTO `lang_definitions` VALUES (1088, 2323, 2, 'export av kommaseparerad lista');
INSERT INTO `lang_definitions` VALUES (1089, 2324, 2, 'Kommaseparerad fil');
INSERT INTO `lang_definitions` VALUES (1090, 2325, 2, 'Kommaseparerad tabell');
INSERT INTO `lang_definitions` VALUES (1091, 2330, 2, 'Kubikmillimeter');
INSERT INTO `lang_definitions` VALUES (1092, 2331, 2, 'Kuban');
INSERT INTO `lang_definitions` VALUES (1093, 2333, 2, 'Valuta decimaler');
INSERT INTO `lang_definitions` VALUES (1094, 2334, 2, 'Valuta decimaltecken');
INSERT INTO `lang_definitions` VALUES (1095, 2335, 2, 'Valutatecken');
INSERT INTO `lang_definitions` VALUES (1096, 2336, 2, 'Valuta tusenseparator');
INSERT INTO `lang_definitions` VALUES (1097, 2337, 2, 'Pågående');
INSERT INTO `lang_definitions` VALUES (1098, 2338, 2, 'Alkohol aktuellt');
INSERT INTO `lang_definitions` VALUES (1099, 2341, 2, 'Pågående konsultation');
INSERT INTO `lang_definitions` VALUES (1100, 2342, 2, 'Aktuella kriterier');
INSERT INTO `lang_definitions` VALUES (1101, 2344, 2, 'Markeringsfärg för aktuell dag');
INSERT INTO `lang_definitions` VALUES (1102, 2345, 2, 'Röker dagligen');
INSERT INTO `lang_definitions` VALUES (1103, 2347, 2, 'Nuvarande filnamn är ändrat till');
INSERT INTO `lang_definitions` VALUES (1104, 2349, 2, 'Använder hash');
INSERT INTO `lang_definitions` VALUES (1105, 2350, 2, 'Nuvarande lokalisation');
INSERT INTO `lang_definitions` VALUES (1106, 2352, 2, 'Aktuell medicinering');
INSERT INTO `lang_definitions` VALUES (1107, 2354, 2, 'Aktuellt lösenord');
INSERT INTO `lang_definitions` VALUES (1108, 2356, 2, 'Pågående patient');
INSERT INTO `lang_definitions` VALUES (1109, 2361, 2, 'Aktuella droger');
INSERT INTO `lang_definitions` VALUES (1110, 2363, 2, 'Tillfällighetsrökare');
INSERT INTO `lang_definitions` VALUES (1111, 2371, 2, 'För närvarande Aktiv');
INSERT INTO `lang_definitions` VALUES (1112, 2375, 2, 'Pågår');
INSERT INTO `lang_definitions` VALUES (1113, 2377, 2, 'Ingen aktuell klinik');
INSERT INTO `lang_definitions` VALUES (1114, 2379, 2, 'Cushing Syndrom');
INSERT INTO `lang_definitions` VALUES (1115, 2380, 2, 'Cushings syndrom');
INSERT INTO `lang_definitions` VALUES (1116, 2383, 2, 'Anpassad');
INSERT INTO `lang_definitions` VALUES (1117, 2390, 2, 'Anpassat input');
INSERT INTO `lang_definitions` VALUES (1118, 2395, 2, 'Anpassad tabell');
INSERT INTO `lang_definitions` VALUES (1119, 2402, 2, 'CVX kod');
INSERT INTO `lang_definitions` VALUES (1120, 2403, 2, 'CVX kod koppling');
INSERT INTO `lang_definitions` VALUES (1121, 2404, 2, 'CVX vaccination');
INSERT INTO `lang_definitions` VALUES (1122, 2412, 2, 'CYP');
INSERT INTO `lang_definitions` VALUES (1123, 2413, 2, 'CYP Factor');
INSERT INTO `lang_definitions` VALUES (1124, 2414, 2, 'CYP Rapport');
INSERT INTO `lang_definitions` VALUES (1125, 2415, 2, 'Tjeckisk');
INSERT INTO `lang_definitions` VALUES (1126, 2416, 2, 'D');
INSERT INTO `lang_definitions` VALUES (1127, 2417, 2, 'D & C');
INSERT INTO `lang_definitions` VALUES (1128, 2418, 2, 'D & E');
INSERT INTO `lang_definitions` VALUES (1129, 2420, 2, 'Födelsedatum');
INSERT INTO `lang_definitions` VALUES (1130, 2421, 2, 'dagligen');
INSERT INTO `lang_definitions` VALUES (1131, 2422, 2, 'Daglig registrering');
INSERT INTO `lang_definitions` VALUES (1132, 2425, 2, 'dansk');
INSERT INTO `lang_definitions` VALUES (1133, 2429, 2, 'Liknande data finns redan i databasen, ändra koden och / eller beskrivning');
INSERT INTO `lang_definitions` VALUES (1134, 2430, 2, 'Liknande data finns redan i databasen, ändra koden och / eller beskrivning');
INSERT INTO `lang_definitions` VALUES (1135, 2431, 2, 'Data kolumner');
INSERT INTO `lang_definitions` VALUES (1136, 2434, 2, 'Data fel');
INSERT INTO `lang_definitions` VALUES (1137, 2439, 2, 'Datattyp');
INSERT INTO `lang_definitions` VALUES (1138, 2440, 2, 'Databas');
INSERT INTO `lang_definitions` VALUES (1139, 2442, 2, 'Databas är inte installerad');
INSERT INTO `lang_definitions` VALUES (1140, 2444, 2, 'databas revision');
INSERT INTO `lang_definitions` VALUES (1141, 2445, 2, 'Databasrapportering');
INSERT INTO `lang_definitions` VALUES (1142, 2447, 2, 'Uppdatering av databas avslutad');
INSERT INTO `lang_definitions` VALUES (1143, 2448, 2, 'Datacols måste ha ett nummer mellan 1 och 999');
INSERT INTO `lang_definitions` VALUES (1144, 2449, 2, 'Datum');
INSERT INTO `lang_definitions` VALUES (1145, 2450, 2, 'DATUM');
INSERT INTO `lang_definitions` VALUES (1146, 2451, 2, 'Hantering av datum och tid');
INSERT INTO `lang_definitions` VALUES (1147, 2453, 2, 'Administreringsdatum');
INSERT INTO `lang_definitions` VALUES (1148, 2454, 2, 'datum och tid för insamling');
INSERT INTO `lang_definitions` VALUES (1149, 2455, 2, 'datum och tid för observation');
INSERT INTO `lang_definitions` VALUES (1150, 2457, 2, 'Datum och tid när provet togs');
INSERT INTO `lang_definitions` VALUES (1151, 2458, 2, 'datum kan inte vara senare än idag');
INSERT INTO `lang_definitions` VALUES (1152, 2459, 2, 'Datum då preventivmeddel insattes för första gången');
INSERT INTO `lang_definitions` VALUES (1153, 2460, 2, 'Skapat datum');
INSERT INTO `lang_definitions` VALUES (1154, 2461, 2, 'Datum avslutad');
INSERT INTO `lang_definitions` VALUES (1155, 2462, 2, 'Förstörd datum');
INSERT INTO `lang_definitions` VALUES (1156, 2463, 2, 'Sätt att visa datum');
INSERT INTO `lang_definitions` VALUES (1157, 2464, 2, 'Datumformat för \"mötet slutar\" är inte giltigt');
INSERT INTO `lang_definitions` VALUES (1158, 2465, 2, 'Datumformat för \"mötet startat \"är inte giltig');
INSERT INTO `lang_definitions` VALUES (1159, 2466, 2, 'Datumformat för \"Nästa Möte\" är inte giltig');
INSERT INTO `lang_definitions` VALUES (1160, 2467, 2, 'Datumformat för \"sista besök\" är inte giltig');
INSERT INTO `lang_definitions` VALUES (1161, 2469, 2, 'Datumformat för \"sista besök\" är inte giltig');
INSERT INTO `lang_definitions` VALUES (1162, 2470, 2, 'Datum för vaccinationsinformation');
INSERT INTO `lang_definitions` VALUES (1163, 2471, 2, 'Datum saknas för kod');
INSERT INTO `lang_definitions` VALUES (1164, 2472, 2, 'Huvudsakligt kriterium för datum');
INSERT INTO `lang_definitions` VALUES (1165, 2475, 2, 'Datum för bankinsättning åååå-mm-dd');
INSERT INTO `lang_definitions` VALUES (1166, 2476, 2, 'datum för fakturering');
INSERT INTO `lang_definitions` VALUES (1167, 2477, 2, 'Födelsedatum');
INSERT INTO `lang_definitions` VALUES (1168, 2478, 2, 'Födelsedatum');
INSERT INTO `lang_definitions` VALUES (1169, 2479, 2, 'Födelsedatum');
INSERT INTO `lang_definitions` VALUES (1170, 2481, 2, 'datum för registrering');
INSERT INTO `lang_definitions` VALUES (1171, 2483, 2, 'Datum för skada');
INSERT INTO `lang_definitions` VALUES (1172, 2487, 2, 'Datum för betalning åååå-mm-dd');
INSERT INTO `lang_definitions` VALUES (1173, 2489, 2, 'Remissdatum');
INSERT INTO `lang_definitions` VALUES (1174, 2491, 2, 'Svarsdatum');
INSERT INTO `lang_definitions` VALUES (1175, 2492, 2, 'Rapportdatum');
INSERT INTO `lang_definitions` VALUES (1176, 2493, 2, 'Datum för tjänsten');
INSERT INTO `lang_definitions` VALUES (1177, 2495, 2, 'Datum för tjänst');
INSERT INTO `lang_definitions` VALUES (1178, 2496, 2, 'datum för tjänsten = idag');
INSERT INTO `lang_definitions` VALUES (1179, 2498, 2, 'Datum för tjänst MM / DD / ÅÅÅÅ');
INSERT INTO `lang_definitions` VALUES (1180, 2499, 2, 'Datum för tjänst:');
INSERT INTO `lang_definitions` VALUES (1181, 2500, 2, 'datum för signering');
INSERT INTO `lang_definitions` VALUES (1182, 2501, 2, 'datum för förändrat status');
INSERT INTO `lang_definitions` VALUES (1183, 2503, 2, 'Orderdatum');
INSERT INTO `lang_definitions` VALUES (1184, 2504, 2, 'Rapportdatum');
INSERT INTO `lang_definitions` VALUES (1185, 2505, 2, 'Datum för VIS deklaration');
INSERT INTO `lang_definitions` VALUES (1186, 2506, 2, 'datum beställd');
INSERT INTO `lang_definitions` VALUES (1187, 2509, 2, 'Val av datum');
INSERT INTO `lang_definitions` VALUES (1188, 2510, 2, 'Skickat datum');
INSERT INTO `lang_definitions` VALUES (1189, 2511, 2, 'Datum då meddelande skickades');
INSERT INTO `lang_definitions` VALUES (1190, 2513, 2, 'datumvärde kan inte vara tomt.');
INSERT INTO `lang_definitions` VALUES (1191, 2516, 2, 'datum/planerat besök');
INSERT INTO `lang_definitions` VALUES (1192, 2517, 2, 'Datum/anteckningar');
INSERT INTO `lang_definitions` VALUES (1193, 2518, 2, 'Datum / Anteckningar, senast');
INSERT INTO `lang_definitions` VALUES (1194, 2519, 2, 'datum/tid');
INSERT INTO `lang_definitions` VALUES (1195, 2520, 2, 'Datum:');
INSERT INTO `lang_definitions` VALUES (1196, 2523, 2, 'Daterad meddelande log');
INSERT INTO `lang_definitions` VALUES (1197, 2526, 2, 'Dag');
INSERT INTO `lang_definitions` VALUES (1198, 2527, 2, 'dag');
INSERT INTO `lang_definitions` VALUES (1199, 2530, 2, 'Överblick dag');
INSERT INTO `lang_definitions` VALUES (1200, 2531, 2, 'Dag (ar)');
INSERT INTO `lang_definitions` VALUES (1201, 2532, 2, 'Dag (ar) M-F');
INSERT INTO `lang_definitions` VALUES (1202, 2533, 2, 'dagar');
INSERT INTO `lang_definitions` VALUES (1203, 2534, 2, 'Dagar');
INSERT INTO `lang_definitions` VALUES (1204, 2535, 2, 'dagar sedan');
INSERT INTO `lang_definitions` VALUES (1205, 2536, 2, 'Dagar och spel Missade');
INSERT INTO `lang_definitions` VALUES (1206, 2537, 2, 'Dagar från förra mötet');
INSERT INTO `lang_definitions` VALUES (1207, 2538, 2, 'Missade dagar');
INSERT INTO `lang_definitions` VALUES (1208, 2541, 2, 'Dagar per Kolumn:');
INSERT INTO `lang_definitions` VALUES (1209, 2543, 2, 'dagar/kolumner');
INSERT INTO `lang_definitions` VALUES (1210, 2544, 2, 'DB installerad');
INSERT INTO `lang_definitions` VALUES (1211, 2545, 2, 'DD/MM/ÅÅÅÅ');
INSERT INTO `lang_definitions` VALUES (1212, 2546, 2, 'Avidentifiering');
INSERT INTO `lang_definitions` VALUES (1213, 2547, 2, 'Avidentifiering komplett');
INSERT INTO `lang_definitions` VALUES (1214, 2548, 2, 'Avidentifiering pågår');
INSERT INTO `lang_definitions` VALUES (1215, 2549, 2, 'Avidentifiering påpbörjad och sker i bakgrunden');
INSERT INTO `lang_definitions` VALUES (1216, 2550, 2, 'Avidentifiering kanske inte är komplett');
INSERT INTO `lang_definitions` VALUES (1217, 2551, 2, 'Avidentifierade filer sparas i');
INSERT INTO `lang_definitions` VALUES (1218, 2552, 2, 'Läkemedelsverket (DEA)');
INSERT INTO `lang_definitions` VALUES (1219, 2558, 2, 'Döv');
INSERT INTO `lang_definitions` VALUES (1220, 2562, 2, 'Debuginformation');
INSERT INTO `lang_definitions` VALUES (1221, 2564, 2, 'Debugging');
INSERT INTO `lang_definitions` VALUES (1222, 2565, 2, 'Dec');
INSERT INTO `lang_definitions` VALUES (1223, 2567, 2, 'Avslutad');
INSERT INTO `lang_definitions` VALUES (1224, 2574, 2, 'December');
INSERT INTO `lang_definitions` VALUES (1225, 2578, 2, 'Decimal pound eller pound/ounces delas med # (ex 5#4)');
INSERT INTO `lang_definitions` VALUES (1226, 2580, 2, 'Avdragsgill');
INSERT INTO `lang_definitions` VALUES (1227, 2581, 2, 'Genomförda avdrag');
INSERT INTO `lang_definitions` VALUES (1228, 2583, 2, 'Standard');
INSERT INTO `lang_definitions` VALUES (1229, 2585, 2, 'Standard Kalender vy');
INSERT INTO `lang_definitions` VALUES (1230, 2587, 2, 'Standard Besöksformulär Id');
INSERT INTO `lang_definitions` VALUES (1231, 2589, 2, 'Standard Klinik');
INSERT INTO `lang_definitions` VALUES (1232, 2594, 2, 'Standardspråk');
INSERT INTO `lang_definitions` VALUES (1233, 2595, 2, 'Standardspråk ifall inget annat är tillåtet eller valt');
INSERT INTO `lang_definitions` VALUES (1234, 2598, 2, 'Standardlista');
INSERT INTO `lang_definitions` VALUES (1235, 2600, 2, 'Standardmetod');
INSERT INTO `lang_definitions` VALUES (1236, 2601, 2, 'Standard tid för lösenords giltighet');
INSERT INTO `lang_definitions` VALUES (1237, 2602, 2, 'Standardtid för lösenords giltighetstid. 0 innebär oändlig giltighet.');
INSERT INTO `lang_definitions` VALUES (1238, 2603, 2, 'Standard patient land');
INSERT INTO `lang_definitions` VALUES (1239, 2606, 2, 'Standard prioritet');
INSERT INTO `lang_definitions` VALUES (1240, 2607, 2, 'Standard vårdgivare');
INSERT INTO `lang_definitions` VALUES (1241, 2609, 2, 'Standard range');
INSERT INTO `lang_definitions` VALUES (1242, 2610, 2, 'Standard kontaktorsak');
INSERT INTO `lang_definitions` VALUES (1243, 2615, 2, 'Standard inställningar');
INSERT INTO `lang_definitions` VALUES (1244, 2617, 2, 'Normalt status för \'Nytt fönster\' markering i patientlistan');
INSERT INTO `lang_definitions` VALUES (1245, 2618, 2, 'Standardmall');
INSERT INTO `lang_definitions` VALUES (1246, 2624, 2, 'Standard enhet');
INSERT INTO `lang_definitions` VALUES (1247, 2626, 2, 'Standardvärde');
INSERT INTO `lang_definitions` VALUES (1248, 2628, 2, 'Standard lager');
INSERT INTO `lang_definitions` VALUES (1249, 2629, 2, 'Standard X12 Partner');
INSERT INTO `lang_definitions` VALUES (1250, 2630, 2, 'Default / Global');
INSERT INTO `lang_definitions` VALUES (1251, 2635, 2, 'Ta bort');
INSERT INTO `lang_definitions` VALUES (1252, 2636, 2, 'Ta bort');
INSERT INTO `lang_definitions` VALUES (1253, 2637, 2, 'Fördröjd Återkommande (> 12 mån)');
INSERT INTO `lang_definitions` VALUES (1254, 2638, 2, 'Ta bort');
INSERT INTO `lang_definitions` VALUES (1255, 2639, 2, 'ta bort');
INSERT INTO `lang_definitions` VALUES (1256, 2640, 2, 'Radera Kategorier med ID (s):');
INSERT INTO `lang_definitions` VALUES (1257, 2641, 2, 'Radera katogori');
INSERT INTO `lang_definitions` VALUES (1258, 2644, 2, 'Kunde ej radera!');
INSERT INTO `lang_definitions` VALUES (1259, 2645, 2, 'Ta bort grupp');
INSERT INTO `lang_definitions` VALUES (1260, 2646, 2, 'Ta bort lista');
INSERT INTO `lang_definitions` VALUES (1261, 2648, 2, 'Radera Sidor');
INSERT INTO `lang_definitions` VALUES (1262, 2649, 2, 'Ta bort patient, Möte, Formulär, Ämne, Dokument, Betalning, Fakturering eller transaktionstryck');
INSERT INTO `lang_definitions` VALUES (1263, 2651, 2, 'Ta bort rad');
INSERT INTO `lang_definitions` VALUES (1264, 2652, 2, 'Ta bort markerade enheter');
INSERT INTO `lang_definitions` VALUES (1265, 2655, 2, 'Borttagning OK');
INSERT INTO `lang_definitions` VALUES (1266, 2656, 2, 'Radera detta dokument');
INSERT INTO `lang_definitions` VALUES (1267, 2657, 2, 'Radera detta formulär');
INSERT INTO `lang_definitions` VALUES (1268, 2659, 2, 'Radera denna anteckning');
INSERT INTO `lang_definitions` VALUES (1269, 2661, 2, 'Borttagning OK');
INSERT INTO `lang_definitions` VALUES (1270, 2662, 2, 'Ta bort');
INSERT INTO `lang_definitions` VALUES (1271, 2663, 2, 'Borttagen händelse kan inte återskapas. Är du säker på att du vill ta bort händelsen?');
INSERT INTO `lang_definitions` VALUES (1272, 2666, 2, 'Leverans bekräftad');
INSERT INTO `lang_definitions` VALUES (1273, 2668, 2, 'Leverans är inte tillåten till specificerad direkt adress.');
INSERT INTO `lang_definitions` VALUES (1274, 2670, 2, 'Leverans av bifogat kliniskt dokument var begärt av patienten');
INSERT INTO `lang_definitions` VALUES (1275, 2671, 2, 'Demens');
INSERT INTO `lang_definitions` VALUES (1276, 2673, 2, 'Demografi');
INSERT INTO `lang_definitions` VALUES (1277, 2674, 2, 'Demografi');
INSERT INTO `lang_definitions` VALUES (1278, 2678, 2, 'Demografi filter kriterier');
INSERT INTO `lang_definitions` VALUES (1279, 2680, 2, 'Demografi ej auktoriserad');
INSERT INTO `lang_definitions` VALUES (1280, 2681, 2, 'Demografi ej auktoriserad');
INSERT INTO `lang_definitions` VALUES (1281, 2682, 2, 'Nekad');
INSERT INTO `lang_definitions` VALUES (1282, 2684, 2, 'Nämnare');
INSERT INTO `lang_definitions` VALUES (1283, 2687, 2, 'Dental');
INSERT INTO `lang_definitions` VALUES (1284, 2688, 2, 'Tandvård ärende lista');
INSERT INTO `lang_definitions` VALUES (1285, 2689, 2, 'Tandvårds ärenden');
INSERT INTO `lang_definitions` VALUES (1286, 2694, 2, 'Beroende på vilken typ av räkning som testas kommer man kunna se HCFA liknande utskrift på blankt papper om HFCA-räkning testas, flera rader med blurrig text och information ifall X12-claim testas. Denna text är X12 EDI 4010A format. Ibland ser man udda konstiga tecken som liknar små figurer. Detta är kontrolltecken för sidmatning mm och det är helt normalt.');
INSERT INTO `lang_definitions` VALUES (1287, 2696, 2, 'Insättningsdatum');
INSERT INTO `lang_definitions` VALUES (1288, 2697, 2, 'Insättningsdatum kan inte vara senare än idag.');
INSERT INTO `lang_definitions` VALUES (1289, 2698, 2, 'Insättning Datum:');
INSERT INTO `lang_definitions` VALUES (1290, 2699, 2, 'Deprimerad');
INSERT INTO `lang_definitions` VALUES (1291, 2700, 2, 'Depression');
INSERT INTO `lang_definitions` VALUES (1292, 2706, 2, 'Beskrivning');
INSERT INTO `lang_definitions` VALUES (1293, 2707, 2, 'beskrivning');
INSERT INTO `lang_definitions` VALUES (1294, 2709, 2, 'Beskrivning av upptäckten');
INSERT INTO `lang_definitions` VALUES (1295, 2710, 2, 'Beskrivning av åtgärden eller resultatkod');
INSERT INTO `lang_definitions` VALUES (1296, 2711, 2, 'Beskrivning översättning');
INSERT INTO `lang_definitions` VALUES (1297, 2713, 2, 'Mål');
INSERT INTO `lang_definitions` VALUES (1298, 2714, 2, 'Målfilnamn');
INSERT INTO `lang_definitions` VALUES (1299, 2716, 2, 'Förstör Parti');
INSERT INTO `lang_definitions` VALUES (1300, 2717, 2, 'Förstör ...');
INSERT INTO `lang_definitions` VALUES (1301, 2718, 2, 'Förstörd');
INSERT INTO `lang_definitions` VALUES (1302, 2719, 2, 'Förstörda läkemedel');
INSERT INTO `lang_definitions` VALUES (1303, 2720, 2, 'Förstöras narkotika Rapport');
INSERT INTO `lang_definitions` VALUES (1304, 2721, 2, 'Detalj');
INSERT INTO `lang_definitions` VALUES (1305, 2726, 2, 'Detaljer');
INSERT INTO `lang_definitions` VALUES (1306, 2728, 2, 'Utvecklingsstörning');
INSERT INTO `lang_definitions` VALUES (1307, 2730, 2, 'Diabetes');
INSERT INTO `lang_definitions` VALUES (1308, 2731, 2, 'Diabetes Mellitus');
INSERT INTO `lang_definitions` VALUES (1309, 2732, 2, 'Diabetes: Blodtryckskontroll');
INSERT INTO `lang_definitions` VALUES (1310, 2733, 2, 'Diabetes: Ögonundersökning');
INSERT INTO `lang_definitions` VALUES (1311, 2734, 2, 'Diabetes: Ögonundersökning');
INSERT INTO `lang_definitions` VALUES (1312, 2735, 2, 'Diabetes: Fotundersökning');
INSERT INTO `lang_definitions` VALUES (1313, 2736, 2, 'Diabetes: Fotundersökning');
INSERT INTO `lang_definitions` VALUES (1314, 2737, 2, 'Diabetes: HbA1c dåligt reglerat');
INSERT INTO `lang_definitions` VALUES (1315, 2738, 2, 'Diabetes: HbA1c');
INSERT INTO `lang_definitions` VALUES (1316, 2739, 2, 'Diabetes: Blodfetter');
INSERT INTO `lang_definitions` VALUES (1317, 2740, 2, 'Diabetes: Urin microalbumin');
INSERT INTO `lang_definitions` VALUES (1318, 2741, 2, 'Diag');
INSERT INTO `lang_definitions` VALUES (1319, 2742, 2, 'Diagnoser');
INSERT INTO `lang_definitions` VALUES (1320, 2743, 2, 'Diagnos');
INSERT INTO `lang_definitions` VALUES (1321, 2744, 2, 'Diagnoskod');
INSERT INTO `lang_definitions` VALUES (1322, 2747, 2, 'Diagnos datum');
INSERT INTO `lang_definitions` VALUES (1323, 2749, 2, 'Diagnos måste kodas in i ett länkat patientmöte');
INSERT INTO `lang_definitions` VALUES (1324, 2750, 2, 'Diagnos namn');
INSERT INTO `lang_definitions` VALUES (1325, 2751, 2, 'Diagnos rapport');
INSERT INTO `lang_definitions` VALUES (1326, 2752, 2, 'Diagnos rapport');
INSERT INTO `lang_definitions` VALUES (1327, 2753, 2, 'Diagnos rapport enbart');
INSERT INTO `lang_definitions` VALUES (1328, 2754, 2, 'Diagnos titel');
INSERT INTO `lang_definitions` VALUES (1329, 2755, 2, 'Diagnos:');
INSERT INTO `lang_definitions` VALUES (1330, 2756, 2, 'Diagnos:');
INSERT INTO `lang_definitions` VALUES (1331, 2758, 2, 'Diagnostiska tester:');
INSERT INTO `lang_definitions` VALUES (1332, 2760, 2, 'Skala');
INSERT INTO `lang_definitions` VALUES (1333, 2763, 2, 'Membran/kapsel');
INSERT INTO `lang_definitions` VALUES (1334, 2764, 2, 'Diarée');
INSERT INTO `lang_definitions` VALUES (1335, 2767, 2, 'Diktat');
INSERT INTO `lang_definitions` VALUES (1336, 2768, 2, 'Diktat:');
INSERT INTO `lang_definitions` VALUES (1337, 2769, 2, 'Fick du en kopia av denna HIPAA notering?');
INSERT INTO `lang_definitions` VALUES (1338, 2770, 2, 'Diffus');
INSERT INTO `lang_definitions` VALUES (1339, 2771, 2, 'Digitalt signerad');
INSERT INTO `lang_definitions` VALUES (1340, 2781, 2, 'Direkt mail');
INSERT INTO `lang_definitions` VALUES (1341, 2782, 2, 'Log på direktmeddelande');
INSERT INTO `lang_definitions` VALUES (1342, 2783, 2, 'Direkt meddelande mottaget');
INSERT INTO `lang_definitions` VALUES (1343, 2784, 2, 'Direkt meddelande ej tillgängligt');
INSERT INTO `lang_definitions` VALUES (1344, 2785, 2, 'Kunde ej skicka direkt meddelande');
INSERT INTO `lang_definitions` VALUES (1345, 2787, 2, 'Arbetsledare, namn');
INSERT INTO `lang_definitions` VALUES (1346, 2788, 2, 'Kunde ej ta bort mapp. Fortsätt');
INSERT INTO `lang_definitions` VALUES (1347, 2789, 2, 'Funktionshinder');
INSERT INTO `lang_definitions` VALUES (1348, 2794, 2, 'Stäng av kalender');
INSERT INTO `lang_definitions` VALUES (1349, 2795, 2, 'Stäng av spårning av patientkort');
INSERT INTO `lang_definitions` VALUES (1350, 2798, 2, 'Stäng av vaccination');
INSERT INTO `lang_definitions` VALUES (1351, 2800, 2, 'Stäng av gammal metrisk vitala tecken formulär');
INSERT INTO `lang_definitions` VALUES (1352, 2802, 2, 'Stäng av phpMyAdmin');
INSERT INTO `lang_definitions` VALUES (1353, 2803, 2, 'Stäng av receptförskrivning');
INSERT INTO `lang_definitions` VALUES (1354, 2804, 2, 'Stäng av användargrupp');
INSERT INTO `lang_definitions` VALUES (1355, 2805, 2, 'funktionshindrade');
INSERT INTO `lang_definitions` VALUES (1356, 2806, 2, 'Funktionshindrade');
INSERT INTO `lang_definitions` VALUES (1357, 2807, 2, 'Handikappad under 65 år med LGHP-försäkring');
INSERT INTO `lang_definitions` VALUES (1358, 2812, 2, 'Disk');
INSERT INTO `lang_definitions` VALUES (1359, 2815, 2, 'Utskrivning');
INSERT INTO `lang_definitions` VALUES (1360, 2816, 2, 'Flytningar från urinröret');
INSERT INTO `lang_definitions` VALUES (1361, 2818, 2, 'Rätt utskriven');
INSERT INTO `lang_definitions` VALUES (1362, 2819, 2, 'Rätt utskriven');
INSERT INTO `lang_definitions` VALUES (1363, 2823, 2, 'Utskriven');
INSERT INTO `lang_definitions` VALUES (1364, 2825, 2, 'Kvitto information');
INSERT INTO `lang_definitions` VALUES (1365, 2826, 2, 'Kvitto typ');
INSERT INTO `lang_definitions` VALUES (1366, 2827, 2, 'Kvitton typer');
INSERT INTO `lang_definitions` VALUES (1367, 2828, 2, 'Kvitton');
INSERT INTO `lang_definitions` VALUES (1368, 2833, 2, 'Rabatt');
INSERT INTO `lang_definitions` VALUES (1369, 2834, 2, 'Rabatt Belopp');
INSERT INTO `lang_definitions` VALUES (1370, 2835, 2, 'Rabatt nivå');
INSERT INTO `lang_definitions` VALUES (1371, 2836, 2, 'Rabatt procent');
INSERT INTO `lang_definitions` VALUES (1372, 2837, 2, 'Rabatt som belopp');
INSERT INTO `lang_definitions` VALUES (1373, 2838, 2, 'Rabatt vid checkout skrivs in som belopp i stället för som procent');
INSERT INTO `lang_definitions` VALUES (1374, 2839, 2, 'Diskreta resultat');
INSERT INTO `lang_definitions` VALUES (1375, 2841, 2, 'Sjukdom');
INSERT INTO `lang_definitions` VALUES (1376, 2843, 2, 'Förskjutning');
INSERT INTO `lang_definitions` VALUES (1377, 2847, 2, 'Antal:');
INSERT INTO `lang_definitions` VALUES (1378, 2848, 2, 'Skicka i väg');
INSERT INTO `lang_definitions` VALUES (1379, 2849, 2, 'Skicka mottagna dokument');
INSERT INTO `lang_definitions` VALUES (1380, 2853, 2, 'Utlämnad');
INSERT INTO `lang_definitions` VALUES (1381, 2856, 2, 'Visa avancerade inställningar på demografisidan');
INSERT INTO `lang_definitions` VALUES (1382, 2859, 2, 'Visa händelsedatum i blocket?');
INSERT INTO `lang_definitions` VALUES (1383, 2860, 2, 'Visa format får US vikter?');
INSERT INTO `lang_definitions` VALUES (1384, 2861, 2, 'Visa hur många händelser?');
INSERT INTO `lang_definitions` VALUES (1385, 2865, 2, 'Visa plats i blocket?');
INSERT INTO `lang_definitions` VALUES (1386, 2866, 2, 'Visa namn');
INSERT INTO `lang_definitions` VALUES (1387, 2868, 2, 'Visa kalender?');
INSERT INTO `lang_definitions` VALUES (1388, 2875, 2, 'Display dagens händelser i blocket?');
INSERT INTO `lang_definitions` VALUES (1389, 2876, 2, 'Visa ämne i blocket?');
INSERT INTO `lang_definitions` VALUES (1390, 2877, 2, 'Visa kommande händelser i blocket?');
INSERT INTO `lang_definitions` VALUES (1391, 2879, 2, 'Visa kommande händelser i blocket?');
INSERT INTO `lang_definitions` VALUES (1392, 2880, 2, 'Visa följande antal av de senaste meddelandena.');
INSERT INTO `lang_definitions` VALUES (1393, 2882, 2, 'Visa följande antal av senaste noteringarna');
INSERT INTO `lang_definitions` VALUES (1394, 2883, 2, 'Visa följande antal av de senaste noteringarna');
INSERT INTO `lang_definitions` VALUES (1395, 2890, 2, 'Distrubition');
INSERT INTO `lang_definitions` VALUES (1396, 2891, 2, 'Distribution');
INSERT INTO `lang_definitions` VALUES (1397, 2892, 2, 'Leverantör');
INSERT INTO `lang_definitions` VALUES (1398, 2897, 2, 'Divertikulit');
INSERT INTO `lang_definitions` VALUES (1399, 2898, 2, 'Divertikulit kirurgi');
INSERT INTO `lang_definitions` VALUES (1400, 2899, 2, 'Divertikulit');
INSERT INTO `lang_definitions` VALUES (1401, 2900, 2, 'Divertikulit Kirurgi');
INSERT INTO `lang_definitions` VALUES (1402, 2901, 2, 'Skild');
INSERT INTO `lang_definitions` VALUES (1403, 2902, 2, 'Yrsel:');
INSERT INTO `lang_definitions` VALUES (1404, 2905, 2, 'Ändra inte');
INSERT INTO `lang_definitions` VALUES (1405, 2907, 2, 'Visa inte Allergi uppladdad till NewCrop');
INSERT INTO `lang_definitions` VALUES (1406, 2909, 2, 'Visa inte medicinering uppladdad till NewCrop');
INSERT INTO `lang_definitions` VALUES (1407, 2912, 2, 'Visa inte kalender');
INSERT INTO `lang_definitions` VALUES (1408, 2916, 2, 'Lagra och sälj inga produkter');
INSERT INTO `lang_definitions` VALUES (1409, 2919, 2, 'Kräv inte att patientanteckningar blir godkända');
INSERT INTO `lang_definitions` VALUES (1410, 2920, 2, 'Inte HLR beslut');
INSERT INTO `lang_definitions` VALUES (1411, 2921, 2, 'spara inte');
INSERT INTO `lang_definitions` VALUES (1412, 2922, 2, 'ersätt inte');
INSERT INTO `lang_definitions` VALUES (1413, 2925, 2, 'gör ingenting');
INSERT INTO `lang_definitions` VALUES (1414, 2929, 2, 'Vill du verkligen radera?');
INSERT INTO `lang_definitions` VALUES (1415, 2930, 2, 'Vill du verkligen radera detta urval?');
INSERT INTO `lang_definitions` VALUES (1416, 2931, 2, 'Vill du verkligen ta bort den här gruppen');
INSERT INTO `lang_definitions` VALUES (1417, 2934, 2, 'Vill du fortsätta?');
INSERT INTO `lang_definitions` VALUES (1418, 2935, 2, 'Vill du ta bort detta?');
INSERT INTO `lang_definitions` VALUES (1419, 2936, 2, 'Vill du ta bort?');
INSERT INTO `lang_definitions` VALUES (1420, 2937, 2, 'Vill du ta bort denna post?');
INSERT INTO `lang_definitions` VALUES (1421, 2938, 2, 'Vill du fortsätta att lägga till den nya patienten?');
INSERT INTO `lang_definitions` VALUES (1422, 2939, 2, 'Vill du fortsätta med det nya namnet?');
INSERT INTO `lang_definitions` VALUES (1423, 2940, 2, 'Vill du PERMANENT ta bort vaccinationsregistreringen?');
INSERT INTO `lang_definitions` VALUES (1424, 2941, 2, 'Födelsedatum');
INSERT INTO `lang_definitions` VALUES (1425, 2942, 2, 'Födelsedatum saknas, ange om möjligt');
INSERT INTO `lang_definitions` VALUES (1426, 2944, 2, 'Dokument');
INSERT INTO `lang_definitions` VALUES (1427, 2945, 2, 'Läkare');
INSERT INTO `lang_definitions` VALUES (1428, 2946, 2, 'Läkare:');
INSERT INTO `lang_definitions` VALUES (1429, 2947, 2, 'Läkares namn och underskrift');
INSERT INTO `lang_definitions` VALUES (1430, 2948, 2, 'Dokument');
INSERT INTO `lang_definitions` VALUES (1431, 2949, 2, 'dokument');
INSERT INTO `lang_definitions` VALUES (1432, 2951, 2, 'Dokument Kategorier');
INSERT INTO `lang_definitions` VALUES (1433, 2958, 2, 'Dokument kan inte flyttas till patienten id');
INSERT INTO `lang_definitions` VALUES (1434, 2960, 2, 'Dokument Datum');
INSERT INTO `lang_definitions` VALUES (1435, 2961, 2, 'Dokumentets datum och utförande uppdaterats');
INSERT INTO `lang_definitions` VALUES (1436, 2962, 2, 'Dokument id');
INSERT INTO `lang_definitions` VALUES (1437, 2965, 2, 'Dokument är flyttat till ny kategori');
INSERT INTO `lang_definitions` VALUES (1438, 2966, 2, 'Dokument är flyttat till patienten id');
INSERT INTO `lang_definitions` VALUES (1439, 2968, 2, 'Dokument kontrollerat');
INSERT INTO `lang_definitions` VALUES (1440, 2969, 2, 'Sätt att lagra dokument');
INSERT INTO `lang_definitions` VALUES (1441, 2970, 2, 'Namnbyte av dokument lyckats');
INSERT INTO `lang_definitions` VALUES (1442, 2976, 2, 'Dokument/avbildning lagrad');
INSERT INTO `lang_definitions` VALUES (1443, 2978, 2, 'Dokument');
INSERT INTO `lang_definitions` VALUES (1444, 2980, 2, 'Dokument (skriva, tilllägg frivilligt)');
INSERT INTO `lang_definitions` VALUES (1445, 2989, 2, 'Inskrivningsdatum');
INSERT INTO `lang_definitions` VALUES (1446, 2994, 2, 'stämmer inte med PV1 besöksnummer');
INSERT INTO `lang_definitions` VALUES (1447, 2995, 2, 'Verkar inte giltig');
INSERT INTO `lang_definitions` VALUES (1448, 2996, 2, 'Tillåter denna typ relaterade koder?');
INSERT INTO `lang_definitions` VALUES (1449, 2997, 2, 'Sambo');
INSERT INTO `lang_definitions` VALUES (1450, 2998, 2, 'Spara inte');
INSERT INTO `lang_definitions` VALUES (1451, 2999, 2, 'Spara inte');
INSERT INTO `lang_definitions` VALUES (1452, 3000, 2, 'Spara inte');
INSERT INTO `lang_definitions` VALUES (1453, 3002, 2, 'Klart');
INSERT INTO `lang_definitions` VALUES (1454, 3004, 2, 'Klar med:');
INSERT INTO `lang_definitions` VALUES (1455, 3005, 2, 'Klar. Skickas för nedladdning');
INSERT INTO `lang_definitions` VALUES (1456, 3006, 2, 'Datum för tjänsten');
INSERT INTO `lang_definitions` VALUES (1457, 3007, 2, 'Dosering');
INSERT INTO `lang_definitions` VALUES (1458, 3011, 2, 'dubbelklicka för att redigera');
INSERT INTO `lang_definitions` VALUES (1459, 3013, 2, 'Dubbelseende');
INSERT INTO `lang_definitions` VALUES (1460, 3014, 2, 'Ladda ner');
INSERT INTO `lang_definitions` VALUES (1461, 3019, 2, 'Ladda ner ändå');
INSERT INTO `lang_definitions` VALUES (1462, 3020, 2, 'Ladda ner faktura fil, bokför och markera som skickad.');
INSERT INTO `lang_definitions` VALUES (1463, 3022, 2, 'Ladda ner certifikat');
INSERT INTO `lang_definitions` VALUES (1464, 3023, 2, 'Ladda ner configurationsdata');
INSERT INTO `lang_definitions` VALUES (1465, 3027, 2, 'ladda ner krypterad fil');
INSERT INTO `lang_definitions` VALUES (1466, 3033, 2, 'Ladda ner PDF');
INSERT INTO `lang_definitions` VALUES (1467, 3037, 2, 'Ladda ner utvald redogörelse');
INSERT INTO `lang_definitions` VALUES (1468, 3039, 2, 'Läkarkontroll');
INSERT INTO `lang_definitions` VALUES (1469, 3040, 2, 'Läkarbesök');
INSERT INTO `lang_definitions` VALUES (1470, 3041, 2, 'Dr.');
INSERT INTO `lang_definitions` VALUES (1471, 3045, 2, 'Drag för att flytta');
INSERT INTO `lang_definitions` VALUES (1472, 3047, 2, 'Dribblande');
INSERT INTO `lang_definitions` VALUES (1473, 3048, 2, 'Körkortsnr');
INSERT INTO `lang_definitions` VALUES (1474, 3050, 2, 'Läkemedel');
INSERT INTO `lang_definitions` VALUES (1475, 3053, 2, 'Leta läkemedel');
INSERT INTO `lang_definitions` VALUES (1476, 3054, 2, 'Läkemedelsformulär');
INSERT INTO `lang_definitions` VALUES (1477, 3055, 2, 'Läkemeddels ID saknas!');
INSERT INTO `lang_definitions` VALUES (1478, 3056, 2, 'Läkemedel intervall');
INSERT INTO `lang_definitions` VALUES (1479, 3057, 2, 'Inventarielista, läkemedel');
INSERT INTO `lang_definitions` VALUES (1480, 3059, 2, 'Läkemedelsnamn');
INSERT INTO `lang_definitions` VALUES (1481, 3061, 2, 'Läkemedel administrationssätt');
INSERT INTO `lang_definitions` VALUES (1482, 3066, 2, 'Läkemedel, enheter');
INSERT INTO `lang_definitions` VALUES (1483, 3072, 2, 'Läkemedel');
INSERT INTO `lang_definitions` VALUES (1484, 3073, 2, 'Läkemedel och produkter');
INSERT INTO `lang_definitions` VALUES (1485, 3074, 2, 'Muntorrhet');
INSERT INTO `lang_definitions` VALUES (1486, 3075, 2, 'DSM-4 Diagnos');
INSERT INTO `lang_definitions` VALUES (1487, 3076, 2, 'DT 1');
INSERT INTO `lang_definitions` VALUES (1488, 3077, 2, 'DT 2');
INSERT INTO `lang_definitions` VALUES (1489, 3078, 2, 'DT 3');
INSERT INTO `lang_definitions` VALUES (1490, 3079, 2, 'DT 4');
INSERT INTO `lang_definitions` VALUES (1491, 3080, 2, 'DT 5');
INSERT INTO `lang_definitions` VALUES (1492, 3081, 2, 'DTaP 1');
INSERT INTO `lang_definitions` VALUES (1493, 3082, 2, 'DTaP 2');
INSERT INTO `lang_definitions` VALUES (1494, 3083, 2, 'DTaP 3');
INSERT INTO `lang_definitions` VALUES (1495, 3084, 2, 'DTaP 4');
INSERT INTO `lang_definitions` VALUES (1496, 3085, 2, 'DTaP 5');
INSERT INTO `lang_definitions` VALUES (1497, 3087, 2, 'Förfaller');
INSERT INTO `lang_definitions` VALUES (1498, 3088, 2, 'Förfallodatum');
INSERT INTO `lang_definitions` VALUES (1499, 3090, 2, 'Förfallodatum mm / dd / yyyy eller åååå-mm-dd');
INSERT INTO `lang_definitions` VALUES (1500, 3091, 2, 'Förfallodatum:');
INSERT INTO `lang_definitions` VALUES (1501, 3093, 2, 'Förfaller patienter');
INSERT INTO `lang_definitions` VALUES (1502, 3094, 2, 'Förfaller snart');
INSERT INTO `lang_definitions` VALUES (1503, 3095, 2, 'Förfallostatus');
INSERT INTO `lang_definitions` VALUES (1504, 3096, 2, 'Uppdatera förfallostatus');
INSERT INTO `lang_definitions` VALUES (1505, 3097, 2, 'Dumping OpenEMR database');
INSERT INTO `lang_definitions` VALUES (1506, 3098, 2, 'Dumping OpenEMR web directory tree');
INSERT INTO `lang_definitions` VALUES (1507, 3099, 2, 'Dumping phpGACL database');
INSERT INTO `lang_definitions` VALUES (1508, 3100, 2, 'Dumping phpGACL web directory tree');
INSERT INTO `lang_definitions` VALUES (1509, 3101, 2, 'Dumping SQL-Ledger database');
INSERT INTO `lang_definitions` VALUES (1510, 3102, 2, 'Dumping SQL-Ledger web directory tree');
INSERT INTO `lang_definitions` VALUES (1511, 3103, 2, 'Dubletter kontroll');
INSERT INTO `lang_definitions` VALUES (1512, 3108, 2, 'Dubletter av ID');
INSERT INTO `lang_definitions` VALUES (1513, 3109, 2, 'Dubletter av namn');
INSERT INTO `lang_definitions` VALUES (1514, 3110, 2, 'DUBLETTER VARNING');
INSERT INTO `lang_definitions` VALUES (1515, 3111, 2, 'Varaktig fullmakt');
INSERT INTO `lang_definitions` VALUES (1516, 3112, 2, 'Varaktighet');
INSERT INTO `lang_definitions` VALUES (1517, 3113, 2, 'varaktighet');
INSERT INTO `lang_definitions` VALUES (1518, 3114, 2, 'Holländsk');
INSERT INTO `lang_definitions` VALUES (1519, 3117, 2, 'Dysfagi');
INSERT INTO `lang_definitions` VALUES (1520, 3118, 2, 'Dyspné:');
INSERT INTO `lang_definitions` VALUES (1521, 3119, 2, 'Urinvägsbesvär');
INSERT INTO `lang_definitions` VALUES (1522, 3128, 2, 'E-recept?');
INSERT INTO `lang_definitions` VALUES (1523, 3129, 2, 'E-rapport');
INSERT INTO `lang_definitions` VALUES (1524, 3130, 2, 'E-recept?');
INSERT INTO `lang_definitions` VALUES (1525, 3132, 2, 'Förnya E-recept');
INSERT INTO `lang_definitions` VALUES (1526, 3135, 2, 'Varje mottagare måste själv ange att meddelanden är avslutade');
INSERT INTO `lang_definitions` VALUES (1527, 3140, 2, 'Tidig Återkommande (<2 Mo)');
INSERT INTO `lang_definitions` VALUES (1528, 3141, 2, 'Öron');
INSERT INTO `lang_definitions` VALUES (1529, 3148, 2, 'EKG');
INSERT INTO `lang_definitions` VALUES (1530, 3149, 2, 'Elektronisk begäran');
INSERT INTO `lang_definitions` VALUES (1531, 3152, 2, 'Ödem');
INSERT INTO `lang_definitions` VALUES (1532, 3159, 2, 'Redigera');
INSERT INTO `lang_definitions` VALUES (1533, 3161, 2, 'Redigera allergier');
INSERT INTO `lang_definitions` VALUES (1534, 3163, 2, 'Edit Kategorier');
INSERT INTO `lang_definitions` VALUES (1535, 3166, 2, 'Redigera definitioner');
INSERT INTO `lang_definitions` VALUES (1536, 3167, 2, 'Redigera diagnoser för');
INSERT INTO `lang_definitions` VALUES (1537, 3173, 2, 'Redigera Kliniker');
INSERT INTO `lang_definitions` VALUES (1538, 3175, 2, 'Redigera Klinikinformation');
INSERT INTO `lang_definitions` VALUES (1539, 3178, 2, 'Redigera form');
INSERT INTO `lang_definitions` VALUES (1540, 3183, 2, 'Redigera layout');
INSERT INTO `lang_definitions` VALUES (1541, 3185, 2, 'Redigera lista');
INSERT INTO `lang_definitions` VALUES (1542, 3189, 2, 'Redigera Struktur');
INSERT INTO `lang_definitions` VALUES (1543, 3196, 2, 'Utbildning');
INSERT INTO `lang_definitions` VALUES (1544, 3197, 2, 'Information');
INSERT INTO `lang_definitions` VALUES (1545, 3200, 2, 'Ikraftträdandedatum');
INSERT INTO `lang_definitions` VALUES (1546, 3202, 2, 'Effektivitet');
INSERT INTO `lang_definitions` VALUES (1547, 3207, 2, 'Ejaculation');
INSERT INTO `lang_definitions` VALUES (1548, 3208, 2, 'Armbåge');
INSERT INTO `lang_definitions` VALUES (1549, 3209, 2, 'Problem med armbågen');
INSERT INTO `lang_definitions` VALUES (1550, 3214, 2, 'Elektronisk remiss');
INSERT INTO `lang_definitions` VALUES (1551, 3225, 2, 'Email');
INSERT INTO `lang_definitions` VALUES (1552, 3236, 2, 'E-post från Batchcom');
INSERT INTO `lang_definitions` VALUES (1553, 3238, 2, 'E-postmeddelande');
INSERT INTO `lang_definitions` VALUES (1554, 3244, 2, 'E-post skicka innan');
INSERT INTO `lang_definitions` VALUES (1555, 3245, 2, 'Email, skicka');
INSERT INTO `lang_definitions` VALUES (1556, 3248, 2, 'Epost Ämnesord');
INSERT INTO `lang_definitions` VALUES (1557, 3251, 2, 'Email Text, användbara Tag: *** NAMN ***, dvs Bäste *** NAMN ***');
INSERT INTO `lang_definitions` VALUES (1558, 3259, 2, 'ICE Kontakt');
INSERT INTO `lang_definitions` VALUES (1559, 3260, 2, 'ICE kontaktperson');
INSERT INTO `lang_definitions` VALUES (1560, 3261, 2, 'ICE kontakt telefonnummer');
INSERT INTO `lang_definitions` VALUES (1561, 3262, 2, 'Akut Preventivmedel');
INSERT INTO `lang_definitions` VALUES (1562, 3268, 2, 'ICE Telefon');
INSERT INTO `lang_definitions` VALUES (1563, 3271, 2, 'Emfysem');
INSERT INTO `lang_definitions` VALUES (1564, 3272, 2, 'Anställd');
INSERT INTO `lang_definitions` VALUES (1565, 3273, 2, 'Arbetsgivare');
INSERT INTO `lang_definitions` VALUES (1566, 3274, 2, 'Arbetsgivarens adress');
INSERT INTO `lang_definitions` VALUES (1567, 3275, 2, 'Arbetsgivare Data');
INSERT INTO `lang_definitions` VALUES (1568, 3276, 2, 'Arbetsgivarens namn');
INSERT INTO `lang_definitions` VALUES (1569, 3278, 2, 'Ta bort');
INSERT INTO `lang_definitions` VALUES (1570, 3281, 2, 'Ta bort värdet i \"E-tider\"');
INSERT INTO `lang_definitions` VALUES (1571, 3282, 2, 'Ta bort värde \"Email, skicka\"');
INSERT INTO `lang_definitions` VALUES (1572, 3283, 2, 'Ta bort värde i \"Email, ämne\"');
INSERT INTO `lang_definitions` VALUES (1573, 3284, 2, 'Ta bort i \"text\"');
INSERT INTO `lang_definitions` VALUES (1574, 3285, 2, 'Ta bort i \"Försörjarens namn\"');
INSERT INTO `lang_definitions` VALUES (1575, 3286, 2, 'Ta bort i \"Lösenord\"');
INSERT INTO `lang_definitions` VALUES (1576, 3287, 2, 'Ta bort \"SMS tider\"');
INSERT INTO `lang_definitions` VALUES (1577, 3288, 2, 'Ta bort \"SMS text\"');
INSERT INTO `lang_definitions` VALUES (1578, 3289, 2, 'Ta bort värdet i \"Användarnamn\"');
INSERT INTO `lang_definitions` VALUES (1579, 3404, 2, 'aktiverat');
INSERT INTO `lang_definitions` VALUES (1580, 3415, 2, 'Möte');
INSERT INTO `lang_definitions` VALUES (1581, 3418, 2, 'Patientmöte');
INSERT INTO `lang_definitions` VALUES (1582, 3419, 2, 'patientmöte');
INSERT INTO `lang_definitions` VALUES (1583, 3420, 2, 'Patientmöter');
INSERT INTO `lang_definitions` VALUES (1584, 3432, 2, 'Patientmöte formulär');
INSERT INTO `lang_definitions` VALUES (1585, 3439, 2, 'Patientmöte antal/nummer');
INSERT INTO `lang_definitions` VALUES (1586, 3461, 2, 'Patientmöte har kodats');
INSERT INTO `lang_definitions` VALUES (1587, 3462, 2, 'Patientmöte:');
INSERT INTO `lang_definitions` VALUES (1588, 3464, 2, 'Patientmöten');
INSERT INTO `lang_definitions` VALUES (1589, 3465, 2, 'Patientmöte & Formulär');
INSERT INTO `lang_definitions` VALUES (1590, 3466, 2, 'Patientmöte & Formulär');
INSERT INTO `lang_definitions` VALUES (1591, 3467, 2, 'Encounters inte godkända');
INSERT INTO `lang_definitions` VALUES (1592, 3468, 2, 'Patientmöte, rapport');
INSERT INTO `lang_definitions` VALUES (1593, 3469, 2, 'Patientmöte, avsnitt');
INSERT INTO `lang_definitions` VALUES (1594, 3472, 2, 'Slut');
INSERT INTO `lang_definitions` VALUES (1595, 3473, 2, 'Slutar (åååå-mm-dd):');
INSERT INTO `lang_definitions` VALUES (1596, 3474, 2, 'Slutdatum');
INSERT INTO `lang_definitions` VALUES (1597, 3475, 2, 'Slutdatum');
INSERT INTO `lang_definitions` VALUES (1598, 3482, 2, 'Slutdatum:');
INSERT INTO `lang_definitions` VALUES (1599, 3487, 2, 'Sluttid');
INSERT INTO `lang_definitions` VALUES (1600, 3492, 2, 'Tjänsten slutar åååå-mm-dd');
INSERT INTO `lang_definitions` VALUES (1601, 3496, 2, 'Endokrina');
INSERT INTO `lang_definitions` VALUES (1602, 3497, 2, 'Endoskopi');
INSERT INTO `lang_definitions` VALUES (1603, 3502, 2, 'Engelsk');
INSERT INTO `lang_definitions` VALUES (1604, 3503, 2, 'Engelsk');
INSERT INTO `lang_definitions` VALUES (1605, 3504, 2, 'Engelsk (indien)');
INSERT INTO `lang_definitions` VALUES (1606, 3505, 2, 'Engelsk (standard)');
INSERT INTO `lang_definitions` VALUES (1607, 3509, 2, 'ENT Ansvarsfrihet');
INSERT INTO `lang_definitions` VALUES (1608, 3510, 2, 'ENT Smärta');
INSERT INTO `lang_definitions` VALUES (1609, 3513, 2, 'Skriv en diagnos kod för att utesluta alla fakturor som inte innehåller det');
INSERT INTO `lang_definitions` VALUES (1610, 3581, 2, 'Ange dina sökkriterier ovan');
INSERT INTO `lang_definitions` VALUES (1611, 3591, 2, 'Miljöpåverkan');
INSERT INTO `lang_definitions` VALUES (1612, 3592, 2, 'EOB Data tillträde');
INSERT INTO `lang_definitions` VALUES (1613, 3597, 2, 'EOB Boknings - Instruktioner');
INSERT INTO `lang_definitions` VALUES (1614, 3598, 2, 'EOB Boknings - Faktura');
INSERT INTO `lang_definitions` VALUES (1615, 3599, 2, 'EOB Boknings - Patient Anmärkning');
INSERT INTO `lang_definitions` VALUES (1616, 3600, 2, 'EOB Boknings - Sök');
INSERT INTO `lang_definitions` VALUES (1617, 3602, 2, 'Epilepsi');
INSERT INTO `lang_definitions` VALUES (1618, 3612, 2, 'Radera');
INSERT INTO `lang_definitions` VALUES (1619, 3614, 2, 'Erektion');
INSERT INTO `lang_definitions` VALUES (1620, 3615, 2, 'Fel');
INSERT INTO `lang_definitions` VALUES (1621, 3621, 2, 'Fel i \"kön\" val');
INSERT INTO `lang_definitions` VALUES (1622, 3622, 2, 'Fel i \"HIPAA\" val');
INSERT INTO `lang_definitions` VALUES (1623, 3623, 2, 'Fel i \"Process\" val');
INSERT INTO `lang_definitions` VALUES (1624, 3624, 2, 'Fel i \"SMS Gateway\" val');
INSERT INTO `lang_definitions` VALUES (1625, 3625, 2, 'Fel i \"Sortera efter\" val');
INSERT INTO `lang_definitions` VALUES (1626, 3627, 2, 'Fel i JA eller NEJ alternativ');
INSERT INTO `lang_definitions` VALUES (1627, 3640, 2, 'fel under registrering!');
INSERT INTO `lang_definitions` VALUES (1628, 3641, 2, 'Fel vid sparande av fil');
INSERT INTO `lang_definitions` VALUES (1629, 3643, 2, 'Fel vid skrivning till fil');
INSERT INTO `lang_definitions` VALUES (1630, 3652, 2, 'FEL, kunde inte samla in data från servern');
INSERT INTO `lang_definitions` VALUES (1631, 3664, 2, 'FEL: kunde inte öppna table.sql bruten form?');
INSERT INTO `lang_definitions` VALUES (1632, 3672, 2, 'Fel: lösenord matchar inte. Kontrollera din stavning.');
INSERT INTO `lang_definitions` VALUES (1633, 3682, 2, 'Fel');
INSERT INTO `lang_definitions` VALUES (1634, 3690, 2, 'Erythema:');
INSERT INTO `lang_definitions` VALUES (1635, 3699, 2, 'Redan känd patient');
INSERT INTO `lang_definitions` VALUES (1636, 3701, 2, 'Modersmål/tolkspråk');
INSERT INTO `lang_definitions` VALUES (1637, 3702, 2, 'Modersmål/tolkspråk');
INSERT INTO `lang_definitions` VALUES (1638, 3703, 2, 'Modersmål/tolkspråk Lista');
INSERT INTO `lang_definitions` VALUES (1639, 3706, 2, 'ETIN');
INSERT INTO `lang_definitions` VALUES (1640, 3709, 2, 'Händelse');
INSERT INTO `lang_definitions` VALUES (1641, 3710, 2, 'Händelse Begins');
INSERT INTO `lang_definitions` VALUES (1642, 3711, 2, 'Händelse Kategori');
INSERT INTO `lang_definitions` VALUES (1643, 3712, 2, 'Händelse Datum');
INSERT INTO `lang_definitions` VALUES (1644, 3714, 2, 'Händelse, Beskrivning');
INSERT INTO `lang_definitions` VALUES (1645, 3715, 2, 'Händelse, detaljer');
INSERT INTO `lang_definitions` VALUES (1646, 3716, 2, 'Händelsen upprepas ej');
INSERT INTO `lang_definitions` VALUES (1647, 3717, 2, 'Händelse, Varaktighet');
INSERT INTO `lang_definitions` VALUES (1648, 3718, 2, 'Händelsens tid i minuter');
INSERT INTO `lang_definitions` VALUES (1649, 3719, 2, 'Händelse, Avgift');
INSERT INTO `lang_definitions` VALUES (1650, 3720, 2, 'Event Location');
INSERT INTO `lang_definitions` VALUES (1651, 3721, 2, 'Händelsen upprepas varje');
INSERT INTO `lang_definitions` VALUES (1652, 3722, 2, 'Händelsen upprepas den');
INSERT INTO `lang_definitions` VALUES (1653, 3723, 2, 'Händelse börjar timme');
INSERT INTO `lang_definitions` VALUES (1654, 3724, 2, 'Händelserubrik');
INSERT INTO `lang_definitions` VALUES (1655, 3725, 2, 'Händelserubrik');
INSERT INTO `lang_definitions` VALUES (1656, 3726, 2, 'Händelse Website');
INSERT INTO `lang_definitions` VALUES (1657, 3727, 2, 'Händelse');
INSERT INTO `lang_definitions` VALUES (1658, 3728, 2, 'Händelser för');
INSERT INTO `lang_definitions` VALUES (1659, 3729, 2, 'Händelsen öppnas i nytt fönster');
INSERT INTO `lang_definitions` VALUES (1660, 3731, 2, 'Varje');
INSERT INTO `lang_definitions` VALUES (1661, 3732, 2, 'Varje');
INSERT INTO `lang_definitions` VALUES (1662, 3734, 2, 'var 3:e timme');
INSERT INTO `lang_definitions` VALUES (1663, 3736, 2, 'var 4:e timme');
INSERT INTO `lang_definitions` VALUES (1664, 3738, 2, 'var 5:e timme');
INSERT INTO `lang_definitions` VALUES (1665, 3740, 2, 'var 6 timme');
INSERT INTO `lang_definitions` VALUES (1666, 3742, 2, 'var 8 timme');
INSERT INTO `lang_definitions` VALUES (1667, 3743, 2, 'Var fjärde');
INSERT INTO `lang_definitions` VALUES (1668, 3745, 2, 'Varannan');
INSERT INTO `lang_definitions` VALUES (1669, 3746, 2, 'Var tredje');
INSERT INTO `lang_definitions` VALUES (1670, 3747, 2, 'Varje, var andra, var 3:e, etc');
INSERT INTO `lang_definitions` VALUES (1671, 3749, 2, 'Tenta och testresultat');
INSERT INTO `lang_definitions` VALUES (1672, 3750, 2, 'Testresultat');
INSERT INTO `lang_definitions` VALUES (1673, 3754, 2, 'Examination Datum');
INSERT INTO `lang_definitions` VALUES (1674, 3760, 2, 'Exams / Tester');
INSERT INTO `lang_definitions` VALUES (1675, 3763, 2, 'Överdrivet rivande');
INSERT INTO `lang_definitions` VALUES (1676, 3772, 2, 'Motions mönster');
INSERT INTO `lang_definitions` VALUES (1677, 3773, 2, 'Övningsmönster');
INSERT INTO `lang_definitions` VALUES (1678, 3778, 2, 'lämna från Administration');
INSERT INTO `lang_definitions` VALUES (1679, 3792, 2, 'Utökad vy');
INSERT INTO `lang_definitions` VALUES (1680, 3793, 2, 'Förväntad form_mötes.pid att');
INSERT INTO `lang_definitions` VALUES (1681, 3794, 2, 'Utgångsdatum');
INSERT INTO `lang_definitions` VALUES (1682, 3795, 2, 'Utgångsdatum');
INSERT INTO `lang_definitions` VALUES (1683, 3797, 2, 'Förfaller');
INSERT INTO `lang_definitions` VALUES (1684, 3799, 2, 'Exportera');
INSERT INTO `lang_definitions` VALUES (1685, 3800, 2, 'Exportera som CSV');
INSERT INTO `lang_definitions` VALUES (1686, 3812, 2, 'Exportera till CSV');
INSERT INTO `lang_definitions` VALUES (1687, 3813, 2, 'Exportera till externa faktureringssystem');
INSERT INTO `lang_definitions` VALUES (1688, 3815, 2, 'Exponering för andra länder');
INSERT INTO `lang_definitions` VALUES (1689, 3834, 2, 'Extern remiss');
INSERT INTO `lang_definitions` VALUES (1690, 3836, 2, 'Extern remiss?');
INSERT INTO `lang_definitions` VALUES (1691, 3837, 2, 'Externa remisser');
INSERT INTO `lang_definitions` VALUES (1692, 3865, 2, 'F');
INSERT INTO `lang_definitions` VALUES (1693, 3868, 2, 'Kliniker');
INSERT INTO `lang_definitions` VALUES (1694, 3869, 2, 'Klinik');
INSERT INTO `lang_definitions` VALUES (1695, 3870, 2, 'klinik');
INSERT INTO `lang_definitions` VALUES (1696, 3871, 2, 'Klinikadm');
INSERT INTO `lang_definitions` VALUES (1697, 3873, 2, 'Klinikkod');
INSERT INTO `lang_definitions` VALUES (1698, 3879, 2, 'Klinik NPI');
INSERT INTO `lang_definitions` VALUES (1699, 3888, 2, 'Klinik:');
INSERT INTO `lang_definitions` VALUES (1700, 3890, 2, 'Misslyckades');
INSERT INTO `lang_definitions` VALUES (1701, 3916, 2, 'Familjehistoria');
INSERT INTO `lang_definitions` VALUES (1702, 3919, 2, 'Familjehistoria:');
INSERT INTO `lang_definitions` VALUES (1703, 3922, 2, 'Familj Storlek');
INSERT INTO `lang_definitions` VALUES (1704, 3928, 2, 'Fader');
INSERT INTO `lang_definitions` VALUES (1705, 3931, 2, 'Fatigue');
INSERT INTO `lang_definitions` VALUES (1706, 3933, 2, 'Fax');
INSERT INTO `lang_definitions` VALUES (1707, 3938, 2, 'Fax in');
INSERT INTO `lang_definitions` VALUES (1708, 3939, 2, 'Fax ut');
INSERT INTO `lang_definitions` VALUES (1709, 3942, 2, 'Februari');
INSERT INTO `lang_definitions` VALUES (1710, 3944, 2, 'Läkemedel ID');
INSERT INTO `lang_definitions` VALUES (1711, 3946, 2, 'Skatt ID');
INSERT INTO `lang_definitions` VALUES (1712, 3948, 2, 'Avgift');
INSERT INTO `lang_definitions` VALUES (1713, 3949, 2, 'avgift');
INSERT INTO `lang_definitions` VALUES (1714, 3951, 2, 'Avgift blankett');
INSERT INTO `lang_definitions` VALUES (1715, 3955, 2, 'Avgifter');
INSERT INTO `lang_definitions` VALUES (1716, 3956, 2, 'Kvinna');
INSERT INTO `lang_definitions` VALUES (1717, 3958, 2, 'Kvinnliga Kondomer');
INSERT INTO `lang_definitions` VALUES (1718, 3963, 2, 'Kvinna VSC');
INSERT INTO `lang_definitions` VALUES (1719, 3966, 2, 'Feber');
INSERT INTO `lang_definitions` VALUES (1720, 3967, 2, 'Feber:');
INSERT INTO `lang_definitions` VALUES (1721, 4004, 2, 'Filnamn');
INSERT INTO `lang_definitions` VALUES (1722, 4014, 2, 'Fyll här endast om du skickar e-postmeddelande till patienter');
INSERT INTO `lang_definitions` VALUES (1723, 4032, 2, 'Filter');
INSERT INTO `lang_definitions` VALUES (1724, 4035, 2, 'Slutgiltig diagnos');
INSERT INTO `lang_definitions` VALUES (1725, 4036, 2, 'Slutgiltig diagnos av specialist');
INSERT INTO `lang_definitions` VALUES (1726, 4038, 2, 'Finansiella');
INSERT INTO `lang_definitions` VALUES (1727, 4045, 2, 'Financial Review Datum');
INSERT INTO `lang_definitions` VALUES (1728, 4048, 2, 'Hitta');
INSERT INTO `lang_definitions` VALUES (1729, 4049, 2, 'Hitta Ledig');
INSERT INTO `lang_definitions` VALUES (1730, 4050, 2, 'Sök Ledig mötestider');
INSERT INTO `lang_definitions` VALUES (1731, 4053, 2, 'Hitta Patientient');
INSERT INTO `lang_definitions` VALUES (1732, 4056, 2, 'Undersökningsresultat');
INSERT INTO `lang_definitions` VALUES (1733, 4057, 2, 'Undersökningsresultat av specialist');
INSERT INTO `lang_definitions` VALUES (1734, 4058, 2, 'Fin');
INSERT INTO `lang_definitions` VALUES (1735, 4065, 2, 'Första');
INSERT INTO `lang_definitions` VALUES (1736, 4068, 2, 'Första dagen i veckan');
INSERT INTO `lang_definitions` VALUES (1737, 4071, 2, 'Förnamn');
INSERT INTO `lang_definitions` VALUES (1738, 4073, 2, 'Förnamn:');
INSERT INTO `lang_definitions` VALUES (1739, 4079, 2, 'Fitness');
INSERT INTO `lang_definitions` VALUES (1740, 4083, 2, 'Fitness att spela');
INSERT INTO `lang_definitions` VALUES (1741, 4110, 2, 'Influensavaccination');
INSERT INTO `lang_definitions` VALUES (1742, 4111, 2, 'Vätske-och elektrolyt problem');
INSERT INTO `lang_definitions` VALUES (1743, 4114, 2, 'Följa manuellt');
INSERT INTO `lang_definitions` VALUES (1744, 4130, 2, 'Fot');
INSERT INTO `lang_definitions` VALUES (1745, 4131, 2, 'Fotproblem');
INSERT INTO `lang_definitions` VALUES (1746, 4132, 2, 'Fot:');
INSERT INTO `lang_definitions` VALUES (1747, 4135, 2, 'Fotboll Skaderapport');
INSERT INTO `lang_definitions` VALUES (1748, 4136, 2, 'Skotyp');
INSERT INTO `lang_definitions` VALUES (1749, 4137, 2, 'för');
INSERT INTO `lang_definitions` VALUES (1750, 4189, 2, 'för:');
INSERT INTO `lang_definitions` VALUES (1751, 4194, 2, 'Underarm');
INSERT INTO `lang_definitions` VALUES (1752, 4195, 2, 'Formulär');
INSERT INTO `lang_definitions` VALUES (1753, 4201, 2, 'Format');
INSERT INTO `lang_definitions` VALUES (1754, 4204, 2, 'Format felaktigt för NDC');
INSERT INTO `lang_definitions` VALUES (1755, 4209, 2, 'Formulär');
INSERT INTO `lang_definitions` VALUES (1756, 4210, 2, 'Formulär administration');
INSERT INTO `lang_definitions` VALUES (1757, 4219, 2, 'Vidarebefordra Sidor via Fax');
INSERT INTO `lang_definitions` VALUES (1758, 4225, 2, 'Fjärde');
INSERT INTO `lang_definitions` VALUES (1759, 4227, 2, 'Fraktur');
INSERT INTO `lang_definitions` VALUES (1760, 4228, 2, 'Fracture på Navicula');
INSERT INTO `lang_definitions` VALUES (1761, 4229, 2, 'Fracture laterala malleolus');
INSERT INTO `lang_definitions` VALUES (1762, 4230, 2, 'Fracture mediala malleolus');
INSERT INTO `lang_definitions` VALUES (1763, 4241, 2, 'Fre');
INSERT INTO `lang_definitions` VALUES (1764, 4242, 2, 'Fredag');
INSERT INTO `lang_definitions` VALUES (1765, 4244, 2, 'Från');
INSERT INTO `lang_definitions` VALUES (1766, 4253, 2, 'Från:');
INSERT INTO `lang_definitions` VALUES (1767, 4254, 2, 'Från:');
INSERT INTO `lang_definitions` VALUES (1768, 4267, 2, 'Reception');
INSERT INTO `lang_definitions` VALUES (1769, 4268, 2, 'Reception, kvitton');
INSERT INTO `lang_definitions` VALUES (1770, 4269, 2, 'Reception, kvitton, rapport');
INSERT INTO `lang_definitions` VALUES (1771, 4271, 2, 'Frontal Höger:');
INSERT INTO `lang_definitions` VALUES (1772, 4286, 2, 'All utbildning');
INSERT INTO `lang_definitions` VALUES (1773, 4303, 2, 'Gallsten');
INSERT INTO `lang_definitions` VALUES (1774, 4304, 2, 'Game Period');
INSERT INTO `lang_definitions` VALUES (1775, 4305, 2, 'Spel');
INSERT INTO `lang_definitions` VALUES (1776, 4307, 2, 'spel / evenemang');
INSERT INTO `lang_definitions` VALUES (1777, 4310, 2, 'Gastrit');
INSERT INTO `lang_definitions` VALUES (1778, 4312, 2, 'Gastrointestinala');
INSERT INTO `lang_definitions` VALUES (1779, 4316, 2, 'GCAC Statistik Rapport');
INSERT INTO `lang_definitions` VALUES (1780, 4320, 2, 'Kön');
INSERT INTO `lang_definitions` VALUES (1781, 4321, 2, 'Allmänt');
INSERT INTO `lang_definitions` VALUES (1782, 4325, 2, 'Allmänna Tjänstekategori');
INSERT INTO `lang_definitions` VALUES (1783, 4334, 2, 'Skapa och hämta HCFA 1500 papper fordringar');
INSERT INTO `lang_definitions` VALUES (1784, 4337, 2, 'Skapa och hämta X12 parti');
INSERT INTO `lang_definitions` VALUES (1785, 4349, 2, 'Generera Skrivelse angående');
INSERT INTO `lang_definitions` VALUES (1786, 4357, 2, 'Generera rapport');
INSERT INTO `lang_definitions` VALUES (1787, 4370, 2, 'Skapad på');
INSERT INTO `lang_definitions` VALUES (1788, 4372, 2, 'Genererar');
INSERT INTO `lang_definitions` VALUES (1789, 4392, 2, 'Glaukom');
INSERT INTO `lang_definitions` VALUES (1790, 4395, 2, 'Global');
INSERT INTO `lang_definitions` VALUES (1791, 4403, 2, 'Gå');
INSERT INTO `lang_definitions` VALUES (1792, 4404, 2, 'gå');
INSERT INTO `lang_definitions` VALUES (1793, 4429, 2, 'Grad:');
INSERT INTO `lang_definitions` VALUES (1794, 4431, 2, 'Totalsumma');
INSERT INTO `lang_definitions` VALUES (1795, 4432, 2, 'Totalsummor');
INSERT INTO `lang_definitions` VALUES (1796, 4442, 2, 'Grupp');
INSERT INTO `lang_definitions` VALUES (1797, 4463, 2, 'Gruppnummer');
INSERT INTO `lang_definitions` VALUES (1798, 4471, 2, 'Grupp:');
INSERT INTO `lang_definitions` VALUES (1799, 4472, 2, 'Gruppnamn');
INSERT INTO `lang_definitions` VALUES (1800, 4475, 2, 'Grupper och åtkomstkontroller');
INSERT INTO `lang_definitions` VALUES (1801, 4478, 2, 'Droppar');
INSERT INTO `lang_definitions` VALUES (1802, 4495, 2, 'Hematom / blåmärken');
INSERT INTO `lang_definitions` VALUES (1803, 4499, 2, 'Hand + fingrar');
INSERT INTO `lang_definitions` VALUES (1804, 4500, 2, 'Handproblem');
INSERT INTO `lang_definitions` VALUES (1805, 4506, 2, 'Umbäranden w / o');
INSERT INTO `lang_definitions` VALUES (1806, 4517, 2, 'Farliga aktiviteter');
INSERT INTO `lang_definitions` VALUES (1807, 4527, 2, 'han PostCalendar');
INSERT INTO `lang_definitions` VALUES (1808, 4528, 2, 'Huvud');
INSERT INTO `lang_definitions` VALUES (1809, 4532, 2, 'Huvudvärk');
INSERT INTO `lang_definitions` VALUES (1810, 4543, 2, 'Heart Attack');
INSERT INTO `lang_definitions` VALUES (1811, 4545, 2, 'Hjärtsvikt');
INSERT INTO `lang_definitions` VALUES (1812, 4547, 2, 'Hjärtproblem');
INSERT INTO `lang_definitions` VALUES (1813, 4548, 2, 'Hjärtkirurgi');
INSERT INTO `lang_definitions` VALUES (1814, 4549, 2, 'Heart Transplant');
INSERT INTO `lang_definitions` VALUES (1815, 4550, 2, 'Heart:');
INSERT INTO `lang_definitions` VALUES (1816, 4558, 2, 'Längd');
INSERT INTO `lang_definitions` VALUES (1817, 4560, 2, 'Hjälp');
INSERT INTO `lang_definitions` VALUES (1818, 4561, 2, 'hjälp');
INSERT INTO `lang_definitions` VALUES (1819, 4567, 2, 'Hemoglobin');
INSERT INTO `lang_definitions` VALUES (1820, 4570, 2, 'Hepatit');
INSERT INTO `lang_definitions` VALUES (1821, 4580, 2, 'Bråck Reparation');
INSERT INTO `lang_definitions` VALUES (1822, 4581, 2, 'Diskbråck');
INSERT INTO `lang_definitions` VALUES (1823, 4582, 2, 'Herpes');
INSERT INTO `lang_definitions` VALUES (1824, 4586, 2, 'heyyo. du har varit här i');
INSERT INTO `lang_definitions` VALUES (1825, 4591, 2, 'Dolda');
INSERT INTO `lang_definitions` VALUES (1826, 4592, 2, 'Dolda Händelser Administration');
INSERT INTO `lang_definitions` VALUES (1827, 4593, 2, 'Gömma');
INSERT INTO `lang_definitions` VALUES (1828, 4595, 2, 'Dölj detaljer');
INSERT INTO `lang_definitions` VALUES (1829, 4599, 2, 'Göm meny');
INSERT INTO `lang_definitions` VALUES (1830, 4601, 2, 'Göm påminnelser');
INSERT INTO `lang_definitions` VALUES (1831, 4603, 2, 'Göm/Visa kolumner');
INSERT INTO `lang_definitions` VALUES (1832, 4605, 2, 'Hög');
INSERT INTO `lang_definitions` VALUES (1833, 4607, 2, 'Högt blodtryck');
INSERT INTO `lang_definitions` VALUES (1834, 4610, 2, 'Höft + ljumske');
INSERT INTO `lang_definitions` VALUES (1835, 4611, 2, 'Höft och ljumske');
INSERT INTO `lang_definitions` VALUES (1836, 4612, 2, 'Hip Problem');
INSERT INTO `lang_definitions` VALUES (1837, 4613, 2, 'Höftledsplastik');
INSERT INTO `lang_definitions` VALUES (1838, 4615, 2, 'Ej Tilldelad');
INSERT INTO `lang_definitions` VALUES (1839, 4618, 2, 'Spansktalande');
INSERT INTO `lang_definitions` VALUES (1840, 4623, 2, 'Historia');
INSERT INTO `lang_definitions` VALUES (1841, 4629, 2, 'Historikdata');
INSERT INTO `lang_definitions` VALUES (1842, 4653, 2, 'Håll ner [Ctrl] för flera val eller avmarkera');
INSERT INTO `lang_definitions` VALUES (1843, 4655, 2, 'Håll ned Ctrl för att välja flera objekt');
INSERT INTO `lang_definitions` VALUES (1844, 4656, 2, 'Håll ned Ctrl för att välja flera patruller');
INSERT INTO `lang_definitions` VALUES (1845, 4658, 2, 'Hem');
INSERT INTO `lang_definitions` VALUES (1846, 4659, 2, 'Hemtelefon');
INSERT INTO `lang_definitions` VALUES (1847, 4662, 2, 'Hemlös eller liknande?');
INSERT INTO `lang_definitions` VALUES (1848, 4664, 2, 'Hemlös');
INSERT INTO `lang_definitions` VALUES (1849, 4665, 2, 'Hemlös');
INSERT INTO `lang_definitions` VALUES (1850, 4678, 2, 'Timmar');
INSERT INTO `lang_definitions` VALUES (1851, 4681, 2, 'Hur uppstod skadan?');
INSERT INTO `lang_definitions` VALUES (1852, 4682, 2, 'Hur uppstod skadan?:');
INSERT INTO `lang_definitions` VALUES (1853, 4685, 2, 'Hur många månader att fråga efter kommande evenemang?');
INSERT INTO `lang_definitions` VALUES (1854, 4706, 2, 'Hyperaktiv');
INSERT INTO `lang_definitions` VALUES (1855, 4711, 2, 'Hyperthyroidism');
INSERT INTO `lang_definitions` VALUES (1856, 4713, 2, 'Hypotyreoidism');
INSERT INTO `lang_definitions` VALUES (1857, 4716, 2, 'Hysterektomi');
INSERT INTO `lang_definitions` VALUES (1858, 4718, 2, 'Jag är upptagen under denna tid.');
INSERT INTO `lang_definitions` VALUES (1859, 4719, 2, 'Jag har inte behörighet att läsa');
INSERT INTO `lang_definitions` VALUES (1860, 4745, 2, 'Identifierare (ett ord)');
INSERT INTO `lang_definitions` VALUES (1861, 4755, 2, 'Om alla uppgifter för alla kolumner är komplett för denna form');
INSERT INTO `lang_definitions` VALUES (1862, 4765, 2, 'Om namn, någon del av efternamn eller efternamn, förnamn');
INSERT INTO `lang_definitions` VALUES (1863, 4771, 2, 'Om personen avlidit ange dödsdatum');
INSERT INTO `lang_definitions` VALUES (1864, 4803, 2, 'om arbetslösa lägg till student');
INSERT INTO `lang_definitions` VALUES (1865, 4850, 2, 'Om du vill ändra datatyper, lägg till rader eller kolumner');
INSERT INTO `lang_definitions` VALUES (1866, 4856, 2, 'Sjukdom');
INSERT INTO `lang_definitions` VALUES (1867, 4865, 2, 'Vaccinering');
INSERT INTO `lang_definitions` VALUES (1868, 4872, 2, 'Vaccin, Lotnummer');
INSERT INTO `lang_definitions` VALUES (1869, 4873, 2, 'Vaccin, tillverkare');
INSERT INTO `lang_definitions` VALUES (1870, 4885, 2, 'Vaccineringar');
INSERT INTO `lang_definitions` VALUES (1871, 4887, 2, 'Vaccinera');
INSERT INTO `lang_definitions` VALUES (1872, 4893, 2, 'Implantat');
INSERT INTO `lang_definitions` VALUES (1873, 4894, 2, 'Importera');
INSERT INTO `lang_definitions` VALUES (1874, 4904, 2, 'Importera patient');
INSERT INTO `lang_definitions` VALUES (1875, 4905, 2, 'Importera Patientdemografi');
INSERT INTO `lang_definitions` VALUES (1876, 4914, 2, 'Importerad från Accounting');
INSERT INTO `lang_definitions` VALUES (1877, 4920, 2, 'förbättrad');
INSERT INTO `lang_definitions` VALUES (1878, 4922, 2, 'i');
INSERT INTO `lang_definitions` VALUES (1879, 4931, 2, 'i båda ögonen');
INSERT INTO `lang_definitions` VALUES (1880, 4934, 2, 'i vänster öga');
INSERT INTO `lang_definitions` VALUES (1881, 4935, 2, 'i näsborre');
INSERT INTO `lang_definitions` VALUES (1882, 4936, 2, 'Arbetar');
INSERT INTO `lang_definitions` VALUES (1883, 4947, 2, 'i höger öga');
INSERT INTO `lang_definitions` VALUES (1884, 4965, 2, 'Inaktiv Dagar');
INSERT INTO `lang_definitions` VALUES (1885, 4977, 2, 'Inkludera mätväden');
INSERT INTO `lang_definitions` VALUES (1886, 4982, 2, 'Inkomst');
INSERT INTO `lang_definitions` VALUES (1887, 4990, 2, 'ökat:');
INSERT INTO `lang_definitions` VALUES (1888, 4991, 2, 'Ansvarsförsäkring');
INSERT INTO `lang_definitions` VALUES (1889, 4994, 2, 'Obestämd');
INSERT INTO `lang_definitions` VALUES (1890, 5000, 2, 'Indikerar om detta problem/frågeställning är aktiv');
INSERT INTO `lang_definitions` VALUES (1891, 5004, 2, 'Hjälpbehövande Patienter Rapport');
INSERT INTO `lang_definitions` VALUES (1892, 5013, 2, 'Infektion / Abscess');
INSERT INTO `lang_definitions` VALUES (1893, 5014, 2, 'Infektioner');
INSERT INTO `lang_definitions` VALUES (1894, 5015, 2, 'Infert Couns');
INSERT INTO `lang_definitions` VALUES (1895, 5022, 2, 'Info');
INSERT INTO `lang_definitions` VALUES (1896, 5023, 2, 'Info test 1');
INSERT INTO `lang_definitions` VALUES (1897, 5024, 2, 'Info test 2');
INSERT INTO `lang_definitions` VALUES (1898, 5025, 2, 'Info test 3');
INSERT INTO `lang_definitions` VALUES (1899, 5026, 2, 'Info test 4');
INSERT INTO `lang_definitions` VALUES (1900, 5027, 2, 'Info test 5');
INSERT INTO `lang_definitions` VALUES (1901, 5028, 2, 'Info test 6');
INSERT INTO `lang_definitions` VALUES (1902, 5034, 2, 'inhalation');
INSERT INTO `lang_definitions` VALUES (1903, 5036, 2, 'inhalationer');
INSERT INTO `lang_definitions` VALUES (1904, 5039, 2, 'Ursprunglig användare');
INSERT INTO `lang_definitions` VALUES (1905, 5042, 2, 'Injeserbara');
INSERT INTO `lang_definitions` VALUES (1906, 5045, 2, 'Skadade ut');
INSERT INTO `lang_definitions` VALUES (1907, 5047, 2, 'Skademekanism');
INSERT INTO `lang_definitions` VALUES (1908, 5048, 2, 'Skada, översiktsrapport');
INSERT INTO `lang_definitions` VALUES (1909, 5050, 2, 'Skada Typ');
INSERT INTO `lang_definitions` VALUES (1910, 5056, 2, 'Inmatningsfält');
INSERT INTO `lang_definitions` VALUES (1911, 5061, 2, 'Ins justera');
INSERT INTO `lang_definitions` VALUES (1912, 5062, 2, 'Ins paketering');
INSERT INTO `lang_definitions` VALUES (1913, 5066, 2, 'Ins överskjutande');
INSERT INTO `lang_definitions` VALUES (1914, 5068, 2, 'Ins återbetalning');
INSERT INTO `lang_definitions` VALUES (1915, 5069, 2, 'Ins Sammering');
INSERT INTO `lang_definitions` VALUES (1916, 5071, 2, 'Ins1');
INSERT INTO `lang_definitions` VALUES (1917, 5072, 2, 'Ins2');
INSERT INTO `lang_definitions` VALUES (1918, 5073, 2, 'Ins3');
INSERT INTO `lang_definitions` VALUES (1919, 5075, 2, 'isättning misslyckades:');
INSERT INTO `lang_definitions` VALUES (1920, 5079, 2, 'Sätt gamla händelser i tabeller');
INSERT INTO `lang_definitions` VALUES (1921, 5085, 2, 'Insomnia');
INSERT INTO `lang_definitions` VALUES (1922, 5087, 2, 'Inspektion');
INSERT INTO `lang_definitions` VALUES (1923, 5088, 2, 'Instabilitet / subluxation');
INSERT INTO `lang_definitions` VALUES (1924, 5093, 2, 'installera DB');
INSERT INTO `lang_definitions` VALUES (1925, 5102, 2, 'Instruerad');
INSERT INTO `lang_definitions` VALUES (1926, 5105, 2, 'Instruktioner:');
INSERT INTO `lang_definitions` VALUES (1927, 5108, 2, 'Insulinberoende diabetiker');
INSERT INTO `lang_definitions` VALUES (1928, 5109, 2, 'Försäkring');
INSERT INTO `lang_definitions` VALUES (1929, 5110, 2, 'försäkring');
INSERT INTO `lang_definitions` VALUES (1930, 5117, 2, 'Försäkringsbolag');
INSERT INTO `lang_definitions` VALUES (1931, 5118, 2, 'Försäkringsbolag');
INSERT INTO `lang_definitions` VALUES (1932, 5119, 2, 'Försäkringsbolag Sök / Köp');
INSERT INTO `lang_definitions` VALUES (1933, 5121, 2, 'Försäkring Data');
INSERT INTO `lang_definitions` VALUES (1934, 5126, 2, 'Försäkring Number');
INSERT INTO `lang_definitions` VALUES (1935, 5129, 2, 'Försäkringsbolag');
INSERT INTO `lang_definitions` VALUES (1936, 5149, 2, 'Internt fel - inga sidor valdes!');
INSERT INTO `lang_definitions` VALUES (1937, 5150, 2, 'Internt fel - patient-ID fanns inte!');
INSERT INTO `lang_definitions` VALUES (1938, 5153, 2, 'Internt fel!');
INSERT INTO `lang_definitions` VALUES (1939, 5156, 2, 'Internt fel: påstående');
INSERT INTO `lang_definitions` VALUES (1940, 5157, 2, 'Internt fel: möter\"');
INSERT INTO `lang_definitions` VALUES (1941, 5163, 2, 'Inre Övergångar');
INSERT INTO `lang_definitions` VALUES (1942, 5167, 2, 'Tolk');
INSERT INTO `lang_definitions` VALUES (1943, 5169, 2, 'Interstitiell lungsjukdom');
INSERT INTO `lang_definitions` VALUES (1944, 5170, 2, 'Interval');
INSERT INTO `lang_definitions` VALUES (1945, 5175, 2, 'Intolerans');
INSERT INTO `lang_definitions` VALUES (1946, 5178, 2, 'intramuskulärt');
INSERT INTO `lang_definitions` VALUES (1947, 5181, 2, 'intravenöst');
INSERT INTO `lang_definitions` VALUES (1948, 5182, 2, 'Introduktion');
INSERT INTO `lang_definitions` VALUES (1949, 5197, 2, 'Ogiltig eller saknas betalaren i källan för kod');
INSERT INTO `lang_definitions` VALUES (1950, 5200, 2, 'Ogiltig Service Kod');
INSERT INTO `lang_definitions` VALUES (1951, 5201, 2, 'Ogiltig källdestination\"');
INSERT INTO `lang_definitions` VALUES (1952, 5205, 2, 'Inventering');
INSERT INTO `lang_definitions` VALUES (1953, 5209, 2, 'Inventering är inte tillgänglig för denna beställning.');
INSERT INTO `lang_definitions` VALUES (1954, 5210, 2, 'Inventeringslista');
INSERT INTO `lang_definitions` VALUES (1955, 5212, 2, 'Faktura');
INSERT INTO `lang_definitions` VALUES (1956, 5213, 2, 'faktura');
INSERT INTO `lang_definitions` VALUES (1957, 5217, 2, 'Fakturadatum');
INSERT INTO `lang_definitions` VALUES (1958, 5219, 2, 'Fakturanhar inget datum!');
INSERT INTO `lang_definitions` VALUES (1959, 5226, 2, 'Faktura:');
INSERT INTO `lang_definitions` VALUES (1960, 5249, 2, 'Oregelbunden hjärtrytm');
INSERT INTO `lang_definitions` VALUES (1961, 5250, 2, 'Retlighet');
INSERT INTO `lang_definitions` VALUES (1962, 5251, 2, 'Irritation');
INSERT INTO `lang_definitions` VALUES (1963, 5256, 2, 'är ett obligatoriskt fält.');
INSERT INTO `lang_definitions` VALUES (1964, 5268, 2, 'inte är giltig (decimalbråk är OK).');
INSERT INTO `lang_definitions` VALUES (1965, 5269, 2, 'Är PHP använder felsäkert läge?');
INSERT INTO `lang_definitions` VALUES (1966, 5290, 2, 'Frågeställning');
INSERT INTO `lang_definitions` VALUES (1967, 5291, 2, 'frågeställning');
INSERT INTO `lang_definitions` VALUES (1968, 5298, 2, 'Aktuellt');
INSERT INTO `lang_definitions` VALUES (1969, 5300, 2, 'Aktuellt (Problem / Medicin / Allergi):');
INSERT INTO `lang_definitions` VALUES (1970, 5302, 2, 'Information och Patientmöten');
INSERT INTO `lang_definitions` VALUES (1971, 5303, 2, 'Information och möten för');
INSERT INTO `lang_definitions` VALUES (1972, 5308, 2, 'Problematik, ej behörig');
INSERT INTO `lang_definitions` VALUES (1973, 5309, 2, 'Frågeställningssektion');
INSERT INTO `lang_definitions` VALUES (1974, 5365, 2, 'Artikel');
INSERT INTO `lang_definitions` VALUES (1975, 5366, 2, 'artikel');
INSERT INTO `lang_definitions` VALUES (1976, 5369, 2, 'Poster laddades inte');
INSERT INTO `lang_definitions` VALUES (1977, 5376, 2, 'Januari');
INSERT INTO `lang_definitions` VALUES (1978, 5380, 2, 'Jobb-beskrivning');
INSERT INTO `lang_definitions` VALUES (1979, 5381, 2, 'Jobb id');
INSERT INTO `lang_definitions` VALUES (1980, 5382, 2, 'Led dislokation');
INSERT INTO `lang_definitions` VALUES (1981, 5383, 2, 'Led smärta');
INSERT INTO `lang_definitions` VALUES (1982, 5384, 2, 'Led vrickning');
INSERT INTO `lang_definitions` VALUES (1983, 5386, 2, 'Juli');
INSERT INTO `lang_definitions` VALUES (1984, 5389, 2, 'Juni');
INSERT INTO `lang_definitions` VALUES (1985, 5391, 2, 'Bara min');
INSERT INTO `lang_definitions` VALUES (1986, 5393, 2, 'Motivera');
INSERT INTO `lang_definitions` VALUES (1987, 5396, 2, 'Motivera / Spara');
INSERT INTO `lang_definitions` VALUES (1988, 5398, 2, 'k, här är resten');
INSERT INTO `lang_definitions` VALUES (1989, 5411, 2, 'Nyckelord');
INSERT INTO `lang_definitions` VALUES (1990, 5415, 2, 'Njurcancer');
INSERT INTO `lang_definitions` VALUES (1991, 5416, 2, 'Njursvikt');
INSERT INTO `lang_definitions` VALUES (1992, 5417, 2, 'Njure Infektioner');
INSERT INTO `lang_definitions` VALUES (1993, 5418, 2, 'Njursten');
INSERT INTO `lang_definitions` VALUES (1994, 5419, 2, 'Njurtransplantation');
INSERT INTO `lang_definitions` VALUES (1995, 5425, 2, 'Knä');
INSERT INTO `lang_definitions` VALUES (1996, 5426, 2, 'Knä Problem');
INSERT INTO `lang_definitions` VALUES (1997, 5427, 2, 'Knä Ersättning /protes');
INSERT INTO `lang_definitions` VALUES (1998, 5434, 2, 'Lab');
INSERT INTO `lang_definitions` VALUES (1999, 5444, 2, 'Lab Rapport');
INSERT INTO `lang_definitions` VALUES (2000, 5453, 2, 'Etikett');
INSERT INTO `lang_definitions` VALUES (2001, 5455, 2, 'Label Cols');
INSERT INTO `lang_definitions` VALUES (2002, 5459, 2, 'Etiketter');
INSERT INTO `lang_definitions` VALUES (2003, 5463, 2, 'Labs');
INSERT INTO `lang_definitions` VALUES (2004, 5464, 2, 'Laceration / hudkodition');
INSERT INTO `lang_definitions` VALUES (2005, 5465, 2, 'Laceration / nötning');
INSERT INTO `lang_definitions` VALUES (2006, 5471, 2, 'Språk');
INSERT INTO `lang_definitions` VALUES (2007, 5472, 2, 'Språk-kod');
INSERT INTO `lang_definitions` VALUES (2008, 5473, 2, 'Språk definition tillagd');
INSERT INTO `lang_definitions` VALUES (2009, 5478, 2, 'Språknamn');
INSERT INTO `lang_definitions` VALUES (2010, 5479, 2, 'Språk:');
INSERT INTO `lang_definitions` VALUES (2011, 5485, 2, 'Sist');
INSERT INTO `lang_definitions` VALUES (2012, 5486, 2, 'Datum för senaste aktivitet');
INSERT INTO `lang_definitions` VALUES (2013, 5489, 2, 'Sista betalnings dag på faktura:');
INSERT INTO `lang_definitions` VALUES (2014, 5495, 2, 'Senaste patientmötet');
INSERT INTO `lang_definitions` VALUES (2015, 5507, 2, 'Efternamn');
INSERT INTO `lang_definitions` VALUES (2016, 5508, 2, 'Efternamn');
INSERT INTO `lang_definitions` VALUES (2017, 5513, 2, 'Efternamn:');
INSERT INTO `lang_definitions` VALUES (2018, 5519, 2, 'Senast sparad');
INSERT INTO `lang_definitions` VALUES (2019, 5525, 2, 'Senast uppdaterad av');
INSERT INTO `lang_definitions` VALUES (2020, 5527, 2, 'Senaste besöket');
INSERT INTO `lang_definitions` VALUES (2021, 5530, 2, 'Sen Återkommande (2-12 mån)');
INSERT INTO `lang_definitions` VALUES (2022, 5535, 2, 'sidled fördrivna PMI:');
INSERT INTO `lang_definitions` VALUES (2023, 5551, 2, 'Layout Editor');
INSERT INTO `lang_definitions` VALUES (2024, 5559, 2, 'Layouter');
INSERT INTO `lang_definitions` VALUES (2025, 5571, 2, 'LDL');
INSERT INTO `lang_definitions` VALUES (2026, 5573, 2, 'lämna tom om fortfarande aktiv');
INSERT INTO `lang_definitions` VALUES (2027, 5575, 2, 'Lämna tomt för att hålla lösenord oförändrad.');
INSERT INTO `lang_definitions` VALUES (2028, 5580, 2, 'Kontakt via');
INSERT INTO `lang_definitions` VALUES (2029, 5582, 2, 'Lämna Form');
INSERT INTO `lang_definitions` VALUES (2030, 5586, 2, 'Vänster');
INSERT INTO `lang_definitions` VALUES (2031, 5589, 2, 'vänster öra');
INSERT INTO `lang_definitions` VALUES (2032, 5590, 2, 'vänster öra');
INSERT INTO `lang_definitions` VALUES (2033, 5599, 2, 'Vänster:');
INSERT INTO `lang_definitions` VALUES (2034, 5600, 2, 'Vänster:');
INSERT INTO `lang_definitions` VALUES (2035, 5601, 2, 'Ben smärta / Kramper');
INSERT INTO `lang_definitions` VALUES (2036, 5602, 2, 'Rättsärenden');
INSERT INTO `lang_definitions` VALUES (2037, 5605, 2, 'Förklaring:');
INSERT INTO `lang_definitions` VALUES (2038, 5606, 2, 'Längd');
INSERT INTO `lang_definitions` VALUES (2039, 5620, 2, 'Brev');
INSERT INTO `lang_definitions` VALUES (2040, 5621, 2, 'Brevgenerator');
INSERT INTO `lang_definitions` VALUES (2041, 5630, 2, 'Ansvar');
INSERT INTO `lang_definitions` VALUES (2042, 5631, 2, 'Ansvar för medicinskt');
INSERT INTO `lang_definitions` VALUES (2043, 5633, 2, 'passnr');
INSERT INTO `lang_definitions` VALUES (2044, 5644, 2, 'Livsstil');
INSERT INTO `lang_definitions` VALUES (2045, 5647, 2, 'Ligament skada eller vrickning');
INSERT INTO `lang_definitions` VALUES (2046, 5651, 2, 'Begränsning av händelser');
INSERT INTO `lang_definitions` VALUES (2047, 5665, 2, 'Förteckning');
INSERT INTO `lang_definitions` VALUES (2048, 5671, 2, 'List Editor');
INSERT INTO `lang_definitions` VALUES (2049, 5675, 2, 'Lista Insurance Companies');
INSERT INTO `lang_definitions` VALUES (2050, 5680, 2, 'Lista listor');
INSERT INTO `lang_definitions` VALUES (2051, 5682, 2, 'Lista Namn');
INSERT INTO `lang_definitions` VALUES (2052, 5688, 2, 'Lista recept');
INSERT INTO `lang_definitions` VALUES (2053, 5693, 2, 'Listor');
INSERT INTO `lang_definitions` VALUES (2054, 5709, 2, 'Ladda definitioner');
INSERT INTO `lang_definitions` VALUES (2055, 5717, 2, 'Laddar');
INSERT INTO `lang_definitions` VALUES (2056, 5724, 2, 'Lokalt');
INSERT INTO `lang_definitions` VALUES (2057, 5729, 2, 'Lokalitet');
INSERT INTO `lang_definitions` VALUES (2058, 5730, 2, 'Lokalisation');
INSERT INTO `lang_definitions` VALUES (2059, 5733, 2, 'Lokalisation ospecificerad');
INSERT INTO `lang_definitions` VALUES (2060, 5736, 2, 'Lokalisation');
INSERT INTO `lang_definitions` VALUES (2061, 5752, 2, 'Inloggad');
INSERT INTO `lang_definitions` VALUES (2062, 5753, 2, 'Inloggad som');
INSERT INTO `lang_definitions` VALUES (2063, 5754, 2, 'Inloggad som:');
INSERT INTO `lang_definitions` VALUES (2064, 5755, 2, 'Utloggad.');
INSERT INTO `lang_definitions` VALUES (2065, 5757, 2, 'Logga in');
INSERT INTO `lang_definitions` VALUES (2066, 5758, 2, 'logga in');
INSERT INTO `lang_definitions` VALUES (2067, 5768, 2, 'Logout');
INSERT INTO `lang_definitions` VALUES (2068, 5769, 2, 'logout');
INSERT INTO `lang_definitions` VALUES (2069, 5770, 2, 'Loggar');
INSERT INTO `lang_definitions` VALUES (2070, 5776, 2, 'Slå upp');
INSERT INTO `lang_definitions` VALUES (2071, 5777, 2, 'Batch');
INSERT INTO `lang_definitions` VALUES (2072, 5779, 2, 'Batchnummer');
INSERT INTO `lang_definitions` VALUES (2073, 5780, 2, 'låg');
INSERT INTO `lang_definitions` VALUES (2074, 5782, 2, 'Benet');
INSERT INTO `lang_definitions` VALUES (2075, 5791, 2, 'Lumbal delen av ryggraden');
INSERT INTO `lang_definitions` VALUES (2076, 5792, 2, 'LUNCH');
INSERT INTO `lang_definitions` VALUES (2077, 5793, 2, 'Lunch');
INSERT INTO `lang_definitions` VALUES (2078, 5794, 2, 'Lung Cancer');
INSERT INTO `lang_definitions` VALUES (2079, 5795, 2, 'Lung Cancer kirurgi');
INSERT INTO `lang_definitions` VALUES (2080, 5796, 2, 'Lungor:');
INSERT INTO `lang_definitions` VALUES (2081, 5797, 2, 'Lungor:');
INSERT INTO `lang_definitions` VALUES (2082, 5804, 2, 'M');
INSERT INTO `lang_definitions` VALUES (2083, 5805, 2, 'MA Kategori');
INSERT INTO `lang_definitions` VALUES (2084, 5815, 2, 'Huvudadress');
INSERT INTO `lang_definitions` VALUES (2085, 5827, 2, 'Gör ändringar i nuvarande kategorier.');
INSERT INTO `lang_definitions` VALUES (2086, 5831, 2, 'Försäkra \"');
INSERT INTO `lang_definitions` VALUES (2087, 5834, 2, 'Sjukdomskänsla:');
INSERT INTO `lang_definitions` VALUES (2088, 5837, 2, 'Man');
INSERT INTO `lang_definitions` VALUES (2089, 5838, 2, 'Manlig Kondomer');
INSERT INTO `lang_definitions` VALUES (2090, 5841, 2, 'Mammogram');
INSERT INTO `lang_definitions` VALUES (2091, 5851, 2, 'Administration');
INSERT INTO `lang_definitions` VALUES (2092, 5860, 2, 'Manuell post');
INSERT INTO `lang_definitions` VALUES (2093, 5864, 2, 'Tillverkare');
INSERT INTO `lang_definitions` VALUES (2094, 5874, 2, 'Mars');
INSERT INTO `lang_definitions` VALUES (2095, 5877, 2, 'Civilstånd');
INSERT INTO `lang_definitions` VALUES (2096, 5880, 2, 'Markera som faktureras men hoppa fakturering');
INSERT INTO `lang_definitions` VALUES (2097, 5881, 2, 'Markera som avklarad');
INSERT INTO `lang_definitions` VALUES (2098, 5882, 2, 'Markera som ej fakturerad');
INSERT INTO `lang_definitions` VALUES (2099, 5886, 2, 'Markerad som avslutad');
INSERT INTO `lang_definitions` VALUES (2100, 5887, 2, 'Gift');
INSERT INTO `lang_definitions` VALUES (2101, 5912, 2, 'Maxillary Höger:');
INSERT INTO `lang_definitions` VALUES (2102, 5924, 2, 'Maj');
INSERT INTO `lang_definitions` VALUES (2103, 5926, 2, 'MC');
INSERT INTO `lang_definitions` VALUES (2104, 5927, 2, 'mcg');
INSERT INTO `lang_definitions` VALUES (2105, 5942, 2, 'Medicinsk');
INSERT INTO `lang_definitions` VALUES (2106, 5952, 2, 'Medicinska problem');
INSERT INTO `lang_definitions` VALUES (2107, 5954, 2, 'Medicinska problem');
INSERT INTO `lang_definitions` VALUES (2108, 5956, 2, 'Journal');
INSERT INTO `lang_definitions` VALUES (2109, 5957, 2, 'Journal #');
INSERT INTO `lang_definitions` VALUES (2110, 5959, 2, 'Journaler');
INSERT INTO `lang_definitions` VALUES (2111, 5966, 2, 'Journal / Historia ( frivilligt att skriva )');
INSERT INTO `lang_definitions` VALUES (2112, 5970, 2, 'Medicin');
INSERT INTO `lang_definitions` VALUES (2113, 5975, 2, 'Läkemedel');
INSERT INTO `lang_definitions` VALUES (2114, 5978, 2, 'Läkemedel:');
INSERT INTO `lang_definitions` VALUES (2115, 5979, 2, 'Medicinska enheter');
INSERT INTO `lang_definitions` VALUES (2116, 5980, 2, 'Medium');
INSERT INTO `lang_definitions` VALUES (2117, 5984, 2, 'Ledamot Association Statistik Rapport');
INSERT INTO `lang_definitions` VALUES (2118, 5986, 2, 'Minnes Problem');
INSERT INTO `lang_definitions` VALUES (2119, 5987, 2, 'Män');
INSERT INTO `lang_definitions` VALUES (2120, 5988, 2, 'Män och kvinnor');
INSERT INTO `lang_definitions` VALUES (2121, 5989, 2, 'Män Endast');
INSERT INTO `lang_definitions` VALUES (2122, 5991, 2, 'Klimakteriet');
INSERT INTO `lang_definitions` VALUES (2123, 5994, 2, 'Psykisk sjukdom');
INSERT INTO `lang_definitions` VALUES (2124, 6005, 2, 'Meddelande');
INSERT INTO `lang_definitions` VALUES (2125, 6006, 2, 'Meddelanden och Påminnelser');
INSERT INTO `lang_definitions` VALUES (2126, 6018, 2, 'MEDELANDE:');
INSERT INTO `lang_definitions` VALUES (2127, 6019, 2, 'Meddelanden');
INSERT INTO `lang_definitions` VALUES (2128, 6026, 2, 'Metod');
INSERT INTO `lang_definitions` VALUES (2129, 6030, 2, 'Metod för förstöring');
INSERT INTO `lang_definitions` VALUES (2130, 6038, 2, 'mg');
INSERT INTO `lang_definitions` VALUES (2131, 6039, 2, 'mg/ml');
INSERT INTO `lang_definitions` VALUES (2132, 6040, 2, 'g');
INSERT INTO `lang_definitions` VALUES (2133, 6041, 2, 'g/ml');
INSERT INTO `lang_definitions` VALUES (2134, 6046, 2, 'Mellan');
INSERT INTO `lang_definitions` VALUES (2135, 6047, 2, 'Mellannamn');
INSERT INTO `lang_definitions` VALUES (2136, 6048, 2, 'Mellannamn');
INSERT INTO `lang_definitions` VALUES (2137, 6062, 2, 'Migrerande eller säsongsarbetare?');
INSERT INTO `lang_definitions` VALUES (2138, 6064, 2, 'Migrerande / Säsong');
INSERT INTO `lang_definitions` VALUES (2139, 6083, 2, 'Protokoll');
INSERT INTO `lang_definitions` VALUES (2140, 6084, 2, 'minuter');
INSERT INTO `lang_definitions` VALUES (2141, 6090, 2, 'Diverse');
INSERT INTO `lang_definitions` VALUES (2142, 6092, 2, 'Missade');
INSERT INTO `lang_definitions` VALUES (2143, 6111, 2, 'Blandat');
INSERT INTO `lang_definitions` VALUES (2144, 6113, 2, 'ml');
INSERT INTO `lang_definitions` VALUES (2145, 6120, 2, 'Mobil');
INSERT INTO `lang_definitions` VALUES (2146, 6121, 2, 'Mobiltelefon');
INSERT INTO `lang_definitions` VALUES (2147, 6153, 2, 'Mån');
INSERT INTO `lang_definitions` VALUES (2148, 6154, 2, 'Mån tills fredag');
INSERT INTO `lang_definitions` VALUES (2149, 6155, 2, 'Måndag, onsdag och fredag');
INSERT INTO `lang_definitions` VALUES (2150, 6156, 2, 'Måndag');
INSERT INTO `lang_definitions` VALUES (2151, 6160, 2, 'månad');
INSERT INTO `lang_definitions` VALUES (2152, 6161, 2, 'Månad');
INSERT INTO `lang_definitions` VALUES (2153, 6162, 2, 'Månadsvy');
INSERT INTO `lang_definitions` VALUES (2154, 6163, 2, 'Månad (er)');
INSERT INTO `lang_definitions` VALUES (2155, 6164, 2, 'Månadsinkomst');
INSERT INTO `lang_definitions` VALUES (2156, 6180, 2, 'Mer än 50 resultat, gör din sökning mer specifik.');
INSERT INTO `lang_definitions` VALUES (2157, 6190, 2, 'Moder');
INSERT INTO `lang_definitions` VALUES (2158, 6196, 2, 'Flytta');
INSERT INTO `lang_definitions` VALUES (2159, 6201, 2, 'Flytta till patient');
INSERT INTO `lang_definitions` VALUES (2160, 6202, 2, 'Flytta till...');
INSERT INTO `lang_definitions` VALUES (2161, 6203, 2, 'flytta up');
INSERT INTO `lang_definitions` VALUES (2162, 6209, 2, 'Herr.');
INSERT INTO `lang_definitions` VALUES (2163, 6215, 2, 'Fru.');
INSERT INTO `lang_definitions` VALUES (2164, 6217, 2, 'Fröken');
INSERT INTO `lang_definitions` VALUES (2165, 6230, 2, 'Multi Language Tool');
INSERT INTO `lang_definitions` VALUES (2166, 6234, 2, 'Flera områden');
INSERT INTO `lang_definitions` VALUES (2167, 6243, 2, 'Sorla:');
INSERT INTO `lang_definitions` VALUES (2168, 6244, 2, 'Muskel värk');
INSERT INTO `lang_definitions` VALUES (2169, 6250, 2, 'Muskel');
INSERT INTO `lang_definitions` VALUES (2170, 6251, 2, 'Muskel skada');
INSERT INTO `lang_definitions` VALUES (2171, 6252, 2, 'Muskuloskeletala');
INSERT INTO `lang_definitions` VALUES (2172, 6259, 2, 'Ömsesidigt Definierad');
INSERT INTO `lang_definitions` VALUES (2173, 6274, 2, 'Namn');
INSERT INTO `lang_definitions` VALUES (2174, 6278, 2, 'Namn 1');
INSERT INTO `lang_definitions` VALUES (2175, 6279, 2, 'Namn 2');
INSERT INTO `lang_definitions` VALUES (2176, 6280, 2, 'Namn på administratör');
INSERT INTO `lang_definitions` VALUES (2177, 6285, 2, 'Namn på försäkringsbolag');
INSERT INTO `lang_definitions` VALUES (2178, 6286, 2, 'Namn på Provider');
INSERT INTO `lang_definitions` VALUES (2179, 6296, 2, 'Namn:');
INSERT INTO `lang_definitions` VALUES (2180, 6300, 2, 'Narės:');
INSERT INTO `lang_definitions` VALUES (2181, 6301, 2, 'Narės: Normal Rätt');
INSERT INTO `lang_definitions` VALUES (2182, 6304, 2, 'Nasal mucosa rosa, septumets mittlinje');
INSERT INTO `lang_definitions` VALUES (2183, 6310, 2, 'Nationalitet');
INSERT INTO `lang_definitions` VALUES (2184, 6322, 2, 'Navigering');
INSERT INTO `lang_definitions` VALUES (2185, 6348, 2, 'Nacke');
INSERT INTO `lang_definitions` VALUES (2186, 6349, 2, 'Nackproblem');
INSERT INTO `lang_definitions` VALUES (2187, 6352, 2, 'Måste ange en beskrivning');
INSERT INTO `lang_definitions` VALUES (2188, 6353, 2, 'Ange ett returvärde');
INSERT INTO `lang_definitions` VALUES (2189, 6354, 2, 'Ange identifieraren');
INSERT INTO `lang_definitions` VALUES (2190, 6355, 2, 'Ange titel');
INSERT INTO `lang_definitions` VALUES (2191, 6360, 2, 'Ange sekundära fakturering');
INSERT INTO `lang_definitions` VALUES (2192, 6369, 2, 'Nervskada');
INSERT INTO `lang_definitions` VALUES (2193, 6371, 2, 'Neurala tillstånd / nervskada');
INSERT INTO `lang_definitions` VALUES (2194, 6384, 2, 'Ny');
INSERT INTO `lang_definitions` VALUES (2195, 6385, 2, 'Ny =>');
INSERT INTO `lang_definitions` VALUES (2196, 6386, 2, 'Nya mottagare');
INSERT INTO `lang_definitions` VALUES (2197, 6390, 2, 'Nytt möte');
INSERT INTO `lang_definitions` VALUES (2198, 6391, 2, 'Nya kategorier');
INSERT INTO `lang_definitions` VALUES (2199, 6393, 2, 'Nya kunder');
INSERT INTO `lang_definitions` VALUES (2200, 6394, 2, 'Ny konsultation');
INSERT INTO `lang_definitions` VALUES (2201, 6396, 2, 'Nytt definitionset tillagt');
INSERT INTO `lang_definitions` VALUES (2202, 6403, 2, 'Nya Patientbesöksformulär');
INSERT INTO `lang_definitions` VALUES (2203, 6404, 2, 'Nya möten som inte godkänts');
INSERT INTO `lang_definitions` VALUES (2204, 6406, 2, 'Nya Klinikinformation');
INSERT INTO `lang_definitions` VALUES (2205, 6410, 2, 'Ny grupp');
INSERT INTO `lang_definitions` VALUES (2206, 6425, 2, 'Ny begränsning av händelser');
INSERT INTO `lang_definitions` VALUES (2207, 6435, 2, 'Ny Patient');
INSERT INTO `lang_definitions` VALUES (2208, 6436, 2, 'NY PATIENT');
INSERT INTO `lang_definitions` VALUES (2209, 6437, 2, 'Nytt Patientbesök');
INSERT INTO `lang_definitions` VALUES (2210, 6439, 2, 'Nytt patient-ID');
INSERT INTO `lang_definitions` VALUES (2211, 6449, 2, 'Nya förslag');
INSERT INTO `lang_definitions` VALUES (2212, 6451, 2, 'Ny användare');
INSERT INTO `lang_definitions` VALUES (2213, 6453, 2, 'Nytt besök');
INSERT INTO `lang_definitions` VALUES (2214, 6454, 2, 'Ny/Sök');
INSERT INTO `lang_definitions` VALUES (2215, 6481, 2, 'Dagstidning');
INSERT INTO `lang_definitions` VALUES (2216, 6482, 2, 'Nästa');
INSERT INTO `lang_definitions` VALUES (2217, 6484, 2, 'Nästa dag');
INSERT INTO `lang_definitions` VALUES (2218, 6485, 2, 'Nästa Månad');
INSERT INTO `lang_definitions` VALUES (2219, 6491, 2, 'Nästa vecka');
INSERT INTO `lang_definitions` VALUES (2220, 6494, 2, 'Alias');
INSERT INTO `lang_definitions` VALUES (2221, 6496, 2, 'Nattliga svettningar');
INSERT INTO `lang_definitions` VALUES (2222, 6499, 2, 'Nej');
INSERT INTO `lang_definitions` VALUES (2223, 6500, 2, 'NEJ');
INSERT INTO `lang_definitions` VALUES (2224, 6502, 2, 'Ingen tillgång');
INSERT INTO `lang_definitions` VALUES (2225, 6515, 2, 'Inget faktureringssystem är aktivt');
INSERT INTO `lang_definitions` VALUES (2226, 6519, 2, 'Ingen kod specificerades!');
INSERT INTO `lang_definitions` VALUES (2227, 6523, 2, 'Ingen diagnos');
INSERT INTO `lang_definitions` VALUES (2228, 6529, 2, 'Inget slutdatum');
INSERT INTO `lang_definitions` VALUES (2229, 6530, 2, 'Inga poster funna, använda formuläret nedan för att lägga till en post.');
INSERT INTO `lang_definitions` VALUES (2230, 6532, 2, 'Inga händelser');
INSERT INTO `lang_definitions` VALUES (2231, 6536, 2, 'Ingen grupp valdes');
INSERT INTO `lang_definitions` VALUES (2232, 6537, 2, 'Inga bråck');
INSERT INTO `lang_definitions` VALUES (2233, 6541, 2, 'Nr Insurance Companies Found');
INSERT INTO `lang_definitions` VALUES (2234, 6580, 2, 'Inga tider hittades för denna period.');
INSERT INTO `lang_definitions` VALUES (2235, 6585, 2, 'Inga Partners hittades');
INSERT INTO `lang_definitions` VALUES (2236, 6588, 2, 'Inga perifera ödem');
INSERT INTO `lang_definitions` VALUES (2237, 6589, 2, 'Inga apotek hittades');
INSERT INTO `lang_definitions` VALUES (2238, 6590, 2, 'Inga recept hittades');
INSERT INTO `lang_definitions` VALUES (2239, 6592, 2, 'Ingen sjukdom / skada visas');
INSERT INTO `lang_definitions` VALUES (2240, 6612, 2, 'Inga resultat hittades i sökningen');
INSERT INTO `lang_definitions` VALUES (2241, 6614, 2, 'Inga resultat, försök igen.');
INSERT INTO `lang_definitions` VALUES (2242, 6618, 2, 'Ej kommit på avtalad tid');
INSERT INTO `lang_definitions` VALUES (2243, 6623, 2, 'Ingen hud dimpling eller bröst knölar');
INSERT INTO `lang_definitions` VALUES (2244, 6636, 2, 'Nr:');
INSERT INTO `lang_definitions` VALUES (2245, 6641, 2, 'Icke specifika skada');
INSERT INTO `lang_definitions` VALUES (2246, 6643, 2, 'Icke-insulinberoende diabetes');
INSERT INTO `lang_definitions` VALUES (2247, 6646, 2, 'Icke-SRH Medical');
INSERT INTO `lang_definitions` VALUES (2248, 6647, 2, 'Icke-SRH icke-medicinska');
INSERT INTO `lang_definitions` VALUES (2249, 6648, 2, 'Ingen');
INSERT INTO `lang_definitions` VALUES (2250, 6649, 2, 'ingen');
INSERT INTO `lang_definitions` VALUES (2251, 6653, 2, 'Inget av ovanstående');
INSERT INTO `lang_definitions` VALUES (2252, 6684, 2, 'Inte heller');
INSERT INTO `lang_definitions` VALUES (2253, 6685, 2, 'Normal');
INSERT INTO `lang_definitions` VALUES (2254, 6697, 2, 'Normal:');
INSERT INTO `lang_definitions` VALUES (2255, 6710, 2, 'Alla fält är obligatoriska för alla nummer eller kod typer.');
INSERT INTO `lang_definitions` VALUES (2256, 6712, 2, 'Ej tillåtet');
INSERT INTO `lang_definitions` VALUES (2257, 6713, 2, 'Ej tillåtet att ta bort gruppen Administratörer');
INSERT INTO `lang_definitions` VALUES (2258, 6715, 2, 'Ej tillåtet att inaktivera alla trygghet objekt');
INSERT INTO `lang_definitions` VALUES (2259, 6716, 2, 'Ej tillåtet att inaktivera allt från Administratörer ACL');
INSERT INTO `lang_definitions` VALUES (2260, 6717, 2, 'Ej tillåtet att ta bort admin-användare från gruppen Administratörer');
INSERT INTO `lang_definitions` VALUES (2261, 6720, 2, 'Ej behörighet att nå PostCalendar modulen');
INSERT INTO `lang_definitions` VALUES (2262, 6738, 2, 'Inte undersökt');
INSERT INTO `lang_definitions` VALUES (2263, 6739, 2, 'Inte undersökt:');
INSERT INTO `lang_definitions` VALUES (2264, 6740, 2, 'Inte undersökt:');
INSERT INTO `lang_definitions` VALUES (2265, 6751, 2, 'Inte sett sedan');
INSERT INTO `lang_definitions` VALUES (2266, 6758, 2, 'kommentera');
INSERT INTO `lang_definitions` VALUES (2267, 6771, 2, 'Kommentartyp');
INSERT INTO `lang_definitions` VALUES (2268, 6780, 2, 'Anmärkning: Denna kod har inte förts in av en auktoriserad användare. Endast godkända koder kan laddas upp till Open Medical Billing nätverket för bearbetning. Om du vill ladda upp dessa nummer kan du välja en auktoriserad användare här.');
INSERT INTO `lang_definitions` VALUES (2269, 6784, 2, 'OBS: Överföra filer med duplikat namn gör att filerna automatiskt ska döpas. Till exempel \"<i> file.jpg </ i>\" blir \"<i> file.jpg.1 </ i>\". Filnamnen anses unika per patient, inte per kategori.');
INSERT INTO `lang_definitions` VALUES (2270, 6785, 2, 'Kommentarer');
INSERT INTO `lang_definitions` VALUES (2271, 6804, 2, 'Ingenting valdes');
INSERT INTO `lang_definitions` VALUES (2272, 6808, 2, 'MEDDELANDE: PostCalendar Inlämning / Modifiering');
INSERT INTO `lang_definitions` VALUES (2273, 6809, 2, 'Besked');
INSERT INTO `lang_definitions` VALUES (2274, 6816, 2, 'Meddela Admin Om Händelse Inlämning / Modifieringsförslag?');
INSERT INTO `lang_definitions` VALUES (2275, 6821, 2, 'November');
INSERT INTO `lang_definitions` VALUES (2276, 6834, 2, 'NPI');
INSERT INTO `lang_definitions` VALUES (2277, 6837, 2, 'Nummer');
INSERT INTO `lang_definitions` VALUES (2278, 6843, 2, 'Antal kolumner i år-vy.');
INSERT INTO `lang_definitions` VALUES (2279, 6877, 2, 'Status');
INSERT INTO `lang_definitions` VALUES (2280, 6886, 2, 'Yrke');
INSERT INTO `lang_definitions` VALUES (2281, 6889, 2, 'Förekomst');
INSERT INTO `lang_definitions` VALUES (2282, 6891, 2, 'Oktober');
INSERT INTO `lang_definitions` VALUES (2283, 6897, 2, 'tabletter');
INSERT INTO `lang_definitions` VALUES (2284, 6898, 2, 'i månaden per');
INSERT INTO `lang_definitions` VALUES (2285, 6907, 2, 'Mottagningskommentarer');
INSERT INTO `lang_definitions` VALUES (2286, 6908, 2, 'Mottagningsbesök');
INSERT INTO `lang_definitions` VALUES (2287, 6921, 2, 'Avkomma');
INSERT INTO `lang_definitions` VALUES (2288, 6925, 2, 'salva');
INSERT INTO `lang_definitions` VALUES (2289, 6927, 2, 'OK');
INSERT INTO `lang_definitions` VALUES (2290, 6933, 2, 'Gamla klienter');
INSERT INTO `lang_definitions` VALUES (2291, 6948, 2, 'underlåtit att autoassign');
INSERT INTO `lang_definitions` VALUES (2292, 6950, 2, 'på');
INSERT INTO `lang_definitions` VALUES (2293, 6956, 2, 'På Hand');
INSERT INTO `lang_definitions` VALUES (2294, 6959, 2, 'På beställning');
INSERT INTO `lang_definitions` VALUES (2295, 6979, 2, 'När du byter lösenord måste du logga in på nytt.');
INSERT INTO `lang_definitions` VALUES (2296, 6999, 2, 'Endast aktiva');
INSERT INTO `lang_definitions` VALUES (2297, 7004, 2, 'endast om faktureringsadress');
INSERT INTO `lang_definitions` VALUES (2298, 7006, 2, 'Endast Inaktiva');
INSERT INTO `lang_definitions` VALUES (2299, 7007, 2, 'Endast Min');
INSERT INTO `lang_definitions` VALUES (2300, 7017, 2, 'Uppkomsten av sjukdom:');
INSERT INTO `lang_definitions` VALUES (2301, 7018, 2, 'Uppkomsten av sjukdom:');
INSERT INTO `lang_definitions` VALUES (2302, 7019, 2, 'Uppkomsten av Svullnad:');
INSERT INTO `lang_definitions` VALUES (2303, 7022, 2, 'Debut / Inskrivning. Datum:');
INSERT INTO `lang_definitions` VALUES (2304, 7031, 2, 'Öppen');
INSERT INTO `lang_definitions` VALUES (2305, 7084, 2, 'OpenEMR kräver Javascript för att utföra användarverifiering.');
INSERT INTO `lang_definitions` VALUES (2306, 7095, 2, 'Alternativ');
INSERT INTO `lang_definitions` VALUES (2307, 7099, 2, 'Valfritt');
INSERT INTO `lang_definitions` VALUES (2308, 7111, 2, 'Frivillig information om denna händelse');
INSERT INTO `lang_definitions` VALUES (2309, 7114, 2, 'Valfri procedurkodkod');
INSERT INTO `lang_definitions` VALUES (2310, 7117, 2, 'ELLER');
INSERT INTO `lang_definitions` VALUES (2311, 7118, 2, 'Eller');
INSERT INTO `lang_definitions` VALUES (2312, 7119, 2, 'Eller välj');
INSERT INTO `lang_definitions` VALUES (2313, 7125, 2, 'Eller ladda upp ERA fil:');
INSERT INTO `lang_definitions` VALUES (2314, 7129, 2, 'Ordning');
INSERT INTO `lang_definitions` VALUES (2315, 7166, 2, 'Organskada');
INSERT INTO `lang_definitions` VALUES (2316, 7167, 2, 'Organisation');
INSERT INTO `lang_definitions` VALUES (2317, 7171, 2, 'Orienterad x 3');
INSERT INTO `lang_definitions` VALUES (2318, 7188, 2, 'P.O. (via munnen)');
INSERT INTO `lang_definitions` VALUES (2319, 7193, 2, 'Övrigt');
INSERT INTO `lang_definitions` VALUES (2320, 7194, 2, 'annan');
INSERT INTO `lang_definitions` VALUES (2321, 7203, 2, 'Andra skador inte specificerade på någon annan plats');
INSERT INTO `lang_definitions` VALUES (2322, 7206, 2, 'annan månad');
INSERT INTO `lang_definitions` VALUES (2323, 7207, 2, 'Andra icke-federala program');
INSERT INTO `lang_definitions` VALUES (2324, 7209, 2, 'Andra relevanta Symtom');
INSERT INTO `lang_definitions` VALUES (2325, 7210, 2, 'Andra relevanta Symtom:');
INSERT INTO `lang_definitions` VALUES (2326, 7216, 2, 'Andra kirurgiska');
INSERT INTO `lang_definitions` VALUES (2327, 7225, 2, 'OU');
INSERT INTO `lang_definitions` VALUES (2328, 7231, 2, 'Utfall');
INSERT INTO `lang_definitions` VALUES (2329, 7234, 2, 'Outlook');
INSERT INTO `lang_definitions` VALUES (2330, 7244, 2, 'Överutnyttjande');
INSERT INTO `lang_definitions` VALUES (2331, 7252, 2, 'vid behov');
INSERT INTO `lang_definitions` VALUES (2332, 7259, 2, 'Pedriatisk');
INSERT INTO `lang_definitions` VALUES (2333, 7263, 2, 'Sidor');
INSERT INTO `lang_definitions` VALUES (2334, 7264, 2, 'Betald');
INSERT INTO `lang_definitions` VALUES (2335, 7265, 2, 'Betalt belopp som du kommer att fördela');
INSERT INTO `lang_definitions` VALUES (2336, 7267, 2, 'Betalas via');
INSERT INTO `lang_definitions` VALUES (2337, 7289, 2, 'Partner');
INSERT INTO `lang_definitions` VALUES (2338, 7301, 2, 'Lösenord');
INSERT INTO `lang_definitions` VALUES (2339, 7302, 2, 'Ändra lösenord');
INSERT INTO `lang_definitions` VALUES (2340, 7311, 2, 'Lösenord för SMS Gateway');
INSERT INTO `lang_definitions` VALUES (2341, 7319, 2, 'Lösenord:');
INSERT INTO `lang_definitions` VALUES (2342, 7334, 2, 'Tidigare möten');
INSERT INTO `lang_definitions` VALUES (2343, 7335, 2, 'Tidigare möten och dokument');
INSERT INTO `lang_definitions` VALUES (2344, 7344, 2, 'Klistra in HL7 Data');
INSERT INTO `lang_definitions` VALUES (2345, 7370, 2, 'Patient Allergier');
INSERT INTO `lang_definitions` VALUES (2346, 7373, 2, 'Patient träff/bokning');
INSERT INTO `lang_definitions` VALUES (2347, 7379, 2, 'Patient diagram ID');
INSERT INTO `lang_definitions` VALUES (2348, 7394, 2, 'Patientdata');
INSERT INTO `lang_definitions` VALUES (2349, 7404, 2, 'Patientdokument');
INSERT INTO `lang_definitions` VALUES (2350, 7412, 2, 'Patientmöten');
INSERT INTO `lang_definitions` VALUES (2351, 7413, 2, 'Patientmötesformulär');
INSERT INTO `lang_definitions` VALUES (2352, 7414, 2, 'Patientmöten');
INSERT INTO `lang_definitions` VALUES (2353, 7415, 2, 'Patientsök');
INSERT INTO `lang_definitions` VALUES (2354, 7428, 2, 'Patienthistoria');
INSERT INTO `lang_definitions` VALUES (2355, 7429, 2, 'Patientens historia / Livsstil');
INSERT INTO `lang_definitions` VALUES (2356, 7431, 2, 'Patient-ID');
INSERT INTO `lang_definitions` VALUES (2357, 7437, 2, 'Patient -vaccination');
INSERT INTO `lang_definitions` VALUES (2358, 7441, 2, 'Ej tilldelad!');
INSERT INTO `lang_definitions` VALUES (2359, 7445, 2, 'Patient -problem');
INSERT INTO `lang_definitions` VALUES (2360, 7454, 2, 'Patientlista');
INSERT INTO `lang_definitions` VALUES (2361, 7463, 2, 'Patientens medicinska problem');
INSERT INTO `lang_definitions` VALUES (2362, 7464, 2, 'Patient -Mediciner');
INSERT INTO `lang_definitions` VALUES (2363, 7472, 2, 'Patient: Namn och Adress');
INSERT INTO `lang_definitions` VALUES (2364, 7478, 2, 'Patientanteckning, typ');
INSERT INTO `lang_definitions` VALUES (2365, 7479, 2, 'Patient -kommentarer');
INSERT INTO `lang_definitions` VALUES (2366, 7482, 2, 'Patientnummer');
INSERT INTO `lang_definitions` VALUES (2367, 7499, 2, 'Patient -Journalrapport');
INSERT INTO `lang_definitions` VALUES (2368, 7514, 2, 'Patientrapport');
INSERT INTO `lang_definitions` VALUES (2369, 7518, 2, 'Patientförfrågan');
INSERT INTO `lang_definitions` VALUES (2370, 7539, 2, 'Patient -Sammanfattning');
INSERT INTO `lang_definitions` VALUES (2371, 7542, 2, 'Patient -Remisser m.m.');
INSERT INTO `lang_definitions` VALUES (2372, 7550, 2, 'Patient / Klient');
INSERT INTO `lang_definitions` VALUES (2373, 7551, 2, 'Patient:');
INSERT INTO `lang_definitions` VALUES (2374, 7553, 2, 'Patienter');
INSERT INTO `lang_definitions` VALUES (2375, 7559, 2, 'Betala');
INSERT INTO `lang_definitions` VALUES (2376, 7563, 2, 'Betalningsdatum:');
INSERT INTO `lang_definitions` VALUES (2377, 7568, 2, 'Betalare');
INSERT INTO `lang_definitions` VALUES (2378, 7572, 2, 'Betalare Typ');
INSERT INTO `lang_definitions` VALUES (2379, 7573, 2, 'Utbetalande');
INSERT INTO `lang_definitions` VALUES (2380, 7575, 2, 'Betalning');
INSERT INTO `lang_definitions` VALUES (2381, 7583, 2, 'Betalningsdatum');
INSERT INTO `lang_definitions` VALUES (2382, 7590, 2, 'Betalningsmetod');
INSERT INTO `lang_definitions` VALUES (2383, 7600, 2, 'Betalning värde för kod');
INSERT INTO `lang_definitions` VALUES (2384, 7602, 2, 'Betalningar');
INSERT INTO `lang_definitions` VALUES (2385, 7624, 2, 'Oavslutad');
INSERT INTO `lang_definitions` VALUES (2386, 7630, 2, 'Oklart');
INSERT INTO `lang_definitions` VALUES (2387, 7642, 2, 'via näsborre');
INSERT INTO `lang_definitions` VALUES (2388, 7643, 2, 'via näsborre');
INSERT INTO `lang_definitions` VALUES (2389, 7646, 2, 'Rektalt');
INSERT INTO `lang_definitions` VALUES (2390, 7647, 2, 'rektalt');
INSERT INTO `lang_definitions` VALUES (2391, 7654, 2, 'Utför sökning');
INSERT INTO `lang_definitions` VALUES (2392, 7655, 2, 'Utför åtgärden');
INSERT INTO `lang_definitions` VALUES (2393, 7678, 2, 'Apotek');
INSERT INTO `lang_definitions` VALUES (2394, 7680, 2, 'Patient Insurance Distribution');
INSERT INTO `lang_definitions` VALUES (2395, 7688, 2, 'Pheumothorax');
INSERT INTO `lang_definitions` VALUES (2396, 7697, 2, 'Telefon');
INSERT INTO `lang_definitions` VALUES (2397, 7699, 2, 'Telefon samtalslistan');
INSERT INTO `lang_definitions` VALUES (2398, 7711, 2, 'Telefonnummer');
INSERT INTO `lang_definitions` VALUES (2399, 7723, 2, 'Hälsokontroll');
INSERT INTO `lang_definitions` VALUES (2400, 7725, 2, 'Läkares Begäran');
INSERT INTO `lang_definitions` VALUES (2401, 7726, 2, 'Läkares Underskrift');
INSERT INTO `lang_definitions` VALUES (2402, 7729, 2, 'Läkare');
INSERT INTO `lang_definitions` VALUES (2403, 7733, 2, 'välj');
INSERT INTO `lang_definitions` VALUES (2404, 7741, 2, 'Tablett Storlek');
INSERT INTO `lang_definitions` VALUES (2405, 7742, 2, 'Tabletter');
INSERT INTO `lang_definitions` VALUES (2406, 7756, 2, 'Vanlig text');
INSERT INTO `lang_definitions` VALUES (2407, 7757, 2, 'Planering');
INSERT INTO `lang_definitions` VALUES (2408, 7762, 2, 'Planering namn');
INSERT INTO `lang_definitions` VALUES (2409, 7773, 2, 'Planering:');
INSERT INTO `lang_definitions` VALUES (2410, 7776, 2, 'Planering');
INSERT INTO `lang_definitions` VALUES (2411, 7778, 2, 'Spelare');
INSERT INTO `lang_definitions` VALUES (2412, 7779, 2, 'Position');
INSERT INTO `lang_definitions` VALUES (2413, 7789, 2, 'Välj ett värde för');
INSERT INTO `lang_definitions` VALUES (2414, 7795, 2, 'Stäng detta fönster');
INSERT INTO `lang_definitions` VALUES (2415, 7796, 2, 'Jämför det nya namnet');
INSERT INTO `lang_definitions` VALUES (2416, 7861, 2, 'Vänligen använ endast alfabetiska tecken');
INSERT INTO `lang_definitions` VALUES (2417, 7862, 2, 'Vänligen använd endast alfabetiska tecken utan mellanslag');
INSERT INTO `lang_definitions` VALUES (2418, 7863, 2, 'Vänligen betala detta belopp');
INSERT INTO `lang_definitions` VALUES (2419, 7889, 2, 'Välj en händelse');
INSERT INTO `lang_definitions` VALUES (2420, 7926, 2, 'EM');
INSERT INTO `lang_definitions` VALUES (2421, 7940, 2, 'Lunginflammations Vaccination');
INSERT INTO `lang_definitions` VALUES (2422, 7947, 2, 'Förhållningssätt');
INSERT INTO `lang_definitions` VALUES (2423, 7955, 2, 'Polyper');
INSERT INTO `lang_definitions` VALUES (2424, 7957, 2, 'Dålig apptit');
INSERT INTO `lang_definitions` VALUES (2425, 7958, 2, 'Dålig cirkulation');
INSERT INTO `lang_definitions` VALUES (2426, 7959, 2, 'Dålig hörsel');
INSERT INTO `lang_definitions` VALUES (2427, 7965, 2, 'Popup-fönster');
INSERT INTO `lang_definitions` VALUES (2428, 8011, 2, 'Postnr');
INSERT INTO `lang_definitions` VALUES (2429, 8012, 2, 'Postnummer');
INSERT INTO `lang_definitions` VALUES (2430, 8026, 2, 'Överförings Datum');
INSERT INTO `lang_definitions` VALUES (2431, 8037, 2, 'Practice');
INSERT INTO `lang_definitions` VALUES (2432, 8056, 2, 'Graviditets test');
INSERT INTO `lang_definitions` VALUES (2433, 8059, 2, 'Förskottsbetalning');
INSERT INTO `lang_definitions` VALUES (2434, 8066, 2, 'Receptbelagda märken');
INSERT INTO `lang_definitions` VALUES (2435, 8070, 2, 'Recept');
INSERT INTO `lang_definitions` VALUES (2436, 8073, 2, 'Föreskrifter och dispenser');
INSERT INTO `lang_definitions` VALUES (2437, 8074, 2, 'Recept och andra råd');
INSERT INTO `lang_definitions` VALUES (2438, 8075, 2, 'Recept och andra råd av specialist');
INSERT INTO `lang_definitions` VALUES (2439, 8076, 2, 'recept rapport');
INSERT INTO `lang_definitions` VALUES (2440, 8077, 2, 'Recept/råd');
INSERT INTO `lang_definitions` VALUES (2441, 8079, 2, 'Presentera Klagomål');
INSERT INTO `lang_definitions` VALUES (2442, 8081, 2, 'Tryck på fortsätt för att fortsätta');
INSERT INTO `lang_definitions` VALUES (2443, 8084, 2, 'Förmodad diagnos');
INSERT INTO `lang_definitions` VALUES (2444, 8085, 2, 'Förmodad diagnos från specialist');
INSERT INTO `lang_definitions` VALUES (2445, 8086, 2, 'Föregående');
INSERT INTO `lang_definitions` VALUES (2446, 8098, 2, 'Föregående');
INSERT INTO `lang_definitions` VALUES (2447, 8099, 2, 'Föregående konsultation');
INSERT INTO `lang_definitions` VALUES (2448, 8100, 2, 'Föregående dag');
INSERT INTO `lang_definitions` VALUES (2449, 8103, 2, 'Föregående månad');
INSERT INTO `lang_definitions` VALUES (2450, 8104, 2, 'Föregående vecka');
INSERT INTO `lang_definitions` VALUES (2451, 8105, 2, 'Pris');
INSERT INTO `lang_definitions` VALUES (2452, 8109, 2, 'Prisnivå');
INSERT INTO `lang_definitions` VALUES (2453, 8111, 2, 'Prisnivå:');
INSERT INTO `lang_definitions` VALUES (2454, 8114, 2, 'Primär');
INSERT INTO `lang_definitions` VALUES (2455, 8126, 2, 'Primära Försäkring');
INSERT INTO `lang_definitions` VALUES (2456, 8127, 2, 'Primära Försäkrings Data');
INSERT INTO `lang_definitions` VALUES (2457, 8128, 2, 'Primär försäkringsbolag');
INSERT INTO `lang_definitions` VALUES (2458, 8130, 2, 'Skriv ut');
INSERT INTO `lang_definitions` VALUES (2459, 8135, 2, 'Printa blankt remissformulär');
INSERT INTO `lang_definitions` VALUES (2460, 8148, 2, 'Skriv ut flera');
INSERT INTO `lang_definitions` VALUES (2461, 8168, 2, 'Skriv ut denna anmärkning');
INSERT INTO `lang_definitions` VALUES (2462, 8169, 2, 'Skriv ut Denna Anmärkning');
INSERT INTO `lang_definitions` VALUES (2463, 8173, 2, 'Utskrivbar');
INSERT INTO `lang_definitions` VALUES (2464, 8174, 2, 'Utskriftsversion');
INSERT INTO `lang_definitions` VALUES (2465, 8178, 2, 'Skriva ut resultat:');
INSERT INTO `lang_definitions` VALUES (2466, 8192, 2, 'Prioritet');
INSERT INTO `lang_definitions` VALUES (2467, 8196, 2, 'Privat');
INSERT INTO `lang_definitions` VALUES (2468, 8202, 2, 'Problem/anledningar');
INSERT INTO `lang_definitions` VALUES (2469, 8209, 2, 'Förfarande');
INSERT INTO `lang_definitions` VALUES (2470, 8254, 2, 'Förfarande');
INSERT INTO `lang_definitions` VALUES (2471, 8256, 2, 'Process');
INSERT INTO `lang_definitions` VALUES (2472, 8267, 2, 'Bearbetning');
INSERT INTO `lang_definitions` VALUES (2473, 8279, 2, 'Produkter');
INSERT INTO `lang_definitions` VALUES (2474, 8282, 2, 'Prof.');
INSERT INTO `lang_definitions` VALUES (2475, 8295, 2, 'Prostata Cancer');
INSERT INTO `lang_definitions` VALUES (2476, 8297, 2, 'Prostata undersökning');
INSERT INTO `lang_definitions` VALUES (2477, 8298, 2, 'Prostata problem');
INSERT INTO `lang_definitions` VALUES (2478, 8318, 2, 'Vårdgivare');
INSERT INTO `lang_definitions` VALUES (2479, 8322, 2, 'Vårdgivare ID');
INSERT INTO `lang_definitions` VALUES (2480, 8323, 2, 'Vårdgivare ID');
INSERT INTO `lang_definitions` VALUES (2481, 8324, 2, 'Vårdgivare ID på specificerad klinik');
INSERT INTO `lang_definitions` VALUES (2482, 8325, 2, 'Kan ej matcha vårdgivare');
INSERT INTO `lang_definitions` VALUES (2483, 8330, 2, 'Vårdgivare, nummmer');
INSERT INTO `lang_definitions` VALUES (2484, 8336, 2, 'Vårdgivare:');
INSERT INTO `lang_definitions` VALUES (2485, 8337, 2, 'Vårdgivare:');
INSERT INTO `lang_definitions` VALUES (2486, 8342, 2, 'PSA');
INSERT INTO `lang_definitions` VALUES (2487, 8343, 2, 'Psoriasis');
INSERT INTO `lang_definitions` VALUES (2488, 8345, 2, 'Psykisk diagnos');
INSERT INTO `lang_definitions` VALUES (2489, 8346, 2, 'Psykiatrisk mediciinering');
INSERT INTO `lang_definitions` VALUES (2490, 8347, 2, 'Psykiatrisk mediciinering');
INSERT INTO `lang_definitions` VALUES (2491, 8398, 2, 'Puls');
INSERT INTO `lang_definitions` VALUES (2492, 8408, 2, 'Var 3:e timme');
INSERT INTO `lang_definitions` VALUES (2493, 8409, 2, 'Var 4:e timme');
INSERT INTO `lang_definitions` VALUES (2494, 8410, 2, 'Var 5:e timme');
INSERT INTO `lang_definitions` VALUES (2495, 8411, 2, 'Var 6:e timme');
INSERT INTO `lang_definitions` VALUES (2496, 8412, 2, 'Var 8:e timme');
INSERT INTO `lang_definitions` VALUES (2497, 8413, 2, '1 ggr/dag');
INSERT INTO `lang_definitions` VALUES (2498, 8414, 2, '4ggr/dag');
INSERT INTO `lang_definitions` VALUES (2499, 8419, 2, 'Antal');
INSERT INTO `lang_definitions` VALUES (2500, 8421, 2, 'Kvalitet');
INSERT INTO `lang_definitions` VALUES (2501, 8423, 2, 'Kvantitet');
INSERT INTO `lang_definitions` VALUES (2502, 8425, 2, 'Kvantitet för NDC');
INSERT INTO `lang_definitions` VALUES (2503, 8436, 2, 'köad');
INSERT INTO `lang_definitions` VALUES (2504, 8437, 2, 'Kö Evenemang Administration');
INSERT INTO `lang_definitions` VALUES (2505, 8438, 2, 'köad för');
INSERT INTO `lang_definitions` VALUES (2506, 8440, 2, 'Kö föreläggande Administration');
INSERT INTO `lang_definitions` VALUES (2507, 8452, 2, 'Modersmål / Tolkspråk');
INSERT INTO `lang_definitions` VALUES (2508, 8453, 2, 'Modersmål / Tolkspråk');
INSERT INTO `lang_definitions` VALUES (2509, 8454, 2, 'Modersmål / Tolkspråk');
INSERT INTO `lang_definitions` VALUES (2510, 8456, 2, 'Radio');
INSERT INTO `lang_definitions` VALUES (2511, 8457, 2, 'Radioknapp');
INSERT INTO `lang_definitions` VALUES (2512, 8463, 2, 'Utslag');
INSERT INTO `lang_definitions` VALUES (2513, 8464, 2, 'Betygsätta');
INSERT INTO `lang_definitions` VALUES (2514, 8466, 2, 'Andel');
INSERT INTO `lang_definitions` VALUES (2515, 8482, 2, 'Åter öppnas');
INSERT INTO `lang_definitions` VALUES (2516, 8486, 2, 'Reaktioner');
INSERT INTO `lang_definitions` VALUES (2517, 8496, 2, 'Riktigt namn');
INSERT INTO `lang_definitions` VALUES (2518, 8498, 2, 'Anledning');
INSERT INTO `lang_definitions` VALUES (2519, 8499, 2, 'Orsak till avslutande');
INSERT INTO `lang_definitions` VALUES (2520, 8502, 2, 'Anledning till remiss');
INSERT INTO `lang_definitions` VALUES (2521, 8504, 2, 'Anledning till besök');
INSERT INTO `lang_definitions` VALUES (2522, 8506, 2, 'Orsak / Form');
INSERT INTO `lang_definitions` VALUES (2523, 8521, 2, 'Kvitto');
INSERT INTO `lang_definitions` VALUES (2524, 8522, 2, 'Kvitto för betalning');
INSERT INTO `lang_definitions` VALUES (2525, 8525, 2, 'Kvitton Sammanfattning');
INSERT INTO `lang_definitions` VALUES (2526, 8526, 2, 'Mottagna');
INSERT INTO `lang_definitions` VALUES (2527, 8527, 2, 'Mottagna av');
INSERT INTO `lang_definitions` VALUES (2528, 8528, 2, 'Mottagna fax');
INSERT INTO `lang_definitions` VALUES (2529, 8532, 2, 'Mottagare');
INSERT INTO `lang_definitions` VALUES (2530, 8533, 2, 'Mottagare ID');
INSERT INTO `lang_definitions` VALUES (2531, 8552, 2, 'Rekomendationer');
INSERT INTO `lang_definitions` VALUES (2532, 8553, 2, 'Rekomendationer och behandling');
INSERT INTO `lang_definitions` VALUES (2533, 8554, 2, 'Rekomendationer av specialist');
INSERT INTO `lang_definitions` VALUES (2534, 8595, 2, 'reduceras:');
INSERT INTO `lang_definitions` VALUES (2535, 8597, 2, 'Remitera');
INSERT INTO `lang_definitions` VALUES (2536, 8598, 2, 'Remiterad av');
INSERT INTO `lang_definitions` VALUES (2537, 8599, 2, 'Remissdatum');
INSERT INTO `lang_definitions` VALUES (2538, 8600, 2, 'Remiteras till');
INSERT INTO `lang_definitions` VALUES (2539, 8603, 2, 'Prioritetsnivå (Risknivå)');
INSERT INTO `lang_definitions` VALUES (2540, 8605, 2, 'Orsak till remiss');
INSERT INTO `lang_definitions` VALUES (2541, 8609, 2, 'Remittent, namn och signatur');
INSERT INTO `lang_definitions` VALUES (2542, 8610, 2, 'Remiss');
INSERT INTO `lang_definitions` VALUES (2543, 8611, 2, 'Remitterad av');
INSERT INTO `lang_definitions` VALUES (2544, 8612, 2, 'Remisskort');
INSERT INTO `lang_definitions` VALUES (2545, 8613, 2, 'Remissdadum');
INSERT INTO `lang_definitions` VALUES (2546, 8614, 2, 'Remissformulär');
INSERT INTO `lang_definitions` VALUES (2547, 8615, 2, 'REMISSFORMULÄR');
INSERT INTO `lang_definitions` VALUES (2548, 8619, 2, 'Remisskälla');
INSERT INTO `lang_definitions` VALUES (2549, 8621, 2, 'Remitteras till');
INSERT INTO `lang_definitions` VALUES (2550, 8622, 2, 'remittering');
INSERT INTO `lang_definitions` VALUES (2551, 8623, 2, 'remiss');
INSERT INTO `lang_definitions` VALUES (2552, 8624, 2, 'Remiterats från');
INSERT INTO `lang_definitions` VALUES (2553, 8625, 2, 'Remiterats från');
INSERT INTO `lang_definitions` VALUES (2554, 8627, 2, 'Remitterats till');
INSERT INTO `lang_definitions` VALUES (2555, 8628, 2, 'Remiterats av');
INSERT INTO `lang_definitions` VALUES (2556, 8639, 2, 'Påfyllnad');
INSERT INTO `lang_definitions` VALUES (2557, 8640, 2, 'påfyllnad');
INSERT INTO `lang_definitions` VALUES (2558, 8641, 2, 'Reflexer normala');
INSERT INTO `lang_definitions` VALUES (2559, 8645, 2, 'Uppdatera');
INSERT INTO `lang_definitions` VALUES (2560, 8662, 2, 'Registrerad');
INSERT INTO `lang_definitions` VALUES (2561, 8663, 2, 'registrerade');
INSERT INTO `lang_definitions` VALUES (2562, 8668, 2, 'Registreringsdag');
INSERT INTO `lang_definitions` VALUES (2563, 8672, 2, 'Rehabilitering');
INSERT INTO `lang_definitions` VALUES (2564, 8677, 2, 'Relaterat');
INSERT INTO `lang_definitions` VALUES (2565, 8682, 2, 'Förhållande');
INSERT INTO `lang_definitions` VALUES (2566, 8684, 2, 'Anhöriga');
INSERT INTO `lang_definitions` VALUES (2567, 8700, 2, 'Religion');
INSERT INTO `lang_definitions` VALUES (2568, 8705, 2, 'Relogin');
INSERT INTO `lang_definitions` VALUES (2569, 8733, 2, 'Ta bort grupp');
INSERT INTO `lang_definitions` VALUES (2570, 8760, 2, 'Upprepar');
INSERT INTO `lang_definitions` VALUES (2571, 8771, 2, 'Svars Datum');
INSERT INTO `lang_definitions` VALUES (2572, 8774, 2, 'Rapport');
INSERT INTO `lang_definitions` VALUES (2573, 8797, 2, 'Rapporter');
INSERT INTO `lang_definitions` VALUES (2574, 8821, 2, 'Nödvändig');
INSERT INTO `lang_definitions` VALUES (2575, 8832, 2, 'RESERVERAD');
INSERT INTO `lang_definitions` VALUES (2576, 8833, 2, 'reserverad');
INSERT INTO `lang_definitions` VALUES (2577, 8852, 2, 'Löst');
INSERT INTO `lang_definitions` VALUES (2578, 8866, 2, 'Begränsat Utbildning');
INSERT INTO `lang_definitions` VALUES (2579, 8867, 2, 'Resultat');
INSERT INTO `lang_definitions` VALUES (2580, 8885, 2, 'Infällda Höger:');
INSERT INTO `lang_definitions` VALUES (2581, 8886, 2, 'Avkastning');
INSERT INTO `lang_definitions` VALUES (2582, 8897, 2, 'Returvärde');
INSERT INTO `lang_definitions` VALUES (2583, 8898, 2, 'Återresa');
INSERT INTO `lang_definitions` VALUES (2584, 8918, 2, 'Översyn av System Kontroller');
INSERT INTO `lang_definitions` VALUES (2585, 8924, 2, 'Revision');
INSERT INTO `lang_definitions` VALUES (2586, 8928, 2, 'Höger');
INSERT INTO `lang_definitions` VALUES (2587, 8931, 2, 'Höger öra');
INSERT INTO `lang_definitions` VALUES (2588, 8932, 2, 'höger öra');
INSERT INTO `lang_definitions` VALUES (2589, 8940, 2, 'Höger:');
INSERT INTO `lang_definitions` VALUES (2590, 8941, 2, 'Ringningar i öron');
INSERT INTO `lang_definitions` VALUES (2591, 8942, 2, 'Tinitus');
INSERT INTO `lang_definitions` VALUES (2592, 8966, 2, 'Rutt');
INSERT INTO `lang_definitions` VALUES (2593, 8969, 2, 'Rader');
INSERT INTO `lang_definitions` VALUES (2594, 8972, 2, 'Massera:');
INSERT INTO `lang_definitions` VALUES (2595, 8973, 2, 'Gnuggar:');
INSERT INTO `lang_definitions` VALUES (2596, 8989, 2, 'Kör kommando:');
INSERT INTO `lang_definitions` VALUES (2597, 8995, 2, 'Recept');
INSERT INTO `lang_definitions` VALUES (2598, 8996, 2, 'Recept');
INSERT INTO `lang_definitions` VALUES (2599, 9028, 2, 'K');
INSERT INTO `lang_definitions` VALUES (2600, 9029, 2, 'Personnr');
INSERT INTO `lang_definitions` VALUES (2601, 9039, 2, 'Samma dag');
INSERT INTO `lang_definitions` VALUES (2602, 9042, 2, 'Sanktions Typ');
INSERT INTO `lang_definitions` VALUES (2603, 9047, 2, 'Lördag');
INSERT INTO `lang_definitions` VALUES (2604, 9048, 2, 'Lördag & söndag');
INSERT INTO `lang_definitions` VALUES (2605, 9049, 2, 'Lördag');
INSERT INTO `lang_definitions` VALUES (2606, 9050, 2, 'Spara');
INSERT INTO `lang_definitions` VALUES (2607, 9058, 2, 'Spara och fördela');
INSERT INTO `lang_definitions` VALUES (2608, 9061, 2, 'Spara som ny');
INSERT INTO `lang_definitions` VALUES (2609, 9067, 2, 'Spara ändringar');
INSERT INTO `lang_definitions` VALUES (2610, 9076, 2, 'Spara vaccination');
INSERT INTO `lang_definitions` VALUES (2611, 9089, 2, 'Spara transaktionen');
INSERT INTO `lang_definitions` VALUES (2612, 9098, 2, 'Inskannade');
INSERT INTO `lang_definitions` VALUES (2613, 9104, 2, 'Schema');
INSERT INTO `lang_definitions` VALUES (2614, 9122, 2, 'Skolios');
INSERT INTO `lang_definitions` VALUES (2615, 9133, 2, 'SE');
INSERT INTO `lang_definitions` VALUES (2616, 9134, 2, 'SE Adress');
INSERT INTO `lang_definitions` VALUES (2617, 9135, 2, 'SE Stad');
INSERT INTO `lang_definitions` VALUES (2618, 9136, 2, 'SE Land');
INSERT INTO `lang_definitions` VALUES (2619, 9141, 2, 'Söka');
INSERT INTO `lang_definitions` VALUES (2620, 9143, 2, 'söka');
INSERT INTO `lang_definitions` VALUES (2621, 9144, 2, 'Sök igen');
INSERT INTO `lang_definitions` VALUES (2622, 9150, 2, 'Sök efter:');
INSERT INTO `lang_definitions` VALUES (2623, 9156, 2, 'Sök efter:');
INSERT INTO `lang_definitions` VALUES (2624, 9161, 2, 'Sök efter eller lägg till patient');
INSERT INTO `lang_definitions` VALUES (2625, 9168, 2, 'Sökresultat:');
INSERT INTO `lang_definitions` VALUES (2626, 9175, 2, 'Sök i Evenemang');
INSERT INTO `lang_definitions` VALUES (2627, 9179, 2, 'Sök / Lägg till försäkringsgivaren');
INSERT INTO `lang_definitions` VALUES (2628, 9185, 2, 'Bilbältesanvändning');
INSERT INTO `lang_definitions` VALUES (2629, 9186, 2, 'Andra');
INSERT INTO `lang_definitions` VALUES (2630, 9189, 2, 'Sekundär');
INSERT INTO `lang_definitions` VALUES (2631, 9191, 2, 'Sekundär Försäkring');
INSERT INTO `lang_definitions` VALUES (2632, 9192, 2, 'Sekundär Försäkrings Data');
INSERT INTO `lang_definitions` VALUES (2633, 9208, 2, 'Se Alla');
INSERT INTO `lang_definitions` VALUES (2634, 9210, 2, 'Se Auktoriseringar');
INSERT INTO `lang_definitions` VALUES (2635, 9218, 2, 'Sett sedan');
INSERT INTO `lang_definitions` VALUES (2636, 9225, 2, 'Välj');
INSERT INTO `lang_definitions` VALUES (2637, 9239, 2, 'Välj Alla');
INSERT INTO `lang_definitions` VALUES (2638, 9340, 2, 'Selecionar usuários da lista suspensa');
INSERT INTO `lang_definitions` VALUES (2639, 9358, 2, 'Egen lön');
INSERT INTO `lang_definitions` VALUES (2640, 9369, 2, 'Överföring pågår');
INSERT INTO `lang_definitions` VALUES (2641, 9395, 2, 'Avsändare');
INSERT INTO `lang_definitions` VALUES (2642, 9396, 2, 'Avsändar ID');
INSERT INTO `lang_definitions` VALUES (2643, 9411, 2, 'Känslighet:');
INSERT INTO `lang_definitions` VALUES (2644, 9420, 2, 'Skickats');
INSERT INTO `lang_definitions` VALUES (2645, 9423, 2, 'skickas till skrivaren.');
INSERT INTO `lang_definitions` VALUES (2646, 9430, 2, 'Separerade');
INSERT INTO `lang_definitions` VALUES (2647, 9431, 2, 'September');
INSERT INTO `lang_definitions` VALUES (2648, 9451, 2, 'Service Datum:');
INSERT INTO `lang_definitions` VALUES (2649, 9455, 2, 'Service Location');
INSERT INTO `lang_definitions` VALUES (2650, 9461, 2, 'Tjänster');
INSERT INTO `lang_definitions` VALUES (2651, 9462, 2, 'Tjänster efter kategori');
INSERT INTO `lang_definitions` VALUES (2652, 9463, 2, 'Tjänster som Tillhandahålls');
INSERT INTO `lang_definitions` VALUES (2653, 9464, 2, 'Tjänster som tillhandahålls');
INSERT INTO `lang_definitions` VALUES (2654, 9488, 2, 'Inställningar');
INSERT INTO `lang_definitions` VALUES (2655, 9493, 2, 'Svår huvudvärk');
INSERT INTO `lang_definitions` VALUES (2656, 9496, 2, 'Svårighetsgrad av smärta');
INSERT INTO `lang_definitions` VALUES (2657, 9497, 2, 'Svårighetsgrad av smärta:');
INSERT INTO `lang_definitions` VALUES (2658, 9498, 2, 'Kön');
INSERT INTO `lang_definitions` VALUES (2659, 9499, 2, 'Sexuellt överförbara sjukdomar');
INSERT INTO `lang_definitions` VALUES (2660, 9503, 2, 'Dela');
INSERT INTO `lang_definitions` VALUES (2661, 9510, 2, 'Andnöd');
INSERT INTO `lang_definitions` VALUES (2662, 9516, 2, 'bör vara som nnnnn-nnnn-nn');
INSERT INTO `lang_definitions` VALUES (2663, 9520, 2, 'Axel');
INSERT INTO `lang_definitions` VALUES (2664, 9521, 2, 'Axel + nyckelben');
INSERT INTO `lang_definitions` VALUES (2665, 9522, 2, 'Axelproblem');
INSERT INTO `lang_definitions` VALUES (2666, 9523, 2, 'visa');
INSERT INTO `lang_definitions` VALUES (2667, 9532, 2, 'Visa som upptagen');
INSERT INTO `lang_definitions` VALUES (2668, 9533, 2, 'Visa endast behöriga');
INSERT INTO `lang_definitions` VALUES (2669, 9540, 2, 'Visa detaljer');
INSERT INTO `lang_definitions` VALUES (2670, 9569, 2, 'Visa rapport');
INSERT INTO `lang_definitions` VALUES (2671, 9580, 2, 'Visa endast icke fakturerad');
INSERT INTO `lang_definitions` VALUES (2672, 9595, 2, 'Syskon');
INSERT INTO `lang_definitions` VALUES (2673, 9606, 2, 'Underskrift');
INSERT INTO `lang_definitions` VALUES (2674, 9609, 2, 'Underskrift:');
INSERT INTO `lang_definitions` VALUES (2675, 9614, 2, 'Betydande Svullnad:');
INSERT INTO `lang_definitions` VALUES (2676, 9622, 2, 'Singel');
INSERT INTO `lang_definitions` VALUES (2677, 9643, 2, 'Storlek');
INSERT INTO `lang_definitions` VALUES (2678, 9648, 2, 'Storlek / Lista');
INSERT INTO `lang_definitions` VALUES (2679, 9650, 2, 'Hud');
INSERT INTO `lang_definitions` VALUES (2680, 9665, 2, 'sömn mönster');
INSERT INTO `lang_definitions` VALUES (2681, 9666, 2, 'sover');
INSERT INTO `lang_definitions` VALUES (2682, 9729, 2, 'Social History:');
INSERT INTO `lang_definitions` VALUES (2683, 9732, 2, 'lösning');
INSERT INTO `lang_definitions` VALUES (2684, 9737, 2, 'Vissa möten visas inte. Klicka här för att visa alla.');
INSERT INTO `lang_definitions` VALUES (2685, 9740, 2, 'Vissa anteckningar visades inte');
INSERT INTO `lang_definitions` VALUES (2686, 9743, 2, 'några ord');
INSERT INTO `lang_definitions` VALUES (2687, 9758, 2, 'Sortera efter');
INSERT INTO `lang_definitions` VALUES (2688, 9779, 2, 'Källa');
INSERT INTO `lang_definitions` VALUES (2689, 9783, 2, 'Källa saknas för kod');
INSERT INTO `lang_definitions` VALUES (2690, 9789, 2, 'Källa:');
INSERT INTO `lang_definitions` VALUES (2691, 9802, 2, 'Specialist namn och signatur');
INSERT INTO `lang_definitions` VALUES (2692, 9804, 2, 'Specialtet');
INSERT INTO `lang_definitions` VALUES (2693, 9806, 2, 'Specialitet:');
INSERT INTO `lang_definitions` VALUES (2694, 9807, 2, 'Särskilda');
INSERT INTO `lang_definitions` VALUES (2695, 9811, 2, 'Särskilda tjänster');
INSERT INTO `lang_definitions` VALUES (2696, 9827, 2, 'Tal diktamen');
INSERT INTO `lang_definitions` VALUES (2697, 9828, 2, 'Spermiedödande');
INSERT INTO `lang_definitions` VALUES (2698, 9832, 2, 'Maka');
INSERT INTO `lang_definitions` VALUES (2699, 9835, 2, 'Sputum:');
INSERT INTO `lang_definitions` VALUES (2700, 9849, 2, 'Personnummmer');
INSERT INTO `lang_definitions` VALUES (2701, 9851, 2, 'Persnr');
INSERT INTO `lang_definitions` VALUES (2702, 9852, 2, 'Stabilitet');
INSERT INTO `lang_definitions` VALUES (2703, 9855, 2, 'Standard');
INSERT INTO `lang_definitions` VALUES (2704, 9866, 2, 'Start');
INSERT INTO `lang_definitions` VALUES (2705, 9867, 2, 'Start (åååå-mm-dd):');
INSERT INTO `lang_definitions` VALUES (2706, 9874, 2, 'Startdatum');
INSERT INTO `lang_definitions` VALUES (2707, 9876, 2, 'Start datum vid denna klinik');
INSERT INTO `lang_definitions` VALUES (2708, 9878, 2, 'Startdatum:');
INSERT INTO `lang_definitions` VALUES (2709, 9879, 2, 'Startdatum:');
INSERT INTO `lang_definitions` VALUES (2710, 9881, 2, 'Start tid');
INSERT INTO `lang_definitions` VALUES (2711, 9884, 2, 'Startdatum');
INSERT INTO `lang_definitions` VALUES (2712, 9889, 2, 'Stat');
INSERT INTO `lang_definitions` VALUES (2713, 9898, 2, 'församling');
INSERT INTO `lang_definitions` VALUES (2714, 9909, 2, 'Statistik');
INSERT INTO `lang_definitions` VALUES (2715, 9910, 2, 'Övrigt');
INSERT INTO `lang_definitions` VALUES (2716, 9911, 2, 'Status');
INSERT INTO `lang_definitions` VALUES (2717, 9916, 2, 'Oförändrat');
INSERT INTO `lang_definitions` VALUES (2718, 9932, 2, 'Stela leder');
INSERT INTO `lang_definitions` VALUES (2719, 9936, 2, 'Ont i magen');
INSERT INTO `lang_definitions` VALUES (2720, 9944, 2, 'Överbelastade muskler');
INSERT INTO `lang_definitions` VALUES (2721, 9947, 2, 'Gata');
INSERT INTO `lang_definitions` VALUES (2722, 9949, 2, 'Gatu nummer');
INSERT INTO `lang_definitions` VALUES (2723, 9950, 2, 'styrka');
INSERT INTO `lang_definitions` VALUES (2724, 9953, 2, 'Stress fraktur');
INSERT INTO `lang_definitions` VALUES (2725, 9954, 2, 'Stresstest');
INSERT INTO `lang_definitions` VALUES (2726, 9956, 2, 'Stroke');
INSERT INTO `lang_definitions` VALUES (2727, 9966, 2, 'Delsumma');
INSERT INTO `lang_definitions` VALUES (2728, 9967, 2, 'Underkategori');
INSERT INTO `lang_definitions` VALUES (2729, 9968, 2, 'underkategori');
INSERT INTO `lang_definitions` VALUES (2730, 9969, 2, 'subkutant');
INSERT INTO `lang_definitions` VALUES (2731, 9971, 2, 'Anamnes');
INSERT INTO `lang_definitions` VALUES (2732, 9972, 2, 'Sublingual');
INSERT INTO `lang_definitions` VALUES (2733, 9973, 2, 'sublingual');
INSERT INTO `lang_definitions` VALUES (2734, 9974, 2, 'Lämna in');
INSERT INTO `lang_definitions` VALUES (2735, 9979, 2, 'Lämna in händelsen');
INSERT INTO `lang_definitions` VALUES (2736, 9980, 2, 'lämna in blanketten');
INSERT INTO `lang_definitions` VALUES (2737, 9985, 2, 'Inlämnat av');
INSERT INTO `lang_definitions` VALUES (2738, 9987, 2, 'Prenuremant');
INSERT INTO `lang_definitions` VALUES (2739, 9988, 2, 'Prenuremants Adress');
INSERT INTO `lang_definitions` VALUES (2740, 10020, 2, 'Ersättare');
INSERT INTO `lang_definitions` VALUES (2741, 10021, 2, 'Ersättare tillåts');
INSERT INTO `lang_definitions` VALUES (2742, 10049, 2, 'Självmord');
INSERT INTO `lang_definitions` VALUES (2743, 10051, 2, 'Sammanfattning');
INSERT INTO `lang_definitions` VALUES (2744, 10058, 2, 'Sön');
INSERT INTO `lang_definitions` VALUES (2745, 10060, 2, 'Söndag');
INSERT INTO `lang_definitions` VALUES (2746, 10093, 2, 'Kirurgi');
INSERT INTO `lang_definitions` VALUES (2747, 10095, 2, 'avstänga');
INSERT INTO `lang_definitions` VALUES (2748, 10096, 2, 'Uppslammad vätska');
INSERT INTO `lang_definitions` VALUES (2749, 10103, 2, 'Svenska');
INSERT INTO `lang_definitions` VALUES (2750, 10130, 2, '3 ggr/dag');
INSERT INTO `lang_definitions` VALUES (2751, 10137, 2, 'Tabell skapas inte');
INSERT INTO `lang_definitions` VALUES (2752, 10138, 2, 'Tabell uppdateringen misslyckades');
INSERT INTO `lang_definitions` VALUES (2753, 10140, 2, 'tablett');
INSERT INTO `lang_definitions` VALUES (2754, 10149, 2, 'Ta');
INSERT INTO `lang_definitions` VALUES (2755, 10154, 2, 'Tar lång tid');
INSERT INTO `lang_definitions` VALUES (2756, 10175, 2, 'Skatter');
INSERT INTO `lang_definitions` VALUES (2757, 10197, 2, 'Mall');
INSERT INTO `lang_definitions` VALUES (2758, 10201, 2, 'Mall:');
INSERT INTO `lang_definitions` VALUES (2759, 10219, 2, 'Testa schema');
INSERT INTO `lang_definitions` VALUES (2760, 10220, 2, 'Testa system');
INSERT INTO `lang_definitions` VALUES (2761, 10242, 2, 'Tack');
INSERT INTO `lang_definitions` VALUES (2762, 10284, 2, 'Påstående ärendet:');
INSERT INTO `lang_definitions` VALUES (2763, 10350, 2, 'Händelsen har godkänts.');
INSERT INTO `lang_definitions` VALUES (2764, 10351, 2, 'Händelsen har gömts undan');
INSERT INTO `lang_definitions` VALUES (2765, 10380, 2, 'Följande kalenderhändelse har lagts till:');
INSERT INTO `lang_definitions` VALUES (2766, 10381, 2, 'Följande kalenderhändelse har modifierats:');
INSERT INTO `lang_definitions` VALUES (2767, 10601, 2, 'Terapeutiska Injektioner');
INSERT INTO `lang_definitions` VALUES (2768, 10611, 2, 'Det är fel med din ansökan. Dessa beskrivs nedan.');
INSERT INTO `lang_definitions` VALUES (2769, 10621, 2, 'Det finns inga nya synpunkter');
INSERT INTO `lang_definitions` VALUES (2770, 10656, 2, 'Det uppstod ett fel när din begäran behandlades.');
INSERT INTO `lang_definitions` VALUES (2771, 10682, 2, 'Förtjockad Höger:');
INSERT INTO `lang_definitions` VALUES (2772, 10683, 2, 'Lår');
INSERT INTO `lang_definitions` VALUES (2773, 10684, 2, 'Lår + knäsena');
INSERT INTO `lang_definitions` VALUES (2774, 10701, 2, 'Tredje');
INSERT INTO `lang_definitions` VALUES (2775, 10734, 2, 'Pågående besök');
INSERT INTO `lang_definitions` VALUES (2776, 10753, 2, 'Detta fakturanumret har ändrats till');
INSERT INTO `lang_definitions` VALUES (2777, 10804, 2, 'Denna patient har ingen aktivitet');
INSERT INTO `lang_definitions` VALUES (2778, 10805, 2, 'Denna patients ID används redan!');
INSERT INTO `lang_definitions` VALUES (2779, 10882, 2, 'Tor');
INSERT INTO `lang_definitions` VALUES (2780, 10884, 2, 'torsdag');
INSERT INTO `lang_definitions` VALUES (2781, 10885, 2, 'Torsdag');
INSERT INTO `lang_definitions` VALUES (2782, 10887, 2, 'Sköldkörtel normal');
INSERT INTO `lang_definitions` VALUES (2783, 10902, 2, 'Tid');
INSERT INTO `lang_definitions` VALUES (2784, 10913, 2, 'beräkna tid på händelse');
INSERT INTO `lang_definitions` VALUES (2785, 10915, 2, 'Tidsstämpel och Text');
INSERT INTO `lang_definitions` VALUES (2786, 10920, 2, 'Titel');
INSERT INTO `lang_definitions` VALUES (2787, 10928, 2, 'Till');
INSERT INTO `lang_definitions` VALUES (2788, 10929, 2, 'till');
INSERT INTO `lang_definitions` VALUES (2789, 10930, 2, 'TILL');
INSERT INTO `lang_definitions` VALUES (2790, 10938, 2, 'På det påverkade området');
INSERT INTO `lang_definitions` VALUES (2791, 10939, 2, 'på det påverkade området');
INSERT INTO `lang_definitions` VALUES (2792, 10945, 2, 'till kategori');
INSERT INTO `lang_definitions` VALUES (2793, 10949, 2, 'Till medbetalare');
INSERT INTO `lang_definitions` VALUES (2794, 10972, 2, 'Till Besök');
INSERT INTO `lang_definitions` VALUES (2795, 10973, 2, 'Om du vill filtrera efter kön');
INSERT INTO `lang_definitions` VALUES (2796, 10980, 2, 'Till Historik');
INSERT INTO `lang_definitions` VALUES (2797, 10982, 2, 'Till frågor');
INSERT INTO `lang_definitions` VALUES (2798, 10985, 2, 'För att länka detta besök till objekt i ovanstående lista, markera önskade objekt och klicka sedan på [spara]. Håll ner [Ctrl] för att markera fler objekt.');
INSERT INTO `lang_definitions` VALUES (2799, 10987, 2, 'för att logga in igen');
INSERT INTO `lang_definitions` VALUES (2800, 11002, 2, 'Huden');
INSERT INTO `lang_definitions` VALUES (2801, 11003, 2, 'huden');
INSERT INTO `lang_definitions` VALUES (2802, 11005, 2, 'Till detta besök?');
INSERT INTO `lang_definitions` VALUES (2803, 11010, 2, 'Till:');
INSERT INTO `lang_definitions` VALUES (2804, 11011, 2, 'Till:');
INSERT INTO `lang_definitions` VALUES (2805, 11025, 2, 'Tobak');
INSERT INTO `lang_definitions` VALUES (2806, 11028, 2, 'Tobaks användande');
INSERT INTO `lang_definitions` VALUES (2807, 11032, 2, 'Idag');
INSERT INTO `lang_definitions` VALUES (2808, 11037, 2, 'Dagens datum');
INSERT INTO `lang_definitions` VALUES (2809, 11038, 2, 'Dagens händelser');
INSERT INTO `lang_definitions` VALUES (2810, 11047, 2, 'Tonsillektomi');
INSERT INTO `lang_definitions` VALUES (2811, 11050, 2, 'Topp');
INSERT INTO `lang_definitions` VALUES (2812, 11053, 2, 'Ämne');
INSERT INTO `lang_definitions` VALUES (2813, 11054, 2, 'Totalt');
INSERT INTO `lang_definitions` VALUES (2814, 11055, 2, 'totalt');
INSERT INTO `lang_definitions` VALUES (2815, 11061, 2, 'Sammanlagt belopp som betalats');
INSERT INTO `lang_definitions` VALUES (2816, 11064, 2, 'Totala kostnader');
INSERT INTO `lang_definitions` VALUES (2817, 11065, 2, 'Totalt antal Kunder');
INSERT INTO `lang_definitions` VALUES (2818, 11072, 2, 'Totalt för');
INSERT INTO `lang_definitions` VALUES (2819, 11073, 2, 'Totalt för');
INSERT INTO `lang_definitions` VALUES (2820, 11074, 2, 'Totalt för kategori');
INSERT INTO `lang_definitions` VALUES (2821, 11084, 2, 'Totalt antal patienter');
INSERT INTO `lang_definitions` VALUES (2822, 11106, 2, 'Totalt');
INSERT INTO `lang_definitions` VALUES (2823, 11107, 2, 'Totalbeloppen för');
INSERT INTO `lang_definitions` VALUES (2824, 11108, 2, 'Totalbeloppen för');
INSERT INTO `lang_definitions` VALUES (2825, 11135, 2, 'Utbildnings sort');
INSERT INTO `lang_definitions` VALUES (2826, 11136, 2, 'Remiss m.m.');
INSERT INTO `lang_definitions` VALUES (2827, 11137, 2, 'Transaktion');
INSERT INTO `lang_definitions` VALUES (2828, 11138, 2, 'Transaktion');
INSERT INTO `lang_definitions` VALUES (2829, 11142, 2, 'Transaktionstyp');
INSERT INTO `lang_definitions` VALUES (2830, 11143, 2, 'Transaktioner');
INSERT INTO `lang_definitions` VALUES (2831, 11145, 2, 'Transaktioner (skriva valfritt)');
INSERT INTO `lang_definitions` VALUES (2832, 11151, 2, 'Transaktioner / Övergångar');
INSERT INTO `lang_definitions` VALUES (2833, 11169, 2, 'översätt detta');
INSERT INTO `lang_definitions` VALUES (2834, 11170, 2, 'översätta');
INSERT INTO `lang_definitions` VALUES (2835, 11179, 2, 'Trauma');
INSERT INTO `lang_definitions` VALUES (2836, 11182, 2, 'Behandlings mål');
INSERT INTO `lang_definitions` VALUES (2837, 11183, 2, 'Behandlings plan');
INSERT INTO `lang_definitions` VALUES (2838, 11186, 2, 'Behandling:');
INSERT INTO `lang_definitions` VALUES (2839, 11187, 2, 'Behandling:');
INSERT INTO `lang_definitions` VALUES (2840, 11205, 2, 'tesked');
INSERT INTO `lang_definitions` VALUES (2841, 11209, 2, 'Tis');
INSERT INTO `lang_definitions` VALUES (2842, 11211, 2, 'Tisdag');
INSERT INTO `lang_definitions` VALUES (2843, 11212, 2, 'Tumör');
INSERT INTO `lang_definitions` VALUES (2844, 11222, 2, 'två gånger dagligen');
INSERT INTO `lang_definitions` VALUES (2845, 11227, 2, 'Typ');
INSERT INTO `lang_definitions` VALUES (2846, 11243, 2, 'Skriv in eller skanna patientidentifikation här');
INSERT INTO `lang_definitions` VALUES (2847, 11272, 2, 'Ulcerations');
INSERT INTO `lang_definitions` VALUES (2848, 11273, 2, 'Ulcerös kolit');
INSERT INTO `lang_definitions` VALUES (2849, 11274, 2, 'Sår:');
INSERT INTO `lang_definitions` VALUES (2850, 11292, 2, 'Ej tilldelad');
INSERT INTO `lang_definitions` VALUES (2851, 11295, 2, 'Obehörig åtkomst.');
INSERT INTO `lang_definitions` VALUES (2852, 11300, 2, 'under tungan');
INSERT INTO `lang_definitions` VALUES (2853, 11303, 2, 'Undervikt');
INSERT INTO `lang_definitions` VALUES (2854, 11304, 2, 'odiagnosticerad');
INSERT INTO `lang_definitions` VALUES (2855, 11309, 2, 'Ångra Kassa');
INSERT INTO `lang_definitions` VALUES (2856, 11311, 2, 'Unika Kunder');
INSERT INTO `lang_definitions` VALUES (2857, 11315, 2, 'Unika nya kunder');
INSERT INTO `lang_definitions` VALUES (2858, 11320, 2, 'Enhet');
INSERT INTO `lang_definitions` VALUES (2859, 11321, 2, 'Enheter');
INSERT INTO `lang_definitions` VALUES (2860, 11322, 2, 'enheter');
INSERT INTO `lang_definitions` VALUES (2861, 11328, 2, 'Okänt');
INSERT INTO `lang_definitions` VALUES (2862, 11332, 2, 'Okänd eller N / A');
INSERT INTO `lang_definitions` VALUES (2863, 11345, 2, 'Namnlöst försäkringsbolag');
INSERT INTO `lang_definitions` VALUES (2864, 11346, 2, 'Oregistrerad');
INSERT INTO `lang_definitions` VALUES (2865, 11349, 2, 'Avmarkera alla');
INSERT INTO `lang_definitions` VALUES (2866, 11350, 2, 'Omarkerat');
INSERT INTO `lang_definitions` VALUES (2867, 11351, 2, 'Ospecificerad');
INSERT INTO `lang_definitions` VALUES (2868, 11356, 2, 'tills');
INSERT INTO `lang_definitions` VALUES (2869, 11360, 2, 'Outnyttjad');
INSERT INTO `lang_definitions` VALUES (2870, 11362, 2, 'Upp till');
INSERT INTO `lang_definitions` VALUES (2871, 11364, 2, 'Kommande möten');
INSERT INTO `lang_definitions` VALUES (2872, 11365, 2, 'Kommande evenemang');
INSERT INTO `lang_definitions` VALUES (2873, 11366, 2, 'Uppdatera');
INSERT INTO `lang_definitions` VALUES (2874, 11367, 2, 'uppdatera');
INSERT INTO `lang_definitions` VALUES (2875, 11371, 2, 'Uppdateringsfilerna');
INSERT INTO `lang_definitions` VALUES (2876, 11372, 2, 'Uppdatera Info');
INSERT INTO `lang_definitions` VALUES (2877, 11401, 2, 'Uppladdning');
INSERT INTO `lang_definitions` VALUES (2878, 11407, 2, 'Ladda upp dokument');
INSERT INTO `lang_definitions` VALUES (2879, 11411, 2, 'Ladda upp fil att importera:');
INSERT INTO `lang_definitions` VALUES (2880, 11415, 2, 'Ladda upp rapport');
INSERT INTO `lang_definitions` VALUES (2881, 11418, 2, 'Ladda upp den här filen:');
INSERT INTO `lang_definitions` VALUES (2882, 11429, 2, 'Överarmen');
INSERT INTO `lang_definitions` VALUES (2883, 11432, 2, 'Brådskande');
INSERT INTO `lang_definitions` VALUES (2884, 11438, 2, 'Urin Frekvens');
INSERT INTO `lang_definitions` VALUES (2885, 11439, 2, 'Urin Tveksamhet');
INSERT INTO `lang_definitions` VALUES (2886, 11443, 2, 'URL');
INSERT INTO `lang_definitions` VALUES (2887, 11457, 2, 'Använd 24-timmars format?');
INSERT INTO `lang_definitions` VALUES (2888, 11477, 2, 'Använd Standardinställningar');
INSERT INTO `lang_definitions` VALUES (2889, 11479, 2, 'Använd internationellt utseende på datum?');
INSERT INTO `lang_definitions` VALUES (2890, 11493, 2, 'Använd ämnen?');
INSERT INTO `lang_definitions` VALUES (2891, 11496, 2, 'Användare');
INSERT INTO `lang_definitions` VALUES (2892, 11499, 2, 'Användaradministration');
INSERT INTO `lang_definitions` VALUES (2893, 11500, 2, 'Användar-och Facility Administration');
INSERT INTO `lang_definitions` VALUES (2894, 11501, 2, 'Användare och grupp Administration');
INSERT INTO `lang_definitions` VALUES (2895, 11507, 2, 'Användardefinierad');
INSERT INTO `lang_definitions` VALUES (2896, 11508, 2, 'Användar definierad Area 11');
INSERT INTO `lang_definitions` VALUES (2897, 11509, 2, 'Användar definierad Area 12');
INSERT INTO `lang_definitions` VALUES (2898, 11533, 2, 'Användare Medlemskap');
INSERT INTO `lang_definitions` VALUES (2899, 11553, 2, 'Användarnamn');
INSERT INTO `lang_definitions` VALUES (2900, 11556, 2, 'Användarnamn för SMS Gateway');
INSERT INTO `lang_definitions` VALUES (2901, 11559, 2, 'Användarnamn:');
INSERT INTO `lang_definitions` VALUES (2902, 11560, 2, 'Användare');
INSERT INTO `lang_definitions` VALUES (2903, 11564, 2, 'Användare / grupper / Logs Administration');
INSERT INTO `lang_definitions` VALUES (2904, 11588, 2, 'SEMESTER');
INSERT INTO `lang_definitions` VALUES (2905, 11589, 2, 'Semester');
INSERT INTO `lang_definitions` VALUES (2906, 11590, 2, 'Vaccin');
INSERT INTO `lang_definitions` VALUES (2907, 11609, 2, 'Wert');
INSERT INTO `lang_definitions` VALUES (2908, 11610, 2, 'Wert 1');
INSERT INTO `lang_definitions` VALUES (2909, 11611, 2, 'Wert 2');
INSERT INTO `lang_definitions` VALUES (2910, 11613, 2, 'Wert muss numerisch sein');
INSERT INTO `lang_definitions` VALUES (2911, 11623, 2, 'Blodkärls kondition');
INSERT INTO `lang_definitions` VALUES (2912, 11624, 2, 'Blodkärsl skada');
INSERT INTO `lang_definitions` VALUES (2913, 11625, 2, 'Kärlkirurgi');
INSERT INTO `lang_definitions` VALUES (2914, 11634, 2, 'Version');
INSERT INTO `lang_definitions` VALUES (2915, 11653, 2, 'Svindel');
INSERT INTO `lang_definitions` VALUES (2916, 11667, 2, 'Visa');
INSERT INTO `lang_definitions` VALUES (2917, 11668, 2, 'visa');
INSERT INTO `lang_definitions` VALUES (2918, 11670, 2, 'Visa allergier');
INSERT INTO `lang_definitions` VALUES (2919, 11676, 2, 'Visa Omfattande Patient Rapport');
INSERT INTO `lang_definitions` VALUES (2920, 11679, 2, 'Visa dokument');
INSERT INTO `lang_definitions` VALUES (2921, 11681, 2, 'Visa möte');
INSERT INTO `lang_definitions` VALUES (2922, 11683, 2, 'Visa händelser i ett popup-fönster?');
INSERT INTO `lang_definitions` VALUES (2923, 11690, 2, 'Visa Sida 1');
INSERT INTO `lang_definitions` VALUES (2924, 11691, 2, 'Visa sida 2');
INSERT INTO `lang_definitions` VALUES (2925, 11700, 2, 'Se relaterade möten');
INSERT INTO `lang_definitions` VALUES (2926, 11717, 2, 'Visa:');
INSERT INTO `lang_definitions` VALUES (2927, 11718, 2, 'VISA');
INSERT INTO `lang_definitions` VALUES (2928, 11719, 2, 'VISA/MC/AMEX/Dis');
INSERT INTO `lang_definitions` VALUES (2929, 11721, 2, 'Visceral skada / trauma / kirurgi');
INSERT INTO `lang_definitions` VALUES (2930, 11728, 2, 'Besökskategori:');
INSERT INTO `lang_definitions` VALUES (2931, 11729, 2, 'Besöks Datum');
INSERT INTO `lang_definitions` VALUES (2932, 11745, 2, 'Besök');
INSERT INTO `lang_definitions` VALUES (2933, 11746, 2, 'Besök från');
INSERT INTO `lang_definitions` VALUES (2934, 11751, 2, 'Vitalparametrar');
INSERT INTO `lang_definitions` VALUES (2935, 11752, 2, 'Vitalparametrar');
INSERT INTO `lang_definitions` VALUES (2936, 11753, 2, 'Vitalparametrar (metriska)');
INSERT INTO `lang_definitions` VALUES (2937, 11754, 2, 'Vitalparametrar Formulär inställningar');
INSERT INTO `lang_definitions` VALUES (2938, 11763, 2, 'Kräkningar');
INSERT INTO `lang_definitions` VALUES (2939, 11767, 2, 'W');
INSERT INTO `lang_definitions` VALUES (2940, 11772, 2, 'Väntar');
INSERT INTO `lang_definitions` VALUES (2941, 11783, 2, 'Varm');
INSERT INTO `lang_definitions` VALUES (2942, 11787, 2, 'VARNING');
INSERT INTO `lang_definitions` VALUES (2943, 11791, 2, 'Varning: Ett besök var redan skapat för denna patient idag!');
INSERT INTO `lang_definitions` VALUES (2944, 11796, 2, 'Varning: patient-ID är inte unikt!');
INSERT INTO `lang_definitions` VALUES (2945, 11821, 2, 'Svaghet');
INSERT INTO `lang_definitions` VALUES (2946, 11827, 2, 'Hemsida');
INSERT INTO `lang_definitions` VALUES (2947, 11832, 2, 'Ons');
INSERT INTO `lang_definitions` VALUES (2948, 11833, 2, 'Onsdag');
INSERT INTO `lang_definitions` VALUES (2949, 11834, 2, 'Vecka');
INSERT INTO `lang_definitions` VALUES (2950, 11835, 2, 'vecka');
INSERT INTO `lang_definitions` VALUES (2951, 11836, 2, 'Veckovy');
INSERT INTO `lang_definitions` VALUES (2952, 11837, 2, 'Veckan (s)');
INSERT INTO `lang_definitions` VALUES (2953, 11841, 2, 'Vikt');
INSERT INTO `lang_definitions` VALUES (2954, 11844, 2, 'Vikt förändring');
INSERT INTO `lang_definitions` VALUES (2955, 11845, 2, 'Viktminskning');
INSERT INTO `lang_definitions` VALUES (2956, 11862, 2, 'Vad är det som räknas?');
INSERT INTO `lang_definitions` VALUES (2957, 11866, 2, 'Wheezing:');
INSERT INTO `lang_definitions` VALUES (2958, 11890, 2, 'Whiplash');
INSERT INTO `lang_definitions` VALUES (2959, 11894, 2, 'Vem');
INSERT INTO `lang_definitions` VALUES (2960, 11895, 2, 'Vem har svarat?');
INSERT INTO `lang_definitions` VALUES (2961, 11897, 2, 'Änka/änkeman');
INSERT INTO `lang_definitions` VALUES (2962, 11898, 2, 'Vidd');
INSERT INTO `lang_definitions` VALUES (2963, 11900, 2, 'Vidd i punkter på vänstra navigeringsfönstret');
INSERT INTO `lang_definitions` VALUES (2964, 11907, 2, 'Med vald:');
INSERT INTO `lang_definitions` VALUES (2965, 11908, 2, 'med det gamla namnet');
INSERT INTO `lang_definitions` VALUES (2966, 11911, 2, 'Med vem kan vi lämna ett meddelande?');
INSERT INTO `lang_definitions` VALUES (2967, 11912, 2, 'Återtagen/innehållen');
INSERT INTO `lang_definitions` VALUES (2968, 11913, 2, 'inom några timmar');
INSERT INTO `lang_definitions` VALUES (2969, 11914, 2, 'inom några timmar:');
INSERT INTO `lang_definitions` VALUES (2970, 11915, 2, 'inom några minuter');
INSERT INTO `lang_definitions` VALUES (2971, 11916, 2, 'inom några minuter:');
INSERT INTO `lang_definitions` VALUES (2972, 11919, 2, 'Utan Updatering');
INSERT INTO `lang_definitions` VALUES (2973, 11920, 2, 'vittne');
INSERT INTO `lang_definitions` VALUES (2974, 11924, 2, 'Kvinnor');
INSERT INTO `lang_definitions` VALUES (2975, 11925, 2, 'Enbart kvinnor');
INSERT INTO `lang_definitions` VALUES (2976, 11927, 2, 'Arbete');
INSERT INTO `lang_definitions` VALUES (2977, 11929, 2, 'Telefon, arbete');
INSERT INTO `lang_definitions` VALUES (2978, 11930, 2, 'Telefon, Arbete, Nummer');
INSERT INTO `lang_definitions` VALUES (2979, 11931, 2, 'Arbetsrelaterat?');
INSERT INTO `lang_definitions` VALUES (2980, 11932, 2, 'Arbete/ Utbildning/ Hobby');
INSERT INTO `lang_definitions` VALUES (2981, 11933, 2, 'Arbete / Skola Anmärkning');
INSERT INTO `lang_definitions` VALUES (2982, 11934, 2, 'arbetsdag');
INSERT INTO `lang_definitions` VALUES (2983, 11941, 2, 'förvärrad');
INSERT INTO `lang_definitions` VALUES (2984, 11953, 2, 'Handled');
INSERT INTO `lang_definitions` VALUES (2985, 11954, 2, 'Handled och hand');
INSERT INTO `lang_definitions` VALUES (2986, 11955, 2, 'Handleds Problem');
INSERT INTO `lang_definitions` VALUES (2987, 11956, 2, 'skriv');
INSERT INTO `lang_definitions` VALUES (2988, 11958, 2, 'avskriva');
INSERT INTO `lang_definitions` VALUES (2989, 11967, 2, 'x inställt');
INSERT INTO `lang_definitions` VALUES (2990, 11969, 2, 'Röntgen');
INSERT INTO `lang_definitions` VALUES (2991, 11970, 2, 'Röntgen Tolkning:');
INSERT INTO `lang_definitions` VALUES (2992, 11971, 2, 'Röntgen Tolkning:');
INSERT INTO `lang_definitions` VALUES (2993, 11975, 2, 'Endast X12: Ersättningskrav');
INSERT INTO `lang_definitions` VALUES (2994, 11978, 2, 'X12 Partner');
INSERT INTO `lang_definitions` VALUES (2995, 11979, 2, 'X12 Partners');
INSERT INTO `lang_definitions` VALUES (2996, 11987, 2, 'Y');
INSERT INTO `lang_definitions` VALUES (2997, 11988, 2, 'år');
INSERT INTO `lang_definitions` VALUES (2998, 11989, 2, 'År');
INSERT INTO `lang_definitions` VALUES (2999, 11990, 2, 'År Visa');
INSERT INTO `lang_definitions` VALUES (3000, 11991, 2, 'År');
INSERT INTO `lang_definitions` VALUES (3001, 11996, 2, 'Ja');
INSERT INTO `lang_definitions` VALUES (3002, 11997, 2, 'JA');
INSERT INTO `lang_definitions` VALUES (3003, 11998, 2, 'ja');
INSERT INTO `lang_definitions` VALUES (3004, 11999, 2, 'JA!');
INSERT INTO `lang_definitions` VALUES (3005, 12000, 2, 'Ja, radera och logga');
INSERT INTO `lang_definitions` VALUES (3006, 12002, 2, 'Ja/Nej');
INSERT INTO `lang_definitions` VALUES (3007, 12003, 2, 'Ja:');
INSERT INTO `lang_definitions` VALUES (3008, 12008, 2, 'Du håller på att permanent ersätta den befintliga mallen. Är du säker på att du vill fortsätta?');
INSERT INTO `lang_definitions` VALUES (3009, 12012, 2, 'Det är inte tillåtet att ta bort denna händelse');
INSERT INTO `lang_definitions` VALUES (3010, 12013, 2, 'Du har inte tillåtelse att redigera den här händelsen');
INSERT INTO `lang_definitions` VALUES (3011, 12014, 2, 'Du har inte behörighet för detta.');
INSERT INTO `lang_definitions` VALUES (3012, 12016, 2, 'Du har inte behörighet att komma åt den här gruppen.');
INSERT INTO `lang_definitions` VALUES (3013, 12017, 2, 'Du har inte behörighet att lägga till / redigera frågor');
INSERT INTO `lang_definitions` VALUES (3014, 12019, 2, 'Du har inte behörighet att se det här mötet.');
INSERT INTO `lang_definitions` VALUES (3015, 12038, 2, 'Du kan inte komma åt denna funktion direkt.');
INSERT INTO `lang_definitions` VALUES (3016, 12050, 2, 'Du kan inte komma åt den här sidan direkt.');
INSERT INTO `lang_definitions` VALUES (3017, 12057, 2, 'Du har inte valt några åtgärder.');
INSERT INTO `lang_definitions` VALUES (3018, 12058, 2, 'Du har inte behörighet att se / redigera denna anmärkning');
INSERT INTO `lang_definitions` VALUES (3019, 12090, 2, 'Du måste först välja eller lägga till en patient.');
INSERT INTO `lang_definitions` VALUES (3020, 12091, 2, 'Du måste först välja eller skapa ett möte.');
INSERT INTO `lang_definitions` VALUES (3021, 12094, 2, 'Du måste välja några områden för att fortsätta.');
INSERT INTO `lang_definitions` VALUES (3022, 12122, 2, 'Ditt slutdatum är ogiltig');
INSERT INTO `lang_definitions` VALUES (3023, 12123, 2, 'Din händelse har strukits.');
INSERT INTO `lang_definitions` VALUES (3024, 12124, 2, 'Din händelse har ändrats.');
INSERT INTO `lang_definitions` VALUES (3025, 12125, 2, 'Din händelse har lämnats in.');
INSERT INTO `lang_definitions` VALUES (3026, 12132, 2, 'Din namnlista har ändrats för att uppfylla namngivnings krav.');
INSERT INTO `lang_definitions` VALUES (3027, 12146, 2, 'Din Post Kalender konfiguration har återställts att använda standardvärden.');
INSERT INTO `lang_definitions` VALUES (3028, 12147, 2, 'Din Post Kalender konfiguration har uppdaterats.');
INSERT INTO `lang_definitions` VALUES (3029, 12148, 2, 'Den upprepade frekvens måste vara ett heltal.');
INSERT INTO `lang_definitions` VALUES (3030, 12149, 2, 'Den upprepade frekvensen måste vara minst 1.');
INSERT INTO `lang_definitions` VALUES (3031, 12151, 2, 'Ditt startdatum är större än ditt slutdatum');
INSERT INTO `lang_definitions` VALUES (3032, 12152, 2, 'Ditt startdatum är ogiltig');
INSERT INTO `lang_definitions` VALUES (3033, 12153, 2, 'Ditt förslag misslyckats.');
INSERT INTO `lang_definitions` VALUES (3034, 12156, 2, 'åååå-mm-dd');
INSERT INTO `lang_definitions` VALUES (3035, 12158, 2, 'åååå-mm-dd dag är förknippade med detta dokument');
INSERT INTO `lang_definitions` VALUES (3036, 12160, 2, 'åååå-mm-dd födelsedatum');
INSERT INTO `lang_definitions` VALUES (3037, 12161, 2, 'åååå-mm-dd Födelsedatum');
INSERT INTO `lang_definitions` VALUES (3038, 12162, 2, 'ååå-mm-dd datum för utlöpande');
INSERT INTO `lang_definitions` VALUES (3039, 12163, 2, 'åååå-mm-dd Datum för uppkomsten eller sjukhusvistelse');
INSERT INTO `lang_definitions` VALUES (3040, 12164, 2, 'åååå-mm-dd datum debut, kirurgi eller början av medicinering');
INSERT INTO `lang_definitions` VALUES (3041, 12166, 2, 'åååå-mm-dd dagen för tillfrisknande eller slutet av medicinering');
INSERT INTO `lang_definitions` VALUES (3042, 12168, 2, 'åååå-mm-dd Delgivningsdatum');
INSERT INTO `lang_definitions` VALUES (3043, 12169, 2, 'åååå-mm-dd dagen för denna skrivelse');
INSERT INTO `lang_definitions` VALUES (3044, 12171, 2, 'åååå-mm-dd dokumentets datum');
INSERT INTO `lang_definitions` VALUES (3045, 12173, 2, 'åååå-mm-dd händelse datum eller startdatum');
INSERT INTO `lang_definitions` VALUES (3046, 12180, 2, 'åååå-mm-dd sista datum för detta evenemang');
INSERT INTO `lang_definitions` VALUES (3047, 12186, 2, 'noll');
INSERT INTO `lang_definitions` VALUES (3048, 12188, 2, 'postadress');
INSERT INTO `lang_definitions` VALUES (3049, 12189, 2, 'postnummer');
INSERT INTO `lang_definitions` VALUES (3050, 12191, 2, 'land');
INSERT INTO `lang_definitions` VALUES (3051, 12197, 2, 'men var');
INSERT INTO `lang_definitions` VALUES (3052, 12198, 2, 'gick inte att komma åt');
INSERT INTO `lang_definitions` VALUES (3053, 12199, 2, 'Vill du verkligen radera');
INSERT INTO `lang_definitions` VALUES (3054, 12200, 2, 'läkemedel');
INSERT INTO `lang_definitions` VALUES (3055, 12201, 2, 'e-postmeddelande ej skickat');
INSERT INTO `lang_definitions` VALUES (3056, 12202, 2, 'från');
INSERT INTO `lang_definitions` VALUES (3057, 12203, 2, 'har skapats');
INSERT INTO `lang_definitions` VALUES (3058, 12204, 2, 'har återupptagits');
INSERT INTO `lang_definitions` VALUES (3059, 12205, 2, 'Historia');
INSERT INTO `lang_definitions` VALUES (3060, 12206, 2, 'är inget nummer');
INSERT INTO `lang_definitions` VALUES (3061, 12207, 2, 'är redo för ny fakturering');
INSERT INTO `lang_definitions` VALUES (3062, 12208, 2, 'LLL:');
INSERT INTO `lang_definitions` VALUES (3063, 12209, 2, 'Batchnr');
INSERT INTO `lang_definitions` VALUES (3064, 12210, 2, 'Medicaid orginal referensnr.');
INSERT INTO `lang_definitions` VALUES (3065, 12212, 2, 'finns ej!');
INSERT INTO `lang_definitions` VALUES (3066, 12215, 2, 'Tills');
INSERT INTO `lang_definitions` VALUES (3067, 12216, 2, 'Uppdateringen misslyckades, inte i databasen?');
INSERT INTO `lang_definitions` VALUES (3068, 12217, 2, 'präglades som faktureras endast.');
INSERT INTO `lang_definitions` VALUES (3069, 12218, 2, 'var kö framgångsrikt.');
INSERT INTO `lang_definitions` VALUES (3070, 12219, 2, '! Lämnat utan besök');
INSERT INTO `lang_definitions` VALUES (3071, 12220, 2, '\" För kod');
INSERT INTO `lang_definitions` VALUES (3072, 12221, 2, '\" Kontrolleras PostCalendar Inställningar!');
INSERT INTO `lang_definitions` VALUES (3073, 12224, 2, 'kr');
INSERT INTO `lang_definitions` VALUES (3074, 12225, 2, 'Kodningen av kronor är färdig');
INSERT INTO `lang_definitions` VALUES (3075, 12226, 2, '$ etikett (åååå-mm-dd):');
INSERT INTO `lang_definitions` VALUES (3076, 12227, 2, '%');
INSERT INTO `lang_definitions` VALUES (3077, 12229, 2, '% Annullerat <24h');
INSERT INTO `lang_definitions` VALUES (3078, 12230, 2, 'bör finnas, men finns inte.');
INSERT INTO `lang_definitions` VALUES (3079, 12231, 2, '(% Matchar alla strängar, _ matchar alla tecken)');
INSERT INTO `lang_definitions` VALUES (3080, 12233, 2, '(Tillbaka)');
INSERT INTO `lang_definitions` VALUES (3081, 12234, 2, '(Klicka för att redigera)');
INSERT INTO `lang_definitions` VALUES (3082, 12236, 2, '(Mer)');
INSERT INTO `lang_definitions` VALUES (3083, 12237, 2, '(Ny Patient)');
INSERT INTO `lang_definitions` VALUES (3084, 12238, 2, '(Anteckningar och Auktoriseringar)');
INSERT INTO `lang_definitions` VALUES (3085, 12239, 2, '(Patient anteckningar)');
INSERT INTO `lang_definitions` VALUES (3086, 12240, 2, '(Välj ett av dessa, eller skriv din egen rubrik)');
INSERT INTO `lang_definitions` VALUES (3087, 12242, 2, '* Påminnelse skickad');
INSERT INTO `lang_definitions` VALUES (3088, 12243, 2, '** Gör om kirurgi till enheter');
INSERT INTO `lang_definitions` VALUES (3089, 12244, 2, '* Obligatorisk');
INSERT INTO `lang_definitions` VALUES (3090, 12245, 2, '+ Patientkort hämtat');
INSERT INTO `lang_definitions` VALUES (3091, 12249, 2, '- Ingen');
INSERT INTO `lang_definitions` VALUES (3092, 12251, 2, '-- Alla --');
INSERT INTO `lang_definitions` VALUES (3093, 12252, 2, '--Välj uppdrag--');
INSERT INTO `lang_definitions` VALUES (3094, 12253, 2, '.');
INSERT INTO `lang_definitions` VALUES (3095, 12254, 2, '0');
INSERT INTO `lang_definitions` VALUES (3096, 12255, 2, '0-10');
INSERT INTO `lang_definitions` VALUES (3097, 12256, 2, '0-24');
INSERT INTO `lang_definitions` VALUES (3098, 12259, 2, '1');
INSERT INTO `lang_definitions` VALUES (3099, 12260, 2, '46 = Sverige. Se http://www.wtng.info för lista på andra landskoder');
INSERT INTO `lang_definitions` VALUES (3100, 12265, 2, '1.Vila 2. Lägg på is i två dagar 3. Komprimering lämna förbandet på plats om inte foten utvecklar domningar eller blek färg 4. Ha foten och ben i Upphöjt läge.');
INSERT INTO `lang_definitions` VALUES (3101, 12266, 2, '11-14');
INSERT INTO `lang_definitions` VALUES (3102, 12267, 2, '12 hr');
INSERT INTO `lang_definitions` VALUES (3103, 12268, 2, '15-19');
INSERT INTO `lang_definitions` VALUES (3104, 12278, 2, '20-24');
INSERT INTO `lang_definitions` VALUES (3105, 12287, 2, '2111-13');
INSERT INTO `lang_definitions` VALUES (3106, 12290, 2, '25-29');
INSERT INTO `lang_definitions` VALUES (3107, 12293, 2, '2:a');
INSERT INTO `lang_definitions` VALUES (3108, 12297, 2, '3 månader');
INSERT INTO `lang_definitions` VALUES (3109, 12299, 2, '3 gånger dagligen');
INSERT INTO `lang_definitions` VALUES (3110, 12301, 2, '30-34');
INSERT INTO `lang_definitions` VALUES (3111, 12302, 2, '35-39');
INSERT INTO `lang_definitions` VALUES (3112, 12304, 2, '3:e');
INSERT INTO `lang_definitions` VALUES (3113, 12308, 2, '4 månader');
INSERT INTO `lang_definitions` VALUES (3114, 12310, 2, '4 gånger dagligen');
INSERT INTO `lang_definitions` VALUES (3115, 12312, 2, '40-44');
INSERT INTO `lang_definitions` VALUES (3116, 12313, 2, '45');
INSERT INTO `lang_definitions` VALUES (3117, 12323, 2, '4:e');
INSERT INTO `lang_definitions` VALUES (3118, 12331, 2, '5:e');
INSERT INTO `lang_definitions` VALUES (3119, 12333, 2, '6 dagar från nu');
INSERT INTO `lang_definitions` VALUES (3120, 12334, 2, '6 månader');
INSERT INTO `lang_definitions` VALUES (3121, 12335, 2, '6 månader från nu');
INSERT INTO `lang_definitions` VALUES (3122, 12336, 2, '6 veckor från nu');
INSERT INTO `lang_definitions` VALUES (3123, 12337, 2, '6:e');
INSERT INTO `lang_definitions` VALUES (3124, 12339, 2, '7 månader från nu');
INSERT INTO `lang_definitions` VALUES (3125, 12340, 2, '8 månader från nu');
INSERT INTO `lang_definitions` VALUES (3126, 12342, 2, '824.0 Sluten fraktur mediala malleolen');
INSERT INTO `lang_definitions` VALUES (3127, 12343, 2, '824.2 Sluten fraktur laterala malleolen');
INSERT INTO `lang_definitions` VALUES (3128, 12344, 2, '842.6 Sluten trimalleolarfraktur');
INSERT INTO `lang_definitions` VALUES (3129, 12345, 2, '825.32 Fraktur os naviculare (fotled)');
INSERT INTO `lang_definitions` VALUES (3130, 12346, 2, '825.35 Fraktur basen av 5:e metatarsalbenet');
INSERT INTO `lang_definitions` VALUES (3131, 12347, 2, '845.00 Stukad fotled UNS');
INSERT INTO `lang_definitions` VALUES (3132, 12348, 2, '845.01 Stukad fotled deltoideus lig.');
INSERT INTO `lang_definitions` VALUES (3133, 12349, 2, '845.02 Stukad fortled, fc-ligament');
INSERT INTO `lang_definitions` VALUES (3134, 12350, 2, '9 månader från nu');
INSERT INTO `lang_definitions` VALUES (3135, 12351, 2, '99212 Etablerade - okomplicerad');
INSERT INTO `lang_definitions` VALUES (3136, 12352, 2, '99213 Etablerade - Låg komplexitet');
INSERT INTO `lang_definitions` VALUES (3137, 12353, 2, '< I undersökningsrummet');
INSERT INTO `lang_definitions` VALUES (3138, 12357, 2, '> Avslutat');
INSERT INTO `lang_definitions` VALUES (3139, 12359, 2, '?');
INSERT INTO `lang_definitions` VALUES (3140, 12361, 2, '? Har ej dykt upp på avtalad tid');
INSERT INTO `lang_definitions` VALUES (3141, 12362, 2, 'Anlänt');
INSERT INTO `lang_definitions` VALUES (3142, 12364, 2, '[Ändra vy]');
INSERT INTO `lang_definitions` VALUES (3143, 12365, 2, '[Datum för senaste mötet]');
INSERT INTO `lang_definitions` VALUES (3144, 12366, 2, '[Dagar sedan senaste mötet]');
INSERT INTO `lang_definitions` VALUES (3145, 12369, 2, '[rekommenderas inte]');
INSERT INTO `lang_definitions` VALUES (3146, 12370, 2, '[Antalet möten]');
INSERT INTO `lang_definitions` VALUES (3147, 12371, 2, '[Rapporter]');
INSERT INTO `lang_definitions` VALUES (3148, 12372, 2, '[Markera alla]');
INSERT INTO `lang_definitions` VALUES (3149, 12373, 2, '[SQL-Ledger]');
INSERT INTO `lang_definitions` VALUES (3150, 12374, 2, '[Starta batchprocess]');
INSERT INTO `lang_definitions` VALUES (3151, 12375, 2, '[Titta på logg]');
INSERT INTO `lang_definitions` VALUES (3152, 12376, 2, '[Se utskrivbar rapport]');
INSERT INTO `lang_definitions` VALUES (3153, 12378, 2, '_PC_DUR_HOURS');
INSERT INTO `lang_definitions` VALUES (3154, 12379, 2, '_PC_DUR_MINUTES');
INSERT INTO `lang_definitions` VALUES (3155, 12380, 2, '_PC_LOCALE');
INSERT INTO `lang_definitions` VALUES (3156, 12381, 2, '~ Kommit sent');
INSERT INTO `lang_definitions` VALUES (3157, 1, 3, 'Un, Una');
INSERT INTO `lang_definitions` VALUES (3158, 2, 3, 'Un número de cheque o reclamación para identificar el pago');
INSERT INTO `lang_definitions` VALUES (3159, 3, 3, 'Debe escoger una reclamación para activar este menú');
INSERT INTO `lang_definitions` VALUES (3160, 4, 3, 'Un certificado de cliente para el usuario administrador');
INSERT INTO `lang_definitions` VALUES (3161, 6, 3, 'Adjunto está un documento clínico.');
INSERT INTO `lang_definitions` VALUES (3162, 7, 3, 'Adjunto está un documento clínico.');
INSERT INTO `lang_definitions` VALUES (3163, 8, 3, 'Un código de este tipo ya ha sido seleccionado. Elimínelo del campo si necesita reemplazarlo.');
INSERT INTO `lang_definitions` VALUES (3164, 10, 3, 'Necesita adquirir una clave de seguridad privada');
INSERT INTO `lang_definitions` VALUES (3165, 11, 3, 'Un código por defecto es opcional, ya que el código necesario puede ser introducido en el momento de crear la orden');
INSERT INTO `lang_definitions` VALUES (3166, 12, 3, 'Aquí puede encontrar una guía detallada acerca de cómo activar y establecer una regla de Decisión Clínica');
INSERT INTO `lang_definitions` VALUES (3167, 13, 3, 'Se requiere un distribuidor');
INSERT INTO `lang_definitions` VALUES (3168, 17, 3, 'Formulario de visita GCAC debe ser agregado a esta visita');
INSERT INTO `lang_definitions` VALUES (3169, 20, 3, 'Un número de lote es requerido');
INSERT INTO `lang_definitions` VALUES (3170, 21, 3, 'Un número de lote es requerido!');
INSERT INTO `lang_definitions` VALUES (3171, 22, 3, 'Una letra minúscula');
INSERT INTO `lang_definitions` VALUES (3172, 23, 3, 'Una nueva cita');
INSERT INTO `lang_definitions` VALUES (3173, 28, 3, 'Un número');
INSERT INTO `lang_definitions` VALUES (3174, 29, 3, 'Debe seleccionar un paciente para generar un reporte');
INSERT INTO `lang_definitions` VALUES (3175, 30, 3, 'Un paciente con ese Nº ID ya existe');
INSERT INTO `lang_definitions` VALUES (3176, 31, 3, 'Un paciente con este nombre ya existe.');
INSERT INTO `lang_definitions` VALUES (3177, 32, 3, 'Un paciente con este Nº Seguridad Social ya existe');
INSERT INTO `lang_definitions` VALUES (3178, 33, 3, '¡Se requiere un pago! Por favor introduzca un concepto de pago');
INSERT INTO `lang_definitions` VALUES (3179, 34, 3, 'Un lugar donde documentar y mostrar el historial médico del paciente, familiar, y personal');
INSERT INTO `lang_definitions` VALUES (3180, 35, 3, 'Una notificación le alertará del éxito o fallo.');
INSERT INTO `lang_definitions` VALUES (3181, 36, 3, 'Un número positivo mostrará tantas citas pasadas en un Widget en la pantalla de resumen del cliente (un número negativo mostrará las citas pasadas en orden descendente)');
INSERT INTO `lang_definitions` VALUES (3182, 37, 3, 'Un número positivo mostrará tantas citas pasadas en un Widget en la pantalla de resumen del cliente (un número negativo mostrará las citas pasadas en orden descendente)');
INSERT INTO `lang_definitions` VALUES (3183, 38, 3, 'Un producto fue seleccionado pero no hay una sección de productos en este formulario');
INSERT INTO `lang_definitions` VALUES (3184, 39, 3, 'Puede seleccionar un proveedor o un almacén en el menú desplegable. Para que se muestre esta opción, \"Support provider in line item in fee sheet\" tiene que ser seleccionado en \"Administración > Globales > Página de facturación');
INSERT INTO `lang_definitions` VALUES (3185, 41, 3, 'Una derivación tiene una acción adicional - imprimir la derivación o guardarla como un fichero pdf');
INSERT INTO `lang_definitions` VALUES (3186, 42, 3, 'Una derivación es el tipo de transacción más común');
INSERT INTO `lang_definitions` VALUES (3187, 43, 3, 'Una fuente de derivación puede ser especificada para cada visita');
INSERT INTO `lang_definitions` VALUES (3188, 44, 3, 'Un código IPPF relacionado es requerido!');
INSERT INTO `lang_definitions` VALUES (3189, 45, 3, 'Se requiere una conexión web segura (HTTPS)  para U2F');
INSERT INTO `lang_definitions` VALUES (3190, 46, 3, 'Una breve descripción del grupo aparecerá cuando coloque le cursor sobre un grupo recién creado (ARO)');
INSERT INTO `lang_definitions` VALUES (3191, 47, 3, 'Una descripción breve de este grupo, pruebas de química de Serum');
INSERT INTO `lang_definitions` VALUES (3192, 48, 3, 'Una descripción breve del procedimiento o el código obtenido');
INSERT INTO `lang_definitions` VALUES (3193, 49, 3, 'Un carácter especial');
INSERT INTO `lang_definitions` VALUES (3194, 50, 3, 'Un formulario estandarizado llamado Formulario de Reclamación del Seguro se usa para enviar reclamaciones');
INSERT INTO `lang_definitions` VALUES (3195, 51, 3, 'Una tercera alternativa es escanear los resultados y guardarlos como un documento TIFF, JPEG, o PDF, en el gráfico del paciente bajo documentos');
INSERT INTO `lang_definitions` VALUES (3196, 53, 3, 'Un valor único para identificar este campo, no visible al usuario');
INSERT INTO `lang_definitions` VALUES (3197, 55, 3, 'Ya existe una visita para ese grupo hoy. Haga click en Cancelar para abrirla, o en OK para crear una nueva.');
INSERT INTO `lang_definitions` VALUES (3198, 56, 3, 'Ya existe una visita para este paciente hoy. Haga click en Cancelar para abrirla, o en OK para crear una nueva');
INSERT INTO `lang_definitions` VALUES (3199, 57, 3, 'antes de las comidas');
INSERT INTO `lang_definitions` VALUES (3200, 58, 3, 'a.m.');
INSERT INTO `lang_definitions` VALUES (3201, 60, 3, 'A/F Nivel de Derecho:');
INSERT INTO `lang_definitions` VALUES (3202, 62, 3, 'AB');
INSERT INTO `lang_definitions` VALUES (3203, 63, 3, 'Abreviatura');
INSERT INTO `lang_definitions` VALUES (3204, 64, 3, 'Abceso:');
INSERT INTO `lang_definitions` VALUES (3205, 65, 3, 'Abdominal');
INSERT INTO `lang_definitions` VALUES (3206, 66, 3, 'Capaz de cargar peso cuatro (4) pasos:');
INSERT INTO `lang_definitions` VALUES (3207, 67, 3, 'Anormal');
INSERT INTO `lang_definitions` VALUES (3208, 68, 3, 'ABN1');
INSERT INTO `lang_definitions` VALUES (3209, 69, 3, 'ABNL');
INSERT INTO `lang_definitions` VALUES (3210, 70, 3, 'Anormal');
INSERT INTO `lang_definitions` VALUES (3211, 71, 3, 'Análisis de sangre anormal');
INSERT INTO `lang_definitions` VALUES (3212, 72, 3, 'Crecimiento anormal del pelo');
INSERT INTO `lang_definitions` VALUES (3213, 73, 3, 'Mamografía anormal');
INSERT INTO `lang_definitions` VALUES (3214, 74, 3, 'Abortar');
INSERT INTO `lang_definitions` VALUES (3215, 75, 3, 'Aborto');
INSERT INTO `lang_definitions` VALUES (3216, 76, 3, 'Problemas del Aborto');
INSERT INTO `lang_definitions` VALUES (3217, 77, 3, 'Método abortivo');
INSERT INTO `lang_definitions` VALUES (3218, 78, 3, 'Categorías relacionadas al Aborto');
INSERT INTO `lang_definitions` VALUES (3219, 79, 3, 'Abortos');
INSERT INTO `lang_definitions` VALUES (3220, 80, 3, 'Acerca de');
INSERT INTO `lang_definitions` VALUES (3221, 81, 3, 'Acerca del panel de control del portal');
INSERT INTO `lang_definitions` VALUES (3222, 82, 3, 'Acerca del calendario');
INSERT INTO `lang_definitions` VALUES (3223, 83, 3, 'Acerca de su portala');
INSERT INTO `lang_definitions` VALUES (3224, 84, 3, 'Por encima de los límites de pánico');
INSERT INTO `lang_definitions` VALUES (3225, 85, 3, 'Ausencias por Diagnóstico');
INSERT INTO `lang_definitions` VALUES (3226, 86, 3, 'Aceptar');
INSERT INTO `lang_definitions` VALUES (3227, 87, 3, 'Aceptar la tarea');
INSERT INTO `lang_definitions` VALUES (3228, 88, 3, 'Aceptar pago');
INSERT INTO `lang_definitions` VALUES (3229, 89, 3, 'Aceptar pago por');
INSERT INTO `lang_definitions` VALUES (3230, 90, 3, 'Aceptar Pago por');
INSERT INTO `lang_definitions` VALUES (3231, 91, 3, 'Acepta la tarea');
INSERT INTO `lang_definitions` VALUES (3232, 92, 3, 'Se puede dar acceso a otros grupo editando Membresías o Grupos del Usuario y controles de acceso en Administracion > ACL');
INSERT INTO `lang_definitions` VALUES (3233, 93, 3, 'Control de acceso');
INSERT INTO `lang_definitions` VALUES (3234, 94, 3, 'Administración de la Lista de Control de Acceso');
INSERT INTO `lang_definitions` VALUES (3235, 95, 3, 'Ayuda para la Lista de control de acceso');
INSERT INTO `lang_definitions` VALUES (3236, 96, 3, 'Listas de control de acceso');
INSERT INTO `lang_definitions` VALUES (3237, 98, 3, 'Fecha de acceso');
INSERT INTO `lang_definitions` VALUES (3238, 99, 3, 'Acceso denegado');
INSERT INTO `lang_definitions` VALUES (3239, 101, 3, 'acceso no permitido');
INSERT INTO `lang_definitions` VALUES (3240, 102, 3, 'Acceso no permitido');
INSERT INTO `lang_definitions` VALUES (3241, 103, 3, 'Acceso no autorizado');
INSERT INTO `lang_definitions` VALUES (3242, 104, 3, 'Acceda a sus registros médicos');
INSERT INTO `lang_definitions` VALUES (3243, 105, 3, 'Acceder al Portal del Paciente');
INSERT INTO `lang_definitions` VALUES (3244, 106, 3, 'Accidente');
INSERT INTO `lang_definitions` VALUES (3245, 107, 3, 'Cuenta');
INSERT INTO `lang_definitions` VALUES (3246, 112, 3, 'Cuenta validada. ¿Enviar credenciales nuevas?');
INSERT INTO `lang_definitions` VALUES (3247, 113, 3, 'Nombre de la Cuenta');
INSERT INTO `lang_definitions` VALUES (3248, 114, 3, 'Nombre de cuenta emitido para NewCrop eRx service.');
INSERT INTO `lang_definitions` VALUES (3249, 115, 3, 'Contraseña de cuenta emitida para NewCrop eRx service.');
INSERT INTO `lang_definitions` VALUES (3250, 117, 3, 'Contabilidad');
INSERT INTO `lang_definitions` VALUES (3251, 118, 3, 'Contabilidad');
INSERT INTO `lang_definitions` VALUES (3252, 119, 3, 'Contabilidad');
INSERT INTO `lang_definitions` VALUES (3253, 120, 3, 'Contab.');
INSERT INTO `lang_definitions` VALUES (3254, 121, 3, 'ACD{{profundidad de camara anterior}}');
INSERT INTO `lang_definitions` VALUES (3255, 122, 3, 'Dolores');
INSERT INTO `lang_definitions` VALUES (3256, 123, 3, 'Reconocer como mi firma electrónica');
INSERT INTO `lang_definitions` VALUES (3257, 124, 3, 'Solicitud de reconocimiento (ISA14)');
INSERT INTO `lang_definitions` VALUES (3258, 125, 3, 'Reconocimientos, Licencias y Certificaciones');
INSERT INTO `lang_definitions` VALUES (3259, 126, 3, 'ACL');
INSERT INTO `lang_definitions` VALUES (3260, 127, 3, 'Administración del ACL');
INSERT INTO `lang_definitions` VALUES (3261, 128, 3, 'Administración del ACL (ACL)');
INSERT INTO `lang_definitions` VALUES (3262, 129, 3, 'Administración del ACL no autorizada');
INSERT INTO `lang_definitions` VALUES (3263, 131, 3, 'ACL Control de Grano Fino');
INSERT INTO `lang_definitions` VALUES (3264, 132, 3, 'ACL actualizada exitósamente');
INSERT INTO `lang_definitions` VALUES (3265, 133, 3, 'Acné');
INSERT INTO `lang_definitions` VALUES (3266, 134, 3, 'ACO');
INSERT INTO `lang_definitions` VALUES (3267, 135, 3, 'ACOM{{Segmento anterior}}');
INSERT INTO `lang_definitions` VALUES (3268, 136, 3, 'Acta');
INSERT INTO `lang_definitions` VALUES (3269, 137, 3, 'Fecha de Acta');
INSERT INTO `lang_definitions` VALUES (3270, 138, 3, 'Acción');
INSERT INTO `lang_definitions` VALUES (3271, 139, 3, 'Acción tomada');
INSERT INTO `lang_definitions` VALUES (3272, 140, 3, 'Tiempo de la acción tomada');
INSERT INTO `lang_definitions` VALUES (3273, 141, 3, 'Usuario de la acción');
INSERT INTO `lang_definitions` VALUES (3274, 142, 3, 'Acciones');
INSERT INTO `lang_definitions` VALUES (3275, 143, 3, 'Activar');
INSERT INTO `lang_definitions` VALUES (3276, 144, 3, 'Activar Reportes CCR/CCD');
INSERT INTO `lang_definitions` VALUES (3277, 145, 3, 'Activar para ordenar columnas en orden ascendente');
INSERT INTO `lang_definitions` VALUES (3278, 146, 3, 'Activar para ordenar columnas en orden descendente');
INSERT INTO `lang_definitions` VALUES (3279, 147, 3, 'Activar soporte de reclamación UB04/837I');
INSERT INTO `lang_definitions` VALUES (3280, 148, 3, 'Activo');
INSERT INTO `lang_definitions` VALUES (3281, 150, 3, 'Alerta Activa');
INSERT INTO `lang_definitions` VALUES (3282, 152, 3, 'Reglas de Alerta Activa');
INSERT INTO `lang_definitions` VALUES (3283, 153, 3, 'Alertas activas/Recordatorios');
INSERT INTO `lang_definitions` VALUES (3284, 154, 3, 'Gráfica activa');
INSERT INTO `lang_definitions` VALUES (3285, 158, 3, 'Visita Activa');
INSERT INTO `lang_definitions` VALUES (3286, 159, 3, 'Códigos de problemas activos');
INSERT INTO `lang_definitions` VALUES (3287, 160, 3, 'Listas Activas');
INSERT INTO `lang_definitions` VALUES (3288, 161, 3, 'Mensajes activos');
INSERT INTO `lang_definitions` VALUES (3289, 162, 3, 'Paciente Activo');
INSERT INTO `lang_definitions` VALUES (3290, 163, 3, 'Planes Activos');
INSERT INTO `lang_definitions` VALUES (3291, 164, 3, 'Plantillas Activas');
INSERT INTO `lang_definitions` VALUES (3292, 173, 3, 'Actividad');
INSERT INTO `lang_definitions` VALUES (3293, 174, 3, 'Tipo de Actividad');
INSERT INTO `lang_definitions` VALUES (3294, 176, 3, 'Agudeza');
INSERT INTO `lang_definitions` VALUES (3295, 177, 3, 'AGUDEZA');
INSERT INTO `lang_definitions` VALUES (3296, 187, 3, 'Agudo en Crónico');
INSERT INTO `lang_definitions` VALUES (3297, 189, 3, 'Añadir');
INSERT INTO `lang_definitions` VALUES (3298, 190, 3, 'añadir');
INSERT INTO `lang_definitions` VALUES (3299, 191, 3, 'AÑADIR');
INSERT INTO `lang_definitions` VALUES (3300, 192, 3, 'Añadir una Sociedad');
INSERT INTO `lang_definitions` VALUES (3301, 193, 3, 'Añadir condición médica');
INSERT INTO `lang_definitions` VALUES (3302, 197, 3, 'Añadir una Farmacia');
INSERT INTO `lang_definitions` VALUES (3303, 199, 3, 'Añadir todas las reglas al plan');
INSERT INTO `lang_definitions` VALUES (3304, 200, 3, 'Añadir un evento para');
INSERT INTO `lang_definitions` VALUES (3305, 201, 3, 'Añadir como mensaje nuevo');
INSERT INTO `lang_definitions` VALUES (3306, 202, 3, 'Añadir como nueva nota');
INSERT INTO `lang_definitions` VALUES (3307, 203, 3, 'Añadir como Nuevo');
INSERT INTO `lang_definitions` VALUES (3308, 204, 3, 'Añadir como nuevo paciente');
INSERT INTO `lang_definitions` VALUES (3309, 206, 3, 'Agregar Botones');
INSERT INTO `lang_definitions` VALUES (3310, 207, 3, 'Agregar botones para caracteres especiales, Textos serán mostrados sobre el editor para incluir en el texto con un Click.');
INSERT INTO `lang_definitions` VALUES (3311, 208, 3, 'Añadir Categoría');
INSERT INTO `lang_definitions` VALUES (3312, 209, 3, 'Añadir Constante');
INSERT INTO `lang_definitions` VALUES (3313, 210, 3, 'Añadir Contexto');
INSERT INTO `lang_definitions` VALUES (3314, 211, 3, 'Añadir Co-pago');
INSERT INTO `lang_definitions` VALUES (3315, 212, 3, 'Añadir Criterios');
INSERT INTO `lang_definitions` VALUES (3316, 213, 3, 'Añadir Botón Personalizado');
INSERT INTO `lang_definitions` VALUES (3317, 216, 3, 'Añadir Diagnóstico');
INSERT INTO `lang_definitions` VALUES (3318, 217, 3, 'Añadir Medicamento');
INSERT INTO `lang_definitions` VALUES (3319, 218, 3, 'Añadir Editar Transacciones Ayuda');
INSERT INTO `lang_definitions` VALUES (3320, 219, 3, 'Añadir visita');
INSERT INTO `lang_definitions` VALUES (3321, 220, 3, 'Añadir Visita');
INSERT INTO `lang_definitions` VALUES (3322, 221, 3, 'Añadir Visita/notas');
INSERT INTO `lang_definitions` VALUES (3323, 222, 3, 'Añadir Centro');
INSERT INTO `lang_definitions` VALUES (3324, 223, 3, 'Añadir Campo');
INSERT INTO `lang_definitions` VALUES (3325, 224, 3, 'Añadir las siguientes líneas al fichero de configuración de Apache');
INSERT INTO `lang_definitions` VALUES (3326, 225, 3, 'Añadir Grupo');
INSERT INTO `lang_definitions` VALUES (3327, 226, 3, 'Añadir grupo');
INSERT INTO `lang_definitions` VALUES (3328, 227, 3, 'Añadir Código CIE');
INSERT INTO `lang_definitions` VALUES (3329, 228, 3, 'Agregar Vacunación');
INSERT INTO `lang_definitions` VALUES (3330, 229, 3, 'Añadir no permitido!');
INSERT INTO `lang_definitions` VALUES (3331, 230, 3, 'Añadir Incidencia');
INSERT INTO `lang_definitions` VALUES (3332, 231, 3, 'Añadir objeto a seguir');
INSERT INTO `lang_definitions` VALUES (3333, 232, 3, 'Añadir Idioma');
INSERT INTO `lang_definitions` VALUES (3334, 234, 3, 'Añadir manualmente');
INSERT INTO `lang_definitions` VALUES (3335, 235, 3, 'Añadir Modo');
INSERT INTO `lang_definitions` VALUES (3336, 236, 3, 'Añadir modificadores para este tipo de campo. Puede seleccionar más de uno.');
INSERT INTO `lang_definitions` VALUES (3337, 237, 3, 'Añadir más artículos');
INSERT INTO `lang_definitions` VALUES (3338, 238, 3, 'Añadir Nuevo');
INSERT INTO `lang_definitions` VALUES (3339, 239, 3, 'Añadir nuevo');
INSERT INTO `lang_definitions` VALUES (3340, 240, 3, 'Añadir nueva categoría:');
INSERT INTO `lang_definitions` VALUES (3341, 241, 3, 'Añadir nuevos Certificados al fichero de configuración de Apache');
INSERT INTO `lang_definitions` VALUES (3342, 242, 3, 'Añadir nuevo componente');
INSERT INTO `lang_definitions` VALUES (3343, 243, 3, 'Añadir nuevos componentes');
INSERT INTO `lang_definitions` VALUES (3344, 244, 3, 'Añadir nueva base de datos');
INSERT INTO `lang_definitions` VALUES (3345, 245, 3, 'Añadir nueva entrada');
INSERT INTO `lang_definitions` VALUES (3346, 246, 3, 'Añadir nuevo evento');
INSERT INTO `lang_definitions` VALUES (3347, 248, 3, 'AÑADIR NUEVO GRUPO');
INSERT INTO `lang_definitions` VALUES (3348, 249, 3, 'Añadir Nuevo Grupo');
INSERT INTO `lang_definitions` VALUES (3349, 250, 3, 'Añadir nuevo problema');
INSERT INTO `lang_definitions` VALUES (3350, 251, 3, 'Añadir nuevo lote y transacción');
INSERT INTO `lang_definitions` VALUES (3351, 252, 3, 'Añadir nuevo mensaje');
INSERT INTO `lang_definitions` VALUES (3352, 253, 3, 'Añadir Nueva Nota');
INSERT INTO `lang_definitions` VALUES (3353, 254, 3, 'Añadir nueva nota');
INSERT INTO `lang_definitions` VALUES (3354, 255, 3, 'Añadir Nuevo Socio');
INSERT INTO `lang_definitions` VALUES (3355, 256, 3, 'Añadir Nuevo Paciente');
INSERT INTO `lang_definitions` VALUES (3356, 257, 3, 'AÑADIR NUEVO PLAN');
INSERT INTO `lang_definitions` VALUES (3357, 258, 3, 'Añadir Nuevo...');
INSERT INTO `lang_definitions` VALUES (3358, 264, 3, 'Añadir Nota');
INSERT INTO `lang_definitions` VALUES (3359, 265, 3, 'Añadir actividad al portal Onsite');
INSERT INTO `lang_definitions` VALUES (3360, 266, 3, 'Añadir Paquete');
INSERT INTO `lang_definitions` VALUES (3361, 267, 3, 'Añadir Paciente');
INSERT INTO `lang_definitions` VALUES (3362, 268, 3, 'Añadir Registro de Paciente');
INSERT INTO `lang_definitions` VALUES (3363, 269, 3, 'Añadir Receta');
INSERT INTO `lang_definitions` VALUES (3364, 270, 3, 'Añadir procedimiento');
INSERT INTO `lang_definitions` VALUES (3365, 271, 3, 'Añadir numero del proveedor');
INSERT INTO `lang_definitions` VALUES (3366, 272, 3, 'Añadir retiro');
INSERT INTO `lang_definitions` VALUES (3367, 273, 3, 'Añadir Rehabilitación');
INSERT INTO `lang_definitions` VALUES (3368, 274, 3, 'Añadir Regla');
INSERT INTO `lang_definitions` VALUES (3369, 276, 3, 'Añadir hora a la fecha');
INSERT INTO `lang_definitions` VALUES (3370, 277, 3, 'Añadir a');
INSERT INTO `lang_definitions` VALUES (3371, 278, 3, 'AÑADIR A MENSAJE EXISTENTE');
INSERT INTO `lang_definitions` VALUES (3372, 279, 3, 'Añadir a mensaje existente');
INSERT INTO `lang_definitions` VALUES (3373, 280, 3, 'Añadir a lista de Medicación');
INSERT INTO `lang_definitions` VALUES (3374, 281, 3, 'Añadir a Lista de Medicación');
INSERT INTO `lang_definitions` VALUES (3375, 282, 3, 'Añadir Nivel Superior');
INSERT INTO `lang_definitions` VALUES (3376, 283, 3, 'Añadir Transacción');
INSERT INTO `lang_definitions` VALUES (3377, 284, 3, 'Añadir Usuario');
INSERT INTO `lang_definitions` VALUES (3378, 285, 3, 'Añadir Usuario al Grupo');
INSERT INTO `lang_definitions` VALUES (3379, 287, 3, 'Añadir/Editar Receta electrónica');
INSERT INTO `lang_definitions` VALUES (3380, 288, 3, 'Añadir/Editar problema');
INSERT INTO `lang_definitions` VALUES (3381, 289, 3, 'Añadir/Editar Transacción de paciente');
INSERT INTO `lang_definitions` VALUES (3382, 290, 3, 'Añadido');
INSERT INTO `lang_definitions` VALUES (3383, 291, 3, 'Añadiendo');
INSERT INTO `lang_definitions` VALUES (3384, 292, 3, 'Añadiendo un participante');
INSERT INTO `lang_definitions` VALUES (3385, 293, 3, 'Añadir datos demográficos no autorizado.');
INSERT INTO `lang_definitions` VALUES (3386, 295, 3, 'Síndrome de Addison');
INSERT INTO `lang_definitions` VALUES (3387, 296, 3, 'Síndrome de Addison');
INSERT INTO `lang_definitions` VALUES (3388, 297, 3, 'Atributos adicionales');
INSERT INTO `lang_definitions` VALUES (3389, 299, 3, 'Fecha adicional:');
INSERT INTO `lang_definitions` VALUES (3390, 300, 3, 'Diagnóstico adicional:');
INSERT INTO `lang_definitions` VALUES (3391, 305, 3, 'Historia Adicional');
INSERT INTO `lang_definitions` VALUES (3392, 306, 3, 'Notas adicionales a la historia');
INSERT INTO `lang_definitions` VALUES (3393, 307, 3, 'Información adicional');
INSERT INTO `lang_definitions` VALUES (3394, 310, 3, 'Laboratorios adicionales');
INSERT INTO `lang_definitions` VALUES (3395, 311, 3, 'Notas adicionales');
INSERT INTO `lang_definitions` VALUES (3396, 314, 3, 'Notas adicionales:');
INSERT INTO `lang_definitions` VALUES (3397, 315, 3, 'Notas adicionales:');
INSERT INTO `lang_definitions` VALUES (3398, 317, 3, 'Notas de Rayos X adicionales:');
INSERT INTO `lang_definitions` VALUES (3399, 320, 3, 'Sólo añadir');
INSERT INTO `lang_definitions` VALUES (3400, 322, 3, 'Libreta Direcciones');
INSERT INTO `lang_definitions` VALUES (3401, 323, 3, 'Libreta Direcciones');
INSERT INTO `lang_definitions` VALUES (3402, 324, 3, 'Dirección');
INSERT INTO `lang_definitions` VALUES (3403, 325, 3, 'Dirección y Código Postal');
INSERT INTO `lang_definitions` VALUES (3404, 326, 3, 'Dirección y Provincia/Departamento');
INSERT INTO `lang_definitions` VALUES (3405, 327, 3, 'Libreta de Direcciones');
INSERT INTO `lang_definitions` VALUES (3406, 328, 3, 'Entrada a la libreta de Direcciones de la empresa que realiza este procedimiento');
INSERT INTO `lang_definitions` VALUES (3407, 329, 3, 'Entrada a la libreta de Direcciones para el distribuidor');
INSERT INTO `lang_definitions` VALUES (3408, 330, 3, 'Entrada a la Libreta de Direcciones para el vendedor');
INSERT INTO `lang_definitions` VALUES (3409, 331, 3, 'Tipos de Libreta de Direcciones');
INSERT INTO `lang_definitions` VALUES (3410, 332, 3, 'Etiqueta de Dirección');
INSERT INTO `lang_definitions` VALUES (3411, 333, 3, 'Etiquetas de Dirección');
INSERT INTO `lang_definitions` VALUES (3412, 336, 3, 'Dirección Sola');
INSERT INTO `lang_definitions` VALUES (3413, 338, 3, 'Dirección, Provincia/Estado/Departamento y Código Postal');
INSERT INTO `lang_definitions` VALUES (3414, 339, 3, 'Dirección1');
INSERT INTO `lang_definitions` VALUES (3415, 340, 3, 'Dirección2');
INSERT INTO `lang_definitions` VALUES (3416, 342, 3, 'DESTINATARIO');
INSERT INTO `lang_definitions` VALUES (3417, 345, 3, 'Ajuste');
INSERT INTO `lang_definitions` VALUES (3418, 346, 3, 'Importe de Ajuste');
INSERT INTO `lang_definitions` VALUES (3419, 347, 3, 'Ajustar');
INSERT INTO `lang_definitions` VALUES (3420, 348, 3, 'Ajuste');
INSERT INTO `lang_definitions` VALUES (3421, 349, 3, 'Ajuste importe');
INSERT INTO `lang_definitions` VALUES (3422, 350, 3, 'Motivos del ajuste');
INSERT INTO `lang_definitions` VALUES (3423, 352, 3, 'Valor de ajuste para código');
INSERT INTO `lang_definitions` VALUES (3424, 353, 3, 'Ajustes');
INSERT INTO `lang_definitions` VALUES (3425, 354, 3, 'Ajuste administrador');
INSERT INTO `lang_definitions` VALUES (3426, 355, 3, 'Administrador');
INSERT INTO `lang_definitions` VALUES (3427, 356, 3, 'email administrador');
INSERT INTO `lang_definitions` VALUES (3428, 357, 3, 'Administrar a través de');
INSERT INTO `lang_definitions` VALUES (3429, 359, 3, 'Administrado');
INSERT INTO `lang_definitions` VALUES (3430, 360, 3, 'Administrado por');
INSERT INTO `lang_definitions` VALUES (3431, 361, 3, 'Fecha Administrado');
INSERT INTO `lang_definitions` VALUES (3432, 362, 3, 'Sitio Administrado');
INSERT INTO `lang_definitions` VALUES (3433, 363, 3, 'Administración');
INSERT INTO `lang_definitions` VALUES (3434, 365, 3, 'Sitio de administración');
INSERT INTO `lang_definitions` VALUES (3435, 366, 3, 'Administradores');
INSERT INTO `lang_definitions` VALUES (3436, 367, 3, 'Los administradores pueden hacer todo');
INSERT INTO `lang_definitions` VALUES (3437, 371, 3, 'Revisión Peso de Adulto y Seguimiento');
INSERT INTO `lang_definitions` VALUES (3438, 372, 3, 'Revisión Peso de Adulto y Seguimiento (GCC)');
INSERT INTO `lang_definitions` VALUES (3439, 373, 3, 'Instrucción anticipada');
INSERT INTO `lang_definitions` VALUES (3440, 374, 3, 'Directriz Anticipada');
INSERT INTO `lang_definitions` VALUES (3441, 375, 3, 'Aviso Directriz Anticipada');
INSERT INTO `lang_definitions` VALUES (3442, 377, 3, 'Anticipado');
INSERT INTO `lang_definitions` VALUES (3443, 380, 3, 'Consejo');
INSERT INTO `lang_definitions` VALUES (3444, 382, 3, 'Afecta normales');
INSERT INTO `lang_definitions` VALUES (3445, 386, 3, 'Llamadas fuera de horario laboral');
INSERT INTO `lang_definitions` VALUES (3446, 388, 3, 'Después de hacer las configuraciones mencionadas, importar el certificado del cliente de administrador al navegador y reiniciar el servidor Apache (Contraseña vacía)');
INSERT INTO `lang_definitions` VALUES (3447, 390, 3, 'Después de guardar el PDF, click [Ver Log] para comprobar errores.');
INSERT INTO `lang_definitions` VALUES (3448, 393, 3, 'Después de guardar los ficheros de TEXTO, click [Ver Log] para comprobar errores.');
INSERT INTO `lang_definitions` VALUES (3449, 396, 3, 'Después de guardar su Batch, click [Ver Log] para comprobar errores.');
INSERT INTO `lang_definitions` VALUES (3450, 399, 3, 'Una vez completada la informacion correctamente, click en botón Guardar');
INSERT INTO `lang_definitions` VALUES (3451, 400, 3, 'Después de subir, haga click en el botón \"Importar\"');
INSERT INTO `lang_definitions` VALUES (3452, 404, 3, 'Planificación posterior al cuidado');
INSERT INTO `lang_definitions` VALUES (3453, 406, 3, 'Otra vez');
INSERT INTO `lang_definitions` VALUES (3454, 407, 3, 'Edad');
INSERT INTO `lang_definitions` VALUES (3455, 408, 3, 'Edad de fallecimiento');
INSERT INTO `lang_definitions` VALUES (3456, 409, 3, 'Por Edad');
INSERT INTO `lang_definitions` VALUES (3457, 410, 3, 'Categoría edad');
INSERT INTO `lang_definitions` VALUES (3458, 411, 3, 'Dato edad fuera de rango.');
INSERT INTO `lang_definitions` VALUES (3459, 412, 3, 'Formato para mostrar edad');
INSERT INTO `lang_definitions` VALUES (3460, 413, 3, 'Formato edad en \'desde edad\' no es válido');
INSERT INTO `lang_definitions` VALUES (3461, 414, 3, 'Formato edad en \'hasta edad\' no es válido');
INSERT INTO `lang_definitions` VALUES (3462, 415, 3, 'Edad desde');
INSERT INTO `lang_definitions` VALUES (3463, 416, 3, 'Edad en años para cambio de formato');
INSERT INTO `lang_definitions` VALUES (3464, 417, 3, 'Edad Máxima');
INSERT INTO `lang_definitions` VALUES (3465, 418, 3, 'Edad Mínima');
INSERT INTO `lang_definitions` VALUES (3466, 419, 3, 'Rango de Edad');
INSERT INTO `lang_definitions` VALUES (3467, 420, 3, 'Columnas del envejecimiento');
INSERT INTO `lang_definitions` VALUES (3468, 421, 3, 'Columnas del envejecimiento:');
INSERT INTO `lang_definitions` VALUES (3469, 423, 3, 'Albanés');
INSERT INTO `lang_definitions` VALUES (3470, 424, 3, 'Alcohol');
INSERT INTO `lang_definitions` VALUES (3471, 425, 3, 'Consumo de alcohol');
INSERT INTO `lang_definitions` VALUES (3472, 426, 3, 'Uso de alcohol');
INSERT INTO `lang_definitions` VALUES (3473, 427, 3, 'Alerta');
INSERT INTO `lang_definitions` VALUES (3474, 428, 3, 'Contador de Alerta');
INSERT INTO `lang_definitions` VALUES (3475, 434, 3, 'Tiempo de alerta');
INSERT INTO `lang_definitions` VALUES (3476, 435, 3, 'Alertas');
INSERT INTO `lang_definitions` VALUES (3477, 436, 3, 'Registro de alertas');
INSERT INTO `lang_definitions` VALUES (3478, 437, 3, 'Alertas/Recordatorios');
INSERT INTO `lang_definitions` VALUES (3479, 439, 3, 'ALEUTIANO');
INSERT INTO `lang_definitions` VALUES (3480, 440, 3, 'Todos');
INSERT INTO `lang_definitions` VALUES (3481, 441, 3, 'TODOS');
INSERT INTO `lang_definitions` VALUES (3482, 442, 3, 'todos');
INSERT INTO `lang_definitions` VALUES (3483, 443, 3, 'Todos (Formatos Compaginados A)');
INSERT INTO `lang_definitions` VALUES (3484, 444, 3, 'Todos (Formatos Compaginados B)');
INSERT INTO `lang_definitions` VALUES (3485, 445, 3, 'Todos (Acumulativo)');
INSERT INTO `lang_definitions` VALUES (3486, 446, 3, 'Todas las alertas');
INSERT INTO `lang_definitions` VALUES (3487, 447, 3, 'Todo los Cálculos de Medidas Automatizados (CMA)');
INSERT INTO `lang_definitions` VALUES (3488, 448, 3, 'Todas las Categorías');
INSERT INTO `lang_definitions` VALUES (3489, 450, 3, 'Todos los Códigos');
INSERT INTO `lang_definitions` VALUES (3490, 452, 3, 'Todas las fechas');
INSERT INTO `lang_definitions` VALUES (3491, 453, 3, 'Todo el día');
INSERT INTO `lang_definitions` VALUES (3492, 454, 3, 'Evento de día completo');
INSERT INTO `lang_definitions` VALUES (3493, 455, 3, 'Todos los campos demográficos, con búsqueda y chequeo de dupicados');
INSERT INTO `lang_definitions` VALUES (3494, 457, 3, 'Todas las Clínicas');
INSERT INTO `lang_definitions` VALUES (3495, 458, 3, 'Todas las Lesiones/Problemas/Incidencias');
INSERT INTO `lang_definitions` VALUES (3496, 459, 3, 'Permitidos todos los Idiomas');
INSERT INTO `lang_definitions` VALUES (3497, 462, 3, 'Todo o parte del nombre');
INSERT INTO `lang_definitions` VALUES (3498, 463, 3, 'Todo o parte del apellido');
INSERT INTO `lang_definitions` VALUES (3499, 464, 3, 'Todo o parte de la organización');
INSERT INTO `lang_definitions` VALUES (3500, 468, 3, 'Todos los productos');
INSERT INTO `lang_definitions` VALUES (3501, 469, 3, 'Todos los proveedores');
INSERT INTO `lang_definitions` VALUES (3502, 470, 3, 'Todos Revisados y Negativos:');
INSERT INTO `lang_definitions` VALUES (3503, 475, 3, 'Todos los Temas');
INSERT INTO `lang_definitions` VALUES (3504, 478, 3, 'Todos los Usuarios');
INSERT INTO `lang_definitions` VALUES (3505, 479, 3, 'Alérgico');
INSERT INTO `lang_definitions` VALUES (3506, 481, 3, 'Alergias');
INSERT INTO `lang_definitions` VALUES (3507, 484, 3, 'Alergias:');
INSERT INTO `lang_definitions` VALUES (3508, 485, 3, 'Alergia');
INSERT INTO `lang_definitions` VALUES (3509, 486, 3, 'Importación de Alergia completado con éxito');
INSERT INTO `lang_definitions` VALUES (3510, 488, 3, 'Reacción Alérgica');
INSERT INTO `lang_definitions` VALUES (3511, 491, 3, 'Asignar');
INSERT INTO `lang_definitions` VALUES (3512, 492, 3, 'Permitir');
INSERT INTO `lang_definitions` VALUES (3513, 494, 3, 'Permitir todos los idiomas disponibles como opción en el menú de inicio sesión.');
INSERT INTO `lang_definitions` VALUES (3514, 496, 3, 'Permitir creación de reclamaciones con diagnósticos pero no procedimientos o cargos. La mayoría de clínicas no desean esto.');
INSERT INTO `lang_definitions` VALUES (3515, 497, 3, 'Permitir Depuración de Idioma');
INSERT INTO `lang_definitions` VALUES (3516, 500, 3, 'Permitir Email');
INSERT INTO `lang_definitions` VALUES (3517, 501, 3, '¿Permitir mensajes email?');
INSERT INTO `lang_definitions` VALUES (3518, 502, 3, '¿Permitir Email?');
INSERT INTO `lang_definitions` VALUES (3519, 503, 3, 'Permitir reclamación de Visita');
INSERT INTO `lang_definitions` VALUES (3520, 506, 3, 'Permitir el Intercambio de Información de Salud');
INSERT INTO `lang_definitions` VALUES (3521, 508, 3, 'Permitir Compartir Información de Vacunación');
INSERT INTO `lang_definitions` VALUES (3522, 509, 3, 'Permitir el Uso del Registro de Vacunaciones');
INSERT INTO `lang_definitions` VALUES (3523, 512, 3, 'Permitir mensajes email');
INSERT INTO `lang_definitions` VALUES (3524, 533, 3, 'Permitir Portal del Paciente');
INSERT INTO `lang_definitions` VALUES (3525, 541, 3, 'Permitir SMS');
INSERT INTO `lang_definitions` VALUES (3526, 542, 3, '¿Permitir SMS (mensajes de texto)?');
INSERT INTO `lang_definitions` VALUES (3527, 544, 3, '¿Permitir la activación instantánea de los eventos introducidos?');
INSERT INTO `lang_definitions` VALUES (3528, 545, 3, '¿Permitir mensajes telefónicos?');
INSERT INTO `lang_definitions` VALUES (3529, 547, 3, 'Permitir a los usuarios publicar eventos globales');
INSERT INTO `lang_definitions` VALUES (3530, 548, 3, 'Permitir a los usuarios publicar calendarios personales');
INSERT INTO `lang_definitions` VALUES (3531, 554, 3, 'Permitir Mensaje de Voz');
INSERT INTO `lang_definitions` VALUES (3532, 555, 3, 'Permitido');
INSERT INTO `lang_definitions` VALUES (3533, 556, 3, 'Idiomas Permitidos');
INSERT INTO `lang_definitions` VALUES (3534, 558, 3, 'Asignado ©');
INSERT INTO `lang_definitions` VALUES (3535, 559, 3, 'Permite E-sign en todo el encuentro');
INSERT INTO `lang_definitions` VALUES (3536, 560, 3, 'Permite E-sign para formas individuales');
INSERT INTO `lang_definitions` VALUES (3537, 561, 3, 'Permitir Correo Electrónico');
INSERT INTO `lang_definitions` VALUES (3538, 562, 3, 'Permitir Mensajes de voz');
INSERT INTO `lang_definitions` VALUES (3539, 566, 3, 'ya existe');
INSERT INTO `lang_definitions` VALUES (3540, 568, 3, 'ya existe.');
INSERT INTO `lang_definitions` VALUES (3541, 570, 3, 'Identificador ya usado, elija otro');
INSERT INTO `lang_definitions` VALUES (3542, 571, 3, 'Título ya usado, elija otro');
INSERT INTO `lang_definitions` VALUES (3543, 573, 3, 'Dirección alternativa');
INSERT INTO `lang_definitions` VALUES (3544, 577, 3, 'modificar');
INSERT INTO `lang_definitions` VALUES (3545, 584, 3, 'De forma alternativa, puede usar la página de búsqueda para cargar un fichero electrónico (X12835) que haya recibido de su pagador. Puede hacerlo presionando el botón Explorar y seleccionar el fichero a cargar, y luego pulsando Explorar para ejecutar la carga y mostrar las facturas correspondientes. En este caso, los otros parámetros mencionados arriba no se aplican y pueden ser ignorados. La carga guarda el fichero pero no procesa su contenido - esto se realiza de forma separada como se describe abajo.');
INSERT INTO `lang_definitions` VALUES (3546, 586, 3, 'AM');
INSERT INTO `lang_definitions` VALUES (3547, 587, 3, 'Programa AM');
INSERT INTO `lang_definitions` VALUES (3548, 592, 3, 'Cálculo Automático de Medidas (CAM)');
INSERT INTO `lang_definitions` VALUES (3549, 593, 3, 'Rastreo CAM');
INSERT INTO `lang_definitions` VALUES (3550, 600, 3, 'Corregir nota existente');
INSERT INTO `lang_definitions` VALUES (3551, 610, 3, 'Indígena americano');
INSERT INTO `lang_definitions` VALUES (3552, 611, 3, 'Indígena americano o Nativo de Alaska');
INSERT INTO `lang_definitions` VALUES (3553, 612, 3, 'AMEX');
INSERT INTO `lang_definitions` VALUES (3554, 613, 3, 'Amárico (Lengua de Etiopia)');
INSERT INTO `lang_definitions` VALUES (3555, 614, 3, 'Importe');
INSERT INTO `lang_definitions` VALUES (3556, 617, 3, 'Importes Cargados');
INSERT INTO `lang_definitions` VALUES (3557, 620, 3, 'Importe Saldo Vencido');
INSERT INTO `lang_definitions` VALUES (3558, 621, 3, 'Importe por esta visita');
INSERT INTO `lang_definitions` VALUES (3559, 622, 3, 'Importe pagado');
INSERT INTO `lang_definitions` VALUES (3560, 623, 3, 'Importe:');
INSERT INTO `lang_definitions` VALUES (3561, 626, 3, 'Importe Facturado');
INSERT INTO `lang_definitions` VALUES (3562, 630, 3, '¡Se requiere una fecha de finalización posterior a la fecha de inicio para los eventos repetidos!');
INSERT INTO `lang_definitions` VALUES (3563, 632, 3, 'Ocurrió un error durante la descarga web de los directorios de OpenEMR');
INSERT INTO `lang_definitions` VALUES (3564, 633, 3, 'Ocurrió un error durante la descarga web de los directorios de phpGACL');
INSERT INTO `lang_definitions` VALUES (3565, 634, 3, 'Ocurrió un error durante la descarga web de los directorios SQL-Ledger');
INSERT INTO `lang_definitions` VALUES (3566, 638, 3, 'Una incidencia GCAC incompleta ha sido creada y vinculada. Alguien tendrá que completarla más tarde.');
INSERT INTO `lang_definitions` VALUES (3567, 644, 3, 'Ocurrio un error inesperado.');
INSERT INTO `lang_definitions` VALUES (3568, 646, 3, 'Una letra mayúscula');
INSERT INTO `lang_definitions` VALUES (3569, 648, 3, 'y');
INSERT INTO `lang_definitions` VALUES (3570, 649, 3, 'Y');
INSERT INTO `lang_definitions` VALUES (3571, 650, 3, 'Y');
INSERT INTO `lang_definitions` VALUES (3572, 651, 3, 'y');
INSERT INTO `lang_definitions` VALUES (3573, 652, 3, '¿y toda la información subordinada? Esta acción será registrada');
INSERT INTO `lang_definitions` VALUES (3574, 653, 3, 'y modificador');
INSERT INTO `lang_definitions` VALUES (3575, 654, 3, 'y procesado.');
INSERT INTO `lang_definitions` VALUES (3576, 656, 3, 'y reiniciar servidor Apache');
INSERT INTO `lang_definitions` VALUES (3577, 657, 3, 'y la Razón es');
INSERT INTO `lang_definitions` VALUES (3578, 659, 3, 'Anemia');
INSERT INTO `lang_definitions` VALUES (3579, 660, 3, 'Tobillo');
INSERT INTO `lang_definitions` VALUES (3580, 661, 3, 'Tobillo + talón');
INSERT INTO `lang_definitions` VALUES (3581, 662, 3, 'Formulario de Evaluación del tobillo');
INSERT INTO `lang_definitions` VALUES (3582, 663, 3, 'Problemas de tobillo');
INSERT INTO `lang_definitions` VALUES (3583, 664, 3, 'Espondilitis anquilosante');
INSERT INTO `lang_definitions` VALUES (3584, 665, 3, 'Espondilitis anquilosante');
INSERT INTO `lang_definitions` VALUES (3585, 666, 3, 'Anorexia');
INSERT INTO `lang_definitions` VALUES (3586, 667, 3, 'Otra cosa que puede hacer en la ventana de publicación es solicitar facturación secundaria. Si selecciona la casilla de verificación antes de guardar, la reclamación original será reabierta y puesta en cola en la página de Facturación, y será procesada en el siguiente proceso de facturación.');
INSERT INTO `lang_definitions` VALUES (3587, 671, 3, 'ante');
INSERT INTO `lang_definitions` VALUES (3588, 673, 3, 'Segmento Anterior');
INSERT INTO `lang_definitions` VALUES (3589, 674, 3, 'Valores por Defecto para el Segmento Anterior');
INSERT INTO `lang_definitions` VALUES (3590, 676, 3, 'Ano normal, recto sin distensión ni masa');
INSERT INTO `lang_definitions` VALUES (3591, 677, 3, 'Ansiedad');
INSERT INTO `lang_definitions` VALUES (3592, 679, 3, 'Cualquiera');
INSERT INTO `lang_definitions` VALUES (3593, 682, 3, 'Cualquier Categoría');
INSERT INTO `lang_definitions` VALUES (3594, 688, 3, 'Cualquier parte del código deseado o su descripción');
INSERT INTO `lang_definitions` VALUES (3595, 689, 3, 'Cualquier parte de la especialidad deseada');
INSERT INTO `lang_definitions` VALUES (3596, 690, 3, 'Cualquier parte del identificador o nombre de medicamento');
INSERT INTO `lang_definitions` VALUES (3597, 691, 3, 'Cualquier parte del identificador o nombre de vacuna');
INSERT INTO `lang_definitions` VALUES (3598, 692, 3, 'Cualquier parte del nombre del paciente, o Apellido, Nombre, o X-Y');
INSERT INTO `lang_definitions` VALUES (3599, 694, 3, '¿Algo más ocurre al mismo tiempo?');
INSERT INTO `lang_definitions` VALUES (3600, 699, 3, 'Clave API para puerta enlace SMS');
INSERT INTO `lang_definitions` VALUES (3601, 703, 3, 'Apnea');
INSERT INTO `lang_definitions` VALUES (3602, 710, 3, 'Aspecto');
INSERT INTO `lang_definitions` VALUES (3603, 711, 3, 'Aspecto:');
INSERT INTO `lang_definitions` VALUES (3604, 714, 3, 'Añadir esta nota');
INSERT INTO `lang_definitions` VALUES (3605, 716, 3, 'Añadir a la nota existente');
INSERT INTO `lang_definitions` VALUES (3606, 717, 3, 'Añadir a sta nota');
INSERT INTO `lang_definitions` VALUES (3607, 718, 3, 'Añadir a Esta Nota');
INSERT INTO `lang_definitions` VALUES (3608, 719, 3, 'Apendicectomía');
INSERT INTO `lang_definitions` VALUES (3609, 721, 3, 'Pacientes Aplicables');
INSERT INTO `lang_definitions` VALUES (3610, 723, 3, 'Nombre de aplicación para página de inicio de sesión y título de ventana principal');
INSERT INTO `lang_definitions` VALUES (3611, 724, 3, 'Código de Aplicación del receptor (GS03 - si está en blanco se usará ISA08)');
INSERT INTO `lang_definitions` VALUES (3612, 725, 3, 'Codigo de Aplicacion del Enviador (GS02)');
INSERT INTO `lang_definitions` VALUES (3613, 726, 3, 'Título de Aplicación');
INSERT INTO `lang_definitions` VALUES (3614, 727, 3, 'Se aplica al formulario de Constantes Vitales y Gráfica de Crecimiento');
INSERT INTO `lang_definitions` VALUES (3615, 729, 3, '¿Aplicar los cambios sólo al evento actual, a éste y todos los episodios futuros, o a todos los episodios?');
INSERT INTO `lang_definitions` VALUES (3616, 730, 3, 'aplicar a la zona afectada');
INSERT INTO `lang_definitions` VALUES (3617, 731, 3, 'aplicar a la piel');
INSERT INTO `lang_definitions` VALUES (3618, 732, 3, 'Aplicando');
INSERT INTO `lang_definitions` VALUES (3619, 733, 3, 'Aplicando parche al sitio');
INSERT INTO `lang_definitions` VALUES (3620, 734, 3, 'Cita');
INSERT INTO `lang_definitions` VALUES (3621, 736, 3, 'Fecha de Cita');
INSERT INTO `lang_definitions` VALUES (3622, 742, 3, 'Estilo de visualizacion de la cita');
INSERT INTO `lang_definitions` VALUES (3623, 744, 3, 'Regla para recordar Cita');
INSERT INTO `lang_definitions` VALUES (3624, 746, 3, 'Estado de la Cita');
INSERT INTO `lang_definitions` VALUES (3625, 747, 3, 'Estados de la cita');
INSERT INTO `lang_definitions` VALUES (3626, 748, 3, 'Cita dentro de');
INSERT INTO `lang_definitions` VALUES (3627, 749, 3, 'Color de Cita/Evento');
INSERT INTO `lang_definitions` VALUES (3628, 750, 3, 'Citas');
INSERT INTO `lang_definitions` VALUES (3629, 751, 3, 'Citas (escriba opcional)');
INSERT INTO `lang_definitions` VALUES (3630, 752, 3, 'Citas (escribir, algunos opcional)');
INSERT INTO `lang_definitions` VALUES (3631, 758, 3, 'Citas y Visitas');
INSERT INTO `lang_definitions` VALUES (3632, 759, 3, 'Encuentros para');
INSERT INTO `lang_definitions` VALUES (3633, 760, 3, 'Informe de citas');
INSERT INTO `lang_definitions` VALUES (3634, 761, 3, 'Informes Citas-Visitas');
INSERT INTO `lang_definitions` VALUES (3635, 764, 3, 'Aprobar');
INSERT INTO `lang_definitions` VALUES (3636, 767, 3, 'Aprobado');
INSERT INTO `lang_definitions` VALUES (3637, 768, 3, 'Eventos Administrativos Aprobados');
INSERT INTO `lang_definitions` VALUES (3638, 774, 3, 'Citas-Visitas');
INSERT INTO `lang_definitions` VALUES (3639, 776, 3, 'Citas');
INSERT INTO `lang_definitions` VALUES (3640, 779, 3, 'Abr');
INSERT INTO `lang_definitions` VALUES (3641, 780, 3, 'Abril');
INSERT INTO `lang_definitions` VALUES (3642, 782, 3, 'Arábigo');
INSERT INTO `lang_definitions` VALUES (3643, 783, 3, 'Aragonés');
INSERT INTO `lang_definitions` VALUES (3644, 784, 3, 'Archivo');
INSERT INTO `lang_definitions` VALUES (3645, 785, 3, 'Archivar los Registros Cronológicos');
INSERT INTO `lang_definitions` VALUES (3646, 786, 3, 'Archivas Registros (Logs) Viejos');
INSERT INTO `lang_definitions` VALUES (3647, 787, 3, '¿Se traducen los nombres del grupo de control de acceso?');
INSERT INTO `lang_definitions` VALUES (3648, 788, 3, '¿Se traducen los nombres de las categorías de cita?');
INSERT INTO `lang_definitions` VALUES (3649, 789, 3, '¿Se traducen los nombres de categorías de documento?');
INSERT INTO `lang_definitions` VALUES (3650, 790, 3, '¿Se cobran honorarios por este tipo?');
INSERT INTO `lang_definitions` VALUES (3651, 791, 3, 'están apagados');
INSERT INTO `lang_definitions` VALUES (3652, 792, 3, 'están encendidos');
INSERT INTO `lang_definitions` VALUES (3653, 793, 3, '¿Se traducen los títulos de las notas del paciente?');
INSERT INTO `lang_definitions` VALUES (3654, 794, 3, '¿Están los códigos archivados en tablas sql externas (0-No, 1-CIE10, 2-SNOMED(RF1), 3-SNOMED(rf2))?');
INSERT INTO `lang_definitions` VALUES (3655, 795, 3, '¿Está preparado para completar una nueva incidencia de GCAC (Global Connection Admission Control) para esta visita?');
INSERT INTO `lang_definitions` VALUES (3656, 797, 3, '¿Está seguro de enviar hoy?');
INSERT INTO `lang_definitions` VALUES (3657, 798, 3, '¿Está seguro que quiere aprobar estos eventos?');
INSERT INTO `lang_definitions` VALUES (3658, 799, 3, '¿Está seguro de querer cancelar los cambios?');
INSERT INTO `lang_definitions` VALUES (3659, 801, 3, '¿Está seguro de que desea eliminar por completo este formulario?');
INSERT INTO `lang_definitions` VALUES (3660, 804, 3, '¿Está seguro que desea eliminar este aviso?');
INSERT INTO `lang_definitions` VALUES (3661, 805, 3, '¿Está seguro que quiere eliminar este evento?');
INSERT INTO `lang_definitions` VALUES (3662, 806, 3, '¿Está seguro que quiere eliminar este asunto de la base de datos?');
INSERT INTO `lang_definitions` VALUES (3663, 808, 3, '¿Está usted seguro que quiere eliminar esta nota?');
INSERT INTO `lang_definitions` VALUES (3664, 810, 3, '¿Está seguro que quiere editar estos eventos?');
INSERT INTO `lang_definitions` VALUES (3665, 811, 3, '¿Está seguro que quiere ocultar estos eventos?');
INSERT INTO `lang_definitions` VALUES (3666, 814, 3, '¿Está seguro que quiere visualizar estos eventos?');
INSERT INTO `lang_definitions` VALUES (3667, 815, 3, 'Está seguro que desea eliminar el grupo entero nombrado');
INSERT INTO `lang_definitions` VALUES (3668, 816, 3, 'Está seguro que desea eliminar la lista entera');
INSERT INTO `lang_definitions` VALUES (3669, 817, 3, 'Está seguro que quiere eliminar el campo interno');
INSERT INTO `lang_definitions` VALUES (3670, 818, 3, '¿Está seguro que quiere eliminar los campos seleccionados?');
INSERT INTO `lang_definitions` VALUES (3671, 819, 3, '¿Está seguro que quiere continuar con estas acciones?');
INSERT INTO `lang_definitions` VALUES (3672, 820, 3, 'Zona no especificada');
INSERT INTO `lang_definitions` VALUES (3673, 821, 3, 'Brazo');
INSERT INTO `lang_definitions` VALUES (3674, 822, 3, 'Armenio');
INSERT INTO `lang_definitions` VALUES (3675, 829, 3, 'Arritmia');
INSERT INTO `lang_definitions` VALUES (3676, 830, 3, 'Artritis');
INSERT INTO `lang_definitions` VALUES (3677, 831, 3, 'Artritis/Enfermedad degenerativa de articulaciones');
INSERT INTO `lang_definitions` VALUES (3678, 832, 3, 'Artritis/Enfermedad degenerativa de articulaciones');
INSERT INTO `lang_definitions` VALUES (3679, 836, 3, 'como');
INSERT INTO `lang_definitions` VALUES (3680, 838, 3, 'Desde');
INSERT INTO `lang_definitions` VALUES (3681, 845, 3, 'Asiático');
INSERT INTO `lang_definitions` VALUES (3682, 848, 3, 'Evaluación');
INSERT INTO `lang_definitions` VALUES (3683, 853, 3, 'Asignado a');
INSERT INTO `lang_definitions` VALUES (3684, 854, 3, 'Ayudante');
INSERT INTO `lang_definitions` VALUES (3685, 861, 3, 'Asma');
INSERT INTO `lang_definitions` VALUES (3686, 862, 3, 'en');
INSERT INTO `lang_definitions` VALUES (3687, 863, 3, 'Se requiere al menos un parámetro de búsqueda si selecciona Todos.');
INSERT INTO `lang_definitions` VALUES (3688, 866, 3, 'En el Escafoides');
INSERT INTO `lang_definitions` VALUES (3689, 867, 3, 'En el Escafoides:');
INSERT INTO `lang_definitions` VALUES (3690, 868, 3, 'Equipo de atletismo');
INSERT INTO `lang_definitions` VALUES (3691, 870, 3, 'Lesión Deportiva');
INSERT INTO `lang_definitions` VALUES (3692, 871, 3, 'Certificado CA de ATNA (Seguimiento de auditoría y autenticación del nodo)');
INSERT INTO `lang_definitions` VALUES (3693, 872, 3, 'Host de auditoría ATNA (Seguimiento de auditoría y autenticación del nodo)');
INSERT INTO `lang_definitions` VALUES (3694, 873, 3, 'Certificado local de ATNA (Seguimiento de auditoría y autenticación del nodo)');
INSERT INTO `lang_definitions` VALUES (3695, 874, 3, 'Puerto de auditoría ATNA (Seguimiento de auditoría y autenticación del nodo)');
INSERT INTO `lang_definitions` VALUES (3696, 877, 3, 'Atención');
INSERT INTO `lang_definitions` VALUES (3697, 879, 3, 'Atención');
INSERT INTO `lang_definitions` VALUES (3698, 890, 3, 'Auditoría Backups de inicio de sesión');
INSERT INTO `lang_definitions` VALUES (3699, 891, 3, 'Auditoría de inicio de sesión varios');
INSERT INTO `lang_definitions` VALUES (3700, 892, 3, 'Auditoría Orden de inicio de sesión');
INSERT INTO `lang_definitions` VALUES (3701, 893, 3, 'Auditoría registro inicio de sesión del paciente');
INSERT INTO `lang_definitions` VALUES (3702, 894, 3, 'Auditoría Planificación inicio sesión');
INSERT INTO `lang_definitions` VALUES (3703, 895, 3, 'Auditoría Administración de Seguridad inicio sesión');
INSERT INTO `lang_definitions` VALUES (3704, 896, 3, 'Auditoría Consulta SELECT inicio sesión');
INSERT INTO `lang_definitions` VALUES (3705, 898, 3, 'Ago');
INSERT INTO `lang_definitions` VALUES (3706, 899, 3, 'Agosto');
INSERT INTO `lang_definitions` VALUES (3707, 901, 3, 'Autorización');
INSERT INTO `lang_definitions` VALUES (3708, 902, 3, 'Autorización/notas');
INSERT INTO `lang_definitions` VALUES (3709, 922, 3, 'Grupo de Autorización');
INSERT INTO `lang_definitions` VALUES (3710, 923, 3, 'Estatus de autorización');
INSERT INTO `lang_definitions` VALUES (3711, 924, 3, 'Autorizaciones');
INSERT INTO `lang_definitions` VALUES (3712, 925, 3, 'Autorizar');
INSERT INTO `lang_definitions` VALUES (3713, 926, 3, 'Autorizar - cualquier visita');
INSERT INTO `lang_definitions` VALUES (3714, 928, 3, 'Autorizar - mis visitas');
INSERT INTO `lang_definitions` VALUES (3715, 934, 3, 'Autorizado');
INSERT INTO `lang_definitions` VALUES (3716, 936, 3, 'Autorización solamente');
INSERT INTO `lang_definitions` VALUES (3717, 941, 3, 'Envío automático');
INSERT INTO `lang_definitions` VALUES (3718, 944, 3, 'Crear automáticamente nuevas visitas');
INSERT INTO `lang_definitions` VALUES (3719, 945, 3, 'Auto-generado');
INSERT INTO `lang_definitions` VALUES (3720, 947, 3, 'Cálculos Automáticos de Medida (CAM)');
INSERT INTO `lang_definitions` VALUES (3721, 952, 3, 'Seguimiento Cálculos Automáticos de Medida (CAM)');
INSERT INTO `lang_definitions` VALUES (3722, 953, 3, 'Medidas Automatizadas');
INSERT INTO `lang_definitions` VALUES (3723, 955, 3, 'Automático');
INSERT INTO `lang_definitions` VALUES (3724, 959, 3, 'Crear automáticamente nuevas visitas cuando en el estado de una cita se selecciona -@- (llegado)');
INSERT INTO `lang_definitions` VALUES (3725, 962, 3, 'Automóvil Médico');
INSERT INTO `lang_definitions` VALUES (3726, 964, 3, 'Autoguardado');
INSERT INTO `lang_definitions` VALUES (3727, 967, 3, 'Categorías Disponibles');
INSERT INTO `lang_definitions` VALUES (3728, 971, 3, 'Horas disponibles');
INSERT INTO `lang_definitions` VALUES (3729, 976, 3, 'Media Mensual');
INSERT INTO `lang_definitions` VALUES (3730, 980, 3, 'Avulsión/fractura por avulsión');
INSERT INTO `lang_definitions` VALUES (3731, 981, 3, 'Avulsión de maleolo lateral');
INSERT INTO `lang_definitions` VALUES (3732, 982, 3, 'Avulsión de maléolo tibial');
INSERT INTO `lang_definitions` VALUES (3733, 983, 3, 'Basado en el Conocimiento');
INSERT INTO `lang_definitions` VALUES (3734, 985, 3, 'Axilar');
INSERT INTO `lang_definitions` VALUES (3735, 992, 3, 'dos veces por día');
INSERT INTO `lang_definitions` VALUES (3736, 993, 3, 'Atrás');
INSERT INTO `lang_definitions` VALUES (3737, 994, 3, 'atrás');
INSERT INTO `lang_definitions` VALUES (3738, 995, 3, 'Retrocede ocho visitas');
INSERT INTO `lang_definitions` VALUES (3739, 996, 3, 'Retrocede once visitas');
INSERT INTO `lang_definitions` VALUES (3740, 997, 3, 'Retroceder cinco visitas');
INSERT INTO `lang_definitions` VALUES (3741, 998, 3, 'Retrocede cuatro visitas');
INSERT INTO `lang_definitions` VALUES (3742, 999, 3, 'Retrocede nueve visitas');
INSERT INTO `lang_definitions` VALUES (3743, 1000, 3, 'Retroced una visita');
INSERT INTO `lang_definitions` VALUES (3744, 1001, 3, 'Dolor de espalda');
INSERT INTO `lang_definitions` VALUES (3745, 1002, 3, 'Problemas de espalda');
INSERT INTO `lang_definitions` VALUES (3746, 1003, 3, 'Retrocede siete visitas');
INSERT INTO `lang_definitions` VALUES (3747, 1004, 3, 'Retrocede seis visitas');
INSERT INTO `lang_definitions` VALUES (3748, 1005, 3, 'Cirugia de espalda');
INSERT INTO `lang_definitions` VALUES (3749, 1006, 3, 'Retrocede diez visitas');
INSERT INTO `lang_definitions` VALUES (3750, 1007, 3, 'Retrocede tres visitas');
INSERT INTO `lang_definitions` VALUES (3751, 1008, 3, 'Volver a la página de Administración');
INSERT INTO `lang_definitions` VALUES (3752, 1013, 3, 'Volver al paciente');
INSERT INTO `lang_definitions` VALUES (3753, 1015, 3, 'Volver a los usuarios');
INSERT INTO `lang_definitions` VALUES (3754, 1016, 3, 'Volver a Vista');
INSERT INTO `lang_definitions` VALUES (3755, 1017, 3, 'Retrocede doce visitas');
INSERT INTO `lang_definitions` VALUES (3756, 1018, 3, 'Retrocede dos visitas');
INSERT INTO `lang_definitions` VALUES (3757, 1020, 3, 'Backup');
INSERT INTO `lang_definitions` VALUES (3758, 1022, 3, 'Se ha creado el fichero de backup. Ahora comenzará la descarga.');
INSERT INTO `lang_definitions` VALUES (3759, 1024, 3, 'Backup creado correctamente');
INSERT INTO `lang_definitions` VALUES (3760, 1025, 3, 'Cheque sin fondos');
INSERT INTO `lang_definitions` VALUES (3761, 1026, 3, 'Mal crédito');
INSERT INTO `lang_definitions` VALUES (3762, 1027, 3, 'Bahasa Indonesia');
INSERT INTO `lang_definitions` VALUES (3763, 1028, 3, 'Bal');
INSERT INTO `lang_definitions` VALUES (3764, 1031, 3, 'Balance');
INSERT INTO `lang_definitions` VALUES (3765, 1032, 3, 'balance');
INSERT INTO `lang_definitions` VALUES (3766, 1033, 3, 'Importe Balance');
INSERT INTO `lang_definitions` VALUES (3767, 1034, 3, 'Balance a pagar');
INSERT INTO `lang_definitions` VALUES (3768, 1038, 3, 'Recibo bancario');
INSERT INTO `lang_definitions` VALUES (3769, 1042, 3, 'Base del quinto (5to) Metatarsiano');
INSERT INTO `lang_definitions` VALUES (3770, 1043, 3, 'Base del quinto (5to) Metatarsiano:');
INSERT INTO `lang_definitions` VALUES (3771, 1051, 3, 'Herramienta de Comunicación del Batch');
INSERT INTO `lang_definitions` VALUES (3772, 1053, 3, 'Batch de entrada de pagos');
INSERT INTO `lang_definitions` VALUES (3773, 1054, 3, 'Serie de Pagos');
INSERT INTO `lang_definitions` VALUES (3774, 1055, 3, 'Iniciado proceso Batch; esto puede tardar unos minutos.');
INSERT INTO `lang_definitions` VALUES (3775, 1056, 3, 'Resultados de la serie (Batch)');
INSERT INTO `lang_definitions` VALUES (3776, 1057, 3, 'Comunicación en serie');
INSERT INTO `lang_definitions` VALUES (3777, 1063, 3, 'porque no existe ese id.');
INSERT INTO `lang_definitions` VALUES (3778, 1072, 3, 'Empezar');
INSERT INTO `lang_definitions` VALUES (3779, 1074, 3, 'Fecha comienzo');
INSERT INTO `lang_definitions` VALUES (3780, 1077, 3, 'Fecha de inicio de servicio aaaa-mm-dd');
INSERT INTO `lang_definitions` VALUES (3781, 1078, 3, 'Hora de inicio del día para los eventos del calendario');
INSERT INTO `lang_definitions` VALUES (3782, 1082, 3, 'Eructo');
INSERT INTO `lang_definitions` VALUES (3783, 1086, 3, 'Bengali');
INSERT INTO `lang_definitions` VALUES (3784, 1089, 3, 'entre');
INSERT INTO `lang_definitions` VALUES (3785, 1095, 3, 'Bilateral');
INSERT INTO `lang_definitions` VALUES (3786, 1096, 3, 'Bilateral:');
INSERT INTO `lang_definitions` VALUES (3787, 1099, 3, 'Fecha factura:');
INSERT INTO `lang_definitions` VALUES (3788, 1101, 3, 'Factura/Cobrar');
INSERT INTO `lang_definitions` VALUES (3789, 1102, 3, 'Facturado');
INSERT INTO `lang_definitions` VALUES (3790, 1104, 3, 'Facturación');
INSERT INTO `lang_definitions` VALUES (3791, 1105, 3, 'Facturación (escritura opcional)');
INSERT INTO `lang_definitions` VALUES (3792, 1109, 3, 'Atención facturación');
INSERT INTO `lang_definitions` VALUES (3793, 1111, 3, 'Código de facturación para el Servicio Solicitado');
INSERT INTO `lang_definitions` VALUES (3794, 1112, 3, 'Códigos de facturación');
INSERT INTO `lang_definitions` VALUES (3795, 1113, 3, 'Datos de facturación');
INSERT INTO `lang_definitions` VALUES (3796, 1114, 3, 'Departamento de Facturación');
INSERT INTO `lang_definitions` VALUES (3797, 1115, 3, 'Centro de Facturación');
INSERT INTO `lang_definitions` VALUES (3798, 1117, 3, 'Información facturación');
INSERT INTO `lang_definitions` VALUES (3799, 1118, 3, 'Dirección facturación');
INSERT INTO `lang_definitions` VALUES (3800, 1125, 3, 'Administrador de Facturación');
INSERT INTO `lang_definitions` VALUES (3801, 1126, 3, 'Nota de facturación');
INSERT INTO `lang_definitions` VALUES (3802, 1127, 3, 'Nota de facturación para');
INSERT INTO `lang_definitions` VALUES (3803, 1128, 3, 'Nota de facturación:');
INSERT INTO `lang_definitions` VALUES (3804, 1130, 3, 'Resultados de la cola de la facturación:');
INSERT INTO `lang_definitions` VALUES (3805, 1131, 3, 'Informe de Facturación');
INSERT INTO `lang_definitions` VALUES (3806, 1132, 3, 'Estado de facturación');
INSERT INTO `lang_definitions` VALUES (3807, 1133, 3, 'Estado de Facturación = No facturados');
INSERT INTO `lang_definitions` VALUES (3808, 1134, 3, 'facturación para');
INSERT INTO `lang_definitions` VALUES (3809, 1138, 3, 'Biopsia');
INSERT INTO `lang_definitions` VALUES (3810, 1140, 3, 'F.Nacim.');
INSERT INTO `lang_definitions` VALUES (3811, 1144, 3, 'Negro');
INSERT INTO `lang_definitions` VALUES (3812, 1147, 3, 'Pulmón negro');
INSERT INTO `lang_definitions` VALUES (3813, 1148, 3, 'Negro o Afroamericano');
INSERT INTO `lang_definitions` VALUES (3814, 1149, 3, 'Cáncer de vejiga');
INSERT INTO `lang_definitions` VALUES (3815, 1150, 3, 'Infecciones de vejiga');
INSERT INTO `lang_definitions` VALUES (3816, 1152, 3, 'Formularios en Blanco');
INSERT INTO `lang_definitions` VALUES (3817, 1153, 3, 'Problemas de sangrado');
INSERT INTO `lang_definitions` VALUES (3818, 1154, 3, 'Puntos ciegos');
INSERT INTO `lang_definitions` VALUES (3819, 1156, 3, 'Hinchazón');
INSERT INTO `lang_definitions` VALUES (3820, 1158, 3, 'Atascado');
INSERT INTO `lang_definitions` VALUES (3821, 1159, 3, 'Sangre');
INSERT INTO `lang_definitions` VALUES (3822, 1160, 3, 'Presión Arterial');
INSERT INTO `lang_definitions` VALUES (3823, 1161, 3, 'Presión arterial');
INSERT INTO `lang_definitions` VALUES (3824, 1162, 3, 'Sangra por la nariz');
INSERT INTO `lang_definitions` VALUES (3825, 1163, 3, 'Blue Cross Blue Shield');
INSERT INTO `lang_definitions` VALUES (3826, 1165, 3, 'Las líneas azules en este reporte son informativas. Líneas negras muestran información existente. Líneas verdes muestran cambios aplicados correctamente. Líneas rojas indican errores o cambios que no fueron aplicados, y deben ser procesados manualmente. Reclamaciones actuales denegadas y pagos revertidos no se manejan automáticamente y aparecerán en rojo.');
INSERT INTO `lang_definitions` VALUES (3827, 1166, 3, 'Visión borrosa');
INSERT INTO `lang_definitions` VALUES (3828, 1167, 3, 'IMC');
INSERT INTO `lang_definitions` VALUES (3829, 1168, 3, 'Estado del IMC');
INSERT INTO `lang_definitions` VALUES (3830, 1170, 3, 'Región corporal');
INSERT INTO `lang_definitions` VALUES (3831, 1171, 3, 'Área Corporal');
INSERT INTO `lang_definitions` VALUES (3832, 1172, 3, 'Área corporal, si es aplicable');
INSERT INTO `lang_definitions` VALUES (3833, 1173, 3, 'Sensibilidad en hueso:');
INSERT INTO `lang_definitions` VALUES (3834, 1174, 3, 'Sensibilidad en hueso: Maléolo Tibial');
INSERT INTO `lang_definitions` VALUES (3835, 1175, 3, 'Boleano');
INSERT INTO `lang_definitions` VALUES (3836, 1177, 3, 'Infer.');
INSERT INTO `lang_definitions` VALUES (3837, 1179, 3, 'Ambos Oídos');
INSERT INTO `lang_definitions` VALUES (3838, 1180, 3, 'ambos oídos');
INSERT INTO `lang_definitions` VALUES (3839, 1183, 3, 'inferior');
INSERT INTO `lang_definitions` VALUES (3840, 1187, 3, 'CASILLA 10 A. relacionados con el Empleo');
INSERT INTO `lang_definitions` VALUES (3841, 1189, 3, 'CASILLA 10 B. Accidentes de tráfico');
INSERT INTO `lang_definitions` VALUES (3842, 1191, 3, 'CASILLA 10 C. Otros Accidentes');
INSERT INTO `lang_definitions` VALUES (3843, 1205, 3, 'CASILLA 15. Fecha de la misma o similar enfermedad (aaaa-mm-dd)');
INSERT INTO `lang_definitions` VALUES (3844, 1211, 3, 'CASILLA 16. Fecha de incapacidad a partir de (aaaa-mm-dd):');
INSERT INTO `lang_definitions` VALUES (3845, 1215, 3, 'CASILLA 16. Fecha de incapacidad (aaaa-mm-dd):');
INSERT INTO `lang_definitions` VALUES (3846, 1227, 3, 'CASILLA 18. Fecha de inicio de hospitalización (aaaa-mm-dd):');
INSERT INTO `lang_definitions` VALUES (3847, 1231, 3, 'CASILLA 18. Fecha de inicio de hospitalización (aaaa-mm-dd):');
INSERT INTO `lang_definitions` VALUES (3848, 1235, 3, 'CASILLA 20. ¿Se utiliza Laboratorio externo?');
INSERT INTO `lang_definitions` VALUES (3849, 1239, 3, 'CASILLA 22. Código del re-envío de Medicaid (CIE-9)');
INSERT INTO `lang_definitions` VALUES (3850, 1243, 3, 'CASILLA 23. Número de Autorización previa');
INSERT INTO `lang_definitions` VALUES (3851, 1244, 3, 'PA');
INSERT INTO `lang_definitions` VALUES (3852, 1245, 3, 'PA Diastólica');
INSERT INTO `lang_definitions` VALUES (3853, 1246, 3, 'PA Sistólica');
INSERT INTO `lang_definitions` VALUES (3854, 1248, 3, 'Pad');
INSERT INTO `lang_definitions` VALUES (3855, 1252, 3, 'Pas');
INSERT INTO `lang_definitions` VALUES (3856, 1254, 3, 'Portugués brasileño');
INSERT INTO `lang_definitions` VALUES (3857, 1255, 3, 'mama');
INSERT INTO `lang_definitions` VALUES (3858, 1256, 3, 'Biopsia de mama');
INSERT INTO `lang_definitions` VALUES (3859, 1257, 3, 'Secreción de la mama');
INSERT INTO `lang_definitions` VALUES (3860, 1258, 3, 'Enfermedad de la mama');
INSERT INTO `lang_definitions` VALUES (3861, 1259, 3, 'Revisión de mama');
INSERT INTO `lang_definitions` VALUES (3862, 1260, 3, 'Masa en la mama');
INSERT INTO `lang_definitions` VALUES (3863, 1262, 3, 'Sonidos respiratorios:');
INSERT INTO `lang_definitions` VALUES (3864, 1265, 3, 'Huesos fracturados');
INSERT INTO `lang_definitions` VALUES (3865, 1267, 3, 'Forma de bronquitis');
INSERT INTO `lang_definitions` VALUES (3866, 1270, 3, 'Explorar');
INSERT INTO `lang_definitions` VALUES (3867, 1271, 3, 'Explorar para Registro');
INSERT INTO `lang_definitions` VALUES (3868, 1272, 3, 'Contusiones/Hematomas');
INSERT INTO `lang_definitions` VALUES (3869, 1276, 3, 'Abultamiento derecho:');
INSERT INTO `lang_definitions` VALUES (3870, 1278, 3, 'Ardor al orinar');
INSERT INTO `lang_definitions` VALUES (3871, 1279, 3, 'Ardor Al Orinar');
INSERT INTO `lang_definitions` VALUES (3872, 1282, 3, 'Ocupado');
INSERT INTO `lang_definitions` VALUES (3873, 1283, 3, 'pero todavía no procesado.');
INSERT INTO `lang_definitions` VALUES (3874, 1284, 3, 'Glúteo');
INSERT INTO `lang_definitions` VALUES (3875, 1285, 3, 'Gluteos + S.I.');
INSERT INTO `lang_definitions` VALUES (3876, 1286, 3, 'por');
INSERT INTO `lang_definitions` VALUES (3877, 1287, 3, 'Por');
INSERT INTO `lang_definitions` VALUES (3878, 1293, 3, 'por boca');
INSERT INTO `lang_definitions` VALUES (3879, 1295, 3, 'Por/Origen');
INSERT INTO `lang_definitions` VALUES (3880, 1296, 3, 'Por:');
INSERT INTO `lang_definitions` VALUES (3881, 1299, 3, 'C');
INSERT INTO `lang_definitions` VALUES (3882, 1301, 3, 'Certificado de CA para verificar el RFC 5425 TLS del servidor syslog.');
INSERT INTO `lang_definitions` VALUES (3883, 1302, 3, 'Tiempo de Vida del Caché (en segundos)');
INSERT INTO `lang_definitions` VALUES (3884, 1303, 3, '¿Plantilla de salida del caché?');
INSERT INTO `lang_definitions` VALUES (3885, 1305, 3, 'Consumo de cafeína');
INSERT INTO `lang_definitions` VALUES (3886, 1306, 3, 'Calendario');
INSERT INTO `lang_definitions` VALUES (3887, 1307, 3, 'Fin Hora Calendario');
INSERT INTO `lang_definitions` VALUES (3888, 1308, 3, 'Intervalo Calendario');
INSERT INTO `lang_definitions` VALUES (3889, 1309, 3, 'Pantalla de calendario');
INSERT INTO `lang_definitions` VALUES (3890, 1310, 3, 'Ajustes del calendario');
INSERT INTO `lang_definitions` VALUES (3891, 1312, 3, 'Hora de inicio de calendario');
INSERT INTO `lang_definitions` VALUES (3892, 1313, 3, 'Calendario UI');
INSERT INTO `lang_definitions` VALUES (3893, 1314, 3, 'Vista de Calendario');
INSERT INTO `lang_definitions` VALUES (3894, 1317, 3, 'Llamada para añadir Formulario () va aquí.<br>');
INSERT INTO `lang_definitions` VALUES (3895, 1321, 3, 'Calorías');
INSERT INTO `lang_definitions` VALUES (3896, 1322, 3, 'Camboyano');
INSERT INTO `lang_definitions` VALUES (3897, 1323, 3, 'CAMOS');
INSERT INTO `lang_definitions` VALUES (3898, 1329, 3, 'Cancelar');
INSERT INTO `lang_definitions` VALUES (3899, 1332, 3, 'Cancelar cambios');
INSERT INTO `lang_definitions` VALUES (3900, 1333, 3, 'Cancelado');
INSERT INTO `lang_definitions` VALUES (3901, 1335, 3, 'Cáncer');
INSERT INTO `lang_definitions` VALUES (3902, 1336, 3, 'Detección de Cancer: Detección Cancer de Colon');
INSERT INTO `lang_definitions` VALUES (3903, 1337, 3, 'Detección de Cancer: Mamografía');
INSERT INTO `lang_definitions` VALUES (3904, 1338, 3, 'Detección de Cancer: Prueba de Papanicolau');
INSERT INTO `lang_definitions` VALUES (3905, 1339, 3, 'Detección de Cancer: Detección de Cancer de Próstata');
INSERT INTO `lang_definitions` VALUES (3906, 1340, 3, 'No se puede agregar esta entrada, ¡porque ya existe!');
INSERT INTO `lang_definitions` VALUES (3907, 1341, 3, '¡No se puede agregar/actualizar esta entrada porque ya existe un duplicado!');
INSERT INTO `lang_definitions` VALUES (3908, 1343, 3, 'no puede convertirse a JPEG. ¿probablemente ImageMagick no está instalado?');
INSERT INTO `lang_definitions` VALUES (3909, 1345, 3, 'no se puede mostrar en línea porque su tipo no está soportado por el navegador.');
INSERT INTO `lang_definitions` VALUES (3910, 1346, 3, 'no se puede mostrar en línea porque su tipo no está soportado por el navegador');
INSERT INTO `lang_definitions` VALUES (3911, 1347, 3, 'no se puede mostrar en línea porque su tipo no está soportado por el navegador.');
INSERT INTO `lang_definitions` VALUES (3912, 1349, 3, 'No se puede crear');
INSERT INTO `lang_definitions` VALUES (3913, 1354, 3, 'No se puede encontrar');
INSERT INTO `lang_definitions` VALUES (3914, 1355, 3, 'No se puede encontrar fichero de destino');
INSERT INTO `lang_definitions` VALUES (3915, 1358, 3, 'No puede encontrar al paciente con ese ID de cliente en SQL-Ledger');
INSERT INTO `lang_definitions` VALUES (3916, 1359, 3, 'No se puede encontrar el documento de referencia de postscript en');
INSERT INTO `lang_definitions` VALUES (3917, 1360, 3, 'No puede encontrar al facultativo con SQL-Ledger empleado');
INSERT INTO `lang_definitions` VALUES (3918, 1361, 3, 'No puede modificar los pagos. La no-distribución es negativa.');
INSERT INTO `lang_definitions` VALUES (3919, 1363, 3, 'No se puede abrir');
INSERT INTO `lang_definitions` VALUES (3920, 1364, 3, 'No se puede enviar al seguro.La entidad pagadora seleccionada es el paciente.');
INSERT INTO `lang_definitions` VALUES (3921, 1365, 3, 'No puede enviar al Paciente. La Entidad pagadora seleccionada es el seguro.');
INSERT INTO `lang_definitions` VALUES (3922, 1366, 3, 'No puede enviar pagos. La distribución es negativa.');
INSERT INTO `lang_definitions` VALUES (3923, 1367, 3, 'No se puede leer');
INSERT INTO `lang_definitions` VALUES (3924, 1368, 3, 'No se puede leer el directorio');
INSERT INTO `lang_definitions` VALUES (3925, 1369, 3, '¡No se puede actualizar porque no está editando una entrada existente!.');
INSERT INTO `lang_definitions` VALUES (3926, 1370, 3, 'Poner en Mayúsculas');
INSERT INTO `lang_definitions` VALUES (3927, 1372, 3, 'cápsula');
INSERT INTO `lang_definitions` VALUES (3928, 1373, 3, 'Tarjeta');
INSERT INTO `lang_definitions` VALUES (3929, 1382, 3, 'Cateterismo Cardiaco');
INSERT INTO `lang_definitions` VALUES (3930, 1383, 3, 'Ecocardiograma');
INSERT INTO `lang_definitions` VALUES (3931, 1384, 3, 'Cardiovascular');
INSERT INTO `lang_definitions` VALUES (3932, 1396, 3, 'Daño de cartílago/ condral / disco articular.');
INSERT INTO `lang_definitions` VALUES (3933, 1397, 3, 'Lesión de cartílago');
INSERT INTO `lang_definitions` VALUES (3934, 1398, 3, 'Nl Pulsos Carotideos, pulsos pedios nl');
INSERT INTO `lang_definitions` VALUES (3935, 1400, 3, 'efectivo');
INSERT INTO `lang_definitions` VALUES (3936, 1401, 3, 'Efectivo');
INSERT INTO `lang_definitions` VALUES (3937, 1402, 3, 'Entradas Efectivo');
INSERT INTO `lang_definitions` VALUES (3938, 1403, 3, 'Entradas de efectivo por facultativo');
INSERT INTO `lang_definitions` VALUES (3939, 1406, 3, 'Cirugía de cataratas');
INSERT INTO `lang_definitions` VALUES (3940, 1407, 3, 'Cataratas');
INSERT INTO `lang_definitions` VALUES (3941, 1408, 3, 'Categorías');
INSERT INTO `lang_definitions` VALUES (3942, 1409, 3, 'Categorías para');
INSERT INTO `lang_definitions` VALUES (3943, 1410, 3, 'Categoría');
INSERT INTO `lang_definitions` VALUES (3944, 1411, 3, 'categoría');
INSERT INTO `lang_definitions` VALUES (3945, 1412, 3, 'Categoría');
INSERT INTO `lang_definitions` VALUES (3946, 1416, 3, 'Detalles de Categoría');
INSERT INTO `lang_definitions` VALUES (3947, 1417, 3, 'Límites de Categoría');
INSERT INTO `lang_definitions` VALUES (3948, 1418, 3, 'Nombre de Categoría');
INSERT INTO `lang_definitions` VALUES (3949, 1419, 3, 'Nombre de la Categoria está vacío');
INSERT INTO `lang_definitions` VALUES (3950, 1420, 3, 'Categoría/Título');
INSERT INTO `lang_definitions` VALUES (3951, 1421, 3, 'Caucásico');
INSERT INTO `lang_definitions` VALUES (3952, 1422, 3, 'Imprime la receta de la visita con la información del proveedor primario');
INSERT INTO `lang_definitions` VALUES (3953, 1442, 3, 'CDR');
INSERT INTO `lang_definitions` VALUES (3954, 1444, 3, 'Celda');
INSERT INTO `lang_definitions` VALUES (3955, 1445, 3, 'Teléfono Móvil');
INSERT INTO `lang_definitions` VALUES (3956, 1447, 3, 'Teléfono Móvil');
INSERT INTO `lang_definitions` VALUES (3957, 1449, 3, 'Certificación central');
INSERT INTO `lang_definitions` VALUES (3958, 1451, 3, 'Centroamericano/Sudamericano');
INSERT INTO `lang_definitions` VALUES (3959, 1452, 3, 'La localización del fichero de Certificado de Autoridad crt no puede estar vacía');
INSERT INTO `lang_definitions` VALUES (3960, 1453, 3, 'La localizacion de la clave del fichero del Certificado de Autoridad no puede estar vacía');
INSERT INTO `lang_definitions` VALUES (3961, 1454, 3, 'Certificado para enviar a la RFC 5425 TLS del servidor syslog.');
INSERT INTO `lang_definitions` VALUES (3962, 1455, 3, 'Usuario del Certificado');
INSERT INTO `lang_definitions` VALUES (3963, 1456, 3, 'Certificados');
INSERT INTO `lang_definitions` VALUES (3964, 1458, 3, 'ChampUS');
INSERT INTO `lang_definitions` VALUES (3965, 1459, 3, 'ChampUSVA');
INSERT INTO `lang_definitions` VALUES (3966, 1460, 3, 'cambiar');
INSERT INTO `lang_definitions` VALUES (3967, 1461, 3, 'Cambio');
INSERT INTO `lang_definitions` VALUES (3968, 1462, 3, 'Cambia actividad');
INSERT INTO `lang_definitions` VALUES (3969, 1467, 3, 'Cambio en la Visión');
INSERT INTO `lang_definitions` VALUES (3970, 1468, 3, 'Cambio en la Visión');
INSERT INTO `lang_definitions` VALUES (3971, 1475, 3, 'Cambiado');
INSERT INTO `lang_definitions` VALUES (3972, 1476, 3, 'Intestino Cambiado');
INSERT INTO `lang_definitions` VALUES (3973, 1484, 3, 'Características');
INSERT INTO `lang_definitions` VALUES (3974, 1485, 3, 'Caracteres Restantes');
INSERT INTO `lang_definitions` VALUES (3975, 1486, 3, 'Cargo');
INSERT INTO `lang_definitions` VALUES (3976, 1487, 3, 'Ajuste del cargo');
INSERT INTO `lang_definitions` VALUES (3977, 1488, 3, 'Cobro codificado');
INSERT INTO `lang_definitions` VALUES (3978, 1490, 3, 'Cargos');
INSERT INTO `lang_definitions` VALUES (3979, 1491, 3, 'Historia');
INSERT INTO `lang_definitions` VALUES (3980, 1492, 3, 'Gráfico de Actividad');
INSERT INTO `lang_definitions` VALUES (3981, 1493, 3, 'Informe de Actividad - Entradas/Salidas de gráficos');
INSERT INTO `lang_definitions` VALUES (3982, 1495, 3, 'Nº Identificación de gráfico');
INSERT INTO `lang_definitions` VALUES (3983, 1496, 3, 'Nº Identificación de gráfico:');
INSERT INTO `lang_definitions` VALUES (3984, 1498, 3, 'Actividad de Localización de Gráficos');
INSERT INTO `lang_definitions` VALUES (3985, 1499, 3, 'Nota en el gráfico');
INSERT INTO `lang_definitions` VALUES (3986, 1500, 3, 'Número de gráfico');
INSERT INTO `lang_definitions` VALUES (3987, 1502, 3, 'Gráfico de Localizaciones archivadas');
INSERT INTO `lang_definitions` VALUES (3988, 1504, 3, 'Gráfico de seguimiento');
INSERT INTO `lang_definitions` VALUES (3989, 1505, 3, 'Gráfico de seguimiento');
INSERT INTO `lang_definitions` VALUES (3990, 1508, 3, 'Gráficas retiradas');
INSERT INTO `lang_definitions` VALUES (3991, 1509, 3, 'Gráficas retiradas');
INSERT INTO `lang_definitions` VALUES (3992, 1513, 3, 'Comprobar');
INSERT INTO `lang_definitions` VALUES (3993, 1514, 3, 'comprobar');
INSERT INTO `lang_definitions` VALUES (3994, 1515, 3, 'Comprobar todo');
INSERT INTO `lang_definitions` VALUES (3995, 1517, 3, 'Importe del cheque');
INSERT INTO `lang_definitions` VALUES (3996, 1519, 3, 'Fecha del cheque');
INSERT INTO `lang_definitions` VALUES (3997, 1521, 3, 'Comprobar diferencias entre las traducciones con Tabla del Idioma Personalizada');
INSERT INTO `lang_definitions` VALUES (3998, 1527, 3, 'Llegue a');
INSERT INTO `lang_definitions` VALUES (3999, 1528, 3, 'Comprobar Fecha Entrada');
INSERT INTO `lang_definitions` VALUES (4000, 1530, 3, 'Revisar los Resultados de Laboratorio');
INSERT INTO `lang_definitions` VALUES (4001, 1533, 3, 'Número de cheque');
INSERT INTO `lang_definitions` VALUES (4002, 1536, 3, 'Pago por Cheque');
INSERT INTO `lang_definitions` VALUES (4003, 1537, 3, 'Marque la casilla si es un fichero encriptado');
INSERT INTO `lang_definitions` VALUES (4004, 1541, 3, 'Selecciona ésto si quiere que los facultativos vean todas las citas por defecto y no sólo las suyas.');
INSERT INTO `lang_definitions` VALUES (4005, 1545, 3, 'Comprobar Fecha/EOB:');
INSERT INTO `lang_definitions` VALUES (4006, 1547, 3, 'Comprobar Número EOB.:');
INSERT INTO `lang_definitions` VALUES (4007, 1548, 3, 'Comprobar/Número de Referencia');
INSERT INTO `lang_definitions` VALUES (4008, 1549, 3, 'Comprobar/Número de referencia');
INSERT INTO `lang_definitions` VALUES (4009, 1550, 3, 'Lista de casillas');
INSERT INTO `lang_definitions` VALUES (4010, 1551, 3, 'Lista de casillas');
INSERT INTO `lang_definitions` VALUES (4011, 1552, 3, 'Casilla con Texto');
INSERT INTO `lang_definitions` VALUES (4012, 1553, 3, 'Casilla con texto');
INSERT INTO `lang_definitions` VALUES (4013, 1557, 3, 'Comprobado');
INSERT INTO `lang_definitions` VALUES (4014, 1559, 3, 'Casilla marcada = sí, vacía = no');
INSERT INTO `lang_definitions` VALUES (4015, 1568, 3, 'Comprobación');
INSERT INTO `lang_definitions` VALUES (4016, 1569, 3, 'Sumatorio');
INSERT INTO `lang_definitions` VALUES (4017, 1570, 3, 'Pecho');
INSERT INTO `lang_definitions` VALUES (4018, 1571, 3, 'Pecho CTAB');
INSERT INTO `lang_definitions` VALUES (4019, 1572, 3, 'Dolor de Pecho');
INSERT INTO `lang_definitions` VALUES (4020, 1573, 3, 'Dolor de Pecho:');
INSERT INTO `lang_definitions` VALUES (4021, 1574, 3, 'Dolores de Pecho');
INSERT INTO `lang_definitions` VALUES (4022, 1576, 3, 'Var');
INSERT INTO `lang_definitions` VALUES (4023, 1578, 3, 'Síntoma Principal');
INSERT INTO `lang_definitions` VALUES (4024, 1581, 3, 'Niño');
INSERT INTO `lang_definitions` VALUES (4025, 1583, 3, 'Estado de vacunación de la niñez (GCC)');
INSERT INTO `lang_definitions` VALUES (4026, 1584, 3, 'Escalofríos');
INSERT INTO `lang_definitions` VALUES (4027, 1585, 3, 'Chino');
INSERT INTO `lang_definitions` VALUES (4028, 1586, 3, 'Chino (simplificado)');
INSERT INTO `lang_definitions` VALUES (4029, 1587, 3, 'Chino (tradicional)');
INSERT INTO `lang_definitions` VALUES (4030, 1589, 3, 'Opciones');
INSERT INTO `lang_definitions` VALUES (4031, 1590, 3, 'Colecistectomía');
INSERT INTO `lang_definitions` VALUES (4032, 1592, 3, 'Colecistectomía');
INSERT INTO `lang_definitions` VALUES (4033, 1593, 3, 'Elegir');
INSERT INTO `lang_definitions` VALUES (4034, 1596, 3, 'Elija una sección y haga click en un elemento dentro de ella; luego, en la otra sección, verá remarcados los elementos relacionados, puede hacer click en esa sección para añadir y borrar relaciones.');
INSERT INTO `lang_definitions` VALUES (4035, 1597, 3, 'Criterios de selección');
INSERT INTO `lang_definitions` VALUES (4036, 1605, 3, 'Lista de Selecciones');
INSERT INTO `lang_definitions` VALUES (4037, 1611, 3, 'Seleccione formato de impresión para este informe de visitas.');
INSERT INTO `lang_definitions` VALUES (4038, 1615, 3, 'Bronquitis Crónica');
INSERT INTO `lang_definitions` VALUES (4039, 1616, 3, 'Dolor crónico de articulaciones');
INSERT INTO `lang_definitions` VALUES (4040, 1617, 3, 'Enfermedad Renal Crónica (ERC)');
INSERT INTO `lang_definitions` VALUES (4041, 1620, 3, 'Sinovitis crónica/derrame/dolor articular/gota');
INSERT INTO `lang_definitions` VALUES (4042, 1622, 3, 'Crónico/Recurrente');
INSERT INTO `lang_definitions` VALUES (4043, 1625, 3, 'Cirrosis de hígado');
INSERT INTO `lang_definitions` VALUES (4044, 1626, 3, 'Cirrosis del Hígado');
INSERT INTO `lang_definitions` VALUES (4045, 1627, 3, 'Ciudad');
INSERT INTO `lang_definitions` VALUES (4046, 1629, 3, 'Nombre de Ciudad');
INSERT INTO `lang_definitions` VALUES (4047, 1630, 3, 'Ciudad, Provincia');
INSERT INTO `lang_definitions` VALUES (4048, 1631, 3, 'Ciudad, Código Postal');
INSERT INTO `lang_definitions` VALUES (4049, 1633, 3, 'Ciudad/Provincia');
INSERT INTO `lang_definitions` VALUES (4050, 1634, 3, 'Reclamación');
INSERT INTO `lang_definitions` VALUES (4051, 1635, 3, 'Reclamación');
INSERT INTO `lang_definitions` VALUES (4052, 1638, 3, 'Prueba de Reclamación ha terminado');
INSERT INTO `lang_definitions` VALUES (4053, 1639, 3, 'Tipo de Reclamación');
INSERT INTO `lang_definitions` VALUES (4054, 1640, 3, 'Reclamación generada para presentar');
INSERT INTO `lang_definitions` VALUES (4055, 1641, 3, 'La Reclamación se ha guardado en el fichero');
INSERT INTO `lang_definitions` VALUES (4056, 1642, 3, 'Reclamaciones');
INSERT INTO `lang_definitions` VALUES (4057, 1645, 3, 'Clasificación');
INSERT INTO `lang_definitions` VALUES (4058, 1646, 3, 'Limpiar');
INSERT INTO `lang_definitions` VALUES (4059, 1651, 3, 'Limpiar todos');
INSERT INTO `lang_definitions` VALUES (4060, 1654, 3, 'Limpiar Datos HL7');
INSERT INTO `lang_definitions` VALUES (4061, 1655, 3, 'Limpiar Justificación');
INSERT INTO `lang_definitions` VALUES (4062, 1659, 3, 'Vaciar Cache Smarty');
INSERT INTO `lang_definitions` VALUES (4063, 1661, 3, 'Información requerida por la Cámara de compensación en la creación del Batch EDI 270');
INSERT INTO `lang_definitions` VALUES (4064, 1662, 3, 'Número CLIA');
INSERT INTO `lang_definitions` VALUES (4065, 1663, 3, 'Click');
INSERT INTO `lang_definitions` VALUES (4066, 1664, 3, 'Click \'export\' para exportar su Categoría, Subcategoría, Item o Datos contenidos a un fichero de texto. Cualquier similitud de este fichero con un fichero tipo XML es pura coincidencia. Las etiquetas de abrir y cerrar deben estar en la misma línea y deben ser minúsculas sin espacios. Para importar, localize el fichero y click \'Importar\'. Si los datos son completamente diferentes se unen a los datos existentes. Si hay datos con nombres similares, el nombre más antiguo se mantiene mientras que al nuevo se le agrega un número al final.');
INSERT INTO `lang_definitions` VALUES (4067, 1667, 3, 'Click en el gráfico para nueva anotacion, click de nuevo para eliminarla.');
INSERT INTO `lang_definitions` VALUES (4068, 1671, 3, 'Click descargar Certificado para descargar los certificados en el fichero ssl.zip');
INSERT INTO `lang_definitions` VALUES (4069, 1672, 3, 'Click para más');
INSERT INTO `lang_definitions` VALUES (4070, 1678, 3, 'Click aquí');
INSERT INTO `lang_definitions` VALUES (4071, 1679, 3, 'Click aquí para añadir un nuevo paciente.');
INSERT INTO `lang_definitions` VALUES (4072, 1680, 3, 'Click aqui para añadir un nuevo cambio de estado de la lesion y editar la actividad diaria.');
INSERT INTO `lang_definitions` VALUES (4073, 1682, 3, 'Click aquí para elegir una fecha');
INSERT INTO `lang_definitions` VALUES (4074, 1683, 3, 'Click aquí para elegir una fecha y hora');
INSERT INTO `lang_definitions` VALUES (4075, 1684, 3, 'Click aquí para elegir una fecha de inicio');
INSERT INTO `lang_definitions` VALUES (4076, 1707, 3, 'Click aquí para buscar');
INSERT INTO `lang_definitions` VALUES (4077, 1710, 3, 'Click aquí para actualizar configuración de prioridad, categoría y apodos');
INSERT INTO `lang_definitions` VALUES (4078, 1714, 3, 'Click aquí para ver todo.');
INSERT INTO `lang_definitions` VALUES (4079, 1715, 3, 'Click aqui para vista y gráficos');
INSERT INTO `lang_definitions` VALUES (4080, 1717, 3, 'Click aquí para vista y grafico de todas las constantes vitales.');
INSERT INTO `lang_definitions` VALUES (4081, 1718, 3, 'Click aquí para ver los detalles del paciente');
INSERT INTO `lang_definitions` VALUES (4082, 1719, 3, 'Click aquí para ver todos.');
INSERT INTO `lang_definitions` VALUES (4083, 1723, 3, 'Click botón Instalar para instalar la versión de la base de datos desde la siguiente fecha');
INSERT INTO `lang_definitions` VALUES (4084, 1730, 3, 'Click aquí para aumentar los intervalos de tiempo');
INSERT INTO `lang_definitions` VALUES (4085, 1751, 3, 'Click en Nombre Paciente para abrir el fichero del paciente');
INSERT INTO `lang_definitions` VALUES (4086, 1753, 3, 'Click Refrescar para ver todos los resultados o introduzca un criterio de búsqueda arriba para ver resultados específicos.');
INSERT INTO `lang_definitions` VALUES (4087, 1779, 3, 'Nuevo Paciente');
INSERT INTO `lang_definitions` VALUES (4088, 1780, 3, 'Click para agregar nueva consulta');
INSERT INTO `lang_definitions` VALUES (4089, 1785, 3, 'Click para descargar');
INSERT INTO `lang_definitions` VALUES (4090, 1786, 3, 'Click para editar');
INSERT INTO `lang_definitions` VALUES (4091, 1788, 3, 'Click para editar este evento');
INSERT INTO `lang_definitions` VALUES (4092, 1790, 3, 'Click para generar el informe');
INSERT INTO `lang_definitions` VALUES (4093, 1800, 3, 'Click para imprimir');
INSERT INTO `lang_definitions` VALUES (4094, 1801, 3, 'Click para recibir (añadir) nuevo lote');
INSERT INTO `lang_definitions` VALUES (4095, 1805, 3, 'Click para seleccionar');
INSERT INTO `lang_definitions` VALUES (4096, 1806, 3, 'Click Para Seleccionar');
INSERT INTO `lang_definitions` VALUES (4097, 1808, 3, 'Click para seleccionar un código estándar industrial para este procedimiento');
INSERT INTO `lang_definitions` VALUES (4098, 1811, 3, 'Click para seleccionar el codigo de procedimiento opcional');
INSERT INTO `lang_definitions` VALUES (4099, 1813, 3, 'Click para seleccionar o cambiar código CVX');
INSERT INTO `lang_definitions` VALUES (4100, 1814, 3, 'Click para seleccionar o cambiar diagnósticos');
INSERT INTO `lang_definitions` VALUES (4101, 1815, 3, 'Click para seleccionar o cambiar códigos de servicios');
INSERT INTO `lang_definitions` VALUES (4102, 1816, 3, 'Click para seleccionar el paciente');
INSERT INTO `lang_definitions` VALUES (4103, 1817, 3, 'Click para seleccionar un código relacionado');
INSERT INTO `lang_definitions` VALUES (4104, 1819, 3, 'Click para seleccionar servicios a realizar si este resultado es anormal');
INSERT INTO `lang_definitions` VALUES (4105, 1822, 3, 'Click para seleccionar el procedimiento deseado');
INSERT INTO `lang_definitions` VALUES (4106, 1831, 3, 'Click para ver');
INSERT INTO `lang_definitions` VALUES (4107, 1833, 3, 'Click para ver o editar');
INSERT INTO `lang_definitions` VALUES (4108, 1834, 3, 'Click para ver/editar');
INSERT INTO `lang_definitions` VALUES (4109, 1836, 3, 'Click botón Actualizar para actualizar la versión de la base de datos desde la fecha siguiente');
INSERT INTO `lang_definitions` VALUES (4110, 1839, 3, 'Click:');
INSERT INTO `lang_definitions` VALUES (4111, 1862, 3, 'Días para Vencimiento del Certificado del Cliente');
INSERT INTO `lang_definitions` VALUES (4112, 1864, 3, 'Periodo de validación del Certificado del Cliente');
INSERT INTO `lang_definitions` VALUES (4113, 1865, 3, 'El certificado de validación del cliente debe ser un número válido');
INSERT INTO `lang_definitions` VALUES (4114, 1866, 3, 'Copia para el cliente');
INSERT INTO `lang_definitions` VALUES (4115, 1869, 3, 'Resumen de historia clínica del cliente');
INSERT INTO `lang_definitions` VALUES (4116, 1873, 3, 'Perfil de cliente - Nuevos Clientes');
INSERT INTO `lang_definitions` VALUES (4117, 1874, 3, 'Perfil de cliente - Clientes Únicos');
INSERT INTO `lang_definitions` VALUES (4118, 1878, 3, 'Clientes');
INSERT INTO `lang_definitions` VALUES (4119, 1879, 3, 'Clínica');
INSERT INTO `lang_definitions` VALUES (4120, 1880, 3, 'Copia para la Clínica');
INSERT INTO `lang_definitions` VALUES (4121, 1881, 3, 'Registro Diario de la Clínica');
INSERT INTO `lang_definitions` VALUES (4122, 1882, 3, 'Nº Identificación de Clínica');
INSERT INTO `lang_definitions` VALUES (4123, 1883, 3, 'Clínico');
INSERT INTO `lang_definitions` VALUES (4124, 1884, 3, 'Gestor de Alertas para las Reglas de Decisión Clinicas');
INSERT INTO `lang_definitions` VALUES (4125, 1889, 3, 'Planes Clínicos');
INSERT INTO `lang_definitions` VALUES (4126, 1890, 3, 'Medidas de Calidad Clínica (GCC)');
INSERT INTO `lang_definitions` VALUES (4127, 1893, 3, 'Recordatorios Clínicos');
INSERT INTO `lang_definitions` VALUES (4128, 1897, 3, 'Reportes Clínicos');
INSERT INTO `lang_definitions` VALUES (4129, 1898, 3, 'Reglas Clínicas para Categoría de Acción');
INSERT INTO `lang_definitions` VALUES (4130, 1899, 3, 'Reglas Clínicas para Asunto de Acción');
INSERT INTO `lang_definitions` VALUES (4131, 1900, 3, 'Reglas Clínicas para Métodos de filtro');
INSERT INTO `lang_definitions` VALUES (4132, 1901, 3, 'Reglas Clínicas para Objetivo de Métodos');
INSERT INTO `lang_definitions` VALUES (4133, 1902, 3, 'Reglas Clínicas');
INSERT INTO `lang_definitions` VALUES (4134, 1903, 3, 'Reglas Clínicas para Intervalos de Edad');
INSERT INTO `lang_definitions` VALUES (4135, 1904, 3, 'Reglas Clínicas de Comparación');
INSERT INTO `lang_definitions` VALUES (4136, 1905, 3, 'Reglas Clínicas de Tipos de Visitas');
INSERT INTO `lang_definitions` VALUES (4137, 1906, 3, 'Reglas Clínicas de opciones de Vencimientos de Recordatorios');
INSERT INTO `lang_definitions` VALUES (4138, 1907, 3, 'Reglas Clínicas de opciones de Desactivación de Recordatorios');
INSERT INTO `lang_definitions` VALUES (4139, 1908, 3, 'Reglas Clínicas de intervalos de recordatorios');
INSERT INTO `lang_definitions` VALUES (4140, 1909, 3, 'Reglas Clínicas de Métodos de Recordatorios');
INSERT INTO `lang_definitions` VALUES (4141, 1910, 3, 'Reglas Clínicas de Intervalos de Destino');
INSERT INTO `lang_definitions` VALUES (4142, 1911, 3, 'Destinos Clínicos');
INSERT INTO `lang_definitions` VALUES (4143, 1914, 3, 'Vista de Clínica');
INSERT INTO `lang_definitions` VALUES (4144, 1915, 3, 'Médicos');
INSERT INTO `lang_definitions` VALUES (4145, 1916, 3, 'Clonar');
INSERT INTO `lang_definitions` VALUES (4146, 1917, 3, 'Clonar Visita Anterior');
INSERT INTO `lang_definitions` VALUES (4147, 1918, 3, 'Cerrar');
INSERT INTO `lang_definitions` VALUES (4148, 1924, 3, 'Cerrar Ventana');
INSERT INTO `lang_definitions` VALUES (4149, 1925, 3, 'cerrar ventana');
INSERT INTO `lang_definitions` VALUES (4150, 1927, 3, 'Cerrado');
INSERT INTO `lang_definitions` VALUES (4151, 1928, 3, 'cm');
INSERT INTO `lang_definitions` VALUES (4152, 1931, 3, 'Margenes del formulario CMS 1500');
INSERT INTO `lang_definitions` VALUES (4153, 1940, 3, 'CMS ID');
INSERT INTO `lang_definitions` VALUES (4154, 1955, 3, 'NC 2-12 Intacto');
INSERT INTO `lang_definitions` VALUES (4155, 1958, 3, 'Copago');
INSERT INTO `lang_definitions` VALUES (4156, 1959, 3, 'Copago pagado');
INSERT INTO `lang_definitions` VALUES (4157, 1962, 3, 'Copago');
INSERT INTO `lang_definitions` VALUES (4158, 1964, 3, 'Código');
INSERT INTO `lang_definitions` VALUES (4159, 1965, 3, 'código');
INSERT INTO `lang_definitions` VALUES (4160, 1967, 3, 'Buscador de Código');
INSERT INTO `lang_definitions` VALUES (4161, 1968, 3, 'Código debe ser dos letras en minúscula');
INSERT INTO `lang_definitions` VALUES (4162, 1969, 3, 'Código o símbolo para indicar moneda');
INSERT INTO `lang_definitions` VALUES (4163, 1971, 3, 'Código de Texto');
INSERT INTO `lang_definitions` VALUES (4164, 1973, 3, 'tipo de código');
INSERT INTO `lang_definitions` VALUES (4165, 1976, 3, 'Típos de Código');
INSERT INTO `lang_definitions` VALUES (4166, 1978, 3, 'Codificado');
INSERT INTO `lang_definitions` VALUES (4167, 1979, 3, 'Códigos');
INSERT INTO `lang_definitions` VALUES (4168, 1981, 3, 'Codificando');
INSERT INTO `lang_definitions` VALUES (4169, 1983, 3, 'Codificación - cualquier visita(escribir, con algunas opciones)');
INSERT INTO `lang_definitions` VALUES (4170, 1985, 3, 'Codificación - mis visitas(escribir, con algunas opciones)');
INSERT INTO `lang_definitions` VALUES (4171, 1990, 3, 'Codificación no autorizada');
INSERT INTO `lang_definitions` VALUES (4172, 1991, 3, 'Café');
INSERT INTO `lang_definitions` VALUES (4173, 1994, 3, 'Coseguro');
INSERT INTO `lang_definitions` VALUES (4174, 1995, 3, 'Coll w/o');
INSERT INTO `lang_definitions` VALUES (4175, 1997, 3, 'Contraer');
INSERT INTO `lang_definitions` VALUES (4176, 1998, 3, 'contraer');
INSERT INTO `lang_definitions` VALUES (4177, 1999, 3, 'Contraer Todo');
INSERT INTO `lang_definitions` VALUES (4178, 2000, 3, 'Contraer todo');
INSERT INTO `lang_definitions` VALUES (4179, 2001, 3, 'contraer todo');
INSERT INTO `lang_definitions` VALUES (4180, 2005, 3, 'Fecha de recolecciòn');
INSERT INTO `lang_definitions` VALUES (4181, 2007, 3, 'Recobro');
INSERT INTO `lang_definitions` VALUES (4182, 2008, 3, 'Informe de Recobro');
INSERT INTO `lang_definitions` VALUES (4183, 2009, 3, 'Cáncer de colon');
INSERT INTO `lang_definitions` VALUES (4184, 2010, 3, 'Detección de Cáncer de colon');
INSERT INTO `lang_definitions` VALUES (4185, 2011, 3, 'Cirugía de Cáncer de colon');
INSERT INTO `lang_definitions` VALUES (4186, 2012, 3, 'Colonoscopia');
INSERT INTO `lang_definitions` VALUES (4187, 2013, 3, 'colonoscopía');
INSERT INTO `lang_definitions` VALUES (4188, 2014, 3, 'Color');
INSERT INTO `lang_definitions` VALUES (4189, 2020, 3, 'Abreviatura de color');
INSERT INTO `lang_definitions` VALUES (4190, 2021, 3, 'Colunma');
INSERT INTO `lang_definitions` VALUES (4191, 2022, 3, 'Columnas');
INSERT INTO `lang_definitions` VALUES (4192, 2024, 3, 'Combinando Lotes');
INSERT INTO `lang_definitions` VALUES (4193, 2025, 3, 'Coma');
INSERT INTO `lang_definitions` VALUES (4194, 2027, 3, 'Comentario');
INSERT INTO `lang_definitions` VALUES (4195, 2028, 3, 'Comentarios');
INSERT INTO `lang_definitions` VALUES (4196, 2030, 3, 'Comentarios para este resultado o recomendación');
INSERT INTO `lang_definitions` VALUES (4197, 2031, 3, 'Sociedad Comercial de Seguros');
INSERT INTO `lang_definitions` VALUES (4198, 2032, 3, 'Guardar Cambios');
INSERT INTO `lang_definitions` VALUES (4199, 2036, 3, 'Comunicaciones');
INSERT INTO `lang_definitions` VALUES (4200, 2039, 3, 'Compañía');
INSERT INTO `lang_definitions` VALUES (4201, 2040, 3, 'Nombre Empresa');
INSERT INTO `lang_definitions` VALUES (4202, 2041, 3, 'Completo');
INSERT INTO `lang_definitions` VALUES (4203, 2043, 3, 'Terminado');
INSERT INTO `lang_definitions` VALUES (4204, 2046, 3, 'Terminado?');
INSERT INTO `lang_definitions` VALUES (4205, 2049, 3, 'Conplicaciones por el proveedor de servicios');
INSERT INTO `lang_definitions` VALUES (4206, 2050, 3, 'Complicaciones de aborto');
INSERT INTO `lang_definitions` VALUES (4207, 2051, 3, 'Componentes');
INSERT INTO `lang_definitions` VALUES (4208, 2057, 3, 'Sistema Computarizado de Pedidos Médicos');
INSERT INTO `lang_definitions` VALUES (4209, 2058, 3, 'Conclusiones');
INSERT INTO `lang_definitions` VALUES (4210, 2063, 3, 'Config');
INSERT INTO `lang_definitions` VALUES (4211, 2064, 3, 'Configuración');
INSERT INTO `lang_definitions` VALUES (4212, 2065, 3, 'Configuración Exportar/Importar');
INSERT INTO `lang_definitions` VALUES (4213, 2067, 3, 'Configure Apache y OpenEMR para usar certificados SSL del Cliente');
INSERT INTO `lang_definitions` VALUES (4214, 2068, 3, 'Configure Apache para usar certificados SSL del Cliente');
INSERT INTO `lang_definitions` VALUES (4215, 2069, 3, 'Configure Apache para usar HTTPS');
INSERT INTO `lang_definitions` VALUES (4216, 2070, 3, 'Configure Openemr para usar certificado SSL del Cliente');
INSERT INTO `lang_definitions` VALUES (4217, 2079, 3, 'Confirma Crear Nuevo Paciente');
INSERT INTO `lang_definitions` VALUES (4218, 2081, 3, 'Confirmar Nueva Contraseña');
INSERT INTO `lang_definitions` VALUES (4219, 2083, 3, 'Confirmar Pago');
INSERT INTO `lang_definitions` VALUES (4220, 2092, 3, 'Congénito');
INSERT INTO `lang_definitions` VALUES (4221, 2094, 3, 'Conjuntiva, pupilas');
INSERT INTO `lang_definitions` VALUES (4222, 2097, 3, 'Conectores');
INSERT INTO `lang_definitions` VALUES (4223, 2098, 3, 'Constante');
INSERT INTO `lang_definitions` VALUES (4224, 2100, 3, 'Nombre constante');
INSERT INTO `lang_definitions` VALUES (4225, 2101, 3, 'Nombre constante está en blanco');
INSERT INTO `lang_definitions` VALUES (4226, 2102, 3, 'constantes');
INSERT INTO `lang_definitions` VALUES (4227, 2103, 3, 'Estreñimiento');
INSERT INTO `lang_definitions` VALUES (4228, 2104, 3, 'Constitucional');
INSERT INTO `lang_definitions` VALUES (4229, 2107, 3, 'Breve Descripción de Consulta');
INSERT INTO `lang_definitions` VALUES (4230, 2109, 3, 'Contacto');
INSERT INTO `lang_definitions` VALUES (4231, 2110, 3, 'email del contacto');
INSERT INTO `lang_definitions` VALUES (4232, 2111, 3, 'email de contacto');
INSERT INTO `lang_definitions` VALUES (4233, 2113, 3, 'Informacion de contacto');
INSERT INTO `lang_definitions` VALUES (4234, 2117, 3, 'Lentes de Contacto');
INSERT INTO `lang_definitions` VALUES (4235, 2122, 3, 'Nombre del contacto');
INSERT INTO `lang_definitions` VALUES (4236, 2125, 3, 'Persona de Contacto');
INSERT INTO `lang_definitions` VALUES (4237, 2127, 3, 'Número de Teléfono de Contacto');
INSERT INTO `lang_definitions` VALUES (4238, 2129, 3, 'Contactar ZMG, LLC (zmghealth@gmail.com) para suscribir el servicio de receta electrónica');
INSERT INTO `lang_definitions` VALUES (4239, 2131, 3, 'contiene por lo menos tres de las cuatro cosas siguientes:');
INSERT INTO `lang_definitions` VALUES (4240, 2133, 3, 'Contenido');
INSERT INTO `lang_definitions` VALUES (4241, 2134, 3, 'contenido');
INSERT INTO `lang_definitions` VALUES (4242, 2136, 3, 'Contexto');
INSERT INTO `lang_definitions` VALUES (4243, 2137, 3, 'El nombre de contexto no puede estar vacío');
INSERT INTO `lang_definitions` VALUES (4244, 2138, 3, 'Continuar');
INSERT INTO `lang_definitions` VALUES (4245, 2142, 3, 'Continuidad del Documento de Atención (CCD)');
INSERT INTO `lang_definitions` VALUES (4246, 2145, 3, 'Continuidad del registro de cuidados (CCR)');
INSERT INTO `lang_definitions` VALUES (4247, 2146, 3, 'Contra Clientes');
INSERT INTO `lang_definitions` VALUES (4248, 2147, 3, 'Contracepción');
INSERT INTO `lang_definitions` VALUES (4249, 2148, 3, 'Incidencias de Anticonceptivos');
INSERT INTO `lang_definitions` VALUES (4250, 2149, 3, 'Complicación anticonceptivos (especificar)');
INSERT INTO `lang_definitions` VALUES (4251, 2150, 3, 'Método Anticonceptivo');
INSERT INTO `lang_definitions` VALUES (4252, 2151, 3, 'Productos Anticonceptivos');
INSERT INTO `lang_definitions` VALUES (4253, 2152, 3, 'Servicios anticonceptivos ya empezados');
INSERT INTO `lang_definitions` VALUES (4254, 2153, 3, 'Comienzo de anticonceptivos');
INSERT INTO `lang_definitions` VALUES (4255, 2158, 3, 'Nº Identificación de control');
INSERT INTO `lang_definitions` VALUES (4256, 2159, 3, 'N º de control');
INSERT INTO `lang_definitions` VALUES (4257, 2168, 3, 'COPAGO');
INSERT INTO `lang_definitions` VALUES (4258, 2169, 3, 'Co-pago');
INSERT INTO `lang_definitions` VALUES (4259, 2170, 3, 'Co-Pago');
INSERT INTO `lang_definitions` VALUES (4260, 2171, 3, 'El Co-pago no es positivo');
INSERT INTO `lang_definitions` VALUES (4261, 2173, 3, 'Co-pagos');
INSERT INTO `lang_definitions` VALUES (4262, 2174, 3, 'COPD');
INSERT INTO `lang_definitions` VALUES (4263, 2175, 3, 'Copiar páginas a la Historia del Paciente');
INSERT INTO `lang_definitions` VALUES (4264, 2177, 3, 'Copiar Valores');
INSERT INTO `lang_definitions` VALUES (4265, 2178, 3, 'Copiando base de datos. Puede tardar algún tiempo');
INSERT INTO `lang_definitions` VALUES (4266, 2179, 3, 'Aviso de Derechos Reservados');
INSERT INTO `lang_definitions` VALUES (4267, 2184, 3, 'Bypass coronario arterial');
INSERT INTO `lang_definitions` VALUES (4268, 2185, 3, 'Cirugía de revascularización coronaria');
INSERT INTO `lang_definitions` VALUES (4269, 2186, 3, 'Corregido');
INSERT INTO `lang_definitions` VALUES (4270, 2188, 3, 'CouchDB');
INSERT INTO `lang_definitions` VALUES (4271, 2189, 3, 'Conexión a CouchDB fallida.');
INSERT INTO `lang_definitions` VALUES (4272, 2191, 3, 'bbdd CouchDB');
INSERT INTO `lang_definitions` VALUES (4273, 2192, 3, 'Nombre de bbdd CouchDB');
INSERT INTO `lang_definitions` VALUES (4274, 2195, 3, 'Host CouchDB');
INSERT INTO `lang_definitions` VALUES (4275, 2196, 3, 'Nombre Host CouchDB');
INSERT INTO `lang_definitions` VALUES (4276, 2197, 3, 'Activar Log CouchDB');
INSERT INTO `lang_definitions` VALUES (4277, 2198, 3, 'Contraseña CouchDB');
INSERT INTO `lang_definitions` VALUES (4278, 2199, 3, 'Puerto CouchDB');
INSERT INTO `lang_definitions` VALUES (4279, 2200, 3, 'puerto CouchDB');
INSERT INTO `lang_definitions` VALUES (4280, 2203, 3, 'Nombre usuario CouchDB');
INSERT INTO `lang_definitions` VALUES (4281, 2204, 3, 'Tos');
INSERT INTO `lang_definitions` VALUES (4282, 2205, 3, 'Tos:');
INSERT INTO `lang_definitions` VALUES (4283, 2211, 3, 'No se pudo leer el fichero');
INSERT INTO `lang_definitions` VALUES (4284, 2214, 3, 'email no enviado por problema en el servidor,');
INSERT INTO `lang_definitions` VALUES (4285, 2216, 3, 'No se pudo enviar email debido a problemas en el servidor.');
INSERT INTO `lang_definitions` VALUES (4286, 2217, 3, 'No se pudo crear el dir de backup:');
INSERT INTO `lang_definitions` VALUES (4287, 2218, 3, 'No se pudo eliminar dir:');
INSERT INTO `lang_definitions` VALUES (4288, 2219, 3, 'No se pudo eliminar el antiguo fichero de Backup:');
INSERT INTO `lang_definitions` VALUES (4289, 2220, 3, 'No se pudo eliminar el antiguo fichero de exportación:');
INSERT INTO `lang_definitions` VALUES (4290, 2221, 3, 'Tratamiento con Coumadin - Seguimiento del Ratio Internacional Normalizado (RIN)');
INSERT INTO `lang_definitions` VALUES (4291, 2222, 3, 'Counseling por Método');
INSERT INTO `lang_definitions` VALUES (4292, 2223, 3, 'Orientación');
INSERT INTO `lang_definitions` VALUES (4293, 2224, 3, 'Actividades de orientación');
INSERT INTO `lang_definitions` VALUES (4294, 2227, 3, 'FORMULARIO CONTADOR DE DERIVACIONES');
INSERT INTO `lang_definitions` VALUES (4295, 2228, 3, 'Contador-Derivación');
INSERT INTO `lang_definitions` VALUES (4296, 2229, 3, 'País');
INSERT INTO `lang_definitions` VALUES (4297, 2231, 3, 'Tipo de datos País');
INSERT INTO `lang_definitions` VALUES (4298, 2232, 3, 'Lista de País');
INSERT INTO `lang_definitions` VALUES (4299, 2233, 3, 'Lista del país (escriba, addonly opcional)');
INSERT INTO `lang_definitions` VALUES (4300, 2235, 3, 'Nombre del Pais deber ser representados por dos letras');
INSERT INTO `lang_definitions` VALUES (4301, 2236, 3, 'condado');
INSERT INTO `lang_definitions` VALUES (4302, 2238, 3, 'Cupón');
INSERT INTO `lang_definitions` VALUES (4303, 2245, 3, 'CPT');
INSERT INTO `lang_definitions` VALUES (4304, 2246, 3, 'Código CPT');
INSERT INTO `lang_definitions` VALUES (4305, 2247, 3, 'Código CPT');
INSERT INTO `lang_definitions` VALUES (4306, 2248, 3, 'Procedimiento/Servicio CPT4');
INSERT INTO `lang_definitions` VALUES (4307, 2249, 3, 'Medidas de Rendimiento CPTII');
INSERT INTO `lang_definitions` VALUES (4308, 2250, 3, 'Gestión Calidad Continua (GCC)');
INSERT INTO `lang_definitions` VALUES (4309, 2252, 3, 'Crujidos, crepitaciones');
INSERT INTO `lang_definitions` VALUES (4310, 2255, 3, 'crema');
INSERT INTO `lang_definitions` VALUES (4311, 2256, 3, 'Crear un certificado SSL del Cliente por usuario o cliente de maquina');
INSERT INTO `lang_definitions` VALUES (4312, 2257, 3, 'Crear un certificado SSL del lado del cliente, ya sea para un usuario o un nombre de host cliente.');
INSERT INTO `lang_definitions` VALUES (4313, 2269, 3, 'Crear un evento');
INSERT INTO `lang_definitions` VALUES (4314, 2273, 3, 'Crear y descargar un respaldo completo');
INSERT INTO `lang_definitions` VALUES (4315, 2275, 3, 'Crear Respaldo');
INSERT INTO `lang_definitions` VALUES (4316, 2276, 3, 'Crear batch');
INSERT INTO `lang_definitions` VALUES (4317, 2277, 3, 'Crear Certificado de Cliente');
INSERT INTO `lang_definitions` VALUES (4318, 2278, 3, 'Crear Certificados SSL del Cliente');
INSERT INTO `lang_definitions` VALUES (4319, 2281, 3, 'Crear Duplicado');
INSERT INTO `lang_definitions` VALUES (4320, 2283, 3, 'Crear backup de registro de eventos');
INSERT INTO `lang_definitions` VALUES (4321, 2285, 3, 'Crear nueva incidencia');
INSERT INTO `lang_definitions` VALUES (4322, 2287, 3, 'Crear Nuevo Paciente');
INSERT INTO `lang_definitions` VALUES (4323, 2290, 3, 'Crear Credenciales para el Portal Offsite');
INSERT INTO `lang_definitions` VALUES (4324, 2292, 3, 'Crear Credenciales para el Portal Onsite');
INSERT INTO `lang_definitions` VALUES (4325, 2294, 3, 'Crear nota de paciente');
INSERT INTO `lang_definitions` VALUES (4326, 2296, 3, 'Crear Certificado de Autoridad SSL y Certificados del Servidor.');
INSERT INTO `lang_definitions` VALUES (4327, 2297, 3, 'Crear visita');
INSERT INTO `lang_definitions` VALUES (4328, 2298, 3, 'Creado');
INSERT INTO `lang_definitions` VALUES (4329, 2306, 3, 'Creando fichero de exportación');
INSERT INTO `lang_definitions` VALUES (4330, 2309, 3, 'Creador');
INSERT INTO `lang_definitions` VALUES (4331, 2311, 3, 'crédito');
INSERT INTO `lang_definitions` VALUES (4332, 2312, 3, 'Tarjeta de Credito');
INSERT INTO `lang_definitions` VALUES (4333, 2314, 3, 'Créditos');
INSERT INTO `lang_definitions` VALUES (4334, 2316, 3, 'Criterio');
INSERT INTO `lang_definitions` VALUES (4335, 2319, 3, 'Enfermedad de Crohn');
INSERT INTO `lang_definitions` VALUES (4336, 2320, 3, 'Enfermedad de Crohn');
INSERT INTO `lang_definitions` VALUES (4337, 2323, 3, 'CSV');
INSERT INTO `lang_definitions` VALUES (4338, 2324, 3, 'Fichero CSV');
INSERT INTO `lang_definitions` VALUES (4339, 2330, 3, 'MM.CU (Mililitros cubicos)');
INSERT INTO `lang_definitions` VALUES (4340, 2331, 3, 'Cubano');
INSERT INTO `lang_definitions` VALUES (4341, 2333, 3, 'Número de decimales en moneda');
INSERT INTO `lang_definitions` VALUES (4342, 2334, 3, 'Tipo de Cambio - Símbolo de Punto Decimal');
INSERT INTO `lang_definitions` VALUES (4343, 2335, 3, 'Indicador de Tipo de Cambio');
INSERT INTO `lang_definitions` VALUES (4344, 2336, 3, 'Tipo de Cambio - Separador de Miles');
INSERT INTO `lang_definitions` VALUES (4345, 2337, 3, 'Actual');
INSERT INTO `lang_definitions` VALUES (4346, 2338, 3, 'Alcohol actual');
INSERT INTO `lang_definitions` VALUES (4347, 2341, 3, 'Consulta Actual');
INSERT INTO `lang_definitions` VALUES (4348, 2342, 3, 'Criterio Actual');
INSERT INTO `lang_definitions` VALUES (4349, 2344, 3, 'Color resaltado del presente día');
INSERT INTO `lang_definitions` VALUES (4350, 2345, 3, 'Actualmente fumador diario');
INSERT INTO `lang_definitions` VALUES (4351, 2347, 3, 'El nombre de fichero actual fue cambiado a');
INSERT INTO `lang_definitions` VALUES (4352, 2349, 3, 'Hash actual');
INSERT INTO `lang_definitions` VALUES (4353, 2350, 3, 'Ubicación actual');
INSERT INTO `lang_definitions` VALUES (4354, 2352, 3, 'Medicamentos Actuales');
INSERT INTO `lang_definitions` VALUES (4355, 2354, 3, 'Contraseña Actual');
INSERT INTO `lang_definitions` VALUES (4356, 2356, 3, 'Paciente Actual');
INSERT INTO `lang_definitions` VALUES (4357, 2361, 3, 'Drogas no farmacológicas actuales');
INSERT INTO `lang_definitions` VALUES (4358, 2363, 3, 'Actualmente fumador ocasional');
INSERT INTO `lang_definitions` VALUES (4359, 2371, 3, 'Actualmente Activo');
INSERT INTO `lang_definitions` VALUES (4360, 2377, 3, 'Actualmente no hay clínicas');
INSERT INTO `lang_definitions` VALUES (4361, 2379, 3, 'Síndrome de Cushing');
INSERT INTO `lang_definitions` VALUES (4362, 2380, 3, 'Síndrome de Cushing');
INSERT INTO `lang_definitions` VALUES (4363, 2383, 3, 'Costumbre');
INSERT INTO `lang_definitions` VALUES (4364, 2390, 3, '¿Entrada cliente?');
INSERT INTO `lang_definitions` VALUES (4365, 2395, 3, 'Tabla Cliente');
INSERT INTO `lang_definitions` VALUES (4366, 2402, 3, 'Código CVX');
INSERT INTO `lang_definitions` VALUES (4367, 2403, 3, 'Mapa de Código CVX');
INSERT INTO `lang_definitions` VALUES (4368, 2404, 3, 'Vacunación CVX');
INSERT INTO `lang_definitions` VALUES (4369, 2406, 3, 'Ciclo');
INSERT INTO `lang_definitions` VALUES (4370, 2412, 3, 'CYP');
INSERT INTO `lang_definitions` VALUES (4371, 2413, 3, 'Factor de CYP');
INSERT INTO `lang_definitions` VALUES (4372, 2414, 3, 'Informe de CYP');
INSERT INTO `lang_definitions` VALUES (4373, 2415, 3, 'Checo');
INSERT INTO `lang_definitions` VALUES (4374, 2416, 3, 'D');
INSERT INTO `lang_definitions` VALUES (4375, 2417, 3, 'D&C');
INSERT INTO `lang_definitions` VALUES (4376, 2418, 3, 'D&E');
INSERT INTO `lang_definitions` VALUES (4377, 2420, 3, 'F.Nacim.');
INSERT INTO `lang_definitions` VALUES (4378, 2421, 3, 'diariamente');
INSERT INTO `lang_definitions` VALUES (4379, 2422, 3, 'Registro Diario');
INSERT INTO `lang_definitions` VALUES (4380, 2425, 3, 'Danés');
INSERT INTO `lang_definitions` VALUES (4381, 2429, 3, 'Información parecida está ya en la base de datos, por favor cambie el código o la descripción');
INSERT INTO `lang_definitions` VALUES (4382, 2430, 3, 'Información parecida está ya en la base de datos, por favor cambie el nombre de la constante');
INSERT INTO `lang_definitions` VALUES (4383, 2431, 3, 'Datos Cols');
INSERT INTO `lang_definitions` VALUES (4384, 2434, 3, 'Error de datos');
INSERT INTO `lang_definitions` VALUES (4385, 2439, 3, 'Tipo de datos');
INSERT INTO `lang_definitions` VALUES (4386, 2440, 3, 'Base de datos');
INSERT INTO `lang_definitions` VALUES (4387, 2442, 3, 'Base de datos sin instalar');
INSERT INTO `lang_definitions` VALUES (4388, 2444, 3, 'Revisión bbdd');
INSERT INTO `lang_definitions` VALUES (4389, 2445, 3, 'Información de la base de datos');
INSERT INTO `lang_definitions` VALUES (4390, 2447, 3, 'Actualización de base de datos completa');
INSERT INTO `lang_definitions` VALUES (4391, 2448, 3, 'DataCols debe ser un número entre 1 y 999');
INSERT INTO `lang_definitions` VALUES (4392, 2449, 3, 'Fecha');
INSERT INTO `lang_definitions` VALUES (4393, 2450, 3, 'FECHA');
INSERT INTO `lang_definitions` VALUES (4394, 2453, 3, 'Fecha adminstrada');
INSERT INTO `lang_definitions` VALUES (4395, 2454, 3, 'Fecha y hora de coleccion de muestra');
INSERT INTO `lang_definitions` VALUES (4396, 2455, 3, 'Fecha y hora de esta observación');
INSERT INTO `lang_definitions` VALUES (4397, 2457, 3, 'Fecha y hora cuando la muestra fue colectada');
INSERT INTO `lang_definitions` VALUES (4398, 2458, 3, 'La fecha no puede ser mayor a la de hoy');
INSERT INTO `lang_definitions` VALUES (4399, 2459, 3, 'Fecha en que fueron provistos inicialmente los servicios anticonceptivos');
INSERT INTO `lang_definitions` VALUES (4400, 2460, 3, 'Fecha Creacion');
INSERT INTO `lang_definitions` VALUES (4401, 2461, 3, 'Fecha Defunción');
INSERT INTO `lang_definitions` VALUES (4402, 2462, 3, 'Fecha destruída');
INSERT INTO `lang_definitions` VALUES (4403, 2463, 3, 'Formato visualización de fecha');
INSERT INTO `lang_definitions` VALUES (4404, 2464, 3, 'Formato fecha para última cita no es válido');
INSERT INTO `lang_definitions` VALUES (4405, 2465, 3, 'Formato fecha para inicio de cita no es válido');
INSERT INTO `lang_definitions` VALUES (4406, 2466, 3, 'Formato fecha en \'Próxima Cita\' no es válido');
INSERT INTO `lang_definitions` VALUES (4407, 2467, 3, 'Formato fecha en \'no visto desde\' no es válido');
INSERT INTO `lang_definitions` VALUES (4408, 2469, 3, 'Formato fecha en \'visto en\' no es válido');
INSERT INTO `lang_definitions` VALUES (4409, 2470, 3, 'Comunicados de fechas de vacunación entregados');
INSERT INTO `lang_definitions` VALUES (4410, 2471, 3, 'Falta fecha para código');
INSERT INTO `lang_definitions` VALUES (4411, 2472, 3, 'Criterio maestro de fecha');
INSERT INTO `lang_definitions` VALUES (4412, 2475, 3, 'Fecha ingreso en banco aaaa-mm-dd');
INSERT INTO `lang_definitions` VALUES (4413, 2476, 3, 'Fecha de factura');
INSERT INTO `lang_definitions` VALUES (4414, 2477, 3, 'F.Nacim.');
INSERT INTO `lang_definitions` VALUES (4415, 2478, 3, 'F.Nacim.');
INSERT INTO `lang_definitions` VALUES (4416, 2479, 3, 'F.Nacim.');
INSERT INTO `lang_definitions` VALUES (4417, 2481, 3, 'Fecha de entrada');
INSERT INTO `lang_definitions` VALUES (4418, 2483, 3, 'Fecha de la lesión');
INSERT INTO `lang_definitions` VALUES (4419, 2487, 3, 'Fecha de pago aaaa-mm-dd');
INSERT INTO `lang_definitions` VALUES (4420, 2489, 3, 'Fecha de derivación');
INSERT INTO `lang_definitions` VALUES (4421, 2491, 3, 'Fecha de la respuesta');
INSERT INTO `lang_definitions` VALUES (4422, 2493, 3, 'Fecha De Servicio');
INSERT INTO `lang_definitions` VALUES (4423, 2495, 3, 'Fecha de servicio');
INSERT INTO `lang_definitions` VALUES (4424, 2496, 3, 'Fecha de servicio = hoy');
INSERT INTO `lang_definitions` VALUES (4425, 2498, 3, 'Fecha de servicio mm/dd/aaaa');
INSERT INTO `lang_definitions` VALUES (4426, 2499, 3, 'Fecha de Servicio:');
INSERT INTO `lang_definitions` VALUES (4427, 2500, 3, 'Fecha de firma');
INSERT INTO `lang_definitions` VALUES (4428, 2503, 3, 'Fecha de esta orden');
INSERT INTO `lang_definitions` VALUES (4429, 2504, 3, 'Fecha de este reporte');
INSERT INTO `lang_definitions` VALUES (4430, 2505, 3, 'Fecha de la Declaración de VIS');
INSERT INTO `lang_definitions` VALUES (4431, 2506, 3, 'Fecha en que se ordenó');
INSERT INTO `lang_definitions` VALUES (4432, 2509, 3, 'Seleccionador de fecha');
INSERT INTO `lang_definitions` VALUES (4433, 2510, 3, 'Fecha Envio');
INSERT INTO `lang_definitions` VALUES (4434, 2511, 3, 'Fecha del mensaje enviado');
INSERT INTO `lang_definitions` VALUES (4435, 2513, 3, 'La fecha no puede estar en blanco');
INSERT INTO `lang_definitions` VALUES (4436, 2516, 3, 'Fecha/Cita');
INSERT INTO `lang_definitions` VALUES (4437, 2517, 3, 'Fecha/Notas');
INSERT INTO `lang_definitions` VALUES (4438, 2518, 3, 'Fecha/Notas de Último');
INSERT INTO `lang_definitions` VALUES (4439, 2519, 3, 'Fecha/Hora');
INSERT INTO `lang_definitions` VALUES (4440, 2520, 3, 'Fecha:');
INSERT INTO `lang_definitions` VALUES (4441, 2523, 3, 'Registro mensaje fechado');
INSERT INTO `lang_definitions` VALUES (4442, 2526, 3, 'Día');
INSERT INTO `lang_definitions` VALUES (4443, 2527, 3, 'dia');
INSERT INTO `lang_definitions` VALUES (4444, 2530, 3, 'Vista de día');
INSERT INTO `lang_definitions` VALUES (4445, 2531, 3, 'Día(s)');
INSERT INTO `lang_definitions` VALUES (4446, 2532, 3, 'Día(s) L-V');
INSERT INTO `lang_definitions` VALUES (4447, 2533, 3, 'días');
INSERT INTO `lang_definitions` VALUES (4448, 2534, 3, 'Días');
INSERT INTO `lang_definitions` VALUES (4449, 2535, 3, 'días pasados');
INSERT INTO `lang_definitions` VALUES (4450, 2536, 3, 'Dïas y juegos perdidos');
INSERT INTO `lang_definitions` VALUES (4451, 2537, 3, 'Días Desde la Última Visita');
INSERT INTO `lang_definitions` VALUES (4452, 2538, 3, 'Dias faltados');
INSERT INTO `lang_definitions` VALUES (4453, 2541, 3, 'Días por columna');
INSERT INTO `lang_definitions` VALUES (4454, 2543, 3, 'Días/Col');
INSERT INTO `lang_definitions` VALUES (4455, 2544, 3, 'DB instalado');
INSERT INTO `lang_definitions` VALUES (4456, 2545, 3, 'DD/MM/AAAA');
INSERT INTO `lang_definitions` VALUES (4457, 2546, 3, 'Anonimato');
INSERT INTO `lang_definitions` VALUES (4458, 2547, 3, 'El proceso de anonimato está completo');
INSERT INTO `lang_definitions` VALUES (4459, 2548, 3, 'El proceso de anonimato está en proceso');
INSERT INTO `lang_definitions` VALUES (4460, 2549, 3, 'El proceso de anonimato ha iniciado y está corriendo en el fondo');
INSERT INTO `lang_definitions` VALUES (4461, 2550, 3, 'Los datos anónimos pueden no estar completos');
INSERT INTO `lang_definitions` VALUES (4462, 2551, 3, 'Los ficheros anónimos serán guardados en');
INSERT INTO `lang_definitions` VALUES (4463, 2552, 3, 'DEA');
INSERT INTO `lang_definitions` VALUES (4464, 2558, 3, 'Sordera');
INSERT INTO `lang_definitions` VALUES (4465, 2562, 3, 'Elimine errores de la información');
INSERT INTO `lang_definitions` VALUES (4466, 2565, 3, 'Dic');
INSERT INTO `lang_definitions` VALUES (4467, 2567, 3, 'DIFUNTO');
INSERT INTO `lang_definitions` VALUES (4468, 2574, 3, 'Diciembre');
INSERT INTO `lang_definitions` VALUES (4469, 2580, 3, 'Deducible');
INSERT INTO `lang_definitions` VALUES (4470, 2581, 3, 'Deducible alcanzado');
INSERT INTO `lang_definitions` VALUES (4471, 2583, 3, 'Por Defecto');
INSERT INTO `lang_definitions` VALUES (4472, 2585, 3, 'Vista Calendario por defecto');
INSERT INTO `lang_definitions` VALUES (4473, 2587, 3, 'Formulario ID para Visita por defecto');
INSERT INTO `lang_definitions` VALUES (4474, 2589, 3, 'Centro por defecto');
INSERT INTO `lang_definitions` VALUES (4475, 2594, 3, 'Idioma por defecto');
INSERT INTO `lang_definitions` VALUES (4476, 2595, 3, 'Idioma por defecto si no se permite otro, o bien elegir.');
INSERT INTO `lang_definitions` VALUES (4477, 2598, 3, 'Lista por defecto (escriba, sólo añadir opcional)');
INSERT INTO `lang_definitions` VALUES (4478, 2600, 3, 'Método por defecto');
INSERT INTO `lang_definitions` VALUES (4479, 2601, 3, 'Días Expiración Contraseña por Defecto');
INSERT INTO `lang_definitions` VALUES (4480, 2602, 3, 'El periodo de vencimiento de la contraseña por defecto es 0. Ésto significa que la función está desactivada');
INSERT INTO `lang_definitions` VALUES (4481, 2603, 3, 'País por defecto del Paciente');
INSERT INTO `lang_definitions` VALUES (4482, 2607, 3, 'Médico por defecto');
INSERT INTO `lang_definitions` VALUES (4483, 2609, 3, 'Rango por defecto');
INSERT INTO `lang_definitions` VALUES (4484, 2610, 3, 'Razón por defecto de la visita');
INSERT INTO `lang_definitions` VALUES (4485, 2615, 3, 'Configuración por defecto');
INSERT INTO `lang_definitions` VALUES (4486, 2617, 3, 'Estado de la casilla por defecto de nueva ventana en la lista de pacientes.');
INSERT INTO `lang_definitions` VALUES (4487, 2618, 3, 'Plantilla por defecto');
INSERT INTO `lang_definitions` VALUES (4488, 2624, 3, 'Unidades por defecto');
INSERT INTO `lang_definitions` VALUES (4489, 2626, 3, 'Valor por defecto');
INSERT INTO `lang_definitions` VALUES (4490, 2628, 3, 'Deposito por defecto');
INSERT INTO `lang_definitions` VALUES (4491, 2629, 3, 'Socio X12 por defecto');
INSERT INTO `lang_definitions` VALUES (4492, 2630, 3, 'Por defecto/Global');
INSERT INTO `lang_definitions` VALUES (4493, 2635, 3, 'Borrar');
INSERT INTO `lang_definitions` VALUES (4494, 2636, 3, 'borrar');
INSERT INTO `lang_definitions` VALUES (4495, 2637, 3, 'Repetición retrasada (> 12 Mo)');
INSERT INTO `lang_definitions` VALUES (4496, 2638, 3, 'Eliminar');
INSERT INTO `lang_definitions` VALUES (4497, 2639, 3, 'eliminar');
INSERT INTO `lang_definitions` VALUES (4498, 2640, 3, 'Eliminar Categorías con identificador(es) :');
INSERT INTO `lang_definitions` VALUES (4499, 2641, 3, 'Borrar Categoría');
INSERT INTO `lang_definitions` VALUES (4500, 2645, 3, 'Eliminar Grupo');
INSERT INTO `lang_definitions` VALUES (4501, 2646, 3, 'Eliminar Lista');
INSERT INTO `lang_definitions` VALUES (4502, 2648, 3, 'Eliminar Páginas');
INSERT INTO `lang_definitions` VALUES (4503, 2649, 3, 'Borrar Paciente, visita, formulario, Incidencia, Documento, Pago, facturación o Transacción');
INSERT INTO `lang_definitions` VALUES (4504, 2651, 3, 'Borrar fila');
INSERT INTO `lang_definitions` VALUES (4505, 2652, 3, 'Borrar ítems selectos');
INSERT INTO `lang_definitions` VALUES (4506, 2655, 3, 'Eliminar éxito.');
INSERT INTO `lang_definitions` VALUES (4507, 2656, 3, 'Eliminar este documento');
INSERT INTO `lang_definitions` VALUES (4508, 2657, 3, 'Eliminar este formulario');
INSERT INTO `lang_definitions` VALUES (4509, 2659, 3, 'Eliminar esta nota');
INSERT INTO `lang_definitions` VALUES (4510, 2661, 3, 'Borrado Completado');
INSERT INTO `lang_definitions` VALUES (4511, 2663, 3, 'No se puede deshacer la eliminación de este evento. No se puede recuperar una vez que se ha hecho. ¿Está seguro que desea eliminar este evento?');
INSERT INTO `lang_definitions` VALUES (4512, 2671, 3, 'Demencia');
INSERT INTO `lang_definitions` VALUES (4513, 2673, 3, 'Datos demográficos');
INSERT INTO `lang_definitions` VALUES (4514, 2674, 3, 'Demografía (escribir, sólo añadir opcional)');
INSERT INTO `lang_definitions` VALUES (4515, 2678, 3, 'Criterio de Filtro Demográficos');
INSERT INTO `lang_definitions` VALUES (4516, 2680, 3, 'Datos demográficos no autorizados');
INSERT INTO `lang_definitions` VALUES (4517, 2681, 3, 'Datos demográficos no autorizados');
INSERT INTO `lang_definitions` VALUES (4518, 2682, 3, 'Denegado');
INSERT INTO `lang_definitions` VALUES (4519, 2684, 3, 'Denominador');
INSERT INTO `lang_definitions` VALUES (4520, 2687, 3, 'Dental');
INSERT INTO `lang_definitions` VALUES (4521, 2689, 3, 'Incidencias Dentales');
INSERT INTO `lang_definitions` VALUES (4522, 2694, 3, 'Dependiendo del tipo de cuenta que usted prueba, usted verá salida tipo HCFA en una página en blanco para las cuentas de HCFA, o usted verá muchas líneas de texto e información alteradas, si usted está probando una demanda X12. Ese texto mutilado es el formato del X12 IED 4010A. Usted verá de vez en cuando los caracteres extraños que parecen dominós o basura, se trata de caracteres de control tales como alimentaciones de página y son normales.');
INSERT INTO `lang_definitions` VALUES (4523, 2696, 3, 'Fecha de depósito');
INSERT INTO `lang_definitions` VALUES (4524, 2697, 3, 'La fecha del deposiito no puede ser mayor a la de hoy');
INSERT INTO `lang_definitions` VALUES (4525, 2698, 3, 'Fecha del depósito');
INSERT INTO `lang_definitions` VALUES (4526, 2699, 3, 'Depresivo');
INSERT INTO `lang_definitions` VALUES (4527, 2700, 3, 'Depresión');
INSERT INTO `lang_definitions` VALUES (4528, 2706, 3, 'Descripción');
INSERT INTO `lang_definitions` VALUES (4529, 2707, 3, 'descripción');
INSERT INTO `lang_definitions` VALUES (4530, 2709, 3, 'Descripción de la publicación');
INSERT INTO `lang_definitions` VALUES (4531, 2710, 3, 'Desceripcion de este procedimiento o codigo resultante');
INSERT INTO `lang_definitions` VALUES (4532, 2711, 3, 'Traducción de la descripción');
INSERT INTO `lang_definitions` VALUES (4533, 2713, 3, 'Destino');
INSERT INTO `lang_definitions` VALUES (4534, 2714, 3, 'Nombre del fichero destino');
INSERT INTO `lang_definitions` VALUES (4535, 2716, 3, 'Destruir todo el lote');
INSERT INTO `lang_definitions` VALUES (4536, 2717, 3, 'Destruido ...');
INSERT INTO `lang_definitions` VALUES (4537, 2718, 3, 'Destruido');
INSERT INTO `lang_definitions` VALUES (4538, 2719, 3, 'Drogas destruidas');
INSERT INTO `lang_definitions` VALUES (4539, 2720, 3, 'Informe drogas destruidas');
INSERT INTO `lang_definitions` VALUES (4540, 2721, 3, 'Detalle');
INSERT INTO `lang_definitions` VALUES (4541, 2726, 3, 'Detalles');
INSERT INTO `lang_definitions` VALUES (4542, 2728, 3, 'Anormalidad del desarrollo');
INSERT INTO `lang_definitions` VALUES (4543, 2730, 3, 'Diabetes');
INSERT INTO `lang_definitions` VALUES (4544, 2731, 3, 'Diabetes Mellitus');
INSERT INTO `lang_definitions` VALUES (4545, 2732, 3, 'Diabetes: Gestión presión arterial (GCC)');
INSERT INTO `lang_definitions` VALUES (4546, 2733, 3, 'Diabetes:Examen Ocular');
INSERT INTO `lang_definitions` VALUES (4547, 2734, 3, 'Diabetes: Examen ocular (GCC)');
INSERT INTO `lang_definitions` VALUES (4548, 2735, 3, 'Diabetes: Examen de los pies');
INSERT INTO `lang_definitions` VALUES (4549, 2736, 3, 'Diabetes: Examen de los pies (GCC)');
INSERT INTO `lang_definitions` VALUES (4550, 2737, 3, 'Diabetes:Control HbA1c Deficiente (GCC)');
INSERT INTO `lang_definitions` VALUES (4551, 2738, 3, 'Diabetes: Hemoglobina A1C');
INSERT INTO `lang_definitions` VALUES (4552, 2739, 3, 'Diabetes: Gestión LDL y Control (GCC)');
INSERT INTO `lang_definitions` VALUES (4553, 2740, 3, 'Diabetes: Microalbúmina de la orina');
INSERT INTO `lang_definitions` VALUES (4554, 2741, 3, 'Diag');
INSERT INTO `lang_definitions` VALUES (4555, 2742, 3, 'Diagnósticos');
INSERT INTO `lang_definitions` VALUES (4556, 2743, 3, 'Diagnóstico');
INSERT INTO `lang_definitions` VALUES (4557, 2744, 3, 'Cód. Diagnóstico');
INSERT INTO `lang_definitions` VALUES (4558, 2745, 3, 'Códigos diagnósticos');
INSERT INTO `lang_definitions` VALUES (4559, 2747, 3, 'Fecha de diagnóstico');
INSERT INTO `lang_definitions` VALUES (4560, 2749, 3, 'El diagnóstico debe ser codificado en una visita vinculada');
INSERT INTO `lang_definitions` VALUES (4561, 2750, 3, 'Nombre del diagnóstico');
INSERT INTO `lang_definitions` VALUES (4562, 2751, 3, 'Reporte del diagnóstico');
INSERT INTO `lang_definitions` VALUES (4563, 2752, 3, 'Informe de diagnóstico');
INSERT INTO `lang_definitions` VALUES (4564, 2753, 3, 'Informe sólo de diagnóstico');
INSERT INTO `lang_definitions` VALUES (4565, 2754, 3, 'Título del diagnóstico');
INSERT INTO `lang_definitions` VALUES (4566, 2755, 3, 'Diagnóstico:');
INSERT INTO `lang_definitions` VALUES (4567, 2756, 3, 'Diagnóstico:');
INSERT INTO `lang_definitions` VALUES (4568, 2757, 3, 'Diagnóstico');
INSERT INTO `lang_definitions` VALUES (4569, 2758, 3, 'Pruebas diagnósticas:');
INSERT INTO `lang_definitions` VALUES (4570, 2760, 3, 'Diales');
INSERT INTO `lang_definitions` VALUES (4571, 2763, 3, 'Diafragmas/Capuchón cervical');
INSERT INTO `lang_definitions` VALUES (4572, 2764, 3, 'Diarrea');
INSERT INTO `lang_definitions` VALUES (4573, 2765, 3, 'Diastólico');
INSERT INTO `lang_definitions` VALUES (4574, 2767, 3, 'Dictado');
INSERT INTO `lang_definitions` VALUES (4575, 2768, 3, 'Dictado:');
INSERT INTO `lang_definitions` VALUES (4576, 2769, 3, '¿Usted recibió una copia del aviso de HIPAA?');
INSERT INTO `lang_definitions` VALUES (4577, 2770, 3, 'Difuso:');
INSERT INTO `lang_definitions` VALUES (4578, 2771, 3, 'Firmado digitalmente');
INSERT INTO `lang_definitions` VALUES (4579, 2772, 3, 'Dilatado con');
INSERT INTO `lang_definitions` VALUES (4580, 2777, 3, 'Directo');
INSERT INTO `lang_definitions` VALUES (4581, 2778, 3, 'Dirección Directa');
INSERT INTO `lang_definitions` VALUES (4582, 2779, 3, 'Dirección Directa');
INSERT INTO `lang_definitions` VALUES (4583, 2780, 3, 'Mail directo');
INSERT INTO `lang_definitions` VALUES (4584, 2781, 3, 'Correo Directo');
INSERT INTO `lang_definitions` VALUES (4585, 2782, 3, 'Registro Mens. Directo');
INSERT INTO `lang_definitions` VALUES (4586, 2783, 3, 'Mens.Directo recibido');
INSERT INTO `lang_definitions` VALUES (4587, 2784, 3, 'Mensaje directo no disponible ahora');
INSERT INTO `lang_definitions` VALUES (4588, 2785, 3, 'Falla de envío de mensaje directo');
INSERT INTO `lang_definitions` VALUES (4589, 2786, 3, 'Directivas');
INSERT INTO `lang_definitions` VALUES (4590, 2787, 3, 'Nombre del director');
INSERT INTO `lang_definitions` VALUES (4591, 2789, 3, 'inhabilitación');
INSERT INTO `lang_definitions` VALUES (4592, 2794, 3, 'Deshabilitar calendario');
INSERT INTO `lang_definitions` VALUES (4593, 2795, 3, 'Deshabilitar Gráfico de seguimiento');
INSERT INTO `lang_definitions` VALUES (4594, 2798, 3, 'Deshabilitar vacunaciones');
INSERT INTO `lang_definitions` VALUES (4595, 2800, 3, 'Deshabilitar vieja forma métrica de constantes vitales');
INSERT INTO `lang_definitions` VALUES (4596, 2802, 3, 'Deshabilitar phpMyAdmin');
INSERT INTO `lang_definitions` VALUES (4597, 2803, 3, 'Deshabilitar prescriciones');
INSERT INTO `lang_definitions` VALUES (4598, 2804, 3, 'Deshabilitar grupos de usuarios');
INSERT INTO `lang_definitions` VALUES (4599, 2805, 3, 'inhabilitado');
INSERT INTO `lang_definitions` VALUES (4600, 2806, 3, 'inhabilitado');
INSERT INTO `lang_definitions` VALUES (4601, 2807, 3, 'Beneficiario discapacitado menor de 65 años con un Plan de salud para grandes grupos (LGHP)');
INSERT INTO `lang_definitions` VALUES (4602, 2812, 3, 'DISCO');
INSERT INTO `lang_definitions` VALUES (4603, 2815, 3, 'Descarga');
INSERT INTO `lang_definitions` VALUES (4604, 2816, 3, 'Pérdidas/secreciones de la uretra');
INSERT INTO `lang_definitions` VALUES (4605, 2818, 3, 'Derecho de alta');
INSERT INTO `lang_definitions` VALUES (4606, 2819, 3, 'Derecho de alta:');
INSERT INTO `lang_definitions` VALUES (4607, 2825, 3, 'Informacion de publicación');
INSERT INTO `lang_definitions` VALUES (4608, 2826, 3, 'Tipo de publicación');
INSERT INTO `lang_definitions` VALUES (4609, 2827, 3, 'Tipos de publicación');
INSERT INTO `lang_definitions` VALUES (4610, 2828, 3, 'Publicaciones');
INSERT INTO `lang_definitions` VALUES (4611, 2832, 3, 'Suspender');
INSERT INTO `lang_definitions` VALUES (4612, 2833, 3, 'Descuento');
INSERT INTO `lang_definitions` VALUES (4613, 2834, 3, 'Suma de descuento');
INSERT INTO `lang_definitions` VALUES (4614, 2835, 3, 'Nivel del Descuento');
INSERT INTO `lang_definitions` VALUES (4615, 2836, 3, 'Porcentaje de descuento');
INSERT INTO `lang_definitions` VALUES (4616, 2837, 3, 'Descuentos como importes monetarios');
INSERT INTO `lang_definitions` VALUES (4617, 2838, 3, 'Descuentos a la hora de salida se introducen como cantidades de dinero, a diferencia de porcentaje.');
INSERT INTO `lang_definitions` VALUES (4618, 2839, 3, 'Resultado discreto');
INSERT INTO `lang_definitions` VALUES (4619, 2841, 3, 'Enfermedad');
INSERT INTO `lang_definitions` VALUES (4620, 2843, 3, 'Dislocación');
INSERT INTO `lang_definitions` VALUES (4621, 2847, 3, '# Disp');
INSERT INTO `lang_definitions` VALUES (4622, 2848, 3, 'Informe');
INSERT INTO `lang_definitions` VALUES (4623, 2849, 3, 'Remitir documento recibido');
INSERT INTO `lang_definitions` VALUES (4624, 2853, 3, 'Prescrito');
INSERT INTO `lang_definitions` VALUES (4625, 2856, 3, 'Mostrar las directivas anticipadas en la página de la demografía.');
INSERT INTO `lang_definitions` VALUES (4626, 2859, 3, '¿Mostrar fechas de eventos en bloque?');
INSERT INTO `lang_definitions` VALUES (4627, 2861, 3, '¿Mostrar cuántos eventos?');
INSERT INTO `lang_definitions` VALUES (4628, 2865, 3, '¿Mostrar lugar/sitio en bloque?');
INSERT INTO `lang_definitions` VALUES (4629, 2866, 3, 'Nombre Pantalla');
INSERT INTO `lang_definitions` VALUES (4630, 2868, 3, '¿Mostrar el calendario?');
INSERT INTO `lang_definitions` VALUES (4631, 2875, 3, '¿Mostrar los eventos de hoy en el bloque?');
INSERT INTO `lang_definitions` VALUES (4632, 2876, 3, '¿Mostrar tema en el bloque?');
INSERT INTO `lang_definitions` VALUES (4633, 2877, 3, '¿Mostrar los eventos próximos en tabla?');
INSERT INTO `lang_definitions` VALUES (4634, 2879, 3, 'Mostrar columnas');
INSERT INTO `lang_definitions` VALUES (4635, 2880, 3, 'Viendo el siguiente número de las publicaciones más recientes:');
INSERT INTO `lang_definitions` VALUES (4636, 2882, 3, 'Mostrando el siguiente número de las notas más recientes');
INSERT INTO `lang_definitions` VALUES (4637, 2883, 3, 'Mostrando el siguiente número de las notas más recientes:');
INSERT INTO `lang_definitions` VALUES (4638, 2890, 3, 'Distribución');
INSERT INTO `lang_definitions` VALUES (4639, 2891, 3, 'Distribuciones');
INSERT INTO `lang_definitions` VALUES (4640, 2892, 3, 'Distribuidor');
INSERT INTO `lang_definitions` VALUES (4641, 2897, 3, 'Diverticulitis');
INSERT INTO `lang_definitions` VALUES (4642, 2898, 3, 'Operación de Diverticulitis');
INSERT INTO `lang_definitions` VALUES (4643, 2899, 3, 'Diverticulitis');
INSERT INTO `lang_definitions` VALUES (4644, 2900, 3, 'Operación de Diverticulitis');
INSERT INTO `lang_definitions` VALUES (4645, 2901, 3, 'Divorciado');
INSERT INTO `lang_definitions` VALUES (4646, 2902, 3, 'Mareo:');
INSERT INTO `lang_definitions` VALUES (4647, 2905, 3, 'No cambiar');
INSERT INTO `lang_definitions` VALUES (4648, 2907, 3, 'No mostrar alergia subida a NewCrop');
INSERT INTO `lang_definitions` VALUES (4649, 2909, 3, 'No mostrar medicación subida a NewCrop');
INSERT INTO `lang_definitions` VALUES (4650, 2912, 3, 'No mostrar el calendario');
INSERT INTO `lang_definitions` VALUES (4651, 2916, 3, 'No inventariar ni vender nigun producto');
INSERT INTO `lang_definitions` VALUES (4652, 2919, 3, 'No requiere notas del paciente para ser autorizado');
INSERT INTO `lang_definitions` VALUES (4653, 2920, 3, 'Orden de No Resucitar');
INSERT INTO `lang_definitions` VALUES (4654, 2921, 3, 'no guardar');
INSERT INTO `lang_definitions` VALUES (4655, 2922, 3, 'no sustituir');
INSERT INTO `lang_definitions` VALUES (4656, 2925, 3, 'no actuar');
INSERT INTO `lang_definitions` VALUES (4657, 2929, 3, 'De verdad quiere suprimir?');
INSERT INTO `lang_definitions` VALUES (4658, 2930, 3, '¿Verdaderamente desea borrar la selección?');
INSERT INTO `lang_definitions` VALUES (4659, 2931, 3, 'Está seguro que quiere eliminar este grupo');
INSERT INTO `lang_definitions` VALUES (4660, 2934, 3, '¿Quiere continuar?');
INSERT INTO `lang_definitions` VALUES (4661, 2935, 3, '¿Quiere borrar esto?');
INSERT INTO `lang_definitions` VALUES (4662, 2936, 3, '¿Quiere borrar?');
INSERT INTO `lang_definitions` VALUES (4663, 2937, 3, '¿Desea remover este registro?');
INSERT INTO `lang_definitions` VALUES (4664, 2938, 3, '¿Desea continuar añadiendo este nuevo paciente?');
INSERT INTO `lang_definitions` VALUES (4665, 2939, 3, '¿Usted desea continuar con el nuevo nombre?');
INSERT INTO `lang_definitions` VALUES (4666, 2940, 3, '¿Usted desea suprimir DEFINITIVAMENTE este registro de vacunación?');
INSERT INTO `lang_definitions` VALUES (4667, 2941, 3, 'F.Nacim.');
INSERT INTO `lang_definitions` VALUES (4668, 2942, 3, 'Falta F.Nacimiento, por favor insertarla si es posible');
INSERT INTO `lang_definitions` VALUES (4669, 2944, 3, 'Documentos');
INSERT INTO `lang_definitions` VALUES (4670, 2945, 3, 'Médico');
INSERT INTO `lang_definitions` VALUES (4671, 2946, 3, 'Médico:');
INSERT INTO `lang_definitions` VALUES (4672, 2947, 3, 'Nombre del médico y firma');
INSERT INTO `lang_definitions` VALUES (4673, 2948, 3, 'Documento');
INSERT INTO `lang_definitions` VALUES (4674, 2949, 3, 'documento');
INSERT INTO `lang_definitions` VALUES (4675, 2951, 3, 'Categorías documento');
INSERT INTO `lang_definitions` VALUES (4676, 2958, 3, 'El documento no ha podido ser trasladado al Nº Identificación del paciente');
INSERT INTO `lang_definitions` VALUES (4677, 2960, 3, 'Fecha de documento');
INSERT INTO `lang_definitions` VALUES (4678, 2961, 3, 'Fecha del documento e incidencia actualizadas con éxito');
INSERT INTO `lang_definitions` VALUES (4679, 2962, 3, 'Nº Identificación de Documento');
INSERT INTO `lang_definitions` VALUES (4680, 2965, 3, 'Documento se trasladó a nueva categoría');
INSERT INTO `lang_definitions` VALUES (4681, 2966, 3, 'Documento se trasladó al Nº Identificación del paciente');
INSERT INTO `lang_definitions` VALUES (4682, 2968, 3, 'Documento aprobó la comprobación de integridad');
INSERT INTO `lang_definitions` VALUES (4683, 2969, 3, 'Método de archivo de documentos');
INSERT INTO `lang_definitions` VALUES (4684, 2970, 3, 'Documento renombrado con éxito');
INSERT INTO `lang_definitions` VALUES (4685, 2976, 3, 'Depósito de documentos/Imágenes');
INSERT INTO `lang_definitions` VALUES (4686, 2978, 3, 'Documentos');
INSERT INTO `lang_definitions` VALUES (4687, 2980, 3, 'Documentos (escribir, addonly opcional)');
INSERT INTO `lang_definitions` VALUES (4688, 2989, 3, 'DOE');
INSERT INTO `lang_definitions` VALUES (4689, 2996, 3, '¿Este tipo permite codigos relacionados?');
INSERT INTO `lang_definitions` VALUES (4690, 2997, 3, 'Socio doméstico');
INSERT INTO `lang_definitions` VALUES (4691, 2998, 3, 'No Guardar');
INSERT INTO `lang_definitions` VALUES (4692, 2999, 3, 'No Guardar');
INSERT INTO `lang_definitions` VALUES (4693, 3000, 3, 'No Guardar Cambios');
INSERT INTO `lang_definitions` VALUES (4694, 3002, 3, 'Terminado');
INSERT INTO `lang_definitions` VALUES (4695, 3004, 3, 'Hecho con:');
INSERT INTO `lang_definitions` VALUES (4696, 3005, 3, 'Terminado. Ahora se enviará la descarga');
INSERT INTO `lang_definitions` VALUES (4697, 3006, 3, 'DOS');
INSERT INTO `lang_definitions` VALUES (4698, 3007, 3, 'Dosis');
INSERT INTO `lang_definitions` VALUES (4699, 3011, 3, 'Doble click para editar');
INSERT INTO `lang_definitions` VALUES (4700, 3013, 3, 'Visión doble');
INSERT INTO `lang_definitions` VALUES (4701, 3014, 3, 'Descarga');
INSERT INTO `lang_definitions` VALUES (4702, 3019, 3, 'Descargar de todas formas');
INSERT INTO `lang_definitions` VALUES (4703, 3020, 3, 'Descargar expediente de factura, mandar a contabilidad y marcar como facturado.');
INSERT INTO `lang_definitions` VALUES (4704, 3022, 3, 'Certificados de descargas');
INSERT INTO `lang_definitions` VALUES (4705, 3023, 3, 'Descargar datos de configuración');
INSERT INTO `lang_definitions` VALUES (4706, 3027, 3, 'Descargar fichero encriptado');
INSERT INTO `lang_definitions` VALUES (4707, 3028, 3, 'Descargar FAX');
INSERT INTO `lang_definitions` VALUES (4708, 3032, 3, 'Descargar o Borrar una plantilla');
INSERT INTO `lang_definitions` VALUES (4709, 3033, 3, 'Descargar PDF');
INSERT INTO `lang_definitions` VALUES (4710, 3037, 3, 'Descargar seleccionados');
INSERT INTO `lang_definitions` VALUES (4711, 3039, 3, 'Revisar médico');
INSERT INTO `lang_definitions` VALUES (4712, 3040, 3, 'Visitar médico');
INSERT INTO `lang_definitions` VALUES (4713, 3041, 3, 'Dr.');
INSERT INTO `lang_definitions` VALUES (4714, 3045, 3, 'Arrastre para mover');
INSERT INTO `lang_definitions` VALUES (4715, 3047, 3, 'Goteo');
INSERT INTO `lang_definitions` VALUES (4716, 3048, 3, 'Permiso de conducir o D.N.I.');
INSERT INTO `lang_definitions` VALUES (4717, 3050, 3, 'Medicamento');
INSERT INTO `lang_definitions` VALUES (4718, 3053, 3, 'Buscador de medicamentos');
INSERT INTO `lang_definitions` VALUES (4719, 3054, 3, 'Formularios de Medicamento');
INSERT INTO `lang_definitions` VALUES (4720, 3055, 3, 'Nº Identificación medicamento falta!');
INSERT INTO `lang_definitions` VALUES (4721, 3056, 3, 'Intervalos de Medicamento');
INSERT INTO `lang_definitions` VALUES (4722, 3057, 3, 'Inventario de Medicamentos');
INSERT INTO `lang_definitions` VALUES (4723, 3059, 3, 'Nombre del Medicamento');
INSERT INTO `lang_definitions` VALUES (4724, 3061, 3, 'Vía de administración del Medicamento');
INSERT INTO `lang_definitions` VALUES (4725, 3066, 3, 'Unidades de Medicamento');
INSERT INTO `lang_definitions` VALUES (4726, 3072, 3, 'Medicamentos');
INSERT INTO `lang_definitions` VALUES (4727, 3073, 3, 'Medicamentos y productos');
INSERT INTO `lang_definitions` VALUES (4728, 3074, 3, 'Boca seca');
INSERT INTO `lang_definitions` VALUES (4729, 3075, 3, 'Diagnóstico DSMIV');
INSERT INTO `lang_definitions` VALUES (4730, 3076, 3, 'DT 1');
INSERT INTO `lang_definitions` VALUES (4731, 3077, 3, 'DT 2');
INSERT INTO `lang_definitions` VALUES (4732, 3078, 3, 'DT 3');
INSERT INTO `lang_definitions` VALUES (4733, 3079, 3, 'DT 4');
INSERT INTO `lang_definitions` VALUES (4734, 3080, 3, 'DT 5');
INSERT INTO `lang_definitions` VALUES (4735, 3081, 3, 'DTaP 1');
INSERT INTO `lang_definitions` VALUES (4736, 3082, 3, 'DTaP 2');
INSERT INTO `lang_definitions` VALUES (4737, 3083, 3, 'DTaP 3');
INSERT INTO `lang_definitions` VALUES (4738, 3084, 3, 'DTaP 4');
INSERT INTO `lang_definitions` VALUES (4739, 3085, 3, 'DTaP 5');
INSERT INTO `lang_definitions` VALUES (4740, 3087, 3, 'Adeudado');
INSERT INTO `lang_definitions` VALUES (4741, 3088, 3, 'Fecha del parto');
INSERT INTO `lang_definitions` VALUES (4742, 3090, 3, 'Fecha del parto mm/dd/aaaa o aaaa-mm-dd');
INSERT INTO `lang_definitions` VALUES (4743, 3091, 3, 'Fecha del parto:');
INSERT INTO `lang_definitions` VALUES (4744, 3092, 3, 'Deuda Seguro');
INSERT INTO `lang_definitions` VALUES (4745, 3093, 3, 'Deuda Paciente');
INSERT INTO `lang_definitions` VALUES (4746, 3094, 3, 'Deuda próxima');
INSERT INTO `lang_definitions` VALUES (4747, 3095, 3, 'Estado de Deuda');
INSERT INTO `lang_definitions` VALUES (4748, 3096, 3, 'Actualización Estado de Deuda');
INSERT INTO `lang_definitions` VALUES (4749, 3097, 3, 'Volcar OpenEMR base de datos');
INSERT INTO `lang_definitions` VALUES (4750, 3098, 3, 'Volcar OpenEMR web de árbol de directorios');
INSERT INTO `lang_definitions` VALUES (4751, 3099, 3, 'Volcar phpGACL base de datos');
INSERT INTO `lang_definitions` VALUES (4752, 3100, 3, 'volcar phpGACL web de árbol de directorios');
INSERT INTO `lang_definitions` VALUES (4753, 3101, 3, 'Volcar SQL-Ledger base de datos');
INSERT INTO `lang_definitions` VALUES (4754, 3102, 3, 'Volcar phpGACL web de árbol de directorios');
INSERT INTO `lang_definitions` VALUES (4755, 3103, 3, 'Compruebe duplicado');
INSERT INTO `lang_definitions` VALUES (4756, 3108, 3, 'ID duplicado en linea');
INSERT INTO `lang_definitions` VALUES (4757, 3109, 3, 'Nombre duplicado en linea');
INSERT INTO `lang_definitions` VALUES (4758, 3110, 3, 'AVISO DE DUPLICACION');
INSERT INTO `lang_definitions` VALUES (4759, 3111, 3, 'Poder Legal Duradero');
INSERT INTO `lang_definitions` VALUES (4760, 3112, 3, 'Duración');
INSERT INTO `lang_definitions` VALUES (4761, 3113, 3, 'duración');
INSERT INTO `lang_definitions` VALUES (4762, 3114, 3, 'Holandés');
INSERT INTO `lang_definitions` VALUES (4763, 3116, 3, 'Dx Rep');
INSERT INTO `lang_definitions` VALUES (4764, 3117, 3, 'Disfagia');
INSERT INTO `lang_definitions` VALUES (4765, 3118, 3, 'Disnea');
INSERT INTO `lang_definitions` VALUES (4766, 3119, 3, 'Disuria');
INSERT INTO `lang_definitions` VALUES (4767, 3122, 3, 'E-Mail');
INSERT INTO `lang_definitions` VALUES (4768, 3123, 3, 'E-mail');
INSERT INTO `lang_definitions` VALUES (4769, 3128, 3, '¿E-Receta?');
INSERT INTO `lang_definitions` VALUES (4770, 3130, 3, 'Receta Electrónica');
INSERT INTO `lang_definitions` VALUES (4771, 3132, 3, 'Renovación Receta Electrónica');
INSERT INTO `lang_definitions` VALUES (4772, 3135, 3, 'Cada destinatario debe establecer sus propios mensajes como terminados.');
INSERT INTO `lang_definitions` VALUES (4773, 3140, 3, 'Repetición Temprana (<2 Mo)');
INSERT INTO `lang_definitions` VALUES (4774, 3141, 3, 'Orejas');
INSERT INTO `lang_definitions` VALUES (4775, 3148, 3, 'Electrocardiograma');
INSERT INTO `lang_definitions` VALUES (4776, 3149, 3, 'Reclamaciones electrónicas');
INSERT INTO `lang_definitions` VALUES (4777, 3152, 3, 'Edema');
INSERT INTO `lang_definitions` VALUES (4778, 3157, 3, 'Adjuntar fichero EDI-271');
INSERT INTO `lang_definitions` VALUES (4779, 3158, 3, 'Respuesta de carga de fichero EDI-271');
INSERT INTO `lang_definitions` VALUES (4780, 3159, 3, 'Editar');
INSERT INTO `lang_definitions` VALUES (4781, 3160, 3, 'editar');
INSERT INTO `lang_definitions` VALUES (4782, 3161, 3, 'Editar alergias');
INSERT INTO `lang_definitions` VALUES (4783, 3163, 3, 'Editar categorías');
INSERT INTO `lang_definitions` VALUES (4784, 3165, 3, 'Editar Definiciones');
INSERT INTO `lang_definitions` VALUES (4785, 3166, 3, 'Editar definiciones');
INSERT INTO `lang_definitions` VALUES (4786, 3167, 3, 'Editar diagnóstico para');
INSERT INTO `lang_definitions` VALUES (4787, 3168, 3, 'editar publicación');
INSERT INTO `lang_definitions` VALUES (4788, 3173, 3, 'Editar Clínicas');
INSERT INTO `lang_definitions` VALUES (4789, 3174, 3, 'Editar Centro');
INSERT INTO `lang_definitions` VALUES (4790, 3175, 3, 'Editar información del Centro');
INSERT INTO `lang_definitions` VALUES (4791, 3176, 3, 'Editar información de instalación de usuario específico');
INSERT INTO `lang_definitions` VALUES (4792, 3177, 3, 'editar fichero en');
INSERT INTO `lang_definitions` VALUES (4793, 3178, 3, 'Editar forma');
INSERT INTO `lang_definitions` VALUES (4794, 3179, 3, 'Editar configuración global');
INSERT INTO `lang_definitions` VALUES (4795, 3181, 3, 'Edición no permitida');
INSERT INTO `lang_definitions` VALUES (4796, 3183, 3, 'Editar el diseño');
INSERT INTO `lang_definitions` VALUES (4797, 3185, 3, 'Editar la lista');
INSERT INTO `lang_definitions` VALUES (4798, 3188, 3, 'Editar Pago');
INSERT INTO `lang_definitions` VALUES (4799, 3189, 3, 'Editar estructura');
INSERT INTO `lang_definitions` VALUES (4800, 3192, 3, 'Editar usuario');
INSERT INTO `lang_definitions` VALUES (4801, 3193, 3, 'Editar configuración de usuario');
INSERT INTO `lang_definitions` VALUES (4802, 3194, 3, 'Editar su información');
INSERT INTO `lang_definitions` VALUES (4803, 3195, 3, 'La edición falló');
INSERT INTO `lang_definitions` VALUES (4804, 3196, 3, 'Educación');
INSERT INTO `lang_definitions` VALUES (4805, 3197, 3, 'Fecha educación');
INSERT INTO `lang_definitions` VALUES (4806, 3199, 3, 'Debería haber recibido una copia del GNU con este programa, si no, escriba al Free');
INSERT INTO `lang_definitions` VALUES (4807, 3200, 3, 'Fecha efectiva');
INSERT INTO `lang_definitions` VALUES (4808, 3202, 3, 'Efectividad');
INSERT INTO `lang_definitions` VALUES (4809, 3204, 3, 'EIN');
INSERT INTO `lang_definitions` VALUES (4810, 3207, 3, 'Eyaculaciones');
INSERT INTO `lang_definitions` VALUES (4811, 3208, 3, 'Codo');
INSERT INTO `lang_definitions` VALUES (4812, 3209, 3, 'Problemas del codo');
INSERT INTO `lang_definitions` VALUES (4813, 3210, 3, 'Electrónico');
INSERT INTO `lang_definitions` VALUES (4814, 3214, 3, 'Mandatos Electronicos');
INSERT INTO `lang_definitions` VALUES (4815, 3218, 3, 'Elegibilidad');
INSERT INTO `lang_definitions` VALUES (4816, 3219, 3, 'Elegibilidad Batch Consulta 270');
INSERT INTO `lang_definitions` VALUES (4817, 3220, 3, 'Elegibilidad de Respuesta');
INSERT INTO `lang_definitions` VALUES (4818, 3222, 3, 'Estado de elegibilidad para la vacuna suministrada para niños');
INSERT INTO `lang_definitions` VALUES (4819, 3223, 3, 'Elegible');
INSERT INTO `lang_definitions` VALUES (4820, 3225, 3, 'email');
INSERT INTO `lang_definitions` VALUES (4821, 3228, 3, 'email');
INSERT INTO `lang_definitions` VALUES (4822, 3230, 3, 'email del remitente para los recordatorios de pacientes. Las respuestas de los pacientes irán a esa dirección. Es importante usar una dirección del dominio de la Clínica para evitar que las respuestas de recordatorios de los pacientes vayan a la carpeta de correo basura.');
INSERT INTO `lang_definitions` VALUES (4823, 3231, 3, 'email, si hay, para recibir notificaciones administrativas.');
INSERT INTO `lang_definitions` VALUES (4824, 3232, 3, 'email, si hay, para recibir mensajes de activación de inicio sesión de usuario.');
INSERT INTO `lang_definitions` VALUES (4825, 3233, 3, 'Autenticación email');
INSERT INTO `lang_definitions` VALUES (4826, 3236, 3, 'email de Batchcom');
INSERT INTO `lang_definitions` VALUES (4827, 3238, 3, 'Notificación email');
INSERT INTO `lang_definitions` VALUES (4828, 3239, 3, 'Horario Notificación Email');
INSERT INTO `lang_definitions` VALUES (4829, 3240, 3, 'Informe de notificación de email');
INSERT INTO `lang_definitions` VALUES (4830, 3244, 3, 'email enviado antes');
INSERT INTO `lang_definitions` VALUES (4831, 3245, 3, 'Remitente de email');
INSERT INTO `lang_definitions` VALUES (4832, 3246, 3, 'Email enviado');
INSERT INTO `lang_definitions` VALUES (4833, 3247, 3, 'email enviado a');
INSERT INTO `lang_definitions` VALUES (4834, 3248, 3, 'Asunto del email');
INSERT INTO `lang_definitions` VALUES (4835, 3251, 3, 'Texto del email, etiqueta útil: ***NAME***, Ej. Estimado ***NAME***');
INSERT INTO `lang_definitions` VALUES (4836, 3252, 3, 'Texto email, etiqueta útil:***NAME***, por ej. Querido ***NAME***{{No traducir el elemento ***NAME*** de esta constante}}');
INSERT INTO `lang_definitions` VALUES (4837, 3253, 3, 'Método de envío de email');
INSERT INTO `lang_definitions` VALUES (4838, 3254, 3, 'Email enviado a las siguientes direcciones');
INSERT INTO `lang_definitions` VALUES (4839, 3259, 3, 'Contacto en caso de emergencia');
INSERT INTO `lang_definitions` VALUES (4840, 3260, 3, 'Persona de Contacto de Emergencia');
INSERT INTO `lang_definitions` VALUES (4841, 3261, 3, 'Teléfono de Contacto de Emergencias');
INSERT INTO `lang_definitions` VALUES (4842, 3262, 3, 'Emergencia anticonceptiva');
INSERT INTO `lang_definitions` VALUES (4843, 3263, 3, 'Acceso de Emergencia');
INSERT INTO `lang_definitions` VALUES (4844, 3264, 3, 'Inicio sesión de Emergencia ACL elegido. El usuario esta aún activo, favor desactivar usuario y activarlo cuando la situación de emergencia lo requiera. Visitar Administración>Usuario para activación o deactivación');
INSERT INTO `lang_definitions` VALUES (4845, 3265, 3, 'El email de activación de inicio de sesión de emergencia ha de circular sólo si los siguientes ajustes del fichero interfase/globals.php están configurados:');
INSERT INTO `lang_definitions` VALUES (4846, 3266, 3, 'email de inicio de sesión de emergencia');
INSERT INTO `lang_definitions` VALUES (4847, 3267, 3, 'El usuario de Inicio de sesión de emergencia puede hacer cualquier cosa');
INSERT INTO `lang_definitions` VALUES (4848, 3268, 3, 'Teléfono de emergencia');
INSERT INTO `lang_definitions` VALUES (4849, 3271, 3, 'Enfisema');
INSERT INTO `lang_definitions` VALUES (4850, 3272, 3, 'Empleado');
INSERT INTO `lang_definitions` VALUES (4851, 3273, 3, 'Empresa');
INSERT INTO `lang_definitions` VALUES (4852, 3274, 3, 'Dirección del empleador');
INSERT INTO `lang_definitions` VALUES (4853, 3275, 3, 'Datos de la empresa');
INSERT INTO `lang_definitions` VALUES (4854, 3276, 3, 'Nombre de Empresa');
INSERT INTO `lang_definitions` VALUES (4855, 3277, 3, 'VACIO');
INSERT INTO `lang_definitions` VALUES (4856, 3278, 3, 'Vacio');
INSERT INTO `lang_definitions` VALUES (4857, 3281, 3, 'Valor vacío en -Horas de eEmail-');
INSERT INTO `lang_definitions` VALUES (4858, 3282, 3, 'Valor vacío en -Remitente de email-');
INSERT INTO `lang_definitions` VALUES (4859, 3283, 3, 'Valor vacío en-Tema de email-');
INSERT INTO `lang_definitions` VALUES (4860, 3284, 3, 'Valor vacío en-Texto de email-');
INSERT INTO `lang_definitions` VALUES (4861, 3285, 3, 'Valor vacío en -Nombre del Facultativo-');
INSERT INTO `lang_definitions` VALUES (4862, 3286, 3, 'Valor vacío en -Contraseña-');
INSERT INTO `lang_definitions` VALUES (4863, 3287, 3, 'Valor vacío en -Horas de SMS-');
INSERT INTO `lang_definitions` VALUES (4864, 3288, 3, 'Vaciar en el valor -Texto SMS-');
INSERT INTO `lang_definitions` VALUES (4865, 3289, 3, 'Vaciar en el valor -Usuario-');
INSERT INTO `lang_definitions` VALUES (4866, 3298, 3, 'Activar aviso MCA');
INSERT INTO `lang_definitions` VALUES (4867, 3300, 3, 'Activar Informe MCA');
INSERT INTO `lang_definitions` VALUES (4868, 3301, 3, 'Activar seguimiento MCA');
INSERT INTO `lang_definitions` VALUES (4869, 3303, 3, 'Activar auditoría RANA');
INSERT INTO `lang_definitions` VALUES (4870, 3305, 3, 'Inicio de sesión Auditoría habilitado');
INSERT INTO `lang_definitions` VALUES (4871, 3306, 3, 'Activar Auditoría Registro y Autenticación del Nodo (ATNA)');
INSERT INTO `lang_definitions` VALUES (4872, 3307, 3, 'Activar Informe Medidas de Cálculo Automático (MCA)');
INSERT INTO `lang_definitions` VALUES (4873, 3312, 3, 'Activar Cliente SSL');
INSERT INTO `lang_definitions` VALUES (4874, 3313, 3, 'Activar Cliente SSL con certificado de autenticación.');
INSERT INTO `lang_definitions` VALUES (4875, 3315, 3, 'Activar Reglas Clínicas de Decisión (CDR)');
INSERT INTO `lang_definitions` VALUES (4876, 3318, 3, 'Activar informe medidas de calidad clínica (GCC)');
INSERT INTO `lang_definitions` VALUES (4877, 3319, 3, 'Activar popup recordatorios clínicos');
INSERT INTO `lang_definitions` VALUES (4878, 3320, 3, 'Activar Widget Recordatorios clínicos');
INSERT INTO `lang_definitions` VALUES (4879, 3324, 3, 'Activar Informes GCC');
INSERT INTO `lang_definitions` VALUES (4880, 3334, 3, 'Habilitar tarifas en el menú de la izquierda');
INSERT INTO `lang_definitions` VALUES (4881, 3341, 3, 'Activar Soporte Hylafax');
INSERT INTO `lang_definitions` VALUES (4882, 3343, 3, 'Activar el estado de importación de mensajes para Receta electrónica NewCrop');
INSERT INTO `lang_definitions` VALUES (4883, 3347, 3, 'Activar intercambio Laboratorio');
INSERT INTO `lang_definitions` VALUES (4884, 3349, 3, 'Habilitar registro para documentos subidos/bajados de CouchDB');
INSERT INTO `lang_definitions` VALUES (4885, 3350, 3, 'Activar registro de todas las consultas SQL SELECT.');
INSERT INTO `lang_definitions` VALUES (4886, 3351, 3, 'Activar registro de backup de actividades relacionadas.');
INSERT INTO `lang_definitions` VALUES (4887, 3353, 3, 'Activar inicio sesión de actividades varias.');
INSERT INTO `lang_definitions` VALUES (4888, 3354, 3, 'Activar registro de actividades solicitadas.');
INSERT INTO `lang_definitions` VALUES (4889, 3355, 3, 'Activar registro de modificaciones del registro de pacientes.');
INSERT INTO `lang_definitions` VALUES (4890, 3356, 3, 'Activar registro de programar actividades.');
INSERT INTO `lang_definitions` VALUES (4891, 3357, 3, 'Activar registro de seguridad y administración de actividades.');
INSERT INTO `lang_definitions` VALUES (4892, 3360, 3, 'Activar servicio Receta electrónica NewCrop');
INSERT INTO `lang_definitions` VALUES (4893, 3365, 3, 'Activar Portal Paciente Externo');
INSERT INTO `lang_definitions` VALUES (4894, 3366, 3, 'Activar Portal paciente desde el exterior.');
INSERT INTO `lang_definitions` VALUES (4895, 3368, 3, 'Activar Portal paciente in-situ');
INSERT INTO `lang_definitions` VALUES (4896, 3371, 3, 'Activar Portal paciente in-situ.');
INSERT INTO `lang_definitions` VALUES (4897, 3385, 3, 'Activar widget recordatorios del paciente');
INSERT INTO `lang_definitions` VALUES (4898, 3389, 3, 'Activar aviso fecha requerida para Medidas de Cálculo Automático (MCA)');
INSERT INTO `lang_definitions` VALUES (4899, 3391, 3, 'Activar Informe de Seguimiento de Fecha para Medidas de Cálculo Automático (MCA)');
INSERT INTO `lang_definitions` VALUES (4900, 3392, 3, 'Activar Soporte escaner');
INSERT INTO `lang_definitions` VALUES (4901, 3397, 3, 'Activar servicio de soporte OpenEMR LLC Laboratorio de intercambio');
INSERT INTO `lang_definitions` VALUES (4902, 3398, 3, 'Activar Certificado de Autenticación del usuario.');
INSERT INTO `lang_definitions` VALUES (4903, 3403, 3, 'Activar servicio ZMG, Receta electrónica LLC');
INSERT INTO `lang_definitions` VALUES (4904, 3404, 3, 'Activado');
INSERT INTO `lang_definitions` VALUES (4905, 3412, 3, 'Activar el viejo panel de cargos para introducir códigos de facturas y pagos. No se recomienda usar la hoja de honorarios en su lugar.');
INSERT INTO `lang_definitions` VALUES (4906, 3415, 3, 'Encuentro');
INSERT INTO `lang_definitions` VALUES (4907, 3417, 3, 'Visita');
INSERT INTO `lang_definitions` VALUES (4908, 3418, 3, 'Visita');
INSERT INTO `lang_definitions` VALUES (4909, 3419, 3, 'visita');
INSERT INTO `lang_definitions` VALUES (4910, 3420, 3, 'Visita');
INSERT INTO `lang_definitions` VALUES (4911, 3421, 3, 'Visita a un hospitalizado agudo o ED');
INSERT INTO `lang_definitions` VALUES (4912, 3427, 3, 'Fecha visita');
INSERT INTO `lang_definitions` VALUES (4913, 3432, 3, 'Formularios visita');
INSERT INTO `lang_definitions` VALUES (4914, 3433, 3, 'visita de salud y evaluación de comportamiento');
INSERT INTO `lang_definitions` VALUES (4915, 3434, 3, 'Histórico de visitas');
INSERT INTO `lang_definitions` VALUES (4916, 3435, 3, 'ID Visita');
INSERT INTO `lang_definitions` VALUES (4917, 3436, 3, 'Visita gripe');
INSERT INTO `lang_definitions` VALUES (4918, 3439, 3, 'número visita');
INSERT INTO `lang_definitions` VALUES (4919, 3441, 3, 'visita cuidado enfermería');
INSERT INTO `lang_definitions` VALUES (4920, 3442, 3, 'visita centro enfermería');
INSERT INTO `lang_definitions` VALUES (4921, 3443, 3, 'visita terapia ocupacional');
INSERT INTO `lang_definitions` VALUES (4922, 3444, 3, 'visita a consultorio');
INSERT INTO `lang_definitions` VALUES (4923, 3445, 3, 'visita paciente externo');
INSERT INTO `lang_definitions` VALUES (4924, 3446, 3, 'visita paciente externo w/PCP y obgyn');
INSERT INTO `lang_definitions` VALUES (4925, 3447, 3, 'Tamaño página visita');
INSERT INTO `lang_definitions` VALUES (4926, 3448, 3, 'Pago visita');
INSERT INTO `lang_definitions` VALUES (4927, 3449, 3, 'visita embarazo');
INSERT INTO `lang_definitions` VALUES (4928, 3450, 3, 'visita medicina preventiva - asesoramiento individual');
INSERT INTO `lang_definitions` VALUES (4929, 3451, 3, 'visita medicina preventiva para mayores de 40');
INSERT INTO `lang_definitions` VALUES (4930, 3452, 3, 'visita de medicina preventiva - asesoramiento en grupo');
INSERT INTO `lang_definitions` VALUES (4931, 3453, 3, 'visita medicina preventiva otros servicios');
INSERT INTO `lang_definitions` VALUES (4932, 3454, 3, 'visita servicios medicina preventiva mayores de 18');
INSERT INTO `lang_definitions` VALUES (4933, 3457, 3, 'visita psiquiatrica y psicológica');
INSERT INTO `lang_definitions` VALUES (4934, 3458, 3, 'Estadísticas de visitas');
INSERT INTO `lang_definitions` VALUES (4935, 3459, 3, 'Resumen de visitas');
INSERT INTO `lang_definitions` VALUES (4936, 3461, 3, 'Visita codificada');
INSERT INTO `lang_definitions` VALUES (4937, 3462, 3, 'Visita:');
INSERT INTO `lang_definitions` VALUES (4938, 3463, 3, 'Visita: visita ingreso no agudo, paciente externo, o oftalmológico');
INSERT INTO `lang_definitions` VALUES (4939, 3464, 3, 'Visitas');
INSERT INTO `lang_definitions` VALUES (4940, 3465, 3, 'Visitas y Formularios');
INSERT INTO `lang_definitions` VALUES (4941, 3466, 3, 'Visitas y Formularios');
INSERT INTO `lang_definitions` VALUES (4942, 3467, 3, 'Visitas no autorizadas');
INSERT INTO `lang_definitions` VALUES (4943, 3468, 3, 'Informe de visitas');
INSERT INTO `lang_definitions` VALUES (4944, 3469, 3, 'Sección visitas');
INSERT INTO `lang_definitions` VALUES (4945, 3471, 3, 'Encriptación');
INSERT INTO `lang_definitions` VALUES (4946, 3472, 3, 'Final');
INSERT INTO `lang_definitions` VALUES (4947, 3473, 3, 'Final (aaaa-mm-dd):');
INSERT INTO `lang_definitions` VALUES (4948, 3474, 3, 'Fecha final');
INSERT INTO `lang_definitions` VALUES (4949, 3475, 3, 'Fecha final');
INSERT INTO `lang_definitions` VALUES (4950, 3480, 3, 'Fecha final debe ser posterior a fecha inicio');
INSERT INTO `lang_definitions` VALUES (4951, 3482, 3, 'Fecha Final:');
INSERT INTO `lang_definitions` VALUES (4952, 3487, 3, 'Hora finalización');
INSERT INTO `lang_definitions` VALUES (4953, 3489, 3, 'Enfermedad renal en Etapa Final - Beneficiario de MCP con un Plan de grupo del empleador');
INSERT INTO `lang_definitions` VALUES (4954, 3492, 3, 'Fecha final de servicio aaaa-mm-dd');
INSERT INTO `lang_definitions` VALUES (4955, 3493, 3, 'Termina DOS dd/mm/aaaa si desea entrar en una serie');
INSERT INTO `lang_definitions` VALUES (4956, 3494, 3, 'Hora final del día para eventos de calendario');
INSERT INTO `lang_definitions` VALUES (4957, 3495, 3, 'Sangre anormal Endo');
INSERT INTO `lang_definitions` VALUES (4958, 3496, 3, 'Endocrino');
INSERT INTO `lang_definitions` VALUES (4959, 3497, 3, 'Endoscopía');
INSERT INTO `lang_definitions` VALUES (4960, 3502, 3, 'Inglés');
INSERT INTO `lang_definitions` VALUES (4961, 3503, 3, 'Inglés');
INSERT INTO `lang_definitions` VALUES (4962, 3504, 3, 'Ingleses (Indios)');
INSERT INTO `lang_definitions` VALUES (4963, 3505, 3, 'Inglés (Estándar)');
INSERT INTO `lang_definitions` VALUES (4964, 3506, 3, 'Enscript comando usado por Hylafax.');
INSERT INTO `lang_definitions` VALUES (4965, 3507, 3, 'Garantizar OpenEMR tiene privilegios al directorio');
INSERT INTO `lang_definitions` VALUES (4966, 3509, 3, 'ENT Descarga');
INSERT INTO `lang_definitions` VALUES (4967, 3510, 3, 'ENT Dolor');
INSERT INTO `lang_definitions` VALUES (4968, 3513, 3, 'Introduzca un código de la diagnosis para excluir todas las facturas que no lo contienen');
INSERT INTO `lang_definitions` VALUES (4969, 3518, 3, 'Incorpore el cuerpo de la carta aquí');
INSERT INTO `lang_definitions` VALUES (4970, 3520, 3, 'Introduzca Contraseña root para Base Datos');
INSERT INTO `lang_definitions` VALUES (4971, 3521, 3, 'Introduzca Usuario root para Base Datos');
INSERT INTO `lang_definitions` VALUES (4972, 3529, 3, 'Introduzca Diagnóstico');
INSERT INTO `lang_definitions` VALUES (4973, 3530, 3, 'Introduzca Medicamentos');
INSERT INTO `lang_definitions` VALUES (4974, 3537, 3, 'Introduzca Vacunas');
INSERT INTO `lang_definitions` VALUES (4975, 3538, 3, 'Introducir Clave');
INSERT INTO `lang_definitions` VALUES (4976, 3544, 3, 'Escriba el nuevo Estado');
INSERT INTO `lang_definitions` VALUES (4977, 3569, 3, 'Introducir código Re-identificación');
INSERT INTO `lang_definitions` VALUES (4978, 3581, 3, 'Incorpore sus criterios de búsqueda arriba');
INSERT INTO `lang_definitions` VALUES (4979, 3586, 3, 'entradas');
INSERT INTO `lang_definitions` VALUES (4980, 3591, 3, 'Ambiental');
INSERT INTO `lang_definitions` VALUES (4981, 3592, 3, 'Entrada de datos de EOB');
INSERT INTO `lang_definitions` VALUES (4982, 3596, 3, 'EOB envío - Remesas electrónicas');
INSERT INTO `lang_definitions` VALUES (4983, 3597, 3, 'EOB envío - Instrucciones');
INSERT INTO `lang_definitions` VALUES (4984, 3598, 3, 'EOB envío - Factura');
INSERT INTO `lang_definitions` VALUES (4985, 3599, 3, 'EOB envío - Nota del Paciente');
INSERT INTO `lang_definitions` VALUES (4986, 3600, 3, 'EOB envío - Buscar');
INSERT INTO `lang_definitions` VALUES (4987, 3602, 3, 'Epilepsia');
INSERT INTO `lang_definitions` VALUES (4988, 3608, 3, 'ERA (Remesa Electrónica de Aviso)');
INSERT INTO `lang_definitions` VALUES (4989, 3610, 3, 'Envío ERA (Remesa Electrónica de Aviso)');
INSERT INTO `lang_definitions` VALUES (4990, 3612, 3, 'Borrar');
INSERT INTO `lang_definitions` VALUES (4991, 3614, 3, 'Erecciones');
INSERT INTO `lang_definitions` VALUES (4992, 3615, 3, 'Error');
INSERT INTO `lang_definitions` VALUES (4993, 3617, 3, 'Error confirmando la recepción de los resultados del laboratorio');
INSERT INTO `lang_definitions` VALUES (4994, 3620, 3, 'Error al obtener los resultados de laboratorio de la red de intercambio del laboratorio');
INSERT INTO `lang_definitions` VALUES (4995, 3621, 3, 'Error en selección de género');
INSERT INTO `lang_definitions` VALUES (4996, 3622, 3, 'Error en -HIPAA- selección');
INSERT INTO `lang_definitions` VALUES (4997, 3623, 3, 'Error en el -Proceso de selección');
INSERT INTO `lang_definitions` VALUES (4998, 3624, 3, 'El error en la selección de -Puerta enlace SMS-');
INSERT INTO `lang_definitions` VALUES (4999, 3625, 3, 'Error en -Ordenar por- selección');
INSERT INTO `lang_definitions` VALUES (5000, 3626, 3, 'Error del file de compresion gzip');
INSERT INTO `lang_definitions` VALUES (5001, 3627, 3, 'Error en la opción SI o NO');
INSERT INTO `lang_definitions` VALUES (5002, 3630, 3, 'Error al abrir fichero adjunto para lectura');
INSERT INTO `lang_definitions` VALUES (5003, 3633, 3, 'Error al eliminar el mensaje');
INSERT INTO `lang_definitions` VALUES (5004, 3634, 3, 'Error recuperando resultados de la red de intercambio del laboratorio');
INSERT INTO `lang_definitions` VALUES (5005, 3637, 3, 'Error en el fichero de concesión de privilegios para el usuario de OpenEMR.');
INSERT INTO `lang_definitions` VALUES (5006, 3640, 3, 'error al registrar la forma!');
INSERT INTO `lang_definitions` VALUES (5007, 3641, 3, 'Error al guardar el fichero');
INSERT INTO `lang_definitions` VALUES (5008, 3643, 3, 'Error al escribir en el fichero');
INSERT INTO `lang_definitions` VALUES (5009, 3651, 3, 'Error, Este file no existe');
INSERT INTO `lang_definitions` VALUES (5010, 3652, 3, 'ERROR, incapaz de recoger los datos de servidor');
INSERT INTO `lang_definitions` VALUES (5011, 3653, 3, 'Error, incapaz de crear certificado de cliente');
INSERT INTO `lang_definitions` VALUES (5012, 3654, 3, 'Error, incapaz de crear el certificado p12 de Admin');
INSERT INTO `lang_definitions` VALUES (5013, 3655, 3, 'Error. No puede crearse certificadodo de Certificado de Autenticación');
INSERT INTO `lang_definitions` VALUES (5014, 3656, 3, 'Error, incapaz de crear el certificado del servidor');
INSERT INTO `lang_definitions` VALUES (5015, 3658, 3, 'Error, incapaz de abrir el file');
INSERT INTO `lang_definitions` VALUES (5016, 3659, 3, 'Error. Certificado de Autenticación de usuario no está activado en OpenEMR');
INSERT INTO `lang_definitions` VALUES (5017, 3663, 3, 'Error. Necesita instalar el fichero/Tar.php módulo php');
INSERT INTO `lang_definitions` VALUES (5018, 3664, 3, 'ERROR: no pudo abrir tabla sql, formulario roto?');
INSERT INTO `lang_definitions` VALUES (5019, 3667, 3, 'Error: ID duplicado en línea');
INSERT INTO `lang_definitions` VALUES (5020, 3668, 3, 'Error: Nombre duplicado en línea');
INSERT INTO `lang_definitions` VALUES (5021, 3669, 3, 'ERROR: Campo');
INSERT INTO `lang_definitions` VALUES (5022, 3670, 3, 'ERROR: Falta el fichero comprimido del Módulo PHP');
INSERT INTO `lang_definitions` VALUES (5023, 3671, 3, 'ERROR: Sin directorio de importación ICD');
INSERT INTO `lang_definitions` VALUES (5024, 3672, 3, 'Error: las contraseñas no coinciden. Por favor, compruebe lo tecleado.');
INSERT INTO `lang_definitions` VALUES (5025, 3673, 3, 'Error: las contraseñas no coinciden. Por favor, compruebe lo tecleado.');
INSERT INTO `lang_definitions` VALUES (5026, 3674, 3, 'Error, este file no existe');
INSERT INTO `lang_definitions` VALUES (5027, 3675, 3, 'ERROR: La siguiente variable contiene caracteres inválidos');
INSERT INTO `lang_definitions` VALUES (5028, 3676, 3, 'ERROR: No se puede copiar el fichero.');
INSERT INTO `lang_definitions` VALUES (5029, 3677, 3, 'Error, incapaz de crear el fichero de descarga');
INSERT INTO `lang_definitions` VALUES (5030, 3678, 3, 'ERROR: No se puede crear el fichero comprimido.');
INSERT INTO `lang_definitions` VALUES (5031, 3679, 3, 'ERROR: No se puede extraer el fichero.');
INSERT INTO `lang_definitions` VALUES (5032, 3680, 3, 'ERROR: No se puede leer el fichero en la base de datos.');
INSERT INTO `lang_definitions` VALUES (5033, 3681, 3, 'ERROR: No se puede establecer el número de versión.');
INSERT INTO `lang_definitions` VALUES (5034, 3682, 3, 'Errores');
INSERT INTO `lang_definitions` VALUES (5035, 3684, 3, 'Estado cuenta Receta electrónica');
INSERT INTO `lang_definitions` VALUES (5036, 3685, 3, 'Registros Receta electrónica');
INSERT INTO `lang_definitions` VALUES (5037, 3686, 3, 'Nombre Receta electrónica');
INSERT INTO `lang_definitions` VALUES (5038, 3687, 3, 'Contraseña Receta electrónica');
INSERT INTO `lang_definitions` VALUES (5039, 3688, 3, 'Rol Receta electrónica');
INSERT INTO `lang_definitions` VALUES (5040, 3689, 3, 'Usuario Receta electrónica');
INSERT INTO `lang_definitions` VALUES (5041, 3690, 3, 'Eritema');
INSERT INTO `lang_definitions` VALUES (5042, 3693, 3, 'Esquimal');
INSERT INTO `lang_definitions` VALUES (5043, 3699, 3, 'Paciente regular');
INSERT INTO `lang_definitions` VALUES (5044, 3701, 3, 'Raza');
INSERT INTO `lang_definitions` VALUES (5045, 3702, 3, 'La etnia o la raza');
INSERT INTO `lang_definitions` VALUES (5046, 3703, 3, 'Lista de Origen étnico--Raza (escriba, sólo añadir opcional)');
INSERT INTO `lang_definitions` VALUES (5047, 3706, 3, 'ETIN');
INSERT INTO `lang_definitions` VALUES (5048, 3709, 3, 'Evento');
INSERT INTO `lang_definitions` VALUES (5049, 3710, 3, 'Fecha comienzo de evento');
INSERT INTO `lang_definitions` VALUES (5050, 3711, 3, 'Categoría de evento');
INSERT INTO `lang_definitions` VALUES (5051, 3712, 3, 'Fecha evento');
INSERT INTO `lang_definitions` VALUES (5052, 3714, 3, 'Descripción evento');
INSERT INTO `lang_definitions` VALUES (5053, 3715, 3, 'Detalles evento');
INSERT INTO `lang_definitions` VALUES (5054, 3716, 3, 'Evento no se repite');
INSERT INTO `lang_definitions` VALUES (5055, 3717, 3, 'Duración de Evento');
INSERT INTO `lang_definitions` VALUES (5056, 3718, 3, 'Duración de evento en minutos');
INSERT INTO `lang_definitions` VALUES (5057, 3719, 3, 'Honorarios del evento');
INSERT INTO `lang_definitions` VALUES (5058, 3720, 3, 'Lugar de evento');
INSERT INTO `lang_definitions` VALUES (5059, 3721, 3, 'Evento repite cada');
INSERT INTO `lang_definitions` VALUES (5060, 3722, 3, 'Evento repite en');
INSERT INTO `lang_definitions` VALUES (5061, 3723, 3, 'Hora comienzo evento');
INSERT INTO `lang_definitions` VALUES (5062, 3724, 3, 'Título de evento');
INSERT INTO `lang_definitions` VALUES (5063, 3725, 3, 'Título de Evento');
INSERT INTO `lang_definitions` VALUES (5064, 3726, 3, 'Página web de evento');
INSERT INTO `lang_definitions` VALUES (5065, 3727, 3, 'Eventos');
INSERT INTO `lang_definitions` VALUES (5066, 3728, 3, 'Eventos para');
INSERT INTO `lang_definitions` VALUES (5067, 3729, 3, 'Eventos abre en nueva ventana');
INSERT INTO `lang_definitions` VALUES (5068, 3731, 3, 'cada');
INSERT INTO `lang_definitions` VALUES (5069, 3732, 3, 'Cada');
INSERT INTO `lang_definitions` VALUES (5070, 3734, 3, 'cada 3 horas');
INSERT INTO `lang_definitions` VALUES (5071, 3736, 3, 'cada 4 horas');
INSERT INTO `lang_definitions` VALUES (5072, 3738, 3, 'cada 5 horas');
INSERT INTO `lang_definitions` VALUES (5073, 3740, 3, 'cada 6 horas');
INSERT INTO `lang_definitions` VALUES (5074, 3742, 3, 'cada 8 horas');
INSERT INTO `lang_definitions` VALUES (5075, 3743, 3, 'cada cuarto');
INSERT INTO `lang_definitions` VALUES (5076, 3745, 3, 'uno sí, otro no');
INSERT INTO `lang_definitions` VALUES (5077, 3746, 3, 'cada tercero');
INSERT INTO `lang_definitions` VALUES (5078, 3747, 3, 'Cada, cada otro, cada 3ro, etc.');
INSERT INTO `lang_definitions` VALUES (5079, 3749, 3, 'Examen y los resultados de las pruebas');
INSERT INTO `lang_definitions` VALUES (5080, 3750, 3, 'Resultados del examen');
INSERT INTO `lang_definitions` VALUES (5081, 3753, 3, 'Examen');
INSERT INTO `lang_definitions` VALUES (5082, 3754, 3, 'Fecha de examen');
INSERT INTO `lang_definitions` VALUES (5083, 3755, 3, 'Ejemplo');
INSERT INTO `lang_definitions` VALUES (5084, 3758, 3, 'Ejemplos');
INSERT INTO `lang_definitions` VALUES (5085, 3760, 3, 'Exámenes/Pruebas');
INSERT INTO `lang_definitions` VALUES (5086, 3762, 3, 'Excepto');
INSERT INTO `lang_definitions` VALUES (5087, 3763, 3, 'Lagrimeo Excesivo');
INSERT INTO `lang_definitions` VALUES (5088, 3766, 3, 'Pacientes Excluídos');
INSERT INTO `lang_definitions` VALUES (5089, 3767, 3, 'Exclusiones');
INSERT INTO `lang_definitions` VALUES (5090, 3768, 3, 'Organización de provedor exclusivo (OPE)');
INSERT INTO `lang_definitions` VALUES (5091, 3770, 3, 'Tamaño papel ejecutivo');
INSERT INTO `lang_definitions` VALUES (5092, 3771, 3, 'Ejercicio');
INSERT INTO `lang_definitions` VALUES (5093, 3772, 3, 'Patrones de ejercicio');
INSERT INTO `lang_definitions` VALUES (5094, 3773, 3, 'Patrones del ejercicio');
INSERT INTO `lang_definitions` VALUES (5095, 3774, 3, 'Existe');
INSERT INTO `lang_definitions` VALUES (5096, 3778, 3, 'Salir de Administración');
INSERT INTO `lang_definitions` VALUES (5097, 3782, 3, 'Exp');
INSERT INTO `lang_definitions` VALUES (5098, 3784, 3, 'Expandir');
INSERT INTO `lang_definitions` VALUES (5099, 3785, 3, 'Expandir');
INSERT INTO `lang_definitions` VALUES (5100, 3787, 3, 'Expandir Todo');
INSERT INTO `lang_definitions` VALUES (5101, 3792, 3, 'Vista ampliada');
INSERT INTO `lang_definitions` VALUES (5102, 3793, 3, 'Se espera form_encounter.pid para ser');
INSERT INTO `lang_definitions` VALUES (5103, 3794, 3, 'Caducidad');
INSERT INTO `lang_definitions` VALUES (5104, 3795, 3, 'Fecha de caducidad');
INSERT INTO `lang_definitions` VALUES (5105, 3797, 3, 'Caducidad');
INSERT INTO `lang_definitions` VALUES (5106, 3798, 3, 'Expira en');
INSERT INTO `lang_definitions` VALUES (5107, 3799, 3, 'Exportar');
INSERT INTO `lang_definitions` VALUES (5108, 3800, 3, 'Exportar con CSV');
INSERT INTO `lang_definitions` VALUES (5109, 3802, 3, 'Exportar configuración');
INSERT INTO `lang_definitions` VALUES (5110, 3806, 3, 'Exportación de Demograficos del paciente');
INSERT INTO `lang_definitions` VALUES (5111, 3808, 3, 'Exportar Informe PQRI');
INSERT INTO `lang_definitions` VALUES (5112, 3810, 3, 'Selección de exportación como CSV');
INSERT INTO `lang_definitions` VALUES (5113, 3811, 3, 'Selección de las colecciones a la exportación');
INSERT INTO `lang_definitions` VALUES (5114, 3812, 3, 'Exportar a CSV');
INSERT INTO `lang_definitions` VALUES (5115, 3813, 3, 'Exportación al sistema de facturación externo');
INSERT INTO `lang_definitions` VALUES (5116, 3815, 3, 'Exposición a los países extranjeros');
INSERT INTO `lang_definitions` VALUES (5117, 3816, 3, 'Exposición a Países Extranjeros');
INSERT INTO `lang_definitions` VALUES (5118, 3818, 3, 'Ext tiempo de coleccionar');
INSERT INTO `lang_definitions` VALUES (5119, 3820, 3, 'Externo');
INSERT INTO `lang_definitions` VALUES (5120, 3823, 3, 'Carga de datos externos');
INSERT INTO `lang_definitions` VALUES (5121, 3824, 3, 'Utilidad de importación bbdd externa');
INSERT INTO `lang_definitions` VALUES (5122, 3828, 3, 'D.N.I.');
INSERT INTO `lang_definitions` VALUES (5123, 3829, 3, 'ID externo');
INSERT INTO `lang_definitions` VALUES (5124, 3830, 3, 'identificación externos');
INSERT INTO `lang_definitions` VALUES (5125, 3831, 3, 'Identificador externo');
INSERT INTO `lang_definitions` VALUES (5126, 3834, 3, 'Derivación externa');
INSERT INTO `lang_definitions` VALUES (5127, 3835, 3, 'Seguimiento de Derivaciones Externas');
INSERT INTO `lang_definitions` VALUES (5128, 3836, 3, '¿Derivación externa?');
INSERT INTO `lang_definitions` VALUES (5129, 3837, 3, 'Derivaciones externas');
INSERT INTO `lang_definitions` VALUES (5130, 3838, 3, 'Extraer este file comprimido');
INSERT INTO `lang_definitions` VALUES (5131, 3839, 3, 'Extrayendo fichero. Esto puede tardar algún tiempo...');
INSERT INTO `lang_definitions` VALUES (5132, 3840, 3, 'Exudado:');
INSERT INTO `lang_definitions` VALUES (5133, 3850, 3, 'Irritación de Ojo');
INSERT INTO `lang_definitions` VALUES (5134, 3856, 3, 'Dolor de Ojo');
INSERT INTO `lang_definitions` VALUES (5135, 3860, 3, 'Enrojecimiento de Ojo');
INSERT INTO `lang_definitions` VALUES (5136, 3863, 3, 'Ojos');
INSERT INTO `lang_definitions` VALUES (5137, 3865, 3, 'F');
INSERT INTO `lang_definitions` VALUES (5138, 3866, 3, 'F/H Problemas de Sangre');
INSERT INTO `lang_definitions` VALUES (5139, 3867, 3, 'F/H Hirsutismo Femenino/Estrías');
INSERT INTO `lang_definitions` VALUES (5140, 3868, 3, 'Centros');
INSERT INTO `lang_definitions` VALUES (5141, 3869, 3, 'Centro');
INSERT INTO `lang_definitions` VALUES (5142, 3870, 3, 'centro');
INSERT INTO `lang_definitions` VALUES (5143, 3871, 3, 'Administración del Centro');
INSERT INTO `lang_definitions` VALUES (5144, 3872, 3, 'Ciudad del Centro');
INSERT INTO `lang_definitions` VALUES (5145, 3873, 3, 'Código del Centro');
INSERT INTO `lang_definitions` VALUES (5146, 3875, 3, 'Código País del Centro');
INSERT INTO `lang_definitions` VALUES (5147, 3876, 3, 'Fax del Centro');
INSERT INTO `lang_definitions` VALUES (5148, 3878, 3, 'Nombre del Centro');
INSERT INTO `lang_definitions` VALUES (5149, 3879, 3, 'NPI del Centro');
INSERT INTO `lang_definitions` VALUES (5150, 3880, 3, 'Teléfono del Centro');
INSERT INTO `lang_definitions` VALUES (5151, 3882, 3, 'Información de usuario en el centro especificado');
INSERT INTO `lang_definitions` VALUES (5152, 3883, 3, 'Estado del Centro');
INSERT INTO `lang_definitions` VALUES (5153, 3884, 3, 'Dirección del Centro');
INSERT INTO `lang_definitions` VALUES (5154, 3886, 3, 'Código Postal del Centro');
INSERT INTO `lang_definitions` VALUES (5155, 3888, 3, 'Centro:');
INSERT INTO `lang_definitions` VALUES (5156, 3889, 3, 'Fallo');
INSERT INTO `lang_definitions` VALUES (5157, 3890, 3, 'Fallado');
INSERT INTO `lang_definitions` VALUES (5158, 3891, 3, 'fallado');
INSERT INTO `lang_definitions` VALUES (5159, 3901, 3, 'Fallo al crear la carpeta temporal. CouchDB no funcionará.');
INSERT INTO `lang_definitions` VALUES (5160, 3907, 3, 'Fallo');
INSERT INTO `lang_definitions` VALUES (5161, 3908, 3, 'error');
INSERT INTO `lang_definitions` VALUES (5162, 3916, 3, 'Historia familiar');
INSERT INTO `lang_definitions` VALUES (5163, 3918, 3, 'Historia Familiar de Glaucoma');
INSERT INTO `lang_definitions` VALUES (5164, 3919, 3, 'Historia');
INSERT INTO `lang_definitions` VALUES (5165, 3921, 3, 'Familia de pago');
INSERT INTO `lang_definitions` VALUES (5166, 3922, 3, 'Tamaño familia');
INSERT INTO `lang_definitions` VALUES (5167, 3923, 3, 'Suposición');
INSERT INTO `lang_definitions` VALUES (5168, 3925, 3, 'Iraní');
INSERT INTO `lang_definitions` VALUES (5169, 3928, 3, 'Padre');
INSERT INTO `lang_definitions` VALUES (5170, 3930, 3, 'Fatiga');
INSERT INTO `lang_definitions` VALUES (5171, 3931, 3, 'Fatigado');
INSERT INTO `lang_definitions` VALUES (5172, 3933, 3, 'Fax');
INSERT INTO `lang_definitions` VALUES (5173, 3934, 3, 'Contador fax');
INSERT INTO `lang_definitions` VALUES (5174, 3935, 3, 'Número de fax');
INSERT INTO `lang_definitions` VALUES (5175, 3937, 3, 'Fax/Escanear');
INSERT INTO `lang_definitions` VALUES (5176, 3938, 3, 'Faxes entrada');
INSERT INTO `lang_definitions` VALUES (5177, 3939, 3, 'Faxes salida');
INSERT INTO `lang_definitions` VALUES (5178, 3940, 3, 'Características');
INSERT INTO `lang_definitions` VALUES (5179, 3941, 3, 'Feb');
INSERT INTO `lang_definitions` VALUES (5180, 3942, 3, 'Febrero');
INSERT INTO `lang_definitions` VALUES (5181, 3943, 3, 'FECA');
INSERT INTO `lang_definitions` VALUES (5182, 3944, 3, 'Nº Colegiado');
INSERT INTO `lang_definitions` VALUES (5183, 3945, 3, 'Federal EIN');
INSERT INTO `lang_definitions` VALUES (5184, 3946, 3, 'Nº Identificación de impuesto federal');
INSERT INTO `lang_definitions` VALUES (5185, 3948, 3, 'Honorario');
INSERT INTO `lang_definitions` VALUES (5186, 3949, 3, 'honorario');
INSERT INTO `lang_definitions` VALUES (5187, 3950, 3, 'No se permiten honorarios');
INSERT INTO `lang_definitions` VALUES (5188, 3951, 3, 'Hoja de honorarios');
INSERT INTO `lang_definitions` VALUES (5189, 3953, 3, 'Opciones de la hoja de honorarios');
INSERT INTO `lang_definitions` VALUES (5190, 3955, 3, 'Honorarios');
INSERT INTO `lang_definitions` VALUES (5191, 3956, 3, 'Femenino');
INSERT INTO `lang_definitions` VALUES (5192, 3957, 3, 'AP Femenino');
INSERT INTO `lang_definitions` VALUES (5193, 3958, 3, 'Condones femeninos');
INSERT INTO `lang_definitions` VALUES (5194, 3959, 3, 'G Femenino');
INSERT INTO `lang_definitions` VALUES (5195, 3960, 3, 'LC Femenino');
INSERT INTO `lang_definitions` VALUES (5196, 3961, 3, 'P Femenino');
INSERT INTO `lang_definitions` VALUES (5197, 3962, 3, 'Síntomas Femeninos');
INSERT INTO `lang_definitions` VALUES (5198, 3963, 3, 'Mujeres VSC');
INSERT INTO `lang_definitions` VALUES (5199, 3966, 3, 'Fiebre');
INSERT INTO `lang_definitions` VALUES (5200, 3967, 3, 'Fiebre:');
INSERT INTO `lang_definitions` VALUES (5201, 3968, 3, 'Problemas de Sangre FH');
INSERT INTO `lang_definitions` VALUES (5202, 3972, 3, 'Fibromas');
INSERT INTO `lang_definitions` VALUES (5203, 3978, 3, 'Tipo de campo a utilizar para el país del empleador o abonado en demográficos.');
INSERT INTO `lang_definitions` VALUES (5204, 3979, 3, 'Tipo de campo a utilizar para el estado del empleador o abonado en demográficos.');
INSERT INTO `lang_definitions` VALUES (5205, 3980, 3, 'Falta Campo(s)!');
INSERT INTO `lang_definitions` VALUES (5206, 3986, 3, 'Fichero');
INSERT INTO `lang_definitions` VALUES (5207, 3989, 3, 'Fichero en el directorio de documentación para aprender como automatizar el proceso de creación de logs de backup');
INSERT INTO `lang_definitions` VALUES (5208, 3990, 3, 'Ubicacion del file');
INSERT INTO `lang_definitions` VALUES (5209, 3991, 3, 'Gestión de Fichero');
INSERT INTO `lang_definitions` VALUES (5210, 3998, 3, 'Fichero de permisos de usuario de OpenEMR');
INSERT INTO `lang_definitions` VALUES (5211, 3999, 3, 'Fallo en la recuperación de archivo de CouchDB');
INSERT INTO `lang_definitions` VALUES (5212, 4000, 3, 'Sala de archivo');
INSERT INTO `lang_definitions` VALUES (5213, 4001, 3, 'Fichero para adjuntar');
INSERT INTO `lang_definitions` VALUES (5214, 4003, 3, 'Un fichero con el mismo nombre ya existe en la ubicación:');
INSERT INTO `lang_definitions` VALUES (5215, 4004, 3, 'Nombre de fichero');
INSERT INTO `lang_definitions` VALUES (5216, 4006, 3, 'Ficheros');
INSERT INTO `lang_definitions` VALUES (5217, 4011, 3, 'Filipino');
INSERT INTO `lang_definitions` VALUES (5218, 4013, 3, 'Rellene cualquiera de las filas de abajo.');
INSERT INTO `lang_definitions` VALUES (5219, 4014, 3, 'Rellenar sólo si manda notificación a paciente por email');
INSERT INTO `lang_definitions` VALUES (5220, 4023, 3, 'Llenar los valores abajo');
INSERT INTO `lang_definitions` VALUES (5221, 4025, 3, 'Rellene la fila');
INSERT INTO `lang_definitions` VALUES (5222, 4028, 3, 'Filtro');
INSERT INTO `lang_definitions` VALUES (5223, 4029, 3, 'Filtro para los constantes');
INSERT INTO `lang_definitions` VALUES (5224, 4030, 3, 'Filtro por Definición');
INSERT INTO `lang_definitions` VALUES (5225, 4031, 3, 'Filtrado desde');
INSERT INTO `lang_definitions` VALUES (5226, 4032, 3, 'Filtros');
INSERT INTO `lang_definitions` VALUES (5227, 4033, 3, 'filtros');
INSERT INTO `lang_definitions` VALUES (5228, 4034, 3, 'Final');
INSERT INTO `lang_definitions` VALUES (5229, 4035, 3, 'Diagnóstico final');
INSERT INTO `lang_definitions` VALUES (5230, 4036, 3, 'Diagnóstico final por especialista');
INSERT INTO `lang_definitions` VALUES (5231, 4038, 3, 'Financiero');
INSERT INTO `lang_definitions` VALUES (5232, 4039, 3, 'Fecha cierre financiero (aaaa-mm-dd)');
INSERT INTO `lang_definitions` VALUES (5233, 4040, 3, 'Información financiera - cualquier cosa');
INSERT INTO `lang_definitions` VALUES (5234, 4042, 3, 'Información financiera - mis visitas');
INSERT INTO `lang_definitions` VALUES (5235, 4045, 3, 'Fecha de revisión financiero');
INSERT INTO `lang_definitions` VALUES (5236, 4046, 3, 'Resumen Financiero por Código de Servicio');
INSERT INTO `lang_definitions` VALUES (5237, 4048, 3, 'Buscar');
INSERT INTO `lang_definitions` VALUES (5238, 4049, 3, 'Buscar disponible');
INSERT INTO `lang_definitions` VALUES (5239, 4050, 3, 'Buscar citas disponibles');
INSERT INTO `lang_definitions` VALUES (5240, 4053, 3, 'Busca paciente');
INSERT INTO `lang_definitions` VALUES (5241, 4054, 3, 'Buscar materiales educativos para el paciente');
INSERT INTO `lang_definitions` VALUES (5242, 4056, 3, 'Conclusiones');
INSERT INTO `lang_definitions` VALUES (5243, 4057, 3, 'Conclusiones por especialista');
INSERT INTO `lang_definitions` VALUES (5244, 4058, 3, 'Multa');
INSERT INTO `lang_definitions` VALUES (5245, 4060, 3, 'Final Pagos');
INSERT INTO `lang_definitions` VALUES (5246, 4062, 3, 'Terminado');
INSERT INTO `lang_definitions` VALUES (5247, 4065, 3, 'Primero');
INSERT INTO `lang_definitions` VALUES (5248, 4068, 3, 'Primer día de la semana');
INSERT INTO `lang_definitions` VALUES (5249, 4071, 3, 'Nombre');
INSERT INTO `lang_definitions` VALUES (5250, 4072, 3, 'Nombre');
INSERT INTO `lang_definitions` VALUES (5251, 4073, 3, 'Nombre:');
INSERT INTO `lang_definitions` VALUES (5252, 4079, 3, 'Aptitud');
INSERT INTO `lang_definitions` VALUES (5253, 4080, 3, 'Condicion Fisica');
INSERT INTO `lang_definitions` VALUES (5254, 4081, 3, 'Condicion Fisica para este jugador hoy');
INSERT INTO `lang_definitions` VALUES (5255, 4083, 3, 'Aptitud para jugar');
INSERT INTO `lang_definitions` VALUES (5256, 4084, 3, 'Fijar fechas visita - cualquier visita');
INSERT INTO `lang_definitions` VALUES (5257, 4086, 3, 'Solucionar este');
INSERT INTO `lang_definitions` VALUES (5258, 4088, 3, 'FL');
INSERT INTO `lang_definitions` VALUES (5259, 4090, 3, 'Flatulencia');
INSERT INTO `lang_definitions` VALUES (5260, 4091, 3, 'Flujo');
INSERT INTO `lang_definitions` VALUES (5261, 4108, 3, 'Temporada de gripe');
INSERT INTO `lang_definitions` VALUES (5262, 4109, 3, 'Temporada de Gripe');
INSERT INTO `lang_definitions` VALUES (5263, 4110, 3, 'Vacunación gripe');
INSERT INTO `lang_definitions` VALUES (5264, 4111, 3, 'Problema de fluído y electrolito');
INSERT INTO `lang_definitions` VALUES (5265, 4112, 3, 'FMS');
INSERT INTO `lang_definitions` VALUES (5266, 4113, 3, 'Tamaño papel folio');
INSERT INTO `lang_definitions` VALUES (5267, 4114, 3, 'Seguir manualmente');
INSERT INTO `lang_definitions` VALUES (5268, 4115, 3, 'Siga estas instrucciones para instalar o actualizar la siguiente bbdd');
INSERT INTO `lang_definitions` VALUES (5269, 4116, 3, 'Seguimineto');
INSERT INTO `lang_definitions` VALUES (5270, 4119, 3, 'Motivo de seguimiento');
INSERT INTO `lang_definitions` VALUES (5271, 4121, 3, 'A continuación una nueva constante de cliente:');
INSERT INTO `lang_definitions` VALUES (5272, 4122, 3, 'A continuación un nuevo idioma de cliente:');
INSERT INTO `lang_definitions` VALUES (5273, 4123, 3, 'A continuación una nueva definición (Idioma, Constante, Definición):');
INSERT INTO `lang_definitions` VALUES (5274, 4125, 3, 'Servicios de seguimiento');
INSERT INTO `lang_definitions` VALUES (5275, 4126, 3, 'Seguimiento indicado');
INSERT INTO `lang_definitions` VALUES (5276, 4129, 3, 'Intolerancia del Alimento');
INSERT INTO `lang_definitions` VALUES (5277, 4130, 3, 'Pie');
INSERT INTO `lang_definitions` VALUES (5278, 4131, 3, 'Problemas en los píes');
INSERT INTO `lang_definitions` VALUES (5279, 4132, 3, 'Píe:');
INSERT INTO `lang_definitions` VALUES (5280, 4133, 3, 'Lesiones de fútbol');
INSERT INTO `lang_definitions` VALUES (5281, 4135, 3, 'Informe de lesión futbolística');
INSERT INTO `lang_definitions` VALUES (5282, 4136, 3, 'Tipo de calzado');
INSERT INTO `lang_definitions` VALUES (5283, 4137, 3, 'para');
INSERT INTO `lang_definitions` VALUES (5284, 4138, 3, 'Para');
INSERT INTO `lang_definitions` VALUES (5285, 4144, 3, 'Por Código');
INSERT INTO `lang_definitions` VALUES (5286, 4152, 3, 'Para reclamaciones de visita');
INSERT INTO `lang_definitions` VALUES (5287, 4154, 3, 'Por Ejemplo');
INSERT INTO `lang_definitions` VALUES (5288, 4161, 3, 'Por Factura');
INSERT INTO `lang_definitions` VALUES (5289, 4163, 3, 'Para Seguro médico sólo, obliga al facultativo de referencia a ser el mismo que el facultativo del representado.');
INSERT INTO `lang_definitions` VALUES (5290, 4173, 3, 'Para el profesional/Organizacion referida');
INSERT INTO `lang_definitions` VALUES (5291, 4176, 3, 'Por el pasado');
INSERT INTO `lang_definitions` VALUES (5292, 4188, 3, 'por variable');
INSERT INTO `lang_definitions` VALUES (5293, 4189, 3, 'para:');
INSERT INTO `lang_definitions` VALUES (5294, 4190, 3, 'Fuerza la apertura del widget de facturación');
INSERT INTO `lang_definitions` VALUES (5295, 4191, 3, 'Forzar Crear Nuevo Paciente');
INSERT INTO `lang_definitions` VALUES (5296, 4194, 3, 'Antebrazo');
INSERT INTO `lang_definitions` VALUES (5297, 4195, 3, 'Formulario');
INSERT INTO `lang_definitions` VALUES (5298, 4196, 3, 'formulario');
INSERT INTO `lang_definitions` VALUES (5299, 4201, 3, 'Formato');
INSERT INTO `lang_definitions` VALUES (5300, 4202, 3, 'formato');
INSERT INTO `lang_definitions` VALUES (5301, 4204, 3, 'Formato incorrecto para el NDC');
INSERT INTO `lang_definitions` VALUES (5302, 4205, 3, 'Formato usado para la mayoría de fechas');
INSERT INTO `lang_definitions` VALUES (5303, 4206, 3, 'Formato usado para mostrar la mayoría de horas.');
INSERT INTO `lang_definitions` VALUES (5304, 4207, 3, 'Informe Formateado');
INSERT INTO `lang_definitions` VALUES (5305, 4208, 3, 'Ex-fumador');
INSERT INTO `lang_definitions` VALUES (5306, 4209, 3, 'Formularios');
INSERT INTO `lang_definitions` VALUES (5307, 4210, 3, 'Formas de administración');
INSERT INTO `lang_definitions` VALUES (5308, 4215, 3, 'Re-enviar');
INSERT INTO `lang_definitions` VALUES (5309, 4219, 3, 'Reenviar Páginas vía fax');
INSERT INTO `lang_definitions` VALUES (5310, 4222, 3, 'Remitido');
INSERT INTO `lang_definitions` VALUES (5311, 4225, 3, 'Cuarto');
INSERT INTO `lang_definitions` VALUES (5312, 4227, 3, 'Fractura');
INSERT INTO `lang_definitions` VALUES (5313, 4228, 3, 'Fractura de escafoides');
INSERT INTO `lang_definitions` VALUES (5314, 4229, 3, 'Fractura del maléolo lat.');
INSERT INTO `lang_definitions` VALUES (5315, 4230, 3, 'Fractura del maléolo tibial.');
INSERT INTO `lang_definitions` VALUES (5316, 4231, 3, 'Fractura de base quinta (5 ª) metatarsianas');
INSERT INTO `lang_definitions` VALUES (5317, 4232, 3, 'Marco');
INSERT INTO `lang_definitions` VALUES (5318, 4233, 3, 'Soporte para Marcos requeridos');
INSERT INTO `lang_definitions` VALUES (5319, 4235, 3, 'Francés');
INSERT INTO `lang_definitions` VALUES (5320, 4236, 3, 'Francés (Canadiense)');
INSERT INTO `lang_definitions` VALUES (5321, 4237, 3, 'Francés (Standard)');
INSERT INTO `lang_definitions` VALUES (5322, 4238, 3, 'Frecuencia');
INSERT INTO `lang_definitions` VALUES (5323, 4239, 3, 'Resfriados Frecuentes');
INSERT INTO `lang_definitions` VALUES (5324, 4240, 3, 'Enfermedades Frecuentes');
INSERT INTO `lang_definitions` VALUES (5325, 4241, 3, 'Viernes');
INSERT INTO `lang_definitions` VALUES (5326, 4242, 3, 'Viernes');
INSERT INTO `lang_definitions` VALUES (5327, 4244, 3, 'Desde');
INSERT INTO `lang_definitions` VALUES (5328, 4245, 3, 'DESDE');
INSERT INTO `lang_definitions` VALUES (5329, 4246, 3, 'desde');
INSERT INTO `lang_definitions` VALUES (5330, 4247, 3, 'Fecha desde no puede ser mayor que fecha hasta');
INSERT INTO `lang_definitions` VALUES (5331, 4253, 3, 'Desde:');
INSERT INTO `lang_definitions` VALUES (5332, 4254, 3, 'Desde:');
INSERT INTO `lang_definitions` VALUES (5333, 4255, 3, 'FROM_CITY');
INSERT INTO `lang_definitions` VALUES (5334, 4257, 3, 'FROM_FNAME');
INSERT INTO `lang_definitions` VALUES (5335, 4258, 3, 'FROM_LNAME');
INSERT INTO `lang_definitions` VALUES (5336, 4259, 3, 'FROM_MNAME');
INSERT INTO `lang_definitions` VALUES (5337, 4261, 3, 'FROM_PHONECELL');
INSERT INTO `lang_definitions` VALUES (5338, 4262, 3, 'FROM_POSTAL');
INSERT INTO `lang_definitions` VALUES (5339, 4263, 3, 'FROM_STATE');
INSERT INTO `lang_definitions` VALUES (5340, 4264, 3, 'FROM_STREET');
INSERT INTO `lang_definitions` VALUES (5341, 4265, 3, 'FROM_TITLE');
INSERT INTO `lang_definitions` VALUES (5342, 4266, 3, 'FROM_VALEDICTORY');
INSERT INTO `lang_definitions` VALUES (5343, 4267, 3, 'Oficina central');
INSERT INTO `lang_definitions` VALUES (5344, 4268, 3, 'Recibos de la Oficina Central');
INSERT INTO `lang_definitions` VALUES (5345, 4269, 3, 'Reportes de Recibos de la Oficina Central');
INSERT INTO `lang_definitions` VALUES (5346, 4270, 3, 'Rec. Oficina Central');
INSERT INTO `lang_definitions` VALUES (5347, 4271, 3, 'La derecha frontal:');
INSERT INTO `lang_definitions` VALUES (5348, 4278, 3, 'Nombre Completo');
INSERT INTO `lang_definitions` VALUES (5349, 4280, 3, 'Ruta completa del directorio que contiene los ejecutables MySQL.');
INSERT INTO `lang_definitions` VALUES (5350, 4281, 3, 'Ruta completa del directorio que contiene los ejecutables Perl.');
INSERT INTO `lang_definitions` VALUES (5351, 4282, 3, 'Ruta completa del directorio para log de eventos de backup');
INSERT INTO `lang_definitions` VALUES (5352, 4283, 3, 'Ruta completa del directorio usado para ficheros temporales');
INSERT INTO `lang_definitions` VALUES (5353, 4284, 3, 'Juego completo');
INSERT INTO `lang_definitions` VALUES (5354, 4286, 3, 'Entrenamiento completo');
INSERT INTO `lang_definitions` VALUES (5355, 4288, 3, 'Pagado Total');
INSERT INTO `lang_definitions` VALUES (5356, 4298, 3, 'G');
INSERT INTO `lang_definitions` VALUES (5357, 4299, 3, 'G/DL');
INSERT INTO `lang_definitions` VALUES (5358, 4302, 3, 'Afección de la vesícula biliar');
INSERT INTO `lang_definitions` VALUES (5359, 4303, 3, 'Piedras en la vesícula');
INSERT INTO `lang_definitions` VALUES (5360, 4304, 3, 'Periodo de Juego');
INSERT INTO `lang_definitions` VALUES (5361, 4305, 3, 'Juegos');
INSERT INTO `lang_definitions` VALUES (5362, 4306, 3, 'Juegos faltados');
INSERT INTO `lang_definitions` VALUES (5363, 4307, 3, 'juegos/eventos');
INSERT INTO `lang_definitions` VALUES (5364, 4308, 3, 'Juegos/Eventos perdidos');
INSERT INTO `lang_definitions` VALUES (5365, 4310, 3, 'Gastritis');
INSERT INTO `lang_definitions` VALUES (5366, 4311, 3, 'Dolor Gastrointestinal');
INSERT INTO `lang_definitions` VALUES (5367, 4312, 3, 'Gastrointestinal');
INSERT INTO `lang_definitions` VALUES (5368, 4316, 3, 'Informe de estadísticas del GCAC');
INSERT INTO `lang_definitions` VALUES (5369, 4317, 3, 'Estadísticas GCAC');
INSERT INTO `lang_definitions` VALUES (5370, 4318, 3, 'Falta la forma de la visita del GCAC');
INSERT INTO `lang_definitions` VALUES (5371, 4319, 3, 'Género');
INSERT INTO `lang_definitions` VALUES (5372, 4320, 3, 'Género');
INSERT INTO `lang_definitions` VALUES (5373, 4321, 3, 'General');
INSERT INTO `lang_definitions` VALUES (5374, 4325, 3, 'Categoría de servicio general');
INSERT INTO `lang_definitions` VALUES (5375, 4332, 3, 'Generar y Descargar');
INSERT INTO `lang_definitions` VALUES (5376, 4334, 3, 'Generar y descargar HCFA 1500 reclamaciones en papel');
INSERT INTO `lang_definitions` VALUES (5377, 4337, 3, 'Generar y descargar batch X12');
INSERT INTO `lang_definitions` VALUES (5378, 4338, 3, 'Generar y descargar batch X12 de reclamación por visita');
INSERT INTO `lang_definitions` VALUES (5379, 4341, 3, 'Generar y transmitir electrónicamente las recetas autorizadas.');
INSERT INTO `lang_definitions` VALUES (5380, 4342, 3, 'Generar formulario CMS 1500');
INSERT INTO `lang_definitions` VALUES (5381, 4343, 3, 'Generar formulario CMS 1500 PDF');
INSERT INTO `lang_definitions` VALUES (5382, 4344, 3, 'Generar formulario CMS 1500 TEXTO');
INSERT INTO `lang_definitions` VALUES (5383, 4345, 3, 'Genere HCFA');
INSERT INTO `lang_definitions` VALUES (5384, 4347, 3, 'Generar factura');
INSERT INTO `lang_definitions` VALUES (5385, 4348, 3, 'Genere la Carta');
INSERT INTO `lang_definitions` VALUES (5386, 4349, 3, 'Generar carta relacionada');
INSERT INTO `lang_definitions` VALUES (5387, 4351, 3, 'Generar informe PQRI (Método A)');
INSERT INTO `lang_definitions` VALUES (5388, 4353, 3, 'Generar informe PQRI (Método E)');
INSERT INTO `lang_definitions` VALUES (5389, 4357, 3, 'Generar informe');
INSERT INTO `lang_definitions` VALUES (5390, 4365, 3, 'Generar usuario y contraseña para');
INSERT INTO `lang_definitions` VALUES (5391, 4366, 3, 'Generar X12');
INSERT INTO `lang_definitions` VALUES (5392, 4368, 3, 'Generar visita X12');
INSERT INTO `lang_definitions` VALUES (5393, 4370, 3, 'Generado en');
INSERT INTO `lang_definitions` VALUES (5394, 4372, 3, 'genera');
INSERT INTO `lang_definitions` VALUES (5395, 4377, 3, 'Genitourinario');
INSERT INTO `lang_definitions` VALUES (5396, 4381, 3, 'Alemán');
INSERT INTO `lang_definitions` VALUES (5397, 4386, 3, 'Obtener HL7');
INSERT INTO `lang_definitions` VALUES (5398, 4392, 3, 'Glaucoma');
INSERT INTO `lang_definitions` VALUES (5399, 4393, 3, 'Historia Familiar de Glaucoma');
INSERT INTO `lang_definitions` VALUES (5400, 4395, 3, 'Global');
INSERT INTO `lang_definitions` VALUES (5401, 4398, 3, 'ID Global');
INSERT INTO `lang_definitions` VALUES (5402, 4399, 3, 'Ajustes Globales');
INSERT INTO `lang_definitions` VALUES (5403, 4400, 3, 'Globales');
INSERT INTO `lang_definitions` VALUES (5404, 4401, 3, 'GM/DL');
INSERT INTO `lang_definitions` VALUES (5405, 4403, 3, 'Ir');
INSERT INTO `lang_definitions` VALUES (5406, 4404, 3, 'ir');
INSERT INTO `lang_definitions` VALUES (5407, 4407, 3, 'Ir a');
INSERT INTO `lang_definitions` VALUES (5408, 4417, 3, 'Ir a la semana del');
INSERT INTO `lang_definitions` VALUES (5409, 4418, 3, 'Ir hoy');
INSERT INTO `lang_definitions` VALUES (5410, 4428, 3, 'Grado de la lesión');
INSERT INTO `lang_definitions` VALUES (5411, 4429, 3, 'Grado:');
INSERT INTO `lang_definitions` VALUES (5412, 4430, 3, 'Gramos');
INSERT INTO `lang_definitions` VALUES (5413, 4431, 3, 'Suma total');
INSERT INTO `lang_definitions` VALUES (5414, 4432, 3, 'Sumas totales');
INSERT INTO `lang_definitions` VALUES (5415, 4435, 3, 'Posibilidad de gráfico');
INSERT INTO `lang_definitions` VALUES (5416, 4437, 3, 'Mayor que');
INSERT INTO `lang_definitions` VALUES (5417, 4438, 3, 'Mayor que o Igual a');
INSERT INTO `lang_definitions` VALUES (5418, 4439, 3, 'Griego');
INSERT INTO `lang_definitions` VALUES (5419, 4442, 3, 'Grupo');
INSERT INTO `lang_definitions` VALUES (5420, 4459, 3, 'Nombre de Grupo');
INSERT INTO `lang_definitions` VALUES (5421, 4460, 3, 'Los nombres de los grupos no pueden quedar en blanco');
INSERT INTO `lang_definitions` VALUES (5422, 4461, 3, 'Los nombres de los grupos no pueden iniciar con números');
INSERT INTO `lang_definitions` VALUES (5423, 4462, 3, 'Los nombres de grupo no pueden comenzar con números.');
INSERT INTO `lang_definitions` VALUES (5424, 4463, 3, 'Número de grupo');
INSERT INTO `lang_definitions` VALUES (5425, 4465, 3, 'Grupo de pago');
INSERT INTO `lang_definitions` VALUES (5426, 4471, 3, 'Grupo:');
INSERT INTO `lang_definitions` VALUES (5427, 4472, 3, 'Nombre del grupo');
INSERT INTO `lang_definitions` VALUES (5428, 4475, 3, 'Controles de grupos y accesos');
INSERT INTO `lang_definitions` VALUES (5429, 4476, 3, 'Gráfico de Crecimiento');
INSERT INTO `lang_definitions` VALUES (5430, 4477, 3, 'Gráfico de Crecimiento');
INSERT INTO `lang_definitions` VALUES (5431, 4478, 3, 'gtts (gotas)');
INSERT INTO `lang_definitions` VALUES (5432, 4479, 3, 'Guamés');
INSERT INTO `lang_definitions` VALUES (5433, 4484, 3, 'Nombre del tutor');
INSERT INTO `lang_definitions` VALUES (5434, 4489, 3, 'Examen ginecológico');
INSERT INTO `lang_definitions` VALUES (5435, 4490, 3, 'h');
INSERT INTO `lang_definitions` VALUES (5436, 4492, 3, 'h.s.');
INSERT INTO `lang_definitions` VALUES (5437, 4493, 3, 'H/O Hepatitis');
INSERT INTO `lang_definitions` VALUES (5438, 4494, 3, 'se ha suprimido con éxito. Cualquier sub-categorías si fueron trasladados abajo');
INSERT INTO `lang_definitions` VALUES (5439, 4495, 3, 'Hematoma/moratón');
INSERT INTO `lang_definitions` VALUES (5440, 4496, 3, 'HAI Estado');
INSERT INTO `lang_definitions` VALUES (5441, 4499, 3, 'manos + dedos');
INSERT INTO `lang_definitions` VALUES (5442, 4500, 3, 'Problemas de manos');
INSERT INTO `lang_definitions` VALUES (5443, 4505, 3, 'Disco Duro');
INSERT INTO `lang_definitions` VALUES (5444, 4506, 3, 'Dificultad sin');
INSERT INTO `lang_definitions` VALUES (5445, 4507, 3, 'se ha ligado para visitar');
INSERT INTO `lang_definitions` VALUES (5446, 4508, 3, 'ha expirado');
INSERT INTO `lang_definitions` VALUES (5447, 4509, 3, 'Función Hash');
INSERT INTO `lang_definitions` VALUES (5448, 4511, 3, 'No existe hash para este fichero. Un nuevo hash será generado.');
INSERT INTO `lang_definitions` VALUES (5449, 4512, 3, 'Hash no coincide. La integridad de datos se ha visto comprometida.');
INSERT INTO `lang_definitions` VALUES (5450, 4515, 3, 'Hawaiano');
INSERT INTO `lang_definitions` VALUES (5451, 4516, 3, 'Actividades peligrosas');
INSERT INTO `lang_definitions` VALUES (5452, 4517, 3, 'Actividades peligrosas');
INSERT INTO `lang_definitions` VALUES (5453, 4521, 3, 'Margen izquierdo de HCFA en puntos');
INSERT INTO `lang_definitions` VALUES (5454, 4522, 3, 'Márgenes de HCFA');
INSERT INTO `lang_definitions` VALUES (5455, 4523, 3, 'Margen superior en puntos de HCFA');
INSERT INTO `lang_definitions` VALUES (5456, 4524, 3, 'Procedimiento/Servicio HCPCS');
INSERT INTO `lang_definitions` VALUES (5457, 4527, 3, 'PostCalendar');
INSERT INTO `lang_definitions` VALUES (5458, 4528, 3, 'Cabeza');
INSERT INTO `lang_definitions` VALUES (5459, 4529, 3, 'Jefe Circ');
INSERT INTO `lang_definitions` VALUES (5460, 4530, 3, 'Circunferencia de la cabeza');
INSERT INTO `lang_definitions` VALUES (5461, 4531, 3, 'Dolor de cabeza');
INSERT INTO `lang_definitions` VALUES (5462, 4532, 3, 'Dolores de cabeza');
INSERT INTO `lang_definitions` VALUES (5463, 4534, 3, 'Operaciones de atención médica');
INSERT INTO `lang_definitions` VALUES (5464, 4535, 3, 'Operaciones de Atención Médica');
INSERT INTO `lang_definitions` VALUES (5465, 4537, 3, 'Centro de salud/clínica');
INSERT INTO `lang_definitions` VALUES (5466, 4540, 3, 'Organización para el mantenimiento de la salud');
INSERT INTO `lang_definitions` VALUES (5467, 4541, 3, 'Riesgo de Seguro médico de la organización de mantenimiento de salud (HMO)');
INSERT INTO `lang_definitions` VALUES (5468, 4542, 3, 'Pérdida de Oído');
INSERT INTO `lang_definitions` VALUES (5469, 4543, 3, 'Ataque al Corazón');
INSERT INTO `lang_definitions` VALUES (5470, 4544, 3, 'Enfermedad del corazón');
INSERT INTO `lang_definitions` VALUES (5471, 4545, 3, 'Fallo cardiaco');
INSERT INTO `lang_definitions` VALUES (5472, 4546, 3, 'Problema del Corazón');
INSERT INTO `lang_definitions` VALUES (5473, 4547, 3, 'Problemas de corazón');
INSERT INTO `lang_definitions` VALUES (5474, 4548, 3, 'Cirugía del Corazón');
INSERT INTO `lang_definitions` VALUES (5475, 4549, 3, 'Transplante de corazón');
INSERT INTO `lang_definitions` VALUES (5476, 4550, 3, 'CORAZÓN:');
INSERT INTO `lang_definitions` VALUES (5477, 4551, 3, 'Ardor de estómago');
INSERT INTO `lang_definitions` VALUES (5478, 4552, 3, 'Calor o Frío');
INSERT INTO `lang_definitions` VALUES (5479, 4553, 3, 'Calor o Frío');
INSERT INTO `lang_definitions` VALUES (5480, 4555, 3, 'Hebreo');
INSERT INTO `lang_definitions` VALUES (5481, 4557, 3, 'HEENT');
INSERT INTO `lang_definitions` VALUES (5482, 4558, 3, 'Altura');
INSERT INTO `lang_definitions` VALUES (5483, 4560, 3, 'Ayuda');
INSERT INTO `lang_definitions` VALUES (5484, 4561, 3, 'ayuda');
INSERT INTO `lang_definitions` VALUES (5485, 4563, 3, 'Hematemesis');
INSERT INTO `lang_definitions` VALUES (5486, 4564, 3, 'Hematoquecia');
INSERT INTO `lang_definitions` VALUES (5487, 4565, 3, 'Hematológico');
INSERT INTO `lang_definitions` VALUES (5488, 4566, 3, 'Hematuria');
INSERT INTO `lang_definitions` VALUES (5489, 4567, 3, 'Hemoglobina');
INSERT INTO `lang_definitions` VALUES (5490, 4568, 3, 'Hemoglobina A1C');
INSERT INTO `lang_definitions` VALUES (5491, 4569, 3, 'Hemoptisis');
INSERT INTO `lang_definitions` VALUES (5492, 4570, 3, 'Hepatitis');
INSERT INTO `lang_definitions` VALUES (5493, 4571, 3, 'Hepatitis A 1');
INSERT INTO `lang_definitions` VALUES (5494, 4572, 3, 'Hepatitis A 2');
INSERT INTO `lang_definitions` VALUES (5495, 4573, 3, 'Hepatitis B 1');
INSERT INTO `lang_definitions` VALUES (5496, 4574, 3, 'Hepatitis B 2');
INSERT INTO `lang_definitions` VALUES (5497, 4575, 3, 'Hepatitis B 3');
INSERT INTO `lang_definitions` VALUES (5498, 4576, 3, 'aqui');
INSERT INTO `lang_definitions` VALUES (5499, 4580, 3, 'Reparación de la hernia');
INSERT